/// <reference types="node" />
/**
 * Create a virtual file from a description.
 * If `options` is a string or a buffer, it’s used as the path.
 * If it’s a VFile itself, it’s returned instead.
 * In all other cases, the options are passed through to `vfile()`.
 *
 * @param {Compatible} [options]
 * @returns {VFile}
 */
export function toVFile(options?: Compatible): VFile
export namespace toVFile {
  export {readSync}
  export {writeSync}
  export {read}
  export {write}
}
/**
 * Create a virtual file and read it in, synchronously.
 *
 * @param {Compatible} description
 * @param {ReadOptions} [options]
 * @returns {VFile}
 */
export function readSync(description: Compatible, options?: ReadOptions): VFile
/**
 * Create a virtual file and write it in, synchronously.
 *
 * @param {Compatible} description
 * @param {WriteOptions} [options]
 * @returns {VFile}
 */
export function writeSync(
  description: Compatible,
  options?: WriteOptions
): VFile
export function read(
  description: Compatible,
  options: ReadOptions,
  callback: Callback
): void
export function read(description: Compatible, callback: Callback): void
export function read(
  description: Compatible,
  options?: ReadOptions
): Promise<VFile>
export function write(
  description: Compatible,
  options: WriteOptions,
  callback: Callback
): void
export function write(description: Compatible, callback: Callback): void
export function write(
  description: Compatible,
  options?: WriteOptions
): Promise<VFile>
export type Value = import('vfile').VFileValue
export type Options = import('vfile').VFileOptions
export type BufferEncoding = import('vfile').BufferEncoding
export type Mode = number | string
export type ReadOptions =
  | BufferEncoding
  | {
      encoding?: null | BufferEncoding
      flag?: string
    }
export type WriteOptions =
  | BufferEncoding
  | {
      encoding?: null | BufferEncoding
      mode: Mode | null
      flag?: string
    }
/**
 * Path of the file.
 * Note: `Value` is used here because it’s a smarter `Buffer`
 */
export type Path = URL | Value
/**
 * Things that can be
 * passed to the function.
 */
export type Compatible = Path | Options | VFile
export type Callback = (
  error: NodeJS.ErrnoException | null,
  file: VFile | null
) => any
import {VFile} from 'vfile'
import {URL} from 'url'
