# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessProtocol."""

    SMB = "SMB"
    """Server Message Block protocol(SMB)."""
    NFS = "NFS"
    """Network File System protocol(NFS)."""


class AddressType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of address."""

    NONE = "None"
    """Address type not known."""
    RESIDENTIAL = "Residential"
    """Residential Address."""
    COMMERCIAL = "Commercial"
    """Commercial Address."""


class AddressValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The address validation status."""

    VALID = "Valid"
    """Address provided is valid."""
    INVALID = "Invalid"
    """Address provided is invalid or not supported."""
    AMBIGUOUS = "Ambiguous"
    """Address provided is ambiguous, please choose one of the alternate addresses returned."""


class ClassDiscriminator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the type of job details."""

    DATA_BOX = "DataBox"
    """Databox orders."""
    DATA_BOX_DISK = "DataBoxDisk"
    """DataboxDisk orders."""
    DATA_BOX_HEAVY = "DataBoxHeavy"
    """DataboxHeavy orders."""


class CopyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Status of the copy."""

    NOT_STARTED = "NotStarted"
    """Data copy hasn't started yet."""
    IN_PROGRESS = "InProgress"
    """Data copy is in progress."""
    COMPLETED = "Completed"
    """Data copy completed."""
    COMPLETED_WITH_ERRORS = "CompletedWithErrors"
    """Data copy completed with errors."""
    FAILED = "Failed"
    """Data copy failed. No data was copied."""
    NOT_RETURNED = "NotReturned"
    """No copy triggered as device was not returned."""
    HARDWARE_ERROR = "HardwareError"
    """The Device has hit hardware issues."""
    DEVICE_FORMATTED = "DeviceFormatted"
    """Data copy failed. The Device was formatted by user."""
    DEVICE_METADATA_MODIFIED = "DeviceMetadataModified"
    """Data copy failed. Device metadata was modified by user."""
    STORAGE_ACCOUNT_NOT_ACCESSIBLE = "StorageAccountNotAccessible"
    """Data copy failed. Storage Account was not accessible during copy."""
    UNSUPPORTED_DATA = "UnsupportedData"
    """Data copy failed. The Device data content is not supported."""


class DataDestinationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data Destination Type."""

    STORAGE_ACCOUNT = "StorageAccount"
    """Storage Accounts ."""
    MANAGED_DISK = "ManagedDisk"
    """Azure Managed disk storage."""


class JobDeliveryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Delivery type of Job."""

    NON_SCHEDULED = "NonScheduled"
    """Non Scheduled job."""
    SCHEDULED = "Scheduled"
    """Scheduled job."""


class NotificationStageName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the stage."""

    DEVICE_PREPARED = "DevicePrepared"
    """Notification at device prepared stage."""
    DISPATCHED = "Dispatched"
    """Notification at device dispatched stage."""
    DELIVERED = "Delivered"
    """Notification at device delivered stage."""
    PICKED_UP = "PickedUp"
    """Notification at device picked up from user stage."""
    AT_AZURE_DC = "AtAzureDC"
    """Notification at device received at azure datacenter stage."""
    DATA_COPY = "DataCopy"
    """Notification at data copy started stage."""


class OverallValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Overall validation status."""

    ALL_VALID_TO_PROCEED = "AllValidToProceed"
    """Every input request is valid."""
    INPUTS_REVISIT_REQUIRED = "InputsRevisitRequired"
    """Some input requests are not valid."""
    CERTAIN_INPUT_VALIDATIONS_SKIPPED = "CertainInputValidationsSkipped"
    """Certain input validations skipped."""


class ShareDestinationFormatType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the share."""

    UNKNOWN_TYPE = "UnknownType"
    """Unknown format."""
    HCS = "HCS"
    """Storsimple data format."""
    BLOCK_BLOB = "BlockBlob"
    """Azure storage block blob format."""
    PAGE_BLOB = "PageBlob"
    """Azure storage page blob format."""
    AZURE_FILE = "AzureFile"
    """Azure storage file format."""
    MANAGED_DISK = "ManagedDisk"
    """Azure Compute Disk."""


class SkuDisabledReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason why the Sku is disabled."""

    NONE = "None"
    """SKU is not disabled."""
    COUNTRY = "Country"
    """SKU is not available in the requested country."""
    REGION = "Region"
    """SKU is not available to push data to the requested Azure region."""
    FEATURE = "Feature"
    """Required features are not enabled for the SKU."""
    OFFER_TYPE = "OfferType"
    """Subscription does not have required offer types for the SKU."""
    NO_SUBSCRIPTION_INFO = "NoSubscriptionInfo"
    """Subscription has not registered to Microsoft.DataBox and Service does not have the subscription
    #: notification."""


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SkuName."""

    DATA_BOX = "DataBox"
    """Databox."""
    DATA_BOX_DISK = "DataBoxDisk"
    """DataboxDisk."""
    DATA_BOX_HEAVY = "DataBoxHeavy"
    """DataboxHeavy."""


class StageName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the stage which is in progress."""

    DEVICE_ORDERED = "DeviceOrdered"
    """An order has been created."""
    DEVICE_PREPARED = "DevicePrepared"
    """A device has been prepared for the order."""
    DISPATCHED = "Dispatched"
    """Device has been dispatched to the user of the order."""
    DELIVERED = "Delivered"
    """Device has been delivered to the user of the order."""
    PICKED_UP = "PickedUp"
    """Device has been picked up from user and in transit to azure datacenter."""
    AT_AZURE_DC = "AtAzureDC"
    """Device has been received at azure datacenter from the user."""
    DATA_COPY = "DataCopy"
    """Data copy from the device at azure datacenter."""
    COMPLETED = "Completed"
    """Order has completed."""
    COMPLETED_WITH_ERRORS = "CompletedWithErrors"
    """Order has completed with errors."""
    CANCELLED = "Cancelled"
    """Order has been cancelled."""
    FAILED_ISSUE_REPORTED_AT_CUSTOMER = "Failed_IssueReportedAtCustomer"
    """Order has failed due to issue reported by user."""
    FAILED_ISSUE_DETECTED_AT_AZURE_DC = "Failed_IssueDetectedAtAzureDC"
    """Order has failed due to issue detected at azure datacenter."""
    ABORTED = "Aborted"
    """Order has been aborted."""
    COMPLETED_WITH_WARNINGS = "CompletedWithWarnings"
    """Order has completed with warnings."""
    READY_TO_DISPATCH_FROM_AZURE_DC = "ReadyToDispatchFromAzureDC"
    """Device is ready to be handed to customer from Azure DC."""
    READY_TO_RECEIVE_AT_AZURE_DC = "ReadyToReceiveAtAzureDC"
    """Device can be dropped off at Azure DC."""


class StageStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the job stage."""

    NONE = "None"
    """No status available yet."""
    IN_PROGRESS = "InProgress"
    """Stage is in progress."""
    SUCCEEDED = "Succeeded"
    """Stage has succeeded."""
    FAILED = "Failed"
    """Stage has failed."""
    CANCELLED = "Cancelled"
    """Stage has been cancelled."""
    CANCELLING = "Cancelling"
    """Stage is cancelling."""
    SUCCEEDED_WITH_ERRORS = "SucceededWithErrors"
    """Stage has succeeded with errors."""


class TransportShipmentTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Transport Shipment Type supported for given region."""

    CUSTOMER_MANAGED = "CustomerManaged"
    """Shipment Logistics is handled by the customer."""
    MICROSOFT_MANAGED = "MicrosoftManaged"
    """Shipment Logistics is handled by Microsoft."""


class ValidationInputDiscriminator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifies the type of validation request."""

    VALIDATE_ADDRESS = "ValidateAddress"
    """Identify request and response of address validation."""
    VALIDATE_DATA_DESTINATION_DETAILS = "ValidateDataDestinationDetails"
    """Identify request and response of data destination details validation."""
    VALIDATE_SUBSCRIPTION_IS_ALLOWED_TO_CREATE_JOB = "ValidateSubscriptionIsAllowedToCreateJob"
    """Identify request and response for validation of subscription permission to create job."""
    VALIDATE_PREFERENCES = "ValidatePreferences"
    """Identify request and response of preference validation."""
    VALIDATE_CREATE_ORDER_LIMIT = "ValidateCreateOrderLimit"
    """Identify request and response of create order limit for subscription validation."""
    VALIDATE_SKU_AVAILABILITY = "ValidateSkuAvailability"
    """Identify request and response of active job limit for sku availability."""


class ValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Create order limit validation status."""

    VALID = "Valid"
    """Validation is successful"""
    INVALID = "Invalid"
    """Validation is not successful"""
    SKIPPED = "Skipped"
    """Validation is skipped"""
