/*
 * brass - Braille and speech server
 *
 * Copyright (C) 2001 by Roger Butenuth, All rights reserved.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
 *
 * $Id: softspeech.h,v 1.5 2003/05/29 16:58:43 butenuth Exp $
 */
#ifndef SOFTSPEECH_H
#define SOFTSPEECH_H

#define MAX_NAME_LEN   30
#define MAX_DATA_LEN 1024

typedef struct cmd_block_struct {
    unsigned cmd_length;
    enum {
        C_SYNTH,
        C_FLUSH,
        C_CLEAR,
        C_INDEX_SET,
        C_SET_PARAM,
        C_SELECT_LANGUAGE,      /* coded in param_num */
        C_CONFIG_VAR,
        C_TERMINATE
    } cmd;
    int  param_num;             /* number of parameter or language */
    int  param_value;           /* value of parameter */
    char name[MAX_NAME_LEN];    /* \0-terminated variable name */
    int  len;                   /* 0..MAX_DATA_LEN-1 */
    char data[MAX_DATA_LEN];    /* string, \0-terminated variable value */
                                /* or not \0-terminated text (for C_SYNTH) */
} cmd_block_t;

void server_process(int from_master, int to_master);

#endif
