; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i8* @example(i8* dereferenceable(24) %x) {
; CHECK-LABEL: @example(
; CHECK-NEXT:    [[X2:%.*]] = bitcast i8* [[X:%.*]] to {}**
; CHECK-NEXT:    [[Y:%.*]] = load {}*, {}** [[X2]], align 8
; CHECK-NEXT:    [[Y_IS_NULL:%.*]] = icmp ne {}* [[Y]], null
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_IS_NULL]])
; CHECK-NEXT:    ret i8* [[X]]
;
  %x2 = bitcast i8* %x to {}**
  %y = load {}*, {}** %x2, align 8
  %y_is_null = icmp eq {}* %y, null

  %x0 = getelementptr inbounds i8, i8* %x, i64 0
  %res = select i1 %y_is_null, i8* null, i8* %x0

  %nonnull = icmp ne i8* %res, null
  call void @llvm.assume(i1 %nonnull)

  ret i8* %res
}

; TODO: this should be folded to `ret i8* %x` as well.
define i8* @example2(i8* %x) {
; CHECK-LABEL: @example2(
; CHECK-NEXT:    [[X2:%.*]] = bitcast i8* [[X:%.*]] to {}**
; CHECK-NEXT:    [[Y:%.*]] = load {}*, {}** [[X2]], align 8
; CHECK-NEXT:    [[Y_IS_NULL:%.*]] = icmp eq {}* [[Y]], null
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[Y_IS_NULL]], i8* null, i8* [[X]]
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp ne i8* [[RES]], null
; CHECK-NEXT:    call void @llvm.assume(i1 [[NONNULL]])
; CHECK-NEXT:    ret i8* [[RES]]
;
  %x2 = bitcast i8* %x to {}**
  %y = load {}*, {}** %x2, align 8
  %y_is_null = icmp eq {}* %y, null

  %x0 = getelementptr inbounds i8, i8* %x, i64 0
  %res = select i1 %y_is_null, i8* null, i8* %x0

  %nonnull = icmp ne i8* %res, null
  call void @llvm.assume(i1 %nonnull)

  ret i8* %res
}

declare void @llvm.assume(i1)
