# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._hybrid_compute_management_client_enums import *


class ConnectionDetail(msrest.serialization.Model):
    """ConnectionDetail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar private_ip_address: The private endpoint connection private ip address.
    :vartype private_ip_address: str
    :ivar link_identifier: The private endpoint connection link identifier.
    :vartype link_identifier: str
    :ivar group_id: The private endpoint connection group id.
    :vartype group_id: str
    :ivar member_name: The private endpoint connection member name.
    :vartype member_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'link_identifier': {'readonly': True},
        'group_id': {'readonly': True},
        'member_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'link_identifier': {'key': 'linkIdentifier', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'member_name': {'key': 'memberName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionDetail, self).__init__(**kwargs)
        self.id = None
        self.private_ip_address = None
        self.link_identifier = None
        self.group_id = None
        self.member_name = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hybridcompute.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.hybridcompute.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class PrivateLinkScopesResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PrivateLinkScopesResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class HybridComputePrivateLinkScope(PrivateLinkScopesResource):
    """An Azure Arc PrivateLinkScope definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties: Properties that define a Azure Arc PrivateLinkScope resource.
    :type properties: ~azure.mgmt.hybridcompute.models.HybridComputePrivateLinkScopeProperties
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'HybridComputePrivateLinkScopeProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["HybridComputePrivateLinkScopeProperties"] = None,
        **kwargs
    ):
        super(HybridComputePrivateLinkScope, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties
        self.system_data = None


class HybridComputePrivateLinkScopeListResult(msrest.serialization.Model):
    """Describes the list of Azure Arc PrivateLinkScope resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of Azure Arc PrivateLinkScope definitions.
    :type value: list[~azure.mgmt.hybridcompute.models.HybridComputePrivateLinkScope]
    :param next_link: The URI to get the next set of Azure Arc PrivateLinkScope definitions if too
     many PrivateLinkScopes where returned in the result set.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HybridComputePrivateLinkScope]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["HybridComputePrivateLinkScope"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(HybridComputePrivateLinkScopeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class HybridComputePrivateLinkScopeProperties(msrest.serialization.Model):
    """Properties that define a Azure Arc PrivateLinkScope resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param public_network_access: Indicates whether machines associated with the private link scope
     can also use public Azure Arc service endpoints. Possible values include: "Enabled",
     "Disabled". Default value: "Disabled".
    :type public_network_access: str or ~azure.mgmt.hybridcompute.models.PublicNetworkAccessType
    :ivar provisioning_state: Current state of this PrivateLinkScope: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
    :vartype provisioning_state: str
    :ivar private_link_scope_id: The Guid id of the private link scope.
    :vartype private_link_scope_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'private_link_scope_id': {'readonly': True},
    }

    _attribute_map = {
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_link_scope_id': {'key': 'privateLinkScopeId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "PublicNetworkAccessType"]] = "Disabled",
        **kwargs
    ):
        super(HybridComputePrivateLinkScopeProperties, self).__init__(**kwargs)
        self.public_network_access = public_network_access
        self.provisioning_state = None
        self.private_link_scope_id = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value: "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'constant': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class LocationData(msrest.serialization.Model):
    """Metadata pertaining to the geographic location of the resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A canonical name for the geographic or physical location.
    :type name: str
    :param city: The city or locality where the resource is located.
    :type city: str
    :param district: The district, state, or province where the resource is located.
    :type district: str
    :param country_or_region: The country or region where the resource is located.
    :type country_or_region: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'district': {'key': 'district', 'type': 'str'},
        'country_or_region': {'key': 'countryOrRegion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        city: Optional[str] = None,
        district: Optional[str] = None,
        country_or_region: Optional[str] = None,
        **kwargs
    ):
        super(LocationData, self).__init__(**kwargs)
        self.name = name
        self.city = city
        self.district = district
        self.country_or_region = country_or_region


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Machine(TrackedResource):
    """Describes a hybrid machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param properties: Hybrid Compute Machine properties.
    :type properties: ~azure.mgmt.hybridcompute.models.MachineProperties
    :param identity: Identity for the resource.
    :type identity: ~azure.mgmt.hybridcompute.models.Identity
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MachineProperties'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["MachineProperties"] = None,
        identity: Optional["Identity"] = None,
        **kwargs
    ):
        super(Machine, self).__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.identity = identity
        self.system_data = None


class MachineExtension(TrackedResource):
    """Describes a Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param properties: Describes Machine Extension Properties.
    :type properties: ~azure.mgmt.hybridcompute.models.MachineExtensionProperties
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MachineExtensionProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["MachineExtensionProperties"] = None,
        **kwargs
    ):
        super(MachineExtension, self).__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.system_data = None


class MachineExtensionInstanceView(msrest.serialization.Model):
    """Describes the Machine Extension Instance View.

    :param name: The machine extension name.
    :type name: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param status: Instance view status.
    :type status: ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceViewStatus
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'MachineExtensionInstanceViewStatus'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["MachineExtensionInstanceViewStatus"] = None,
        **kwargs
    ):
        super(MachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status


class MachineExtensionInstanceViewStatus(msrest.serialization.Model):
    """Instance view status.

    :param code: The status code.
    :type code: str
    :param level: The level code. Possible values include: "Info", "Warning", "Error".
    :type level: str or ~azure.mgmt.hybridcompute.models.StatusLevelTypes
    :param display_status: The short localizable label for the status.
    :type display_status: str
    :param message: The detailed status message, including for alerts and error messages.
    :type message: str
    :param time: The time of the status.
    :type time: ~datetime.datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(MachineExtensionInstanceViewStatus, self).__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class MachineExtensionProperties(msrest.serialization.Model):
    """Describes the properties of a Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param instance_view: The machine extension instance view.
    :type instance_view: ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'force_update_tag': {'key': 'forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'settings', 'type': 'object'},
        'protected_settings': {'key': 'protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'instance_view': {'key': 'instanceView', 'type': 'MachineExtensionInstanceView'},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[object] = None,
        protected_settings: Optional[object] = None,
        instance_view: Optional["MachineExtensionInstanceView"] = None,
        **kwargs
    ):
        super(MachineExtensionProperties, self).__init__(**kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view


class MachineExtensionsListResult(msrest.serialization.Model):
    """Describes the Machine Extensions List Result.

    :param value: The list of extensions.
    :type value: list[~azure.mgmt.hybridcompute.models.MachineExtension]
    :param next_link: The uri to fetch the next page of machine extensions. Call ListNext() with
     this to fetch the next page of extensions.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MachineExtension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MachineExtension"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(MachineExtensionsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceUpdate(msrest.serialization.Model):
    """The Update Resource model definition.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ResourceUpdate, self).__init__(**kwargs)
        self.tags = tags


class MachineExtensionUpdate(ResourceUpdate):
    """Describes a Machine Extension Update.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties: Describes Machine Extension Update Properties.
    :type properties: ~azure.mgmt.hybridcompute.models.MachineExtensionUpdateProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'MachineExtensionUpdateProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["MachineExtensionUpdateProperties"] = None,
        **kwargs
    ):
        super(MachineExtensionUpdate, self).__init__(tags=tags, **kwargs)
        self.properties = properties


class MachineExtensionUpdateProperties(msrest.serialization.Model):
    """Describes the properties of a Machine Extension.

    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    """

    _attribute_map = {
        'force_update_tag': {'key': 'forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'settings', 'type': 'object'},
        'protected_settings': {'key': 'protectedSettings', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[object] = None,
        protected_settings: Optional[object] = None,
        **kwargs
    ):
        super(MachineExtensionUpdateProperties, self).__init__(**kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings


class MachineListResult(msrest.serialization.Model):
    """The List hybrid machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of hybrid machines.
    :type value: list[~azure.mgmt.hybridcompute.models.Machine]
    :param next_link: The URI to fetch the next page of Machines. Call ListNext() with this URI to
     fetch the next page of hybrid machines.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Machine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Machine"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(MachineListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MachineProperties(msrest.serialization.Model):
    """Describes the properties of a hybrid machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location_data: Metadata pertaining to the geographic location of the resource.
    :type location_data: ~azure.mgmt.hybridcompute.models.LocationData
    :ivar os_profile: Specifies the operating system settings for the hybrid machine.
    :vartype os_profile: ~azure.mgmt.hybridcompute.models.OSProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar status: The status of the hybrid machine agent. Possible values include: "Connected",
     "Disconnected", "Error".
    :vartype status: str or ~azure.mgmt.hybridcompute.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: ~datetime.datetime
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :param vm_id: Specifies the hybrid machine unique ID.
    :type vm_id: str
    :ivar display_name: Specifies the hybrid machine display name.
    :vartype display_name: str
    :ivar machine_fqdn: Specifies the hybrid machine FQDN.
    :vartype machine_fqdn: str
    :param client_public_key: Public Key that the client provides to be used during initial
     resource onboarding.
    :type client_public_key: str
    :ivar os_name: The Operating System running on the hybrid machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the hybrid machine.
    :vartype os_version: str
    :ivar vm_uuid: Specifies the Arc Machine's unique SMBIOS ID.
    :vartype vm_uuid: str
    :param extensions: Machine Extensions information.
    :type extensions: list[~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView]
    :ivar os_sku: Specifies the Operating System product SKU.
    :vartype os_sku: str
    :ivar domain_name: Specifies the Windows domain name.
    :vartype domain_name: str
    :ivar ad_fqdn: Specifies the AD fully qualified display name.
    :vartype ad_fqdn: str
    :ivar dns_fqdn: Specifies the DNS fully qualified display name.
    :vartype dns_fqdn: str
    :param private_link_scope_resource_id: The resource id of the private link scope this machine
     is assigned to, if any.
    :type private_link_scope_resource_id: str
    :param parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this
     machine is assigned to, if any.
    :type parent_cluster_resource_id: str
    :ivar detected_properties: Detected properties from the machine.
    :vartype detected_properties: dict[str, str]
    """

    _validation = {
        'os_profile': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'last_status_change': {'readonly': True},
        'error_details': {'readonly': True},
        'agent_version': {'readonly': True},
        'display_name': {'readonly': True},
        'machine_fqdn': {'readonly': True},
        'os_name': {'readonly': True},
        'os_version': {'readonly': True},
        'vm_uuid': {'readonly': True},
        'os_sku': {'readonly': True},
        'domain_name': {'readonly': True},
        'ad_fqdn': {'readonly': True},
        'dns_fqdn': {'readonly': True},
        'detected_properties': {'readonly': True},
    }

    _attribute_map = {
        'location_data': {'key': 'locationData', 'type': 'LocationData'},
        'os_profile': {'key': 'osProfile', 'type': 'OSProfile'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'last_status_change': {'key': 'lastStatusChange', 'type': 'iso-8601'},
        'error_details': {'key': 'errorDetails', 'type': '[ErrorDetail]'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'machine_fqdn': {'key': 'machineFqdn', 'type': 'str'},
        'client_public_key': {'key': 'clientPublicKey', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'vm_uuid': {'key': 'vmUuid', 'type': 'str'},
        'extensions': {'key': 'extensions', 'type': '[MachineExtensionInstanceView]'},
        'os_sku': {'key': 'osSku', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'ad_fqdn': {'key': 'adFqdn', 'type': 'str'},
        'dns_fqdn': {'key': 'dnsFqdn', 'type': 'str'},
        'private_link_scope_resource_id': {'key': 'privateLinkScopeResourceId', 'type': 'str'},
        'parent_cluster_resource_id': {'key': 'parentClusterResourceId', 'type': 'str'},
        'detected_properties': {'key': 'detectedProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location_data: Optional["LocationData"] = None,
        vm_id: Optional[str] = None,
        client_public_key: Optional[str] = None,
        extensions: Optional[List["MachineExtensionInstanceView"]] = None,
        private_link_scope_resource_id: Optional[str] = None,
        parent_cluster_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(MachineProperties, self).__init__(**kwargs)
        self.location_data = location_data
        self.os_profile = None
        self.provisioning_state = None
        self.status = None
        self.last_status_change = None
        self.error_details = None
        self.agent_version = None
        self.vm_id = vm_id
        self.display_name = None
        self.machine_fqdn = None
        self.client_public_key = client_public_key
        self.os_name = None
        self.os_version = None
        self.vm_uuid = None
        self.extensions = extensions
        self.os_sku = None
        self.domain_name = None
        self.ad_fqdn = None
        self.dns_fqdn = None
        self.private_link_scope_resource_id = private_link_scope_resource_id
        self.parent_cluster_resource_id = parent_cluster_resource_id
        self.detected_properties = None


class MachineUpdate(ResourceUpdate):
    """Describes a hybrid machine Update.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: Identity for the resource.
    :type identity: ~azure.mgmt.hybridcompute.models.Identity
    :param properties: Hybrid Compute Machine properties.
    :type properties: ~azure.mgmt.hybridcompute.models.MachineUpdateProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'properties': {'key': 'properties', 'type': 'MachineUpdateProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        properties: Optional["MachineUpdateProperties"] = None,
        **kwargs
    ):
        super(MachineUpdate, self).__init__(tags=tags, **kwargs)
        self.identity = identity
        self.properties = properties


class MachineUpdateProperties(msrest.serialization.Model):
    """Describes the ARM updatable properties of a hybrid machine.

    :param location_data: Metadata pertaining to the geographic location of the resource.
    :type location_data: ~azure.mgmt.hybridcompute.models.LocationData
    :param parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this
     machine is assigned to, if any.
    :type parent_cluster_resource_id: str
    :param private_link_scope_resource_id: The resource id of the private link scope this machine
     is assigned to, if any.
    :type private_link_scope_resource_id: str
    """

    _attribute_map = {
        'location_data': {'key': 'locationData', 'type': 'LocationData'},
        'parent_cluster_resource_id': {'key': 'parentClusterResourceId', 'type': 'str'},
        'private_link_scope_resource_id': {'key': 'privateLinkScopeResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location_data: Optional["LocationData"] = None,
        parent_cluster_resource_id: Optional[str] = None,
        private_link_scope_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(MachineUpdateProperties, self).__init__(**kwargs)
        self.location_data = location_data
        self.parent_cluster_resource_id = parent_cluster_resource_id
        self.private_link_scope_resource_id = private_link_scope_resource_id


class OperationListResult(msrest.serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.hybridcompute.models.OperationValue]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None


class OperationValue(msrest.serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :param display: Display properties.
    :type display: ~azure.mgmt.hybridcompute.models.OperationValueDisplay
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationValueDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationValueDisplay"] = None,
        **kwargs
    ):
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.display = display


class OperationValueDisplay(msrest.serialization.Model):
    """Describes the properties of a Hybrid Compute Operation Value Display.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationValueDisplay, self).__init__(**kwargs)
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class OSProfile(msrest.serialization.Model):
    """Specifies the operating system settings for the hybrid machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar computer_name: Specifies the host OS name of the hybrid machine.
    :vartype computer_name: str
    """

    _validation = {
        'computer_name': {'readonly': True},
    }

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param properties: Resource properties.
    :type properties: ~azure.mgmt.hybridcompute.models.PrivateEndpointConnectionProperties
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PrivateEndpointConnectionProperties"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.properties = properties
        self.system_data = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.hybridcompute.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointConnectionProperties(msrest.serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.hybridcompute.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.hybridcompute.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointProperty(msrest.serialization.Model):
    """Private endpoint which the connection belongs to.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param properties: Resource properties.
    :type properties: ~azure.mgmt.hybridcompute.models.PrivateLinkResourceProperties
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PrivateLinkResourceProperties"] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = properties
        self.system_data = None


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.hybridcompute.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkScopeValidationDetails(msrest.serialization.Model):
    """PrivateLinkScopeValidationDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :param public_network_access: Indicates whether machines associated with the private link scope
     can also use public Azure Arc service endpoints. Possible values include: "Enabled",
     "Disabled". Default value: "Disabled".
    :type public_network_access: str or ~azure.mgmt.hybridcompute.models.PublicNetworkAccessType
    :param connection_details: List of Private Endpoint Connection details.
    :type connection_details: list[~azure.mgmt.hybridcompute.models.ConnectionDetail]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'connection_details': {'key': 'connectionDetails', 'type': '[ConnectionDetail]'},
    }

    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "PublicNetworkAccessType"]] = "Disabled",
        connection_details: Optional[List["ConnectionDetail"]] = None,
        **kwargs
    ):
        super(PrivateLinkScopeValidationDetails, self).__init__(**kwargs)
        self.id = None
        self.public_network_access = public_network_access
        self.connection_details = connection_details


class PrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """State of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
    :type status: str
    :param description: Required. The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service connection.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: str,
        description: str,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.hybridcompute.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.hybridcompute.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkScope instance.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TagsResource, self).__init__(**kwargs)
        self.tags = tags
