/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomImg;
import net.sourceforge.plantuml.creole.AtomMath;
import net.sourceforge.plantuml.creole.AtomOpenIcon;
import net.sourceforge.plantuml.creole.AtomSpace;
import net.sourceforge.plantuml.creole.AtomSprite;
import net.sourceforge.plantuml.creole.AtomText;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.CommandCreoleColorAndSizeChange;
import net.sourceforge.plantuml.creole.CommandCreoleColorChange;
import net.sourceforge.plantuml.creole.CommandCreoleExposantChange;
import net.sourceforge.plantuml.creole.CommandCreoleFontFamilyChange;
import net.sourceforge.plantuml.creole.CommandCreoleImg;
import net.sourceforge.plantuml.creole.CommandCreoleLatex;
import net.sourceforge.plantuml.creole.CommandCreoleMath;
import net.sourceforge.plantuml.creole.CommandCreoleMonospaced;
import net.sourceforge.plantuml.creole.CommandCreoleOpenIcon;
import net.sourceforge.plantuml.creole.CommandCreoleQrcode;
import net.sourceforge.plantuml.creole.CommandCreoleSizeChange;
import net.sourceforge.plantuml.creole.CommandCreoleSpace;
import net.sourceforge.plantuml.creole.CommandCreoleSprite;
import net.sourceforge.plantuml.creole.CommandCreoleStyle;
import net.sourceforge.plantuml.creole.CommandCreoleSvgAttributeChange;
import net.sourceforge.plantuml.creole.CommandCreoleUrl;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleHorizontalLine;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontPosition;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.utils.CharHidder;

public class StripeSimple
implements Stripe {
    private final Atom header;
    private final List<Atom> atoms = new ArrayList<Atom>();
    private final List<Command> commands = new ArrayList<Command>();
    private HorizontalAlignment align = HorizontalAlignment.LEFT;
    private FontConfiguration fontConfiguration;
    private final StripeStyle style;
    private final ISkinSimple skinParam;

    public void setCellAlignment(HorizontalAlignment align) {
        this.align = align;
    }

    public HorizontalAlignment getCellAlignment() {
        return this.align;
    }

    public String toString() {
        return super.toString() + " " + this.atoms.toString();
    }

    @Override
    public Atom getHeader() {
        return this.header;
    }

    public StripeSimple(FontConfiguration fontConfiguration, StripeStyle style, CreoleContext context, ISkinSimple skinParam, CreoleMode modeSimpleLine) {
        this.fontConfiguration = fontConfiguration;
        this.style = style;
        this.skinParam = skinParam;
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.PLAIN));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.PLAIN));
        if (modeSimpleLine == CreoleMode.FULL) {
            this.commands.add(CommandCreoleStyle.createCreole(FontStyle.UNDERLINE));
        }
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.UNDERLINE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.UNDERLINE));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.BACKCOLOR));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.BACKCOLOR));
        this.commands.add(CommandCreoleSizeChange.create());
        this.commands.add(CommandCreoleSizeChange.createEol());
        this.commands.add(CommandCreoleColorChange.create());
        this.commands.add(CommandCreoleColorChange.createEol());
        this.commands.add(CommandCreoleColorAndSizeChange.create());
        this.commands.add(CommandCreoleColorAndSizeChange.createEol());
        this.commands.add(CommandCreoleExposantChange.create(FontPosition.EXPOSANT));
        this.commands.add(CommandCreoleExposantChange.create(FontPosition.INDICE));
        this.commands.add(CommandCreoleImg.create());
        this.commands.add(CommandCreoleQrcode.create());
        this.commands.add(CommandCreoleOpenIcon.create(skinParam.getIHtmlColorSet()));
        double scale = (double)skinParam.getDpi() / 96.0;
        this.commands.add(CommandCreoleMath.create(scale));
        this.commands.add(CommandCreoleLatex.create(scale));
        this.commands.add(CommandCreoleSprite.create(skinParam.getIHtmlColorSet()));
        this.commands.add(CommandCreoleSpace.create());
        this.commands.add(CommandCreoleFontFamilyChange.create());
        this.commands.add(CommandCreoleFontFamilyChange.createEol());
        this.commands.add(CommandCreoleMonospaced.create(skinParam.getMonospacedFamily()));
        this.commands.add(CommandCreoleUrl.create(skinParam));
        this.commands.add(CommandCreoleSvgAttributeChange.create());
        this.header = style.getHeader(fontConfiguration, context);
        if (this.header != null) {
            this.atoms.add(this.header);
        }
    }

    @Override
    public List<Atom> getAtoms() {
        if (this.atoms.size() == 0) {
            this.atoms.add(AtomText.create(" ", this.fontConfiguration));
        }
        return Collections.unmodifiableList(this.atoms);
    }

    public FontConfiguration getActualFontConfiguration() {
        return this.fontConfiguration;
    }

    public void setActualFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    public void analyzeAndAdd(String line) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        if (line.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(line);
        }
        line = CharHidder.hide(line);
        if (this.style.getType() == StripeStyleType.HEADING) {
            this.fontConfiguration = StripeSimple.fontConfigurationForHeading(this.fontConfiguration, this.style.getOrder());
            this.modifyStripe(line);
        } else if (this.style.getType() == StripeStyleType.HORIZONTAL_LINE) {
            this.atoms.add(CreoleHorizontalLine.create(this.fontConfiguration, line, this.style.getStyle(), this.skinParam));
        } else {
            this.modifyStripe(line);
        }
    }

    private static FontConfiguration fontConfigurationForHeading(FontConfiguration fontConfiguration, int order) {
        fontConfiguration = order == 0 ? fontConfiguration.bigger(4.0).bold() : (order == 1 ? fontConfiguration.bigger(2.0).bold() : (order == 2 ? fontConfiguration.bigger(1.0).bold() : fontConfiguration.italic()));
        return fontConfiguration;
    }

    public void addImage(String src, double scale) {
        this.atoms.add(AtomImg.create(src, ImgValign.TOP, 0, scale, null));
    }

    public void addQrcode(String src, double scale) {
        this.atoms.add(AtomImg.createQrcode(src, scale));
    }

    public void addSpace(int size) {
        this.atoms.add(AtomSpace.create(size));
    }

    public void addUrl(Url url) {
        this.atoms.add(AtomText.createUrl(url, this.fontConfiguration, this.skinParam));
    }

    public void addSprite(String src, double scale, HtmlColor color) {
        Sprite sprite = this.skinParam.getSprite(src);
        if (sprite != null) {
            this.atoms.add(new AtomSprite(color, scale, this.fontConfiguration, sprite, null));
        }
    }

    public void addOpenIcon(String src, double scale, HtmlColor color) {
        OpenIcon openIcon = OpenIcon.retrieve(src);
        if (openIcon != null) {
            this.atoms.add(new AtomOpenIcon(color, scale, openIcon, this.fontConfiguration, null));
        }
    }

    public void addMath(ScientificEquationSafe math, double scale) {
        this.atoms.add(new AtomMath(math, this.fontConfiguration.getColor(), this.fontConfiguration.getExtendedColor(), scale, this.skinParam.getColorMapper()));
    }

    private void modifyStripe(String line) {
        StringBuilder pending = new StringBuilder();
        while (line.length() > 0) {
            Command cmd = this.searchCommand(line);
            if (cmd == null) {
                pending.append(line.charAt(0));
                line = line.substring(1);
                continue;
            }
            this.addPending(pending);
            line = cmd.executeAndGetRemaining(line, this);
        }
        this.addPending(pending);
    }

    private void addPending(StringBuilder pending) {
        if (pending.length() == 0) {
            return;
        }
        this.atoms.add(AtomText.create(pending.toString(), this.fontConfiguration));
        pending.setLength(0);
    }

    private Command searchCommand(String line) {
        for (Command cmd : this.commands) {
            int i = cmd.matchingSize(line);
            if (i == 0) continue;
            return cmd;
        }
        return null;
    }
}

