#include "mf_rr.h"

namespace ADNS {

	MF_RR::MF_RR()
	{
		rr_type = RR_TYPE::MF;
		madname = gcnew DOMAIN_NAME();
		rr_class = RR_CLASS::IN;
		UpdateRdata();
	}

	Void MF_RR::SetMadname(DOMAIN_NAME^ newname)
	{
		madname = gcnew DOMAIN_NAME(newname->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ MF_RR::GetMadname()
	{
		return madname->Clone();
	}

	String^ MF_RR::Print()
	{
		return madname->Print();
	}

	Void MF_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(madname->GetName()->Length);
		else
			rdata->Resize(rdata,madname->GetName()->Length);

		madname->GetName()->CopyTo(rdata,0);

		return;
	}

	Void MF_RR::ToCanonical()
	{
		madname->MakeCanonical();
		UpdateRdata();
	}

	MF_RR^ MF_RR::Clone()
	{
		MF_RR^ newrr = gcnew MF_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->madname = madname->Clone();
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ MF_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		array<Byte>^ tmparray;
		MF_RR^ mfout;
		int reallen;

		mfout = gcnew MF_RR();
		mfout->owner = gcnew DOMAIN_NAME(domainname);
		mfout->rr_class = (RR_CLASS) rr_class;
		mfout->ttl = ttl;
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		mfout->SetMadname(gcnew DOMAIN_NAME(tmparray));
		return mfout;
	}

	String^ MF_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<MF_RR^>(rec)->Print();
	}

	ResourceRecord^ MF_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<MF_RR^>(rec)->Clone();
	}

}