// Code generated by protoc-gen-go. DO NOT EDIT.
// source: channelz.proto

package grpc_channelz_v1 // import "google.golang.org/grpc/channelz/grpc_channelz_v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import any "github.com/golang/protobuf/ptypes/any"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ChannelConnectivityState_State int32

const (
	ChannelConnectivityState_UNKNOWN           ChannelConnectivityState_State = 0
	ChannelConnectivityState_IDLE              ChannelConnectivityState_State = 1
	ChannelConnectivityState_CONNECTING        ChannelConnectivityState_State = 2
	ChannelConnectivityState_READY             ChannelConnectivityState_State = 3
	ChannelConnectivityState_TRANSIENT_FAILURE ChannelConnectivityState_State = 4
	ChannelConnectivityState_SHUTDOWN          ChannelConnectivityState_State = 5
)

var ChannelConnectivityState_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "IDLE",
	2: "CONNECTING",
	3: "READY",
	4: "TRANSIENT_FAILURE",
	5: "SHUTDOWN",
}
var ChannelConnectivityState_State_value = map[string]int32{
	"UNKNOWN":           0,
	"IDLE":              1,
	"CONNECTING":        2,
	"READY":             3,
	"TRANSIENT_FAILURE": 4,
	"SHUTDOWN":          5,
}

func (x ChannelConnectivityState_State) String() string {
	return proto.EnumName(ChannelConnectivityState_State_name, int32(x))
}
func (ChannelConnectivityState_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{2, 0}
}

// Channel is a logical grouping of channels, subchannels, and sockets.
type Channel struct {
	// The identifier for this channel. This should bet set.
	Ref *ChannelRef `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	// Data specific to this channel.
	Data *ChannelData `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	// There are no ordering guarantees on the order of channel refs.
	// There may not be cycles in the ref graph.
	// A channel ref may be present in more than one channel or subchannel.
	ChannelRef []*ChannelRef `protobuf:"bytes,3,rep,name=channel_ref,json=channelRef" json:"channel_ref,omitempty"`
	// At most one of 'channel_ref+subchannel_ref' and 'socket' is set.
	// There are no ordering guarantees on the order of subchannel refs.
	// There may not be cycles in the ref graph.
	// A sub channel ref may be present in more than one channel or subchannel.
	SubchannelRef []*SubchannelRef `protobuf:"bytes,4,rep,name=subchannel_ref,json=subchannelRef" json:"subchannel_ref,omitempty"`
	// There are no ordering guarantees on the order of sockets.
	SocketRef            []*SocketRef `protobuf:"bytes,5,rep,name=socket_ref,json=socketRef" json:"socket_ref,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Channel) Reset()         { *m = Channel{} }
func (m *Channel) String() string { return proto.CompactTextString(m) }
func (*Channel) ProtoMessage()    {}
func (*Channel) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{0}
}
func (m *Channel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Channel.Unmarshal(m, b)
}
func (m *Channel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Channel.Marshal(b, m, deterministic)
}
func (dst *Channel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Channel.Merge(dst, src)
}
func (m *Channel) XXX_Size() int {
	return xxx_messageInfo_Channel.Size(m)
}
func (m *Channel) XXX_DiscardUnknown() {
	xxx_messageInfo_Channel.DiscardUnknown(m)
}

var xxx_messageInfo_Channel proto.InternalMessageInfo

func (m *Channel) GetRef() *ChannelRef {
	if m != nil {
		return m.Ref
	}
	return nil
}

func (m *Channel) GetData() *ChannelData {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Channel) GetChannelRef() []*ChannelRef {
	if m != nil {
		return m.ChannelRef
	}
	return nil
}

func (m *Channel) GetSubchannelRef() []*SubchannelRef {
	if m != nil {
		return m.SubchannelRef
	}
	return nil
}

func (m *Channel) GetSocketRef() []*SocketRef {
	if m != nil {
		return m.SocketRef
	}
	return nil
}

// Subchannel is a logical grouping of channels, subchannels, and sockets.
// A subchannel is load balanced over by it's ancestor
type Subchannel struct {
	// The identifier for this channel.
	Ref *SubchannelRef `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	// Data specific to this channel.
	Data *ChannelData `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	// There are no ordering guarantees on the order of channel refs.
	// There may not be cycles in the ref graph.
	// A channel ref may be present in more than one channel or subchannel.
	ChannelRef []*ChannelRef `protobuf:"bytes,3,rep,name=channel_ref,json=channelRef" json:"channel_ref,omitempty"`
	// At most one of 'channel_ref+subchannel_ref' and 'socket' is set.
	// There are no ordering guarantees on the order of subchannel refs.
	// There may not be cycles in the ref graph.
	// A sub channel ref may be present in more than one channel or subchannel.
	SubchannelRef []*SubchannelRef `protobuf:"bytes,4,rep,name=subchannel_ref,json=subchannelRef" json:"subchannel_ref,omitempty"`
	// There are no ordering guarantees on the order of sockets.
	SocketRef            []*SocketRef `protobuf:"bytes,5,rep,name=socket_ref,json=socketRef" json:"socket_ref,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Subchannel) Reset()         { *m = Subchannel{} }
func (m *Subchannel) String() string { return proto.CompactTextString(m) }
func (*Subchannel) ProtoMessage()    {}
func (*Subchannel) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{1}
}
func (m *Subchannel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subchannel.Unmarshal(m, b)
}
func (m *Subchannel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subchannel.Marshal(b, m, deterministic)
}
func (dst *Subchannel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subchannel.Merge(dst, src)
}
func (m *Subchannel) XXX_Size() int {
	return xxx_messageInfo_Subchannel.Size(m)
}
func (m *Subchannel) XXX_DiscardUnknown() {
	xxx_messageInfo_Subchannel.DiscardUnknown(m)
}

var xxx_messageInfo_Subchannel proto.InternalMessageInfo

func (m *Subchannel) GetRef() *SubchannelRef {
	if m != nil {
		return m.Ref
	}
	return nil
}

func (m *Subchannel) GetData() *ChannelData {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Subchannel) GetChannelRef() []*ChannelRef {
	if m != nil {
		return m.ChannelRef
	}
	return nil
}

func (m *Subchannel) GetSubchannelRef() []*SubchannelRef {
	if m != nil {
		return m.SubchannelRef
	}
	return nil
}

func (m *Subchannel) GetSocketRef() []*SocketRef {
	if m != nil {
		return m.SocketRef
	}
	return nil
}

// These come from the specified states in this document:
// https://github.com/grpc/grpc/blob/master/doc/connectivity-semantics-and-api.md
type ChannelConnectivityState struct {
	State                ChannelConnectivityState_State `protobuf:"varint,1,opt,name=state,enum=grpc.channelz.v1.ChannelConnectivityState_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ChannelConnectivityState) Reset()         { *m = ChannelConnectivityState{} }
func (m *ChannelConnectivityState) String() string { return proto.CompactTextString(m) }
func (*ChannelConnectivityState) ProtoMessage()    {}
func (*ChannelConnectivityState) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{2}
}
func (m *ChannelConnectivityState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelConnectivityState.Unmarshal(m, b)
}
func (m *ChannelConnectivityState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelConnectivityState.Marshal(b, m, deterministic)
}
func (dst *ChannelConnectivityState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelConnectivityState.Merge(dst, src)
}
func (m *ChannelConnectivityState) XXX_Size() int {
	return xxx_messageInfo_ChannelConnectivityState.Size(m)
}
func (m *ChannelConnectivityState) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelConnectivityState.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelConnectivityState proto.InternalMessageInfo

func (m *ChannelConnectivityState) GetState() ChannelConnectivityState_State {
	if m != nil {
		return m.State
	}
	return ChannelConnectivityState_UNKNOWN
}

// Channel data is data related to a specific Channel or Subchannel.
type ChannelData struct {
	// The connectivity state of the channel or subchannel.  Implementations
	// should always set this.
	State *ChannelConnectivityState `protobuf:"bytes,1,opt,name=state" json:"state,omitempty"`
	// The target this channel originally tried to connect to.  May be absent
	Target string `protobuf:"bytes,2,opt,name=target" json:"target,omitempty"`
	// A trace of recent events on the channel.  May be absent.
	Trace *ChannelTrace `protobuf:"bytes,3,opt,name=trace" json:"trace,omitempty"`
	// The number of calls started on the channel
	CallsStarted int64 `protobuf:"varint,4,opt,name=calls_started,json=callsStarted" json:"calls_started,omitempty"`
	// The number of calls that have completed with an OK status
	CallsSucceeded int64 `protobuf:"varint,5,opt,name=calls_succeeded,json=callsSucceeded" json:"calls_succeeded,omitempty"`
	// The number of calls that have completed with a non-OK status
	CallsFailed int64 `protobuf:"varint,6,opt,name=calls_failed,json=callsFailed" json:"calls_failed,omitempty"`
	// The last time a call was started on the channel.
	LastCallStartedTimestamp *timestamp.Timestamp `protobuf:"bytes,7,opt,name=last_call_started_timestamp,json=lastCallStartedTimestamp" json:"last_call_started_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}             `json:"-"`
	XXX_unrecognized         []byte               `json:"-"`
	XXX_sizecache            int32                `json:"-"`
}

func (m *ChannelData) Reset()         { *m = ChannelData{} }
func (m *ChannelData) String() string { return proto.CompactTextString(m) }
func (*ChannelData) ProtoMessage()    {}
func (*ChannelData) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{3}
}
func (m *ChannelData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelData.Unmarshal(m, b)
}
func (m *ChannelData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelData.Marshal(b, m, deterministic)
}
func (dst *ChannelData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelData.Merge(dst, src)
}
func (m *ChannelData) XXX_Size() int {
	return xxx_messageInfo_ChannelData.Size(m)
}
func (m *ChannelData) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelData.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelData proto.InternalMessageInfo

func (m *ChannelData) GetState() *ChannelConnectivityState {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *ChannelData) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *ChannelData) GetTrace() *ChannelTrace {
	if m != nil {
		return m.Trace
	}
	return nil
}

func (m *ChannelData) GetCallsStarted() int64 {
	if m != nil {
		return m.CallsStarted
	}
	return 0
}

func (m *ChannelData) GetCallsSucceeded() int64 {
	if m != nil {
		return m.CallsSucceeded
	}
	return 0
}

func (m *ChannelData) GetCallsFailed() int64 {
	if m != nil {
		return m.CallsFailed
	}
	return 0
}

func (m *ChannelData) GetLastCallStartedTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.LastCallStartedTimestamp
	}
	return nil
}

// ChannelTrace represents the recent events that have occurred on the channel.
type ChannelTrace struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelTrace) Reset()         { *m = ChannelTrace{} }
func (m *ChannelTrace) String() string { return proto.CompactTextString(m) }
func (*ChannelTrace) ProtoMessage()    {}
func (*ChannelTrace) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{4}
}
func (m *ChannelTrace) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelTrace.Unmarshal(m, b)
}
func (m *ChannelTrace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelTrace.Marshal(b, m, deterministic)
}
func (dst *ChannelTrace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelTrace.Merge(dst, src)
}
func (m *ChannelTrace) XXX_Size() int {
	return xxx_messageInfo_ChannelTrace.Size(m)
}
func (m *ChannelTrace) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelTrace.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelTrace proto.InternalMessageInfo

// ChannelRef is a reference to a Channel.
type ChannelRef struct {
	// The globally unique id for this channel.  Must be a positive number.
	ChannelId int64 `protobuf:"varint,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// An optional name associated with the channel.
	Name                 string   `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelRef) Reset()         { *m = ChannelRef{} }
func (m *ChannelRef) String() string { return proto.CompactTextString(m) }
func (*ChannelRef) ProtoMessage()    {}
func (*ChannelRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{5}
}
func (m *ChannelRef) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelRef.Unmarshal(m, b)
}
func (m *ChannelRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelRef.Marshal(b, m, deterministic)
}
func (dst *ChannelRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelRef.Merge(dst, src)
}
func (m *ChannelRef) XXX_Size() int {
	return xxx_messageInfo_ChannelRef.Size(m)
}
func (m *ChannelRef) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelRef.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelRef proto.InternalMessageInfo

func (m *ChannelRef) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *ChannelRef) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ChannelRef is a reference to a Subchannel.
type SubchannelRef struct {
	// The globally unique id for this subchannel.  Must be a positive number.
	SubchannelId int64 `protobuf:"varint,7,opt,name=subchannel_id,json=subchannelId" json:"subchannel_id,omitempty"`
	// An optional name associated with the subchannel.
	Name                 string   `protobuf:"bytes,8,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SubchannelRef) Reset()         { *m = SubchannelRef{} }
func (m *SubchannelRef) String() string { return proto.CompactTextString(m) }
func (*SubchannelRef) ProtoMessage()    {}
func (*SubchannelRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{6}
}
func (m *SubchannelRef) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubchannelRef.Unmarshal(m, b)
}
func (m *SubchannelRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubchannelRef.Marshal(b, m, deterministic)
}
func (dst *SubchannelRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubchannelRef.Merge(dst, src)
}
func (m *SubchannelRef) XXX_Size() int {
	return xxx_messageInfo_SubchannelRef.Size(m)
}
func (m *SubchannelRef) XXX_DiscardUnknown() {
	xxx_messageInfo_SubchannelRef.DiscardUnknown(m)
}

var xxx_messageInfo_SubchannelRef proto.InternalMessageInfo

func (m *SubchannelRef) GetSubchannelId() int64 {
	if m != nil {
		return m.SubchannelId
	}
	return 0
}

func (m *SubchannelRef) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SocketRef is a reference to a Socket.
type SocketRef struct {
	SocketId int64 `protobuf:"varint,3,opt,name=socket_id,json=socketId" json:"socket_id,omitempty"`
	// An optional name associated with the socket.
	Name                 string   `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SocketRef) Reset()         { *m = SocketRef{} }
func (m *SocketRef) String() string { return proto.CompactTextString(m) }
func (*SocketRef) ProtoMessage()    {}
func (*SocketRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{7}
}
func (m *SocketRef) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SocketRef.Unmarshal(m, b)
}
func (m *SocketRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SocketRef.Marshal(b, m, deterministic)
}
func (dst *SocketRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SocketRef.Merge(dst, src)
}
func (m *SocketRef) XXX_Size() int {
	return xxx_messageInfo_SocketRef.Size(m)
}
func (m *SocketRef) XXX_DiscardUnknown() {
	xxx_messageInfo_SocketRef.DiscardUnknown(m)
}

var xxx_messageInfo_SocketRef proto.InternalMessageInfo

func (m *SocketRef) GetSocketId() int64 {
	if m != nil {
		return m.SocketId
	}
	return 0
}

func (m *SocketRef) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ServerRef is a reference to a Server.
type ServerRef struct {
	// A globally unique identifier for this server.  Must be a positive number.
	ServerId int64 `protobuf:"varint,5,opt,name=server_id,json=serverId" json:"server_id,omitempty"`
	// An optional name associated with the server.
	Name                 string   `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerRef) Reset()         { *m = ServerRef{} }
func (m *ServerRef) String() string { return proto.CompactTextString(m) }
func (*ServerRef) ProtoMessage()    {}
func (*ServerRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{8}
}
func (m *ServerRef) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerRef.Unmarshal(m, b)
}
func (m *ServerRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerRef.Marshal(b, m, deterministic)
}
func (dst *ServerRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerRef.Merge(dst, src)
}
func (m *ServerRef) XXX_Size() int {
	return xxx_messageInfo_ServerRef.Size(m)
}
func (m *ServerRef) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerRef.DiscardUnknown(m)
}

var xxx_messageInfo_ServerRef proto.InternalMessageInfo

func (m *ServerRef) GetServerId() int64 {
	if m != nil {
		return m.ServerId
	}
	return 0
}

func (m *ServerRef) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Server represents a single server.  There may be multiple servers in a single
// program.
type Server struct {
	// The identifier for a Server.  This should be set.
	Ref *ServerRef `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	// The associated data of the Server.
	Data *ServerData `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	// The sockets that the server is listening on.  There are no ordering
	// guarantees.  This may be absent.
	ListenSocket         []*SocketRef `protobuf:"bytes,3,rep,name=listen_socket,json=listenSocket" json:"listen_socket,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Server) Reset()         { *m = Server{} }
func (m *Server) String() string { return proto.CompactTextString(m) }
func (*Server) ProtoMessage()    {}
func (*Server) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{9}
}
func (m *Server) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Server.Unmarshal(m, b)
}
func (m *Server) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Server.Marshal(b, m, deterministic)
}
func (dst *Server) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Server.Merge(dst, src)
}
func (m *Server) XXX_Size() int {
	return xxx_messageInfo_Server.Size(m)
}
func (m *Server) XXX_DiscardUnknown() {
	xxx_messageInfo_Server.DiscardUnknown(m)
}

var xxx_messageInfo_Server proto.InternalMessageInfo

func (m *Server) GetRef() *ServerRef {
	if m != nil {
		return m.Ref
	}
	return nil
}

func (m *Server) GetData() *ServerData {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Server) GetListenSocket() []*SocketRef {
	if m != nil {
		return m.ListenSocket
	}
	return nil
}

// ServerData is data for a specific Server.
type ServerData struct {
	// A trace of recent events on the server.  May be absent.
	Trace *ChannelTrace `protobuf:"bytes,1,opt,name=trace" json:"trace,omitempty"`
	// The number of incoming calls started on the server
	CallsStarted int64 `protobuf:"varint,2,opt,name=calls_started,json=callsStarted" json:"calls_started,omitempty"`
	// The number of incoming calls that have completed with an OK status
	CallsSucceeded int64 `protobuf:"varint,3,opt,name=calls_succeeded,json=callsSucceeded" json:"calls_succeeded,omitempty"`
	// The number of incoming calls that have a completed with a non-OK status
	CallsFailed int64 `protobuf:"varint,4,opt,name=calls_failed,json=callsFailed" json:"calls_failed,omitempty"`
	// The last time a call was started on the server.
	LastCallStartedTimestamp *timestamp.Timestamp `protobuf:"bytes,5,opt,name=last_call_started_timestamp,json=lastCallStartedTimestamp" json:"last_call_started_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}             `json:"-"`
	XXX_unrecognized         []byte               `json:"-"`
	XXX_sizecache            int32                `json:"-"`
}

func (m *ServerData) Reset()         { *m = ServerData{} }
func (m *ServerData) String() string { return proto.CompactTextString(m) }
func (*ServerData) ProtoMessage()    {}
func (*ServerData) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{10}
}
func (m *ServerData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerData.Unmarshal(m, b)
}
func (m *ServerData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerData.Marshal(b, m, deterministic)
}
func (dst *ServerData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerData.Merge(dst, src)
}
func (m *ServerData) XXX_Size() int {
	return xxx_messageInfo_ServerData.Size(m)
}
func (m *ServerData) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerData.DiscardUnknown(m)
}

var xxx_messageInfo_ServerData proto.InternalMessageInfo

func (m *ServerData) GetTrace() *ChannelTrace {
	if m != nil {
		return m.Trace
	}
	return nil
}

func (m *ServerData) GetCallsStarted() int64 {
	if m != nil {
		return m.CallsStarted
	}
	return 0
}

func (m *ServerData) GetCallsSucceeded() int64 {
	if m != nil {
		return m.CallsSucceeded
	}
	return 0
}

func (m *ServerData) GetCallsFailed() int64 {
	if m != nil {
		return m.CallsFailed
	}
	return 0
}

func (m *ServerData) GetLastCallStartedTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.LastCallStartedTimestamp
	}
	return nil
}

// Information about an actual connection.  Pronounced "sock-ay".
type Socket struct {
	// The identifier for the Socket.
	Ref *SocketRef `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	// Data specific to this Socket.
	Data *SocketData `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	// The locally bound address.
	Local *Address `protobuf:"bytes,3,opt,name=local" json:"local,omitempty"`
	// The remote bound address.  May be absent.
	Remote *Address `protobuf:"bytes,4,opt,name=remote" json:"remote,omitempty"`
	// Security details for this socket.  May be absent if not available, or
	// there is no security on the socket.
	Security *Security `protobuf:"bytes,5,opt,name=security" json:"security,omitempty"`
	// Optional, represents the name of the remote endpoint, if different than
	// the original target name.
	RemoteName           string   `protobuf:"bytes,6,opt,name=remote_name,json=remoteName" json:"remote_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Socket) Reset()         { *m = Socket{} }
func (m *Socket) String() string { return proto.CompactTextString(m) }
func (*Socket) ProtoMessage()    {}
func (*Socket) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{11}
}
func (m *Socket) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Socket.Unmarshal(m, b)
}
func (m *Socket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Socket.Marshal(b, m, deterministic)
}
func (dst *Socket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Socket.Merge(dst, src)
}
func (m *Socket) XXX_Size() int {
	return xxx_messageInfo_Socket.Size(m)
}
func (m *Socket) XXX_DiscardUnknown() {
	xxx_messageInfo_Socket.DiscardUnknown(m)
}

var xxx_messageInfo_Socket proto.InternalMessageInfo

func (m *Socket) GetRef() *SocketRef {
	if m != nil {
		return m.Ref
	}
	return nil
}

func (m *Socket) GetData() *SocketData {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Socket) GetLocal() *Address {
	if m != nil {
		return m.Local
	}
	return nil
}

func (m *Socket) GetRemote() *Address {
	if m != nil {
		return m.Remote
	}
	return nil
}

func (m *Socket) GetSecurity() *Security {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *Socket) GetRemoteName() string {
	if m != nil {
		return m.RemoteName
	}
	return ""
}

// SocketData is data associated for a specific Socket.  The fields present
// are specific to the implementation, so there may be minor differences in
// the semantics.  (e.g. flow control windows)
type SocketData struct {
	// The number of streams that have been started.
	StreamsStarted int64 `protobuf:"varint,1,opt,name=streams_started,json=streamsStarted" json:"streams_started,omitempty"`
	// The number of streams that have ended successfully:
	// On client side, received frame with eos bit set;
	// On server side, sent frame with eos bit set.
	StreamsSucceeded int64 `protobuf:"varint,2,opt,name=streams_succeeded,json=streamsSucceeded" json:"streams_succeeded,omitempty"`
	// The number of streams that have ended unsuccessfully:
	// On client side, ended without receiving frame with eos bit set;
	// On server side, ended without sending frame with eos bit set.
	StreamsFailed int64 `protobuf:"varint,3,opt,name=streams_failed,json=streamsFailed" json:"streams_failed,omitempty"`
	// The number of grpc messages successfully sent on this socket.
	MessagesSent int64 `protobuf:"varint,4,opt,name=messages_sent,json=messagesSent" json:"messages_sent,omitempty"`
	// The number of grpc messages received on this socket.
	MessagesReceived int64 `protobuf:"varint,5,opt,name=messages_received,json=messagesReceived" json:"messages_received,omitempty"`
	// The number of keep alives sent.  This is typically implemented with HTTP/2
	// ping messages.
	KeepAlivesSent int64 `protobuf:"varint,6,opt,name=keep_alives_sent,json=keepAlivesSent" json:"keep_alives_sent,omitempty"`
	// The last time a stream was created by this endpoint.  Usually unset for
	// servers.
	LastLocalStreamCreatedTimestamp *timestamp.Timestamp `protobuf:"bytes,7,opt,name=last_local_stream_created_timestamp,json=lastLocalStreamCreatedTimestamp" json:"last_local_stream_created_timestamp,omitempty"`
	// The last time a stream was created by the remote endpoint.  Usually unset
	// for clients.
	LastRemoteStreamCreatedTimestamp *timestamp.Timestamp `protobuf:"bytes,8,opt,name=last_remote_stream_created_timestamp,json=lastRemoteStreamCreatedTimestamp" json:"last_remote_stream_created_timestamp,omitempty"`
	// The last time a message was sent by this endpoint.
	LastMessageSentTimestamp *timestamp.Timestamp `protobuf:"bytes,9,opt,name=last_message_sent_timestamp,json=lastMessageSentTimestamp" json:"last_message_sent_timestamp,omitempty"`
	// The last time a message was received by this endpoint.
	LastMessageReceivedTimestamp *timestamp.Timestamp `protobuf:"bytes,10,opt,name=last_message_received_timestamp,json=lastMessageReceivedTimestamp" json:"last_message_received_timestamp,omitempty"`
	// The amount of window, granted to the local endpoint by the remote endpoint.
	// This may be slightly out of date due to network latency.  This does NOT
	// include stream level or TCP level flow control info.
	LocalFlowControlWindow *wrappers.Int64Value `protobuf:"bytes,11,opt,name=local_flow_control_window,json=localFlowControlWindow" json:"local_flow_control_window,omitempty"`
	// The amount of window, granted to the remote endpoint by the local endpoint.
	// This may be slightly out of date due to network latency.  This does NOT
	// include stream level or TCP level flow control info.
	RemoteFlowControlWindow *wrappers.Int64Value `protobuf:"bytes,12,opt,name=remote_flow_control_window,json=remoteFlowControlWindow" json:"remote_flow_control_window,omitempty"`
	// Socket options set on this socket.  May be absent.
	Option               []*SocketOption `protobuf:"bytes,13,rep,name=option" json:"option,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SocketData) Reset()         { *m = SocketData{} }
func (m *SocketData) String() string { return proto.CompactTextString(m) }
func (*SocketData) ProtoMessage()    {}
func (*SocketData) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{12}
}
func (m *SocketData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SocketData.Unmarshal(m, b)
}
func (m *SocketData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SocketData.Marshal(b, m, deterministic)
}
func (dst *SocketData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SocketData.Merge(dst, src)
}
func (m *SocketData) XXX_Size() int {
	return xxx_messageInfo_SocketData.Size(m)
}
func (m *SocketData) XXX_DiscardUnknown() {
	xxx_messageInfo_SocketData.DiscardUnknown(m)
}

var xxx_messageInfo_SocketData proto.InternalMessageInfo

func (m *SocketData) GetStreamsStarted() int64 {
	if m != nil {
		return m.StreamsStarted
	}
	return 0
}

func (m *SocketData) GetStreamsSucceeded() int64 {
	if m != nil {
		return m.StreamsSucceeded
	}
	return 0
}

func (m *SocketData) GetStreamsFailed() int64 {
	if m != nil {
		return m.StreamsFailed
	}
	return 0
}

func (m *SocketData) GetMessagesSent() int64 {
	if m != nil {
		return m.MessagesSent
	}
	return 0
}

func (m *SocketData) GetMessagesReceived() int64 {
	if m != nil {
		return m.MessagesReceived
	}
	return 0
}

func (m *SocketData) GetKeepAlivesSent() int64 {
	if m != nil {
		return m.KeepAlivesSent
	}
	return 0
}

func (m *SocketData) GetLastLocalStreamCreatedTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.LastLocalStreamCreatedTimestamp
	}
	return nil
}

func (m *SocketData) GetLastRemoteStreamCreatedTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.LastRemoteStreamCreatedTimestamp
	}
	return nil
}

func (m *SocketData) GetLastMessageSentTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.LastMessageSentTimestamp
	}
	return nil
}

func (m *SocketData) GetLastMessageReceivedTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.LastMessageReceivedTimestamp
	}
	return nil
}

func (m *SocketData) GetLocalFlowControlWindow() *wrappers.Int64Value {
	if m != nil {
		return m.LocalFlowControlWindow
	}
	return nil
}

func (m *SocketData) GetRemoteFlowControlWindow() *wrappers.Int64Value {
	if m != nil {
		return m.RemoteFlowControlWindow
	}
	return nil
}

func (m *SocketData) GetOption() []*SocketOption {
	if m != nil {
		return m.Option
	}
	return nil
}

// Address represents the address used to create the socket.
type Address struct {
	// Types that are valid to be assigned to Address:
	//	*Address_TcpipAddress
	//	*Address_UdsAddress_
	//	*Address_OtherAddress_
	Address              isAddress_Address `protobuf_oneof:"address"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Address) Reset()         { *m = Address{} }
func (m *Address) String() string { return proto.CompactTextString(m) }
func (*Address) ProtoMessage()    {}
func (*Address) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{13}
}
func (m *Address) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Address.Unmarshal(m, b)
}
func (m *Address) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Address.Marshal(b, m, deterministic)
}
func (dst *Address) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Address.Merge(dst, src)
}
func (m *Address) XXX_Size() int {
	return xxx_messageInfo_Address.Size(m)
}
func (m *Address) XXX_DiscardUnknown() {
	xxx_messageInfo_Address.DiscardUnknown(m)
}

var xxx_messageInfo_Address proto.InternalMessageInfo

type isAddress_Address interface {
	isAddress_Address()
}

type Address_TcpipAddress struct {
	TcpipAddress *Address_TcpIpAddress `protobuf:"bytes,1,opt,name=tcpip_address,json=tcpipAddress,oneof"`
}
type Address_UdsAddress_ struct {
	UdsAddress *Address_UdsAddress `protobuf:"bytes,2,opt,name=uds_address,json=udsAddress,oneof"`
}
type Address_OtherAddress_ struct {
	OtherAddress *Address_OtherAddress `protobuf:"bytes,3,opt,name=other_address,json=otherAddress,oneof"`
}

func (*Address_TcpipAddress) isAddress_Address()  {}
func (*Address_UdsAddress_) isAddress_Address()   {}
func (*Address_OtherAddress_) isAddress_Address() {}

func (m *Address) GetAddress() isAddress_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Address) GetTcpipAddress() *Address_TcpIpAddress {
	if x, ok := m.GetAddress().(*Address_TcpipAddress); ok {
		return x.TcpipAddress
	}
	return nil
}

func (m *Address) GetUdsAddress() *Address_UdsAddress {
	if x, ok := m.GetAddress().(*Address_UdsAddress_); ok {
		return x.UdsAddress
	}
	return nil
}

func (m *Address) GetOtherAddress() *Address_OtherAddress {
	if x, ok := m.GetAddress().(*Address_OtherAddress_); ok {
		return x.OtherAddress
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Address) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Address_OneofMarshaler, _Address_OneofUnmarshaler, _Address_OneofSizer, []interface{}{
		(*Address_TcpipAddress)(nil),
		(*Address_UdsAddress_)(nil),
		(*Address_OtherAddress_)(nil),
	}
}

func _Address_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_TcpipAddress:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TcpipAddress); err != nil {
			return err
		}
	case *Address_UdsAddress_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UdsAddress); err != nil {
			return err
		}
	case *Address_OtherAddress_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OtherAddress); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Address.Address has unexpected type %T", x)
	}
	return nil
}

func _Address_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Address)
	switch tag {
	case 1: // address.tcpip_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Address_TcpIpAddress)
		err := b.DecodeMessage(msg)
		m.Address = &Address_TcpipAddress{msg}
		return true, err
	case 2: // address.uds_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Address_UdsAddress)
		err := b.DecodeMessage(msg)
		m.Address = &Address_UdsAddress_{msg}
		return true, err
	case 3: // address.other_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Address_OtherAddress)
		err := b.DecodeMessage(msg)
		m.Address = &Address_OtherAddress_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Address_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_TcpipAddress:
		s := proto.Size(x.TcpipAddress)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Address_UdsAddress_:
		s := proto.Size(x.UdsAddress)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Address_OtherAddress_:
		s := proto.Size(x.OtherAddress)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Address_TcpIpAddress struct {
	// Either the IPv4 or IPv6 address in bytes.  Will be either 4 bytes or 16
	// bytes in length.
	IpAddress []byte `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// 0-64k, or -1 if not appropriate.
	Port                 int32    `protobuf:"varint,2,opt,name=port" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Address_TcpIpAddress) Reset()         { *m = Address_TcpIpAddress{} }
func (m *Address_TcpIpAddress) String() string { return proto.CompactTextString(m) }
func (*Address_TcpIpAddress) ProtoMessage()    {}
func (*Address_TcpIpAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{13, 0}
}
func (m *Address_TcpIpAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Address_TcpIpAddress.Unmarshal(m, b)
}
func (m *Address_TcpIpAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Address_TcpIpAddress.Marshal(b, m, deterministic)
}
func (dst *Address_TcpIpAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Address_TcpIpAddress.Merge(dst, src)
}
func (m *Address_TcpIpAddress) XXX_Size() int {
	return xxx_messageInfo_Address_TcpIpAddress.Size(m)
}
func (m *Address_TcpIpAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_Address_TcpIpAddress.DiscardUnknown(m)
}

var xxx_messageInfo_Address_TcpIpAddress proto.InternalMessageInfo

func (m *Address_TcpIpAddress) GetIpAddress() []byte {
	if m != nil {
		return m.IpAddress
	}
	return nil
}

func (m *Address_TcpIpAddress) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// A Unix Domain Socket address.
type Address_UdsAddress struct {
	Filename             string   `protobuf:"bytes,1,opt,name=filename" json:"filename,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Address_UdsAddress) Reset()         { *m = Address_UdsAddress{} }
func (m *Address_UdsAddress) String() string { return proto.CompactTextString(m) }
func (*Address_UdsAddress) ProtoMessage()    {}
func (*Address_UdsAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{13, 1}
}
func (m *Address_UdsAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Address_UdsAddress.Unmarshal(m, b)
}
func (m *Address_UdsAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Address_UdsAddress.Marshal(b, m, deterministic)
}
func (dst *Address_UdsAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Address_UdsAddress.Merge(dst, src)
}
func (m *Address_UdsAddress) XXX_Size() int {
	return xxx_messageInfo_Address_UdsAddress.Size(m)
}
func (m *Address_UdsAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_Address_UdsAddress.DiscardUnknown(m)
}

var xxx_messageInfo_Address_UdsAddress proto.InternalMessageInfo

func (m *Address_UdsAddress) GetFilename() string {
	if m != nil {
		return m.Filename
	}
	return ""
}

// An address type not included above.
type Address_OtherAddress struct {
	// The human readable version of the value.  This value should be set.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The actual address message.
	Value                *any.Any `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Address_OtherAddress) Reset()         { *m = Address_OtherAddress{} }
func (m *Address_OtherAddress) String() string { return proto.CompactTextString(m) }
func (*Address_OtherAddress) ProtoMessage()    {}
func (*Address_OtherAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{13, 2}
}
func (m *Address_OtherAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Address_OtherAddress.Unmarshal(m, b)
}
func (m *Address_OtherAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Address_OtherAddress.Marshal(b, m, deterministic)
}
func (dst *Address_OtherAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Address_OtherAddress.Merge(dst, src)
}
func (m *Address_OtherAddress) XXX_Size() int {
	return xxx_messageInfo_Address_OtherAddress.Size(m)
}
func (m *Address_OtherAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_Address_OtherAddress.DiscardUnknown(m)
}

var xxx_messageInfo_Address_OtherAddress proto.InternalMessageInfo

func (m *Address_OtherAddress) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Address_OtherAddress) GetValue() *any.Any {
	if m != nil {
		return m.Value
	}
	return nil
}

// Security represents details about how secure the socket is.
type Security struct {
	// Types that are valid to be assigned to Model:
	//	*Security_Tls_
	//	*Security_Other
	Model                isSecurity_Model `protobuf_oneof:"model"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Security) Reset()         { *m = Security{} }
func (m *Security) String() string { return proto.CompactTextString(m) }
func (*Security) ProtoMessage()    {}
func (*Security) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{14}
}
func (m *Security) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Security.Unmarshal(m, b)
}
func (m *Security) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Security.Marshal(b, m, deterministic)
}
func (dst *Security) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Security.Merge(dst, src)
}
func (m *Security) XXX_Size() int {
	return xxx_messageInfo_Security.Size(m)
}
func (m *Security) XXX_DiscardUnknown() {
	xxx_messageInfo_Security.DiscardUnknown(m)
}

var xxx_messageInfo_Security proto.InternalMessageInfo

type isSecurity_Model interface {
	isSecurity_Model()
}

type Security_Tls_ struct {
	Tls *Security_Tls `protobuf:"bytes,1,opt,name=tls,oneof"`
}
type Security_Other struct {
	Other *Security_OtherSecurity `protobuf:"bytes,2,opt,name=other,oneof"`
}

func (*Security_Tls_) isSecurity_Model()  {}
func (*Security_Other) isSecurity_Model() {}

func (m *Security) GetModel() isSecurity_Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *Security) GetTls() *Security_Tls {
	if x, ok := m.GetModel().(*Security_Tls_); ok {
		return x.Tls
	}
	return nil
}

func (m *Security) GetOther() *Security_OtherSecurity {
	if x, ok := m.GetModel().(*Security_Other); ok {
		return x.Other
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Security) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Security_OneofMarshaler, _Security_OneofUnmarshaler, _Security_OneofSizer, []interface{}{
		(*Security_Tls_)(nil),
		(*Security_Other)(nil),
	}
}

func _Security_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Security)
	// model
	switch x := m.Model.(type) {
	case *Security_Tls_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Tls); err != nil {
			return err
		}
	case *Security_Other:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Other); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Security.Model has unexpected type %T", x)
	}
	return nil
}

func _Security_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Security)
	switch tag {
	case 1: // model.tls
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Security_Tls)
		err := b.DecodeMessage(msg)
		m.Model = &Security_Tls_{msg}
		return true, err
	case 2: // model.other
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Security_OtherSecurity)
		err := b.DecodeMessage(msg)
		m.Model = &Security_Other{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Security_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Security)
	// model
	switch x := m.Model.(type) {
	case *Security_Tls_:
		s := proto.Size(x.Tls)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Security_Other:
		s := proto.Size(x.Other)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Security_Tls struct {
	// Types that are valid to be assigned to CipherSuite:
	//	*Security_Tls_StandardName
	//	*Security_Tls_OtherName
	CipherSuite isSecurity_Tls_CipherSuite `protobuf_oneof:"cipher_suite"`
	// the certificate used by this endpoint.
	LocalCertificate []byte `protobuf:"bytes,3,opt,name=local_certificate,json=localCertificate,proto3" json:"local_certificate,omitempty"`
	// the certificate used by the remote endpoint.
	RemoteCertificate    []byte   `protobuf:"bytes,4,opt,name=remote_certificate,json=remoteCertificate,proto3" json:"remote_certificate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Security_Tls) Reset()         { *m = Security_Tls{} }
func (m *Security_Tls) String() string { return proto.CompactTextString(m) }
func (*Security_Tls) ProtoMessage()    {}
func (*Security_Tls) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{14, 0}
}
func (m *Security_Tls) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Security_Tls.Unmarshal(m, b)
}
func (m *Security_Tls) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Security_Tls.Marshal(b, m, deterministic)
}
func (dst *Security_Tls) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Security_Tls.Merge(dst, src)
}
func (m *Security_Tls) XXX_Size() int {
	return xxx_messageInfo_Security_Tls.Size(m)
}
func (m *Security_Tls) XXX_DiscardUnknown() {
	xxx_messageInfo_Security_Tls.DiscardUnknown(m)
}

var xxx_messageInfo_Security_Tls proto.InternalMessageInfo

type isSecurity_Tls_CipherSuite interface {
	isSecurity_Tls_CipherSuite()
}

type Security_Tls_StandardName struct {
	StandardName string `protobuf:"bytes,1,opt,name=standard_name,json=standardName,oneof"`
}
type Security_Tls_OtherName struct {
	OtherName string `protobuf:"bytes,2,opt,name=other_name,json=otherName,oneof"`
}

func (*Security_Tls_StandardName) isSecurity_Tls_CipherSuite() {}
func (*Security_Tls_OtherName) isSecurity_Tls_CipherSuite()    {}

func (m *Security_Tls) GetCipherSuite() isSecurity_Tls_CipherSuite {
	if m != nil {
		return m.CipherSuite
	}
	return nil
}

func (m *Security_Tls) GetStandardName() string {
	if x, ok := m.GetCipherSuite().(*Security_Tls_StandardName); ok {
		return x.StandardName
	}
	return ""
}

func (m *Security_Tls) GetOtherName() string {
	if x, ok := m.GetCipherSuite().(*Security_Tls_OtherName); ok {
		return x.OtherName
	}
	return ""
}

func (m *Security_Tls) GetLocalCertificate() []byte {
	if m != nil {
		return m.LocalCertificate
	}
	return nil
}

func (m *Security_Tls) GetRemoteCertificate() []byte {
	if m != nil {
		return m.RemoteCertificate
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Security_Tls) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Security_Tls_OneofMarshaler, _Security_Tls_OneofUnmarshaler, _Security_Tls_OneofSizer, []interface{}{
		(*Security_Tls_StandardName)(nil),
		(*Security_Tls_OtherName)(nil),
	}
}

func _Security_Tls_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Security_Tls)
	// cipher_suite
	switch x := m.CipherSuite.(type) {
	case *Security_Tls_StandardName:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StandardName)
	case *Security_Tls_OtherName:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.OtherName)
	case nil:
	default:
		return fmt.Errorf("Security_Tls.CipherSuite has unexpected type %T", x)
	}
	return nil
}

func _Security_Tls_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Security_Tls)
	switch tag {
	case 1: // cipher_suite.standard_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.CipherSuite = &Security_Tls_StandardName{x}
		return true, err
	case 2: // cipher_suite.other_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.CipherSuite = &Security_Tls_OtherName{x}
		return true, err
	default:
		return false, nil
	}
}

func _Security_Tls_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Security_Tls)
	// cipher_suite
	switch x := m.CipherSuite.(type) {
	case *Security_Tls_StandardName:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StandardName)))
		n += len(x.StandardName)
	case *Security_Tls_OtherName:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.OtherName)))
		n += len(x.OtherName)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Security_OtherSecurity struct {
	// The human readable version of the value.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The actual security details message.
	Value                *any.Any `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Security_OtherSecurity) Reset()         { *m = Security_OtherSecurity{} }
func (m *Security_OtherSecurity) String() string { return proto.CompactTextString(m) }
func (*Security_OtherSecurity) ProtoMessage()    {}
func (*Security_OtherSecurity) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{14, 1}
}
func (m *Security_OtherSecurity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Security_OtherSecurity.Unmarshal(m, b)
}
func (m *Security_OtherSecurity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Security_OtherSecurity.Marshal(b, m, deterministic)
}
func (dst *Security_OtherSecurity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Security_OtherSecurity.Merge(dst, src)
}
func (m *Security_OtherSecurity) XXX_Size() int {
	return xxx_messageInfo_Security_OtherSecurity.Size(m)
}
func (m *Security_OtherSecurity) XXX_DiscardUnknown() {
	xxx_messageInfo_Security_OtherSecurity.DiscardUnknown(m)
}

var xxx_messageInfo_Security_OtherSecurity proto.InternalMessageInfo

func (m *Security_OtherSecurity) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Security_OtherSecurity) GetValue() *any.Any {
	if m != nil {
		return m.Value
	}
	return nil
}

// SocketOption represents socket options for a socket.  Specifically, these
// are the options returned by getsockopt().
type SocketOption struct {
	// The full name of the socket option.  Typically this will be the upper case
	// name, such as "SO_REUSEPORT".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The human readable value of this socket option.  At least one of value or
	// additional will be set.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// Additional data associated with the socket option.  At least one of value
	// or additional will be set.
	Additional           *any.Any `protobuf:"bytes,3,opt,name=additional" json:"additional,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SocketOption) Reset()         { *m = SocketOption{} }
func (m *SocketOption) String() string { return proto.CompactTextString(m) }
func (*SocketOption) ProtoMessage()    {}
func (*SocketOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{15}
}
func (m *SocketOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SocketOption.Unmarshal(m, b)
}
func (m *SocketOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SocketOption.Marshal(b, m, deterministic)
}
func (dst *SocketOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SocketOption.Merge(dst, src)
}
func (m *SocketOption) XXX_Size() int {
	return xxx_messageInfo_SocketOption.Size(m)
}
func (m *SocketOption) XXX_DiscardUnknown() {
	xxx_messageInfo_SocketOption.DiscardUnknown(m)
}

var xxx_messageInfo_SocketOption proto.InternalMessageInfo

func (m *SocketOption) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SocketOption) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *SocketOption) GetAdditional() *any.Any {
	if m != nil {
		return m.Additional
	}
	return nil
}

// For use with SocketOption's additional field.  This is primarily used for
// SO_RCVTIMEO and SO_SNDTIMEO
type SocketOptionTimeout struct {
	Duration             *duration.Duration `protobuf:"bytes,1,opt,name=duration" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SocketOptionTimeout) Reset()         { *m = SocketOptionTimeout{} }
func (m *SocketOptionTimeout) String() string { return proto.CompactTextString(m) }
func (*SocketOptionTimeout) ProtoMessage()    {}
func (*SocketOptionTimeout) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{16}
}
func (m *SocketOptionTimeout) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SocketOptionTimeout.Unmarshal(m, b)
}
func (m *SocketOptionTimeout) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SocketOptionTimeout.Marshal(b, m, deterministic)
}
func (dst *SocketOptionTimeout) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SocketOptionTimeout.Merge(dst, src)
}
func (m *SocketOptionTimeout) XXX_Size() int {
	return xxx_messageInfo_SocketOptionTimeout.Size(m)
}
func (m *SocketOptionTimeout) XXX_DiscardUnknown() {
	xxx_messageInfo_SocketOptionTimeout.DiscardUnknown(m)
}

var xxx_messageInfo_SocketOptionTimeout proto.InternalMessageInfo

func (m *SocketOptionTimeout) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

// For use with SocketOption's additional field.  This is primarily used for
// SO_LINGER.
type SocketOptionLinger struct {
	// active maps to `struct linger.l_onoff`
	Active bool `protobuf:"varint,1,opt,name=active" json:"active,omitempty"`
	// duration maps to `struct linger.l_linger`
	Duration             *duration.Duration `protobuf:"bytes,2,opt,name=duration" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SocketOptionLinger) Reset()         { *m = SocketOptionLinger{} }
func (m *SocketOptionLinger) String() string { return proto.CompactTextString(m) }
func (*SocketOptionLinger) ProtoMessage()    {}
func (*SocketOptionLinger) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{17}
}
func (m *SocketOptionLinger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SocketOptionLinger.Unmarshal(m, b)
}
func (m *SocketOptionLinger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SocketOptionLinger.Marshal(b, m, deterministic)
}
func (dst *SocketOptionLinger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SocketOptionLinger.Merge(dst, src)
}
func (m *SocketOptionLinger) XXX_Size() int {
	return xxx_messageInfo_SocketOptionLinger.Size(m)
}
func (m *SocketOptionLinger) XXX_DiscardUnknown() {
	xxx_messageInfo_SocketOptionLinger.DiscardUnknown(m)
}

var xxx_messageInfo_SocketOptionLinger proto.InternalMessageInfo

func (m *SocketOptionLinger) GetActive() bool {
	if m != nil {
		return m.Active
	}
	return false
}

func (m *SocketOptionLinger) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

// For use with SocketOption's additional field.  Tcp info for
// SOL_TCP and TCP_INFO.
type SocketOptionTcpInfo struct {
	TcpiState            uint32   `protobuf:"varint,1,opt,name=tcpi_state,json=tcpiState" json:"tcpi_state,omitempty"`
	TcpiCaState          uint32   `protobuf:"varint,2,opt,name=tcpi_ca_state,json=tcpiCaState" json:"tcpi_ca_state,omitempty"`
	TcpiRetransmits      uint32   `protobuf:"varint,3,opt,name=tcpi_retransmits,json=tcpiRetransmits" json:"tcpi_retransmits,omitempty"`
	TcpiProbes           uint32   `protobuf:"varint,4,opt,name=tcpi_probes,json=tcpiProbes" json:"tcpi_probes,omitempty"`
	TcpiBackoff          uint32   `protobuf:"varint,5,opt,name=tcpi_backoff,json=tcpiBackoff" json:"tcpi_backoff,omitempty"`
	TcpiOptions          uint32   `protobuf:"varint,6,opt,name=tcpi_options,json=tcpiOptions" json:"tcpi_options,omitempty"`
	TcpiSndWscale        uint32   `protobuf:"varint,7,opt,name=tcpi_snd_wscale,json=tcpiSndWscale" json:"tcpi_snd_wscale,omitempty"`
	TcpiRcvWscale        uint32   `protobuf:"varint,8,opt,name=tcpi_rcv_wscale,json=tcpiRcvWscale" json:"tcpi_rcv_wscale,omitempty"`
	TcpiRto              uint32   `protobuf:"varint,9,opt,name=tcpi_rto,json=tcpiRto" json:"tcpi_rto,omitempty"`
	TcpiAto              uint32   `protobuf:"varint,10,opt,name=tcpi_ato,json=tcpiAto" json:"tcpi_ato,omitempty"`
	TcpiSndMss           uint32   `protobuf:"varint,11,opt,name=tcpi_snd_mss,json=tcpiSndMss" json:"tcpi_snd_mss,omitempty"`
	TcpiRcvMss           uint32   `protobuf:"varint,12,opt,name=tcpi_rcv_mss,json=tcpiRcvMss" json:"tcpi_rcv_mss,omitempty"`
	TcpiUnacked          uint32   `protobuf:"varint,13,opt,name=tcpi_unacked,json=tcpiUnacked" json:"tcpi_unacked,omitempty"`
	TcpiSacked           uint32   `protobuf:"varint,14,opt,name=tcpi_sacked,json=tcpiSacked" json:"tcpi_sacked,omitempty"`
	TcpiLost             uint32   `protobuf:"varint,15,opt,name=tcpi_lost,json=tcpiLost" json:"tcpi_lost,omitempty"`
	TcpiRetrans          uint32   `protobuf:"varint,16,opt,name=tcpi_retrans,json=tcpiRetrans" json:"tcpi_retrans,omitempty"`
	TcpiFackets          uint32   `protobuf:"varint,17,opt,name=tcpi_fackets,json=tcpiFackets" json:"tcpi_fackets,omitempty"`
	TcpiLastDataSent     uint32   `protobuf:"varint,18,opt,name=tcpi_last_data_sent,json=tcpiLastDataSent" json:"tcpi_last_data_sent,omitempty"`
	TcpiLastAckSent      uint32   `protobuf:"varint,19,opt,name=tcpi_last_ack_sent,json=tcpiLastAckSent" json:"tcpi_last_ack_sent,omitempty"`
	TcpiLastDataRecv     uint32   `protobuf:"varint,20,opt,name=tcpi_last_data_recv,json=tcpiLastDataRecv" json:"tcpi_last_data_recv,omitempty"`
	TcpiLastAckRecv      uint32   `protobuf:"varint,21,opt,name=tcpi_last_ack_recv,json=tcpiLastAckRecv" json:"tcpi_last_ack_recv,omitempty"`
	TcpiPmtu             uint32   `protobuf:"varint,22,opt,name=tcpi_pmtu,json=tcpiPmtu" json:"tcpi_pmtu,omitempty"`
	TcpiRcvSsthresh      uint32   `protobuf:"varint,23,opt,name=tcpi_rcv_ssthresh,json=tcpiRcvSsthresh" json:"tcpi_rcv_ssthresh,omitempty"`
	TcpiRtt              uint32   `protobuf:"varint,24,opt,name=tcpi_rtt,json=tcpiRtt" json:"tcpi_rtt,omitempty"`
	TcpiRttvar           uint32   `protobuf:"varint,25,opt,name=tcpi_rttvar,json=tcpiRttvar" json:"tcpi_rttvar,omitempty"`
	TcpiSndSsthresh      uint32   `protobuf:"varint,26,opt,name=tcpi_snd_ssthresh,json=tcpiSndSsthresh" json:"tcpi_snd_ssthresh,omitempty"`
	TcpiSndCwnd          uint32   `protobuf:"varint,27,opt,name=tcpi_snd_cwnd,json=tcpiSndCwnd" json:"tcpi_snd_cwnd,omitempty"`
	TcpiAdvmss           uint32   `protobuf:"varint,28,opt,name=tcpi_advmss,json=tcpiAdvmss" json:"tcpi_advmss,omitempty"`
	TcpiReordering       uint32   `protobuf:"varint,29,opt,name=tcpi_reordering,json=tcpiReordering" json:"tcpi_reordering,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SocketOptionTcpInfo) Reset()         { *m = SocketOptionTcpInfo{} }
func (m *SocketOptionTcpInfo) String() string { return proto.CompactTextString(m) }
func (*SocketOptionTcpInfo) ProtoMessage()    {}
func (*SocketOptionTcpInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{18}
}
func (m *SocketOptionTcpInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SocketOptionTcpInfo.Unmarshal(m, b)
}
func (m *SocketOptionTcpInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SocketOptionTcpInfo.Marshal(b, m, deterministic)
}
func (dst *SocketOptionTcpInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SocketOptionTcpInfo.Merge(dst, src)
}
func (m *SocketOptionTcpInfo) XXX_Size() int {
	return xxx_messageInfo_SocketOptionTcpInfo.Size(m)
}
func (m *SocketOptionTcpInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SocketOptionTcpInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SocketOptionTcpInfo proto.InternalMessageInfo

func (m *SocketOptionTcpInfo) GetTcpiState() uint32 {
	if m != nil {
		return m.TcpiState
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiCaState() uint32 {
	if m != nil {
		return m.TcpiCaState
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRetransmits() uint32 {
	if m != nil {
		return m.TcpiRetransmits
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiProbes() uint32 {
	if m != nil {
		return m.TcpiProbes
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiBackoff() uint32 {
	if m != nil {
		return m.TcpiBackoff
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiOptions() uint32 {
	if m != nil {
		return m.TcpiOptions
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiSndWscale() uint32 {
	if m != nil {
		return m.TcpiSndWscale
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRcvWscale() uint32 {
	if m != nil {
		return m.TcpiRcvWscale
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRto() uint32 {
	if m != nil {
		return m.TcpiRto
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiAto() uint32 {
	if m != nil {
		return m.TcpiAto
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiSndMss() uint32 {
	if m != nil {
		return m.TcpiSndMss
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRcvMss() uint32 {
	if m != nil {
		return m.TcpiRcvMss
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiUnacked() uint32 {
	if m != nil {
		return m.TcpiUnacked
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiSacked() uint32 {
	if m != nil {
		return m.TcpiSacked
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiLost() uint32 {
	if m != nil {
		return m.TcpiLost
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRetrans() uint32 {
	if m != nil {
		return m.TcpiRetrans
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiFackets() uint32 {
	if m != nil {
		return m.TcpiFackets
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiLastDataSent() uint32 {
	if m != nil {
		return m.TcpiLastDataSent
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiLastAckSent() uint32 {
	if m != nil {
		return m.TcpiLastAckSent
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiLastDataRecv() uint32 {
	if m != nil {
		return m.TcpiLastDataRecv
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiLastAckRecv() uint32 {
	if m != nil {
		return m.TcpiLastAckRecv
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiPmtu() uint32 {
	if m != nil {
		return m.TcpiPmtu
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRcvSsthresh() uint32 {
	if m != nil {
		return m.TcpiRcvSsthresh
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRtt() uint32 {
	if m != nil {
		return m.TcpiRtt
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiRttvar() uint32 {
	if m != nil {
		return m.TcpiRttvar
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiSndSsthresh() uint32 {
	if m != nil {
		return m.TcpiSndSsthresh
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiSndCwnd() uint32 {
	if m != nil {
		return m.TcpiSndCwnd
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiAdvmss() uint32 {
	if m != nil {
		return m.TcpiAdvmss
	}
	return 0
}

func (m *SocketOptionTcpInfo) GetTcpiReordering() uint32 {
	if m != nil {
		return m.TcpiReordering
	}
	return 0
}

type GetTopChannelsRequest struct {
	// start_channel_id indicates that only channels at or above this id should be
	// included in the results.
	StartChannelId       int64    `protobuf:"varint,1,opt,name=start_channel_id,json=startChannelId" json:"start_channel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTopChannelsRequest) Reset()         { *m = GetTopChannelsRequest{} }
func (m *GetTopChannelsRequest) String() string { return proto.CompactTextString(m) }
func (*GetTopChannelsRequest) ProtoMessage()    {}
func (*GetTopChannelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{19}
}
func (m *GetTopChannelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTopChannelsRequest.Unmarshal(m, b)
}
func (m *GetTopChannelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTopChannelsRequest.Marshal(b, m, deterministic)
}
func (dst *GetTopChannelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTopChannelsRequest.Merge(dst, src)
}
func (m *GetTopChannelsRequest) XXX_Size() int {
	return xxx_messageInfo_GetTopChannelsRequest.Size(m)
}
func (m *GetTopChannelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTopChannelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTopChannelsRequest proto.InternalMessageInfo

func (m *GetTopChannelsRequest) GetStartChannelId() int64 {
	if m != nil {
		return m.StartChannelId
	}
	return 0
}

type GetTopChannelsResponse struct {
	// list of channels that the connection detail service knows about.  Sorted in
	// ascending channel_id order.
	Channel []*Channel `protobuf:"bytes,1,rep,name=channel" json:"channel,omitempty"`
	// If set, indicates that the list of channels is the final list.  Requesting
	// more channels can only return more if they are created after this RPC
	// completes.
	End                  bool     `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTopChannelsResponse) Reset()         { *m = GetTopChannelsResponse{} }
func (m *GetTopChannelsResponse) String() string { return proto.CompactTextString(m) }
func (*GetTopChannelsResponse) ProtoMessage()    {}
func (*GetTopChannelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{20}
}
func (m *GetTopChannelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTopChannelsResponse.Unmarshal(m, b)
}
func (m *GetTopChannelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTopChannelsResponse.Marshal(b, m, deterministic)
}
func (dst *GetTopChannelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTopChannelsResponse.Merge(dst, src)
}
func (m *GetTopChannelsResponse) XXX_Size() int {
	return xxx_messageInfo_GetTopChannelsResponse.Size(m)
}
func (m *GetTopChannelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTopChannelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetTopChannelsResponse proto.InternalMessageInfo

func (m *GetTopChannelsResponse) GetChannel() []*Channel {
	if m != nil {
		return m.Channel
	}
	return nil
}

func (m *GetTopChannelsResponse) GetEnd() bool {
	if m != nil {
		return m.End
	}
	return false
}

type GetServersRequest struct {
	// start_server_id indicates that only servers at or above this id should be
	// included in the results.
	StartServerId        int64    `protobuf:"varint,1,opt,name=start_server_id,json=startServerId" json:"start_server_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServersRequest) Reset()         { *m = GetServersRequest{} }
func (m *GetServersRequest) String() string { return proto.CompactTextString(m) }
func (*GetServersRequest) ProtoMessage()    {}
func (*GetServersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{21}
}
func (m *GetServersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServersRequest.Unmarshal(m, b)
}
func (m *GetServersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServersRequest.Marshal(b, m, deterministic)
}
func (dst *GetServersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServersRequest.Merge(dst, src)
}
func (m *GetServersRequest) XXX_Size() int {
	return xxx_messageInfo_GetServersRequest.Size(m)
}
func (m *GetServersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServersRequest proto.InternalMessageInfo

func (m *GetServersRequest) GetStartServerId() int64 {
	if m != nil {
		return m.StartServerId
	}
	return 0
}

type GetServersResponse struct {
	// list of servers that the connection detail service knows about.  Sorted in
	// ascending server_id order.
	Server []*Server `protobuf:"bytes,1,rep,name=server" json:"server,omitempty"`
	// If set, indicates that the list of servers is the final list.  Requesting
	// more servers will only return more if they are created after this RPC
	// completes.
	End                  bool     `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServersResponse) Reset()         { *m = GetServersResponse{} }
func (m *GetServersResponse) String() string { return proto.CompactTextString(m) }
func (*GetServersResponse) ProtoMessage()    {}
func (*GetServersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{22}
}
func (m *GetServersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServersResponse.Unmarshal(m, b)
}
func (m *GetServersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServersResponse.Marshal(b, m, deterministic)
}
func (dst *GetServersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServersResponse.Merge(dst, src)
}
func (m *GetServersResponse) XXX_Size() int {
	return xxx_messageInfo_GetServersResponse.Size(m)
}
func (m *GetServersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetServersResponse proto.InternalMessageInfo

func (m *GetServersResponse) GetServer() []*Server {
	if m != nil {
		return m.Server
	}
	return nil
}

func (m *GetServersResponse) GetEnd() bool {
	if m != nil {
		return m.End
	}
	return false
}

type GetServerSocketsRequest struct {
	ServerId int64 `protobuf:"varint,1,opt,name=server_id,json=serverId" json:"server_id,omitempty"`
	// start_socket_id indicates that only sockets at or above this id should be
	// included in the results.
	StartSocketId        int64    `protobuf:"varint,2,opt,name=start_socket_id,json=startSocketId" json:"start_socket_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServerSocketsRequest) Reset()         { *m = GetServerSocketsRequest{} }
func (m *GetServerSocketsRequest) String() string { return proto.CompactTextString(m) }
func (*GetServerSocketsRequest) ProtoMessage()    {}
func (*GetServerSocketsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{23}
}
func (m *GetServerSocketsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServerSocketsRequest.Unmarshal(m, b)
}
func (m *GetServerSocketsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServerSocketsRequest.Marshal(b, m, deterministic)
}
func (dst *GetServerSocketsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServerSocketsRequest.Merge(dst, src)
}
func (m *GetServerSocketsRequest) XXX_Size() int {
	return xxx_messageInfo_GetServerSocketsRequest.Size(m)
}
func (m *GetServerSocketsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServerSocketsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServerSocketsRequest proto.InternalMessageInfo

func (m *GetServerSocketsRequest) GetServerId() int64 {
	if m != nil {
		return m.ServerId
	}
	return 0
}

func (m *GetServerSocketsRequest) GetStartSocketId() int64 {
	if m != nil {
		return m.StartSocketId
	}
	return 0
}

type GetServerSocketsResponse struct {
	// list of socket refs that the connection detail service knows about.  Sorted in
	// ascending socket_id order.
	SocketRef []*SocketRef `protobuf:"bytes,1,rep,name=socket_ref,json=socketRef" json:"socket_ref,omitempty"`
	// If set, indicates that the list of sockets is the final list.  Requesting
	// more sockets will only return more if they are created after this RPC
	// completes.
	End                  bool     `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServerSocketsResponse) Reset()         { *m = GetServerSocketsResponse{} }
func (m *GetServerSocketsResponse) String() string { return proto.CompactTextString(m) }
func (*GetServerSocketsResponse) ProtoMessage()    {}
func (*GetServerSocketsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{24}
}
func (m *GetServerSocketsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServerSocketsResponse.Unmarshal(m, b)
}
func (m *GetServerSocketsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServerSocketsResponse.Marshal(b, m, deterministic)
}
func (dst *GetServerSocketsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServerSocketsResponse.Merge(dst, src)
}
func (m *GetServerSocketsResponse) XXX_Size() int {
	return xxx_messageInfo_GetServerSocketsResponse.Size(m)
}
func (m *GetServerSocketsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServerSocketsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetServerSocketsResponse proto.InternalMessageInfo

func (m *GetServerSocketsResponse) GetSocketRef() []*SocketRef {
	if m != nil {
		return m.SocketRef
	}
	return nil
}

func (m *GetServerSocketsResponse) GetEnd() bool {
	if m != nil {
		return m.End
	}
	return false
}

type GetChannelRequest struct {
	// channel_id is the identifier of the specific channel to get.
	ChannelId            int64    `protobuf:"varint,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetChannelRequest) Reset()         { *m = GetChannelRequest{} }
func (m *GetChannelRequest) String() string { return proto.CompactTextString(m) }
func (*GetChannelRequest) ProtoMessage()    {}
func (*GetChannelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{25}
}
func (m *GetChannelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetChannelRequest.Unmarshal(m, b)
}
func (m *GetChannelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetChannelRequest.Marshal(b, m, deterministic)
}
func (dst *GetChannelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetChannelRequest.Merge(dst, src)
}
func (m *GetChannelRequest) XXX_Size() int {
	return xxx_messageInfo_GetChannelRequest.Size(m)
}
func (m *GetChannelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetChannelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetChannelRequest proto.InternalMessageInfo

func (m *GetChannelRequest) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

type GetChannelResponse struct {
	// The Channel that corresponds to the requested channel_id.  This field
	// should be set.
	Channel              *Channel `protobuf:"bytes,1,opt,name=channel" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetChannelResponse) Reset()         { *m = GetChannelResponse{} }
func (m *GetChannelResponse) String() string { return proto.CompactTextString(m) }
func (*GetChannelResponse) ProtoMessage()    {}
func (*GetChannelResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{26}
}
func (m *GetChannelResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetChannelResponse.Unmarshal(m, b)
}
func (m *GetChannelResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetChannelResponse.Marshal(b, m, deterministic)
}
func (dst *GetChannelResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetChannelResponse.Merge(dst, src)
}
func (m *GetChannelResponse) XXX_Size() int {
	return xxx_messageInfo_GetChannelResponse.Size(m)
}
func (m *GetChannelResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetChannelResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetChannelResponse proto.InternalMessageInfo

func (m *GetChannelResponse) GetChannel() *Channel {
	if m != nil {
		return m.Channel
	}
	return nil
}

type GetSubchannelRequest struct {
	// subchannel_id is the identifier of the specific subchannel to get.
	SubchannelId         int64    `protobuf:"varint,1,opt,name=subchannel_id,json=subchannelId" json:"subchannel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSubchannelRequest) Reset()         { *m = GetSubchannelRequest{} }
func (m *GetSubchannelRequest) String() string { return proto.CompactTextString(m) }
func (*GetSubchannelRequest) ProtoMessage()    {}
func (*GetSubchannelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{27}
}
func (m *GetSubchannelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSubchannelRequest.Unmarshal(m, b)
}
func (m *GetSubchannelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSubchannelRequest.Marshal(b, m, deterministic)
}
func (dst *GetSubchannelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSubchannelRequest.Merge(dst, src)
}
func (m *GetSubchannelRequest) XXX_Size() int {
	return xxx_messageInfo_GetSubchannelRequest.Size(m)
}
func (m *GetSubchannelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSubchannelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSubchannelRequest proto.InternalMessageInfo

func (m *GetSubchannelRequest) GetSubchannelId() int64 {
	if m != nil {
		return m.SubchannelId
	}
	return 0
}

type GetSubchannelResponse struct {
	// The Subchannel that corresponds to the requested subchannel_id.  This
	// field should be set.
	Subchannel           *Subchannel `protobuf:"bytes,1,opt,name=subchannel" json:"subchannel,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GetSubchannelResponse) Reset()         { *m = GetSubchannelResponse{} }
func (m *GetSubchannelResponse) String() string { return proto.CompactTextString(m) }
func (*GetSubchannelResponse) ProtoMessage()    {}
func (*GetSubchannelResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{28}
}
func (m *GetSubchannelResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSubchannelResponse.Unmarshal(m, b)
}
func (m *GetSubchannelResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSubchannelResponse.Marshal(b, m, deterministic)
}
func (dst *GetSubchannelResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSubchannelResponse.Merge(dst, src)
}
func (m *GetSubchannelResponse) XXX_Size() int {
	return xxx_messageInfo_GetSubchannelResponse.Size(m)
}
func (m *GetSubchannelResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSubchannelResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetSubchannelResponse proto.InternalMessageInfo

func (m *GetSubchannelResponse) GetSubchannel() *Subchannel {
	if m != nil {
		return m.Subchannel
	}
	return nil
}

type GetSocketRequest struct {
	// socket_id is the identifier of the specific socket to get.
	SocketId             int64    `protobuf:"varint,1,opt,name=socket_id,json=socketId" json:"socket_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSocketRequest) Reset()         { *m = GetSocketRequest{} }
func (m *GetSocketRequest) String() string { return proto.CompactTextString(m) }
func (*GetSocketRequest) ProtoMessage()    {}
func (*GetSocketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{29}
}
func (m *GetSocketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSocketRequest.Unmarshal(m, b)
}
func (m *GetSocketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSocketRequest.Marshal(b, m, deterministic)
}
func (dst *GetSocketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSocketRequest.Merge(dst, src)
}
func (m *GetSocketRequest) XXX_Size() int {
	return xxx_messageInfo_GetSocketRequest.Size(m)
}
func (m *GetSocketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSocketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSocketRequest proto.InternalMessageInfo

func (m *GetSocketRequest) GetSocketId() int64 {
	if m != nil {
		return m.SocketId
	}
	return 0
}

type GetSocketResponse struct {
	// The Socket that corresponds to the requested socket_id.  This field
	// should be set.
	Socket               *Socket  `protobuf:"bytes,1,opt,name=socket" json:"socket,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSocketResponse) Reset()         { *m = GetSocketResponse{} }
func (m *GetSocketResponse) String() string { return proto.CompactTextString(m) }
func (*GetSocketResponse) ProtoMessage()    {}
func (*GetSocketResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_channelz_544d5edb3d49afb2, []int{30}
}
func (m *GetSocketResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSocketResponse.Unmarshal(m, b)
}
func (m *GetSocketResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSocketResponse.Marshal(b, m, deterministic)
}
func (dst *GetSocketResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSocketResponse.Merge(dst, src)
}
func (m *GetSocketResponse) XXX_Size() int {
	return xxx_messageInfo_GetSocketResponse.Size(m)
}
func (m *GetSocketResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSocketResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetSocketResponse proto.InternalMessageInfo

func (m *GetSocketResponse) GetSocket() *Socket {
	if m != nil {
		return m.Socket
	}
	return nil
}

func init() {
	proto.RegisterType((*Channel)(nil), "grpc.channelz.v1.Channel")
	proto.RegisterType((*Subchannel)(nil), "grpc.channelz.v1.Subchannel")
	proto.RegisterType((*ChannelConnectivityState)(nil), "grpc.channelz.v1.ChannelConnectivityState")
	proto.RegisterType((*ChannelData)(nil), "grpc.channelz.v1.ChannelData")
	proto.RegisterType((*ChannelTrace)(nil), "grpc.channelz.v1.ChannelTrace")
	proto.RegisterType((*ChannelRef)(nil), "grpc.channelz.v1.ChannelRef")
	proto.RegisterType((*SubchannelRef)(nil), "grpc.channelz.v1.SubchannelRef")
	proto.RegisterType((*SocketRef)(nil), "grpc.channelz.v1.SocketRef")
	proto.RegisterType((*ServerRef)(nil), "grpc.channelz.v1.ServerRef")
	proto.RegisterType((*Server)(nil), "grpc.channelz.v1.Server")
	proto.RegisterType((*ServerData)(nil), "grpc.channelz.v1.ServerData")
	proto.RegisterType((*Socket)(nil), "grpc.channelz.v1.Socket")
	proto.RegisterType((*SocketData)(nil), "grpc.channelz.v1.SocketData")
	proto.RegisterType((*Address)(nil), "grpc.channelz.v1.Address")
	proto.RegisterType((*Address_TcpIpAddress)(nil), "grpc.channelz.v1.Address.TcpIpAddress")
	proto.RegisterType((*Address_UdsAddress)(nil), "grpc.channelz.v1.Address.UdsAddress")
	proto.RegisterType((*Address_OtherAddress)(nil), "grpc.channelz.v1.Address.OtherAddress")
	proto.RegisterType((*Security)(nil), "grpc.channelz.v1.Security")
	proto.RegisterType((*Security_Tls)(nil), "grpc.channelz.v1.Security.Tls")
	proto.RegisterType((*Security_OtherSecurity)(nil), "grpc.channelz.v1.Security.OtherSecurity")
	proto.RegisterType((*SocketOption)(nil), "grpc.channelz.v1.SocketOption")
	proto.RegisterType((*SocketOptionTimeout)(nil), "grpc.channelz.v1.SocketOptionTimeout")
	proto.RegisterType((*SocketOptionLinger)(nil), "grpc.channelz.v1.SocketOptionLinger")
	proto.RegisterType((*SocketOptionTcpInfo)(nil), "grpc.channelz.v1.SocketOptionTcpInfo")
	proto.RegisterType((*GetTopChannelsRequest)(nil), "grpc.channelz.v1.GetTopChannelsRequest")
	proto.RegisterType((*GetTopChannelsResponse)(nil), "grpc.channelz.v1.GetTopChannelsResponse")
	proto.RegisterType((*GetServersRequest)(nil), "grpc.channelz.v1.GetServersRequest")
	proto.RegisterType((*GetServersResponse)(nil), "grpc.channelz.v1.GetServersResponse")
	proto.RegisterType((*GetServerSocketsRequest)(nil), "grpc.channelz.v1.GetServerSocketsRequest")
	proto.RegisterType((*GetServerSocketsResponse)(nil), "grpc.channelz.v1.GetServerSocketsResponse")
	proto.RegisterType((*GetChannelRequest)(nil), "grpc.channelz.v1.GetChannelRequest")
	proto.RegisterType((*GetChannelResponse)(nil), "grpc.channelz.v1.GetChannelResponse")
	proto.RegisterType((*GetSubchannelRequest)(nil), "grpc.channelz.v1.GetSubchannelRequest")
	proto.RegisterType((*GetSubchannelResponse)(nil), "grpc.channelz.v1.GetSubchannelResponse")
	proto.RegisterType((*GetSocketRequest)(nil), "grpc.channelz.v1.GetSocketRequest")
	proto.RegisterType((*GetSocketResponse)(nil), "grpc.channelz.v1.GetSocketResponse")
	proto.RegisterEnum("grpc.channelz.v1.ChannelConnectivityState_State", ChannelConnectivityState_State_name, ChannelConnectivityState_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Channelz service

type ChannelzClient interface {
	// Gets all root channels (i.e. channels the application has directly
	// created). This does not include subchannels nor non-top level channels.
	GetTopChannels(ctx context.Context, in *GetTopChannelsRequest, opts ...grpc.CallOption) (*GetTopChannelsResponse, error)
	// Gets all servers that exist in the process.
	GetServers(ctx context.Context, in *GetServersRequest, opts ...grpc.CallOption) (*GetServersResponse, error)
	// Gets all server sockets that exist in the process.
	GetServerSockets(ctx context.Context, in *GetServerSocketsRequest, opts ...grpc.CallOption) (*GetServerSocketsResponse, error)
	// Returns a single Channel, or else a NOT_FOUND code.
	GetChannel(ctx context.Context, in *GetChannelRequest, opts ...grpc.CallOption) (*GetChannelResponse, error)
	// Returns a single Subchannel, or else a NOT_FOUND code.
	GetSubchannel(ctx context.Context, in *GetSubchannelRequest, opts ...grpc.CallOption) (*GetSubchannelResponse, error)
	// Returns a single Socket or else a NOT_FOUND code.
	GetSocket(ctx context.Context, in *GetSocketRequest, opts ...grpc.CallOption) (*GetSocketResponse, error)
}

type channelzClient struct {
	cc *grpc.ClientConn
}

func NewChannelzClient(cc *grpc.ClientConn) ChannelzClient {
	return &channelzClient{cc}
}

func (c *channelzClient) GetTopChannels(ctx context.Context, in *GetTopChannelsRequest, opts ...grpc.CallOption) (*GetTopChannelsResponse, error) {
	out := new(GetTopChannelsResponse)
	err := grpc.Invoke(ctx, "/grpc.channelz.v1.Channelz/GetTopChannels", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *channelzClient) GetServers(ctx context.Context, in *GetServersRequest, opts ...grpc.CallOption) (*GetServersResponse, error) {
	out := new(GetServersResponse)
	err := grpc.Invoke(ctx, "/grpc.channelz.v1.Channelz/GetServers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *channelzClient) GetServerSockets(ctx context.Context, in *GetServerSocketsRequest, opts ...grpc.CallOption) (*GetServerSocketsResponse, error) {
	out := new(GetServerSocketsResponse)
	err := grpc.Invoke(ctx, "/grpc.channelz.v1.Channelz/GetServerSockets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *channelzClient) GetChannel(ctx context.Context, in *GetChannelRequest, opts ...grpc.CallOption) (*GetChannelResponse, error) {
	out := new(GetChannelResponse)
	err := grpc.Invoke(ctx, "/grpc.channelz.v1.Channelz/GetChannel", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *channelzClient) GetSubchannel(ctx context.Context, in *GetSubchannelRequest, opts ...grpc.CallOption) (*GetSubchannelResponse, error) {
	out := new(GetSubchannelResponse)
	err := grpc.Invoke(ctx, "/grpc.channelz.v1.Channelz/GetSubchannel", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *channelzClient) GetSocket(ctx context.Context, in *GetSocketRequest, opts ...grpc.CallOption) (*GetSocketResponse, error) {
	out := new(GetSocketResponse)
	err := grpc.Invoke(ctx, "/grpc.channelz.v1.Channelz/GetSocket", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Channelz service

type ChannelzServer interface {
	// Gets all root channels (i.e. channels the application has directly
	// created). This does not include subchannels nor non-top level channels.
	GetTopChannels(context.Context, *GetTopChannelsRequest) (*GetTopChannelsResponse, error)
	// Gets all servers that exist in the process.
	GetServers(context.Context, *GetServersRequest) (*GetServersResponse, error)
	// Gets all server sockets that exist in the process.
	GetServerSockets(context.Context, *GetServerSocketsRequest) (*GetServerSocketsResponse, error)
	// Returns a single Channel, or else a NOT_FOUND code.
	GetChannel(context.Context, *GetChannelRequest) (*GetChannelResponse, error)
	// Returns a single Subchannel, or else a NOT_FOUND code.
	GetSubchannel(context.Context, *GetSubchannelRequest) (*GetSubchannelResponse, error)
	// Returns a single Socket or else a NOT_FOUND code.
	GetSocket(context.Context, *GetSocketRequest) (*GetSocketResponse, error)
}

func RegisterChannelzServer(s *grpc.Server, srv ChannelzServer) {
	s.RegisterService(&_Channelz_serviceDesc, srv)
}

func _Channelz_GetTopChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChannelzServer).GetTopChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.channelz.v1.Channelz/GetTopChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChannelzServer).GetTopChannels(ctx, req.(*GetTopChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Channelz_GetServers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChannelzServer).GetServers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.channelz.v1.Channelz/GetServers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChannelzServer).GetServers(ctx, req.(*GetServersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Channelz_GetServerSockets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerSocketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChannelzServer).GetServerSockets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.channelz.v1.Channelz/GetServerSockets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChannelzServer).GetServerSockets(ctx, req.(*GetServerSocketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Channelz_GetChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChannelzServer).GetChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.channelz.v1.Channelz/GetChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChannelzServer).GetChannel(ctx, req.(*GetChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Channelz_GetSubchannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubchannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChannelzServer).GetSubchannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.channelz.v1.Channelz/GetSubchannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChannelzServer).GetSubchannel(ctx, req.(*GetSubchannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Channelz_GetSocket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSocketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChannelzServer).GetSocket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.channelz.v1.Channelz/GetSocket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChannelzServer).GetSocket(ctx, req.(*GetSocketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Channelz_serviceDesc = grpc.ServiceDesc{
	ServiceName: "grpc.channelz.v1.Channelz",
	HandlerType: (*ChannelzServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTopChannels",
			Handler:    _Channelz_GetTopChannels_Handler,
		},
		{
			MethodName: "GetServers",
			Handler:    _Channelz_GetServers_Handler,
		},
		{
			MethodName: "GetServerSockets",
			Handler:    _Channelz_GetServerSockets_Handler,
		},
		{
			MethodName: "GetChannel",
			Handler:    _Channelz_GetChannel_Handler,
		},
		{
			MethodName: "GetSubchannel",
			Handler:    _Channelz_GetSubchannel_Handler,
		},
		{
			MethodName: "GetSocket",
			Handler:    _Channelz_GetSocket_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "channelz.proto",
}

func init() { proto.RegisterFile("channelz.proto", fileDescriptor_channelz_544d5edb3d49afb2) }

var fileDescriptor_channelz_544d5edb3d49afb2 = []byte{
	// 2317 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x59, 0xcd, 0x6f, 0xdb, 0xc8,
	0x15, 0x8f, 0xbe, 0x2c, 0xea, 0x59, 0x52, 0xe8, 0x49, 0x36, 0x4b, 0x2b, 0x1f, 0x4e, 0x99, 0x6c,
	0xe2, 0xcd, 0x22, 0x72, 0xe2, 0x4d, 0x73, 0xe8, 0xb6, 0xc0, 0x2a, 0x8a, 0x9d, 0xd8, 0x75, 0x9c,
	0x80, 0x92, 0x37, 0xd9, 0x1e, 0x96, 0x3b, 0x21, 0x47, 0x36, 0x6b, 0x8a, 0x54, 0x39, 0x23, 0x19,
	0xc9, 0xb5, 0xf7, 0x1e, 0xfb, 0x27, 0xf4, 0xd2, 0x43, 0x81, 0x02, 0x05, 0xda, 0x6b, 0xd1, 0x7f,
	0xa6, 0xff, 0x45, 0x31, 0x1f, 0x24, 0x47, 0x96, 0x64, 0x3b, 0xc8, 0xb1, 0x17, 0x43, 0x7c, 0xfc,
	0xbd, 0xdf, 0x7b, 0xf3, 0xbe, 0x38, 0x33, 0x86, 0xa6, 0x77, 0x84, 0xa3, 0x88, 0x84, 0x1f, 0xdb,
	0xa3, 0x24, 0x66, 0x31, 0x32, 0x0f, 0x93, 0x91, 0xd7, 0xce, 0x84, 0x93, 0xc7, 0xad, 0xd5, 0xc3,
	0x38, 0x3e, 0x0c, 0xc9, 0x86, 0x78, 0xff, 0x7e, 0x3c, 0xd8, 0xc0, 0xd1, 0x07, 0x09, 0x6e, 0xdd,
	0x3a, 0xfd, 0xca, 0x1f, 0x27, 0x98, 0x05, 0x71, 0xa4, 0xde, 0xaf, 0x9d, 0x7e, 0xcf, 0x82, 0x21,
	0xa1, 0x0c, 0x0f, 0x47, 0x8b, 0x08, 0x4e, 0x12, 0x3c, 0x1a, 0x91, 0x84, 0xca, 0xf7, 0xf6, 0xdf,
	0x8a, 0x50, 0xed, 0x4a, 0x5f, 0x50, 0x1b, 0x4a, 0x09, 0x19, 0x58, 0x85, 0xdb, 0x85, 0xf5, 0xe5,
	0xcd, 0x1b, 0xed, 0xd3, 0x7e, 0xb6, 0x15, 0xce, 0x21, 0x03, 0x87, 0x03, 0xd1, 0x63, 0x28, 0xfb,
	0x98, 0x61, 0xab, 0x28, 0x14, 0x6e, 0x2e, 0x54, 0x78, 0x8e, 0x19, 0x76, 0x04, 0x14, 0xfd, 0x06,
	0x96, 0x15, 0xc0, 0xe5, 0xa6, 0x4a, 0xb7, 0x4b, 0xe7, 0x9a, 0x02, 0x2f, 0xfb, 0x8d, 0xb6, 0xa1,
	0x49, 0xc7, 0xef, 0x75, 0x86, 0xb2, 0x60, 0x58, 0x9b, 0x65, 0xe8, 0x65, 0x38, 0x4e, 0xd2, 0xa0,
	0xfa, 0x23, 0xfa, 0x15, 0x00, 0x8d, 0xbd, 0x63, 0xc2, 0x04, 0x47, 0x45, 0x70, 0x5c, 0x9f, 0xc3,
	0x21, 0x30, 0x5c, 0xbf, 0x46, 0xd3, 0x9f, 0xf6, 0x3f, 0x8a, 0x00, 0x39, 0x39, 0x7a, 0xac, 0x07,
	0xed, 0x5c, 0x3f, 0xfe, 0x8f, 0xe3, 0xf6, 0xef, 0x02, 0x58, 0xca, 0xbd, 0x6e, 0x1c, 0x45, 0xc4,
	0x63, 0xc1, 0x24, 0x60, 0x1f, 0x7a, 0x0c, 0x33, 0x82, 0xb6, 0xa1, 0x42, 0xf9, 0x0f, 0x11, 0xc7,
	0xe6, 0xe6, 0xa3, 0x85, 0x2b, 0x9b, 0x51, 0x6d, 0x8b, 0xbf, 0x8e, 0x54, 0xb7, 0x7f, 0x82, 0x8a,
	0x24, 0x5c, 0x86, 0xea, 0xc1, 0xfe, 0x6f, 0xf7, 0x5f, 0xbf, 0xdd, 0x37, 0x2f, 0x21, 0x03, 0xca,
	0x3b, 0xcf, 0xf7, 0xb6, 0xcc, 0x02, 0x6a, 0x02, 0x74, 0x5f, 0xef, 0xef, 0x6f, 0x75, 0xfb, 0x3b,
	0xfb, 0x2f, 0xcc, 0x22, 0xaa, 0x41, 0xc5, 0xd9, 0xea, 0x3c, 0xff, 0xd1, 0x2c, 0xa1, 0x2f, 0x60,
	0xa5, 0xef, 0x74, 0xf6, 0x7b, 0x3b, 0x5b, 0xfb, 0x7d, 0x77, 0xbb, 0xb3, 0xb3, 0x77, 0xe0, 0x6c,
	0x99, 0x65, 0x54, 0x07, 0xa3, 0xf7, 0xf2, 0xa0, 0xff, 0x9c, 0x33, 0x55, 0xec, 0xff, 0x16, 0x61,
	0x59, 0xcb, 0x0e, 0xfa, 0x5e, 0xf7, 0x7b, 0x79, 0xf3, 0xc1, 0xc5, 0xfd, 0x56, 0x1e, 0xa3, 0x6b,
	0xb0, 0xc4, 0x70, 0x72, 0x48, 0x98, 0x28, 0x87, 0x9a, 0xa3, 0x9e, 0xd0, 0x13, 0xa8, 0xb0, 0x04,
	0x7b, 0xc4, 0x2a, 0x09, 0xe6, 0x5b, 0x0b, 0x99, 0xfb, 0x1c, 0xe5, 0x48, 0x30, 0xba, 0x03, 0x0d,
	0x0f, 0x87, 0x21, 0x75, 0x29, 0xc3, 0x09, 0x23, 0xbe, 0x55, 0xbe, 0x5d, 0x58, 0x2f, 0x39, 0x75,
	0x21, 0xec, 0x49, 0x19, 0xba, 0x0f, 0x97, 0x15, 0x68, 0xec, 0x79, 0x84, 0xf8, 0xc4, 0xb7, 0x2a,
	0x02, 0xd6, 0x94, 0xb0, 0x54, 0x8a, 0x7e, 0x01, 0x52, 0xd1, 0x1d, 0xe0, 0x20, 0x24, 0xbe, 0xb5,
	0x24, 0x50, 0xcb, 0x42, 0xb6, 0x2d, 0x44, 0xe8, 0x47, 0xb8, 0x1e, 0x62, 0xca, 0x5c, 0x2e, 0x4b,
	0x8d, 0xba, 0xd9, 0x10, 0xb2, 0xaa, 0xc2, 0xf9, 0x56, 0x5b, 0x4e, 0xa1, 0x76, 0x3a, 0x85, 0xda,
	0xfd, 0x14, 0xe1, 0x58, 0x5c, 0xbd, 0x8b, 0xc3, 0x50, 0x79, 0x97, 0xbd, 0xb1, 0x9b, 0x50, 0xd7,
	0x97, 0x68, 0x7b, 0x00, 0x79, 0x79, 0xa3, 0x9b, 0x90, 0x16, 0xb8, 0x1b, 0xf8, 0x22, 0xfc, 0x25,
	0xa7, 0xa6, 0x24, 0x3b, 0x3e, 0x42, 0x50, 0x8e, 0xf0, 0x90, 0xa8, 0xa0, 0x8a, 0xdf, 0xbb, 0x65,
	0xa3, 0x64, 0x96, 0x77, 0xcb, 0x46, 0xd9, 0xac, 0xec, 0x96, 0x8d, 0x8a, 0xb9, 0xb4, 0x5b, 0x36,
	0x96, 0xcc, 0xea, 0x6e, 0xd9, 0xa8, 0x9a, 0xc6, 0x6e, 0xd9, 0x30, 0xcc, 0x9a, 0x1d, 0x42, 0x63,
	0xaa, 0x03, 0x78, 0x44, 0xb5, 0xd6, 0x09, 0x7c, 0xb1, 0xa4, 0x92, 0x53, 0xcf, 0x85, 0x9a, 0x35,
	0x63, 0xca, 0x5a, 0xc1, 0x2c, 0xee, 0x96, 0x8d, 0xa2, 0x59, 0x5a, 0x64, 0xd9, 0xfe, 0x19, 0x6a,
	0x59, 0xaf, 0xa0, 0xeb, 0xa0, 0xba, 0x85, 0x5b, 0x29, 0x09, 0x2b, 0x86, 0x14, 0x68, 0x16, 0xca,
	0x0b, 0x2d, 0xcc, 0x5f, 0x0f, 0xb7, 0x40, 0x92, 0x09, 0x49, 0x52, 0x0b, 0xe2, 0x81, 0x5b, 0xa8,
	0x28, 0x0b, 0x42, 0xa0, 0x59, 0x58, 0xba, 0xd0, 0x1a, 0x72, 0x0b, 0x7f, 0x2d, 0xc0, 0x92, 0x34,
	0x81, 0x1e, 0xea, 0xb3, 0x70, 0xde, 0x5c, 0x48, 0x3d, 0x91, 0x73, 0xf0, 0xd1, 0xd4, 0x1c, 0xbc,
	0xb1, 0x08, 0xaf, 0x8d, 0xc1, 0xef, 0xa1, 0x11, 0x06, 0x94, 0x91, 0xc8, 0x95, 0x81, 0x51, 0x83,
	0xf0, 0xcc, 0x11, 0x54, 0x97, 0x1a, 0x52, 0x60, 0xff, 0x89, 0x4f, 0xef, 0x8c, 0x36, 0xef, 0xb2,
	0xc2, 0x67, 0x75, 0x59, 0xf1, 0x62, 0x5d, 0x56, 0xba, 0x50, 0x97, 0x95, 0x3f, 0xb9, 0xcb, 0x2a,
	0x9f, 0xd1, 0x65, 0x7f, 0x29, 0xc2, 0x92, 0x8c, 0xcd, 0xf9, 0xe9, 0xcb, 0x62, 0x7a, 0xc1, 0xf4,
	0x09, 0xbc, 0x96, 0xbe, 0x0d, 0xa8, 0x84, 0xb1, 0x87, 0x43, 0x35, 0xd3, 0x56, 0x67, 0x55, 0x3a,
	0xbe, 0x9f, 0x10, 0x4a, 0x1d, 0x89, 0x43, 0x8f, 0x61, 0x29, 0x21, 0xc3, 0x98, 0xc9, 0xba, 0x3f,
	0x53, 0x43, 0x01, 0xd1, 0x53, 0x30, 0x28, 0xf1, 0xc6, 0x49, 0xc0, 0x3e, 0xe4, 0x71, 0x99, 0x2d,
	0x2c, 0x89, 0x70, 0x32, 0x2c, 0x5a, 0x83, 0x65, 0xc9, 0xe0, 0x6a, 0x5d, 0x00, 0x52, 0xb4, 0x8f,
	0x87, 0xc4, 0xfe, 0x63, 0x15, 0x20, 0x5f, 0x11, 0x4f, 0x2f, 0x65, 0x09, 0xc1, 0xc3, 0xbc, 0x0a,
	0xe4, 0x10, 0x6a, 0x2a, 0x71, 0x5a, 0x07, 0xdf, 0xc0, 0x4a, 0x06, 0xcc, 0x2a, 0x41, 0x16, 0x8c,
	0x99, 0x42, 0xb3, 0x5a, 0xf8, 0x0a, 0x52, 0xf5, 0xb4, 0x1a, 0x64, 0xcd, 0x34, 0x94, 0x54, 0xd5,
	0xc3, 0x1d, 0x68, 0x0c, 0x09, 0xa5, 0xf8, 0x90, 0x50, 0x97, 0x92, 0x88, 0xa5, 0x63, 0x3e, 0x15,
	0xf6, 0x48, 0xc4, 0xb8, 0xe1, 0x0c, 0x94, 0x10, 0x8f, 0x04, 0x93, 0x6c, 0xd0, 0x9b, 0xe9, 0x0b,
	0x47, 0xc9, 0xd1, 0x3a, 0x98, 0xc7, 0x84, 0x8c, 0x5c, 0x1c, 0x06, 0x93, 0x94, 0x54, 0x8e, 0xfb,
	0x26, 0x97, 0x77, 0x84, 0x58, 0xd0, 0x1e, 0xc1, 0x1d, 0x51, 0x8b, 0x22, 0x43, 0xae, 0xf4, 0xcb,
	0xf5, 0x12, 0x82, 0x3f, 0x75, 0xf2, 0xaf, 0x71, 0x9a, 0x3d, 0xce, 0xd2, 0x13, 0x24, 0x5d, 0xc9,
	0x91, 0x01, 0xd0, 0xef, 0xe1, 0xae, 0xb0, 0xa4, 0xf2, 0xb2, 0xd0, 0x94, 0x71, 0xae, 0xa9, 0xdb,
	0x9c, 0xc7, 0x11, 0x34, 0x0b, 0x6c, 0xa5, 0x1d, 0xa6, 0x02, 0x23, 0x02, 0xa0, 0x99, 0xa8, 0x5d,
	0xac, 0xc3, 0x5e, 0x49, 0x6d, 0x1e, 0xa7, 0x9c, 0x1a, 0xc3, 0xda, 0x14, 0x75, 0x9a, 0x0b, 0x8d,
	0x1e, 0xce, 0xa5, 0xbf, 0xa1, 0xd1, 0xa7, 0x49, 0xcb, 0x4d, 0xfc, 0x00, 0xab, 0x32, 0x1d, 0x83,
	0x30, 0x3e, 0x71, 0xbd, 0x38, 0x62, 0x49, 0x1c, 0xba, 0x27, 0x41, 0xe4, 0xc7, 0x27, 0xd6, 0x72,
	0xda, 0xcf, 0xa7, 0xc8, 0x77, 0x22, 0xf6, 0xf4, 0xc9, 0x0f, 0x38, 0x1c, 0x13, 0xe7, 0x9a, 0xd0,
	0xde, 0x0e, 0xe3, 0x93, 0xae, 0xd4, 0x7d, 0x2b, 0x54, 0xd1, 0x3b, 0x68, 0xa9, 0xe0, 0xcf, 0x23,
	0xae, 0x9f, 0x4f, 0xfc, 0xa5, 0x54, 0x9f, 0x65, 0x7e, 0x0a, 0x4b, 0xf1, 0x88, 0x1f, 0x64, 0xac,
	0x86, 0x18, 0xe1, 0xb7, 0x16, 0x8d, 0x8f, 0xd7, 0x02, 0xe5, 0x28, 0xb4, 0xfd, 0xcf, 0x12, 0x54,
	0x55, 0xcb, 0xa3, 0x57, 0xd0, 0x60, 0xde, 0x28, 0x18, 0xb9, 0x58, 0x0a, 0xd4, 0xe4, 0xba, 0xb7,
	0x70, 0x48, 0xb4, 0xfb, 0xde, 0x68, 0x67, 0xa4, 0x1e, 0x5e, 0x5e, 0x72, 0xea, 0x42, 0x3d, 0xa5,
	0x7b, 0x01, 0xcb, 0x63, 0x9f, 0x66, 0x64, 0x72, 0xac, 0xdd, 0x5d, 0x4c, 0x76, 0xe0, 0xd3, 0x9c,
	0x0a, 0xc6, 0xd9, 0x13, 0xf7, 0x2b, 0x66, 0x47, 0x24, 0xc9, 0xa8, 0x4a, 0xe7, 0xf9, 0xf5, 0x9a,
	0xc3, 0x35, 0xbf, 0x62, 0xed, 0xb9, 0xd5, 0x81, 0xba, 0xee, 0x37, 0xdf, 0xf9, 0x9c, 0x5a, 0x73,
	0xdd, 0xa9, 0xe5, 0xcb, 0x40, 0x50, 0x1e, 0xc5, 0x89, 0xdc, 0x4e, 0x56, 0x1c, 0xf1, 0xbb, 0xb5,
	0x0e, 0x90, 0x7b, 0x8b, 0x5a, 0x60, 0x0c, 0x82, 0x90, 0x88, 0x39, 0x57, 0x10, 0x73, 0x2e, 0x7b,
	0x6e, 0xed, 0x43, 0x5d, 0x77, 0x26, 0xdb, 0x15, 0x14, 0xf2, 0x5d, 0x01, 0x7a, 0x00, 0x95, 0x09,
	0xcf, 0xae, 0x0a, 0xd1, 0xd5, 0x99, 0x02, 0xe8, 0x44, 0x1f, 0x1c, 0x09, 0x79, 0x56, 0x83, 0xaa,
	0xf2, 0xd4, 0xfe, 0x73, 0x09, 0x8c, 0x74, 0xf0, 0xa2, 0x4d, 0x28, 0xb1, 0x90, 0x2e, 0xfe, 0xec,
	0xa6, 0xc0, 0x76, 0x3f, 0xe4, 0x11, 0xe1, 0x60, 0xbe, 0xd9, 0x16, 0x81, 0x51, 0x76, 0xd7, 0xcf,
	0xd0, 0x12, 0x6b, 0x48, 0x9f, 0x5e, 0x5e, 0x72, 0xa4, 0x62, 0xeb, 0x5f, 0x05, 0x28, 0xf5, 0x43,
	0x8a, 0xbe, 0x82, 0x06, 0x65, 0x38, 0xf2, 0x71, 0xe2, 0xbb, 0xf9, 0xf2, 0x78, 0xe4, 0x53, 0x31,
	0x1f, 0xf9, 0x68, 0x0d, 0x40, 0x26, 0x32, 0xdf, 0x4a, 0xbe, 0xbc, 0xe4, 0xd4, 0x84, 0x4c, 0x00,
	0xbe, 0x81, 0x15, 0xd9, 0x77, 0x1e, 0x49, 0x58, 0x30, 0x08, 0x3c, 0x7e, 0x14, 0x28, 0x89, 0x8c,
	0x98, 0xe2, 0x45, 0x37, 0x97, 0xa3, 0x87, 0x80, 0x54, 0x33, 0xe9, 0xe8, 0xb2, 0x40, 0xaf, 0xc8,
	0x37, 0x1a, 0xfc, 0x59, 0x13, 0xea, 0x5e, 0x30, 0xe2, 0xd6, 0xe9, 0x38, 0x60, 0xa4, 0xf5, 0x1a,
	0x1a, 0x53, 0xab, 0xfa, 0xec, 0xd4, 0x54, 0xa1, 0x32, 0x8c, 0x7d, 0x12, 0xda, 0x11, 0xd4, 0xf5,
	0x5e, 0x9b, 0x4b, 0x7c, 0x55, 0x27, 0xae, 0x29, 0x0a, 0xf4, 0x04, 0x00, 0xfb, 0x7e, 0xc0, 0xb5,
	0xb2, 0xaf, 0xfa, 0x7c, 0x9b, 0x1a, 0xce, 0xde, 0x83, 0x2b, 0xba, 0x3d, 0x3e, 0xc6, 0xe2, 0x31,
	0x43, 0xbf, 0x04, 0x23, 0xbd, 0xdd, 0x50, 0x75, 0xb1, 0x3a, 0x43, 0xf5, 0x5c, 0x01, 0x9c, 0x0c,
	0x6a, 0x7b, 0x80, 0x74, 0xb6, 0xbd, 0x20, 0x3a, 0x24, 0x09, 0x3f, 0x56, 0x61, 0x7e, 0xdc, 0x92,
	0xab, 0x30, 0x1c, 0xf5, 0x34, 0x65, 0xa4, 0x78, 0x71, 0x23, 0x7f, 0x37, 0x4e, 0xf9, 0xec, 0x8d,
	0x76, 0xa2, 0x41, 0xcc, 0x7b, 0x91, 0xcf, 0x10, 0x37, 0x3f, 0x04, 0x36, 0x9c, 0x1a, 0x97, 0xc8,
	0x53, 0xa8, 0x2d, 0x27, 0x94, 0xeb, 0x61, 0x85, 0x28, 0x0a, 0xc4, 0x32, 0x17, 0x76, 0xb1, 0xc4,
	0x7c, 0x0d, 0xa6, 0xc0, 0x24, 0x84, 0x25, 0x38, 0xa2, 0xc3, 0x80, 0xc9, 0x81, 0xd1, 0x70, 0x2e,
	0x73, 0xb9, 0x93, 0x8b, 0xf9, 0x1e, 0x45, 0x40, 0x47, 0x49, 0xfc, 0x9e, 0x50, 0x51, 0x3a, 0x0d,
	0x47, 0x38, 0xf0, 0x46, 0x48, 0xf8, 0x56, 0x52, 0x00, 0xde, 0x63, 0xef, 0x38, 0x1e, 0x0c, 0xc4,
	0xd7, 0x5e, 0x99, 0x7b, 0x26, 0x45, 0x19, 0x44, 0xce, 0x53, 0x2a, 0x3e, 0xf2, 0x0a, 0x22, 0x97,
	0x46, 0xd1, 0x3d, 0xb8, 0x2c, 0x17, 0x15, 0xf9, 0xee, 0x09, 0xf5, 0x70, 0x48, 0xc4, 0xd7, 0xbc,
	0xe1, 0x88, 0xc5, 0xf4, 0x22, 0xff, 0xad, 0x10, 0x66, 0xb8, 0xc4, 0x9b, 0xa4, 0x38, 0x23, 0xc7,
	0x39, 0xde, 0x44, 0xe1, 0x56, 0xc1, 0x90, 0x38, 0x16, 0x8b, 0x0f, 0x69, 0xc3, 0xa9, 0x0a, 0x00,
	0x8b, 0xb3, 0x57, 0x98, 0xc5, 0xe2, 0x23, 0xa8, 0x5e, 0x75, 0x58, 0x8c, 0x6e, 0x2b, 0x47, 0xb9,
	0x17, 0x43, 0x4a, 0xc5, 0x67, 0x4c, 0xad, 0xb6, 0x17, 0xf9, 0xaf, 0x28, 0xcd, 0x10, 0xdc, 0x3e,
	0x47, 0xd4, 0x73, 0x84, 0xe3, 0x4d, 0x38, 0x22, 0x5d, 0xec, 0x38, 0xc2, 0xde, 0x31, 0xf1, 0xad,
	0x46, 0xbe, 0xd8, 0x03, 0x29, 0xca, 0x62, 0x4a, 0x25, 0xa2, 0xa9, 0x59, 0x91, 0x80, 0xeb, 0x20,
	0x12, 0xea, 0x86, 0x31, 0x65, 0xd6, 0x65, 0xf1, 0x5a, 0xf8, 0xbc, 0x17, 0x53, 0x96, 0x19, 0x50,
	0xc9, 0xb3, 0xcc, 0xdc, 0x80, 0x4a, 0x5c, 0x06, 0x19, 0x70, 0x3a, 0x46, 0xad, 0x95, 0x1c, 0xb2,
	0x2d, 0x45, 0xe8, 0x21, 0x5c, 0x91, 0x26, 0xf8, 0x36, 0x81, 0xef, 0x94, 0xe5, 0xfe, 0x0b, 0x09,
	0xa4, 0xa8, 0x8e, 0x3d, 0x4c, 0xc5, 0xb6, 0x53, 0x6d, 0xec, 0x50, 0x0e, 0xc7, 0xde, 0xb1, 0x44,
	0x5f, 0xc9, 0x6b, 0x86, 0xa3, 0x3b, 0xde, 0xb1, 0x00, 0xcf, 0x72, 0x27, 0xc4, 0x9b, 0x58, 0x57,
	0x67, 0xb9, 0x1d, 0xe2, 0x4d, 0x66, 0xb9, 0x05, 0xfa, 0x8b, 0x19, 0x6e, 0x01, 0x4e, 0x43, 0x33,
	0x1a, 0xb2, 0xb1, 0x75, 0x2d, 0x0f, 0xcd, 0x9b, 0x21, 0x1b, 0xa3, 0x07, 0xb0, 0x92, 0x65, 0x87,
	0x52, 0x76, 0x94, 0x10, 0x7a, 0x64, 0x7d, 0xa9, 0x15, 0xb6, 0x37, 0xe9, 0x29, 0xb1, 0x56, 0x21,
	0xcc, 0xb2, 0xf4, 0x0a, 0x61, 0x59, 0x7e, 0x12, 0xc6, 0x26, 0x38, 0xb1, 0x56, 0xb5, 0x1c, 0x0b,
	0x49, 0x66, 0x87, 0xd7, 0x49, 0x66, 0xa7, 0x95, 0xdb, 0xe9, 0x45, 0x7e, 0x66, 0x27, 0xed, 0x47,
	0x8e, 0xf5, 0x4e, 0x22, 0xdf, 0xba, 0x9e, 0x27, 0xa3, 0x17, 0xf9, 0xdd, 0x93, 0x28, 0x2f, 0x08,
	0xec, 0x4f, 0x78, 0x51, 0xdd, 0xc8, 0x0d, 0x76, 0x84, 0x84, 0xef, 0xfc, 0x55, 0xce, 0xe3, 0xc4,
	0x27, 0x49, 0x10, 0x1d, 0x5a, 0x37, 0x05, 0xa8, 0x29, 0xd3, 0x9e, 0x4a, 0xed, 0x0e, 0x7c, 0xf1,
	0x82, 0xb0, 0x7e, 0x3c, 0x52, 0x67, 0x48, 0xea, 0x90, 0x3f, 0x8c, 0x09, 0x65, 0x7c, 0xb3, 0x2d,
	0xce, 0x0c, 0xee, 0xcc, 0x0d, 0x46, 0x53, 0xc8, 0xbb, 0xe9, 0xc5, 0x82, 0xed, 0xc2, 0xb5, 0xd3,
	0x14, 0x74, 0x14, 0x47, 0x94, 0xa0, 0x6f, 0xa1, 0xaa, 0xb4, 0xad, 0x82, 0xd8, 0x41, 0xad, 0x2e,
	0xbe, 0x0d, 0x4c, 0x91, 0xc8, 0x84, 0x12, 0x89, 0xe4, 0xe9, 0xc3, 0x70, 0xf8, 0x4f, 0xfb, 0x3b,
	0x58, 0x79, 0x41, 0x98, 0x3c, 0x11, 0x67, 0xfe, 0xdd, 0xe3, 0x67, 0x1b, 0xee, 0x5f, 0x7e, 0x5b,
	0x50, 0x48, 0x8f, 0x21, 0x38, 0x51, 0xe8, 0x1d, 0xdf, 0x7e, 0x07, 0x48, 0x57, 0x56, 0x9e, 0x3d,
	0x82, 0x25, 0xa9, 0xa7, 0x1c, 0xb3, 0x16, 0x5e, 0x04, 0x28, 0xdc, 0x1c, 0xb7, 0x7e, 0x82, 0x2f,
	0x33, 0x66, 0x39, 0x77, 0x33, 0xe7, 0xa6, 0x2e, 0x31, 0x0a, 0xa7, 0x2e, 0x31, 0x72, 0xcf, 0xb3,
	0x9b, 0x94, 0xa2, 0xee, 0xb9, 0xba, 0x4e, 0xb1, 0x8f, 0xc0, 0x9a, 0xe5, 0x57, 0xfe, 0x4f, 0x5f,
	0x72, 0x16, 0x3e, 0xe5, 0x92, 0x73, 0xce, 0x4a, 0x36, 0x45, 0x80, 0xb3, 0x8b, 0x2b, 0xb9, 0x86,
	0xb3, 0x2f, 0xaf, 0xec, 0x1d, 0x11, 0xd7, 0x4c, 0x67, 0x5e, 0xc6, 0x0b, 0x17, 0xcb, 0xb8, 0xfd,
	0x1d, 0x5c, 0xe5, 0x0b, 0xd5, 0xae, 0xb4, 0xa4, 0x07, 0x33, 0xd7, 0x5a, 0x85, 0xd9, 0x6b, 0x2d,
	0xfb, 0x40, 0x14, 0xb0, 0xae, 0xac, 0x5c, 0xf9, 0x35, 0x40, 0x0e, 0x5c, 0xfc, 0x0f, 0x03, 0x4d,
	0x53, 0xc3, 0xdb, 0x1b, 0x60, 0x72, 0x5a, 0x15, 0xb4, 0x3c, 0xab, 0x59, 0xca, 0x0a, 0xd3, 0x97,
	0x5f, 0xf6, 0x96, 0x2c, 0x52, 0xa5, 0xa0, 0x95, 0x99, 0xbc, 0x04, 0x92, 0xf6, 0xad, 0x85, 0x29,
	0x52, 0xb8, 0xcd, 0xff, 0x94, 0xc1, 0x50, 0x01, 0xfa, 0x88, 0x3c, 0x68, 0x4e, 0x77, 0x16, 0xba,
	0x3f, 0x4b, 0x30, 0xb7, 0x7d, 0x5b, 0xeb, 0xe7, 0x03, 0x95, 0x8f, 0x6f, 0x01, 0xf2, 0x06, 0x41,
	0x77, 0xe6, 0xea, 0x4d, 0xf7, 0x5e, 0xeb, 0xee, 0xd9, 0x20, 0x45, 0x1c, 0xc8, 0x10, 0xea, 0xf5,
	0x8b, 0xbe, 0x3e, 0x43, 0x73, 0xba, 0x87, 0x5a, 0x0f, 0x2e, 0x02, 0x9d, 0x5a, 0x43, 0xfa, 0x3f,
	0xa2, 0xf9, 0x6b, 0x98, 0x2e, 0xef, 0x05, 0x6b, 0x38, 0x5d, 0xcf, 0x3f, 0x43, 0x63, 0xaa, 0xba,
	0xd0, 0xbd, 0xf9, 0x5e, 0x9d, 0xae, 0xdd, 0xd6, 0xfd, 0x73, 0x71, 0xca, 0x42, 0x1f, 0x6a, 0x59,
	0xdd, 0x20, 0x7b, 0xbe, 0x96, 0x5e, 0x85, 0xad, 0x3b, 0x67, 0x62, 0x24, 0xeb, 0xb3, 0x77, 0x70,
	0x25, 0x88, 0x67, 0x80, 0xcf, 0x1a, 0x69, 0x69, 0xbd, 0xe1, 0xfb, 0xc8, 0x37, 0x85, 0xdf, 0x3d,
	0x52, 0xfb, 0xca, 0xc3, 0x38, 0xc4, 0xd1, 0x61, 0x3b, 0x4e, 0x0e, 0x37, 0xb8, 0xd2, 0x46, 0xaa,
	0x24, 0x9e, 0xd2, 0x4f, 0xc0, 0x47, 0x77, 0xf2, 0xf8, 0xfd, 0x92, 0xd8, 0x82, 0x7e, 0xfb, 0xbf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xce, 0xbe, 0x6e, 0x8a, 0x33, 0x1c, 0x00, 0x00,
}
