// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/privacy/dlp/v2/storage.proto

package dlp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Categorization of results based on how likely they are to represent a match,
// based on the number of elements they contain which imply a match.
type Likelihood int32

const (
	// Default value; information with all likelihoods is included.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Few matching elements.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	Likelihood_UNLIKELY      Likelihood = 2
	// Some matching elements.
	Likelihood_POSSIBLE Likelihood = 3
	Likelihood_LIKELY   Likelihood = 4
	// Many matching elements.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// Definitions of file type groups to scan.
type FileType int32

const (
	// Includes all files.
	FileType_FILE_TYPE_UNSPECIFIED FileType = 0
	// Includes all file extensions not covered by text file types.
	FileType_BINARY_FILE FileType = 1
	// Included file extensions:
	//   asc, brf, c, cc, cpp, csv, cxx, c++, cs, css, dart, eml, go, h, hh, hpp,
	//   hxx, h++, hs, html, htm, shtml, shtm, xhtml, lhs, ini, java, js, json,
	//   ocaml, md, mkd, markdown, m, ml, mli, pl, pm, php, phtml, pht, py, pyw,
	//   rb, rbw, rs, rc, scala, sh, sql, tex, txt, text, tsv, vcard, vcs, wml,
	//   xml, xsl, xsd, yml, yaml.
	FileType_TEXT_FILE FileType = 2
)

var FileType_name = map[int32]string{
	0: "FILE_TYPE_UNSPECIFIED",
	1: "BINARY_FILE",
	2: "TEXT_FILE",
}
var FileType_value = map[string]int32{
	"FILE_TYPE_UNSPECIFIED": 0,
	"BINARY_FILE":           1,
	"TEXT_FILE":             2,
}

func (x FileType) String() string {
	return proto.EnumName(FileType_name, int32(x))
}
func (FileType) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

// Type of information detected by the API.
type InfoType struct {
	// Name of the information type.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *InfoType) Reset()                    { *m = InfoType{} }
func (m *InfoType) String() string            { return proto.CompactTextString(m) }
func (*InfoType) ProtoMessage()               {}
func (*InfoType) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *InfoType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Custom information type provided by the user. Used to find domain-specific
// sensitive information configurable to the data in question.
type CustomInfoType struct {
	// Info type configuration. All custom info types must have configurations
	// that do not conflict with built-in info types or other custom info types.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Likelihood to return for this custom info type. This base value can be
	// altered by a detection rule if the finding meets the criteria specified by
	// the rule. Defaults to `VERY_LIKELY` if not specified.
	Likelihood Likelihood `protobuf:"varint,6,opt,name=likelihood,enum=google.privacy.dlp.v2.Likelihood" json:"likelihood,omitempty"`
	// Types that are valid to be assigned to Type:
	//	*CustomInfoType_Dictionary_
	//	*CustomInfoType_Regex_
	//	*CustomInfoType_SurrogateType_
	Type isCustomInfoType_Type `protobuf_oneof:"type"`
	// Set of detection rules to apply to all findings of this custom info type.
	// Rules are applied in order that they are specified. Not supported for the
	// `surrogate_type` custom info type.
	DetectionRules []*CustomInfoType_DetectionRule `protobuf:"bytes,7,rep,name=detection_rules,json=detectionRules" json:"detection_rules,omitempty"`
}

func (m *CustomInfoType) Reset()                    { *m = CustomInfoType{} }
func (m *CustomInfoType) String() string            { return proto.CompactTextString(m) }
func (*CustomInfoType) ProtoMessage()               {}
func (*CustomInfoType) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

type isCustomInfoType_Type interface {
	isCustomInfoType_Type()
}

type CustomInfoType_Dictionary_ struct {
	Dictionary *CustomInfoType_Dictionary `protobuf:"bytes,2,opt,name=dictionary,oneof"`
}
type CustomInfoType_Regex_ struct {
	Regex *CustomInfoType_Regex `protobuf:"bytes,3,opt,name=regex,oneof"`
}
type CustomInfoType_SurrogateType_ struct {
	SurrogateType *CustomInfoType_SurrogateType `protobuf:"bytes,4,opt,name=surrogate_type,json=surrogateType,oneof"`
}

func (*CustomInfoType_Dictionary_) isCustomInfoType_Type()    {}
func (*CustomInfoType_Regex_) isCustomInfoType_Type()         {}
func (*CustomInfoType_SurrogateType_) isCustomInfoType_Type() {}

func (m *CustomInfoType) GetType() isCustomInfoType_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *CustomInfoType) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *CustomInfoType) GetLikelihood() Likelihood {
	if m != nil {
		return m.Likelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *CustomInfoType) GetDictionary() *CustomInfoType_Dictionary {
	if x, ok := m.GetType().(*CustomInfoType_Dictionary_); ok {
		return x.Dictionary
	}
	return nil
}

func (m *CustomInfoType) GetRegex() *CustomInfoType_Regex {
	if x, ok := m.GetType().(*CustomInfoType_Regex_); ok {
		return x.Regex
	}
	return nil
}

func (m *CustomInfoType) GetSurrogateType() *CustomInfoType_SurrogateType {
	if x, ok := m.GetType().(*CustomInfoType_SurrogateType_); ok {
		return x.SurrogateType
	}
	return nil
}

func (m *CustomInfoType) GetDetectionRules() []*CustomInfoType_DetectionRule {
	if m != nil {
		return m.DetectionRules
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_OneofMarshaler, _CustomInfoType_OneofUnmarshaler, _CustomInfoType_OneofSizer, []interface{}{
		(*CustomInfoType_Dictionary_)(nil),
		(*CustomInfoType_Regex_)(nil),
		(*CustomInfoType_SurrogateType_)(nil),
	}
}

func _CustomInfoType_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_Dictionary_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Dictionary); err != nil {
			return err
		}
	case *CustomInfoType_Regex_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Regex); err != nil {
			return err
		}
	case *CustomInfoType_SurrogateType_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SurrogateType); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CustomInfoType.Type has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType)
	switch tag {
	case 2: // type.dictionary
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_Dictionary)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_Dictionary_{msg}
		return true, err
	case 3: // type.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_Regex)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_Regex_{msg}
		return true, err
	case 4: // type.surrogate_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_SurrogateType)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_SurrogateType_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_Dictionary_:
		s := proto.Size(x.Dictionary)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomInfoType_Regex_:
		s := proto.Size(x.Regex)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomInfoType_SurrogateType_:
		s := proto.Size(x.SurrogateType)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Custom information type based on a dictionary of words or phrases. This can
// be used to match sensitive information specific to the data, such as a list
// of employee IDs or job titles.
//
// Dictionary words are case-insensitive and all characters other than letters
// and digits in the unicode [Basic Multilingual
// Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
// will be replaced with whitespace when scanning for matches, so the
// dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
// "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
// surrounding any match must be of a different type than the adjacent
// characters within the word, so letters must be next to non-letters and
// digits next to non-digits. For example, the dictionary word "jen" will
// match the first three letters of the text "jen123" but will return no
// matches for "jennifer".
//
// Dictionary words containing a large number of characters that are not
// letters or digits may result in unexpected findings because such characters
// are treated as whitespace.
type CustomInfoType_Dictionary struct {
	// Types that are valid to be assigned to Source:
	//	*CustomInfoType_Dictionary_WordList_
	//	*CustomInfoType_Dictionary_CloudStoragePath
	Source isCustomInfoType_Dictionary_Source `protobuf_oneof:"source"`
}

func (m *CustomInfoType_Dictionary) Reset()                    { *m = CustomInfoType_Dictionary{} }
func (m *CustomInfoType_Dictionary) String() string            { return proto.CompactTextString(m) }
func (*CustomInfoType_Dictionary) ProtoMessage()               {}
func (*CustomInfoType_Dictionary) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1, 0} }

type isCustomInfoType_Dictionary_Source interface {
	isCustomInfoType_Dictionary_Source()
}

type CustomInfoType_Dictionary_WordList_ struct {
	WordList *CustomInfoType_Dictionary_WordList `protobuf:"bytes,1,opt,name=word_list,json=wordList,oneof"`
}
type CustomInfoType_Dictionary_CloudStoragePath struct {
	CloudStoragePath *CloudStoragePath `protobuf:"bytes,3,opt,name=cloud_storage_path,json=cloudStoragePath,oneof"`
}

func (*CustomInfoType_Dictionary_WordList_) isCustomInfoType_Dictionary_Source()        {}
func (*CustomInfoType_Dictionary_CloudStoragePath) isCustomInfoType_Dictionary_Source() {}

func (m *CustomInfoType_Dictionary) GetSource() isCustomInfoType_Dictionary_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *CustomInfoType_Dictionary) GetWordList() *CustomInfoType_Dictionary_WordList {
	if x, ok := m.GetSource().(*CustomInfoType_Dictionary_WordList_); ok {
		return x.WordList
	}
	return nil
}

func (m *CustomInfoType_Dictionary) GetCloudStoragePath() *CloudStoragePath {
	if x, ok := m.GetSource().(*CustomInfoType_Dictionary_CloudStoragePath); ok {
		return x.CloudStoragePath
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType_Dictionary) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_Dictionary_OneofMarshaler, _CustomInfoType_Dictionary_OneofUnmarshaler, _CustomInfoType_Dictionary_OneofSizer, []interface{}{
		(*CustomInfoType_Dictionary_WordList_)(nil),
		(*CustomInfoType_Dictionary_CloudStoragePath)(nil),
	}
}

func _CustomInfoType_Dictionary_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType_Dictionary)
	// source
	switch x := m.Source.(type) {
	case *CustomInfoType_Dictionary_WordList_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WordList); err != nil {
			return err
		}
	case *CustomInfoType_Dictionary_CloudStoragePath:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStoragePath); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CustomInfoType_Dictionary.Source has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_Dictionary_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType_Dictionary)
	switch tag {
	case 1: // source.word_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_Dictionary_WordList)
		err := b.DecodeMessage(msg)
		m.Source = &CustomInfoType_Dictionary_WordList_{msg}
		return true, err
	case 3: // source.cloud_storage_path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStoragePath)
		err := b.DecodeMessage(msg)
		m.Source = &CustomInfoType_Dictionary_CloudStoragePath{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_Dictionary_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType_Dictionary)
	// source
	switch x := m.Source.(type) {
	case *CustomInfoType_Dictionary_WordList_:
		s := proto.Size(x.WordList)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomInfoType_Dictionary_CloudStoragePath:
		s := proto.Size(x.CloudStoragePath)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message defining a list of words or phrases to search for in the data.
type CustomInfoType_Dictionary_WordList struct {
	// Words or phrases defining the dictionary. The dictionary must contain
	// at least one phrase and every phrase must contain at least 2 characters
	// that are letters or digits. [required]
	Words []string `protobuf:"bytes,1,rep,name=words" json:"words,omitempty"`
}

func (m *CustomInfoType_Dictionary_WordList) Reset()         { *m = CustomInfoType_Dictionary_WordList{} }
func (m *CustomInfoType_Dictionary_WordList) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_Dictionary_WordList) ProtoMessage()    {}
func (*CustomInfoType_Dictionary_WordList) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{1, 0, 0}
}

func (m *CustomInfoType_Dictionary_WordList) GetWords() []string {
	if m != nil {
		return m.Words
	}
	return nil
}

// Message defining a custom regular expression.
type CustomInfoType_Regex struct {
	// Pattern defining the regular expression.
	Pattern string `protobuf:"bytes,1,opt,name=pattern" json:"pattern,omitempty"`
}

func (m *CustomInfoType_Regex) Reset()                    { *m = CustomInfoType_Regex{} }
func (m *CustomInfoType_Regex) String() string            { return proto.CompactTextString(m) }
func (*CustomInfoType_Regex) ProtoMessage()               {}
func (*CustomInfoType_Regex) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1, 1} }

func (m *CustomInfoType_Regex) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

// Message for detecting output from deidentification transformations
// such as
// [`CryptoReplaceFfxFpeConfig`](/dlp/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
// These types of transformations are
// those that perform pseudonymization, thereby producing a "surrogate" as
// output. This should be used in conjunction with a field on the
// transformation such as `surrogate_info_type`. This custom info type does
// not support the use of `detection_rules`.
type CustomInfoType_SurrogateType struct {
}

func (m *CustomInfoType_SurrogateType) Reset()                    { *m = CustomInfoType_SurrogateType{} }
func (m *CustomInfoType_SurrogateType) String() string            { return proto.CompactTextString(m) }
func (*CustomInfoType_SurrogateType) ProtoMessage()               {}
func (*CustomInfoType_SurrogateType) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1, 2} }

// Rule for modifying a custom info type to alter behavior under certain
// circumstances, depending on the specific details of the rule. Not supported
// for the `surrogate_type` custom info type.
type CustomInfoType_DetectionRule struct {
	// Types that are valid to be assigned to Type:
	//	*CustomInfoType_DetectionRule_HotwordRule_
	Type isCustomInfoType_DetectionRule_Type `protobuf_oneof:"type"`
}

func (m *CustomInfoType_DetectionRule) Reset()                    { *m = CustomInfoType_DetectionRule{} }
func (m *CustomInfoType_DetectionRule) String() string            { return proto.CompactTextString(m) }
func (*CustomInfoType_DetectionRule) ProtoMessage()               {}
func (*CustomInfoType_DetectionRule) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1, 3} }

type isCustomInfoType_DetectionRule_Type interface {
	isCustomInfoType_DetectionRule_Type()
}

type CustomInfoType_DetectionRule_HotwordRule_ struct {
	HotwordRule *CustomInfoType_DetectionRule_HotwordRule `protobuf:"bytes,1,opt,name=hotword_rule,json=hotwordRule,oneof"`
}

func (*CustomInfoType_DetectionRule_HotwordRule_) isCustomInfoType_DetectionRule_Type() {}

func (m *CustomInfoType_DetectionRule) GetType() isCustomInfoType_DetectionRule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *CustomInfoType_DetectionRule) GetHotwordRule() *CustomInfoType_DetectionRule_HotwordRule {
	if x, ok := m.GetType().(*CustomInfoType_DetectionRule_HotwordRule_); ok {
		return x.HotwordRule
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType_DetectionRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_DetectionRule_OneofMarshaler, _CustomInfoType_DetectionRule_OneofUnmarshaler, _CustomInfoType_DetectionRule_OneofSizer, []interface{}{
		(*CustomInfoType_DetectionRule_HotwordRule_)(nil),
	}
}

func _CustomInfoType_DetectionRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType_DetectionRule)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_DetectionRule_HotwordRule_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotwordRule); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CustomInfoType_DetectionRule.Type has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_DetectionRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType_DetectionRule)
	switch tag {
	case 1: // type.hotword_rule
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_DetectionRule_HotwordRule)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_DetectionRule_HotwordRule_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_DetectionRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType_DetectionRule)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_DetectionRule_HotwordRule_:
		s := proto.Size(x.HotwordRule)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for specifying a window around a finding to apply a detection
// rule.
type CustomInfoType_DetectionRule_Proximity struct {
	// Number of characters before the finding to consider.
	WindowBefore int32 `protobuf:"varint,1,opt,name=window_before,json=windowBefore" json:"window_before,omitempty"`
	// Number of characters after the finding to consider.
	WindowAfter int32 `protobuf:"varint,2,opt,name=window_after,json=windowAfter" json:"window_after,omitempty"`
}

func (m *CustomInfoType_DetectionRule_Proximity) Reset() {
	*m = CustomInfoType_DetectionRule_Proximity{}
}
func (m *CustomInfoType_DetectionRule_Proximity) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_DetectionRule_Proximity) ProtoMessage()    {}
func (*CustomInfoType_DetectionRule_Proximity) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{1, 3, 0}
}

func (m *CustomInfoType_DetectionRule_Proximity) GetWindowBefore() int32 {
	if m != nil {
		return m.WindowBefore
	}
	return 0
}

func (m *CustomInfoType_DetectionRule_Proximity) GetWindowAfter() int32 {
	if m != nil {
		return m.WindowAfter
	}
	return 0
}

// Message for specifying an adjustment to the likelihood of a finding as
// part of a detection rule.
type CustomInfoType_DetectionRule_LikelihoodAdjustment struct {
	// Types that are valid to be assigned to Adjustment:
	//	*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood
	//	*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood
	Adjustment isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment `protobuf_oneof:"adjustment"`
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) Reset() {
	*m = CustomInfoType_DetectionRule_LikelihoodAdjustment{}
}
func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) String() string {
	return proto.CompactTextString(m)
}
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) ProtoMessage() {}
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{1, 3, 1}
}

type isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment interface {
	isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment()
}

type CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood struct {
	FixedLikelihood Likelihood `protobuf:"varint,1,opt,name=fixed_likelihood,json=fixedLikelihood,enum=google.privacy.dlp.v2.Likelihood,oneof"`
}
type CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood struct {
	RelativeLikelihood int32 `protobuf:"varint,2,opt,name=relative_likelihood,json=relativeLikelihood,oneof"`
}

func (*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood) isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment() {
}
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood) isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment() {
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetAdjustment() isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment {
	if m != nil {
		return m.Adjustment
	}
	return nil
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetFixedLikelihood() Likelihood {
	if x, ok := m.GetAdjustment().(*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood); ok {
		return x.FixedLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetRelativeLikelihood() int32 {
	if x, ok := m.GetAdjustment().(*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood); ok {
		return x.RelativeLikelihood
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofMarshaler, _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofUnmarshaler, _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofSizer, []interface{}{
		(*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood)(nil),
		(*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood)(nil),
	}
}

func _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType_DetectionRule_LikelihoodAdjustment)
	// adjustment
	switch x := m.Adjustment.(type) {
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.FixedLikelihood))
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.RelativeLikelihood))
	case nil:
	default:
		return fmt.Errorf("CustomInfoType_DetectionRule_LikelihoodAdjustment.Adjustment has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType_DetectionRule_LikelihoodAdjustment)
	switch tag {
	case 1: // adjustment.fixed_likelihood
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Adjustment = &CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood{Likelihood(x)}
		return true, err
	case 2: // adjustment.relative_likelihood
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Adjustment = &CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood{int32(x)}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType_DetectionRule_LikelihoodAdjustment)
	// adjustment
	switch x := m.Adjustment.(type) {
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.FixedLikelihood))
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.RelativeLikelihood))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Detection rule that adjusts the likelihood of findings within a certain
// proximity of hotwords.
type CustomInfoType_DetectionRule_HotwordRule struct {
	// Regex pattern defining what qualifies as a hotword.
	HotwordRegex *CustomInfoType_Regex `protobuf:"bytes,1,opt,name=hotword_regex,json=hotwordRegex" json:"hotword_regex,omitempty"`
	// Proximity of the finding within which the entire hotword must reside.
	// The total length of the window cannot exceed 1000 characters. Note that
	// the finding itself will be included in the window, so that hotwords may
	// be used to match substrings of the finding itself. For example, the
	// certainty of a phone number regex "\(\d{3}\) \d{3}-\d{4}" could be
	// adjusted upwards if the area code is known to be the local area code of
	// a company office using the hotword regex "\(xxx\)", where "xxx"
	// is the area code in question.
	Proximity *CustomInfoType_DetectionRule_Proximity `protobuf:"bytes,2,opt,name=proximity" json:"proximity,omitempty"`
	// Likelihood adjustment to apply to all matching findings.
	LikelihoodAdjustment *CustomInfoType_DetectionRule_LikelihoodAdjustment `protobuf:"bytes,3,opt,name=likelihood_adjustment,json=likelihoodAdjustment" json:"likelihood_adjustment,omitempty"`
}

func (m *CustomInfoType_DetectionRule_HotwordRule) Reset() {
	*m = CustomInfoType_DetectionRule_HotwordRule{}
}
func (m *CustomInfoType_DetectionRule_HotwordRule) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_DetectionRule_HotwordRule) ProtoMessage()    {}
func (*CustomInfoType_DetectionRule_HotwordRule) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{1, 3, 2}
}

func (m *CustomInfoType_DetectionRule_HotwordRule) GetHotwordRegex() *CustomInfoType_Regex {
	if m != nil {
		return m.HotwordRegex
	}
	return nil
}

func (m *CustomInfoType_DetectionRule_HotwordRule) GetProximity() *CustomInfoType_DetectionRule_Proximity {
	if m != nil {
		return m.Proximity
	}
	return nil
}

func (m *CustomInfoType_DetectionRule_HotwordRule) GetLikelihoodAdjustment() *CustomInfoType_DetectionRule_LikelihoodAdjustment {
	if m != nil {
		return m.LikelihoodAdjustment
	}
	return nil
}

// General identifier of a data field in a storage service.
type FieldId struct {
	// Name describing the field.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *FieldId) Reset()                    { *m = FieldId{} }
func (m *FieldId) String() string            { return proto.CompactTextString(m) }
func (*FieldId) ProtoMessage()               {}
func (*FieldId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *FieldId) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Datastore partition ID.
// A partition ID identifies a grouping of entities. The grouping is always
// by project and namespace, however the namespace ID may be empty.
//
// A partition ID contains several dimensions:
// project ID and namespace ID.
type PartitionId struct {
	// The ID of the project to which the entities belong.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// If not empty, the ID of the namespace to which the entities belong.
	NamespaceId string `protobuf:"bytes,4,opt,name=namespace_id,json=namespaceId" json:"namespace_id,omitempty"`
}

func (m *PartitionId) Reset()                    { *m = PartitionId{} }
func (m *PartitionId) String() string            { return proto.CompactTextString(m) }
func (*PartitionId) ProtoMessage()               {}
func (*PartitionId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *PartitionId) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *PartitionId) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

// A representation of a Datastore kind.
type KindExpression struct {
	// The name of the kind.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *KindExpression) Reset()                    { *m = KindExpression{} }
func (m *KindExpression) String() string            { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()               {}
func (*KindExpression) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *KindExpression) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Options defining a data set within Google Cloud Datastore.
type DatastoreOptions struct {
	// A partition ID identifies a grouping of entities. The grouping is always
	// by project and namespace, however the namespace ID may be empty.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The kind to process.
	Kind *KindExpression `protobuf:"bytes,2,opt,name=kind" json:"kind,omitempty"`
}

func (m *DatastoreOptions) Reset()                    { *m = DatastoreOptions{} }
func (m *DatastoreOptions) String() string            { return proto.CompactTextString(m) }
func (*DatastoreOptions) ProtoMessage()               {}
func (*DatastoreOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *DatastoreOptions) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *DatastoreOptions) GetKind() *KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

// Options defining a file or a set of files (path ending with *) within
// a Google Cloud Storage bucket.
type CloudStorageOptions struct {
	FileSet *CloudStorageOptions_FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet" json:"file_set,omitempty"`
	// Max number of bytes to scan from a file. If a scanned file's size is bigger
	// than this value then the rest of the bytes are omitted.
	BytesLimitPerFile int64 `protobuf:"varint,4,opt,name=bytes_limit_per_file,json=bytesLimitPerFile" json:"bytes_limit_per_file,omitempty"`
	// List of file type groups to include in the scan.
	// If empty, all files are scanned and available data format processors
	// are applied.
	FileTypes []FileType `protobuf:"varint,5,rep,packed,name=file_types,json=fileTypes,enum=google.privacy.dlp.v2.FileType" json:"file_types,omitempty"`
}

func (m *CloudStorageOptions) Reset()                    { *m = CloudStorageOptions{} }
func (m *CloudStorageOptions) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageOptions) ProtoMessage()               {}
func (*CloudStorageOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *CloudStorageOptions) GetFileSet() *CloudStorageOptions_FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

func (m *CloudStorageOptions) GetBytesLimitPerFile() int64 {
	if m != nil {
		return m.BytesLimitPerFile
	}
	return 0
}

func (m *CloudStorageOptions) GetFileTypes() []FileType {
	if m != nil {
		return m.FileTypes
	}
	return nil
}

// Set of files to scan.
type CloudStorageOptions_FileSet struct {
	// The url, in the format `gs://<bucket>/<path>`. Trailing wildcard in the
	// path is allowed.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
}

func (m *CloudStorageOptions_FileSet) Reset()                    { *m = CloudStorageOptions_FileSet{} }
func (m *CloudStorageOptions_FileSet) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageOptions_FileSet) ProtoMessage()               {}
func (*CloudStorageOptions_FileSet) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6, 0} }

func (m *CloudStorageOptions_FileSet) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// Message representing a path in Cloud Storage.
type CloudStoragePath struct {
	// A url representing a file or path (no wildcards) in Cloud Storage.
	// Example: gs://[BUCKET_NAME]/dictionary.txt
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
}

func (m *CloudStoragePath) Reset()                    { *m = CloudStoragePath{} }
func (m *CloudStoragePath) String() string            { return proto.CompactTextString(m) }
func (*CloudStoragePath) ProtoMessage()               {}
func (*CloudStoragePath) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *CloudStoragePath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Options defining BigQuery table and row identifiers.
type BigQueryOptions struct {
	// Complete BigQuery table reference.
	TableReference *BigQueryTable `protobuf:"bytes,1,opt,name=table_reference,json=tableReference" json:"table_reference,omitempty"`
	// References to fields uniquely identifying rows within the table.
	// Nested fields in the format, like `person.birthdate.year`, are allowed.
	IdentifyingFields []*FieldId `protobuf:"bytes,2,rep,name=identifying_fields,json=identifyingFields" json:"identifying_fields,omitempty"`
	// Max number of rows to scan. If the table has more rows than this value, the
	// rest of the rows are omitted. If not set, or if set to 0, all rows will be
	// scanned. Cannot be used in conjunction with TimespanConfig.
	RowsLimit int64 `protobuf:"varint,3,opt,name=rows_limit,json=rowsLimit" json:"rows_limit,omitempty"`
}

func (m *BigQueryOptions) Reset()                    { *m = BigQueryOptions{} }
func (m *BigQueryOptions) String() string            { return proto.CompactTextString(m) }
func (*BigQueryOptions) ProtoMessage()               {}
func (*BigQueryOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *BigQueryOptions) GetTableReference() *BigQueryTable {
	if m != nil {
		return m.TableReference
	}
	return nil
}

func (m *BigQueryOptions) GetIdentifyingFields() []*FieldId {
	if m != nil {
		return m.IdentifyingFields
	}
	return nil
}

func (m *BigQueryOptions) GetRowsLimit() int64 {
	if m != nil {
		return m.RowsLimit
	}
	return 0
}

// Shared message indicating Cloud storage type.
type StorageConfig struct {
	// Types that are valid to be assigned to Type:
	//	*StorageConfig_DatastoreOptions
	//	*StorageConfig_CloudStorageOptions
	//	*StorageConfig_BigQueryOptions
	Type           isStorageConfig_Type          `protobuf_oneof:"type"`
	TimespanConfig *StorageConfig_TimespanConfig `protobuf:"bytes,6,opt,name=timespan_config,json=timespanConfig" json:"timespan_config,omitempty"`
}

func (m *StorageConfig) Reset()                    { *m = StorageConfig{} }
func (m *StorageConfig) String() string            { return proto.CompactTextString(m) }
func (*StorageConfig) ProtoMessage()               {}
func (*StorageConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

type isStorageConfig_Type interface {
	isStorageConfig_Type()
}

type StorageConfig_DatastoreOptions struct {
	DatastoreOptions *DatastoreOptions `protobuf:"bytes,2,opt,name=datastore_options,json=datastoreOptions,oneof"`
}
type StorageConfig_CloudStorageOptions struct {
	CloudStorageOptions *CloudStorageOptions `protobuf:"bytes,3,opt,name=cloud_storage_options,json=cloudStorageOptions,oneof"`
}
type StorageConfig_BigQueryOptions struct {
	BigQueryOptions *BigQueryOptions `protobuf:"bytes,4,opt,name=big_query_options,json=bigQueryOptions,oneof"`
}

func (*StorageConfig_DatastoreOptions) isStorageConfig_Type()    {}
func (*StorageConfig_CloudStorageOptions) isStorageConfig_Type() {}
func (*StorageConfig_BigQueryOptions) isStorageConfig_Type()     {}

func (m *StorageConfig) GetType() isStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StorageConfig) GetDatastoreOptions() *DatastoreOptions {
	if x, ok := m.GetType().(*StorageConfig_DatastoreOptions); ok {
		return x.DatastoreOptions
	}
	return nil
}

func (m *StorageConfig) GetCloudStorageOptions() *CloudStorageOptions {
	if x, ok := m.GetType().(*StorageConfig_CloudStorageOptions); ok {
		return x.CloudStorageOptions
	}
	return nil
}

func (m *StorageConfig) GetBigQueryOptions() *BigQueryOptions {
	if x, ok := m.GetType().(*StorageConfig_BigQueryOptions); ok {
		return x.BigQueryOptions
	}
	return nil
}

func (m *StorageConfig) GetTimespanConfig() *StorageConfig_TimespanConfig {
	if m != nil {
		return m.TimespanConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StorageConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StorageConfig_OneofMarshaler, _StorageConfig_OneofUnmarshaler, _StorageConfig_OneofSizer, []interface{}{
		(*StorageConfig_DatastoreOptions)(nil),
		(*StorageConfig_CloudStorageOptions)(nil),
		(*StorageConfig_BigQueryOptions)(nil),
	}
}

func _StorageConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreOptions); err != nil {
			return err
		}
	case *StorageConfig_CloudStorageOptions:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStorageOptions); err != nil {
			return err
		}
	case *StorageConfig_BigQueryOptions:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BigQueryOptions); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StorageConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _StorageConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StorageConfig)
	switch tag {
	case 2: // type.datastore_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_DatastoreOptions{msg}
		return true, err
	case 3: // type.cloud_storage_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStorageOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_CloudStorageOptions{msg}
		return true, err
	case 4: // type.big_query_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BigQueryOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_BigQueryOptions{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StorageConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		s := proto.Size(x.DatastoreOptions)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageConfig_CloudStorageOptions:
		s := proto.Size(x.CloudStorageOptions)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageConfig_BigQueryOptions:
		s := proto.Size(x.BigQueryOptions)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Configuration of the timespan of the items to include in scanning.
// Currently only supported when inspecting Google Cloud Storage and BigQuery.
type StorageConfig_TimespanConfig struct {
	// Exclude files older than this value.
	StartTime *google_protobuf1.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Exclude files newer than this value.
	// If set to zero, no upper time limit is applied.
	EndTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Specification of the field containing the timestamp of scanned items.
	// Required for data sources like Datastore or BigQuery.
	// The valid data types of the timestamp field are:
	// for BigQuery - timestamp, date, datetime;
	// for Datastore - timestamp.
	// Datastore entity will be scanned if the timestamp property does not exist
	// or its value is empty or invalid.
	TimestampField *FieldId `protobuf:"bytes,3,opt,name=timestamp_field,json=timestampField" json:"timestamp_field,omitempty"`
	// When the job is started by a JobTrigger we will automatically figure out
	// a valid start_time to avoid scanning files that have not been modified
	// since the last time the JobTrigger executed. This will be based on the
	// time of the execution of the last run of the JobTrigger.
	EnableAutoPopulationOfTimespanConfig bool `protobuf:"varint,4,opt,name=enable_auto_population_of_timespan_config,json=enableAutoPopulationOfTimespanConfig" json:"enable_auto_population_of_timespan_config,omitempty"`
}

func (m *StorageConfig_TimespanConfig) Reset()                    { *m = StorageConfig_TimespanConfig{} }
func (m *StorageConfig_TimespanConfig) String() string            { return proto.CompactTextString(m) }
func (*StorageConfig_TimespanConfig) ProtoMessage()               {}
func (*StorageConfig_TimespanConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9, 0} }

func (m *StorageConfig_TimespanConfig) GetStartTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *StorageConfig_TimespanConfig) GetEndTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *StorageConfig_TimespanConfig) GetTimestampField() *FieldId {
	if m != nil {
		return m.TimestampField
	}
	return nil
}

func (m *StorageConfig_TimespanConfig) GetEnableAutoPopulationOfTimespanConfig() bool {
	if m != nil {
		return m.EnableAutoPopulationOfTimespanConfig
	}
	return false
}

// Row key for identifying a record in BigQuery table.
type BigQueryKey struct {
	// Complete BigQuery table reference.
	TableReference *BigQueryTable `protobuf:"bytes,1,opt,name=table_reference,json=tableReference" json:"table_reference,omitempty"`
	// Absolute number of the row from the beginning of the table at the time
	// of scanning.
	RowNumber int64 `protobuf:"varint,2,opt,name=row_number,json=rowNumber" json:"row_number,omitempty"`
}

func (m *BigQueryKey) Reset()                    { *m = BigQueryKey{} }
func (m *BigQueryKey) String() string            { return proto.CompactTextString(m) }
func (*BigQueryKey) ProtoMessage()               {}
func (*BigQueryKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *BigQueryKey) GetTableReference() *BigQueryTable {
	if m != nil {
		return m.TableReference
	}
	return nil
}

func (m *BigQueryKey) GetRowNumber() int64 {
	if m != nil {
		return m.RowNumber
	}
	return 0
}

// Record key for a finding in Cloud Datastore.
type DatastoreKey struct {
	// Datastore entity key.
	EntityKey *Key `protobuf:"bytes,1,opt,name=entity_key,json=entityKey" json:"entity_key,omitempty"`
}

func (m *DatastoreKey) Reset()                    { *m = DatastoreKey{} }
func (m *DatastoreKey) String() string            { return proto.CompactTextString(m) }
func (*DatastoreKey) ProtoMessage()               {}
func (*DatastoreKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *DatastoreKey) GetEntityKey() *Key {
	if m != nil {
		return m.EntityKey
	}
	return nil
}

// A unique identifier for a Datastore entity.
// If a key's partition ID or any of its path kinds or names are
// reserved/read-only, the key is reserved/read-only.
// A reserved/read-only key is forbidden in certain documented contexts.
type Key struct {
	// Entities are partitioned into subsets, currently identified by a project
	// ID and namespace ID.
	// Queries are scoped to a single partition.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The entity path.
	// An entity path consists of one or more elements composed of a kind and a
	// string or numerical identifier, which identify entities. The first
	// element identifies a _root entity_, the second element identifies
	// a _child_ of the root entity, the third element identifies a child of the
	// second entity, and so forth. The entities identified by all prefixes of
	// the path are called the element's _ancestors_.
	//
	// A path can never be empty, and a path can have at most 100 elements.
	Path []*Key_PathElement `protobuf:"bytes,2,rep,name=path" json:"path,omitempty"`
}

func (m *Key) Reset()                    { *m = Key{} }
func (m *Key) String() string            { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()               {}
func (*Key) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *Key) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *Key) GetPath() []*Key_PathElement {
	if m != nil {
		return m.Path
	}
	return nil
}

// A (kind, ID/name) pair used to construct a key path.
//
// If either name or ID is set, the element is complete.
// If neither is set, the element is incomplete.
type Key_PathElement struct {
	// The kind of the entity.
	// A kind matching regex `__.*__` is reserved/read-only.
	// A kind must not contain more than 1500 bytes when UTF-8 encoded.
	// Cannot be `""`.
	Kind string `protobuf:"bytes,1,opt,name=kind" json:"kind,omitempty"`
	// The type of ID.
	//
	// Types that are valid to be assigned to IdType:
	//	*Key_PathElement_Id
	//	*Key_PathElement_Name
	IdType isKey_PathElement_IdType `protobuf_oneof:"id_type"`
}

func (m *Key_PathElement) Reset()                    { *m = Key_PathElement{} }
func (m *Key_PathElement) String() string            { return proto.CompactTextString(m) }
func (*Key_PathElement) ProtoMessage()               {}
func (*Key_PathElement) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12, 0} }

type isKey_PathElement_IdType interface {
	isKey_PathElement_IdType()
}

type Key_PathElement_Id struct {
	Id int64 `protobuf:"varint,2,opt,name=id,oneof"`
}
type Key_PathElement_Name struct {
	Name string `protobuf:"bytes,3,opt,name=name,oneof"`
}

func (*Key_PathElement_Id) isKey_PathElement_IdType()   {}
func (*Key_PathElement_Name) isKey_PathElement_IdType() {}

func (m *Key_PathElement) GetIdType() isKey_PathElement_IdType {
	if m != nil {
		return m.IdType
	}
	return nil
}

func (m *Key_PathElement) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Key_PathElement) GetId() int64 {
	if x, ok := m.GetIdType().(*Key_PathElement_Id); ok {
		return x.Id
	}
	return 0
}

func (m *Key_PathElement) GetName() string {
	if x, ok := m.GetIdType().(*Key_PathElement_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Key_PathElement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Key_PathElement_OneofMarshaler, _Key_PathElement_OneofUnmarshaler, _Key_PathElement_OneofSizer, []interface{}{
		(*Key_PathElement_Id)(nil),
		(*Key_PathElement_Name)(nil),
	}
}

func _Key_PathElement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Name)
	case nil:
	default:
		return fmt.Errorf("Key_PathElement.IdType has unexpected type %T", x)
	}
	return nil
}

func _Key_PathElement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Key_PathElement)
	switch tag {
	case 2: // id_type.id
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.IdType = &Key_PathElement_Id{int64(x)}
		return true, err
	case 3: // id_type.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IdType = &Key_PathElement_Name{x}
		return true, err
	default:
		return false, nil
	}
}

func _Key_PathElement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for a unique key indicating a record that contains a finding.
type RecordKey struct {
	// Types that are valid to be assigned to Type:
	//	*RecordKey_DatastoreKey
	//	*RecordKey_BigQueryKey
	Type isRecordKey_Type `protobuf_oneof:"type"`
}

func (m *RecordKey) Reset()                    { *m = RecordKey{} }
func (m *RecordKey) String() string            { return proto.CompactTextString(m) }
func (*RecordKey) ProtoMessage()               {}
func (*RecordKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

type isRecordKey_Type interface {
	isRecordKey_Type()
}

type RecordKey_DatastoreKey struct {
	DatastoreKey *DatastoreKey `protobuf:"bytes,2,opt,name=datastore_key,json=datastoreKey,oneof"`
}
type RecordKey_BigQueryKey struct {
	BigQueryKey *BigQueryKey `protobuf:"bytes,3,opt,name=big_query_key,json=bigQueryKey,oneof"`
}

func (*RecordKey_DatastoreKey) isRecordKey_Type() {}
func (*RecordKey_BigQueryKey) isRecordKey_Type()  {}

func (m *RecordKey) GetType() isRecordKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RecordKey) GetDatastoreKey() *DatastoreKey {
	if x, ok := m.GetType().(*RecordKey_DatastoreKey); ok {
		return x.DatastoreKey
	}
	return nil
}

func (m *RecordKey) GetBigQueryKey() *BigQueryKey {
	if x, ok := m.GetType().(*RecordKey_BigQueryKey); ok {
		return x.BigQueryKey
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecordKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecordKey_OneofMarshaler, _RecordKey_OneofUnmarshaler, _RecordKey_OneofSizer, []interface{}{
		(*RecordKey_DatastoreKey)(nil),
		(*RecordKey_BigQueryKey)(nil),
	}
}

func _RecordKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_DatastoreKey:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreKey); err != nil {
			return err
		}
	case *RecordKey_BigQueryKey:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BigQueryKey); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RecordKey.Type has unexpected type %T", x)
	}
	return nil
}

func _RecordKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecordKey)
	switch tag {
	case 2: // type.datastore_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_DatastoreKey{msg}
		return true, err
	case 3: // type.big_query_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BigQueryKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_BigQueryKey{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RecordKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_DatastoreKey:
		s := proto.Size(x.DatastoreKey)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RecordKey_BigQueryKey:
		s := proto.Size(x.BigQueryKey)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message defining the location of a BigQuery table. A table is uniquely
// identified  by its project_id, dataset_id, and table_name. Within a query
// a table is often referenced with a string in the format of:
// `<project_id>:<dataset_id>.<table_id>` or
// `<project_id>.<dataset_id>.<table_id>`.
type BigQueryTable struct {
	// The Google Cloud Platform project ID of the project containing the table.
	// If omitted, project ID is inferred from the API call.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Dataset ID of the table.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// Name of the table.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId" json:"table_id,omitempty"`
}

func (m *BigQueryTable) Reset()                    { *m = BigQueryTable{} }
func (m *BigQueryTable) String() string            { return proto.CompactTextString(m) }
func (*BigQueryTable) ProtoMessage()               {}
func (*BigQueryTable) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *BigQueryTable) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BigQueryTable) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *BigQueryTable) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

// An entity in a dataset is a field or set of fields that correspond to a
// single person. For example, in medical records the `EntityId` might be a
// patient identifier, or for financial records it might be an account
// identifier. This message is used when generalizations or analysis must take
// into account that multiple rows correspond to the same entity.
type EntityId struct {
	// Composite key indicating which field contains the entity identifier.
	Field *FieldId `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
}

func (m *EntityId) Reset()                    { *m = EntityId{} }
func (m *EntityId) String() string            { return proto.CompactTextString(m) }
func (*EntityId) ProtoMessage()               {}
func (*EntityId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *EntityId) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

func init() {
	proto.RegisterType((*InfoType)(nil), "google.privacy.dlp.v2.InfoType")
	proto.RegisterType((*CustomInfoType)(nil), "google.privacy.dlp.v2.CustomInfoType")
	proto.RegisterType((*CustomInfoType_Dictionary)(nil), "google.privacy.dlp.v2.CustomInfoType.Dictionary")
	proto.RegisterType((*CustomInfoType_Dictionary_WordList)(nil), "google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList")
	proto.RegisterType((*CustomInfoType_Regex)(nil), "google.privacy.dlp.v2.CustomInfoType.Regex")
	proto.RegisterType((*CustomInfoType_SurrogateType)(nil), "google.privacy.dlp.v2.CustomInfoType.SurrogateType")
	proto.RegisterType((*CustomInfoType_DetectionRule)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule")
	proto.RegisterType((*CustomInfoType_DetectionRule_Proximity)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity")
	proto.RegisterType((*CustomInfoType_DetectionRule_LikelihoodAdjustment)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment")
	proto.RegisterType((*CustomInfoType_DetectionRule_HotwordRule)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule")
	proto.RegisterType((*FieldId)(nil), "google.privacy.dlp.v2.FieldId")
	proto.RegisterType((*PartitionId)(nil), "google.privacy.dlp.v2.PartitionId")
	proto.RegisterType((*KindExpression)(nil), "google.privacy.dlp.v2.KindExpression")
	proto.RegisterType((*DatastoreOptions)(nil), "google.privacy.dlp.v2.DatastoreOptions")
	proto.RegisterType((*CloudStorageOptions)(nil), "google.privacy.dlp.v2.CloudStorageOptions")
	proto.RegisterType((*CloudStorageOptions_FileSet)(nil), "google.privacy.dlp.v2.CloudStorageOptions.FileSet")
	proto.RegisterType((*CloudStoragePath)(nil), "google.privacy.dlp.v2.CloudStoragePath")
	proto.RegisterType((*BigQueryOptions)(nil), "google.privacy.dlp.v2.BigQueryOptions")
	proto.RegisterType((*StorageConfig)(nil), "google.privacy.dlp.v2.StorageConfig")
	proto.RegisterType((*StorageConfig_TimespanConfig)(nil), "google.privacy.dlp.v2.StorageConfig.TimespanConfig")
	proto.RegisterType((*BigQueryKey)(nil), "google.privacy.dlp.v2.BigQueryKey")
	proto.RegisterType((*DatastoreKey)(nil), "google.privacy.dlp.v2.DatastoreKey")
	proto.RegisterType((*Key)(nil), "google.privacy.dlp.v2.Key")
	proto.RegisterType((*Key_PathElement)(nil), "google.privacy.dlp.v2.Key.PathElement")
	proto.RegisterType((*RecordKey)(nil), "google.privacy.dlp.v2.RecordKey")
	proto.RegisterType((*BigQueryTable)(nil), "google.privacy.dlp.v2.BigQueryTable")
	proto.RegisterType((*EntityId)(nil), "google.privacy.dlp.v2.EntityId")
	proto.RegisterEnum("google.privacy.dlp.v2.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.privacy.dlp.v2.FileType", FileType_name, FileType_value)
}

func init() { proto.RegisterFile("google/privacy/dlp/v2/storage.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 1646 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xfd, 0x72, 0x1b, 0x49,
	0x11, 0xd7, 0x4a, 0x96, 0xad, 0x6d, 0x59, 0x1f, 0x9e, 0x38, 0x94, 0x22, 0xc8, 0x9d, 0xa3, 0x84,
	0x10, 0x42, 0x95, 0x04, 0x3e, 0xa8, 0x22, 0x7c, 0x5b, 0x91, 0x72, 0x5a, 0xec, 0xb3, 0xc5, 0x58,
	0x97, 0x5c, 0xc0, 0x55, 0xcb, 0x4a, 0x33, 0x92, 0xe7, 0xb2, 0xda, 0x59, 0x76, 0x47, 0x71, 0x54,
	0x14, 0xcf, 0xc0, 0x3f, 0x3c, 0x02, 0x55, 0x14, 0x14, 0x4f, 0x00, 0x6f, 0x40, 0x15, 0x3c, 0x02,
	0x2f, 0xc0, 0x7f, 0x3c, 0x01, 0x35, 0x1f, 0xbb, 0xfa, 0xc0, 0xba, 0xf8, 0x52, 0xf9, 0xcb, 0xd3,
	0xbd, 0xfd, 0xeb, 0x99, 0xe9, 0xfe, 0x75, 0xf7, 0x58, 0x70, 0x7f, 0xc2, 0xf9, 0xc4, 0xa7, 0xad,
	0x30, 0x62, 0xaf, 0xbd, 0xd1, 0xbc, 0x45, 0xfc, 0xb0, 0xf5, 0xfa, 0xb0, 0x15, 0x0b, 0x1e, 0x79,
	0x13, 0xda, 0x0c, 0x23, 0x2e, 0x38, 0xba, 0xad, 0x8d, 0x9a, 0xc6, 0xa8, 0x49, 0xfc, 0xb0, 0xf9,
	0xfa, 0xb0, 0xfe, 0x35, 0x83, 0xf5, 0x42, 0xd6, 0xf2, 0x82, 0x80, 0x0b, 0x4f, 0x30, 0x1e, 0xc4,
	0x1a, 0x54, 0xff, 0x30, 0xf5, 0xcc, 0x05, 0x1f, 0xce, 0xc6, 0x2d, 0xc1, 0xa6, 0x34, 0x16, 0xde,
	0x34, 0xd4, 0x06, 0x8d, 0x0f, 0xa0, 0xe0, 0x04, 0x63, 0x3e, 0x98, 0x87, 0x14, 0x21, 0xd8, 0x0a,
	0xbc, 0x29, 0xad, 0x59, 0x07, 0xd6, 0x23, 0x1b, 0xab, 0x75, 0xe3, 0x9f, 0x45, 0x28, 0x3f, 0x9d,
	0xc5, 0x82, 0x4f, 0x53, 0xb3, 0x1f, 0x81, 0xcd, 0x82, 0x31, 0x77, 0xc5, 0x3c, 0xd4, 0xb6, 0xc5,
	0xc3, 0x0f, 0x9b, 0xd7, 0x1e, 0xae, 0x99, 0x60, 0x70, 0x81, 0x25, 0xe8, 0x23, 0x00, 0x9f, 0xbd,
	0xa2, 0x3e, 0xbb, 0xe4, 0x9c, 0xd4, 0xb6, 0x0f, 0xac, 0x47, 0xe5, 0xc3, 0x7b, 0x1b, 0xe0, 0x27,
	0xa9, 0x21, 0x5e, 0x02, 0x21, 0x0c, 0x40, 0xd8, 0x48, 0x5e, 0xd3, 0x8b, 0xe6, 0xb5, 0xac, 0x3a,
	0xc1, 0xb7, 0x37, 0xb8, 0x58, 0x3d, 0x7b, 0xb3, 0x93, 0xe2, 0x7a, 0x19, 0xbc, 0xe4, 0x05, 0x3d,
	0x85, 0x7c, 0x44, 0x27, 0xf4, 0x4d, 0x2d, 0xa7, 0xdc, 0x7d, 0xeb, 0x66, 0xee, 0xb0, 0x84, 0xf4,
	0x32, 0x58, 0x63, 0xd1, 0x05, 0x94, 0xe3, 0x59, 0x14, 0xf1, 0x89, 0x27, 0xa8, 0x0e, 0xcf, 0x96,
	0xf2, 0xf6, 0xd1, 0xcd, 0xbc, 0x9d, 0x27, 0x58, 0x29, 0xf5, 0x32, 0xb8, 0x14, 0x2f, 0x2b, 0xd0,
	0x05, 0x54, 0x08, 0x15, 0x54, 0x1d, 0xd9, 0x8d, 0x66, 0x3e, 0x8d, 0x6b, 0x3b, 0x07, 0xb9, 0x9b,
	0xbb, 0xef, 0x24, 0x60, 0x3c, 0xf3, 0x29, 0x2e, 0x93, 0x65, 0x31, 0xae, 0xff, 0xc7, 0x02, 0x58,
	0x44, 0x07, 0x7d, 0x06, 0xf6, 0x15, 0x8f, 0x88, 0xeb, 0xb3, 0x58, 0x98, 0x24, 0x3f, 0xf9, 0xb2,
	0x21, 0x6e, 0xbe, 0xe0, 0x11, 0x39, 0x61, 0xb1, 0xe8, 0x65, 0x70, 0xe1, 0xca, 0xac, 0xd1, 0x0b,
	0x40, 0x23, 0x9f, 0xcf, 0x88, 0x6b, 0xe8, 0xed, 0x86, 0x9e, 0xb8, 0x34, 0x61, 0xff, 0xc6, 0xa6,
	0x2d, 0x24, 0xe0, 0x5c, 0xdb, 0xf7, 0x3d, 0x71, 0xd9, 0xcb, 0xe0, 0xea, 0x68, 0x4d, 0x57, 0x3f,
	0x80, 0x42, 0xb2, 0x21, 0xda, 0x87, 0xbc, 0xdc, 0x30, 0xae, 0x59, 0x07, 0xb9, 0x47, 0x36, 0xd6,
	0x42, 0xbb, 0x00, 0xdb, 0x31, 0x9f, 0x45, 0x23, 0x5a, 0xbf, 0x07, 0x79, 0x95, 0x3b, 0x54, 0x83,
	0x9d, 0xd0, 0x13, 0x82, 0x46, 0x81, 0xa1, 0x7d, 0x22, 0xd6, 0x2b, 0x50, 0x5a, 0x49, 0x48, 0xfd,
	0x6f, 0x79, 0x28, 0xad, 0xc4, 0x10, 0x11, 0xd8, 0xbd, 0xe4, 0x42, 0xc5, 0x49, 0xe6, 0xc3, 0xc4,
	0xe9, 0xa7, 0xef, 0x90, 0x8e, 0x66, 0x4f, 0xfb, 0x91, 0xeb, 0x5e, 0x06, 0x17, 0x2f, 0x17, 0x62,
	0xfd, 0x1c, 0xec, 0x7e, 0xc4, 0xdf, 0xb0, 0x29, 0x13, 0x73, 0x74, 0x1f, 0x4a, 0x57, 0x2c, 0x20,
	0xfc, 0xca, 0x1d, 0xd2, 0x31, 0x8f, 0xf4, 0x9e, 0x79, 0xbc, 0xab, 0x95, 0x6d, 0xa5, 0x43, 0xf7,
	0xc0, 0xc8, 0xae, 0x37, 0x16, 0x34, 0x52, 0x25, 0x92, 0xc7, 0x45, 0xad, 0x3b, 0x92, 0xaa, 0xfa,
	0x9f, 0x2c, 0xd8, 0x5f, 0x94, 0xd7, 0x11, 0xf9, 0x7c, 0x16, 0x8b, 0x29, 0x0d, 0x04, 0x3a, 0x85,
	0xea, 0x98, 0xbd, 0xa1, 0x32, 0xf3, 0x69, 0x95, 0x5a, 0x37, 0xac, 0xd2, 0x5e, 0x06, 0x57, 0x14,
	0x78, 0xa1, 0x42, 0xdf, 0x81, 0x5b, 0x11, 0xf5, 0x3d, 0xc1, 0x5e, 0xd3, 0x65, 0x97, 0xea, 0x48,
	0xbd, 0x0c, 0x46, 0xc9, 0xc7, 0x05, 0xa4, 0xbd, 0x0b, 0xe0, 0xa5, 0x07, 0xaa, 0xff, 0x3d, 0x0b,
	0xc5, 0xa5, 0xe8, 0xa0, 0x3e, 0x94, 0xd2, 0xa0, 0xab, 0x8a, 0xb5, 0xbe, 0x74, 0xc5, 0xe2, 0x24,
	0x6d, 0x9a, 0x03, 0xbf, 0x02, 0x3b, 0x4c, 0x02, 0x6c, 0xda, 0xc9, 0x8f, 0xdf, 0x25, 0x87, 0x69,
	0x96, 0xf0, 0xc2, 0x1f, 0xfa, 0x1d, 0xdc, 0x5e, 0x5c, 0xdb, 0x5d, 0xdc, 0xcb, 0x30, 0xbe, 0xf7,
	0x2e, 0x1b, 0x5d, 0x97, 0x38, 0xbc, 0xef, 0x5f, 0xa3, 0x6d, 0x6f, 0xc3, 0x96, 0x6c, 0x44, 0xc9,
	0xdf, 0xc6, 0x5d, 0xd8, 0x79, 0xc6, 0xa8, 0x4f, 0x1c, 0x72, 0x6d, 0xbb, 0x3f, 0x83, 0x62, 0xdf,
	0x8b, 0x04, 0x93, 0x5b, 0x39, 0x04, 0xdd, 0x05, 0x08, 0x23, 0xfe, 0x39, 0x1d, 0x09, 0x97, 0xe9,
	0x9c, 0xd9, 0xea, 0x6e, 0x52, 0xe3, 0x10, 0xc9, 0x33, 0x89, 0x8a, 0x43, 0x6f, 0x44, 0xa5, 0xc1,
	0x96, 0x32, 0x28, 0xa6, 0x3a, 0x87, 0x34, 0x1e, 0x40, 0xf9, 0x98, 0x05, 0xa4, 0xfb, 0x26, 0x8c,
	0x68, 0x1c, 0x33, 0x1e, 0x5c, 0xbb, 0xed, 0x1f, 0x2c, 0xa8, 0x76, 0x3c, 0xe1, 0xc9, 0x96, 0x40,
	0xcf, 0x42, 0x35, 0xc1, 0x50, 0x17, 0x76, 0xc3, 0xe4, 0x2c, 0xd2, 0xbb, 0xce, 0x73, 0x63, 0x43,
	0xc0, 0x96, 0x8e, 0x8d, 0x8b, 0xe1, 0xd2, 0x1d, 0x9e, 0xc0, 0xd6, 0x2b, 0x16, 0x10, 0x93, 0xd8,
	0xaf, 0x6f, 0x80, 0xaf, 0x1e, 0x12, 0x2b, 0x48, 0xe3, 0xbf, 0x16, 0xdc, 0x5a, 0x6e, 0x3d, 0xc9,
	0xc9, 0x3e, 0x81, 0xc2, 0x98, 0xf9, 0xd4, 0x8d, 0x69, 0xd2, 0x1b, 0x0f, 0x6f, 0xd0, 0xb8, 0x0c,
	0xba, 0xf9, 0x8c, 0xf9, 0xf4, 0x9c, 0x0a, 0xbc, 0x33, 0xd6, 0x0b, 0xd4, 0x82, 0xfd, 0xe1, 0x5c,
	0xd0, 0xd8, 0xf5, 0x25, 0x65, 0xdc, 0x90, 0x46, 0xae, 0xfc, 0xa4, 0xc2, 0x99, 0xc3, 0x7b, 0xea,
	0xdb, 0x89, 0xfc, 0xd4, 0xa7, 0x91, 0x04, 0xa3, 0x9f, 0x00, 0xa8, 0xfd, 0x65, 0x46, 0xe3, 0x5a,
	0xfe, 0x20, 0xf7, 0xa8, 0xbc, 0x71, 0x04, 0x4b, 0x80, 0x1a, 0xc1, 0xf6, 0xd8, 0xac, 0xe2, 0xfa,
	0x57, 0x25, 0x09, 0xf4, 0xde, 0x55, 0xc8, 0xcd, 0x22, 0xdf, 0x24, 0x43, 0x2e, 0x1b, 0x0f, 0xa1,
	0xba, 0xde, 0x6e, 0x65, 0xce, 0x54, 0x97, 0x36, 0x39, 0x93, 0xeb, 0xc6, 0xbf, 0x2c, 0xa8, 0xb4,
	0xd9, 0xe4, 0x17, 0x33, 0x1a, 0xcd, 0x17, 0x81, 0xa9, 0x08, 0x6f, 0xe8, 0x53, 0x37, 0xa2, 0x63,
	0x1a, 0xd1, 0x60, 0x94, 0xf4, 0xc4, 0x07, 0x1b, 0x4e, 0x97, 0x38, 0x18, 0x48, 0x14, 0x2e, 0x2b,
	0x30, 0x4e, 0xb0, 0xe8, 0x13, 0x40, 0x8c, 0xd0, 0x40, 0xb0, 0xf1, 0x9c, 0x05, 0x13, 0x77, 0x2c,
	0x89, 0x1b, 0xd7, 0xb2, 0x6a, 0xe8, 0x7d, 0xb0, 0xf1, 0xbe, 0x8a, 0xdd, 0x78, 0x6f, 0x09, 0xa9,
	0x74, 0xb1, 0x64, 0x73, 0xc4, 0xaf, 0x4c, 0x98, 0x55, 0xfd, 0xe5, 0xb0, 0x2d, 0x35, 0x2a, 0xb8,
	0x8d, 0xbf, 0xe6, 0xa1, 0x64, 0x2e, 0xfd, 0x94, 0x07, 0x63, 0x36, 0x41, 0xcf, 0x61, 0x8f, 0x24,
	0xac, 0x74, 0xb9, 0xbe, 0xa3, 0xe1, 0xd1, 0xa6, 0x49, 0xb5, 0xce, 0x62, 0x39, 0xa9, 0xc8, 0x3a,
	0xb3, 0x7f, 0x0d, 0xb7, 0x57, 0x47, 0x60, 0xe2, 0x5b, 0xf7, 0x84, 0xc7, 0x37, 0x27, 0x53, 0x2f,
	0x83, 0x6f, 0x8d, 0xae, 0x61, 0xe8, 0x00, 0xf6, 0x86, 0x6c, 0xe2, 0xfe, 0x46, 0xc6, 0x36, 0xf5,
	0xae, 0x1f, 0x23, 0x0f, 0xdf, 0x92, 0x8a, 0x85, 0xe7, 0xca, 0x70, 0x2d, 0xbd, 0x17, 0x50, 0x51,
	0xef, 0xc7, 0xd0, 0x0b, 0xdc, 0x91, 0x0a, 0x91, 0x7a, 0xc0, 0x6d, 0x7e, 0x81, 0xac, 0x84, 0xb3,
	0x39, 0x30, 0x58, 0x2d, 0xe2, 0xb2, 0x58, 0x91, 0xeb, 0x7f, 0xcc, 0x42, 0x79, 0xd5, 0x04, 0x3d,
	0x01, 0x88, 0x85, 0x17, 0x09, 0x57, 0x9a, 0x1a, 0x2a, 0xd5, 0x17, 0x7b, 0xe9, 0x37, 0xad, 0xf6,
	0x2b, 0xdf, 0xb4, 0xd8, 0x56, 0xd6, 0x52, 0x46, 0xdf, 0x83, 0x02, 0x0d, 0x88, 0x06, 0x66, 0xdf,
	0x0a, 0xdc, 0xa1, 0x01, 0x51, 0xb0, 0x8f, 0xcd, 0x15, 0xa5, 0x56, 0x13, 0xce, 0x24, 0xe5, 0x6d,
	0x7c, 0x2b, 0xa7, 0x30, 0xa5, 0x41, 0x2f, 0xe0, 0x9b, 0x34, 0x50, 0xb5, 0xe0, 0xcd, 0x04, 0x77,
	0x43, 0x1e, 0xce, 0x7c, 0xf5, 0x34, 0x77, 0xf9, 0xd8, 0x5d, 0x8f, 0xa2, 0xcc, 0x4c, 0x01, 0x3f,
	0xd0, 0x80, 0xa3, 0x99, 0xe0, 0xfd, 0xd4, 0xfc, 0x6c, 0xbc, 0x1a, 0x93, 0xb4, 0x93, 0xff, 0x16,
	0x8a, 0x49, 0xca, 0x8e, 0xe9, 0xfc, 0x7d, 0x97, 0x9e, 0xae, 0x15, 0x37, 0x98, 0x4d, 0x87, 0xe6,
	0x01, 0xa1, 0x6b, 0xe5, 0x54, 0x29, 0x1a, 0x0e, 0xec, 0xa6, 0x4c, 0x97, 0xbb, 0x3f, 0x01, 0x90,
	0xd5, 0x26, 0xe6, 0xee, 0x2b, 0x3a, 0xff, 0xff, 0x44, 0xad, 0xb6, 0x5a, 0x3a, 0xc7, 0xb6, 0xb6,
	0x3e, 0xa6, 0xf3, 0xc6, 0xbf, 0x2d, 0xc8, 0x49, 0x17, 0xef, 0xa9, 0xdd, 0xff, 0xc0, 0xb4, 0x2a,
	0xdd, 0x25, 0x1e, 0x6e, 0x3e, 0x43, 0x53, 0x76, 0xb6, 0xae, 0x4f, 0xd5, 0xf0, 0x54, 0x98, 0xfa,
	0x40, 0x4e, 0xbf, 0x54, 0x29, 0xbb, 0x9e, 0x9a, 0x1c, 0xa6, 0xeb, 0xc9, 0x35, 0xaa, 0x42, 0xd6,
	0x4c, 0xc2, 0x5c, 0x2f, 0x83, 0xb3, 0x8c, 0xa0, 0x7d, 0x33, 0xcf, 0x24, 0x4d, 0xec, 0x5e, 0x46,
	0x4f, 0xb4, 0xb6, 0x0d, 0x3b, 0x8c, 0xa8, 0x06, 0xdd, 0xf8, 0xb3, 0x05, 0x36, 0xa6, 0x23, 0x1e,
	0x11, 0x79, 0xcd, 0x9f, 0x43, 0x69, 0xd1, 0x53, 0x64, 0xb0, 0x34, 0x39, 0xef, 0xbf, 0xad, 0x9f,
	0x1c, 0x53, 0xf9, 0x2f, 0xcb, 0x2e, 0x59, 0x8e, 0x7a, 0x0f, 0x4a, 0x8b, 0x2a, 0x97, 0xbe, 0x72,
	0x5f, 0x18, 0xb3, 0x25, 0xba, 0xc8, 0x37, 0xe6, 0x70, 0x21, 0xa6, 0xa4, 0xba, 0x84, 0xd2, 0x0a,
	0x2f, 0xd6, 0x5e, 0x00, 0xd6, 0xfa, 0x0b, 0xe0, 0x2e, 0x80, 0x3a, 0x11, 0x5d, 0x7e, 0x20, 0x18,
	0x8d, 0x43, 0xd0, 0x1d, 0x28, 0x68, 0x52, 0x32, 0x5d, 0x46, 0x36, 0xde, 0x51, 0xb2, 0x43, 0x1a,
	0x3f, 0x83, 0x42, 0x57, 0x71, 0xc0, 0x21, 0xe8, 0xbb, 0x90, 0xd7, 0xa5, 0x66, 0xdd, 0xa8, 0xd4,
	0xb4, 0xf1, 0x63, 0x01, 0xb0, 0xf4, 0xce, 0xac, 0xc3, 0x57, 0x4e, 0x9c, 0xe3, 0xee, 0x89, 0xd3,
	0x3b, 0x3b, 0xeb, 0xb8, 0x9f, 0x9e, 0x9e, 0xf7, 0xbb, 0x4f, 0x9d, 0x67, 0x4e, 0xb7, 0x53, 0xcd,
	0xa0, 0x3d, 0x28, 0x3d, 0xef, 0xe2, 0x97, 0xee, 0xa7, 0xa7, 0xca, 0xe4, 0x65, 0xd5, 0x42, 0xbb,
	0x50, 0x48, 0xa5, 0xac, 0x94, 0xfa, 0x67, 0xe7, 0xe7, 0x4e, 0xfb, 0xa4, 0x5b, 0xcd, 0x21, 0x80,
	0x6d, 0xf3, 0x65, 0x0b, 0x55, 0xa0, 0xa8, 0xa0, 0x46, 0x91, 0x7f, 0xdc, 0x85, 0x42, 0x32, 0x52,
	0xd1, 0x1d, 0xb8, 0xfd, 0xcc, 0x39, 0xe9, 0xba, 0x83, 0x97, 0xfd, 0xee, 0xda, 0x96, 0x15, 0x28,
	0xb6, 0x9d, 0xd3, 0x23, 0xfc, 0xd2, 0x95, 0x16, 0x55, 0x0b, 0x95, 0xc0, 0x1e, 0x74, 0x3f, 0x1b,
	0x68, 0x31, 0xdb, 0xfe, 0xbd, 0x05, 0x77, 0x46, 0x7c, 0x7a, 0xfd, 0x4d, 0xdb, 0xd0, 0xf1, 0xc3,
	0x64, 0xfe, 0x5a, 0xbf, 0xfc, 0xbe, 0x31, 0x9a, 0x70, 0xdf, 0x0b, 0x26, 0x4d, 0x1e, 0x4d, 0x5a,
	0x13, 0x1a, 0xa8, 0x2e, 0xd6, 0xd2, 0x9f, 0xbc, 0x90, 0xc5, 0x6b, 0xbf, 0x1e, 0xfc, 0x90, 0xf8,
	0xe1, 0x5f, 0xb2, 0xb7, 0x3e, 0xd6, 0x50, 0x35, 0x3a, 0x9a, 0x1d, 0x3f, 0x6c, 0x3e, 0x3f, 0xfc,
	0x47, 0xa2, 0xbd, 0x50, 0xda, 0x8b, 0x8e, 0x1f, 0x5e, 0x3c, 0x3f, 0x1c, 0x6e, 0x2b, 0x87, 0x1f,
	0xfd, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x2c, 0x19, 0xec, 0xdb, 0x8d, 0x10, 0x00, 0x00,
}
