---
page_type: sample
languages:
  - python
products:
  - azure
  - azure-messaging-webpubsubservice
urlFragment: azure-messaging-webpubsubservice-samples
---

# Azure Web PubSub service client library for Python Samples

These are code samples that show common scenario operations with the Azure WebPubSub client library.
The async versions of the samples (the python sample files appended with `_async`) show asynchronous operations.

## Prerequisites

* Python 3.6 or later is required to use this package
* You need an [Azure subscription][azure_sub], and a [Azure WebPubSub service instance][webpubsubservice_docs] to use this package.

## Setup

1. Install the Azure Web PubSub service client library for Python with [pip](https://pypi.org/project/pip/):

```bash
pip install azure-messaging-webpubsubservice
```

2. Clone or download this sample repository
3. Open the sample folder in Visual Studio Code or your IDE of choice.

## Running the samples

1. Open a terminal window and `cd` to the directory that the samples are saved in.
2. Set the environment variables specified in the sample file you wish to run.
3. Follow the usage described in the file, e.g. `python get_client_access_token.py`

## More samples

Check [more samples here][servicesample].

## Next Steps

Take a look at our [API Documentation][apiref] for more information about the APIs that are available in the clients.


<!-- LINKS -->
[azure_sub]: https://azure.microsoft.com/free/
[webpubsubservice_docs]: https://aka.ms/awps/doc
[servicesample]: https://github.com/Azure/azure-webpubsub/tree/main/samples/python
[apiref]: https://aka.ms/awps/sdk/python
