# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AclFailedEntry(msrest.serialization.Model):
    """AclFailedEntry.

    :param name:
    :type name: str
    :param type:
    :type type: str
    :param error_message:
    :type error_message: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        super(AclFailedEntry, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.error_message = error_message


class FileSystem(msrest.serialization.Model):
    """FileSystem.

    :param name:
    :type name: str
    :param last_modified:
    :type last_modified: str
    :param e_tag:
    :type e_tag: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        last_modified: Optional[str] = None,
        e_tag: Optional[str] = None,
        **kwargs
    ):
        super(FileSystem, self).__init__(**kwargs)
        self.name = name
        self.last_modified = last_modified
        self.e_tag = e_tag


class FileSystemList(msrest.serialization.Model):
    """FileSystemList.

    :param filesystems:
    :type filesystems: list[~azure.storage.filedatalake.models.FileSystem]
    """

    _attribute_map = {
        'filesystems': {'key': 'filesystems', 'type': '[FileSystem]'},
    }

    def __init__(
        self,
        *,
        filesystems: Optional[List["FileSystem"]] = None,
        **kwargs
    ):
        super(FileSystemList, self).__init__(**kwargs)
        self.filesystems = filesystems


class LeaseAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :param lease_id: If specified, the operation only succeeds if the resource's lease is active
     and matches this ID.
    :type lease_id: str
    """

    _attribute_map = {
        'lease_id': {'key': 'leaseId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lease_id: Optional[str] = None,
        **kwargs
    ):
        super(LeaseAccessConditions, self).__init__(**kwargs)
        self.lease_id = lease_id


class ModifiedAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :param if_modified_since: Specify this header value to operate only on a blob if it has been
     modified since the specified date/time.
    :type if_modified_since: ~datetime.datetime
    :param if_unmodified_since: Specify this header value to operate only on a blob if it has not
     been modified since the specified date/time.
    :type if_unmodified_since: ~datetime.datetime
    :param if_match: Specify an ETag value to operate only on blobs with a matching value.
    :type if_match: str
    :param if_none_match: Specify an ETag value to operate only on blobs without a matching value.
    :type if_none_match: str
    """

    _attribute_map = {
        'if_modified_since': {'key': 'ifModifiedSince', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': 'ifUnmodifiedSince', 'type': 'rfc-1123'},
        'if_match': {'key': 'ifMatch', 'type': 'str'},
        'if_none_match': {'key': 'ifNoneMatch', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs
    ):
        super(ModifiedAccessConditions, self).__init__(**kwargs)
        self.if_modified_since = if_modified_since
        self.if_unmodified_since = if_unmodified_since
        self.if_match = if_match
        self.if_none_match = if_none_match


class Path(msrest.serialization.Model):
    """Path.

    :param name:
    :type name: str
    :param is_directory:
    :type is_directory: bool
    :param last_modified:
    :type last_modified: str
    :param e_tag:
    :type e_tag: str
    :param content_length:
    :type content_length: long
    :param owner:
    :type owner: str
    :param group:
    :type group: str
    :param permissions:
    :type permissions: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_directory': {'key': 'isDirectory', 'type': 'bool'},
        'last_modified': {'key': 'lastModified', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'content_length': {'key': 'contentLength', 'type': 'long'},
        'owner': {'key': 'owner', 'type': 'str'},
        'group': {'key': 'group', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_directory: Optional[bool] = False,
        last_modified: Optional[str] = None,
        e_tag: Optional[str] = None,
        content_length: Optional[int] = None,
        owner: Optional[str] = None,
        group: Optional[str] = None,
        permissions: Optional[str] = None,
        **kwargs
    ):
        super(Path, self).__init__(**kwargs)
        self.name = name
        self.is_directory = is_directory
        self.last_modified = last_modified
        self.e_tag = e_tag
        self.content_length = content_length
        self.owner = owner
        self.group = group
        self.permissions = permissions


class PathHTTPHeaders(msrest.serialization.Model):
    """Parameter group.

    :param cache_control: Optional. Sets the blob's cache control. If specified, this property is
     stored with the blob and returned with a read request.
    :type cache_control: str
    :param content_encoding: Optional. Sets the blob's content encoding. If specified, this
     property is stored with the blob and returned with a read request.
    :type content_encoding: str
    :param content_language: Optional. Set the blob's content language. If specified, this property
     is stored with the blob and returned with a read request.
    :type content_language: str
    :param content_disposition: Optional. Sets the blob's Content-Disposition header.
    :type content_disposition: str
    :param content_type: Optional. Sets the blob's content type. If specified, this property is
     stored with the blob and returned with a read request.
    :type content_type: str
    :param content_md5: Specify the transactional md5 for the body, to be validated by the service.
    :type content_md5: bytearray
    :param transactional_content_hash: Specify the transactional md5 for the body, to be validated
     by the service.
    :type transactional_content_hash: bytearray
    """

    _attribute_map = {
        'cache_control': {'key': 'cacheControl', 'type': 'str'},
        'content_encoding': {'key': 'contentEncoding', 'type': 'str'},
        'content_language': {'key': 'contentLanguage', 'type': 'str'},
        'content_disposition': {'key': 'contentDisposition', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_md5': {'key': 'contentMD5', 'type': 'bytearray'},
        'transactional_content_hash': {'key': 'transactionalContentHash', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        cache_control: Optional[str] = None,
        content_encoding: Optional[str] = None,
        content_language: Optional[str] = None,
        content_disposition: Optional[str] = None,
        content_type: Optional[str] = None,
        content_md5: Optional[bytearray] = None,
        transactional_content_hash: Optional[bytearray] = None,
        **kwargs
    ):
        super(PathHTTPHeaders, self).__init__(**kwargs)
        self.cache_control = cache_control
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_disposition = content_disposition
        self.content_type = content_type
        self.content_md5 = content_md5
        self.transactional_content_hash = transactional_content_hash


class PathList(msrest.serialization.Model):
    """PathList.

    :param paths:
    :type paths: list[~azure.storage.filedatalake.models.Path]
    """

    _attribute_map = {
        'paths': {'key': 'paths', 'type': '[Path]'},
    }

    def __init__(
        self,
        *,
        paths: Optional[List["Path"]] = None,
        **kwargs
    ):
        super(PathList, self).__init__(**kwargs)
        self.paths = paths


class SetAccessControlRecursiveResponse(msrest.serialization.Model):
    """SetAccessControlRecursiveResponse.

    :param directories_successful:
    :type directories_successful: int
    :param files_successful:
    :type files_successful: int
    :param failure_count:
    :type failure_count: int
    :param failed_entries:
    :type failed_entries: list[~azure.storage.filedatalake.models.AclFailedEntry]
    """

    _attribute_map = {
        'directories_successful': {'key': 'directoriesSuccessful', 'type': 'int'},
        'files_successful': {'key': 'filesSuccessful', 'type': 'int'},
        'failure_count': {'key': 'failureCount', 'type': 'int'},
        'failed_entries': {'key': 'failedEntries', 'type': '[AclFailedEntry]'},
    }

    def __init__(
        self,
        *,
        directories_successful: Optional[int] = None,
        files_successful: Optional[int] = None,
        failure_count: Optional[int] = None,
        failed_entries: Optional[List["AclFailedEntry"]] = None,
        **kwargs
    ):
        super(SetAccessControlRecursiveResponse, self).__init__(**kwargs)
        self.directories_successful = directories_successful
        self.files_successful = files_successful
        self.failure_count = failure_count
        self.failed_entries = failed_entries


class SourceModifiedAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :param source_if_match: Specify an ETag value to operate only on blobs with a matching value.
    :type source_if_match: str
    :param source_if_none_match: Specify an ETag value to operate only on blobs without a matching
     value.
    :type source_if_none_match: str
    :param source_if_modified_since: Specify this header value to operate only on a blob if it has
     been modified since the specified date/time.
    :type source_if_modified_since: ~datetime.datetime
    :param source_if_unmodified_since: Specify this header value to operate only on a blob if it
     has not been modified since the specified date/time.
    :type source_if_unmodified_since: ~datetime.datetime
    """

    _attribute_map = {
        'source_if_match': {'key': 'sourceIfMatch', 'type': 'str'},
        'source_if_none_match': {'key': 'sourceIfNoneMatch', 'type': 'str'},
        'source_if_modified_since': {'key': 'sourceIfModifiedSince', 'type': 'rfc-1123'},
        'source_if_unmodified_since': {'key': 'sourceIfUnmodifiedSince', 'type': 'rfc-1123'},
    }

    def __init__(
        self,
        *,
        source_if_match: Optional[str] = None,
        source_if_none_match: Optional[str] = None,
        source_if_modified_since: Optional[datetime.datetime] = None,
        source_if_unmodified_since: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SourceModifiedAccessConditions, self).__init__(**kwargs)
        self.source_if_match = source_if_match
        self.source_if_none_match = source_if_none_match
        self.source_if_modified_since = source_if_modified_since
        self.source_if_unmodified_since = source_if_unmodified_since


class StorageError(msrest.serialization.Model):
    """StorageError.

    :param error: The service error response object.
    :type error: ~azure.storage.filedatalake.models.StorageErrorAutoGenerated
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'StorageErrorAutoGenerated'},
    }

    def __init__(
        self,
        *,
        error: Optional["StorageErrorAutoGenerated"] = None,
        **kwargs
    ):
        super(StorageError, self).__init__(**kwargs)
        self.error = error


class StorageErrorAutoGenerated(msrest.serialization.Model):
    """The service error response object.

    :param code: The service error code.
    :type code: str
    :param message: The service error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(StorageErrorAutoGenerated, self).__init__(**kwargs)
        self.code = code
        self.message = message
