# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.pipeline.transport import HttpRequest, HttpResponse

from ._configuration import AzureArcVMwareManagementServiceAPIConfiguration
from .operations import Operations
from .operations import ResourcePoolsOperations
from .operations import ClustersOperations
from .operations import HostsOperations
from .operations import DatastoresOperations
from .operations import VCentersOperations
from .operations import VirtualMachinesOperations
from .operations import VirtualMachineTemplatesOperations
from .operations import VirtualNetworksOperations
from .operations import InventoryItemsOperations
from .operations import HybridIdentityMetadataOperations
from .operations import MachineExtensionsOperations
from .operations import GuestAgentsOperations
from . import models


class AzureArcVMwareManagementServiceAPI(object):
    """Self service experience for VMware.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.connectedvmware.operations.Operations
    :ivar resource_pools: ResourcePoolsOperations operations
    :vartype resource_pools: azure.mgmt.connectedvmware.operations.ResourcePoolsOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.connectedvmware.operations.ClustersOperations
    :ivar hosts: HostsOperations operations
    :vartype hosts: azure.mgmt.connectedvmware.operations.HostsOperations
    :ivar datastores: DatastoresOperations operations
    :vartype datastores: azure.mgmt.connectedvmware.operations.DatastoresOperations
    :ivar vcenters: VCentersOperations operations
    :vartype vcenters: azure.mgmt.connectedvmware.operations.VCentersOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.connectedvmware.operations.VirtualMachinesOperations
    :ivar virtual_machine_templates: VirtualMachineTemplatesOperations operations
    :vartype virtual_machine_templates: azure.mgmt.connectedvmware.operations.VirtualMachineTemplatesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks: azure.mgmt.connectedvmware.operations.VirtualNetworksOperations
    :ivar inventory_items: InventoryItemsOperations operations
    :vartype inventory_items: azure.mgmt.connectedvmware.operations.InventoryItemsOperations
    :ivar hybrid_identity_metadata: HybridIdentityMetadataOperations operations
    :vartype hybrid_identity_metadata: azure.mgmt.connectedvmware.operations.HybridIdentityMetadataOperations
    :ivar machine_extensions: MachineExtensionsOperations operations
    :vartype machine_extensions: azure.mgmt.connectedvmware.operations.MachineExtensionsOperations
    :ivar guest_agents: GuestAgentsOperations operations
    :vartype guest_agents: azure.mgmt.connectedvmware.operations.GuestAgentsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The Subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = AzureArcVMwareManagementServiceAPIConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.resource_pools = ResourcePoolsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.clusters = ClustersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.hosts = HostsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.datastores = DatastoresOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vcenters = VCentersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_templates = VirtualMachineTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.inventory_items = InventoryItemsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.hybrid_identity_metadata = HybridIdentityMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.machine_extensions = MachineExtensionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.guest_agents = GuestAgentsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, http_request, **kwargs):
        # type: (HttpRequest, Any) -> HttpResponse
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.HttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> AzureArcVMwareManagementServiceAPI
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
