---
layout: "tls"
page_title: "TLS: tls_private_key"
sidebar_current: "docs-tls-resource-private-key"
description: |-
  Creates a PEM-encoded private key.
---

# tls\_private\_key

Generates a secure private key and encodes it as PEM. This resource is
primarily intended for easily bootstrapping throwaway development
environments.

~> **Important Security Notice** The private key generated by this resource will
be stored *unencrypted* in your Terraform state file. **Use of this resource
for production deployments is *not* recommended**. Instead, generate
a private key file outside of Terraform and distribute it securely
to the system where Terraform will be run.

This is a *logical resource*, so it contributes only to the current Terraform
state and does not create any external managed resources.

## Example Usage

```hcl
resource "tls_private_key" "example" {
  algorithm   = "ECDSA"
  ecdsa_curve = "P384"
}
```

## Argument Reference

The following arguments are supported:

* `algorithm` - (Required) The name of the algorithm to use for
the key. Currently-supported values are "RSA" and "ECDSA".

* `rsa_bits` - (Optional) When `algorithm` is "RSA", the size of the generated
RSA key in bits. Defaults to 2048.

* `ecdsa_curve` - (Optional) When `algorithm` is "ECDSA", the name of the elliptic
curve to use. May be any one of "P224", "P256", "P384" or "P521", with "P224" as the
default.

## Attributes Reference

The following attributes are exported:

* `algorithm` - The algorithm that was selected for the key.
* `private_key_pem` - The private key data in PEM format.
* `public_key_pem` - The public key data in PEM format.
* `public_key_openssh` - The public key data in OpenSSH `authorized_keys`
  format, if the selected private key format is compatible. All RSA keys
  are supported, and ECDSA keys with curves "P256", "P384" and "P521"
  are supported. This attribute is empty if an incompatible ECDSA curve
  is selected.
* `public_key_fingerprint_md5` - The md5 hash of the public key data in
  OpenSSH MD5 hash format, e.g. `aa:bb:cc:...`. Only available if the
  selected private key format is compatible, as per the rules for
  `public_key_openssh`.

## Generating a New Key

Since a private key is a logical resource that lives only in the Terraform state,
it will persist until it is explicitly destroyed by the user.

In order to force the generation of a new key within an existing state, the
private key instance can be "tainted":

```
terraform taint tls_private_key.example
```

A new key will then be generated on the next ``terraform apply``.
