package provider

import (
	"testing"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func TestProvider(t *testing.T) {
	if err := New().InternalValidate(); err != nil {
		t.Fatalf("err: %s", err)
	}
}

var testProviders = map[string]*schema.Provider{
	"tls": New(),
}

var testPrivateKey = `
-----BEGIN RSA PRIVATE KEY-----
MIICXAIBAAKBgQDPLaq43D9C596ko9yQipWUf2FbRhFs18D3wBDBqXLIoP7W3rm5
S292/JiNPa+mX76IYFF416zTBGG9J5w4d4VFrROn8IuMWqHgdXsCUf2szN7EnJcV
BsBzTxxWqz4DjX315vbm/PFOLlKzC0Ngs4h1iDiCD9Hk2MajZuFnJiqj1QIDAQAB
AoGAG6eQ3lQn7Zpd0cQ9sN2O0d+e8zwLH2g9TdTJZ9Bijf1Phwb764vyOQPGqTPO
unqVSEbzGRpQ62nuUf1zkOYDV+gKMNO3mj9Zu+qPNr/nQPHIaGZksPdD34qDUnBl
eRWVGNTyEGQsRPNN0RtFj8ifa4+OWiE30n95PBq2bUGZj4ECQQDZvS5X/4jYxnzw
CscaL4vO9OCVd/Fzdpfak0DQE/KCVmZxzcXu6Q8WuhybCynX84WKHQxuFAo+nBvr
kgtWXX7dAkEA85Vs5ehuDujBKCu3NJYI2R5ie49L9fEMFJVZK9FpkKacoAkET5BZ
UzaZrx4Fg3Zhcv1TssZKSyle+2lYiIydWQJBAMW8/aJi6WdcUsg4MXrBZSlsz6xO
AhOGxv90LS8KfnkJd/2wDyoZs19DY4kWSUjZ2hOEr+4j+u3DHcQAnJUxUW0CQGXP
DrUJcPbKUfF4VBqmmwwkpwT938Hr/iCcS6kE3hqXiN9a5XJb4vnk2FdZNPS9hf2J
5HHUbzj7EbgDT/3CyAECQG0qv6LNQaQMm2lmQKmqpi43Bqj9wvx0xGai1qCOvSeL
rpxCHbX0xSJh0s8j7exRHMF8W16DHjjkc265YdWPXWo=
-----END RSA PRIVATE KEY-----
`

var testCertRequest = `
-----BEGIN CERTIFICATE REQUEST-----
MIICnjCCAgcCAQAwgcUxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTEWMBQGA1UE
BxMNUGlyYXRlIEhhcmJvcjEZMBcGA1UECRMQNTg3OSBDb3R0b24gTGluazETMBEG
A1UEERMKOTU1NTktMTIyNzEVMBMGA1UEChMMRXhhbXBsZSwgSW5jMSgwJgYDVQQL
Ex9EZXBhcnRtZW50IG9mIFRlcnJhZm9ybSBUZXN0aW5nMRQwEgYDVQQDEwtleGFt
cGxlLmNvbTEKMAgGA1UEBRMBMjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA
zy2quNw/QufepKPckIqVlH9hW0YRbNfA98AQwalyyKD+1t65uUtvdvyYjT2vpl++
iGBReNes0wRhvSecOHeFRa0Tp/CLjFqh4HV7AlH9rMzexJyXFQbAc08cVqs+A419
9eb25vzxTi5SswtDYLOIdYg4gg/R5NjGo2bhZyYqo9UCAwEAAaCBlzCBlAYJKoZI
hvcNAQkOMYGGMIGDMIGABgNVHREEeTB3ggtleGFtcGxlLmNvbYILZXhhbXBsZS5u
ZXSHBH8AAAGHBH8AAAKGJnNwaWZmZTovL2V4YW1wbGUtdHJ1c3QtZG9tYWluL3dv
cmtsb2FkhidzcGlmZmU6Ly9leGFtcGxlLXRydXN0LWRvbWFpbi93b3JrbG9hZDIw
DQYJKoZIhvcNAQELBQADgYEAx1/DOJKVylgc47ptL3PlyUOyChLLRKpo9ExREdgF
bYBYT5Zx2EYWdQ+wc6qnMGzEr8TnGodYKxdF2awjTX5s0Cz4UgE5Q07yttLWIZwy
ynTNwKyKaFWqB0r8hTuh60yRA5iBUNrQrpjVS6RuadFXep4fUV1mleVdUWFupzhr
9FY=
-----END CERTIFICATE REQUEST-----
`

// see ../scripts/make-test-ca.tf for a Terraform script to create the following two items

var testCAPrivateKey = `
-----BEGIN RSA PRIVATE KEY-----
MIICXwIBAAKBgQDl2WBP6QneAgKo+Tlim7iVldMcUVC6AbgTE5+MuDu7/ovwR6ic
jMcj7UX8Zc8hLV3Kv0QVnqRWbLfEcdF52ZRXQ2D8+DBFnDv1BUkXPfZZv/ZNeP/p
pRCRPmCn/nU9s88z5H6Bg+RPMulvDHJ5t10tBRrbl8s6KJJWhfvTrPH36wIDAQAB
AoGBAJNSbw8JGU/5DedsRsHTec43B+dAn3N5ophnnX4+n9rxXpSV+ZbODN4UOSV7
w/VJ9LH9QhBxbHgQmwEIyvFE6nSFCcdeJ71BUiKct40b9BP3sX17Sw+vROyvFp4b
4bxfJi7rNurPdbvVCxxKd/v6Odu02+s+J8bW1xg07BlQMTYBAkEA6clK0ukQP8ZP
mWtQCqr7haAoJqZaPwjZ4lxDxUZmyxU9tcRaB256Ghr0KBkkeADjrH1t9mIp4m8A
2pOUG3VGgQJBAPuwUI0CffBJyqDcqGcHQgZIHyABzreOj31xY1e9ttwI2MM5OL49
VGpqpWvJ209jwjSM/0kSirffG6BvfKstgGsCQQCKojpDrb9cAi5LrQ5O9SuoBtwo
ZzdW79m82Le7cU8dmJ/6fNBiXcn8VwV4DcjJfMWGEO83TujFhMu90gve6IGBAkEA
gzz7s5tyCeKgauLEWPy628WtnSX0IViPz6xZTb4Z5IAkbx+eS+x04Qx890iJN8tf
z8EZuIOXm6sVn8GicyvFwwJBAOBrRWofUnvlqpJnry2kaX8l/JrDl5c0Jd+X9eMz
XAWTv3RMk1fAo/H84BCCu04JohkBXjBU5Pkop2/0bV9j/ng=
-----END RSA PRIVATE KEY-----
`

var testCACert = `
-----BEGIN CERTIFICATE-----
MIICvjCCAiegAwIBAgIRALLBfPvp1FbuS+9+mLIHscgwDQYJKoZIhvcNAQELBQAw
ezELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1QaXJhdGUgSGFy
Ym9yMRUwEwYDVQQKEwxFeGFtcGxlLCBJbmMxITAfBgNVBAsTGERlcGFydG1lbnQg
b2YgQ0EgVGVzdGluZzENMAsGA1UEAxMEcm9vdDAeFw0xNzEwMTYxOTIyMDlaFw0y
NzEwMTQxOTIyMDlaMHsxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTEWMBQGA1UE
BxMNUGlyYXRlIEhhcmJvcjEVMBMGA1UEChMMRXhhbXBsZSwgSW5jMSEwHwYDVQQL
ExhEZXBhcnRtZW50IG9mIENBIFRlc3RpbmcxDTALBgNVBAMTBHJvb3QwgZ8wDQYJ
KoZIhvcNAQEBBQADgY0AMIGJAoGBAOXZYE/pCd4CAqj5OWKbuJWV0xxRULoBuBMT
n4y4O7v+i/BHqJyMxyPtRfxlzyEtXcq/RBWepFZst8Rx0XnZlFdDYPz4MEWcO/UF
SRc99lm/9k14/+mlEJE+YKf+dT2zzzPkfoGD5E8y6W8Mcnm3XS0FGtuXyzooklaF
+9Os8ffrAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwICBDAPBgNVHRMBAf8EBTADAQH/
MB0GA1UdDgQWBBTyJ+eBF13nq/OrHTAtXQxSYWT/UTANBgkqhkiG9w0BAQsFAAOB
gQDcpC/LqiMUhSvluRBitI5ZLUn7V7jT1C3AuGW1LrTlb/q8nnhu2Gi8HY0csHvH
4ezq8b95FJv+e/oo9ztExZ2trZ0HJ4wqTIlyN9W1DZvPQTC7gtyEFY1XvCScNoPb
UI+cIbsQJcr9i0SADwhqs7XYIcEz9jDqrdezenaXdGtXYg==
-----END CERTIFICATE-----
`

func setTimeForTest(timeStr string) func() {
	return func() {
		now = func() time.Time {
			t, _ := time.Parse(time.RFC3339, timeStr)
			return t
		}
	}
}
