// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/home/graph/v1/homegraph.proto

/*
Package graph is a generated protocol buffer package.

It is generated from these files:
	google/home/graph/v1/homegraph.proto

It has these top-level messages:
	RequestSyncDevicesRequest
	RequestSyncDevicesResponse
	ReportStateAndNotificationRequest
	ReportStateAndNotificationResponse
	StateAndNotificationPayload
	ReportStateAndNotificationDevice
	DeleteAgentUserRequest
*/
package graph

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/struct"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request type for RequestSyncDevices call.
type RequestSyncDevicesRequest struct {
	// Required. Third-party user id issued by agent's third-party identity
	// provider.
	AgentUserId string `protobuf:"bytes,1,opt,name=agent_user_id,json=agentUserId" json:"agent_user_id,omitempty"`
}

func (m *RequestSyncDevicesRequest) Reset()                    { *m = RequestSyncDevicesRequest{} }
func (m *RequestSyncDevicesRequest) String() string            { return proto.CompactTextString(m) }
func (*RequestSyncDevicesRequest) ProtoMessage()               {}
func (*RequestSyncDevicesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *RequestSyncDevicesRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

// Response type for RequestSyncDevices call. Intentionally empty upon success.
// An HTTP response code is returned with more details upon failure.
type RequestSyncDevicesResponse struct {
}

func (m *RequestSyncDevicesResponse) Reset()                    { *m = RequestSyncDevicesResponse{} }
func (m *RequestSyncDevicesResponse) String() string            { return proto.CompactTextString(m) }
func (*RequestSyncDevicesResponse) ProtoMessage()               {}
func (*RequestSyncDevicesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Sample ReportStateAndNotificationRequest, with states and notifications
// defined per device_id (eg: "123" and "456" in the following example):
// {
//   "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf",
//   "agent_user_id": "1234",
//   "payload": {
//     "devices": {
//       "states": {
//         "123": {
//           "on": true
//         },
//         "456": {
//           "on": true,
//           "brightness": 10
//         }
//       },
//       "notifications": {
//         "123": {
//           "ObjectDetected": {
//             "priority": 0,
//             "objects": {
//               "NAMED": ["Alice", "Bob", "Carol", "Eve"]
//             }
//           },
//           "DoorUnlocked": {
//             "priority": 0,
//             "keyUsed": {
//               "keyName": "Wife's key"
//             }
//           }
//         },
//         "456": {
//           "SprinklersOn": {
//             "priority": 0,
//             "timeStarted": "1513792702"
//           }
//         }
//       }
//     }
//   }
// }
// Request type for ReportStateAndNotification call. It may include States,
// Notifications, or both. This request uses globally unique flattened state
// names instead of namespaces based on traits to align with the existing QUERY
// and EXECUTE APIs implemented by 90+ Smart Home partners.
// Next tag: 5.
type ReportStateAndNotificationRequest struct {
	// Request id used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
	// Unique identifier per event (eg: doorbell press).
	EventId string `protobuf:"bytes,4,opt,name=event_id,json=eventId" json:"event_id,omitempty"`
	// Required. Third-party user id.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId" json:"agent_user_id,omitempty"`
	// State of devices to update and notification metadata for devices. For
	// example, if a user turns a light on manually, a State update should be
	// sent so that the information is always the current status of the device.
	// Notifications are independent from the state and its piece of the payload
	// should contain everything necessary to notify the user. Although it may be
	// related to a state change, it does not need to be. For example, if a
	// device can turn on/off and change temperature, the states reported would
	// include both "on" and "70 degrees" but the 3p may choose not to send any
	// notification for that, or to only say that the "the room is heating up",
	// keeping state and notification independent.
	Payload *StateAndNotificationPayload `protobuf:"bytes,3,opt,name=payload" json:"payload,omitempty"`
}

func (m *ReportStateAndNotificationRequest) Reset()         { *m = ReportStateAndNotificationRequest{} }
func (m *ReportStateAndNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*ReportStateAndNotificationRequest) ProtoMessage()    {}
func (*ReportStateAndNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{2}
}

func (m *ReportStateAndNotificationRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ReportStateAndNotificationRequest) GetEventId() string {
	if m != nil {
		return m.EventId
	}
	return ""
}

func (m *ReportStateAndNotificationRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

func (m *ReportStateAndNotificationRequest) GetPayload() *StateAndNotificationPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Response type for ReportStateAndNotification call.
type ReportStateAndNotificationResponse struct {
	// Request id copied from ReportStateAndNotificationRequest.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *ReportStateAndNotificationResponse) Reset()         { *m = ReportStateAndNotificationResponse{} }
func (m *ReportStateAndNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*ReportStateAndNotificationResponse) ProtoMessage()    {}
func (*ReportStateAndNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{3}
}

func (m *ReportStateAndNotificationResponse) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Payload containing the State and Notification information for devices.
type StateAndNotificationPayload struct {
	// The devices for updating State and sending Notifications.
	Devices *ReportStateAndNotificationDevice `protobuf:"bytes,1,opt,name=devices" json:"devices,omitempty"`
}

func (m *StateAndNotificationPayload) Reset()                    { *m = StateAndNotificationPayload{} }
func (m *StateAndNotificationPayload) String() string            { return proto.CompactTextString(m) }
func (*StateAndNotificationPayload) ProtoMessage()               {}
func (*StateAndNotificationPayload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *StateAndNotificationPayload) GetDevices() *ReportStateAndNotificationDevice {
	if m != nil {
		return m.Devices
	}
	return nil
}

// The States and Notifications specific to a device.
type ReportStateAndNotificationDevice struct {
	// States of devices to update.
	States *google_protobuf2.Struct `protobuf:"bytes,1,opt,name=states" json:"states,omitempty"`
	// Notifications metadata for devices.
	Notifications *google_protobuf2.Struct `protobuf:"bytes,2,opt,name=notifications" json:"notifications,omitempty"`
}

func (m *ReportStateAndNotificationDevice) Reset()         { *m = ReportStateAndNotificationDevice{} }
func (m *ReportStateAndNotificationDevice) String() string { return proto.CompactTextString(m) }
func (*ReportStateAndNotificationDevice) ProtoMessage()    {}
func (*ReportStateAndNotificationDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{5}
}

func (m *ReportStateAndNotificationDevice) GetStates() *google_protobuf2.Struct {
	if m != nil {
		return m.States
	}
	return nil
}

func (m *ReportStateAndNotificationDevice) GetNotifications() *google_protobuf2.Struct {
	if m != nil {
		return m.Notifications
	}
	return nil
}

// Request type for DeleteAgentUser call.
type DeleteAgentUserRequest struct {
	// Request id used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
	// Required. Third-party user id.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId" json:"agent_user_id,omitempty"`
}

func (m *DeleteAgentUserRequest) Reset()                    { *m = DeleteAgentUserRequest{} }
func (m *DeleteAgentUserRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteAgentUserRequest) ProtoMessage()               {}
func (*DeleteAgentUserRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *DeleteAgentUserRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *DeleteAgentUserRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

func init() {
	proto.RegisterType((*RequestSyncDevicesRequest)(nil), "google.home.graph.v1.RequestSyncDevicesRequest")
	proto.RegisterType((*RequestSyncDevicesResponse)(nil), "google.home.graph.v1.RequestSyncDevicesResponse")
	proto.RegisterType((*ReportStateAndNotificationRequest)(nil), "google.home.graph.v1.ReportStateAndNotificationRequest")
	proto.RegisterType((*ReportStateAndNotificationResponse)(nil), "google.home.graph.v1.ReportStateAndNotificationResponse")
	proto.RegisterType((*StateAndNotificationPayload)(nil), "google.home.graph.v1.StateAndNotificationPayload")
	proto.RegisterType((*ReportStateAndNotificationDevice)(nil), "google.home.graph.v1.ReportStateAndNotificationDevice")
	proto.RegisterType((*DeleteAgentUserRequest)(nil), "google.home.graph.v1.DeleteAgentUserRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HomeGraphApiService service

type HomeGraphApiServiceClient interface {
	// Requests a Sync call from Google to a 3p partner's home control agent for
	// a user.
	//
	//
	// Third-party user's identity is passed in as agent_user_id.
	// (see [RequestSyncDevicesRequest][google.home.graph.v1.RequestSyncDevicesRequest]) and forwarded back to the agent.
	// Agent is identified by the API key or JWT signed by the partner's service
	// account.
	RequestSyncDevices(ctx context.Context, in *RequestSyncDevicesRequest, opts ...grpc.CallOption) (*RequestSyncDevicesResponse, error)
	// Reports device state and optionally sends device notifications. Called by
	// an agent when the device state of a third-party changes or the agent wants
	// to send a notification about the device.
	// This method updates a predefined set of States for a device, which all
	// devices have (for example a light will have OnOff, Color, Brightness).
	// A new State may not be created and an INVALID_ARGUMENT code will be thrown
	// if so. It also optionally takes in a list of Notifications that may be
	// created, which are associated to this State change.
	//
	// Third-party user's identity is passed in as agent_user_id.
	// Agent is identified by the JWT signed by the partner's service account.
	ReportStateAndNotification(ctx context.Context, in *ReportStateAndNotificationRequest, opts ...grpc.CallOption) (*ReportStateAndNotificationResponse, error)
	// Unlink an agent user from Google. As result, all data related to this user
	// will be deleted.
	//
	// Third-party user's identity is passed in as agent_user_id.
	// Agent is identified by the JWT signed by the partner's service account.
	//
	// Note: Special characters (except "/") in agent_user_id must be URL encoded.
	DeleteAgentUser(ctx context.Context, in *DeleteAgentUserRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type homeGraphApiServiceClient struct {
	cc *grpc.ClientConn
}

func NewHomeGraphApiServiceClient(cc *grpc.ClientConn) HomeGraphApiServiceClient {
	return &homeGraphApiServiceClient{cc}
}

func (c *homeGraphApiServiceClient) RequestSyncDevices(ctx context.Context, in *RequestSyncDevicesRequest, opts ...grpc.CallOption) (*RequestSyncDevicesResponse, error) {
	out := new(RequestSyncDevicesResponse)
	err := grpc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/RequestSyncDevices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) ReportStateAndNotification(ctx context.Context, in *ReportStateAndNotificationRequest, opts ...grpc.CallOption) (*ReportStateAndNotificationResponse, error) {
	out := new(ReportStateAndNotificationResponse)
	err := grpc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/ReportStateAndNotification", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) DeleteAgentUser(ctx context.Context, in *DeleteAgentUserRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/DeleteAgentUser", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HomeGraphApiService service

type HomeGraphApiServiceServer interface {
	// Requests a Sync call from Google to a 3p partner's home control agent for
	// a user.
	//
	//
	// Third-party user's identity is passed in as agent_user_id.
	// (see [RequestSyncDevicesRequest][google.home.graph.v1.RequestSyncDevicesRequest]) and forwarded back to the agent.
	// Agent is identified by the API key or JWT signed by the partner's service
	// account.
	RequestSyncDevices(context.Context, *RequestSyncDevicesRequest) (*RequestSyncDevicesResponse, error)
	// Reports device state and optionally sends device notifications. Called by
	// an agent when the device state of a third-party changes or the agent wants
	// to send a notification about the device.
	// This method updates a predefined set of States for a device, which all
	// devices have (for example a light will have OnOff, Color, Brightness).
	// A new State may not be created and an INVALID_ARGUMENT code will be thrown
	// if so. It also optionally takes in a list of Notifications that may be
	// created, which are associated to this State change.
	//
	// Third-party user's identity is passed in as agent_user_id.
	// Agent is identified by the JWT signed by the partner's service account.
	ReportStateAndNotification(context.Context, *ReportStateAndNotificationRequest) (*ReportStateAndNotificationResponse, error)
	// Unlink an agent user from Google. As result, all data related to this user
	// will be deleted.
	//
	// Third-party user's identity is passed in as agent_user_id.
	// Agent is identified by the JWT signed by the partner's service account.
	//
	// Note: Special characters (except "/") in agent_user_id must be URL encoded.
	DeleteAgentUser(context.Context, *DeleteAgentUserRequest) (*google_protobuf1.Empty, error)
}

func RegisterHomeGraphApiServiceServer(s *grpc.Server, srv HomeGraphApiServiceServer) {
	s.RegisterService(&_HomeGraphApiService_serviceDesc, srv)
}

func _HomeGraphApiService_RequestSyncDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestSyncDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).RequestSyncDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/RequestSyncDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).RequestSyncDevices(ctx, req.(*RequestSyncDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_ReportStateAndNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportStateAndNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).ReportStateAndNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/ReportStateAndNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).ReportStateAndNotification(ctx, req.(*ReportStateAndNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_DeleteAgentUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).DeleteAgentUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/DeleteAgentUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).DeleteAgentUser(ctx, req.(*DeleteAgentUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HomeGraphApiService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.home.graph.v1.HomeGraphApiService",
	HandlerType: (*HomeGraphApiServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RequestSyncDevices",
			Handler:    _HomeGraphApiService_RequestSyncDevices_Handler,
		},
		{
			MethodName: "ReportStateAndNotification",
			Handler:    _HomeGraphApiService_ReportStateAndNotification_Handler,
		},
		{
			MethodName: "DeleteAgentUser",
			Handler:    _HomeGraphApiService_DeleteAgentUser_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/home/graph/v1/homegraph.proto",
}

func init() { proto.RegisterFile("google/home/graph/v1/homegraph.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 562 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xdd, 0x6a, 0x13, 0x41,
	0x14, 0x66, 0x5b, 0x69, 0xec, 0x09, 0x45, 0x18, 0xa5, 0x4d, 0xd3, 0x08, 0xe9, 0x28, 0x52, 0xa3,
	0xec, 0x9a, 0x08, 0xfe, 0x54, 0x8a, 0xa4, 0x56, 0x34, 0x08, 0x12, 0x36, 0x78, 0xa3, 0x17, 0x65,
	0x9b, 0x3d, 0xdd, 0x2e, 0x24, 0x3b, 0xeb, 0xcc, 0x24, 0x10, 0xc4, 0x9b, 0x3e, 0x82, 0x5e, 0xfa,
	0x36, 0x3e, 0x80, 0x37, 0xbe, 0x82, 0xaf, 0x21, 0xc8, 0xfc, 0xac, 0x6d, 0x9a, 0xdd, 0x34, 0xbd,
	0xdb, 0x99, 0x73, 0xbe, 0x39, 0xdf, 0x39, 0xdf, 0x77, 0x16, 0xee, 0x46, 0x8c, 0x45, 0x03, 0xf4,
	0x4e, 0xd8, 0x10, 0xbd, 0x88, 0x07, 0xe9, 0x89, 0x37, 0x6e, 0xea, 0x93, 0x3e, 0xb8, 0x29, 0x67,
	0x92, 0x91, 0x5b, 0x26, 0xcb, 0x55, 0xf7, 0xae, 0x09, 0x8c, 0x9b, 0xd5, 0x9a, 0xc5, 0x06, 0x69,
	0xec, 0x05, 0x49, 0xc2, 0x64, 0x20, 0x63, 0x96, 0x08, 0x83, 0xa9, 0x6e, 0xd9, 0xa8, 0x3e, 0x1d,
	0x8d, 0x8e, 0x3d, 0x1c, 0xa6, 0x72, 0x62, 0x83, 0xb5, 0x8b, 0x41, 0x21, 0xf9, 0xa8, 0x2f, 0x4d,
	0x94, 0xbe, 0x84, 0x4d, 0x1f, 0x3f, 0x8f, 0x50, 0xc8, 0xde, 0x24, 0xe9, 0x1f, 0xe0, 0x38, 0xee,
	0xa3, 0xb0, 0x37, 0x84, 0xc2, 0x5a, 0x10, 0x61, 0x22, 0x0f, 0x47, 0x02, 0xf9, 0x61, 0x1c, 0x56,
	0x9c, 0xba, 0xb3, 0xb3, 0xea, 0x97, 0xf5, 0xe5, 0x07, 0x81, 0xbc, 0x13, 0xd2, 0x1a, 0x54, 0xf3,
	0x1e, 0x10, 0x29, 0x4b, 0x04, 0xd2, 0x5f, 0x0e, 0x6c, 0xfb, 0x98, 0x32, 0x2e, 0x7b, 0x32, 0x90,
	0xd8, 0x4e, 0xc2, 0xf7, 0x4c, 0xc6, 0xc7, 0x71, 0x5f, 0xf3, 0xcf, 0xea, 0xdc, 0x06, 0xe0, 0xe6,
	0xf3, 0xac, 0xc8, 0xaa, 0xbd, 0xe9, 0x84, 0x64, 0x13, 0xae, 0xe3, 0x58, 0xd1, 0x88, 0xc3, 0xca,
	0x35, 0x1d, 0x2c, 0xe9, 0x73, 0x27, 0x9c, 0x65, 0xb8, 0x34, 0xc3, 0x90, 0xbc, 0x83, 0x52, 0x1a,
	0x4c, 0x06, 0x2c, 0x08, 0x2b, 0xcb, 0x75, 0x67, 0xa7, 0xdc, 0x6a, 0xba, 0x79, 0x33, 0x76, 0xf3,
	0x18, 0x76, 0x0d, 0xd0, 0xcf, 0x5e, 0xa0, 0xaf, 0x80, 0xce, 0xeb, 0xc7, 0xb4, 0x7d, 0x49, 0x43,
	0x94, 0xc1, 0xd6, 0x9c, 0x62, 0xa4, 0x0b, 0xa5, 0xd0, 0xcc, 0x51, 0x43, 0xcb, 0xad, 0x27, 0xf9,
	0x84, 0x8b, 0x89, 0x18, 0x19, 0xfc, 0xec, 0x19, 0xfa, 0xcd, 0x81, 0xfa, 0x65, 0xd9, 0xc4, 0x83,
	0x15, 0xa1, 0xa2, 0x59, 0xd5, 0x8d, 0xac, 0x6a, 0xe6, 0x1c, 0xb7, 0xa7, 0x9d, 0xe3, 0xdb, 0x34,
	0xb2, 0x07, 0x6b, 0xc9, 0xb9, 0x67, 0x84, 0x1e, 0xfe, 0x1c, 0xdc, 0x74, 0x36, 0xfd, 0x04, 0xeb,
	0x07, 0x38, 0x40, 0x89, 0xed, 0x4c, 0xac, 0x05, 0xfd, 0xb0, 0x80, 0xe8, 0xad, 0xbf, 0xcb, 0x70,
	0xf3, 0x2d, 0x1b, 0xe2, 0x1b, 0x35, 0xac, 0x76, 0x1a, 0xf7, 0x90, 0xeb, 0x26, 0x7f, 0x38, 0x40,
	0x66, 0xfd, 0x4a, 0xbc, 0xa2, 0x09, 0x17, 0xac, 0x46, 0xf5, 0xd1, 0xe2, 0x00, 0xbb, 0x0a, 0xf4,
	0xf4, 0xf7, 0x9f, 0xef, 0x4b, 0x35, 0xba, 0xa1, 0xb6, 0xde, 0x0a, 0xb3, 0xcb, 0xcf, 0xf2, 0x77,
	0x9d, 0x06, 0xf9, 0xe9, 0xa8, 0x6d, 0x2a, 0xd2, 0x89, 0x3c, 0xbd, 0xaa, 0x0f, 0x32, 0xb6, 0xcf,
	0xae, 0x0e, 0xb4, 0xac, 0x9b, 0x9a, 0xf5, 0x03, 0x7a, 0x6f, 0x9a, 0x75, 0x11, 0x4e, 0x35, 0x71,
	0xea, 0xc0, 0x8d, 0x0b, 0xc2, 0x92, 0x87, 0xf9, 0x04, 0xf2, 0xf5, 0xaf, 0xae, 0xcf, 0x38, 0xe8,
	0xb5, 0xfa, 0xa1, 0xd1, 0xfb, 0x9a, 0xcc, 0x9d, 0xc6, 0xb6, 0x22, 0xf3, 0x65, 0xca, 0x03, 0x7b,
	0xff, 0xc5, 0x17, 0x5e, 0xa3, 0xf1, 0x75, 0x9f, 0x41, 0xa5, 0xcf, 0x86, 0xb9, 0x55, 0xf7, 0x2b,
	0x39, 0xc6, 0xe8, 0xaa, 0x4a, 0x1f, 0x9f, 0xdb, 0xfc, 0x88, 0x0d, 0x82, 0x24, 0x72, 0x19, 0x8f,
	0xbc, 0x08, 0x13, 0xcd, 0xc2, 0x33, 0xa1, 0x20, 0x8d, 0xc5, 0xf4, 0x1f, 0xfc, 0x85, 0xfe, 0x38,
	0x5a, 0xd1, 0x59, 0x8f, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x83, 0xcd, 0xb6, 0x28, 0xe6, 0x05,
	0x00, 0x00,
}
