// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/containeranalysis/v1alpha1/containeranalysis.proto

package containeranalysis

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_iam_v11 "google.golang.org/genproto/googleapis/iam/v1"
import google_iam_v1 "google.golang.org/genproto/googleapis/iam/v1"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import _ "github.com/golang/protobuf/ptypes/any"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This must be 1:1 with members of our oneofs, it can be used for filtering
// Note and Occurrence on their kind.
type Note_Kind int32

const (
	// Unknown
	Note_KIND_UNSPECIFIED Note_Kind = 0
	// The note and occurrence represent a package vulnerability.
	Note_PACKAGE_VULNERABILITY Note_Kind = 2
	// The note and occurrence assert build provenance.
	Note_BUILD_DETAILS Note_Kind = 3
	// This represents an image basis relationship.
	Note_IMAGE_BASIS Note_Kind = 4
	// This represents a package installed via a package manager.
	Note_PACKAGE_MANAGER Note_Kind = 5
	// The note and occurrence track deployment events.
	Note_DEPLOYABLE Note_Kind = 6
	// The note and occurrence track the initial discovery status of a resource.
	Note_DISCOVERY Note_Kind = 7
	// This represents a logical "role" that can attest to artifacts.
	Note_ATTESTATION_AUTHORITY Note_Kind = 8
)

var Note_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	2: "PACKAGE_VULNERABILITY",
	3: "BUILD_DETAILS",
	4: "IMAGE_BASIS",
	5: "PACKAGE_MANAGER",
	6: "DEPLOYABLE",
	7: "DISCOVERY",
	8: "ATTESTATION_AUTHORITY",
}
var Note_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED":      0,
	"PACKAGE_VULNERABILITY": 2,
	"BUILD_DETAILS":         3,
	"IMAGE_BASIS":           4,
	"PACKAGE_MANAGER":       5,
	"DEPLOYABLE":            6,
	"DISCOVERY":             7,
	"ATTESTATION_AUTHORITY": 8,
}

func (x Note_Kind) String() string {
	return proto.EnumName(Note_Kind_name, int32(x))
}
func (Note_Kind) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{2, 0} }

// Types of platforms.
type Deployable_Deployment_Platform int32

const (
	// Unknown
	Deployable_Deployment_PLATFORM_UNSPECIFIED Deployable_Deployment_Platform = 0
	// Google Container Engine
	Deployable_Deployment_GKE Deployable_Deployment_Platform = 1
	// Google App Engine: Flexible Environment
	Deployable_Deployment_FLEX Deployable_Deployment_Platform = 2
	// Custom user-defined platform
	Deployable_Deployment_CUSTOM Deployable_Deployment_Platform = 3
)

var Deployable_Deployment_Platform_name = map[int32]string{
	0: "PLATFORM_UNSPECIFIED",
	1: "GKE",
	2: "FLEX",
	3: "CUSTOM",
}
var Deployable_Deployment_Platform_value = map[string]int32{
	"PLATFORM_UNSPECIFIED": 0,
	"GKE":    1,
	"FLEX":   2,
	"CUSTOM": 3,
}

func (x Deployable_Deployment_Platform) String() string {
	return proto.EnumName(Deployable_Deployment_Platform_name, int32(x))
}
func (Deployable_Deployment_Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{3, 0, 0}
}

// Analysis status for a resource.
type Discovery_Discovered_AnalysisStatus int32

const (
	// Unknown
	Discovery_Discovered_ANALYSIS_STATUS_UNSPECIFIED Discovery_Discovered_AnalysisStatus = 0
	// Resource is known but no action has been taken yet.
	Discovery_Discovered_PENDING Discovery_Discovered_AnalysisStatus = 1
	// Resource is being analyzed.
	Discovery_Discovered_SCANNING Discovery_Discovered_AnalysisStatus = 2
	// Analysis has finished successfully.
	Discovery_Discovered_FINISHED_SUCCESS Discovery_Discovered_AnalysisStatus = 3
	// Analysis has finished unsuccessfully, the analysis itself is in a bad
	// state.
	Discovery_Discovered_FINISHED_FAILED Discovery_Discovered_AnalysisStatus = 4
	// Analysis will not happen, the resource is not supported.
	Discovery_Discovered_UNSUPPORTED_RESOURCE Discovery_Discovered_AnalysisStatus = 5
)

var Discovery_Discovered_AnalysisStatus_name = map[int32]string{
	0: "ANALYSIS_STATUS_UNSPECIFIED",
	1: "PENDING",
	2: "SCANNING",
	3: "FINISHED_SUCCESS",
	4: "FINISHED_FAILED",
	5: "UNSUPPORTED_RESOURCE",
}
var Discovery_Discovered_AnalysisStatus_value = map[string]int32{
	"ANALYSIS_STATUS_UNSPECIFIED": 0,
	"PENDING":                     1,
	"SCANNING":                    2,
	"FINISHED_SUCCESS":            3,
	"FINISHED_FAILED":             4,
	"UNSUPPORTED_RESOURCE":        5,
}

func (x Discovery_Discovered_AnalysisStatus) String() string {
	return proto.EnumName(Discovery_Discovered_AnalysisStatus_name, int32(x))
}
func (Discovery_Discovered_AnalysisStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{4, 0, 0}
}

// Public key formats
type BuildSignature_KeyType int32

const (
	// `KeyType` is not set.
	BuildSignature_KEY_TYPE_UNSPECIFIED BuildSignature_KeyType = 0
	// `PGP ASCII Armored` public key.
	BuildSignature_PGP_ASCII_ARMORED BuildSignature_KeyType = 1
	// `PKIX PEM` public key.
	BuildSignature_PKIX_PEM BuildSignature_KeyType = 2
)

var BuildSignature_KeyType_name = map[int32]string{
	0: "KEY_TYPE_UNSPECIFIED",
	1: "PGP_ASCII_ARMORED",
	2: "PKIX_PEM",
}
var BuildSignature_KeyType_value = map[string]int32{
	"KEY_TYPE_UNSPECIFIED": 0,
	"PGP_ASCII_ARMORED":    1,
	"PKIX_PEM":             2,
}

func (x BuildSignature_KeyType) String() string {
	return proto.EnumName(BuildSignature_KeyType_name, int32(x))
}
func (BuildSignature_KeyType) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{6, 0} }

// Type (for example schema) of the attestation payload that was signed.
type PgpSignedAttestation_ContentType int32

const (
	// `ContentType` is not set.
	PgpSignedAttestation_CONTENT_TYPE_UNSPECIFIED PgpSignedAttestation_ContentType = 0
	// Atomic format attestation signature. See
	// https://github.com/containers/image/blob/8a5d2f82a6e3263290c8e0276c3e0f64e77723e7/docs/atomic-signature.md
	// The payload extracted from `signature` is a JSON blob conforming to the
	// linked schema.
	PgpSignedAttestation_SIMPLE_SIGNING_JSON PgpSignedAttestation_ContentType = 1
)

var PgpSignedAttestation_ContentType_name = map[int32]string{
	0: "CONTENT_TYPE_UNSPECIFIED",
	1: "SIMPLE_SIGNING_JSON",
}
var PgpSignedAttestation_ContentType_value = map[string]int32{
	"CONTENT_TYPE_UNSPECIFIED": 0,
	"SIMPLE_SIGNING_JSON":      1,
}

func (x PgpSignedAttestation_ContentType) String() string {
	return proto.EnumName(PgpSignedAttestation_ContentType_name, int32(x))
}
func (PgpSignedAttestation_ContentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{7, 0}
}

// `Occurrence` includes information about analysis occurrences for an image.
type Occurrence struct {
	// Output only. The name of the `Occurrence` in the form
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The unique URL of the image or the container for which the `Occurrence`
	// applies. For example, https://gcr.io/project/image@sha256:foo This field
	// can be used as a filter in list requests.
	ResourceUrl string `protobuf:"bytes,2,opt,name=resource_url,json=resourceUrl" json:"resource_url,omitempty"`
	// The resource for which the `Occurrence` applies.
	Resource *Resource `protobuf:"bytes,17,opt,name=resource" json:"resource,omitempty"`
	// An analysis note associated with this image, in the form
	// "providers/{provider_id}/notes/{NOTE_ID}"
	// This field can be used as a filter in list requests.
	NoteName string `protobuf:"bytes,3,opt,name=note_name,json=noteName" json:"note_name,omitempty"`
	// Output only. This explicitly denotes which of the `Occurrence` details are
	// specified. This field can be used as a filter in list requests.
	Kind Note_Kind `protobuf:"varint,6,opt,name=kind,enum=google.devtools.containeranalysis.v1alpha1.Note_Kind" json:"kind,omitempty"`
	// Describes the details of the vulnerability `Note` found in this resource.
	//
	// Types that are valid to be assigned to Details:
	//	*Occurrence_VulnerabilityDetails
	//	*Occurrence_BuildDetails
	//	*Occurrence_DerivedImage
	//	*Occurrence_Installation
	//	*Occurrence_Deployment
	//	*Occurrence_Discovered
	//	*Occurrence_Attestation
	Details isOccurrence_Details `protobuf_oneof:"details"`
	// A description of actions that can be taken to remedy the `Note`
	Remediation string `protobuf:"bytes,5,opt,name=remediation" json:"remediation,omitempty"`
	// Output only. The time this `Occurrence` was created.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time this `Occurrence` was last updated.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *Occurrence) Reset()                    { *m = Occurrence{} }
func (m *Occurrence) String() string            { return proto.CompactTextString(m) }
func (*Occurrence) ProtoMessage()               {}
func (*Occurrence) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

type isOccurrence_Details interface {
	isOccurrence_Details()
}

type Occurrence_VulnerabilityDetails struct {
	VulnerabilityDetails *VulnerabilityType_VulnerabilityDetails `protobuf:"bytes,8,opt,name=vulnerability_details,json=vulnerabilityDetails,oneof"`
}
type Occurrence_BuildDetails struct {
	BuildDetails *BuildDetails `protobuf:"bytes,7,opt,name=build_details,json=buildDetails,oneof"`
}
type Occurrence_DerivedImage struct {
	DerivedImage *DockerImage_Derived `protobuf:"bytes,11,opt,name=derived_image,json=derivedImage,oneof"`
}
type Occurrence_Installation struct {
	Installation *PackageManager_Installation `protobuf:"bytes,12,opt,name=installation,oneof"`
}
type Occurrence_Deployment struct {
	Deployment *Deployable_Deployment `protobuf:"bytes,14,opt,name=deployment,oneof"`
}
type Occurrence_Discovered struct {
	Discovered *Discovery_Discovered `protobuf:"bytes,15,opt,name=discovered,oneof"`
}
type Occurrence_Attestation struct {
	Attestation *AttestationAuthority_Attestation `protobuf:"bytes,16,opt,name=attestation,oneof"`
}

func (*Occurrence_VulnerabilityDetails) isOccurrence_Details() {}
func (*Occurrence_BuildDetails) isOccurrence_Details()         {}
func (*Occurrence_DerivedImage) isOccurrence_Details()         {}
func (*Occurrence_Installation) isOccurrence_Details()         {}
func (*Occurrence_Deployment) isOccurrence_Details()           {}
func (*Occurrence_Discovered) isOccurrence_Details()           {}
func (*Occurrence_Attestation) isOccurrence_Details()          {}

func (m *Occurrence) GetDetails() isOccurrence_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Occurrence) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Occurrence) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *Occurrence) GetResource() *Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *Occurrence) GetNoteName() string {
	if m != nil {
		return m.NoteName
	}
	return ""
}

func (m *Occurrence) GetKind() Note_Kind {
	if m != nil {
		return m.Kind
	}
	return Note_KIND_UNSPECIFIED
}

func (m *Occurrence) GetVulnerabilityDetails() *VulnerabilityType_VulnerabilityDetails {
	if x, ok := m.GetDetails().(*Occurrence_VulnerabilityDetails); ok {
		return x.VulnerabilityDetails
	}
	return nil
}

func (m *Occurrence) GetBuildDetails() *BuildDetails {
	if x, ok := m.GetDetails().(*Occurrence_BuildDetails); ok {
		return x.BuildDetails
	}
	return nil
}

func (m *Occurrence) GetDerivedImage() *DockerImage_Derived {
	if x, ok := m.GetDetails().(*Occurrence_DerivedImage); ok {
		return x.DerivedImage
	}
	return nil
}

func (m *Occurrence) GetInstallation() *PackageManager_Installation {
	if x, ok := m.GetDetails().(*Occurrence_Installation); ok {
		return x.Installation
	}
	return nil
}

func (m *Occurrence) GetDeployment() *Deployable_Deployment {
	if x, ok := m.GetDetails().(*Occurrence_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *Occurrence) GetDiscovered() *Discovery_Discovered {
	if x, ok := m.GetDetails().(*Occurrence_Discovered); ok {
		return x.Discovered
	}
	return nil
}

func (m *Occurrence) GetAttestation() *AttestationAuthority_Attestation {
	if x, ok := m.GetDetails().(*Occurrence_Attestation); ok {
		return x.Attestation
	}
	return nil
}

func (m *Occurrence) GetRemediation() string {
	if m != nil {
		return m.Remediation
	}
	return ""
}

func (m *Occurrence) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Occurrence) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Occurrence) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Occurrence_OneofMarshaler, _Occurrence_OneofUnmarshaler, _Occurrence_OneofSizer, []interface{}{
		(*Occurrence_VulnerabilityDetails)(nil),
		(*Occurrence_BuildDetails)(nil),
		(*Occurrence_DerivedImage)(nil),
		(*Occurrence_Installation)(nil),
		(*Occurrence_Deployment)(nil),
		(*Occurrence_Discovered)(nil),
		(*Occurrence_Attestation)(nil),
	}
}

func _Occurrence_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Occurrence)
	// details
	switch x := m.Details.(type) {
	case *Occurrence_VulnerabilityDetails:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.VulnerabilityDetails); err != nil {
			return err
		}
	case *Occurrence_BuildDetails:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BuildDetails); err != nil {
			return err
		}
	case *Occurrence_DerivedImage:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DerivedImage); err != nil {
			return err
		}
	case *Occurrence_Installation:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Installation); err != nil {
			return err
		}
	case *Occurrence_Deployment:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Deployment); err != nil {
			return err
		}
	case *Occurrence_Discovered:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Discovered); err != nil {
			return err
		}
	case *Occurrence_Attestation:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Attestation); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Occurrence.Details has unexpected type %T", x)
	}
	return nil
}

func _Occurrence_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Occurrence)
	switch tag {
	case 8: // details.vulnerability_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VulnerabilityType_VulnerabilityDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_VulnerabilityDetails{msg}
		return true, err
	case 7: // details.build_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_BuildDetails{msg}
		return true, err
	case 11: // details.derived_image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DockerImage_Derived)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_DerivedImage{msg}
		return true, err
	case 12: // details.installation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PackageManager_Installation)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_Installation{msg}
		return true, err
	case 14: // details.deployment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Deployable_Deployment)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_Deployment{msg}
		return true, err
	case 15: // details.discovered
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Discovery_Discovered)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_Discovered{msg}
		return true, err
	case 16: // details.attestation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AttestationAuthority_Attestation)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_Attestation{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Occurrence_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Occurrence)
	// details
	switch x := m.Details.(type) {
	case *Occurrence_VulnerabilityDetails:
		s := proto.Size(x.VulnerabilityDetails)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_BuildDetails:
		s := proto.Size(x.BuildDetails)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_DerivedImage:
		s := proto.Size(x.DerivedImage)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_Installation:
		s := proto.Size(x.Installation)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_Deployment:
		s := proto.Size(x.Deployment)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_Discovered:
		s := proto.Size(x.Discovered)
		n += proto.SizeVarint(15<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_Attestation:
		s := proto.Size(x.Attestation)
		n += proto.SizeVarint(16<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Resource is an entity that can have metadata. E.g., a Docker image.
type Resource struct {
	// The name of the resource. E.g., the name of a Docker image - "Debian".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The unique URI of the resource. E.g.,
	// "https://gcr.io/project/image@sha256:foo" for a Docker image.
	Uri string `protobuf:"bytes,2,opt,name=uri" json:"uri,omitempty"`
	// The hash of the resource content. E.g., the Docker digest.
	ContentHash *Hash `protobuf:"bytes,3,opt,name=content_hash,json=contentHash" json:"content_hash,omitempty"`
}

func (m *Resource) Reset()                    { *m = Resource{} }
func (m *Resource) String() string            { return proto.CompactTextString(m) }
func (*Resource) ProtoMessage()               {}
func (*Resource) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Resource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Resource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Resource) GetContentHash() *Hash {
	if m != nil {
		return m.ContentHash
	}
	return nil
}

// Provides a detailed description of a `Note`.
type Note struct {
	// The name of the note in the form
	// "providers/{provider_id}/notes/{NOTE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A one sentence description of this `Note`.
	ShortDescription string `protobuf:"bytes,3,opt,name=short_description,json=shortDescription" json:"short_description,omitempty"`
	// A detailed description of this `Note`.
	LongDescription string `protobuf:"bytes,4,opt,name=long_description,json=longDescription" json:"long_description,omitempty"`
	// Output only. This explicitly denotes which kind of note is specified. This
	// field can be used as a filter in list requests.
	Kind Note_Kind `protobuf:"varint,9,opt,name=kind,enum=google.devtools.containeranalysis.v1alpha1.Note_Kind" json:"kind,omitempty"`
	// The type of note.
	//
	// Types that are valid to be assigned to NoteType:
	//	*Note_VulnerabilityType
	//	*Note_BuildType
	//	*Note_BaseImage
	//	*Note_Package
	//	*Note_Deployable
	//	*Note_Discovery
	//	*Note_AttestationAuthority
	NoteType isNote_NoteType `protobuf_oneof:"note_type"`
	// URLs associated with this note
	RelatedUrl []*Note_RelatedUrl `protobuf:"bytes,7,rep,name=related_url,json=relatedUrl" json:"related_url,omitempty"`
	// Time of expiration for this note, null if note does not expire.
	ExpirationTime *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=expiration_time,json=expirationTime" json:"expiration_time,omitempty"`
	// Output only. The time this note was created. This field can be used as a
	// filter in list requests.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time this note was last updated. This field can be used as
	// a filter in list requests.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *Note) Reset()                    { *m = Note{} }
func (m *Note) String() string            { return proto.CompactTextString(m) }
func (*Note) ProtoMessage()               {}
func (*Note) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

type isNote_NoteType interface {
	isNote_NoteType()
}

type Note_VulnerabilityType struct {
	VulnerabilityType *VulnerabilityType `protobuf:"bytes,6,opt,name=vulnerability_type,json=vulnerabilityType,oneof"`
}
type Note_BuildType struct {
	BuildType *BuildType `protobuf:"bytes,8,opt,name=build_type,json=buildType,oneof"`
}
type Note_BaseImage struct {
	BaseImage *DockerImage_Basis `protobuf:"bytes,13,opt,name=base_image,json=baseImage,oneof"`
}
type Note_Package struct {
	Package *PackageManager_Package `protobuf:"bytes,14,opt,name=package,oneof"`
}
type Note_Deployable struct {
	Deployable *Deployable `protobuf:"bytes,17,opt,name=deployable,oneof"`
}
type Note_Discovery struct {
	Discovery *Discovery `protobuf:"bytes,18,opt,name=discovery,oneof"`
}
type Note_AttestationAuthority struct {
	AttestationAuthority *AttestationAuthority `protobuf:"bytes,19,opt,name=attestation_authority,json=attestationAuthority,oneof"`
}

func (*Note_VulnerabilityType) isNote_NoteType()    {}
func (*Note_BuildType) isNote_NoteType()            {}
func (*Note_BaseImage) isNote_NoteType()            {}
func (*Note_Package) isNote_NoteType()              {}
func (*Note_Deployable) isNote_NoteType()           {}
func (*Note_Discovery) isNote_NoteType()            {}
func (*Note_AttestationAuthority) isNote_NoteType() {}

func (m *Note) GetNoteType() isNote_NoteType {
	if m != nil {
		return m.NoteType
	}
	return nil
}

func (m *Note) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Note) GetShortDescription() string {
	if m != nil {
		return m.ShortDescription
	}
	return ""
}

func (m *Note) GetLongDescription() string {
	if m != nil {
		return m.LongDescription
	}
	return ""
}

func (m *Note) GetKind() Note_Kind {
	if m != nil {
		return m.Kind
	}
	return Note_KIND_UNSPECIFIED
}

func (m *Note) GetVulnerabilityType() *VulnerabilityType {
	if x, ok := m.GetNoteType().(*Note_VulnerabilityType); ok {
		return x.VulnerabilityType
	}
	return nil
}

func (m *Note) GetBuildType() *BuildType {
	if x, ok := m.GetNoteType().(*Note_BuildType); ok {
		return x.BuildType
	}
	return nil
}

func (m *Note) GetBaseImage() *DockerImage_Basis {
	if x, ok := m.GetNoteType().(*Note_BaseImage); ok {
		return x.BaseImage
	}
	return nil
}

func (m *Note) GetPackage() *PackageManager_Package {
	if x, ok := m.GetNoteType().(*Note_Package); ok {
		return x.Package
	}
	return nil
}

func (m *Note) GetDeployable() *Deployable {
	if x, ok := m.GetNoteType().(*Note_Deployable); ok {
		return x.Deployable
	}
	return nil
}

func (m *Note) GetDiscovery() *Discovery {
	if x, ok := m.GetNoteType().(*Note_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (m *Note) GetAttestationAuthority() *AttestationAuthority {
	if x, ok := m.GetNoteType().(*Note_AttestationAuthority); ok {
		return x.AttestationAuthority
	}
	return nil
}

func (m *Note) GetRelatedUrl() []*Note_RelatedUrl {
	if m != nil {
		return m.RelatedUrl
	}
	return nil
}

func (m *Note) GetExpirationTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *Note) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Note) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Note) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Note_OneofMarshaler, _Note_OneofUnmarshaler, _Note_OneofSizer, []interface{}{
		(*Note_VulnerabilityType)(nil),
		(*Note_BuildType)(nil),
		(*Note_BaseImage)(nil),
		(*Note_Package)(nil),
		(*Note_Deployable)(nil),
		(*Note_Discovery)(nil),
		(*Note_AttestationAuthority)(nil),
	}
}

func _Note_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Note)
	// note_type
	switch x := m.NoteType.(type) {
	case *Note_VulnerabilityType:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.VulnerabilityType); err != nil {
			return err
		}
	case *Note_BuildType:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BuildType); err != nil {
			return err
		}
	case *Note_BaseImage:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BaseImage); err != nil {
			return err
		}
	case *Note_Package:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Package); err != nil {
			return err
		}
	case *Note_Deployable:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Deployable); err != nil {
			return err
		}
	case *Note_Discovery:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Discovery); err != nil {
			return err
		}
	case *Note_AttestationAuthority:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AttestationAuthority); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Note.NoteType has unexpected type %T", x)
	}
	return nil
}

func _Note_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Note)
	switch tag {
	case 6: // note_type.vulnerability_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VulnerabilityType)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_VulnerabilityType{msg}
		return true, err
	case 8: // note_type.build_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildType)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_BuildType{msg}
		return true, err
	case 13: // note_type.base_image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DockerImage_Basis)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_BaseImage{msg}
		return true, err
	case 14: // note_type.package
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PackageManager_Package)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_Package{msg}
		return true, err
	case 17: // note_type.deployable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Deployable)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_Deployable{msg}
		return true, err
	case 18: // note_type.discovery
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Discovery)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_Discovery{msg}
		return true, err
	case 19: // note_type.attestation_authority
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AttestationAuthority)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_AttestationAuthority{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Note_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Note)
	// note_type
	switch x := m.NoteType.(type) {
	case *Note_VulnerabilityType:
		s := proto.Size(x.VulnerabilityType)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_BuildType:
		s := proto.Size(x.BuildType)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_BaseImage:
		s := proto.Size(x.BaseImage)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_Package:
		s := proto.Size(x.Package)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_Deployable:
		s := proto.Size(x.Deployable)
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_Discovery:
		s := proto.Size(x.Discovery)
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_AttestationAuthority:
		s := proto.Size(x.AttestationAuthority)
		n += proto.SizeVarint(19<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Metadata for any related URL information
type Note_RelatedUrl struct {
	// Specific URL to associate with the note
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// Label to describe usage of the URL
	Label string `protobuf:"bytes,2,opt,name=label" json:"label,omitempty"`
}

func (m *Note_RelatedUrl) Reset()                    { *m = Note_RelatedUrl{} }
func (m *Note_RelatedUrl) String() string            { return proto.CompactTextString(m) }
func (*Note_RelatedUrl) ProtoMessage()               {}
func (*Note_RelatedUrl) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2, 0} }

func (m *Note_RelatedUrl) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Note_RelatedUrl) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

// An artifact that can be deployed in some runtime.
type Deployable struct {
	// Resource URI for the artifact being deployed.
	ResourceUri []string `protobuf:"bytes,1,rep,name=resource_uri,json=resourceUri" json:"resource_uri,omitempty"`
}

func (m *Deployable) Reset()                    { *m = Deployable{} }
func (m *Deployable) String() string            { return proto.CompactTextString(m) }
func (*Deployable) ProtoMessage()               {}
func (*Deployable) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *Deployable) GetResourceUri() []string {
	if m != nil {
		return m.ResourceUri
	}
	return nil
}

// The period during which some deployable was active in a runtime.
type Deployable_Deployment struct {
	// Identity of the user that triggered this deployment.
	UserEmail string `protobuf:"bytes,1,opt,name=user_email,json=userEmail" json:"user_email,omitempty"`
	// Beginning of the lifetime of this deployment.
	DeployTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=deploy_time,json=deployTime" json:"deploy_time,omitempty"`
	// End of the lifetime of this deployment.
	UndeployTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=undeploy_time,json=undeployTime" json:"undeploy_time,omitempty"`
	// Configuration used to create this deployment.
	Config string `protobuf:"bytes,8,opt,name=config" json:"config,omitempty"`
	// Address of the runtime element hosting this deployment.
	Address string `protobuf:"bytes,5,opt,name=address" json:"address,omitempty"`
	// Output only. Resource URI for the artifact being deployed taken from the
	// deployable field with the same name.
	ResourceUri []string `protobuf:"bytes,6,rep,name=resource_uri,json=resourceUri" json:"resource_uri,omitempty"`
	// Platform hosting this deployment.
	Platform Deployable_Deployment_Platform `protobuf:"varint,7,opt,name=platform,enum=google.devtools.containeranalysis.v1alpha1.Deployable_Deployment_Platform" json:"platform,omitempty"`
}

func (m *Deployable_Deployment) Reset()                    { *m = Deployable_Deployment{} }
func (m *Deployable_Deployment) String() string            { return proto.CompactTextString(m) }
func (*Deployable_Deployment) ProtoMessage()               {}
func (*Deployable_Deployment) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3, 0} }

func (m *Deployable_Deployment) GetUserEmail() string {
	if m != nil {
		return m.UserEmail
	}
	return ""
}

func (m *Deployable_Deployment) GetDeployTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.DeployTime
	}
	return nil
}

func (m *Deployable_Deployment) GetUndeployTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UndeployTime
	}
	return nil
}

func (m *Deployable_Deployment) GetConfig() string {
	if m != nil {
		return m.Config
	}
	return ""
}

func (m *Deployable_Deployment) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Deployable_Deployment) GetResourceUri() []string {
	if m != nil {
		return m.ResourceUri
	}
	return nil
}

func (m *Deployable_Deployment) GetPlatform() Deployable_Deployment_Platform {
	if m != nil {
		return m.Platform
	}
	return Deployable_Deployment_PLATFORM_UNSPECIFIED
}

// A note that indicates a type of analysis a provider would perform. This note
// exists in a provider's project. A `Discovery` occurrence is created in a
// consumer's project at the start of analysis. The occurrence's operation will
// indicate the status of the analysis. Absence of an occurrence linked to this
// note for a resource indicates that analysis hasn't started.
type Discovery struct {
	// The kind of analysis that is handled by this discovery.
	AnalysisKind Note_Kind `protobuf:"varint,1,opt,name=analysis_kind,json=analysisKind,enum=google.devtools.containeranalysis.v1alpha1.Note_Kind" json:"analysis_kind,omitempty"`
}

func (m *Discovery) Reset()                    { *m = Discovery{} }
func (m *Discovery) String() string            { return proto.CompactTextString(m) }
func (*Discovery) ProtoMessage()               {}
func (*Discovery) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *Discovery) GetAnalysisKind() Note_Kind {
	if m != nil {
		return m.AnalysisKind
	}
	return Note_KIND_UNSPECIFIED
}

// Provides information about the scan status of a discovered resource.
type Discovery_Discovered struct {
	// Output only. An operation that indicates the status of the current scan.
	Operation *google_longrunning.Operation `protobuf:"bytes,1,opt,name=operation" json:"operation,omitempty"`
	// The status of discovery for the resource.
	AnalysisStatus Discovery_Discovered_AnalysisStatus `protobuf:"varint,5,opt,name=analysis_status,json=analysisStatus,enum=google.devtools.containeranalysis.v1alpha1.Discovery_Discovered_AnalysisStatus" json:"analysis_status,omitempty"`
	// When an error is encountered this will contain a LocalizedMessage under
	// details to show to the user. The LocalizedMessage output only and
	// populated by the API.
	AnalysisStatusError *google_rpc.Status `protobuf:"bytes,6,opt,name=analysis_status_error,json=analysisStatusError" json:"analysis_status_error,omitempty"`
}

func (m *Discovery_Discovered) Reset()                    { *m = Discovery_Discovered{} }
func (m *Discovery_Discovered) String() string            { return proto.CompactTextString(m) }
func (*Discovery_Discovered) ProtoMessage()               {}
func (*Discovery_Discovered) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4, 0} }

func (m *Discovery_Discovered) GetOperation() *google_longrunning.Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *Discovery_Discovered) GetAnalysisStatus() Discovery_Discovered_AnalysisStatus {
	if m != nil {
		return m.AnalysisStatus
	}
	return Discovery_Discovered_ANALYSIS_STATUS_UNSPECIFIED
}

func (m *Discovery_Discovered) GetAnalysisStatusError() *google_rpc.Status {
	if m != nil {
		return m.AnalysisStatusError
	}
	return nil
}

// Note holding the version of the provider's builder and the signature of
// the provenance message in linked BuildDetails.
type BuildType struct {
	// Version of the builder which produced this Note.
	BuilderVersion string `protobuf:"bytes,1,opt,name=builder_version,json=builderVersion" json:"builder_version,omitempty"`
	// Signature of the build in Occurrences pointing to the Note containing this
	// `BuilderDetails`.
	Signature *BuildSignature `protobuf:"bytes,2,opt,name=signature" json:"signature,omitempty"`
}

func (m *BuildType) Reset()                    { *m = BuildType{} }
func (m *BuildType) String() string            { return proto.CompactTextString(m) }
func (*BuildType) ProtoMessage()               {}
func (*BuildType) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *BuildType) GetBuilderVersion() string {
	if m != nil {
		return m.BuilderVersion
	}
	return ""
}

func (m *BuildType) GetSignature() *BuildSignature {
	if m != nil {
		return m.Signature
	}
	return nil
}

// Message encapsulating the signature of the verified build.
type BuildSignature struct {
	// Public key of the builder which can be used to verify that the related
	// findings are valid and unchanged. If `key_type` is empty, this defaults
	// to PEM encoded public keys.
	//
	// This field may be empty if `key_id` references an external key.
	//
	// For Cloud Container Builder based signatures, this is a PEM encoded public
	// key. To verify the Cloud Container Builder signature, place the contents of
	// this field into a file (public.pem). The signature field is base64-decoded
	// into its binary representation in signature.bin, and the provenance bytes
	// from `BuildDetails` are base64-decoded into a binary representation in
	// signed.bin. OpenSSL can then verify the signature:
	// `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
	PublicKey string `protobuf:"bytes,1,opt,name=public_key,json=publicKey" json:"public_key,omitempty"`
	// Signature of the related `BuildProvenance`, encoded in a base64 string.
	Signature string `protobuf:"bytes,2,opt,name=signature" json:"signature,omitempty"`
	// An Id for the key used to sign. This could be either an Id for the key
	// stored in `public_key` (such as the Id or fingerprint for a PGP key, or the
	// CN for a cert), or a reference to an external key (such as a reference to a
	// key in Cloud Key Management Service).
	KeyId string `protobuf:"bytes,3,opt,name=key_id,json=keyId" json:"key_id,omitempty"`
	// The type of the key, either stored in `public_key` or referenced in
	// `key_id`
	KeyType BuildSignature_KeyType `protobuf:"varint,4,opt,name=key_type,json=keyType,enum=google.devtools.containeranalysis.v1alpha1.BuildSignature_KeyType" json:"key_type,omitempty"`
}

func (m *BuildSignature) Reset()                    { *m = BuildSignature{} }
func (m *BuildSignature) String() string            { return proto.CompactTextString(m) }
func (*BuildSignature) ProtoMessage()               {}
func (*BuildSignature) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *BuildSignature) GetPublicKey() string {
	if m != nil {
		return m.PublicKey
	}
	return ""
}

func (m *BuildSignature) GetSignature() string {
	if m != nil {
		return m.Signature
	}
	return ""
}

func (m *BuildSignature) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *BuildSignature) GetKeyType() BuildSignature_KeyType {
	if m != nil {
		return m.KeyType
	}
	return BuildSignature_KEY_TYPE_UNSPECIFIED
}

// An attestation wrapper with a PGP-compatible signature.
// This message only supports `ATTACHED` signatures, where the payload that is
// signed is included alongside the signature itself in the same file.
type PgpSignedAttestation struct {
	// The raw content of the signature, as output by GNU Privacy Guard (GPG) or
	// equivalent.  Since this message only supports attached signatures, the
	// payload that was signed must be attached. While the signature format
	// supported is dependent on the verification implementation, currently only
	// ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than
	// `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor
	// --output=signature.gpg payload.json` will create the signature content
	// expected in this field in `signature.gpg` for the `payload.json`
	// attestation payload.
	Signature string `protobuf:"bytes,1,opt,name=signature" json:"signature,omitempty"`
	// Type (for example schema) of the attestation payload that was signed.
	// The verifier must ensure that the provided type is one that the verifier
	// supports, and that the attestation payload is a valid instantiation of that
	// type (for example by validating a JSON schema).
	ContentType PgpSignedAttestation_ContentType `protobuf:"varint,3,opt,name=content_type,json=contentType,enum=google.devtools.containeranalysis.v1alpha1.PgpSignedAttestation_ContentType" json:"content_type,omitempty"`
	// This field is used by verifiers to select the public key used to validate
	// the signature.  Note that the policy of the verifier ultimately determines
	// which public keys verify a signature based on the context of the
	// verification.  There is no guarantee validation will succeed if the
	// verifier has no key matching this ID, even if it has a key under a
	// different ID that would verify the signature. Note that this ID should also
	// be present in the signature content above, but that is not expected to be
	// used by the verifier.
	//
	// Types that are valid to be assigned to KeyId:
	//	*PgpSignedAttestation_PgpKeyId
	KeyId isPgpSignedAttestation_KeyId `protobuf_oneof:"key_id"`
}

func (m *PgpSignedAttestation) Reset()                    { *m = PgpSignedAttestation{} }
func (m *PgpSignedAttestation) String() string            { return proto.CompactTextString(m) }
func (*PgpSignedAttestation) ProtoMessage()               {}
func (*PgpSignedAttestation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

type isPgpSignedAttestation_KeyId interface {
	isPgpSignedAttestation_KeyId()
}

type PgpSignedAttestation_PgpKeyId struct {
	PgpKeyId string `protobuf:"bytes,2,opt,name=pgp_key_id,json=pgpKeyId,oneof"`
}

func (*PgpSignedAttestation_PgpKeyId) isPgpSignedAttestation_KeyId() {}

func (m *PgpSignedAttestation) GetKeyId() isPgpSignedAttestation_KeyId {
	if m != nil {
		return m.KeyId
	}
	return nil
}

func (m *PgpSignedAttestation) GetSignature() string {
	if m != nil {
		return m.Signature
	}
	return ""
}

func (m *PgpSignedAttestation) GetContentType() PgpSignedAttestation_ContentType {
	if m != nil {
		return m.ContentType
	}
	return PgpSignedAttestation_CONTENT_TYPE_UNSPECIFIED
}

func (m *PgpSignedAttestation) GetPgpKeyId() string {
	if x, ok := m.GetKeyId().(*PgpSignedAttestation_PgpKeyId); ok {
		return x.PgpKeyId
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PgpSignedAttestation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PgpSignedAttestation_OneofMarshaler, _PgpSignedAttestation_OneofUnmarshaler, _PgpSignedAttestation_OneofSizer, []interface{}{
		(*PgpSignedAttestation_PgpKeyId)(nil),
	}
}

func _PgpSignedAttestation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PgpSignedAttestation)
	// key_id
	switch x := m.KeyId.(type) {
	case *PgpSignedAttestation_PgpKeyId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.PgpKeyId)
	case nil:
	default:
		return fmt.Errorf("PgpSignedAttestation.KeyId has unexpected type %T", x)
	}
	return nil
}

func _PgpSignedAttestation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PgpSignedAttestation)
	switch tag {
	case 2: // key_id.pgp_key_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.KeyId = &PgpSignedAttestation_PgpKeyId{x}
		return true, err
	default:
		return false, nil
	}
}

func _PgpSignedAttestation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PgpSignedAttestation)
	// key_id
	switch x := m.KeyId.(type) {
	case *PgpSignedAttestation_PgpKeyId:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.PgpKeyId)))
		n += len(x.PgpKeyId)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Note kind that represents a logical attestation "role" or "authority".  For
// example, an organization might have one `AttestationAuthority` for "QA" and
// one for "build".  This Note is intended to act strictly as a grouping
// mechanism for the attached Occurrences (Attestations).  This grouping
// mechanism also provides a security boundary, since IAM ACLs gate the ability
// for a principle to attach an Occurrence to a given Note.  It also provides a
// single point of lookup to find all attached Attestation Occurrences, even if
// they don't all live in the same project.
type AttestationAuthority struct {
	Hint *AttestationAuthority_AttestationAuthorityHint `protobuf:"bytes,1,opt,name=hint" json:"hint,omitempty"`
}

func (m *AttestationAuthority) Reset()                    { *m = AttestationAuthority{} }
func (m *AttestationAuthority) String() string            { return proto.CompactTextString(m) }
func (*AttestationAuthority) ProtoMessage()               {}
func (*AttestationAuthority) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *AttestationAuthority) GetHint() *AttestationAuthority_AttestationAuthorityHint {
	if m != nil {
		return m.Hint
	}
	return nil
}

// This submessage provides human-readable hints about the purpose of the
// AttestationAuthority.  Because the name of a Note acts as its resource
// reference, it is important to disambiguate the canonical name of the Note
// (which might be a UUID for security purposes) from "readable" names more
// suitable for debug output.  Note that these hints should NOT be used to
// look up AttestationAuthorities in security sensitive contexts, such as when
// looking up Attestations to verify.
type AttestationAuthority_AttestationAuthorityHint struct {
	// The human readable name of this Attestation Authority, for example "qa".
	HumanReadableName string `protobuf:"bytes,1,opt,name=human_readable_name,json=humanReadableName" json:"human_readable_name,omitempty"`
}

func (m *AttestationAuthority_AttestationAuthorityHint) Reset() {
	*m = AttestationAuthority_AttestationAuthorityHint{}
}
func (m *AttestationAuthority_AttestationAuthorityHint) String() string {
	return proto.CompactTextString(m)
}
func (*AttestationAuthority_AttestationAuthorityHint) ProtoMessage() {}
func (*AttestationAuthority_AttestationAuthorityHint) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{8, 0}
}

func (m *AttestationAuthority_AttestationAuthorityHint) GetHumanReadableName() string {
	if m != nil {
		return m.HumanReadableName
	}
	return ""
}

// Occurrence that represents a single "attestation".  The authenticity of an
// Attestation can be verified using the attached signature. If the verifier
// trusts the public key of the signer, then verifying the signature is
// sufficient to establish trust.  In this circumstance, the
// AttestationAuthority to which this Attestation is attached is primarily
// useful for look-up (how to find this Attestation if you already know the
// Authority and artifact to be verified) and intent (which authority was this
// attestation intended to sign for).
type AttestationAuthority_Attestation struct {
	// The signature, generally over the `resource_url`, that verifies this
	// attestation.  The semantics of the signature veracity are ultimately
	// determined by the verification engine.
	//
	// Types that are valid to be assigned to Signature:
	//	*AttestationAuthority_Attestation_PgpSignedAttestation
	Signature isAttestationAuthority_Attestation_Signature `protobuf_oneof:"signature"`
}

func (m *AttestationAuthority_Attestation) Reset()         { *m = AttestationAuthority_Attestation{} }
func (m *AttestationAuthority_Attestation) String() string { return proto.CompactTextString(m) }
func (*AttestationAuthority_Attestation) ProtoMessage()    {}
func (*AttestationAuthority_Attestation) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{8, 1}
}

type isAttestationAuthority_Attestation_Signature interface {
	isAttestationAuthority_Attestation_Signature()
}

type AttestationAuthority_Attestation_PgpSignedAttestation struct {
	PgpSignedAttestation *PgpSignedAttestation `protobuf:"bytes,1,opt,name=pgp_signed_attestation,json=pgpSignedAttestation,oneof"`
}

func (*AttestationAuthority_Attestation_PgpSignedAttestation) isAttestationAuthority_Attestation_Signature() {
}

func (m *AttestationAuthority_Attestation) GetSignature() isAttestationAuthority_Attestation_Signature {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *AttestationAuthority_Attestation) GetPgpSignedAttestation() *PgpSignedAttestation {
	if x, ok := m.GetSignature().(*AttestationAuthority_Attestation_PgpSignedAttestation); ok {
		return x.PgpSignedAttestation
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AttestationAuthority_Attestation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AttestationAuthority_Attestation_OneofMarshaler, _AttestationAuthority_Attestation_OneofUnmarshaler, _AttestationAuthority_Attestation_OneofSizer, []interface{}{
		(*AttestationAuthority_Attestation_PgpSignedAttestation)(nil),
	}
}

func _AttestationAuthority_Attestation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AttestationAuthority_Attestation)
	// signature
	switch x := m.Signature.(type) {
	case *AttestationAuthority_Attestation_PgpSignedAttestation:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PgpSignedAttestation); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AttestationAuthority_Attestation.Signature has unexpected type %T", x)
	}
	return nil
}

func _AttestationAuthority_Attestation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AttestationAuthority_Attestation)
	switch tag {
	case 1: // signature.pgp_signed_attestation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PgpSignedAttestation)
		err := b.DecodeMessage(msg)
		m.Signature = &AttestationAuthority_Attestation_PgpSignedAttestation{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AttestationAuthority_Attestation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AttestationAuthority_Attestation)
	// signature
	switch x := m.Signature.(type) {
	case *AttestationAuthority_Attestation_PgpSignedAttestation:
		s := proto.Size(x.PgpSignedAttestation)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message encapsulating build provenance details.
type BuildDetails struct {
	// The actual provenance
	Provenance *BuildProvenance `protobuf:"bytes,1,opt,name=provenance" json:"provenance,omitempty"`
	// Serialized JSON representation of the provenance, used in generating the
	// `BuildSignature` in the corresponding Result. After verifying the
	// signature, `provenance_bytes` can be unmarshalled and compared to the
	// provenance to confirm that it is unchanged. A base64-encoded string
	// representation of the provenance bytes is used for the signature in order
	// to interoperate with openssl which expects this format for signature
	// verification.
	//
	// The serialized form is captured both to avoid ambiguity in how the
	// provenance is marshalled to json as well to prevent incompatibilities with
	// future changes.
	ProvenanceBytes string `protobuf:"bytes,2,opt,name=provenance_bytes,json=provenanceBytes" json:"provenance_bytes,omitempty"`
}

func (m *BuildDetails) Reset()                    { *m = BuildDetails{} }
func (m *BuildDetails) String() string            { return proto.CompactTextString(m) }
func (*BuildDetails) ProtoMessage()               {}
func (*BuildDetails) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *BuildDetails) GetProvenance() *BuildProvenance {
	if m != nil {
		return m.Provenance
	}
	return nil
}

func (m *BuildDetails) GetProvenanceBytes() string {
	if m != nil {
		return m.ProvenanceBytes
	}
	return ""
}

// Indicates various scans and whether they are turned on or off.
type ScanConfig struct {
	// Output only. The name of the ScanConfig in the form
	// “projects/{project_id}/ScanConfigs/{ScanConfig_id}".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Output only. A human-readable description of what the `ScanConfig` does.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Indicates whether the Scan is enabled.
	Enabled bool `protobuf:"varint,3,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *ScanConfig) Reset()                    { *m = ScanConfig{} }
func (m *ScanConfig) String() string            { return proto.CompactTextString(m) }
func (*ScanConfig) ProtoMessage()               {}
func (*ScanConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *ScanConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ScanConfig) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ScanConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Request to get a Occurrence.
type GetOccurrenceRequest struct {
	// The name of the occurrence of the form
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetOccurrenceRequest) Reset()                    { *m = GetOccurrenceRequest{} }
func (m *GetOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOccurrenceRequest) ProtoMessage()               {}
func (*GetOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *GetOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list occurrences.
type ListOccurrencesRequest struct {
	// The name field contains the project Id. For example:
	// "projects/{project_id}
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This contains the project Id for example: projects/{project_id}.
	Parent string `protobuf:"bytes,5,opt,name=parent" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Number of occurrences to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The kind of occurrences to filter on.
	Kind Note_Kind `protobuf:"varint,6,opt,name=kind,enum=google.devtools.containeranalysis.v1alpha1.Note_Kind" json:"kind,omitempty"`
}

func (m *ListOccurrencesRequest) Reset()                    { *m = ListOccurrencesRequest{} }
func (m *ListOccurrencesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListOccurrencesRequest) ProtoMessage()               {}
func (*ListOccurrencesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *ListOccurrencesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListOccurrencesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListOccurrencesRequest) GetKind() Note_Kind {
	if m != nil {
		return m.Kind
	}
	return Note_KIND_UNSPECIFIED
}

// Response including listed active occurrences.
type ListOccurrencesResponse struct {
	// The occurrences requested.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences" json:"occurrences,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListOccurrencesResponse) Reset()                    { *m = ListOccurrencesResponse{} }
func (m *ListOccurrencesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListOccurrencesResponse) ProtoMessage()               {}
func (*ListOccurrencesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *ListOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a occurrence
type DeleteOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteOccurrenceRequest) Reset()                    { *m = DeleteOccurrenceRequest{} }
func (m *DeleteOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteOccurrenceRequest) ProtoMessage()               {}
func (*DeleteOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *DeleteOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to insert a new occurrence.
type CreateOccurrenceRequest struct {
	// The name of the project.  Should be of the form "projects/{project_id}".
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field contains the project Id for example: "projects/{project_id}"
	Parent string `protobuf:"bytes,3,opt,name=parent" json:"parent,omitempty"`
	// The occurrence to be inserted
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence" json:"occurrence,omitempty"`
}

func (m *CreateOccurrenceRequest) Reset()                    { *m = CreateOccurrenceRequest{} }
func (m *CreateOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateOccurrenceRequest) ProtoMessage()               {}
func (*CreateOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *CreateOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateOccurrenceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

// Request to update an existing occurrence
type UpdateOccurrenceRequest struct {
	// The name of the occurrence.
	// Should be of the form "projects/{project_id}/occurrences/{OCCURRENCE_ID}".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The updated occurrence.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence" json:"occurrence,omitempty"`
	// The fields to update.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateOccurrenceRequest) Reset()                    { *m = UpdateOccurrenceRequest{} }
func (m *UpdateOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateOccurrenceRequest) ProtoMessage()               {}
func (*UpdateOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *UpdateOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

func (m *UpdateOccurrenceRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to get a Note.
type GetNoteRequest struct {
	// The name of the note in the form of
	// "providers/{provider_id}/notes/{NOTE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetNoteRequest) Reset()                    { *m = GetNoteRequest{} }
func (m *GetNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNoteRequest) ProtoMessage()               {}
func (*GetNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *GetNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to get the note to which this occurrence is attached.
type GetOccurrenceNoteRequest struct {
	// The name of the occurrence in the form
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetOccurrenceNoteRequest) Reset()                    { *m = GetOccurrenceNoteRequest{} }
func (m *GetOccurrenceNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOccurrenceNoteRequest) ProtoMessage()               {}
func (*GetOccurrenceNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *GetOccurrenceNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list notes.
type ListNotesRequest struct {
	// The name field will contain the project Id for example:
	// "providers/{provider_id}
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field contains the project Id for example: "projects/{PROJECT_ID}".
	Parent string `protobuf:"bytes,5,opt,name=parent" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Number of notes to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListNotesRequest) Reset()                    { *m = ListNotesRequest{} }
func (m *ListNotesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNotesRequest) ProtoMessage()               {}
func (*ListNotesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *ListNotesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListNotesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListNotesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNotesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNotesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response including listed notes.
type ListNotesResponse struct {
	// The occurrences requested
	Notes []*Note `protobuf:"bytes,1,rep,name=notes" json:"notes,omitempty"`
	// The next pagination token in the list response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListNotesResponse) Reset()                    { *m = ListNotesResponse{} }
func (m *ListNotesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNotesResponse) ProtoMessage()               {}
func (*ListNotesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{20} }

func (m *ListNotesResponse) GetNotes() []*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

func (m *ListNotesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a note
type DeleteNoteRequest struct {
	// The name of the note in the form of
	// "providers/{provider_id}/notes/{NOTE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteNoteRequest) Reset()                    { *m = DeleteNoteRequest{} }
func (m *DeleteNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNoteRequest) ProtoMessage()               {}
func (*DeleteNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{21} }

func (m *DeleteNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to insert a new note
type CreateNoteRequest struct {
	// The name of the project.
	// Should be of the form "providers/{provider_id}".
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field contains the project Id for example:
	// "projects/{project_id}
	Parent string `protobuf:"bytes,4,opt,name=parent" json:"parent,omitempty"`
	// The ID to use for this note.
	NoteId string `protobuf:"bytes,2,opt,name=note_id,json=noteId" json:"note_id,omitempty"`
	// The Note to be inserted
	Note *Note `protobuf:"bytes,3,opt,name=note" json:"note,omitempty"`
}

func (m *CreateNoteRequest) Reset()                    { *m = CreateNoteRequest{} }
func (m *CreateNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateNoteRequest) ProtoMessage()               {}
func (*CreateNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{22} }

func (m *CreateNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateNoteRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateNoteRequest) GetNoteId() string {
	if m != nil {
		return m.NoteId
	}
	return ""
}

func (m *CreateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

// Request to update an existing note
type UpdateNoteRequest struct {
	// The name of the note.
	// Should be of the form "projects/{provider_id}/notes/{note_id}".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The updated note.
	Note *Note `protobuf:"bytes,2,opt,name=note" json:"note,omitempty"`
	// The fields to update.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateNoteRequest) Reset()                    { *m = UpdateNoteRequest{} }
func (m *UpdateNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateNoteRequest) ProtoMessage()               {}
func (*UpdateNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{23} }

func (m *UpdateNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

func (m *UpdateNoteRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to list occurrences.
type ListNoteOccurrencesRequest struct {
	// The name field will contain the note name for example:
	//   "provider/{provider_id}/notes/{note_id}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Number of notes to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListNoteOccurrencesRequest) Reset()                    { *m = ListNoteOccurrencesRequest{} }
func (m *ListNoteOccurrencesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesRequest) ProtoMessage()               {}
func (*ListNoteOccurrencesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{24} }

func (m *ListNoteOccurrencesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNoteOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response including listed occurrences for a note.
type ListNoteOccurrencesResponse struct {
	// The occurrences attached to the specified note.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences" json:"occurrences,omitempty"`
	// Token to receive the next page of notes.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListNoteOccurrencesResponse) Reset()                    { *m = ListNoteOccurrencesResponse{} }
func (m *ListNoteOccurrencesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesResponse) ProtoMessage()               {}
func (*ListNoteOccurrencesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{25} }

func (m *ListNoteOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListNoteOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for creating an operation
type CreateOperationRequest struct {
	// The project Id that this operation should be created under.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The ID to use for this operation.
	OperationId string `protobuf:"bytes,2,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// The operation to create.
	Operation *google_longrunning.Operation `protobuf:"bytes,3,opt,name=operation" json:"operation,omitempty"`
}

func (m *CreateOperationRequest) Reset()                    { *m = CreateOperationRequest{} }
func (m *CreateOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateOperationRequest) ProtoMessage()               {}
func (*CreateOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{26} }

func (m *CreateOperationRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *CreateOperationRequest) GetOperation() *google_longrunning.Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// Request for updating an existing operation
type UpdateOperationRequest struct {
	// The name of the Operation.
	// Should be of the form "projects/{provider_id}/operations/{operation_id}".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The operation to create.
	Operation  *google_longrunning.Operation `protobuf:"bytes,3,opt,name=operation" json:"operation,omitempty"`
	UpdateMask *google_protobuf4.FieldMask   `protobuf:"bytes,4,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateOperationRequest) Reset()                    { *m = UpdateOperationRequest{} }
func (m *UpdateOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateOperationRequest) ProtoMessage()               {}
func (*UpdateOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{27} }

func (m *UpdateOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateOperationRequest) GetOperation() *google_longrunning.Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *UpdateOperationRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Metadata for all operations used and required for all operations
// that created by Container Analysis Providers
type OperationMetadata struct {
	// Output only. The time this operation was created.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time that this operation was marked completed or failed.
	EndTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *OperationMetadata) Reset()                    { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string            { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()               {}
func (*OperationMetadata) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{28} }

func (m *OperationMetadata) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetEndTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Request to get the vulnz summary for some set of vulnerability Occurrences.
type GetVulnzOccurrencesSummaryRequest struct {
	// This contains the project Id for example: projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
}

func (m *GetVulnzOccurrencesSummaryRequest) Reset()         { *m = GetVulnzOccurrencesSummaryRequest{} }
func (m *GetVulnzOccurrencesSummaryRequest) String() string { return proto.CompactTextString(m) }
func (*GetVulnzOccurrencesSummaryRequest) ProtoMessage()    {}
func (*GetVulnzOccurrencesSummaryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{29}
}

func (m *GetVulnzOccurrencesSummaryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GetVulnzOccurrencesSummaryRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// A summary of how many vulnz occurrences there are per severity type.
// counts by groups, or if we should have different summary messages
// like this.
type GetVulnzOccurrencesSummaryResponse struct {
	// A map of how many occurrences were found for each severity.
	Counts []*GetVulnzOccurrencesSummaryResponse_SeverityCount `protobuf:"bytes,1,rep,name=counts" json:"counts,omitempty"`
}

func (m *GetVulnzOccurrencesSummaryResponse) Reset()         { *m = GetVulnzOccurrencesSummaryResponse{} }
func (m *GetVulnzOccurrencesSummaryResponse) String() string { return proto.CompactTextString(m) }
func (*GetVulnzOccurrencesSummaryResponse) ProtoMessage()    {}
func (*GetVulnzOccurrencesSummaryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{30}
}

func (m *GetVulnzOccurrencesSummaryResponse) GetCounts() []*GetVulnzOccurrencesSummaryResponse_SeverityCount {
	if m != nil {
		return m.Counts
	}
	return nil
}

// The number of occurrences created for a specific severity.
type GetVulnzOccurrencesSummaryResponse_SeverityCount struct {
	// The severity of the occurrences.
	Severity VulnerabilityType_Severity `protobuf:"varint,1,opt,name=severity,enum=google.devtools.containeranalysis.v1alpha1.VulnerabilityType_Severity" json:"severity,omitempty"`
	// The number of occurrences with the severity.
	Count int64 `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
}

func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) Reset() {
	*m = GetVulnzOccurrencesSummaryResponse_SeverityCount{}
}
func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) String() string {
	return proto.CompactTextString(m)
}
func (*GetVulnzOccurrencesSummaryResponse_SeverityCount) ProtoMessage() {}
func (*GetVulnzOccurrencesSummaryResponse_SeverityCount) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{30, 0}
}

func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) GetSeverity() VulnerabilityType_Severity {
	if m != nil {
		return m.Severity
	}
	return VulnerabilityType_SEVERITY_UNSPECIFIED
}

func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Request to get a ScanConfig.
type GetScanConfigRequest struct {
	// The name of the ScanConfig in the form
	// projects/{project_id}/scan_configs/{ScanConfig_id}
	// instead.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetScanConfigRequest) Reset()                    { *m = GetScanConfigRequest{} }
func (m *GetScanConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetScanConfigRequest) ProtoMessage()               {}
func (*GetScanConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{31} }

func (m *GetScanConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list the available scan configurations.
type ListScanConfigsRequest struct {
	// This containers the project Id i.e.: projects/{project_id}
	// instead.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// The number of items to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The page token to use for the next request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListScanConfigsRequest) Reset()                    { *m = ListScanConfigsRequest{} }
func (m *ListScanConfigsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListScanConfigsRequest) ProtoMessage()               {}
func (*ListScanConfigsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{32} }

func (m *ListScanConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListScanConfigsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListScanConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListScanConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A list of ScanConfigs for the project.
type ListScanConfigsResponse struct {
	// The set of scan configs
	ScanConfigs []*ScanConfig `protobuf:"bytes,1,rep,name=scan_configs,json=scanConfigs" json:"scan_configs,omitempty"`
	// A page token to pass in order to get more scans.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListScanConfigsResponse) Reset()                    { *m = ListScanConfigsResponse{} }
func (m *ListScanConfigsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListScanConfigsResponse) ProtoMessage()               {}
func (*ListScanConfigsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{33} }

func (m *ListScanConfigsResponse) GetScanConfigs() []*ScanConfig {
	if m != nil {
		return m.ScanConfigs
	}
	return nil
}

func (m *ListScanConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to update a ScanConfig.
type UpdateScanConfigRequest struct {
	// The scan config to update of the form
	// projects/{project_id}/scan_configs/{ScanConfig_id}
	// instead.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The new scan configuration
	ScanConfig *ScanConfig                 `protobuf:"bytes,2,opt,name=scan_config,json=scanConfig" json:"scan_config,omitempty"`
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateScanConfigRequest) Reset()                    { *m = UpdateScanConfigRequest{} }
func (m *UpdateScanConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateScanConfigRequest) ProtoMessage()               {}
func (*UpdateScanConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{34} }

func (m *UpdateScanConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateScanConfigRequest) GetScanConfig() *ScanConfig {
	if m != nil {
		return m.ScanConfig
	}
	return nil
}

func (m *UpdateScanConfigRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterType((*Occurrence)(nil), "google.devtools.containeranalysis.v1alpha1.Occurrence")
	proto.RegisterType((*Resource)(nil), "google.devtools.containeranalysis.v1alpha1.Resource")
	proto.RegisterType((*Note)(nil), "google.devtools.containeranalysis.v1alpha1.Note")
	proto.RegisterType((*Note_RelatedUrl)(nil), "google.devtools.containeranalysis.v1alpha1.Note.RelatedUrl")
	proto.RegisterType((*Deployable)(nil), "google.devtools.containeranalysis.v1alpha1.Deployable")
	proto.RegisterType((*Deployable_Deployment)(nil), "google.devtools.containeranalysis.v1alpha1.Deployable.Deployment")
	proto.RegisterType((*Discovery)(nil), "google.devtools.containeranalysis.v1alpha1.Discovery")
	proto.RegisterType((*Discovery_Discovered)(nil), "google.devtools.containeranalysis.v1alpha1.Discovery.Discovered")
	proto.RegisterType((*BuildType)(nil), "google.devtools.containeranalysis.v1alpha1.BuildType")
	proto.RegisterType((*BuildSignature)(nil), "google.devtools.containeranalysis.v1alpha1.BuildSignature")
	proto.RegisterType((*PgpSignedAttestation)(nil), "google.devtools.containeranalysis.v1alpha1.PgpSignedAttestation")
	proto.RegisterType((*AttestationAuthority)(nil), "google.devtools.containeranalysis.v1alpha1.AttestationAuthority")
	proto.RegisterType((*AttestationAuthority_AttestationAuthorityHint)(nil), "google.devtools.containeranalysis.v1alpha1.AttestationAuthority.AttestationAuthorityHint")
	proto.RegisterType((*AttestationAuthority_Attestation)(nil), "google.devtools.containeranalysis.v1alpha1.AttestationAuthority.Attestation")
	proto.RegisterType((*BuildDetails)(nil), "google.devtools.containeranalysis.v1alpha1.BuildDetails")
	proto.RegisterType((*ScanConfig)(nil), "google.devtools.containeranalysis.v1alpha1.ScanConfig")
	proto.RegisterType((*GetOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetOccurrenceRequest")
	proto.RegisterType((*ListOccurrencesRequest)(nil), "google.devtools.containeranalysis.v1alpha1.ListOccurrencesRequest")
	proto.RegisterType((*ListOccurrencesResponse)(nil), "google.devtools.containeranalysis.v1alpha1.ListOccurrencesResponse")
	proto.RegisterType((*DeleteOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.DeleteOccurrenceRequest")
	proto.RegisterType((*CreateOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.CreateOccurrenceRequest")
	proto.RegisterType((*UpdateOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.UpdateOccurrenceRequest")
	proto.RegisterType((*GetNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetNoteRequest")
	proto.RegisterType((*GetOccurrenceNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetOccurrenceNoteRequest")
	proto.RegisterType((*ListNotesRequest)(nil), "google.devtools.containeranalysis.v1alpha1.ListNotesRequest")
	proto.RegisterType((*ListNotesResponse)(nil), "google.devtools.containeranalysis.v1alpha1.ListNotesResponse")
	proto.RegisterType((*DeleteNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.DeleteNoteRequest")
	proto.RegisterType((*CreateNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.CreateNoteRequest")
	proto.RegisterType((*UpdateNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.UpdateNoteRequest")
	proto.RegisterType((*ListNoteOccurrencesRequest)(nil), "google.devtools.containeranalysis.v1alpha1.ListNoteOccurrencesRequest")
	proto.RegisterType((*ListNoteOccurrencesResponse)(nil), "google.devtools.containeranalysis.v1alpha1.ListNoteOccurrencesResponse")
	proto.RegisterType((*CreateOperationRequest)(nil), "google.devtools.containeranalysis.v1alpha1.CreateOperationRequest")
	proto.RegisterType((*UpdateOperationRequest)(nil), "google.devtools.containeranalysis.v1alpha1.UpdateOperationRequest")
	proto.RegisterType((*OperationMetadata)(nil), "google.devtools.containeranalysis.v1alpha1.OperationMetadata")
	proto.RegisterType((*GetVulnzOccurrencesSummaryRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetVulnzOccurrencesSummaryRequest")
	proto.RegisterType((*GetVulnzOccurrencesSummaryResponse)(nil), "google.devtools.containeranalysis.v1alpha1.GetVulnzOccurrencesSummaryResponse")
	proto.RegisterType((*GetVulnzOccurrencesSummaryResponse_SeverityCount)(nil), "google.devtools.containeranalysis.v1alpha1.GetVulnzOccurrencesSummaryResponse.SeverityCount")
	proto.RegisterType((*GetScanConfigRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetScanConfigRequest")
	proto.RegisterType((*ListScanConfigsRequest)(nil), "google.devtools.containeranalysis.v1alpha1.ListScanConfigsRequest")
	proto.RegisterType((*ListScanConfigsResponse)(nil), "google.devtools.containeranalysis.v1alpha1.ListScanConfigsResponse")
	proto.RegisterType((*UpdateScanConfigRequest)(nil), "google.devtools.containeranalysis.v1alpha1.UpdateScanConfigRequest")
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.Note_Kind", Note_Kind_name, Note_Kind_value)
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.Deployable_Deployment_Platform", Deployable_Deployment_Platform_name, Deployable_Deployment_Platform_value)
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.Discovery_Discovered_AnalysisStatus", Discovery_Discovered_AnalysisStatus_name, Discovery_Discovered_AnalysisStatus_value)
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.BuildSignature_KeyType", BuildSignature_KeyType_name, BuildSignature_KeyType_value)
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.PgpSignedAttestation_ContentType", PgpSignedAttestation_ContentType_name, PgpSignedAttestation_ContentType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ContainerAnalysis service

type ContainerAnalysisClient interface {
	// Returns the requested `Occurrence`.
	GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Lists active `Occurrences` for a given project matching the filters.
	ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error)
	// Deletes the given `Occurrence` from the system. Use this when
	// an `Occurrence` is no longer applicable for the given resource.
	DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates a new `Occurrence`. Use this method to create `Occurrences`
	// for a resource.
	CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Updates an existing occurrence.
	UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Gets the `Note` attached to the given `Occurrence`.
	GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Returns the requested `Note`.
	GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists all `Notes` for a given project.
	ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error)
	// Deletes the given `Note` from the system.
	DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates a new `Note`.
	CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Updates an existing `Note`.
	UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists `Occurrences` referencing the specified `Note`. Use this method to
	// get all occurrences referencing your `Note` across all your customer
	// projects.
	ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error)
	// Gets a summary of the number and severity of occurrences.
	GetVulnzOccurrencesSummary(ctx context.Context, in *GetVulnzOccurrencesSummaryRequest, opts ...grpc.CallOption) (*GetVulnzOccurrencesSummaryResponse, error)
	// Sets the access control policy on the specified `Note` or `Occurrence`.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a `Note` or an `Occurrence`, respectively.
	// Attempting to call this method without these permissions will result in a `
	// `PERMISSION_DENIED` error.
	// Attempting to call this method on a non-existent resource will result in a
	// `NOT_FOUND` error if the user has `containeranalysis.notes.list` permission
	// on a `Note` or `containeranalysis.occurrences.list` on an `Occurrence`, or
	// a `PERMISSION_DENIED` error otherwise. The resource takes the following
	// formats: `projects/{projectid}/occurrences/{occurrenceid}` for occurrences
	// and projects/{projectid}/notes/{noteid} for notes
	SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a note or an `Occurrence` resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	// Attempting to call this method on a resource without the required
	// permission will result in a `PERMISSION_DENIED` error. Attempting to call
	// this method on a non-existent resource will result in a `NOT_FOUND` error
	// if the user has list permission on the project, or a `PERMISSION_DENIED`
	// error otherwise. The resource takes the following formats:
	// `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for occurrences and
	// projects/{PROJECT_ID}/notes/{NOTE_ID} for notes
	GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence resource. Requires list permission on the project (for example,
	// "storage.objects.list" on the containing bucket for testing permission of
	// an object). Attempting to call this method on a non-existent resource will
	// result in a `NOT_FOUND` error if the user has list permission on the
	// project, or a `PERMISSION_DENIED` error otherwise. The resource takes the
	// following formats: `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for
	// `Occurrences` and `projects/{PROJECT_ID}/notes/{NOTE_ID}` for `Notes`
	TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error)
	// Creates a new `Operation`.
	CreateOperation(ctx context.Context, in *CreateOperationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates an existing operation returns an error if operation
	//  does not exist. The only valid operations are to update mark the done bit
	// change the result.
	UpdateOperation(ctx context.Context, in *UpdateOperationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets a specific scan configuration for a project.
	GetScanConfig(ctx context.Context, in *GetScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error)
	// Lists scan configurations for a project.
	ListScanConfigs(ctx context.Context, in *ListScanConfigsRequest, opts ...grpc.CallOption) (*ListScanConfigsResponse, error)
	// Updates the scan configuration to a new value.
	UpdateScanConfig(ctx context.Context, in *UpdateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error)
}

type containerAnalysisClient struct {
	cc *grpc.ClientConn
}

func NewContainerAnalysisClient(cc *grpc.ClientConn) ContainerAnalysisClient {
	return &containerAnalysisClient{cc}
}

func (c *containerAnalysisClient) GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error) {
	out := new(ListOccurrencesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListOccurrences", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrenceNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error) {
	out := new(ListNotesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNotes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error) {
	out := new(ListNoteOccurrencesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNoteOccurrences", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetVulnzOccurrencesSummary(ctx context.Context, in *GetVulnzOccurrencesSummaryRequest, opts ...grpc.CallOption) (*GetVulnzOccurrencesSummaryResponse, error) {
	out := new(GetVulnzOccurrencesSummaryResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetVulnzOccurrencesSummary", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error) {
	out := new(google_iam_v11.TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) CreateOperation(ctx context.Context, in *CreateOperationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) UpdateOperation(ctx context.Context, in *UpdateOperationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetScanConfig(ctx context.Context, in *GetScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error) {
	out := new(ScanConfig)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetScanConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) ListScanConfigs(ctx context.Context, in *ListScanConfigsRequest, opts ...grpc.CallOption) (*ListScanConfigsResponse, error) {
	out := new(ListScanConfigsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListScanConfigs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) UpdateScanConfig(ctx context.Context, in *UpdateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error) {
	out := new(ScanConfig)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateScanConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ContainerAnalysis service

type ContainerAnalysisServer interface {
	// Returns the requested `Occurrence`.
	GetOccurrence(context.Context, *GetOccurrenceRequest) (*Occurrence, error)
	// Lists active `Occurrences` for a given project matching the filters.
	ListOccurrences(context.Context, *ListOccurrencesRequest) (*ListOccurrencesResponse, error)
	// Deletes the given `Occurrence` from the system. Use this when
	// an `Occurrence` is no longer applicable for the given resource.
	DeleteOccurrence(context.Context, *DeleteOccurrenceRequest) (*google_protobuf3.Empty, error)
	// Creates a new `Occurrence`. Use this method to create `Occurrences`
	// for a resource.
	CreateOccurrence(context.Context, *CreateOccurrenceRequest) (*Occurrence, error)
	// Updates an existing occurrence.
	UpdateOccurrence(context.Context, *UpdateOccurrenceRequest) (*Occurrence, error)
	// Gets the `Note` attached to the given `Occurrence`.
	GetOccurrenceNote(context.Context, *GetOccurrenceNoteRequest) (*Note, error)
	// Returns the requested `Note`.
	GetNote(context.Context, *GetNoteRequest) (*Note, error)
	// Lists all `Notes` for a given project.
	ListNotes(context.Context, *ListNotesRequest) (*ListNotesResponse, error)
	// Deletes the given `Note` from the system.
	DeleteNote(context.Context, *DeleteNoteRequest) (*google_protobuf3.Empty, error)
	// Creates a new `Note`.
	CreateNote(context.Context, *CreateNoteRequest) (*Note, error)
	// Updates an existing `Note`.
	UpdateNote(context.Context, *UpdateNoteRequest) (*Note, error)
	// Lists `Occurrences` referencing the specified `Note`. Use this method to
	// get all occurrences referencing your `Note` across all your customer
	// projects.
	ListNoteOccurrences(context.Context, *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error)
	// Gets a summary of the number and severity of occurrences.
	GetVulnzOccurrencesSummary(context.Context, *GetVulnzOccurrencesSummaryRequest) (*GetVulnzOccurrencesSummaryResponse, error)
	// Sets the access control policy on the specified `Note` or `Occurrence`.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a `Note` or an `Occurrence`, respectively.
	// Attempting to call this method without these permissions will result in a `
	// `PERMISSION_DENIED` error.
	// Attempting to call this method on a non-existent resource will result in a
	// `NOT_FOUND` error if the user has `containeranalysis.notes.list` permission
	// on a `Note` or `containeranalysis.occurrences.list` on an `Occurrence`, or
	// a `PERMISSION_DENIED` error otherwise. The resource takes the following
	// formats: `projects/{projectid}/occurrences/{occurrenceid}` for occurrences
	// and projects/{projectid}/notes/{noteid} for notes
	SetIamPolicy(context.Context, *google_iam_v11.SetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a note or an `Occurrence` resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	// Attempting to call this method on a resource without the required
	// permission will result in a `PERMISSION_DENIED` error. Attempting to call
	// this method on a non-existent resource will result in a `NOT_FOUND` error
	// if the user has list permission on the project, or a `PERMISSION_DENIED`
	// error otherwise. The resource takes the following formats:
	// `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for occurrences and
	// projects/{PROJECT_ID}/notes/{NOTE_ID} for notes
	GetIamPolicy(context.Context, *google_iam_v11.GetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence resource. Requires list permission on the project (for example,
	// "storage.objects.list" on the containing bucket for testing permission of
	// an object). Attempting to call this method on a non-existent resource will
	// result in a `NOT_FOUND` error if the user has list permission on the
	// project, or a `PERMISSION_DENIED` error otherwise. The resource takes the
	// following formats: `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for
	// `Occurrences` and `projects/{PROJECT_ID}/notes/{NOTE_ID}` for `Notes`
	TestIamPermissions(context.Context, *google_iam_v11.TestIamPermissionsRequest) (*google_iam_v11.TestIamPermissionsResponse, error)
	// Creates a new `Operation`.
	CreateOperation(context.Context, *CreateOperationRequest) (*google_longrunning.Operation, error)
	// Updates an existing operation returns an error if operation
	//  does not exist. The only valid operations are to update mark the done bit
	// change the result.
	UpdateOperation(context.Context, *UpdateOperationRequest) (*google_longrunning.Operation, error)
	// Gets a specific scan configuration for a project.
	GetScanConfig(context.Context, *GetScanConfigRequest) (*ScanConfig, error)
	// Lists scan configurations for a project.
	ListScanConfigs(context.Context, *ListScanConfigsRequest) (*ListScanConfigsResponse, error)
	// Updates the scan configuration to a new value.
	UpdateScanConfig(context.Context, *UpdateScanConfigRequest) (*ScanConfig, error)
}

func RegisterContainerAnalysisServer(s *grpc.Server, srv ContainerAnalysisServer) {
	s.RegisterService(&_ContainerAnalysis_serviceDesc, srv)
}

func _ContainerAnalysis_GetOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetOccurrence(ctx, req.(*GetOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_ListOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).ListOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).ListOccurrences(ctx, req.(*ListOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_DeleteOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).DeleteOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).DeleteOccurrence(ctx, req.(*DeleteOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_CreateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).CreateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).CreateOccurrence(ctx, req.(*CreateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_UpdateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).UpdateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).UpdateOccurrence(ctx, req.(*UpdateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetOccurrenceNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetOccurrenceNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrenceNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetOccurrenceNote(ctx, req.(*GetOccurrenceNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetNote(ctx, req.(*GetNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_ListNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).ListNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).ListNotes(ctx, req.(*ListNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_DeleteNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).DeleteNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).DeleteNote(ctx, req.(*DeleteNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_CreateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).CreateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).CreateNote(ctx, req.(*CreateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_UpdateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).UpdateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).UpdateNote(ctx, req.(*UpdateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_ListNoteOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNoteOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).ListNoteOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNoteOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).ListNoteOccurrences(ctx, req.(*ListNoteOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetVulnzOccurrencesSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVulnzOccurrencesSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetVulnzOccurrencesSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetVulnzOccurrencesSummary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetVulnzOccurrencesSummary(ctx, req.(*GetVulnzOccurrencesSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).SetIamPolicy(ctx, req.(*google_iam_v11.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetIamPolicy(ctx, req.(*google_iam_v11.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).TestIamPermissions(ctx, req.(*google_iam_v11.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_CreateOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).CreateOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).CreateOperation(ctx, req.(*CreateOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_UpdateOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).UpdateOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).UpdateOperation(ctx, req.(*UpdateOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetScanConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetScanConfig(ctx, req.(*GetScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_ListScanConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListScanConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).ListScanConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListScanConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).ListScanConfigs(ctx, req.(*ListScanConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_UpdateScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).UpdateScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateScanConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).UpdateScanConfig(ctx, req.(*UpdateScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ContainerAnalysis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.containeranalysis.v1alpha1.ContainerAnalysis",
	HandlerType: (*ContainerAnalysisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOccurrence",
			Handler:    _ContainerAnalysis_GetOccurrence_Handler,
		},
		{
			MethodName: "ListOccurrences",
			Handler:    _ContainerAnalysis_ListOccurrences_Handler,
		},
		{
			MethodName: "DeleteOccurrence",
			Handler:    _ContainerAnalysis_DeleteOccurrence_Handler,
		},
		{
			MethodName: "CreateOccurrence",
			Handler:    _ContainerAnalysis_CreateOccurrence_Handler,
		},
		{
			MethodName: "UpdateOccurrence",
			Handler:    _ContainerAnalysis_UpdateOccurrence_Handler,
		},
		{
			MethodName: "GetOccurrenceNote",
			Handler:    _ContainerAnalysis_GetOccurrenceNote_Handler,
		},
		{
			MethodName: "GetNote",
			Handler:    _ContainerAnalysis_GetNote_Handler,
		},
		{
			MethodName: "ListNotes",
			Handler:    _ContainerAnalysis_ListNotes_Handler,
		},
		{
			MethodName: "DeleteNote",
			Handler:    _ContainerAnalysis_DeleteNote_Handler,
		},
		{
			MethodName: "CreateNote",
			Handler:    _ContainerAnalysis_CreateNote_Handler,
		},
		{
			MethodName: "UpdateNote",
			Handler:    _ContainerAnalysis_UpdateNote_Handler,
		},
		{
			MethodName: "ListNoteOccurrences",
			Handler:    _ContainerAnalysis_ListNoteOccurrences_Handler,
		},
		{
			MethodName: "GetVulnzOccurrencesSummary",
			Handler:    _ContainerAnalysis_GetVulnzOccurrencesSummary_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ContainerAnalysis_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ContainerAnalysis_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ContainerAnalysis_TestIamPermissions_Handler,
		},
		{
			MethodName: "CreateOperation",
			Handler:    _ContainerAnalysis_CreateOperation_Handler,
		},
		{
			MethodName: "UpdateOperation",
			Handler:    _ContainerAnalysis_UpdateOperation_Handler,
		},
		{
			MethodName: "GetScanConfig",
			Handler:    _ContainerAnalysis_GetScanConfig_Handler,
		},
		{
			MethodName: "ListScanConfigs",
			Handler:    _ContainerAnalysis_ListScanConfigs_Handler,
		},
		{
			MethodName: "UpdateScanConfig",
			Handler:    _ContainerAnalysis_UpdateScanConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/containeranalysis/v1alpha1/containeranalysis.proto",
}

func init() {
	proto.RegisterFile("google/devtools/containeranalysis/v1alpha1/containeranalysis.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 3256 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5b, 0xdb, 0x6f, 0x23, 0x57,
	0x19, 0xdf, 0xc9, 0xd5, 0xfe, 0x9c, 0x8b, 0x73, 0x36, 0xbb, 0xeb, 0x7a, 0x7b, 0x49, 0xa7, 0x94,
	0x6e, 0x53, 0x6a, 0x77, 0xd3, 0x96, 0xc2, 0x6e, 0x97, 0x5d, 0xc7, 0x76, 0x12, 0x37, 0x89, 0x63,
	0xcd, 0x38, 0x61, 0xd3, 0x96, 0x8e, 0xc6, 0xf6, 0x89, 0x33, 0x64, 0x3c, 0x33, 0xcc, 0x8c, 0xc3,
	0x66, 0x51, 0x25, 0x44, 0x0b, 0xa8, 0x12, 0x45, 0xe5, 0xfa, 0xc2, 0xa5, 0x52, 0x41, 0x95, 0x80,
	0x17, 0x5e, 0x78, 0x83, 0x17, 0x40, 0x3c, 0x01, 0x42, 0xe2, 0x19, 0xf1, 0x00, 0x0f, 0xfc, 0x0b,
	0x48, 0x3c, 0xa0, 0x73, 0xe6, 0x9c, 0x99, 0xf1, 0x25, 0x89, 0xc7, 0xde, 0x4a, 0x7d, 0xda, 0x39,
	0xdf, 0xf9, 0xce, 0x77, 0x3b, 0xdf, 0xf9, 0x9d, 0xef, 0x3b, 0xf1, 0xc2, 0x6a, 0xd3, 0x34, 0x9b,
	0x3a, 0xce, 0x36, 0xf0, 0xb1, 0x6b, 0x9a, 0xba, 0x93, 0xad, 0x9b, 0x86, 0xab, 0x6a, 0x06, 0xb6,
	0x55, 0x43, 0xd5, 0x4f, 0x1c, 0xcd, 0xc9, 0x1e, 0x5f, 0x57, 0x75, 0xeb, 0x50, 0xbd, 0xde, 0x3b,
	0x95, 0xb1, 0x6c, 0xd3, 0x35, 0xd1, 0xb2, 0x27, 0x23, 0xc3, 0x65, 0x64, 0x7a, 0x19, 0xb9, 0x8c,
	0xf4, 0xc3, 0x4c, 0x9f, 0x6a, 0x69, 0x59, 0xd5, 0x30, 0x4c, 0x57, 0x75, 0x35, 0xd3, 0x60, 0x92,
	0xd2, 0x51, 0xac, 0xa9, 0x69, 0xba, 0xae, 0x98, 0x07, 0x4a, 0x4b, 0x75, 0xb1, 0xad, 0xa9, 0x3a,
	0x97, 0xf1, 0x72, 0x04, 0x19, 0x5a, 0x4b, 0x6d, 0x62, 0xa5, 0xa6, 0xfa, 0xbe, 0xa4, 0xd7, 0x22,
	0xac, 0xb6, 0xd4, 0xfa, 0x11, 0x59, 0x7f, 0xdc, 0xd6, 0xc9, 0x7c, 0x4d, 0xd3, 0x35, 0xf7, 0x84,
	0xc9, 0xb9, 0x19, 0x45, 0x8e, 0x6d, 0x1e, 0x63, 0x43, 0x35, 0xea, 0x98, 0x2d, 0x7e, 0x94, 0x2d,
	0xd6, 0xd4, 0x56, 0xf6, 0xf8, 0x3a, 0xf9, 0x47, 0xb1, 0x4c, 0x5d, 0xab, 0x73, 0xe1, 0xe9, 0xce,
	0xf9, 0x8e, 0xb9, 0x27, 0xd8, 0x9c, 0x6e, 0x1a, 0x4d, 0xbb, 0x6d, 0x18, 0x9a, 0xd1, 0xcc, 0x9a,
	0x16, 0xb6, 0x3b, 0xe2, 0xfc, 0x10, 0x63, 0xa2, 0xa3, 0x5a, 0xfb, 0x20, 0xab, 0x1a, 0x7c, 0xfd,
	0xd5, 0xee, 0x29, 0xdc, 0xb2, 0x7c, 0xaf, 0x96, 0xba, 0x27, 0x0f, 0x34, 0xac, 0x37, 0x94, 0x96,
	0xea, 0x1c, 0x31, 0x8e, 0xc7, 0xba, 0x39, 0x5c, 0xad, 0x85, 0x1d, 0x57, 0x6d, 0x59, 0x8c, 0xe1,
	0x0a, 0x63, 0xb0, 0xad, 0x7a, 0xd6, 0x71, 0x55, 0xb7, 0xcd, 0x6c, 0x12, 0x7f, 0x16, 0x07, 0xd8,
	0xa9, 0xd7, 0xdb, 0xb6, 0x8d, 0x8d, 0x3a, 0x46, 0x08, 0x26, 0x0c, 0xb5, 0x85, 0x53, 0xc2, 0x92,
	0x70, 0x2d, 0x2e, 0xd1, 0x6f, 0xf4, 0x38, 0xcc, 0xd8, 0xd8, 0x31, 0xdb, 0x76, 0x1d, 0x2b, 0x6d,
	0x5b, 0x4f, 0x8d, 0xd1, 0xb9, 0x04, 0xa7, 0xed, 0xda, 0x3a, 0xaa, 0x40, 0x8c, 0x0f, 0x53, 0x0b,
	0x4b, 0xc2, 0xb5, 0xc4, 0xca, 0x0b, 0x99, 0xc1, 0xd3, 0x33, 0x23, 0xb1, 0xb5, 0x92, 0x2f, 0x05,
	0x5d, 0x85, 0xb8, 0x61, 0xba, 0x58, 0xa1, 0xd6, 0x8c, 0x53, 0x8d, 0x31, 0x42, 0x28, 0x13, 0x8b,
	0x4a, 0x30, 0x71, 0xa4, 0x19, 0x8d, 0xd4, 0xd4, 0x92, 0x70, 0x6d, 0x6e, 0xe5, 0xc5, 0x28, 0xaa,
	0xca, 0xa6, 0x8b, 0x33, 0x9b, 0x9a, 0xd1, 0x90, 0xa8, 0x08, 0xf4, 0x8e, 0x00, 0x97, 0x3a, 0x32,
	0x49, 0x69, 0x60, 0x57, 0xd5, 0x74, 0x27, 0x15, 0xa3, 0x7e, 0x48, 0x51, 0x84, 0xef, 0x85, 0x05,
	0x55, 0x4f, 0x2c, 0xdc, 0x49, 0x29, 0x78, 0x92, 0x37, 0x2e, 0x48, 0x8b, 0xc7, 0x7d, 0xe8, 0x48,
	0x81, 0xd9, 0x5a, 0x5b, 0xd3, 0x1b, 0xbe, 0x09, 0xd3, 0xd4, 0x84, 0xcf, 0x44, 0x31, 0x61, 0x95,
	0x08, 0x08, 0x14, 0xcd, 0xd4, 0x42, 0x63, 0x74, 0x00, 0xb3, 0x0d, 0x6c, 0x6b, 0xc7, 0xb8, 0xa1,
	0xd0, 0x33, 0x98, 0x4a, 0x50, 0x05, 0xb7, 0xa3, 0x28, 0x28, 0x98, 0xf5, 0x23, 0x6c, 0x97, 0xc8,
	0xf2, 0x4c, 0xc1, 0x13, 0x46, 0xf4, 0x30, 0xb9, 0x94, 0x8e, 0x5a, 0x30, 0xa3, 0x19, 0x8e, 0xab,
	0xea, 0x3a, 0xcd, 0xff, 0xd4, 0x0c, 0x55, 0xb3, 0x1e, 0x45, 0x4d, 0xc5, 0x3b, 0xe5, 0xdb, 0xaa,
	0xa1, 0x36, 0xb1, 0x9d, 0x29, 0x85, 0xc4, 0x11, 0x75, 0x61, 0xf1, 0xa8, 0x0e, 0xd0, 0xc0, 0x96,
	0x6e, 0x9e, 0xb4, 0xb0, 0xe1, 0xa6, 0xe6, 0xa8, 0xb2, 0x5c, 0x24, 0x9f, 0xe8, 0x6a, 0xb5, 0xa6,
	0x63, 0xf6, 0x49, 0x04, 0x6d, 0x5c, 0x90, 0x42, 0x62, 0x51, 0x0d, 0xa0, 0xa1, 0x39, 0x75, 0xf3,
	0x18, 0xdb, 0xb8, 0x91, 0x9a, 0xa7, 0x4a, 0xee, 0x44, 0x52, 0xc2, 0x56, 0x9f, 0xf8, 0x5f, 0x34,
	0x72, 0x21, 0xa9, 0xc8, 0x82, 0x84, 0xea, 0xba, 0xe4, 0xe0, 0xd2, 0xb0, 0x25, 0xa9, 0x92, 0xad,
	0x28, 0x4a, 0x72, 0xc1, 0xf2, 0x5c, 0xdb, 0x3d, 0x34, 0x6d, 0x82, 0x8d, 0x21, 0xe2, 0xc6, 0x05,
	0x29, 0xac, 0x02, 0x2d, 0x41, 0xc2, 0xc6, 0x2d, 0xdc, 0xd0, 0x3c, 0x8d, 0x93, 0xfc, 0x68, 0xfb,
	0x24, 0x74, 0x13, 0x12, 0x75, 0x1b, 0xab, 0x2e, 0x56, 0x08, 0xa6, 0xa4, 0xe2, 0xd4, 0xa6, 0x34,
	0xb7, 0x89, 0x03, 0x4e, 0xa6, 0xca, 0x01, 0x47, 0x02, 0x8f, 0x9d, 0x10, 0xc8, 0xe2, 0xb6, 0xd5,
	0xf0, 0x17, 0xc3, 0xf9, 0x8b, 0x3d, 0x76, 0x42, 0x58, 0x8d, 0xc3, 0x34, 0x3b, 0x08, 0xe2, 0xd7,
	0x05, 0x88, 0x71, 0x90, 0xe8, 0x8b, 0x51, 0x49, 0x18, 0x6f, 0xdb, 0x1a, 0x83, 0x26, 0xf2, 0x89,
	0x64, 0x98, 0x21, 0x71, 0xc2, 0x86, 0xab, 0x1c, 0xaa, 0xce, 0x21, 0xc5, 0x90, 0xc4, 0xca, 0x73,
	0x51, 0x82, 0xb9, 0xa1, 0x3a, 0x87, 0x52, 0x82, 0x49, 0x21, 0x03, 0xf1, 0x7f, 0x00, 0x13, 0x04,
	0x41, 0xfa, 0xda, 0xf0, 0x0c, 0x2c, 0x38, 0x87, 0xa6, 0xed, 0x2a, 0x0d, 0xec, 0xd4, 0x6d, 0xcd,
	0xa2, 0x11, 0xf5, 0xa0, 0x2b, 0x49, 0x27, 0x0a, 0x01, 0x1d, 0x3d, 0x0d, 0x49, 0x72, 0x57, 0x74,
	0xf0, 0x4e, 0x50, 0xde, 0x79, 0x42, 0x0f, 0xb3, 0x72, 0xb4, 0x8b, 0x8f, 0x8e, 0x76, 0x06, 0xa0,
	0x4e, 0xb0, 0x73, 0x4f, 0x2c, 0x4c, 0x61, 0x34, 0xb1, 0x72, 0x6b, 0x24, 0xa4, 0xdb, 0xb8, 0x20,
	0x2d, 0x1c, 0x77, 0x13, 0xd1, 0x1e, 0x80, 0x87, 0x68, 0x54, 0x8f, 0x87, 0xa8, 0x2f, 0x46, 0x86,
	0x33, 0x26, 0x3f, 0x5e, 0xe3, 0x03, 0xf4, 0x06, 0x40, 0x4d, 0x75, 0x30, 0x43, 0xb1, 0xd9, 0xe8,
	0xf6, 0x87, 0x51, 0x6c, 0x95, 0x14, 0x22, 0x54, 0xbe, 0xea, 0x60, 0x0f, 0xc0, 0xde, 0x80, 0x69,
	0x56, 0x66, 0x30, 0x38, 0x59, 0x1d, 0x01, 0xbb, 0xd8, 0x70, 0xe3, 0x82, 0xc4, 0x85, 0xa2, 0xbb,
	0x1c, 0xb1, 0x08, 0xe6, 0xb0, 0x1b, 0xf3, 0xd3, 0xc3, 0x21, 0x56, 0x00, 0x53, 0x64, 0x84, 0x76,
	0x21, 0xce, 0x01, 0xe5, 0x24, 0x85, 0xa2, 0x07, 0xdc, 0x47, 0x29, 0x12, 0x10, 0x5f, 0x12, 0xfa,
	0x32, 0x5c, 0x0a, 0xc1, 0x86, 0xa2, 0x72, 0x6c, 0x49, 0x5d, 0x8c, 0x0e, 0x84, 0xfd, 0x30, 0x8a,
	0xdc, 0x89, 0x6a, 0x1f, 0x3a, 0x7a, 0x9d, 0x00, 0x94, 0xae, 0xba, 0xb8, 0x41, 0x6b, 0x8f, 0xe9,
	0xa5, 0xf1, 0x6b, 0x89, 0x95, 0x9b, 0x91, 0xcf, 0x80, 0xe4, 0xc9, 0xd8, 0xb5, 0x75, 0x09, 0x6c,
	0xff, 0x1b, 0xe5, 0x61, 0x1e, 0xdf, 0xb3, 0x34, 0xaf, 0x4c, 0x1b, 0x14, 0xa3, 0xe6, 0x82, 0x25,
	0x1c, 0xe4, 0xc2, 0x08, 0x99, 0x18, 0x05, 0x21, 0x67, 0xa2, 0x20, 0x64, 0xfa, 0x05, 0x80, 0xc0,
	0x31, 0x0f, 0x03, 0x75, 0x06, 0x49, 0xe4, 0x13, 0x2d, 0xc2, 0xa4, 0xae, 0xd6, 0x30, 0x2f, 0xd9,
	0xbc, 0x81, 0xf8, 0x4b, 0x01, 0x26, 0x08, 0x26, 0xa0, 0x45, 0x48, 0x6e, 0x96, 0xca, 0x05, 0x65,
	0xb7, 0x2c, 0x57, 0x8a, 0xf9, 0xd2, 0x5a, 0xa9, 0x58, 0x48, 0x5e, 0x40, 0x0f, 0xc1, 0xa5, 0x4a,
	0x2e, 0xbf, 0x99, 0x5b, 0x2f, 0x2a, 0x7b, 0xbb, 0x5b, 0xe5, 0xa2, 0x94, 0x5b, 0x2d, 0x6d, 0x95,
	0xaa, 0xfb, 0xc9, 0x31, 0xb4, 0x00, 0xb3, 0xab, 0xbb, 0xa5, 0xad, 0x82, 0x52, 0x28, 0x56, 0x73,
	0xa5, 0x2d, 0x39, 0x39, 0x8e, 0xe6, 0x21, 0x51, 0xda, 0x26, 0xbc, 0xab, 0x39, 0xb9, 0x24, 0x27,
	0x27, 0xd0, 0x45, 0x98, 0xe7, 0xcb, 0xb7, 0x73, 0xe5, 0xdc, 0x7a, 0x51, 0x4a, 0x4e, 0xa2, 0x39,
	0x80, 0x42, 0xb1, 0xb2, 0xb5, 0xb3, 0x9f, 0x5b, 0xdd, 0x2a, 0x26, 0xa7, 0xd0, 0x2c, 0xc4, 0x0b,
	0x25, 0x39, 0xbf, 0xb3, 0x57, 0x94, 0xf6, 0x93, 0xd3, 0x44, 0x65, 0xae, 0x5a, 0x2d, 0xca, 0xd5,
	0x5c, 0xb5, 0xb4, 0x53, 0x56, 0x72, 0xbb, 0xd5, 0x8d, 0x1d, 0x89, 0xa8, 0x8c, 0xad, 0x26, 0x58,
	0x1d, 0x48, 0x00, 0x44, 0xfc, 0xc7, 0x38, 0x40, 0x90, 0xf9, 0x5d, 0x85, 0xa9, 0x96, 0x12, 0x96,
	0xc6, 0x3b, 0x0b, 0x53, 0x2d, 0xfd, 0x2b, 0x7f, 0x05, 0xbd, 0xc4, 0x1f, 0x01, 0x68, 0x3b, 0xd8,
	0x56, 0x70, 0x4b, 0xd5, 0x78, 0xa4, 0xe2, 0x84, 0x52, 0x24, 0x04, 0xb2, 0x19, 0xde, 0x51, 0xf2,
	0x36, 0x63, 0xec, 0xfc, 0xcd, 0xf0, 0xd8, 0xe9, 0x4e, 0xde, 0x86, 0xd9, 0xb6, 0x11, 0x5e, 0x3e,
	0x7e, 0xee, 0xf2, 0x19, 0xbe, 0x80, 0x0a, 0xb8, 0x0c, 0x53, 0x75, 0xd3, 0x38, 0xd0, 0x9a, 0x14,
	0x28, 0xe3, 0x12, 0x1b, 0xa1, 0x14, 0x4c, 0xab, 0x8d, 0x86, 0x8d, 0x1d, 0x87, 0xdd, 0xcf, 0x7c,
	0xd8, 0x13, 0x80, 0xa9, 0x9e, 0x00, 0xa0, 0x03, 0x88, 0x59, 0xba, 0xea, 0x1e, 0x98, 0x76, 0x8b,
	0x96, 0x93, 0x73, 0x2b, 0xaf, 0x8c, 0x5c, 0x19, 0x65, 0x2a, 0x4c, 0xa2, 0xe4, 0xcb, 0x16, 0xf3,
	0x10, 0xe3, 0x54, 0x94, 0x82, 0xc5, 0xca, 0x56, 0xae, 0xba, 0xb6, 0x23, 0x6d, 0x77, 0xe5, 0xd6,
	0x34, 0x8c, 0xaf, 0x6f, 0x16, 0x93, 0x02, 0x8a, 0xc1, 0xc4, 0xda, 0x56, 0xf1, 0x6e, 0x72, 0x0c,
	0x01, 0x4c, 0xe5, 0x77, 0xe5, 0xea, 0xce, 0x76, 0x72, 0x5c, 0x7c, 0x67, 0x02, 0xe2, 0x3e, 0x00,
	0xa1, 0x57, 0x61, 0x96, 0x1b, 0xa4, 0xd0, 0x0b, 0x50, 0x18, 0xe5, 0x02, 0x9c, 0xe1, 0x93, 0x64,
	0x94, 0x7e, 0x9f, 0xe4, 0x45, 0x50, 0x78, 0xdd, 0x84, 0xb8, 0xdf, 0xad, 0x51, 0x35, 0x89, 0x95,
	0x47, 0xb8, 0x9a, 0x50, 0x4b, 0x97, 0xd9, 0xe1, 0x4c, 0x52, 0xc0, 0x8f, 0xee, 0xc1, 0xbc, 0x6f,
	0xa7, 0xd7, 0x5b, 0xd1, 0x7d, 0x9a, 0x5b, 0xd9, 0x19, 0xb5, 0x3c, 0xcc, 0xe4, 0x18, 0x9b, 0x4c,
	0xc5, 0x4a, 0x73, 0x6a, 0xc7, 0x18, 0xad, 0xc1, 0xa5, 0x2e, 0xcd, 0x0a, 0xb6, 0x6d, 0xd3, 0x66,
	0x37, 0x3a, 0xe2, 0xfa, 0x6d, 0xab, 0x9e, 0x61, 0x22, 0x2e, 0x76, 0x8a, 0x28, 0x12, 0x76, 0xf1,
	0x3b, 0x02, 0xcc, 0x75, 0xaa, 0x42, 0x8f, 0xc1, 0xd5, 0x5c, 0x39, 0xb7, 0xb5, 0x2f, 0x97, 0x64,
	0x85, 0x9c, 0xcb, 0x5d, 0xb9, 0x6b, 0x2b, 0x13, 0x30, 0x5d, 0x29, 0x96, 0x0b, 0xa5, 0xf2, 0x7a,
	0x52, 0x40, 0x33, 0x10, 0x93, 0xf3, 0xb9, 0x72, 0x99, 0x8c, 0xc6, 0x08, 0xae, 0xac, 0x95, 0xca,
	0x25, 0x79, 0xa3, 0x58, 0x50, 0xe4, 0xdd, 0x7c, 0xbe, 0x28, 0x13, 0xa4, 0xb8, 0x08, 0xf3, 0x3e,
	0x75, 0x2d, 0x57, 0xda, 0x2a, 0x16, 0x92, 0x13, 0x24, 0x55, 0x76, 0xcb, 0xf2, 0x6e, 0xa5, 0xb2,
	0x23, 0x55, 0x8b, 0x05, 0x45, 0x2a, 0xca, 0x3b, 0xbb, 0x52, 0xbe, 0x98, 0x9c, 0x14, 0xbf, 0x2d,
	0x40, 0xdc, 0xbf, 0xfd, 0xd1, 0x53, 0x30, 0x4f, 0x6f, 0x7f, 0x6c, 0x2b, 0xc7, 0xd8, 0x76, 0xf8,
	0x36, 0xc5, 0xa5, 0x39, 0x46, 0xde, 0xf3, 0xa8, 0xe8, 0x2e, 0xc4, 0x1d, 0xad, 0x69, 0xa8, 0x6e,
	0xdb, 0xe6, 0x07, 0xf8, 0x46, 0xe4, 0x82, 0x43, 0xe6, 0x12, 0xa4, 0x40, 0x98, 0xf8, 0xee, 0x18,
	0xcc, 0x75, 0xce, 0x12, 0x38, 0xb1, 0xda, 0x35, 0x5d, 0xab, 0x2b, 0x47, 0xf8, 0x84, 0xc3, 0x89,
	0x47, 0xd9, 0xc4, 0x27, 0xe8, 0xe1, 0x6e, 0x5b, 0xe2, 0x21, 0x79, 0xe8, 0x12, 0x4c, 0x1d, 0xe1,
	0x13, 0x45, 0x6b, 0xb0, 0x1a, 0x71, 0xf2, 0x08, 0x9f, 0x94, 0x1a, 0xe8, 0x0b, 0x10, 0x23, 0x64,
	0x5a, 0x30, 0x4d, 0xd0, 0x34, 0x5a, 0x1d, 0xde, 0xfe, 0xcc, 0x26, 0xa6, 0x85, 0x98, 0x34, 0x7d,
	0xe4, 0x7d, 0x88, 0x1b, 0x30, 0xcd, 0x68, 0x24, 0xf6, 0x9b, 0xc5, 0x7d, 0xa5, 0xba, 0x5f, 0x29,
	0x76, 0xed, 0xed, 0x25, 0x58, 0xa8, 0xac, 0x57, 0x94, 0x9c, 0x9c, 0x2f, 0x95, 0x94, 0x9c, 0xb4,
	0xbd, 0x23, 0x15, 0x0b, 0xde, 0x2e, 0x57, 0x36, 0x4b, 0x77, 0x95, 0x4a, 0x71, 0x3b, 0x39, 0x26,
	0xfe, 0x60, 0x0c, 0x16, 0x2b, 0x4d, 0x8b, 0xe8, 0xc2, 0x8d, 0xd0, 0x9d, 0xde, 0xe9, 0xb6, 0xd0,
	0xed, 0xb6, 0x19, 0xd4, 0xe5, 0xd4, 0xc7, 0x71, 0xea, 0x63, 0xa4, 0x26, 0xa7, 0x9f, 0xd6, 0x4c,
	0xde, 0x13, 0x4a, 0xbd, 0xe5, 0x35, 0x3b, 0x75, 0xf3, 0x51, 0x00, 0xab, 0x69, 0x29, 0x2c, 0xd6,
	0x74, 0x1b, 0x36, 0x2e, 0x48, 0x31, 0xab, 0x69, 0x6d, 0x92, 0x80, 0x8b, 0x05, 0x48, 0x84, 0xd6,
	0xa2, 0x87, 0x21, 0x95, 0xdf, 0x29, 0x57, 0x8b, 0xe5, 0x6a, 0xbf, 0xc8, 0x5c, 0x81, 0x8b, 0x72,
	0x69, 0xbb, 0xb2, 0x55, 0x54, 0xe4, 0xd2, 0x3a, 0x49, 0x77, 0xe5, 0x15, 0x79, 0xa7, 0x9c, 0x14,
	0x56, 0x63, 0x7c, 0x37, 0xc5, 0xff, 0x8c, 0xc1, 0x62, 0xbf, 0x12, 0x07, 0xb5, 0x60, 0xe2, 0x50,
	0x33, 0x5c, 0x86, 0x2f, 0xfb, 0x0f, 0xb2, 0xad, 0x0b, 0xea, 0x28, 0xcd, 0x70, 0x25, 0xaa, 0x26,
	0xfd, 0x0a, 0xa4, 0x4e, 0xe3, 0x40, 0x19, 0xb8, 0x78, 0xd8, 0x6e, 0xa9, 0x86, 0x62, 0x63, 0xb5,
	0x41, 0xd0, 0x5d, 0x09, 0x75, 0x33, 0x0b, 0x74, 0x4a, 0x62, 0x33, 0x65, 0xb5, 0x85, 0xd3, 0xdf,
	0x17, 0x20, 0x11, 0xde, 0xe2, 0x7b, 0x70, 0x99, 0xc4, 0xd4, 0xa1, 0xbb, 0xa0, 0x84, 0x7b, 0x56,
	0x21, 0x7a, 0x3d, 0xd8, 0x6f, 0x3b, 0x49, 0x3d, 0x68, 0xf5, 0xa1, 0x93, 0x7a, 0x20, 0x38, 0x92,
	0x3f, 0x14, 0x60, 0x26, 0xfc, 0xe0, 0x81, 0x5e, 0x03, 0x08, 0x9e, 0xf5, 0x98, 0x2d, 0x37, 0x23,
	0x1f, 0x9f, 0x8a, 0x2f, 0x42, 0x0a, 0x89, 0x23, 0x2d, 0x5b, 0x30, 0x52, 0x6a, 0x27, 0x2e, 0x76,
	0xd8, 0xa9, 0x9e, 0x0f, 0xe8, 0xab, 0x84, 0x2c, 0xbe, 0x0e, 0x20, 0xd7, 0x55, 0x23, 0xef, 0x5d,
	0xe0, 0xfd, 0x9a, 0xc5, 0x25, 0x52, 0x6a, 0x04, 0xad, 0x1f, 0x7b, 0x53, 0x0b, 0x91, 0xc8, 0xb5,
	0x8f, 0x0d, 0xb2, 0x03, 0x1e, 0x40, 0xc4, 0x24, 0x3e, 0x14, 0x97, 0x61, 0x71, 0x1d, 0xbb, 0xc1,
	0xab, 0x9d, 0x84, 0xbf, 0xd4, 0xc6, 0x8e, 0xdb, 0x4f, 0x8f, 0xf8, 0x2f, 0x01, 0x2e, 0x6f, 0x69,
	0x4e, 0x88, 0xdb, 0x39, 0x83, 0x9d, 0xd4, 0x20, 0x96, 0x6a, 0x63, 0xc3, 0x65, 0xa5, 0x06, 0x1b,
	0x11, 0xfa, 0x81, 0xa6, 0xbb, 0xd8, 0x66, 0x96, 0xb2, 0x11, 0xba, 0x0a, 0x71, 0x4b, 0x6d, 0x62,
	0xc5, 0xd1, 0xee, 0x7b, 0x47, 0x79, 0x52, 0x8a, 0x11, 0x82, 0xac, 0xdd, 0xf7, 0xe0, 0x91, 0x4c,
	0xba, 0xe6, 0x11, 0xe6, 0xdd, 0x2d, 0x65, 0xaf, 0x12, 0xc2, 0x03, 0x7c, 0xc5, 0x13, 0x7f, 0x24,
	0xc0, 0x95, 0x1e, 0x2f, 0x1d, 0xcb, 0x34, 0x1c, 0xd2, 0x6b, 0x25, 0xcc, 0x80, 0x4c, 0x8b, 0xc4,
	0x88, 0xcd, 0x56, 0x28, 0xd2, 0x61, 0x51, 0xe8, 0x93, 0x30, 0x6f, 0xe0, 0x7b, 0xae, 0x12, 0x72,
	0xd2, 0x8b, 0xce, 0x2c, 0x21, 0x57, 0xb8, 0xa3, 0xe2, 0xb3, 0x70, 0xa5, 0x80, 0x75, 0xec, 0xe2,
	0xc1, 0xb6, 0xec, 0x27, 0x02, 0x5c, 0xc9, 0xd3, 0x0e, 0x61, 0x20, 0xfe, 0xd0, 0x9e, 0x8d, 0x77,
	0xec, 0xd9, 0x1e, 0x40, 0x60, 0x2d, 0xbb, 0x0b, 0x87, 0xf5, 0x3b, 0x24, 0x49, 0xfc, 0xbd, 0x00,
	0x57, 0x76, 0x69, 0x13, 0x32, 0x98, 0x7d, 0x1f, 0x91, 0x1d, 0xa1, 0xd6, 0xa9, 0xa5, 0x3a, 0x47,
	0xa7, 0x96, 0xdb, 0x6b, 0x1a, 0xd6, 0x1b, 0xdb, 0xaa, 0x73, 0xc4, 0x5b, 0x27, 0xf2, 0x2d, 0x7e,
	0x02, 0xe6, 0xd6, 0xb1, 0x4b, 0xf2, 0xe8, 0xac, 0xad, 0xc8, 0x40, 0xaa, 0xe3, 0xa4, 0x9d, 0xc7,
	0xff, 0x5d, 0x01, 0x92, 0x24, 0x0f, 0x09, 0xdf, 0xc7, 0xe5, 0x9c, 0x89, 0x6f, 0x09, 0xb0, 0x10,
	0x32, 0x8a, 0x1d, 0x8b, 0x35, 0x98, 0x24, 0x8d, 0x15, 0x3f, 0x10, 0xcf, 0x45, 0x3d, 0x7e, 0x92,
	0xb7, 0x7c, 0xe0, 0x43, 0xf0, 0x14, 0x2c, 0x78, 0x87, 0xe0, 0xbc, 0x18, 0xfe, 0x54, 0x80, 0x05,
	0x2f, 0xfd, 0xcf, 0xe1, 0x0c, 0x05, 0x71, 0xa2, 0x23, 0x88, 0x57, 0x60, 0x9a, 0xf6, 0x8c, 0xfc,
	0xba, 0x97, 0xa6, 0xc8, 0xb0, 0xd4, 0x40, 0x05, 0x98, 0x20, 0x5f, 0xc3, 0xbc, 0x05, 0x52, 0x5b,
	0xe8, 0x6a, 0xd2, 0x3f, 0x2f, 0x78, 0xf9, 0x7f, 0x9e, 0x81, 0x5c, 0xdf, 0xd8, 0x28, 0xfa, 0x46,
	0xcb, 0xf3, 0xb7, 0x05, 0x48, 0xf3, 0xcd, 0x1f, 0xfc, 0x0e, 0x78, 0xe0, 0x39, 0xf8, 0xbe, 0x00,
	0x57, 0xfb, 0x9a, 0xf1, 0xb1, 0x01, 0xe9, 0xf7, 0x04, 0xb8, 0xcc, 0x50, 0xd7, 0x6f, 0xf2, 0x58,
	0x90, 0x82, 0x3c, 0x13, 0x3a, 0xf2, 0xec, 0x71, 0x98, 0xf1, 0xbb, 0xc0, 0x20, 0xd9, 0x12, 0x3e,
	0xad, 0xd4, 0xd5, 0x58, 0x8e, 0x47, 0x6b, 0x2c, 0xc5, 0x0f, 0x05, 0xb8, 0xcc, 0x80, 0xb6, 0xdb,
	0xa4, 0x7e, 0xfb, 0x36, 0x8a, 0xae, 0xee, 0x24, 0x9b, 0x88, 0x94, 0x64, 0xdf, 0x14, 0x60, 0xc1,
	0x97, 0xba, 0x8d, 0x5d, 0xb5, 0xa1, 0xba, 0x6a, 0xf7, 0xbb, 0x98, 0x10, 0xe9, 0x5d, 0xec, 0x45,
	0x88, 0x61, 0xa3, 0x31, 0xe8, 0x3b, 0xcc, 0x34, 0x36, 0x1a, 0x64, 0x24, 0xca, 0xf0, 0xf8, 0x3a,
	0x76, 0xf7, 0xda, 0xba, 0x71, 0x3f, 0x94, 0x66, 0x72, 0xbb, 0xd5, 0x52, 0xed, 0x93, 0xf3, 0xf6,
	0xf3, 0x94, 0xc4, 0x17, 0x3f, 0x1c, 0x03, 0xf1, 0x2c, 0xa9, 0x2c, 0x87, 0x5d, 0x98, 0xaa, 0x9b,
	0x6d, 0xc3, 0xe5, 0xe9, 0xfb, 0x7a, 0x94, 0xf4, 0x3d, 0x5f, 0x7e, 0x46, 0xc6, 0xc7, 0x98, 0x54,
	0xf0, 0x79, 0xa2, 0x44, 0x62, 0xba, 0xd2, 0xef, 0x08, 0x30, 0xdb, 0x31, 0x83, 0x6a, 0x10, 0x73,
	0x18, 0x81, 0x3d, 0x99, 0xac, 0x8d, 0xf6, 0x47, 0x4c, 0x2e, 0x5e, 0xf2, 0xe5, 0xa2, 0x45, 0x98,
	0xa4, 0xfa, 0x69, 0xa4, 0xc6, 0x25, 0x6f, 0xc0, 0x0a, 0xd3, 0xa0, 0xf2, 0x3d, 0x0b, 0xe6, 0xdf,
	0x66, 0x85, 0x69, 0xc0, 0xed, 0x0c, 0xb9, 0x3f, 0x23, 0x01, 0xd3, 0x8f, 0x59, 0xe5, 0xd8, 0x61,
	0x06, 0xdb, 0xd0, 0x7d, 0x98, 0x71, 0xea, 0xaa, 0xa1, 0x78, 0xef, 0x70, 0x43, 0xa1, 0x52, 0x28,
	0x16, 0x09, 0x27, 0x50, 0x31, 0x30, 0x2a, 0xfd, 0xc1, 0xaf, 0xb5, 0x06, 0x8a, 0x2a, 0xfa, 0x3c,
	0x24, 0x42, 0x26, 0x0f, 0x53, 0x6c, 0x85, 0xf4, 0x40, 0x60, 0xf1, 0x48, 0x97, 0xd0, 0xca, 0x9f,
	0x96, 0x60, 0x21, 0xcf, 0x55, 0xf2, 0x87, 0x26, 0xf4, 0x5b, 0x01, 0x66, 0x3b, 0xaa, 0x2b, 0x74,
	0x27, 0xe2, 0x89, 0xe9, 0xa9, 0x3f, 0xd3, 0x43, 0x5e, 0x19, 0xe2, 0xf5, 0xaf, 0xfd, 0xfd, 0xdf,
	0xdf, 0x1b, 0x7b, 0x06, 0x3d, 0x1d, 0xfc, 0x3e, 0xe4, 0x2b, 0x24, 0xa0, 0xb7, 0x2c, 0xdb, 0xfc,
	0x22, 0xae, 0xbb, 0x4e, 0x76, 0x39, 0x1b, 0xba, 0x55, 0xb2, 0xcb, 0x6f, 0xa2, 0xbf, 0x08, 0x30,
	0xdf, 0xd5, 0x73, 0xa0, 0x48, 0x4f, 0x35, 0xfd, 0xdb, 0xb2, 0x74, 0x7e, 0x24, 0x19, 0x5e, 0xea,
	0xf6, 0xf5, 0xc7, 0x3b, 0x45, 0x21, 0x8f, 0xde, 0x0c, 0xbb, 0x84, 0x3e, 0x10, 0x20, 0xd9, 0xdd,
	0xa6, 0xa0, 0x7c, 0xb4, 0xc7, 0xe2, 0xbe, 0x4d, 0x4e, 0xfa, 0x72, 0x4f, 0x9a, 0x14, 0x5b, 0x96,
	0x7b, 0xc2, 0x8d, 0x5c, 0x8e, 0x10, 0xf4, 0xbf, 0x0a, 0x90, 0xec, 0xee, 0x8d, 0xa2, 0x19, 0x79,
	0x4a, 0x67, 0x35, 0x74, 0xe6, 0xdc, 0xa2, 0x4e, 0xbc, 0x24, 0x0e, 0x1e, 0xe9, 0x1b, 0xe1, 0x26,
	0x86, 0x38, 0xd4, 0xdd, 0x4c, 0x45, 0x73, 0xe8, 0x94, 0x56, 0x6c, 0x54, 0x87, 0x56, 0x06, 0xdf,
	0x95, 0x0e, 0x87, 0xfe, 0x28, 0xc0, 0x42, 0x4f, 0xcf, 0x84, 0x0a, 0x43, 0x9f, 0xec, 0x50, 0x8d,
	0x9d, 0x8e, 0x5c, 0x41, 0x8b, 0x2f, 0x51, 0x67, 0xae, 0xa3, 0xec, 0xc0, 0xce, 0x64, 0xbd, 0xb6,
	0xe6, 0xe7, 0x02, 0x4c, 0xb3, 0x06, 0x11, 0xdd, 0x88, 0x68, 0xfc, 0x68, 0x26, 0x3f, 0x43, 0x4d,
	0x7e, 0x12, 0x3d, 0x71, 0x86, 0xc9, 0xd4, 0x46, 0x72, 0x1e, 0x7e, 0x23, 0x40, 0xdc, 0xef, 0xed,
	0xd0, 0xcb, 0x51, 0xa1, 0x23, 0xdc, 0xa7, 0xa6, 0x6f, 0x0d, 0xb9, 0x9a, 0x41, 0x4e, 0x3f, 0xbb,
	0xfb, 0x1c, 0x04, 0x2f, 0xbc, 0xef, 0x09, 0x00, 0x41, 0x3b, 0x88, 0x6e, 0x45, 0x87, 0x99, 0x70,
	0x90, 0x4f, 0x03, 0x18, 0x66, 0xd2, 0xf2, 0x40, 0xa1, 0xfc, 0xb5, 0x00, 0x10, 0xf4, 0x9d, 0xd1,
	0x4c, 0xea, 0xe9, 0x57, 0x87, 0xd8, 0x77, 0x86, 0x86, 0xe2, 0x20, 0xf1, 0xbb, 0xe1, 0x75, 0x86,
	0xc4, 0xe4, 0xa0, 0x13, 0x8d, 0x66, 0x72, 0x4f, 0x07, 0x3b, 0xbc, 0xc9, 0x2b, 0x83, 0xc4, 0x97,
	0x99, 0xfc, 0x4f, 0x01, 0x2e, 0xf6, 0x69, 0x04, 0xd1, 0xda, 0x30, 0xc9, 0xd7, 0xe7, 0xf6, 0x5c,
	0x1f, 0x59, 0x0e, 0x4b, 0xe7, 0x41, 0x90, 0x83, 0xfb, 0xd6, 0x71, 0x8f, 0xbe, 0x35, 0x06, 0xe9,
	0xd3, 0xab, 0x79, 0xb4, 0xfd, 0xa0, 0xba, 0x02, 0xcf, 0xdf, 0xf2, 0x83, 0x6d, 0x32, 0xc4, 0x35,
	0xea, 0xf6, 0x1d, 0xf4, 0xb9, 0xc1, 0xaf, 0xb3, 0x8e, 0x9f, 0xfd, 0x70, 0x37, 0xff, 0x2c, 0xc0,
	0x8c, 0x8c, 0xdd, 0x92, 0xda, 0xaa, 0xd0, 0xdf, 0xc9, 0x22, 0x91, 0x1b, 0xaa, 0xa9, 0xad, 0xcc,
	0xf1, 0xf5, 0x4c, 0x78, 0x92, 0x3b, 0x73, 0xa9, 0x8b, 0xc7, 0x9b, 0x15, 0xbf, 0x2a, 0x50, 0xa3,
	0xee, 0x8b, 0x2f, 0x84, 0x8c, 0xe2, 0x7f, 0xe4, 0xee, 0x9b, 0x6b, 0x4e, 0x48, 0xf8, 0x0d, 0x61,
	0xf9, 0xd5, 0xdb, 0xe2, 0x8d, 0x73, 0x96, 0x76, 0xdd, 0x68, 0x5d, 0x02, 0xa8, 0x3b, 0xeb, 0x67,
	0xb9, 0xb3, 0xfe, 0x51, 0xba, 0xd3, 0x1c, 0xd5, 0x9d, 0x2e, 0x01, 0xe8, 0xbf, 0x02, 0xa0, 0x2a,
	0x76, 0x28, 0x11, 0xdb, 0x2d, 0xcd, 0x71, 0x34, 0xd3, 0x70, 0xd0, 0xb5, 0x2e, 0x83, 0x7b, 0x59,
	0xb8, 0x6b, 0x4f, 0x0f, 0xc0, 0xc9, 0x32, 0xea, 0x5d, 0xcf, 0xdd, 0x6f, 0x08, 0xe7, 0x1a, 0xed,
	0xfb, 0xeb, 0xf6, 0x48, 0x23, 0x5e, 0x17, 0xc5, 0x3b, 0xd1, 0xbc, 0xee, 0x2b, 0x06, 0xfd, 0x42,
	0x80, 0xf9, 0xae, 0x87, 0x9e, 0x68, 0x75, 0x7b, 0xff, 0x57, 0xa2, 0xf4, 0xd9, 0x6f, 0x2d, 0xe2,
	0xf3, 0x34, 0x0a, 0xcf, 0x8a, 0xd7, 0xce, 0x39, 0x58, 0xfe, 0x8f, 0xc6, 0xb9, 0xad, 0x5d, 0x2f,
	0x40, 0xd1, 0x6c, 0xed, 0xff, 0x7c, 0x34, 0xa0, 0xad, 0x2b, 0xd7, 0xce, 0xaa, 0x9a, 0x7c, 0x43,
	0x49, 0xa8, 0x85, 0x65, 0xf4, 0x3b, 0xaf, 0x9d, 0x0b, 0xfd, 0xdd, 0x2b, 0x6a, 0x3b, 0xd7, 0xd3,
	0xe2, 0xa6, 0x87, 0xec, 0x5c, 0xc5, 0x15, 0xea, 0xc0, 0xa7, 0xd0, 0xf2, 0x19, 0x0e, 0x84, 0x5b,
	0x7b, 0xd6, 0x5a, 0xcc, 0x77, 0xbd, 0x04, 0x44, 0xef, 0xe7, 0x7a, 0x5f, 0x33, 0xa2, 0xf7, 0x73,
	0x7d, 0x9e, 0x22, 0xfa, 0x3a, 0xd4, 0x27, 0x7b, 0xc2, 0x3e, 0xa1, 0xbf, 0xf9, 0xad, 0x45, 0x68,
	0x4f, 0x86, 0x68, 0x2d, 0x1e, 0xdc, 0xb6, 0xdc, 0xa6, 0x5e, 0x7c, 0x76, 0x25, 0xc2, 0xb6, 0xdc,
	0x08, 0xbf, 0x67, 0xac, 0x7e, 0x4b, 0x80, 0x27, 0xeb, 0x66, 0x8b, 0xab, 0x3f, 0x5d, 0x6b, 0x45,
	0x78, 0xf5, 0x35, 0xc6, 0xd4, 0x34, 0x75, 0xd5, 0x68, 0x66, 0x4c, 0xbb, 0x99, 0x6d, 0x62, 0x83,
	0x56, 0x88, 0x59, 0x6f, 0x4a, 0xb5, 0x34, 0x67, 0x90, 0xff, 0x2a, 0x72, 0xb3, 0x67, 0xea, 0x83,
	0xb1, 0xf1, 0xf5, 0x7c, 0xae, 0x36, 0x45, 0xa5, 0x3d, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xb3, 0xe0, 0xe0, 0x39, 0xcf, 0x33, 0x00, 0x00,
}
