﻿# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# --------------------------------------------------------------------------------------------
# Generated file, DO NOT EDIT
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------------------------

from msrest.serialization import Model


class AcquisitionOperation(Model):
    """
    :param operation_state: State of the AcquisitionOperation for the current user
    :type operation_state: object
    :param operation_type: AcquisitionOperationType: install, request, buy, etc...
    :type operation_type: object
    :param reason: Optional reason to justify current state. Typically used with Disallow state.
    :type reason: str
    """

    _attribute_map = {
        'operation_state': {'key': 'operationState', 'type': 'object'},
        'operation_type': {'key': 'operationType', 'type': 'object'},
        'reason': {'key': 'reason', 'type': 'str'}
    }

    def __init__(self, operation_state=None, operation_type=None, reason=None):
        super(AcquisitionOperation, self).__init__()
        self.operation_state = operation_state
        self.operation_type = operation_type
        self.reason = reason


class AcquisitionOptions(Model):
    """
    Market item acquisition options (install, buy, etc) for an installation target.

    :param default_operation: Default Operation for the ItemId in this target
    :type default_operation: :class:`AcquisitionOperation <azure.devops.v7_1.gallery.models.AcquisitionOperation>`
    :param item_id: The item id that this options refer to
    :type item_id: str
    :param operations: Operations allowed for the ItemId in this target
    :type operations: list of :class:`AcquisitionOperation <azure.devops.v7_1.gallery.models.AcquisitionOperation>`
    :param target: The target that this options refer to
    :type target: str
    """

    _attribute_map = {
        'default_operation': {'key': 'defaultOperation', 'type': 'AcquisitionOperation'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'operations': {'key': 'operations', 'type': '[AcquisitionOperation]'},
        'target': {'key': 'target', 'type': 'str'}
    }

    def __init__(self, default_operation=None, item_id=None, operations=None, target=None):
        super(AcquisitionOptions, self).__init__()
        self.default_operation = default_operation
        self.item_id = item_id
        self.operations = operations
        self.target = target


class Answers(Model):
    """
    :param vs_marketplace_extension_name: Gets or sets the vs marketplace extension name
    :type vs_marketplace_extension_name: str
    :param vs_marketplace_publisher_name: Gets or sets the vs marketplace publisher name
    :type vs_marketplace_publisher_name: str
    """

    _attribute_map = {
        'vs_marketplace_extension_name': {'key': 'vsMarketplaceExtensionName', 'type': 'str'},
        'vs_marketplace_publisher_name': {'key': 'vsMarketplacePublisherName', 'type': 'str'}
    }

    def __init__(self, vs_marketplace_extension_name=None, vs_marketplace_publisher_name=None):
        super(Answers, self).__init__()
        self.vs_marketplace_extension_name = vs_marketplace_extension_name
        self.vs_marketplace_publisher_name = vs_marketplace_publisher_name


class AssetDetails(Model):
    """
    :param answers: Gets or sets the Answers, which contains vs marketplace extension name and publisher name
    :type answers: :class:`Answers <azure.devops.v7_1.gallery.models.Answers>`
    :param publisher_natural_identifier: Gets or sets the VS publisher Id
    :type publisher_natural_identifier: str
    """

    _attribute_map = {
        'answers': {'key': 'answers', 'type': 'Answers'},
        'publisher_natural_identifier': {'key': 'publisherNaturalIdentifier', 'type': 'str'}
    }

    def __init__(self, answers=None, publisher_natural_identifier=None):
        super(AssetDetails, self).__init__()
        self.answers = answers
        self.publisher_natural_identifier = publisher_natural_identifier


class AzurePublisher(Model):
    """
    :param azure_publisher_id:
    :type azure_publisher_id: str
    :param publisher_name:
    :type publisher_name: str
    """

    _attribute_map = {
        'azure_publisher_id': {'key': 'azurePublisherId', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'}
    }

    def __init__(self, azure_publisher_id=None, publisher_name=None):
        super(AzurePublisher, self).__init__()
        self.azure_publisher_id = azure_publisher_id
        self.publisher_name = publisher_name


class AzureRestApiRequestModel(Model):
    """
    :param asset_details: Gets or sets the Asset details
    :type asset_details: :class:`AssetDetails <azure.devops.v7_1.gallery.models.AssetDetails>`
    :param asset_id: Gets or sets the asset id
    :type asset_id: str
    :param asset_version: Gets or sets the asset version
    :type asset_version: long
    :param customer_support_email: Gets or sets the customer support email
    :type customer_support_email: str
    :param integration_contact_email: Gets or sets the integration contact email
    :type integration_contact_email: str
    :param operation: Gets or sets the asset version
    :type operation: str
    :param plan_id: Gets or sets the plan identifier if any.
    :type plan_id: str
    :param publisher_id: Gets or sets the publisher id
    :type publisher_id: str
    :param type: Gets or sets the resource type
    :type type: str
    """

    _attribute_map = {
        'asset_details': {'key': 'assetDetails', 'type': 'AssetDetails'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'asset_version': {'key': 'assetVersion', 'type': 'long'},
        'customer_support_email': {'key': 'customerSupportEmail', 'type': 'str'},
        'integration_contact_email': {'key': 'integrationContactEmail', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'plan_id': {'key': 'planId', 'type': 'str'},
        'publisher_id': {'key': 'publisherId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'}
    }

    def __init__(self, asset_details=None, asset_id=None, asset_version=None, customer_support_email=None, integration_contact_email=None, operation=None, plan_id=None, publisher_id=None, type=None):
        super(AzureRestApiRequestModel, self).__init__()
        self.asset_details = asset_details
        self.asset_id = asset_id
        self.asset_version = asset_version
        self.customer_support_email = customer_support_email
        self.integration_contact_email = integration_contact_email
        self.operation = operation
        self.plan_id = plan_id
        self.publisher_id = publisher_id
        self.type = type


class CategoriesResult(Model):
    """
    This is the set of categories in response to the get category query

    :param categories:
    :type categories: list of :class:`ExtensionCategory <azure.devops.v7_1.gallery.models.ExtensionCategory>`
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[ExtensionCategory]'}
    }

    def __init__(self, categories=None):
        super(CategoriesResult, self).__init__()
        self.categories = categories


class CategoryLanguageTitle(Model):
    """
    Definition of one title of a category

    :param lang: The language for which the title is applicable
    :type lang: str
    :param lcid: The language culture id of the lang parameter
    :type lcid: int
    :param title: Actual title to be shown on the UI
    :type title: str
    """

    _attribute_map = {
        'lang': {'key': 'lang', 'type': 'str'},
        'lcid': {'key': 'lcid', 'type': 'int'},
        'title': {'key': 'title', 'type': 'str'}
    }

    def __init__(self, lang=None, lcid=None, title=None):
        super(CategoryLanguageTitle, self).__init__()
        self.lang = lang
        self.lcid = lcid
        self.title = title


class CustomerSupportRequest(Model):
    """
    An entity representing the data required to create a Customer Support Request.

    :param display_name: Display name of extension in concern
    :type display_name: str
    :param email_id: Email of user making the support request
    :type email_id: str
    :param extension_name: Extension name
    :type extension_name: str
    :param extension_uRL: Link to the extension details page
    :type extension_uRL: str
    :param message: User-provided support request message.
    :type message: str
    :param publisher_name: Publisher name
    :type publisher_name: str
    :param reason: Reason for support request
    :type reason: str
    :param re_captcha_token:
    :type re_captcha_token: str
    :param reporter_vSID: VSID of the user making the support request
    :type reporter_vSID: str
    :param review: Review under concern
    :type review: :class:`Review <azure.devops.v7_1.gallery.models.Review>`
    :param source_link: The UI source through which the request was made
    :type source_link: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'email_id': {'key': 'emailId', 'type': 'str'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'extension_uRL': {'key': 'extensionURL', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        're_captcha_token': {'key': 'reCaptchaToken', 'type': 'str'},
        'reporter_vSID': {'key': 'reporterVSID', 'type': 'str'},
        'review': {'key': 'review', 'type': 'Review'},
        'source_link': {'key': 'sourceLink', 'type': 'str'}
    }

    def __init__(self, display_name=None, email_id=None, extension_name=None, extension_uRL=None, message=None, publisher_name=None, reason=None, re_captcha_token=None, reporter_vSID=None, review=None, source_link=None):
        super(CustomerSupportRequest, self).__init__()
        self.display_name = display_name
        self.email_id = email_id
        self.extension_name = extension_name
        self.extension_uRL = extension_uRL
        self.message = message
        self.publisher_name = publisher_name
        self.reason = reason
        self.re_captcha_token = re_captcha_token
        self.reporter_vSID = reporter_vSID
        self.review = review
        self.source_link = source_link


class EventCounts(Model):
    """
    :param average_rating: Average rating on the day for extension
    :type average_rating: float
    :param buy_count: Number of times the extension was bought in hosted scenario (applies only to VSTS extensions)
    :type buy_count: int
    :param connected_buy_count: Number of times the extension was bought in connected scenario (applies only to VSTS extensions)
    :type connected_buy_count: int
    :param connected_install_count: Number of times the extension was installed in connected scenario (applies only to VSTS extensions)
    :type connected_install_count: int
    :param install_count: Number of times the extension was installed
    :type install_count: long
    :param try_count: Number of times the extension was installed as a trial (applies only to VSTS extensions)
    :type try_count: int
    :param uninstall_count: Number of times the extension was uninstalled (applies only to VSTS extensions)
    :type uninstall_count: int
    :param web_download_count: Number of times the extension was downloaded (applies to VSTS extensions and VSCode marketplace click installs)
    :type web_download_count: long
    :param web_page_views: Number of detail page views
    :type web_page_views: long
    """

    _attribute_map = {
        'average_rating': {'key': 'averageRating', 'type': 'float'},
        'buy_count': {'key': 'buyCount', 'type': 'int'},
        'connected_buy_count': {'key': 'connectedBuyCount', 'type': 'int'},
        'connected_install_count': {'key': 'connectedInstallCount', 'type': 'int'},
        'install_count': {'key': 'installCount', 'type': 'long'},
        'try_count': {'key': 'tryCount', 'type': 'int'},
        'uninstall_count': {'key': 'uninstallCount', 'type': 'int'},
        'web_download_count': {'key': 'webDownloadCount', 'type': 'long'},
        'web_page_views': {'key': 'webPageViews', 'type': 'long'}
    }

    def __init__(self, average_rating=None, buy_count=None, connected_buy_count=None, connected_install_count=None, install_count=None, try_count=None, uninstall_count=None, web_download_count=None, web_page_views=None):
        super(EventCounts, self).__init__()
        self.average_rating = average_rating
        self.buy_count = buy_count
        self.connected_buy_count = connected_buy_count
        self.connected_install_count = connected_install_count
        self.install_count = install_count
        self.try_count = try_count
        self.uninstall_count = uninstall_count
        self.web_download_count = web_download_count
        self.web_page_views = web_page_views


class ExtensionAcquisitionRequest(Model):
    """
    Contract for handling the extension acquisition process

    :param assignment_type: How the item is being assigned
    :type assignment_type: object
    :param billing_id: The id of the subscription used for purchase
    :type billing_id: str
    :param item_id: The marketplace id (publisherName.extensionName) for the item
    :type item_id: str
    :param operation_type: The type of operation, such as install, request, purchase
    :type operation_type: object
    :param properties: Additional properties which can be added to the request.
    :type properties: :class:`object <azure.devops.v7_1.gallery.models.object>`
    :param quantity: How many licenses should be purchased
    :type quantity: int
    :param targets: A list of target guids where the item should be acquired (installed, requested, etc.), such as account id
    :type targets: list of str
    """

    _attribute_map = {
        'assignment_type': {'key': 'assignmentType', 'type': 'object'},
        'billing_id': {'key': 'billingId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'object'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'targets': {'key': 'targets', 'type': '[str]'}
    }

    def __init__(self, assignment_type=None, billing_id=None, item_id=None, operation_type=None, properties=None, quantity=None, targets=None):
        super(ExtensionAcquisitionRequest, self).__init__()
        self.assignment_type = assignment_type
        self.billing_id = billing_id
        self.item_id = item_id
        self.operation_type = operation_type
        self.properties = properties
        self.quantity = quantity
        self.targets = targets


class ExtensionBadge(Model):
    """
    :param description:
    :type description: str
    :param img_uri:
    :type img_uri: str
    :param link:
    :type link: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'img_uri': {'key': 'imgUri', 'type': 'str'},
        'link': {'key': 'link', 'type': 'str'}
    }

    def __init__(self, description=None, img_uri=None, link=None):
        super(ExtensionBadge, self).__init__()
        self.description = description
        self.img_uri = img_uri
        self.link = link


class ExtensionCategory(Model):
    """
    :param associated_products: The name of the products with which this category is associated to.
    :type associated_products: list of str
    :param category_id:
    :type category_id: int
    :param category_name: This is the internal name for a category
    :type category_name: str
    :param language: This parameter is obsolete. Refer to LanguageTitles for language specific titles
    :type language: str
    :param language_titles: The list of all the titles of this category in various languages
    :type language_titles: list of :class:`CategoryLanguageTitle <azure.devops.v7_1.gallery.models.CategoryLanguageTitle>`
    :param parent_category_name: This is the internal name of the parent if this is associated with a parent
    :type parent_category_name: str
    """

    _attribute_map = {
        'associated_products': {'key': 'associatedProducts', 'type': '[str]'},
        'category_id': {'key': 'categoryId', 'type': 'int'},
        'category_name': {'key': 'categoryName', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
        'language_titles': {'key': 'languageTitles', 'type': '[CategoryLanguageTitle]'},
        'parent_category_name': {'key': 'parentCategoryName', 'type': 'str'}
    }

    def __init__(self, associated_products=None, category_id=None, category_name=None, language=None, language_titles=None, parent_category_name=None):
        super(ExtensionCategory, self).__init__()
        self.associated_products = associated_products
        self.category_id = category_id
        self.category_name = category_name
        self.language = language
        self.language_titles = language_titles
        self.parent_category_name = parent_category_name


class ExtensionDailyStat(Model):
    """
    :param counts: Stores the event counts
    :type counts: :class:`EventCounts <azure.devops.v7_1.gallery.models.EventCounts>`
    :param extended_stats: Generic key/value pair to store extended statistics. Used for sending paid extension stats like Upgrade, Downgrade, Cancel trend etc.
    :type extended_stats: dict
    :param statistic_date: Timestamp of this data point
    :type statistic_date: datetime
    :param version: Version of the extension
    :type version: str
    """

    _attribute_map = {
        'counts': {'key': 'counts', 'type': 'EventCounts'},
        'extended_stats': {'key': 'extendedStats', 'type': '{object}'},
        'statistic_date': {'key': 'statisticDate', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'str'}
    }

    def __init__(self, counts=None, extended_stats=None, statistic_date=None, version=None):
        super(ExtensionDailyStat, self).__init__()
        self.counts = counts
        self.extended_stats = extended_stats
        self.statistic_date = statistic_date
        self.version = version


class ExtensionDailyStats(Model):
    """
    :param daily_stats: List of extension statistics data points
    :type daily_stats: list of :class:`ExtensionDailyStat <azure.devops.v7_1.gallery.models.ExtensionDailyStat>`
    :param extension_id: Id of the extension, this will never be sent back to the client. For internal use only.
    :type extension_id: str
    :param extension_name: Name of the extension
    :type extension_name: str
    :param publisher_name: Name of the publisher
    :type publisher_name: str
    :param stat_count: Count of stats
    :type stat_count: int
    """

    _attribute_map = {
        'daily_stats': {'key': 'dailyStats', 'type': '[ExtensionDailyStat]'},
        'extension_id': {'key': 'extensionId', 'type': 'str'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'stat_count': {'key': 'statCount', 'type': 'int'}
    }

    def __init__(self, daily_stats=None, extension_id=None, extension_name=None, publisher_name=None, stat_count=None):
        super(ExtensionDailyStats, self).__init__()
        self.daily_stats = daily_stats
        self.extension_id = extension_id
        self.extension_name = extension_name
        self.publisher_name = publisher_name
        self.stat_count = stat_count


class ExtensionDraft(Model):
    """
    :param assets:
    :type assets: list of :class:`ExtensionDraftAsset <azure.devops.v7_1.gallery.models.ExtensionDraftAsset>`
    :param created_date:
    :type created_date: datetime
    :param draft_state:
    :type draft_state: object
    :param extension_name:
    :type extension_name: str
    :param id:
    :type id: str
    :param last_updated:
    :type last_updated: datetime
    :param payload:
    :type payload: :class:`ExtensionPayload <azure.devops.v7_1.gallery.models.ExtensionPayload>`
    :param product:
    :type product: str
    :param publisher_name:
    :type publisher_name: str
    :param validation_errors:
    :type validation_errors: list of { key: str; value: str }
    :param validation_warnings:
    :type validation_warnings: list of { key: str; value: str }
    """

    _attribute_map = {
        'assets': {'key': 'assets', 'type': '[ExtensionDraftAsset]'},
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'draft_state': {'key': 'draftState', 'type': 'object'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'payload': {'key': 'payload', 'type': 'ExtensionPayload'},
        'product': {'key': 'product', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[{ key: str; value: str }]'},
        'validation_warnings': {'key': 'validationWarnings', 'type': '[{ key: str; value: str }]'}
    }

    def __init__(self, assets=None, created_date=None, draft_state=None, extension_name=None, id=None, last_updated=None, payload=None, product=None, publisher_name=None, validation_errors=None, validation_warnings=None):
        super(ExtensionDraft, self).__init__()
        self.assets = assets
        self.created_date = created_date
        self.draft_state = draft_state
        self.extension_name = extension_name
        self.id = id
        self.last_updated = last_updated
        self.payload = payload
        self.product = product
        self.publisher_name = publisher_name
        self.validation_errors = validation_errors
        self.validation_warnings = validation_warnings


class ExtensionDraftPatch(Model):
    """
    :param extension_data:
    :type extension_data: :class:`UnpackagedExtensionData <azure.devops.v7_1.gallery.models.UnpackagedExtensionData>`
    :param operation:
    :type operation: object
    :param re_captcha_token:
    :type re_captcha_token: str
    """

    _attribute_map = {
        'extension_data': {'key': 'extensionData', 'type': 'UnpackagedExtensionData'},
        'operation': {'key': 'operation', 'type': 'object'},
        're_captcha_token': {'key': 'reCaptchaToken', 'type': 'str'}
    }

    def __init__(self, extension_data=None, operation=None, re_captcha_token=None):
        super(ExtensionDraftPatch, self).__init__()
        self.extension_data = extension_data
        self.operation = operation
        self.re_captcha_token = re_captcha_token


class ExtensionEvent(Model):
    """
    Stores details of each event

    :param id: Id which identifies each data point uniquely
    :type id: long
    :param properties:
    :type properties: :class:`object <azure.devops.v7_1.gallery.models.object>`
    :param statistic_date: Timestamp of when the event occurred
    :type statistic_date: datetime
    :param version: Version of the extension
    :type version: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'properties': {'key': 'properties', 'type': 'object'},
        'statistic_date': {'key': 'statisticDate', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'str'}
    }

    def __init__(self, id=None, properties=None, statistic_date=None, version=None):
        super(ExtensionEvent, self).__init__()
        self.id = id
        self.properties = properties
        self.statistic_date = statistic_date
        self.version = version


class ExtensionEvents(Model):
    """
    Container object for all extension events. Stores all install and uninstall events related to an extension. The events container is generic so can store data of any type of event. New event types can be added without altering the contract.

    :param events: Generic container for events data. The dictionary key denotes the type of event and the list contains properties related to that event
    :type events: dict
    :param extension_id: Id of the extension, this will never be sent back to the client. This field will mainly be used when EMS calls into Gallery REST API to update install/uninstall events for various extensions in one go.
    :type extension_id: str
    :param extension_name: Name of the extension
    :type extension_name: str
    :param publisher_name: Name of the publisher
    :type publisher_name: str
    """

    _attribute_map = {
        'events': {'key': 'events', 'type': '{[ExtensionEvent]}'},
        'extension_id': {'key': 'extensionId', 'type': 'str'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'}
    }

    def __init__(self, events=None, extension_id=None, extension_name=None, publisher_name=None):
        super(ExtensionEvents, self).__init__()
        self.events = events
        self.extension_id = extension_id
        self.extension_name = extension_name
        self.publisher_name = publisher_name


class ExtensionFile(Model):
    """
    :param asset_type:
    :type asset_type: str
    :param language:
    :type language: str
    :param source:
    :type source: str
    """

    _attribute_map = {
        'asset_type': {'key': 'assetType', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'}
    }

    def __init__(self, asset_type=None, language=None, source=None):
        super(ExtensionFile, self).__init__()
        self.asset_type = asset_type
        self.language = language
        self.source = source


class ExtensionFilterResult(Model):
    """
    The FilterResult is the set of extensions that matched a particular query filter.

    :param extensions: This is the set of applications that matched the query filter supplied.
    :type extensions: list of :class:`PublishedExtension <azure.devops.v7_1.gallery.models.PublishedExtension>`
    :param paging_token: The PagingToken is returned from a request when more records exist that match the result than were requested or could be returned. A follow-up query with this paging token can be used to retrieve more results.
    :type paging_token: str
    :param result_metadata: This is the additional optional metadata for the given result. E.g. Total count of results which is useful in case of paged results
    :type result_metadata: list of :class:`ExtensionFilterResultMetadata <azure.devops.v7_1.gallery.models.ExtensionFilterResultMetadata>`
    """

    _attribute_map = {
        'extensions': {'key': 'extensions', 'type': '[PublishedExtension]'},
        'paging_token': {'key': 'pagingToken', 'type': 'str'},
        'result_metadata': {'key': 'resultMetadata', 'type': '[ExtensionFilterResultMetadata]'}
    }

    def __init__(self, extensions=None, paging_token=None, result_metadata=None):
        super(ExtensionFilterResult, self).__init__()
        self.extensions = extensions
        self.paging_token = paging_token
        self.result_metadata = result_metadata


class ExtensionFilterResultMetadata(Model):
    """
    ExtensionFilterResultMetadata is one set of metadata for the result e.g. Total count. There can be multiple metadata items for one metadata.

    :param metadata_items: The metadata items for the category
    :type metadata_items: list of :class:`MetadataItem <azure.devops.v7_1.gallery.models.MetadataItem>`
    :param metadata_type: Defines the category of metadata items
    :type metadata_type: str
    """

    _attribute_map = {
        'metadata_items': {'key': 'metadataItems', 'type': '[MetadataItem]'},
        'metadata_type': {'key': 'metadataType', 'type': 'str'}
    }

    def __init__(self, metadata_items=None, metadata_type=None):
        super(ExtensionFilterResultMetadata, self).__init__()
        self.metadata_items = metadata_items
        self.metadata_type = metadata_type


class ExtensionPackage(Model):
    """
    Package that will be used to create or update a published extension

    :param extension_manifest: Base 64 encoded extension package
    :type extension_manifest: str
    """

    _attribute_map = {
        'extension_manifest': {'key': 'extensionManifest', 'type': 'str'}
    }

    def __init__(self, extension_manifest=None):
        super(ExtensionPackage, self).__init__()
        self.extension_manifest = extension_manifest


class ExtensionPayload(Model):
    """
    :param description:
    :type description: str
    :param display_name:
    :type display_name: str
    :param file_name:
    :type file_name: str
    :param installation_targets:
    :type installation_targets: list of :class:`InstallationTarget <azure.devops.v7_1.gallery.models.InstallationTarget>`
    :param is_preview:
    :type is_preview: bool
    :param is_signed_by_microsoft:
    :type is_signed_by_microsoft: bool
    :param is_valid:
    :type is_valid: bool
    :param metadata:
    :type metadata: list of { key: str; value: str }
    :param type:
    :type type: object
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'file_name': {'key': 'fileName', 'type': 'str'},
        'installation_targets': {'key': 'installationTargets', 'type': '[InstallationTarget]'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_signed_by_microsoft': {'key': 'isSignedByMicrosoft', 'type': 'bool'},
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'metadata': {'key': 'metadata', 'type': '[{ key: str; value: str }]'},
        'type': {'key': 'type', 'type': 'object'}
    }

    def __init__(self, description=None, display_name=None, file_name=None, installation_targets=None, is_preview=None, is_signed_by_microsoft=None, is_valid=None, metadata=None, type=None):
        super(ExtensionPayload, self).__init__()
        self.description = description
        self.display_name = display_name
        self.file_name = file_name
        self.installation_targets = installation_targets
        self.is_preview = is_preview
        self.is_signed_by_microsoft = is_signed_by_microsoft
        self.is_valid = is_valid
        self.metadata = metadata
        self.type = type


class ExtensionQuery(Model):
    """
    An ExtensionQuery is used to search the gallery for a set of extensions that match one of many filter values.

    :param asset_types: When retrieving extensions with a query; frequently the caller only needs a small subset of the assets. The caller may specify a list of asset types that should be returned if the extension contains it. All other assets will not be returned.
    :type asset_types: list of str
    :param filters: Each filter is a unique query and will have matching set of extensions returned from the request. Each result will have the same index in the resulting array that the filter had in the incoming query.
    :type filters: list of :class:`QueryFilter <azure.devops.v7_1.gallery.models.QueryFilter>`
    :param flags: The Flags are used to determine which set of information the caller would like returned for the matched extensions.
    :type flags: object
    """

    _attribute_map = {
        'asset_types': {'key': 'assetTypes', 'type': '[str]'},
        'filters': {'key': 'filters', 'type': '[QueryFilter]'},
        'flags': {'key': 'flags', 'type': 'object'}
    }

    def __init__(self, asset_types=None, filters=None, flags=None):
        super(ExtensionQuery, self).__init__()
        self.asset_types = asset_types
        self.filters = filters
        self.flags = flags


class ExtensionQueryResult(Model):
    """
    This is the set of extensions that matched a supplied query through the filters given.

    :param results: For each filter supplied in the query, a filter result will be returned in the query result.
    :type results: list of :class:`ExtensionFilterResult <azure.devops.v7_1.gallery.models.ExtensionFilterResult>`
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': '[ExtensionFilterResult]'}
    }

    def __init__(self, results=None):
        super(ExtensionQueryResult, self).__init__()
        self.results = results


class ExtensionShare(Model):
    """
    :param id:
    :type id: str
    :param is_org:
    :type is_org: bool
    :param name:
    :type name: str
    :param type:
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'is_org': {'key': 'isOrg', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'}
    }

    def __init__(self, id=None, is_org=None, name=None, type=None):
        super(ExtensionShare, self).__init__()
        self.id = id
        self.is_org = is_org
        self.name = name
        self.type = type


class ExtensionStatistic(Model):
    """
    :param statistic_name:
    :type statistic_name: str
    :param value:
    :type value: float
    """

    _attribute_map = {
        'statistic_name': {'key': 'statisticName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'}
    }

    def __init__(self, statistic_name=None, value=None):
        super(ExtensionStatistic, self).__init__()
        self.statistic_name = statistic_name
        self.value = value


class ExtensionStatisticUpdate(Model):
    """
    :param extension_name:
    :type extension_name: str
    :param operation:
    :type operation: object
    :param publisher_name:
    :type publisher_name: str
    :param statistic:
    :type statistic: :class:`ExtensionStatistic <azure.devops.v7_1.gallery.models.ExtensionStatistic>`
    """

    _attribute_map = {
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'object'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'statistic': {'key': 'statistic', 'type': 'ExtensionStatistic'}
    }

    def __init__(self, extension_name=None, operation=None, publisher_name=None, statistic=None):
        super(ExtensionStatisticUpdate, self).__init__()
        self.extension_name = extension_name
        self.operation = operation
        self.publisher_name = publisher_name
        self.statistic = statistic


class ExtensionVersion(Model):
    """
    :param asset_uri:
    :type asset_uri: str
    :param badges:
    :type badges: list of :class:`ExtensionBadge <azure.devops.v7_1.gallery.models.ExtensionBadge>`
    :param fallback_asset_uri:
    :type fallback_asset_uri: str
    :param files:
    :type files: list of :class:`ExtensionFile <azure.devops.v7_1.gallery.models.ExtensionFile>`
    :param flags:
    :type flags: object
    :param last_updated:
    :type last_updated: datetime
    :param properties:
    :type properties: list of { key: str; value: str }
    :param target_platform:
    :type target_platform: str
    :param validation_result_message:
    :type validation_result_message: str
    :param version:
    :type version: str
    :param version_description:
    :type version_description: str
    """

    _attribute_map = {
        'asset_uri': {'key': 'assetUri', 'type': 'str'},
        'badges': {'key': 'badges', 'type': '[ExtensionBadge]'},
        'fallback_asset_uri': {'key': 'fallbackAssetUri', 'type': 'str'},
        'files': {'key': 'files', 'type': '[ExtensionFile]'},
        'flags': {'key': 'flags', 'type': 'object'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'properties': {'key': 'properties', 'type': '[{ key: str; value: str }]'},
        'target_platform': {'key': 'targetPlatform', 'type': 'str'},
        'validation_result_message': {'key': 'validationResultMessage', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'version_description': {'key': 'versionDescription', 'type': 'str'}
    }

    def __init__(self, asset_uri=None, badges=None, fallback_asset_uri=None, files=None, flags=None, last_updated=None, properties=None, target_platform=None, validation_result_message=None, version=None, version_description=None):
        super(ExtensionVersion, self).__init__()
        self.asset_uri = asset_uri
        self.badges = badges
        self.fallback_asset_uri = fallback_asset_uri
        self.files = files
        self.flags = flags
        self.last_updated = last_updated
        self.properties = properties
        self.target_platform = target_platform
        self.validation_result_message = validation_result_message
        self.version = version
        self.version_description = version_description


class FilterCriteria(Model):
    """
    One condition in a QueryFilter.

    :param filter_type:
    :type filter_type: int
    :param value: The value used in the match based on the filter type.
    :type value: str
    """

    _attribute_map = {
        'filter_type': {'key': 'filterType', 'type': 'int'},
        'value': {'key': 'value', 'type': 'str'}
    }

    def __init__(self, filter_type=None, value=None):
        super(FilterCriteria, self).__init__()
        self.filter_type = filter_type
        self.value = value


class GraphSubjectBase(Model):
    """
    :param _links: This field contains zero or more interesting links about the graph subject. These links may be invoked to obtain additional relationships or more detailed information about this graph subject.
    :type _links: :class:`ReferenceLinks <azure.devops.v7_1.microsoft._visual_studio._services._web_api.models.ReferenceLinks>`
    :param descriptor: The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the same graph subject across both Accounts and Organizations.
    :type descriptor: str
    :param display_name: This is the non-unique display name of the graph subject. To change this field, you must alter its value in the source provider.
    :type display_name: str
    :param url: This url is the full route to the source resource of this graph subject.
    :type url: str
    """

    _attribute_map = {
        '_links': {'key': '_links', 'type': 'ReferenceLinks'},
        'descriptor': {'key': 'descriptor', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'}
    }

    def __init__(self, _links=None, descriptor=None, display_name=None, url=None):
        super(GraphSubjectBase, self).__init__()
        self._links = _links
        self.descriptor = descriptor
        self.display_name = display_name
        self.url = url


class IdentityRef(GraphSubjectBase):
    """
    :param _links: This field contains zero or more interesting links about the graph subject. These links may be invoked to obtain additional relationships or more detailed information about this graph subject.
    :type _links: :class:`ReferenceLinks <azure.devops.v7_1.microsoft._visual_studio._services._web_api.models.ReferenceLinks>`
    :param descriptor: The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the same graph subject across both Accounts and Organizations.
    :type descriptor: str
    :param display_name: This is the non-unique display name of the graph subject. To change this field, you must alter its value in the source provider.
    :type display_name: str
    :param url: This url is the full route to the source resource of this graph subject.
    :type url: str
    :param directory_alias: Deprecated - Can be retrieved by querying the Graph user referenced in the "self" entry of the IdentityRef "_links" dictionary
    :type directory_alias: str
    :param id:
    :type id: str
    :param image_url: Deprecated - Available in the "avatar" entry of the IdentityRef "_links" dictionary
    :type image_url: str
    :param inactive: Deprecated - Can be retrieved by querying the Graph membership state referenced in the "membershipState" entry of the GraphUser "_links" dictionary
    :type inactive: bool
    :param is_aad_identity: Deprecated - Can be inferred from the subject type of the descriptor (Descriptor.IsAadUserType/Descriptor.IsAadGroupType)
    :type is_aad_identity: bool
    :param is_container: Deprecated - Can be inferred from the subject type of the descriptor (Descriptor.IsGroupType)
    :type is_container: bool
    :param is_deleted_in_origin:
    :type is_deleted_in_origin: bool
    :param profile_url: Deprecated - not in use in most preexisting implementations of ToIdentityRef
    :type profile_url: str
    :param unique_name: Deprecated - use Domain+PrincipalName instead
    :type unique_name: str
    """

    _attribute_map = {
        '_links': {'key': '_links', 'type': 'ReferenceLinks'},
        'descriptor': {'key': 'descriptor', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'directory_alias': {'key': 'directoryAlias', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'image_url': {'key': 'imageUrl', 'type': 'str'},
        'inactive': {'key': 'inactive', 'type': 'bool'},
        'is_aad_identity': {'key': 'isAadIdentity', 'type': 'bool'},
        'is_container': {'key': 'isContainer', 'type': 'bool'},
        'is_deleted_in_origin': {'key': 'isDeletedInOrigin', 'type': 'bool'},
        'profile_url': {'key': 'profileUrl', 'type': 'str'},
        'unique_name': {'key': 'uniqueName', 'type': 'str'}
    }

    def __init__(self, _links=None, descriptor=None, display_name=None, url=None, directory_alias=None, id=None, image_url=None, inactive=None, is_aad_identity=None, is_container=None, is_deleted_in_origin=None, profile_url=None, unique_name=None):
        super(IdentityRef, self).__init__(_links=_links, descriptor=descriptor, display_name=display_name, url=url)
        self.directory_alias = directory_alias
        self.id = id
        self.image_url = image_url
        self.inactive = inactive
        self.is_aad_identity = is_aad_identity
        self.is_container = is_container
        self.is_deleted_in_origin = is_deleted_in_origin
        self.profile_url = profile_url
        self.unique_name = unique_name


class InstallationTarget(Model):
    """
    :param extension_version:
    :type extension_version: str
    :param product_architecture:
    :type product_architecture: str
    :param target:
    :type target: str
    :param target_platform:
    :type target_platform: str
    :param target_version:
    :type target_version: str
    """

    _attribute_map = {
        'extension_version': {'key': 'extensionVersion', 'type': 'str'},
        'product_architecture': {'key': 'productArchitecture', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'target_platform': {'key': 'targetPlatform', 'type': 'str'},
        'target_version': {'key': 'targetVersion', 'type': 'str'}
    }

    def __init__(self, extension_version=None, product_architecture=None, target=None, target_platform=None, target_version=None):
        super(InstallationTarget, self).__init__()
        self.extension_version = extension_version
        self.product_architecture = product_architecture
        self.target = target
        self.target_platform = target_platform
        self.target_version = target_version


class MetadataItem(Model):
    """
    MetadataItem is one value of metadata under a given category of metadata

    :param count: The count of the metadata item
    :type count: int
    :param name: The name of the metadata item
    :type name: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'}
    }

    def __init__(self, count=None, name=None):
        super(MetadataItem, self).__init__()
        self.count = count
        self.name = name


class NotificationsData(Model):
    """
    Information needed for sending mail notification

    :param data: Notification data needed
    :type data: dict
    :param identities: List of users who should get the notification
    :type identities: dict
    :param type: Type of Mail Notification.Can be Qna , review or CustomerContact
    :type type: object
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': '{object}'},
        'identities': {'key': 'identities', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'object'}
    }

    def __init__(self, data=None, identities=None, type=None):
        super(NotificationsData, self).__init__()
        self.data = data
        self.identities = identities
        self.type = type


class ProductCategoriesResult(Model):
    """
    This is the set of categories in response to the get category query

    :param categories:
    :type categories: list of :class:`ProductCategory <azure.devops.v7_1.gallery.models.ProductCategory>`
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[ProductCategory]'}
    }

    def __init__(self, categories=None):
        super(ProductCategoriesResult, self).__init__()
        self.categories = categories


class ProductCategory(Model):
    """
    This is the interface object to be used by Root Categories and Category Tree APIs for Visual Studio Ide.

    :param has_children: Indicator whether this is a leaf or there are children under this category
    :type has_children: bool
    :param children:
    :type children: list of :class:`ProductCategory <azure.devops.v7_1.gallery.models.ProductCategory>`
    :param id: Individual Guid of the Category
    :type id: str
    :param title: Category Title in the requested language
    :type title: str
    """

    _attribute_map = {
        'has_children': {'key': 'hasChildren', 'type': 'bool'},
        'children': {'key': 'children', 'type': '[ProductCategory]'},
        'id': {'key': 'id', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'}
    }

    def __init__(self, has_children=None, children=None, id=None, title=None):
        super(ProductCategory, self).__init__()
        self.has_children = has_children
        self.children = children
        self.id = id
        self.title = title


class PublishedExtension(Model):
    """
    :param categories:
    :type categories: list of str
    :param deployment_type:
    :type deployment_type: object
    :param display_name:
    :type display_name: str
    :param extension_id:
    :type extension_id: str
    :param extension_name:
    :type extension_name: str
    :param flags:
    :type flags: object
    :param installation_targets:
    :type installation_targets: list of :class:`InstallationTarget <azure.devops.v7_1.gallery.models.InstallationTarget>`
    :param last_updated:
    :type last_updated: datetime
    :param long_description:
    :type long_description: str
    :param present_in_conflict_list: Check if Extension is in conflict list or not. Taking as String and not as boolean because we don't want end customer to see this flag and by making it Boolean it is coming as false for all the cases.
    :type present_in_conflict_list: str
    :param published_date: Date on which the extension was first uploaded.
    :type published_date: datetime
    :param publisher:
    :type publisher: :class:`PublisherFacts <azure.devops.v7_1.gallery.models.PublisherFacts>`
    :param release_date: Date on which the extension first went public.
    :type release_date: datetime
    :param shared_with:
    :type shared_with: list of :class:`ExtensionShare <azure.devops.v7_1.gallery.models.ExtensionShare>`
    :param short_description:
    :type short_description: str
    :param statistics:
    :type statistics: list of :class:`ExtensionStatistic <azure.devops.v7_1.gallery.models.ExtensionStatistic>`
    :param tags:
    :type tags: list of str
    :param versions:
    :type versions: list of :class:`ExtensionVersion <azure.devops.v7_1.gallery.models.ExtensionVersion>`
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[str]'},
        'deployment_type': {'key': 'deploymentType', 'type': 'object'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'extension_id': {'key': 'extensionId', 'type': 'str'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'flags': {'key': 'flags', 'type': 'object'},
        'installation_targets': {'key': 'installationTargets', 'type': '[InstallationTarget]'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'long_description': {'key': 'longDescription', 'type': 'str'},
        'present_in_conflict_list': {'key': 'presentInConflictList', 'type': 'str'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'publisher': {'key': 'publisher', 'type': 'PublisherFacts'},
        'release_date': {'key': 'releaseDate', 'type': 'iso-8601'},
        'shared_with': {'key': 'sharedWith', 'type': '[ExtensionShare]'},
        'short_description': {'key': 'shortDescription', 'type': 'str'},
        'statistics': {'key': 'statistics', 'type': '[ExtensionStatistic]'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'versions': {'key': 'versions', 'type': '[ExtensionVersion]'}
    }

    def __init__(self, categories=None, deployment_type=None, display_name=None, extension_id=None, extension_name=None, flags=None, installation_targets=None, last_updated=None, long_description=None, present_in_conflict_list=None, published_date=None, publisher=None, release_date=None, shared_with=None, short_description=None, statistics=None, tags=None, versions=None):
        super(PublishedExtension, self).__init__()
        self.categories = categories
        self.deployment_type = deployment_type
        self.display_name = display_name
        self.extension_id = extension_id
        self.extension_name = extension_name
        self.flags = flags
        self.installation_targets = installation_targets
        self.last_updated = last_updated
        self.long_description = long_description
        self.present_in_conflict_list = present_in_conflict_list
        self.published_date = published_date
        self.publisher = publisher
        self.release_date = release_date
        self.shared_with = shared_with
        self.short_description = short_description
        self.statistics = statistics
        self.tags = tags
        self.versions = versions


class PublisherBase(Model):
    """
    Keeping base class separate since publisher DB model class and publisher contract class share these common properties

    :param display_name:
    :type display_name: str
    :param email_address:
    :type email_address: list of str
    :param extensions:
    :type extensions: list of :class:`PublishedExtension <azure.devops.v7_1.gallery.models.PublishedExtension>`
    :param flags:
    :type flags: object
    :param last_updated:
    :type last_updated: datetime
    :param long_description:
    :type long_description: str
    :param publisher_id:
    :type publisher_id: str
    :param publisher_name:
    :type publisher_name: str
    :param short_description:
    :type short_description: str
    :param state:
    :type state: object
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'email_address': {'key': 'emailAddress', 'type': '[str]'},
        'extensions': {'key': 'extensions', 'type': '[PublishedExtension]'},
        'flags': {'key': 'flags', 'type': 'object'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'long_description': {'key': 'longDescription', 'type': 'str'},
        'publisher_id': {'key': 'publisherId', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'short_description': {'key': 'shortDescription', 'type': 'str'},
        'state': {'key': 'state', 'type': 'object'}
    }

    def __init__(self, display_name=None, email_address=None, extensions=None, flags=None, last_updated=None, long_description=None, publisher_id=None, publisher_name=None, short_description=None, state=None):
        super(PublisherBase, self).__init__()
        self.display_name = display_name
        self.email_address = email_address
        self.extensions = extensions
        self.flags = flags
        self.last_updated = last_updated
        self.long_description = long_description
        self.publisher_id = publisher_id
        self.publisher_name = publisher_name
        self.short_description = short_description
        self.state = state


class PublisherFacts(Model):
    """
    High-level information about the publisher, like id's and names

    :param display_name:
    :type display_name: str
    :param domain:
    :type domain: str
    :param flags:
    :type flags: object
    :param is_domain_verified:
    :type is_domain_verified: bool
    :param publisher_id:
    :type publisher_id: str
    :param publisher_name:
    :type publisher_name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'flags': {'key': 'flags', 'type': 'object'},
        'is_domain_verified': {'key': 'isDomainVerified', 'type': 'bool'},
        'publisher_id': {'key': 'publisherId', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'}
    }

    def __init__(self, display_name=None, domain=None, flags=None, is_domain_verified=None, publisher_id=None, publisher_name=None):
        super(PublisherFacts, self).__init__()
        self.display_name = display_name
        self.domain = domain
        self.flags = flags
        self.is_domain_verified = is_domain_verified
        self.publisher_id = publisher_id
        self.publisher_name = publisher_name


class PublisherFilterResult(Model):
    """
    The FilterResult is the set of publishers that matched a particular query filter.

    :param publishers: This is the set of applications that matched the query filter supplied.
    :type publishers: list of :class:`Publisher <azure.devops.v7_1.gallery.models.Publisher>`
    """

    _attribute_map = {
        'publishers': {'key': 'publishers', 'type': '[Publisher]'}
    }

    def __init__(self, publishers=None):
        super(PublisherFilterResult, self).__init__()
        self.publishers = publishers


class PublisherQuery(Model):
    """
    An PublisherQuery is used to search the gallery for a set of publishers that match one of many filter values.

    :param filters: Each filter is a unique query and will have matching set of publishers returned from the request. Each result will have the same index in the resulting array that the filter had in the incoming query.
    :type filters: list of :class:`QueryFilter <azure.devops.v7_1.gallery.models.QueryFilter>`
    :param flags: The Flags are used to determine which set of information the caller would like returned for the matched publishers.
    :type flags: object
    """

    _attribute_map = {
        'filters': {'key': 'filters', 'type': '[QueryFilter]'},
        'flags': {'key': 'flags', 'type': 'object'}
    }

    def __init__(self, filters=None, flags=None):
        super(PublisherQuery, self).__init__()
        self.filters = filters
        self.flags = flags


class PublisherQueryResult(Model):
    """
    This is the set of publishers that matched a supplied query through the filters given.

    :param results: For each filter supplied in the query, a filter result will be returned in the query result.
    :type results: list of :class:`PublisherFilterResult <azure.devops.v7_1.gallery.models.PublisherFilterResult>`
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': '[PublisherFilterResult]'}
    }

    def __init__(self, results=None):
        super(PublisherQueryResult, self).__init__()
        self.results = results


class PublisherRoleAssignment(Model):
    """
    :param access: Designates the role as explicitly assigned or inherited.
    :type access: object
    :param access_display_name: User friendly description of access assignment.
    :type access_display_name: str
    :param identity: The user to whom the role is assigned.
    :type identity: :class:`IdentityRef <azure.devops.v7_1.gallery.models.IdentityRef>`
    :param role: The role assigned to the user.
    :type role: :class:`PublisherSecurityRole <azure.devops.v7_1.gallery.models.PublisherSecurityRole>`
    """

    _attribute_map = {
        'access': {'key': 'access', 'type': 'object'},
        'access_display_name': {'key': 'accessDisplayName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityRef'},
        'role': {'key': 'role', 'type': 'PublisherSecurityRole'}
    }

    def __init__(self, access=None, access_display_name=None, identity=None, role=None):
        super(PublisherRoleAssignment, self).__init__()
        self.access = access
        self.access_display_name = access_display_name
        self.identity = identity
        self.role = role


class PublisherSecurityRole(Model):
    """
    :param allow_permissions: Permissions the role is allowed.
    :type allow_permissions: int
    :param deny_permissions: Permissions the role is denied.
    :type deny_permissions: int
    :param description: Description of user access defined by the role
    :type description: str
    :param display_name: User friendly name of the role.
    :type display_name: str
    :param identifier: Globally unique identifier for the role.
    :type identifier: str
    :param name: Unique name of the role in the scope.
    :type name: str
    :param scope: Returns the id of the ParentScope.
    :type scope: str
    """

    _attribute_map = {
        'allow_permissions': {'key': 'allowPermissions', 'type': 'int'},
        'deny_permissions': {'key': 'denyPermissions', 'type': 'int'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'identifier': {'key': 'identifier', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'}
    }

    def __init__(self, allow_permissions=None, deny_permissions=None, description=None, display_name=None, identifier=None, name=None, scope=None):
        super(PublisherSecurityRole, self).__init__()
        self.allow_permissions = allow_permissions
        self.deny_permissions = deny_permissions
        self.description = description
        self.display_name = display_name
        self.identifier = identifier
        self.name = name
        self.scope = scope


class PublisherUserRoleAssignmentRef(Model):
    """
    :param role_name: The name of the role assigned.
    :type role_name: str
    :param unique_name: Identifier of the user given the role assignment.
    :type unique_name: str
    :param user_id: Unique id of the user given the role assignment.
    :type user_id: str
    """

    _attribute_map = {
        'role_name': {'key': 'roleName', 'type': 'str'},
        'unique_name': {'key': 'uniqueName', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'}
    }

    def __init__(self, role_name=None, unique_name=None, user_id=None):
        super(PublisherUserRoleAssignmentRef, self).__init__()
        self.role_name = role_name
        self.unique_name = unique_name
        self.user_id = user_id


class QnAItem(Model):
    """
    The core structure of a QnA item

    :param created_date: Time when the review was first created
    :type created_date: datetime
    :param id: Unique identifier of a QnA item
    :type id: long
    :param status: Get status of item
    :type status: object
    :param text: Text description of the QnA item
    :type text: str
    :param updated_date: Time when the review was edited/updated
    :type updated_date: datetime
    :param user: User details for the item.
    :type user: :class:`UserIdentityRef <azure.devops.v7_1.gallery.models.UserIdentityRef>`
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'long'},
        'status': {'key': 'status', 'type': 'object'},
        'text': {'key': 'text', 'type': 'str'},
        'updated_date': {'key': 'updatedDate', 'type': 'iso-8601'},
        'user': {'key': 'user', 'type': 'UserIdentityRef'}
    }

    def __init__(self, created_date=None, id=None, status=None, text=None, updated_date=None, user=None):
        super(QnAItem, self).__init__()
        self.created_date = created_date
        self.id = id
        self.status = status
        self.text = text
        self.updated_date = updated_date
        self.user = user


class QueryFilter(Model):
    """
    A filter used to define a set of extensions to return during a query.

    :param criteria: The filter values define the set of values in this query. They are applied based on the QueryFilterType.
    :type criteria: list of :class:`FilterCriteria <azure.devops.v7_1.gallery.models.FilterCriteria>`
    :param direction: The PagingDirection is applied to a paging token if one exists. If not the direction is ignored, and Forward from the start of the resultset is used. Direction should be left out of the request unless a paging token is used to help prevent future issues.
    :type direction: object
    :param page_number: The page number requested by the user. If not provided 1 is assumed by default.
    :type page_number: int
    :param page_size: The page size defines the number of results the caller wants for this filter. The count can't exceed the overall query size limits.
    :type page_size: int
    :param paging_token: The paging token is a distinct type of filter and the other filter fields are ignored. The paging token represents the continuation of a previously executed query. The information about where in the result and what fields are being filtered are embedded in the token.
    :type paging_token: str
    :param sort_by: Defines the type of sorting to be applied on the results. The page slice is cut of the sorted results only.
    :type sort_by: int
    :param sort_order: Defines the order of sorting, 1 for Ascending, 2 for Descending, else default ordering based on the SortBy value
    :type sort_order: int
    """

    _attribute_map = {
        'criteria': {'key': 'criteria', 'type': '[FilterCriteria]'},
        'direction': {'key': 'direction', 'type': 'object'},
        'page_number': {'key': 'pageNumber', 'type': 'int'},
        'page_size': {'key': 'pageSize', 'type': 'int'},
        'paging_token': {'key': 'pagingToken', 'type': 'str'},
        'sort_by': {'key': 'sortBy', 'type': 'int'},
        'sort_order': {'key': 'sortOrder', 'type': 'int'}
    }

    def __init__(self, criteria=None, direction=None, page_number=None, page_size=None, paging_token=None, sort_by=None, sort_order=None):
        super(QueryFilter, self).__init__()
        self.criteria = criteria
        self.direction = direction
        self.page_number = page_number
        self.page_size = page_size
        self.paging_token = paging_token
        self.sort_by = sort_by
        self.sort_order = sort_order


class Question(QnAItem):
    """
    The structure of the question / thread

    :param created_date: Time when the review was first created
    :type created_date: datetime
    :param id: Unique identifier of a QnA item
    :type id: long
    :param status: Get status of item
    :type status: object
    :param text: Text description of the QnA item
    :type text: str
    :param updated_date: Time when the review was edited/updated
    :type updated_date: datetime
    :param user: User details for the item.
    :type user: :class:`UserIdentityRef <azure.devops.v7_1.gallery.models.UserIdentityRef>`
    :param re_captcha_token:
    :type re_captcha_token: str
    :param responses: List of answers in for the question / thread
    :type responses: list of :class:`Response <azure.devops.v7_1.gallery.models.Response>`
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'long'},
        'status': {'key': 'status', 'type': 'object'},
        'text': {'key': 'text', 'type': 'str'},
        'updated_date': {'key': 'updatedDate', 'type': 'iso-8601'},
        'user': {'key': 'user', 'type': 'UserIdentityRef'},
        're_captcha_token': {'key': 'reCaptchaToken', 'type': 'str'},
        'responses': {'key': 'responses', 'type': '[Response]'}
    }

    def __init__(self, created_date=None, id=None, status=None, text=None, updated_date=None, user=None, re_captcha_token=None, responses=None):
        super(Question, self).__init__(created_date=created_date, id=id, status=status, text=text, updated_date=updated_date, user=user)
        self.re_captcha_token = re_captcha_token
        self.responses = responses


class QuestionsResult(Model):
    """
    :param has_more_questions: Flag indicating if there are more QnA threads to be shown (for paging)
    :type has_more_questions: bool
    :param questions: List of the QnA threads
    :type questions: list of :class:`Question <azure.devops.v7_1.gallery.models.Question>`
    """

    _attribute_map = {
        'has_more_questions': {'key': 'hasMoreQuestions', 'type': 'bool'},
        'questions': {'key': 'questions', 'type': '[Question]'}
    }

    def __init__(self, has_more_questions=None, questions=None):
        super(QuestionsResult, self).__init__()
        self.has_more_questions = has_more_questions
        self.questions = questions


class RatingCountPerRating(Model):
    """
    :param rating: Rating value
    :type rating: str
    :param rating_count: Count of total ratings
    :type rating_count: long
    """

    _attribute_map = {
        'rating': {'key': 'rating', 'type': 'str'},
        'rating_count': {'key': 'ratingCount', 'type': 'long'}
    }

    def __init__(self, rating=None, rating_count=None):
        super(RatingCountPerRating, self).__init__()
        self.rating = rating
        self.rating_count = rating_count


class ReferenceLinks(Model):
    """
    The class to represent a collection of REST reference links.

    :param links: The readonly view of the links.  Because Reference links are readonly, we only want to expose them as read only.
    :type links: dict
    """

    _attribute_map = {
        'links': {'key': 'links', 'type': '{object}'}
    }

    def __init__(self, links=None):
        super(ReferenceLinks, self).__init__()
        self.links = links


class Response(QnAItem):
    """
    The structure of a response

    :param created_date: Time when the review was first created
    :type created_date: datetime
    :param id: Unique identifier of a QnA item
    :type id: long
    :param status: Get status of item
    :type status: object
    :param text: Text description of the QnA item
    :type text: str
    :param updated_date: Time when the review was edited/updated
    :type updated_date: datetime
    :param user: User details for the item.
    :type user: :class:`UserIdentityRef <azure.devops.v7_1.gallery.models.UserIdentityRef>`
    :param re_captcha_token:
    :type re_captcha_token: str
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'long'},
        'status': {'key': 'status', 'type': 'object'},
        'text': {'key': 'text', 'type': 'str'},
        'updated_date': {'key': 'updatedDate', 'type': 'iso-8601'},
        'user': {'key': 'user', 'type': 'UserIdentityRef'},
        're_captcha_token': {'key': 'reCaptchaToken', 'type': 'str'}
    }

    def __init__(self, created_date=None, id=None, status=None, text=None, updated_date=None, user=None, re_captcha_token=None):
        super(Response, self).__init__(created_date=created_date, id=id, status=status, text=text, updated_date=updated_date, user=user)
        self.re_captcha_token = re_captcha_token


class Review(Model):
    """
    :param admin_reply: Admin Reply, if any, for this review
    :type admin_reply: :class:`ReviewReply <azure.devops.v7_1.gallery.models.ReviewReply>`
    :param id: Unique identifier of a review item
    :type id: long
    :param is_deleted: Flag for soft deletion
    :type is_deleted: bool
    :param is_ignored:
    :type is_ignored: bool
    :param product_version: Version of the product for which review was submitted
    :type product_version: str
    :param rating: Rating provided by the user
    :type rating: str
    :param re_captcha_token:
    :type re_captcha_token: str
    :param reply: Reply, if any, for this review
    :type reply: :class:`ReviewReply <azure.devops.v7_1.gallery.models.ReviewReply>`
    :param text: Text description of the review
    :type text: str
    :param title: Title of the review
    :type title: str
    :param updated_date: Time when the review was edited/updated
    :type updated_date: datetime
    :param user_display_name: Name of the user
    :type user_display_name: str
    :param user_id: Id of the user who submitted the review
    :type user_id: str
    """

    _attribute_map = {
        'admin_reply': {'key': 'adminReply', 'type': 'ReviewReply'},
        'id': {'key': 'id', 'type': 'long'},
        'is_deleted': {'key': 'isDeleted', 'type': 'bool'},
        'is_ignored': {'key': 'isIgnored', 'type': 'bool'},
        'product_version': {'key': 'productVersion', 'type': 'str'},
        'rating': {'key': 'rating', 'type': 'str'},
        're_captcha_token': {'key': 'reCaptchaToken', 'type': 'str'},
        'reply': {'key': 'reply', 'type': 'ReviewReply'},
        'text': {'key': 'text', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'updated_date': {'key': 'updatedDate', 'type': 'iso-8601'},
        'user_display_name': {'key': 'userDisplayName', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'}
    }

    def __init__(self, admin_reply=None, id=None, is_deleted=None, is_ignored=None, product_version=None, rating=None, re_captcha_token=None, reply=None, text=None, title=None, updated_date=None, user_display_name=None, user_id=None):
        super(Review, self).__init__()
        self.admin_reply = admin_reply
        self.id = id
        self.is_deleted = is_deleted
        self.is_ignored = is_ignored
        self.product_version = product_version
        self.rating = rating
        self.re_captcha_token = re_captcha_token
        self.reply = reply
        self.text = text
        self.title = title
        self.updated_date = updated_date
        self.user_display_name = user_display_name
        self.user_id = user_id


class ReviewPatch(Model):
    """
    :param operation: Denotes the patch operation type
    :type operation: object
    :param reported_concern: Use when patch operation is FlagReview
    :type reported_concern: :class:`UserReportedConcern <azure.devops.v7_1.gallery.models.UserReportedConcern>`
    :param review_item: Use when patch operation is EditReview
    :type review_item: :class:`Review <azure.devops.v7_1.gallery.models.Review>`
    """

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'object'},
        'reported_concern': {'key': 'reportedConcern', 'type': 'UserReportedConcern'},
        'review_item': {'key': 'reviewItem', 'type': 'Review'}
    }

    def __init__(self, operation=None, reported_concern=None, review_item=None):
        super(ReviewPatch, self).__init__()
        self.operation = operation
        self.reported_concern = reported_concern
        self.review_item = review_item


class ReviewReply(Model):
    """
    :param id: Id of the reply
    :type id: long
    :param is_deleted: Flag for soft deletion
    :type is_deleted: bool
    :param product_version: Version of the product when the reply was submitted or updated
    :type product_version: str
    :param reply_text: Content of the reply
    :type reply_text: str
    :param review_id: Id of the review, to which this reply belongs
    :type review_id: long
    :param title: Title of the reply
    :type title: str
    :param updated_date: Date the reply was submitted or updated
    :type updated_date: datetime
    :param user_id: Id of the user who left the reply
    :type user_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'is_deleted': {'key': 'isDeleted', 'type': 'bool'},
        'product_version': {'key': 'productVersion', 'type': 'str'},
        'reply_text': {'key': 'replyText', 'type': 'str'},
        'review_id': {'key': 'reviewId', 'type': 'long'},
        'title': {'key': 'title', 'type': 'str'},
        'updated_date': {'key': 'updatedDate', 'type': 'iso-8601'},
        'user_id': {'key': 'userId', 'type': 'str'}
    }

    def __init__(self, id=None, is_deleted=None, product_version=None, reply_text=None, review_id=None, title=None, updated_date=None, user_id=None):
        super(ReviewReply, self).__init__()
        self.id = id
        self.is_deleted = is_deleted
        self.product_version = product_version
        self.reply_text = reply_text
        self.review_id = review_id
        self.title = title
        self.updated_date = updated_date
        self.user_id = user_id


class ReviewsResult(Model):
    """
    :param has_more_reviews: Flag indicating if there are more reviews to be shown (for paging)
    :type has_more_reviews: bool
    :param reviews: List of reviews
    :type reviews: list of :class:`Review <azure.devops.v7_1.gallery.models.Review>`
    :param total_review_count: Count of total review items
    :type total_review_count: long
    """

    _attribute_map = {
        'has_more_reviews': {'key': 'hasMoreReviews', 'type': 'bool'},
        'reviews': {'key': 'reviews', 'type': '[Review]'},
        'total_review_count': {'key': 'totalReviewCount', 'type': 'long'}
    }

    def __init__(self, has_more_reviews=None, reviews=None, total_review_count=None):
        super(ReviewsResult, self).__init__()
        self.has_more_reviews = has_more_reviews
        self.reviews = reviews
        self.total_review_count = total_review_count


class ReviewSummary(Model):
    """
    :param average_rating: Average Rating
    :type average_rating: float
    :param rating_count: Count of total ratings
    :type rating_count: long
    :param rating_split: Split of count across rating
    :type rating_split: list of :class:`RatingCountPerRating <azure.devops.v7_1.gallery.models.RatingCountPerRating>`
    """

    _attribute_map = {
        'average_rating': {'key': 'averageRating', 'type': 'float'},
        'rating_count': {'key': 'ratingCount', 'type': 'long'},
        'rating_split': {'key': 'ratingSplit', 'type': '[RatingCountPerRating]'}
    }

    def __init__(self, average_rating=None, rating_count=None, rating_split=None):
        super(ReviewSummary, self).__init__()
        self.average_rating = average_rating
        self.rating_count = rating_count
        self.rating_split = rating_split


class UnpackagedExtensionData(Model):
    """
    :param categories:
    :type categories: list of str
    :param description:
    :type description: str
    :param display_name:
    :type display_name: str
    :param draft_id:
    :type draft_id: str
    :param extension_name:
    :type extension_name: str
    :param installation_targets:
    :type installation_targets: list of :class:`InstallationTarget <azure.devops.v7_1.gallery.models.InstallationTarget>`
    :param is_converted_to_markdown:
    :type is_converted_to_markdown: bool
    :param is_preview:
    :type is_preview: bool
    :param pricing_category:
    :type pricing_category: str
    :param product:
    :type product: str
    :param publisher_name:
    :type publisher_name: str
    :param qn_aEnabled:
    :type qn_aEnabled: bool
    :param referral_url:
    :type referral_url: str
    :param repository_url:
    :type repository_url: str
    :param tags:
    :type tags: list of str
    :param version:
    :type version: str
    :param vsix_id:
    :type vsix_id: str
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[str]'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'draft_id': {'key': 'draftId', 'type': 'str'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'installation_targets': {'key': 'installationTargets', 'type': '[InstallationTarget]'},
        'is_converted_to_markdown': {'key': 'isConvertedToMarkdown', 'type': 'bool'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'pricing_category': {'key': 'pricingCategory', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'qn_aEnabled': {'key': 'qnAEnabled', 'type': 'bool'},
        'referral_url': {'key': 'referralUrl', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'version': {'key': 'version', 'type': 'str'},
        'vsix_id': {'key': 'vsixId', 'type': 'str'}
    }

    def __init__(self, categories=None, description=None, display_name=None, draft_id=None, extension_name=None, installation_targets=None, is_converted_to_markdown=None, is_preview=None, pricing_category=None, product=None, publisher_name=None, qn_aEnabled=None, referral_url=None, repository_url=None, tags=None, version=None, vsix_id=None):
        super(UnpackagedExtensionData, self).__init__()
        self.categories = categories
        self.description = description
        self.display_name = display_name
        self.draft_id = draft_id
        self.extension_name = extension_name
        self.installation_targets = installation_targets
        self.is_converted_to_markdown = is_converted_to_markdown
        self.is_preview = is_preview
        self.pricing_category = pricing_category
        self.product = product
        self.publisher_name = publisher_name
        self.qn_aEnabled = qn_aEnabled
        self.referral_url = referral_url
        self.repository_url = repository_url
        self.tags = tags
        self.version = version
        self.vsix_id = vsix_id


class UserIdentityRef(Model):
    """
    Identity reference with name and guid

    :param display_name: User display name
    :type display_name: str
    :param id: User VSID
    :type id: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'}
    }

    def __init__(self, display_name=None, id=None):
        super(UserIdentityRef, self).__init__()
        self.display_name = display_name
        self.id = id


class UserReportedConcern(Model):
    """
    :param category: Category of the concern
    :type category: object
    :param concern_text: User comment associated with the report
    :type concern_text: str
    :param review_id: Id of the review which was reported
    :type review_id: long
    :param submitted_date: Date the report was submitted
    :type submitted_date: datetime
    :param user_id: Id of the user who reported a review
    :type user_id: str
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'object'},
        'concern_text': {'key': 'concernText', 'type': 'str'},
        'review_id': {'key': 'reviewId', 'type': 'long'},
        'submitted_date': {'key': 'submittedDate', 'type': 'iso-8601'},
        'user_id': {'key': 'userId', 'type': 'str'}
    }

    def __init__(self, category=None, concern_text=None, review_id=None, submitted_date=None, user_id=None):
        super(UserReportedConcern, self).__init__()
        self.category = category
        self.concern_text = concern_text
        self.review_id = review_id
        self.submitted_date = submitted_date
        self.user_id = user_id


class Concern(QnAItem):
    """
    The structure of a Concern Rather than defining a separate data structure having same fields as QnAItem, we are inheriting from the QnAItem.

    :param created_date: Time when the review was first created
    :type created_date: datetime
    :param id: Unique identifier of a QnA item
    :type id: long
    :param status: Get status of item
    :type status: object
    :param text: Text description of the QnA item
    :type text: str
    :param updated_date: Time when the review was edited/updated
    :type updated_date: datetime
    :param user: User details for the item.
    :type user: :class:`UserIdentityRef <azure.devops.v7_1.gallery.models.UserIdentityRef>`
    :param category: Category of the concern
    :type category: object
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'long'},
        'status': {'key': 'status', 'type': 'object'},
        'text': {'key': 'text', 'type': 'str'},
        'updated_date': {'key': 'updatedDate', 'type': 'iso-8601'},
        'user': {'key': 'user', 'type': 'UserIdentityRef'},
        'category': {'key': 'category', 'type': 'object'}
    }

    def __init__(self, created_date=None, id=None, status=None, text=None, updated_date=None, user=None, category=None):
        super(Concern, self).__init__(created_date=created_date, id=id, status=status, text=text, updated_date=updated_date, user=user)
        self.category = category


class ExtensionDraftAsset(ExtensionFile):
    """
    :param asset_type:
    :type asset_type: str
    :param language:
    :type language: str
    :param source:
    :type source: str
    """

    _attribute_map = {
        'asset_type': {'key': 'assetType', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(self, asset_type=None, language=None, source=None):
        super(ExtensionDraftAsset, self).__init__(asset_type=asset_type, language=language, source=source)


class Publisher(PublisherBase):
    """
    :param display_name:
    :type display_name: str
    :param email_address:
    :type email_address: list of str
    :param extensions:
    :type extensions: list of :class:`PublishedExtension <azure.devops.v7_1.gallery.models.PublishedExtension>`
    :param flags:
    :type flags: object
    :param last_updated:
    :type last_updated: datetime
    :param long_description:
    :type long_description: str
    :param publisher_id:
    :type publisher_id: str
    :param publisher_name:
    :type publisher_name: str
    :param short_description:
    :type short_description: str
    :param state:
    :type state: object
    :param _links:
    :type _links: :class:`ReferenceLinks <azure.devops.v7_1.gallery.models.ReferenceLinks>`
    :param domain:
    :type domain: str
    :param is_dns_token_verified:
    :type is_dns_token_verified: bool
    :param is_domain_verified:
    :type is_domain_verified: bool
    :param re_captcha_token:
    :type re_captcha_token: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'email_address': {'key': 'emailAddress', 'type': '[str]'},
        'extensions': {'key': 'extensions', 'type': '[PublishedExtension]'},
        'flags': {'key': 'flags', 'type': 'object'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'long_description': {'key': 'longDescription', 'type': 'str'},
        'publisher_id': {'key': 'publisherId', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'short_description': {'key': 'shortDescription', 'type': 'str'},
        'state': {'key': 'state', 'type': 'object'},
        '_links': {'key': '_links', 'type': 'ReferenceLinks'},
        'domain': {'key': 'domain', 'type': 'str'},
        'is_dns_token_verified': {'key': 'isDnsTokenVerified', 'type': 'bool'},
        'is_domain_verified': {'key': 'isDomainVerified', 'type': 'bool'},
        're_captcha_token': {'key': 'reCaptchaToken', 'type': 'str'}
    }

    def __init__(self, display_name=None, email_address=None, extensions=None, flags=None, last_updated=None, long_description=None, publisher_id=None, publisher_name=None, short_description=None, state=None, _links=None, domain=None, is_dns_token_verified=None, is_domain_verified=None, re_captcha_token=None):
        super(Publisher, self).__init__(display_name=display_name, email_address=email_address, extensions=extensions, flags=flags, last_updated=last_updated, long_description=long_description, publisher_id=publisher_id, publisher_name=publisher_name, short_description=short_description, state=state)
        self._links = _links
        self.domain = domain
        self.is_dns_token_verified = is_dns_token_verified
        self.is_domain_verified = is_domain_verified
        self.re_captcha_token = re_captcha_token


__all__ = [
    'AcquisitionOperation',
    'AcquisitionOptions',
    'Answers',
    'AssetDetails',
    'AzurePublisher',
    'AzureRestApiRequestModel',
    'CategoriesResult',
    'CategoryLanguageTitle',
    'CustomerSupportRequest',
    'EventCounts',
    'ExtensionAcquisitionRequest',
    'ExtensionBadge',
    'ExtensionCategory',
    'ExtensionDailyStat',
    'ExtensionDailyStats',
    'ExtensionDraft',
    'ExtensionDraftPatch',
    'ExtensionEvent',
    'ExtensionEvents',
    'ExtensionFile',
    'ExtensionFilterResult',
    'ExtensionFilterResultMetadata',
    'ExtensionPackage',
    'ExtensionPayload',
    'ExtensionQuery',
    'ExtensionQueryResult',
    'ExtensionShare',
    'ExtensionStatistic',
    'ExtensionStatisticUpdate',
    'ExtensionVersion',
    'FilterCriteria',
    'GraphSubjectBase',
    'IdentityRef',
    'InstallationTarget',
    'MetadataItem',
    'NotificationsData',
    'ProductCategoriesResult',
    'ProductCategory',
    'PublishedExtension',
    'PublisherBase',
    'PublisherFacts',
    'PublisherFilterResult',
    'PublisherQuery',
    'PublisherQueryResult',
    'PublisherRoleAssignment',
    'PublisherSecurityRole',
    'PublisherUserRoleAssignmentRef',
    'QnAItem',
    'QueryFilter',
    'Question',
    'QuestionsResult',
    'RatingCountPerRating',
    'ReferenceLinks',
    'Response',
    'Review',
    'ReviewPatch',
    'ReviewReply',
    'ReviewsResult',
    'ReviewSummary',
    'UnpackagedExtensionData',
    'UserIdentityRef',
    'UserReportedConcern',
    'Concern',
    'ExtensionDraftAsset',
    'Publisher',
]
