/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.pseudoserver.WebResource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

class HttpResponseStream {
    private static final String CRLF = "\r\n";
    private OutputStream _stream;
    private PrintWriter _pw;
    private Vector _headers = new Vector();
    private String _protocol = "HTTP/1.0";
    private int _responseCode = 200;
    private String _responseText = "OK";
    private boolean _headersWritten;

    void restart() {
        this._headersWritten = false;
        this._headers.clear();
        this._responseCode = 200;
        this._responseText = "OK";
    }

    void close() throws IOException {
        this.flushHeaders();
        this._pw.close();
    }

    HttpResponseStream(OutputStream stream) {
        this._stream = stream;
        try {
            this.setCharacterSet("us-ascii");
        }
        catch (UnsupportedEncodingException e) {
            this._pw = new PrintWriter(new OutputStreamWriter(this._stream));
        }
    }

    void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    void setResponse(int responseCode, String responseText) {
        this._responseCode = responseCode;
        this._responseText = responseText;
    }

    void addHeader(String header) {
        this._headers.addElement(header);
    }

    void write(String contents, String charset) throws IOException {
        this.flushHeaders();
        this.setCharacterSet(charset);
        this.sendText(contents);
    }

    void write(WebResource resource) throws IOException {
        this.flushHeaders();
        resource.writeTo(this._stream);
        this._stream.flush();
    }

    private void setCharacterSet(String characterSet) throws UnsupportedEncodingException {
        if (this._pw != null) {
            this._pw.flush();
        }
        this._pw = new PrintWriter(new OutputStreamWriter(this._stream, characterSet));
    }

    private void flushHeaders() {
        if (!this._headersWritten) {
            this.sendResponse(this._responseCode, this._responseText);
            Enumeration e = this._headers.elements();
            while (e.hasMoreElements()) {
                this.sendLine((String)e.nextElement());
            }
            this.sendText(CRLF);
            this._headersWritten = true;
            this._pw.flush();
        }
    }

    private void sendResponse(int responseCode, String responseText) {
        this.sendLine(this._protocol + ' ' + responseCode + ' ' + responseText);
    }

    private void sendLine(String text) {
        this.sendText(text);
        this.sendText(CRLF);
    }

    private void sendText(String text) {
        this._pw.write(text);
    }

    static {
        CRLF = CRLF;
    }
}

