/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverEllipseEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverEllipseEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        UEllipse shape = (UEllipse)ushape;
        double width = shape.getWidth();
        double height = shape.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            if (!clip.isInside(x, y)) {
                return;
            }
            if (!clip.isInside(x + width, y + height)) {
                return;
            }
        }
        if (shape.getDeltaShadow() != 0.0) {
            eps.epsEllipseShadow(x + width / 2.0, y + height / 2.0, width / 2.0, height / 2.0, shape.getDeltaShadow());
        }
        eps.setFillColor(mapper.getMappedColor(param.getBackcolor()));
        eps.setStrokeColor(mapper.getMappedColor(param.getColor()));
        eps.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashVisible(), param.getStroke().getDashSpace());
        if (shape.getStart() == 0.0 && shape.getExtend() == 0.0) {
            eps.epsEllipse(x + width / 2.0, y + height / 2.0, width / 2.0, height / 2.0);
        } else {
            eps.epsEllipse(x + width / 2.0, y + height / 2.0, width / 2.0, height / 2.0, shape.getStart(), shape.getExtend());
        }
    }
}

