// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"testing"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/resource"
)

func TestAccComputeImageIamBindingGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
		"role":          "roles/compute.imageUser",
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccComputeImageIamBinding_basicGenerated(context),
			},
			{
				ResourceName:      "google_compute_image_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/global/images/%s roles/compute.imageUser", getTestProjectFromEnv(), fmt.Sprintf("tf-test-example-image%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				// Test Iam Binding update
				Config: testAccComputeImageIamBinding_updateGenerated(context),
			},
			{
				ResourceName:      "google_compute_image_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/global/images/%s roles/compute.imageUser", getTestProjectFromEnv(), fmt.Sprintf("tf-test-example-image%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccComputeImageIamMemberGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
		"role":          "roles/compute.imageUser",
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				// Test Iam Member creation (no update for member, no need to test)
				Config: testAccComputeImageIamMember_basicGenerated(context),
			},
			{
				ResourceName:      "google_compute_image_iam_member.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/global/images/%s roles/compute.imageUser user:admin@hashicorptest.com", getTestProjectFromEnv(), fmt.Sprintf("tf-test-example-image%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccComputeImageIamPolicyGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
		"role":          "roles/compute.imageUser",
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccComputeImageIamPolicy_basicGenerated(context),
			},
			{
				ResourceName:      "google_compute_image_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/global/images/%s", getTestProjectFromEnv(), fmt.Sprintf("tf-test-example-image%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				Config: testAccComputeImageIamPolicy_emptyBinding(context),
			},
			{
				ResourceName:      "google_compute_image_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/global/images/%s", getTestProjectFromEnv(), fmt.Sprintf("tf-test-example-image%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccComputeImageIamMember_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_compute_image" "example" {
  name = "tf-test-example-image%{random_suffix}"

  raw_disk {
    source = "https://storage.googleapis.com/bosh-cpi-artifacts/bosh-stemcell-3262.4-google-kvm-ubuntu-trusty-go_agent-raw.tar.gz"
  }
}

resource "google_compute_image_iam_member" "foo" {
  project = google_compute_image.example.project
  image = google_compute_image.example.name
  role = "%{role}"
  member = "user:admin@hashicorptest.com"
}
`, context)
}

func testAccComputeImageIamPolicy_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_compute_image" "example" {
  name = "tf-test-example-image%{random_suffix}"

  raw_disk {
    source = "https://storage.googleapis.com/bosh-cpi-artifacts/bosh-stemcell-3262.4-google-kvm-ubuntu-trusty-go_agent-raw.tar.gz"
  }
}

data "google_iam_policy" "foo" {
  binding {
    role = "%{role}"
    members = ["user:admin@hashicorptest.com"]
  }
}

resource "google_compute_image_iam_policy" "foo" {
  project = google_compute_image.example.project
  image = google_compute_image.example.name
  policy_data = data.google_iam_policy.foo.policy_data
}
`, context)
}

func testAccComputeImageIamPolicy_emptyBinding(context map[string]interface{}) string {
	return Nprintf(`
resource "google_compute_image" "example" {
  name = "tf-test-example-image%{random_suffix}"

  raw_disk {
    source = "https://storage.googleapis.com/bosh-cpi-artifacts/bosh-stemcell-3262.4-google-kvm-ubuntu-trusty-go_agent-raw.tar.gz"
  }
}

data "google_iam_policy" "foo" {
}

resource "google_compute_image_iam_policy" "foo" {
  project = google_compute_image.example.project
  image = google_compute_image.example.name
  policy_data = data.google_iam_policy.foo.policy_data
}
`, context)
}

func testAccComputeImageIamBinding_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_compute_image" "example" {
  name = "tf-test-example-image%{random_suffix}"

  raw_disk {
    source = "https://storage.googleapis.com/bosh-cpi-artifacts/bosh-stemcell-3262.4-google-kvm-ubuntu-trusty-go_agent-raw.tar.gz"
  }
}

resource "google_compute_image_iam_binding" "foo" {
  project = google_compute_image.example.project
  image = google_compute_image.example.name
  role = "%{role}"
  members = ["user:admin@hashicorptest.com"]
}
`, context)
}

func testAccComputeImageIamBinding_updateGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_compute_image" "example" {
  name = "tf-test-example-image%{random_suffix}"

  raw_disk {
    source = "https://storage.googleapis.com/bosh-cpi-artifacts/bosh-stemcell-3262.4-google-kvm-ubuntu-trusty-go_agent-raw.tar.gz"
  }
}

resource "google_compute_image_iam_binding" "foo" {
  project = google_compute_image.example.project
  image = google_compute_image.example.name
  role = "%{role}"
  members = ["user:admin@hashicorptest.com", "user:paddy@hashicorp.com"]
}
`, context)
}
