#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../brl.h"
#include "../brl_driver.h"
#include "../sbllog.h"

void brl_debug (unsigned int dbg)
{
  if (dbg == 5)
    return;
}

struct brlinfo identbrl (const char *name, const char *dev)
{
  struct brlinfo ret;

  ret.cols = 0;
  if (!strcmp (name, "none"))
   {
     strcpy (ret.name, "none");
     strcpy (ret.fullname, "no braille support");
     sbl_log ("none braille\n");
     ret.cols = 80;
     ret.st_cells = 0;
     ret.offvert = 0;
     ret.offhor = 0;
     ret.baud = 0;

     return ret;
   }

  if (dev)
    return ret;
  return ret;
}

void initbrl (brldim * brl, const char *dev)    /* initialise Braille display 
                                                 */
{

  brl->x = 80;
  brl->y = 1;
  brl->disp = (unsigned char *) malloc (brl->x * brl->y);
  if (dev)
    return;
}

void closebrl (brldim * brl)    /* close braille display */
{
  free (brl->disp);
  return;
}

void writebrl (brldim * dev)    /* write to braille display */
{
  if (dev)
    return;
  return;
}

int readbrl (int *type)         /* get key press from braille display */
{
  *type = 0;
  return EOF;
}

void setbrlstat (const unsigned char *txt)      /* set status cells */
{
  if (txt)
    return;
  return;
}
