// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the response to a successful <code>GetSessionToken</code> request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct GetSessionTokenOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p><note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub credentials: ::std::option::Option<crate::types::Credentials>,
    _request_id: Option<String>,
}
impl GetSessionTokenOutput {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p><note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn credentials(&self) -> ::std::option::Option<&crate::types::Credentials> {
        self.credentials.as_ref()
    }
}
impl ::std::fmt::Debug for GetSessionTokenOutput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionTokenOutput");
        formatter.field("credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
impl ::aws_types::request_id::RequestId for GetSessionTokenOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl GetSessionTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetSessionTokenOutput`](crate::operation::get_session_token::GetSessionTokenOutput).
    pub fn builder() -> crate::operation::get_session_token::builders::GetSessionTokenOutputBuilder {
        crate::operation::get_session_token::builders::GetSessionTokenOutputBuilder::default()
    }
}

/// A builder for [`GetSessionTokenOutput`](crate::operation::get_session_token::GetSessionTokenOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct GetSessionTokenOutputBuilder {
    pub(crate) credentials: ::std::option::Option<crate::types::Credentials>,
    _request_id: Option<String>,
}
impl GetSessionTokenOutputBuilder {
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p><note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn credentials(mut self, input: crate::types::Credentials) -> Self {
        self.credentials = ::std::option::Option::Some(input);
        self
    }
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p><note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn set_credentials(mut self, input: ::std::option::Option<crate::types::Credentials>) -> Self {
        self.credentials = input;
        self
    }
    /// <p>The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.</p><note>
    /// <p>The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.</p>
    /// </note>
    pub fn get_credentials(&self) -> &::std::option::Option<crate::types::Credentials> {
        &self.credentials
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`GetSessionTokenOutput`](crate::operation::get_session_token::GetSessionTokenOutput).
    pub fn build(self) -> crate::operation::get_session_token::GetSessionTokenOutput {
        crate::operation::get_session_token::GetSessionTokenOutput {
            credentials: self.credentials,
            _request_id: self._request_id,
        }
    }
}
impl ::std::fmt::Debug for GetSessionTokenOutputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionTokenOutputBuilder");
        formatter.field("credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
