/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.persister;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.cglib.MetaClass;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.InstantiationException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PropertyAccessException;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.IdentityGenerator;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.SelectFragment;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.ComponentType;
import net.sf.hibernate.type.IdentifierType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.type.VersionType;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEntityPersister
implements Queryable,
ClassMetadata {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$persister$AbstractEntityPersister == null ? (class$net$sf$hibernate$persister$AbstractEntityPersister = AbstractEntityPersister.class$("net.sf.hibernate.persister.AbstractEntityPersister")) : class$net$sf$hibernate$persister$AbstractEntityPersister));
    protected static final Class[] NO_CLASSES = new Class[0];
    private final Class mappedClass;
    private final transient Dialect dialect;
    private final transient Constructor constructor;
    private final transient IdentifierGenerator idgen;
    private final transient boolean polymorphic;
    private final transient boolean explicitPolymorphism;
    private final transient boolean inherited;
    private final transient boolean hasSubclasses;
    private final transient boolean versioned;
    private final transient boolean abstractClass;
    private final transient boolean implementsLifecycle;
    private final transient boolean implementsValidatable;
    private final transient boolean hasCollections;
    private final transient boolean hasCascades;
    private final transient boolean mutable;
    private final transient boolean useIdentityColumn;
    private final transient Class superclass;
    private final transient boolean dynamicUpdate;
    private final transient boolean dynamicInsert;
    private final transient String identitySelectString;
    private final transient Class[] proxyInterfaces;
    private final transient Class concreteProxyClass;
    private final transient boolean hasProxy;
    private final transient boolean hasEmbeddedIdentifier;
    private final transient String[] identifierColumnNames;
    private final transient Cascades.IdentifierValue unsavedIdentifierValue;
    protected final transient HashMap columnNamesByPropertyPath = new HashMap();
    protected final transient HashMap typesByPropertyPath = new HashMap();
    private final transient String identifierPropertyName;
    private final transient Type identifierType;
    private final transient ReflectHelper.Setter identifierSetter;
    private final transient ReflectHelper.Getter identifierGetter;
    private final transient Method proxyGetIdentifierMethod;
    private final transient String[] propertyNames;
    private final transient Type[] propertyTypes;
    private final transient boolean[] propertyUpdateability;
    private final transient boolean[] propertyInsertability;
    private final transient String versionPropertyName;
    private final transient String versionColumnName;
    private final transient VersionType versionType;
    private final transient ReflectHelper.Getter versionGetter;
    private final transient int versionProperty;
    private final transient ReflectHelper.Getter[] getters;
    private final transient ReflectHelper.Setter[] setters;
    private final transient HashMap gettersByPropertyName = new HashMap();
    private final transient HashMap settersByPropertyName = new HashMap();
    protected final transient int hydrateSpan;
    private final transient String className;
    private final transient Cascades.CascadeStyle[] cascadeStyles;
    private final transient CacheConcurrencyStrategy cache;
    private final transient MetaClass optimizer;
    static /* synthetic */ Class class$net$sf$hibernate$persister$AbstractEntityPersister;
    static /* synthetic */ Class class$net$sf$hibernate$Lifecycle;
    static /* synthetic */ Class class$net$sf$hibernate$Validatable;
    static /* synthetic */ Class class$net$sf$hibernate$proxy$HibernateProxy;

    public final Class getMappedClass() {
        return this.mappedClass;
    }

    public final String getClassName() {
        return this.className;
    }

    public String identifierSelectFragment(String name, String suffix) {
        return new SelectFragment().setSuffix(suffix).addColumns(name, this.getIdentifierColumnNames()).toFragmentString().substring(2);
    }

    public Type getPropertyType(String path) {
        return (Type)this.typesByPropertyPath.get(path);
    }

    public Cascades.CascadeStyle[] getPropertyCascadeStyles() {
        return this.cascadeStyles;
    }

    public void setPropertyValues(Object object, Object[] values) throws HibernateException {
        try {
            if (this.optimizer != null) {
                this.optimizer.setPropertyValues(object, values);
                return;
            }
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception setting property value with CGLIB", true, this.mappedClass, "?");
        }
        int j = 0;
        while (j < this.hydrateSpan) {
            this.getSetters()[j].set(object, values[j]);
            ++j;
        }
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        try {
            if (this.optimizer != null) {
                return this.optimizer.getPropertyValues(object);
            }
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception getting property value with CGLIB", false, this.mappedClass, "?");
        }
        Object[] result = new Object[this.hydrateSpan];
        int j = 0;
        while (j < this.hydrateSpan) {
            result[j] = this.getGetters()[j].get(object);
            ++j;
        }
        return result;
    }

    public Object getPropertyValue(Object object, int i) throws HibernateException {
        return this.getGetters()[i].get(object);
    }

    public void setPropertyValue(Object object, int i, Object value) throws HibernateException {
        this.getSetters()[i].set(object, value);
    }

    public int[] findDirty(Object[] x, Object[] y, Object object, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findDirty(this.propertyTypes, x, y, this.propertyUpdateability, session);
        if (props == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            int i = 0;
            while (i < props.length) {
                log.trace((Object)(this.className + '.' + this.propertyNames[props[i]] + " is dirty"));
                ++i;
            }
        }
        return props;
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        Object id;
        if (this.hasEmbeddedIdentifier) {
            id = object;
        } else {
            if (this.identifierGetter == null) {
                throw new HibernateException("The class has no identifier property: " + this.className);
            }
            id = this.identifierGetter.get(object);
        }
        try {
            return (Serializable)id;
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Identifier classes must be serializable: " + cce.getMessage());
        }
    }

    public Object getVersion(Object object) throws HibernateException {
        if (!this.versioned) {
            return null;
        }
        return this.versionGetter.get(object);
    }

    public void setIdentifier(Object object, Serializable id) throws HibernateException {
        if (this.hasEmbeddedIdentifier) {
            ComponentType copier = (ComponentType)this.identifierType;
            copier.setPropertyValues(object, copier.getPropertyValues(id));
        } else if (this.identifierSetter != null) {
            this.identifierSetter.set(object, id);
        }
    }

    public Object instantiate(Serializable id) throws HibernateException {
        if (this.hasEmbeddedIdentifier && id.getClass() == this.mappedClass) {
            return id;
        }
        if (this.abstractClass) {
            throw new HibernateException("Cannot instantiate abstract class or interface: " + this.className);
        }
        if (this.optimizer != null) {
            try {
                return this.optimizer.newInstance();
            }
            catch (Throwable t) {
                throw new InstantiationException("Could not instantiate entity with CGLIB: ", this.mappedClass, t);
            }
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, e);
        }
    }

    protected ReflectHelper.Setter[] getSetters() {
        return this.setters;
    }

    protected ReflectHelper.Getter[] getGetters() {
        return this.getters;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public String[] getIdentifierColumnNames() {
        return this.identifierColumnNames;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasCompositeKey() {
        return this.identifierColumnNames.length > 1;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierGetter != null;
    }

    public Method getProxyGetIdentifierMethod() {
        return this.proxyGetIdentifierMethod;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public int getVersionProperty() {
        return this.versionProperty;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isIdentifierAssignedByInsert() {
        return this.useIdentityColumn;
    }

    public boolean isUnsaved(Serializable id) {
        return this.unsavedIdentifierValue.isUnsaved(id);
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getIdentifierPropertyName() {
        return this.identifierPropertyName;
    }

    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    public final String[] getPropertyColumnNames(String path) {
        return (String[])this.columnNamesByPropertyPath.get(path);
    }

    public boolean implementsLifecycle() {
        return this.implementsLifecycle;
    }

    public boolean implementsValidatable() {
        return this.implementsValidatable;
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public Class[] getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    public boolean hasProxy() {
        return this.hasProxy;
    }

    protected final String sqlIdentitySelect() {
        return this.identitySelectString;
    }

    public IdentifierGenerator getIdentifierGenerator() throws HibernateException {
        if (this.idgen == null) {
            throw new HibernateException("No ID SchemaExport is configured for class " + this.className + " (Try using insert() with an assigned ID)");
        }
        return this.idgen;
    }

    protected void check(int rows, Serializable id) throws HibernateException {
        if (rows < 1) {
            throw new StaleObjectStateException(this.getMappedClass(), id);
        }
        if (rows > 1) {
            throw new HibernateException("Duplicate identifier in table for " + this.getClassName() + ": " + id);
        }
    }

    protected AbstractEntityPersister(PersistentClass model, SessionFactoryImplementor factory) throws MappingException {
        this.dialect = factory.getDialect();
        this.className = model.getPersistentClass().getName();
        this.mappedClass = model.getPersistentClass();
        this.mutable = model.isMutable();
        this.dynamicUpdate = model.useDynamicUpdate();
        this.dynamicInsert = model.useDynamicInsert();
        this.polymorphic = model.isPolymorphic();
        this.explicitPolymorphism = model.isExplicitPolymorphism();
        this.inherited = model.isInherited();
        this.superclass = this.inherited ? model.getSuperclass().getPersistentClass() : null;
        this.hasSubclasses = model.hasSubclasses();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        this.abstractClass = ReflectHelper.isAbstractClass(this.mappedClass);
        this.hasEmbeddedIdentifier = model.hasEmbeddedIdentifier();
        this.identifierPropertyName = model.hasIdentifierProperty() ? model.getIdentifierProperty().getName() : null;
        Value idValue = model.getIdentifier();
        this.identifierType = idValue.getType();
        if (this.identifierPropertyName != null) {
            this.identifierSetter = ReflectHelper.getSetter(this.mappedClass, this.identifierPropertyName);
            this.identifierGetter = ReflectHelper.getGetter(this.mappedClass, this.identifierPropertyName);
            Method proxyGetter = this.identifierGetter.getMethod();
            try {
                Class prox = model.getProxyInterface();
                if (prox != null) {
                    proxyGetter = ReflectHelper.getGetter(prox, this.identifierPropertyName).getMethod();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.proxyGetIdentifierMethod = proxyGetter;
        } else {
            this.identifierGetter = null;
            this.identifierSetter = null;
            this.proxyGetIdentifierMethod = null;
        }
        int m = 0;
        Iterator iter = model.getPropertyClosureIterator();
        while (iter.hasNext()) {
            ++m;
            iter.next();
        }
        this.hydrateSpan = m;
        int idColumnSpan = model.getIdentifier().getColumnSpan();
        this.identifierColumnNames = new String[idColumnSpan];
        iter = idValue.getColumnIterator();
        int i = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.identifierColumnNames[i] = col.getQuotedName(this.dialect);
            ++i;
        }
        this.idgen = model.getIdentifier().createIdentifierGenerator(this.dialect);
        this.useIdentityColumn = this.idgen instanceof IdentityGenerator;
        this.identitySelectString = this.useIdentityColumn ? this.dialect.getIdentitySelectString() : null;
        String unsavedValue = model.getIdentifier().getNullValue();
        if (unsavedValue == null || "null".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NULL;
        } else if ("none".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NONE;
        } else if ("any".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_ANY;
        } else {
            Type idType = model.getIdentifier().getType();
            try {
                this.unsavedIdentifierValue = new Cascades.IdentifierValue(((IdentifierType)idType).stringToObject(unsavedValue));
            }
            catch (ClassCastException cce) {
                throw new MappingException("Bad identifier type: " + idType.getClass().getName());
            }
            catch (Exception e) {
                throw new MappingException("Could not parse unsaved-value: " + unsavedValue);
            }
        }
        this.versionColumnName = model.isVersioned() ? ((Column)model.getVersion().getColumnIterator().next()).getQuotedName(this.dialect) : null;
        if (model.isVersioned()) {
            this.versionPropertyName = model.getVersion().getName();
            this.versioned = true;
            this.versionGetter = ReflectHelper.getGetter(this.mappedClass, this.versionPropertyName);
            this.versionType = (VersionType)model.getVersion().getType();
        } else {
            this.versionPropertyName = null;
            this.versioned = false;
            this.versionType = null;
            this.versionGetter = null;
        }
        this.propertyTypes = new Type[this.hydrateSpan];
        this.propertyNames = new String[this.hydrateSpan];
        this.propertyUpdateability = new boolean[this.hydrateSpan];
        this.propertyInsertability = new boolean[this.hydrateSpan];
        this.getters = new ReflectHelper.Getter[this.hydrateSpan];
        this.setters = new ReflectHelper.Setter[this.hydrateSpan];
        this.cascadeStyles = new Cascades.CascadeStyle[this.hydrateSpan];
        String[] setterNames = new String[this.hydrateSpan];
        String[] getterNames = new String[this.hydrateSpan];
        Class[] types = new Class[this.hydrateSpan];
        iter = model.getPropertyClosureIterator();
        i = 0;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop == model.getVersion()) {
                tempVersionProperty = i;
            }
            this.propertyNames[i] = prop.getName();
            this.getters[i] = ReflectHelper.getGetter(this.mappedClass, this.propertyNames[i]);
            this.setters[i] = ReflectHelper.getSetter(this.mappedClass, this.propertyNames[i]);
            getterNames[i] = this.getters[i].getMethod().getName();
            setterNames[i] = this.setters[i].getMethod().getName();
            types[i] = this.getters[i].getMethod().getReturnType();
            this.propertyTypes[i] = prop.getType();
            this.propertyUpdateability[i] = prop.isUpdateable();
            this.propertyInsertability[i] = prop.isInsertable();
            this.gettersByPropertyName.put(this.propertyNames[i], this.getters[i]);
            this.settersByPropertyName.put(this.propertyNames[i], this.setters[i]);
            this.cascadeStyles[i] = prop.getCascadeStyle();
            if (this.cascadeStyles[i] != Cascades.STYLE_NONE) {
                foundCascade = true;
            }
            ++i;
        }
        this.optimizer = Environment.useReflectionOptimizer() ? ReflectHelper.getMetaClass(this.mappedClass, getterNames, setterNames, types) : null;
        this.hasCascades = foundCascade;
        this.versionProperty = tempVersionProperty;
        this.implementsLifecycle = (class$net$sf$hibernate$Lifecycle == null ? (class$net$sf$hibernate$Lifecycle = AbstractEntityPersister.class$("net.sf.hibernate.Lifecycle")) : class$net$sf$hibernate$Lifecycle).isAssignableFrom(this.mappedClass);
        this.implementsValidatable = (class$net$sf$hibernate$Validatable == null ? (class$net$sf$hibernate$Validatable = AbstractEntityPersister.class$("net.sf.hibernate.Validatable")) : class$net$sf$hibernate$Validatable).isAssignableFrom(this.mappedClass);
        this.cache = model.getCache();
        this.hasCollections = this.initHasCollections();
        Class pi = model.getProxyInterface();
        this.hasProxy = pi != null && Environment.jvmSupportsProxies();
        HashSet<Class> pis = new HashSet<Class>();
        pis.add(class$net$sf$hibernate$proxy$HibernateProxy == null ? (class$net$sf$hibernate$proxy$HibernateProxy = AbstractEntityPersister.class$("net.sf.hibernate.proxy.HibernateProxy")) : class$net$sf$hibernate$proxy$HibernateProxy);
        if (!this.mappedClass.equals(pi)) {
            pis.add(pi);
        }
        this.concreteProxyClass = pi;
        if (this.hasProxy) {
            iter = model.getSubclassIterator();
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                pi = sc.getProxyInterface();
                if (pi == null) {
                    throw new MappingException("All subclasses must also have proxies: " + this.mappedClass.getName());
                }
                if (sc.getPersistentClass().equals(pi)) continue;
                pis.add(pi);
            }
        }
        this.proxyInterfaces = pis.toArray(NO_CLASSES);
    }

    private boolean initHasCollections() {
        return this.initHasCollections(this.propertyTypes);
    }

    private boolean initHasCollections(Type[] types) {
        int i = 0;
        while (i < types.length) {
            if (types[i].isPersistentCollectionType()) {
                return true;
            }
            if (types[i].isComponentType() && this.initHasCollections(((AbstractComponentType)types[i]).getSubtypes())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ClassMetadata getClassMetadata() {
        return this;
    }

    public Class getConcreteProxyClass() {
        return this.concreteProxyClass;
    }

    public Class getMappedSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    protected boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    protected boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public Object getPropertyValue(Object object, String propertyName) throws HibernateException {
        return ((ReflectHelper.Getter)this.gettersByPropertyName.get(propertyName)).get(object);
    }

    public void setPropertyValue(Object object, String propertyName, Object value) throws HibernateException {
        ((ReflectHelper.Setter)this.settersByPropertyName.get(propertyName)).set(object, value);
    }

    protected boolean hasEmbeddedIdentifier() {
        return this.hasEmbeddedIdentifier;
    }

    public boolean[] getNotNullInsertableColumns(Object[] fields) {
        boolean[] notNull = new boolean[fields.length];
        boolean[] insertable = this.getPropertyInsertability();
        int i = 0;
        while (i < fields.length) {
            notNull[i] = insertable[i] && fields[i] != null;
            ++i;
        }
        return notNull;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

