/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.stylebook.BasicContext;
import org.apache.stylebook.BasicEntry;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.Entry;
import org.apache.stylebook.LoadingException;
import org.apache.stylebook.NodeListParameters;
import org.apache.stylebook.Parameters;
import org.apache.stylebook.Processor;
import org.apache.stylebook.Producer;
import org.apache.stylebook.ResourceEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Project {
    private Hashtable entries = new Hashtable();
    private Engine engine = null;
    private URL urlbase = null;

    public Project(Engine engine, Document document, Parameters parameters, URL uRL) throws LoadingException, IOException {
        this.engine = engine;
        this.urlbase = uRL;
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("project")) {
            throw new LoadingException("Project does not start with <project>");
        }
        NodeList nodeList = element.getChildNodes();
        Parameters parameters2 = new NodeListParameters(nodeList).merge(parameters);
        this.processNodeList(nodeList, this.urlbase, parameters2);
    }

    public void create(String string, OutputStream outputStream) throws IOException, CreationException {
        this.engine.log(this, "Creating \"" + string + "\"");
        Entry entry = (Entry)this.entries.get(string);
        if (entry == null) {
            throw new CreationException("No Entry \"" + string + "\"");
        }
        entry.create(outputStream);
    }

    public Enumeration getEntryNames() {
        return this.entries.keys();
    }

    private void processEntry(Element element, URL uRL, Parameters parameters) throws LoadingException, IOException {
        Object object;
        String string = element.getAttribute("producer");
        URL uRL2 = new URL(uRL, element.getAttribute("source"));
        BasicContext basicContext = new BasicContext(uRL2, "");
        basicContext.merge(parameters);
        this.engine.debug(this, "Processing Source=\"" + uRL2 + "\" [" + string + "]");
        Producer producer = this.engine.getProducer(string);
        if (producer == null) {
            throw new LoadingException("Invalid Producer \"" + string + "\"");
        }
        NodeList nodeList = element.getChildNodes();
        basicContext.merge(new NodeListParameters(nodeList));
        Document document = null;
        try {
            document = producer.produce(basicContext);
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n).getNodeType() == 1 && !(object = (Element)nodeList.item(n)).getTagName().equals("parameter")) {
                    if (!object.getTagName().equals("processor")) {
                        throw new LoadingException("Invalid <" + object.getTagName() + ">");
                    }
                    Processor processor = this.engine.getProcessor(object.getAttribute("name"));
                    if (processor == null) {
                        throw new LoadingException("No Processr \"" + processor + "\"");
                    }
                    Parameters parameters2 = new NodeListParameters(object.getChildNodes()).merge(basicContext);
                    document = processor.process(document, basicContext, parameters2);
                }
                ++n;
            }
        }
        catch (CreationException creationException) {
            creationException.printStackTrace(System.out);
            throw new LoadingException("Processing Entry (" + creationException.getMessage() + ")");
        }
        if (document == null) {
            return;
        }
        Element element2 = document.getDocumentElement();
        if (!element2.getTagName().equals("project")) {
            throw new LoadingException("Result of process is not <project>");
        }
        nodeList = element2.getChildNodes();
        object = new NodeListParameters(nodeList).merge(basicContext);
        this.processNodeList(nodeList, uRL2, (Parameters)object);
    }

    private void processNodeList(NodeList nodeList, URL uRL, Parameters parameters) throws LoadingException, IOException {
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element;
            String string;
            if (nodeList.item(n).getNodeType() == 1 && !(string = (element = (Element)nodeList.item(n)).getTagName()).equals("parameter")) {
                if (string.equals("create")) {
                    this.setCreateEntry(element, uRL, parameters);
                } else if (string.equals("resource")) {
                    this.setResourceEntry(element, uRL);
                } else if (string.equals("process")) {
                    this.processEntry(element, uRL, parameters);
                } else {
                    throw new LoadingException("Invalid element <" + string + ">");
                }
            }
            ++n;
        }
    }

    private void setCreateEntry(Element element, URL uRL, Parameters parameters) throws LoadingException, IOException {
        BasicEntry basicEntry;
        URL uRL2 = new URL(uRL, element.getAttribute("source"));
        String string = element.getAttribute("target");
        Entry entry = this.entries.put(string, basicEntry = new BasicEntry(this.engine, uRL2, string, element, parameters));
        if (entry != null && !entry.equals(basicEntry)) {
            throw new LoadingException("Duplicate Entry \"" + string + "\"");
        }
    }

    private void setResourceEntry(Element element, URL uRL) throws LoadingException, IOException {
        ResourceEntry resourceEntry;
        URL uRL2 = new URL(uRL, element.getAttribute("source"));
        String string = element.getAttribute("target");
        Entry entry = this.entries.put(string, resourceEntry = new ResourceEntry(this.engine, uRL2, string));
        if (entry != null && !entry.equals(resourceEntry)) {
            throw new LoadingException("Duplicate Entry \"" + string + "\"");
        }
    }
}

