# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AvailabilitySet(_serialization.Model):
    """The AvailabilitySets resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Gets or sets the location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.scvmm.models.SystemData
    :ivar extended_location: The extended location.
    :vartype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
    :ivar availability_set_name: Name of the availability set.
    :vartype availability_set_name: str
    :ivar vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
    :vartype vmm_server_id: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "availability_set_name": {"min_length": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "availability_set_name": {"key": "properties.availabilitySetName", "type": "str"},
        "vmm_server_id": {"key": "properties.vmmServerId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        availability_set_name: Optional[str] = None,
        vmm_server_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Gets or sets the location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location.
        :paramtype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
        :keyword availability_set_name: Name of the availability set.
        :paramtype availability_set_name: str
        :keyword vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
        :paramtype vmm_server_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.extended_location = extended_location
        self.availability_set_name = availability_set_name
        self.vmm_server_id = vmm_server_id
        self.provisioning_state = None


class AvailabilitySetListItem(_serialization.Model):
    """Availability Set model.

    :ivar id: Gets the ARM Id of the microsoft.scvmm/availabilitySets resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the availability set.
    :vartype name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, id: Optional[str] = None, name: Optional[str] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword id: Gets the ARM Id of the microsoft.scvmm/availabilitySets resource.
        :paramtype id: str
        :keyword name: Gets or sets the name of the availability set.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name


class AvailabilitySetListResult(_serialization.Model):
    """List of AvailabilitySets.

    :ivar value: List of AvailabilitySets.
    :vartype value: list[~azure.mgmt.scvmm.models.AvailabilitySet]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailabilitySet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AvailabilitySet"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of AvailabilitySets.
        :paramtype value: list[~azure.mgmt.scvmm.models.AvailabilitySet]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Checkpoint(_serialization.Model):
    """Defines the resource properties.

    :ivar parent_checkpoint_id: Gets ID of parent of the checkpoint.
    :vartype parent_checkpoint_id: str
    :ivar checkpoint_id: Gets ID of the checkpoint.
    :vartype checkpoint_id: str
    :ivar name: Gets name of the checkpoint.
    :vartype name: str
    :ivar description: Gets description of the checkpoint.
    :vartype description: str
    """

    _attribute_map = {
        "parent_checkpoint_id": {"key": "parentCheckpointID", "type": "str"},
        "checkpoint_id": {"key": "checkpointID", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        parent_checkpoint_id: Optional[str] = None,
        checkpoint_id: Optional[str] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword parent_checkpoint_id: Gets ID of parent of the checkpoint.
        :paramtype parent_checkpoint_id: str
        :keyword checkpoint_id: Gets ID of the checkpoint.
        :paramtype checkpoint_id: str
        :keyword name: Gets name of the checkpoint.
        :paramtype name: str
        :keyword description: Gets description of the checkpoint.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.parent_checkpoint_id = parent_checkpoint_id
        self.checkpoint_id = checkpoint_id
        self.name = name
        self.description = description


class Cloud(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The Clouds resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.scvmm.models.SystemData
    :ivar extended_location: The extended location. Required.
    :vartype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the resource.
    :vartype inventory_item_id: str
    :ivar uuid: Unique ID of the cloud.
    :vartype uuid: str
    :ivar vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
    :vartype vmm_server_id: str
    :ivar cloud_name: Name of the cloud in VMMServer.
    :vartype cloud_name: str
    :ivar cloud_capacity: Capacity of the cloud.
    :vartype cloud_capacity: ~azure.mgmt.scvmm.models.CloudCapacity
    :ivar storage_qo_s_policies: List of QoS policies available for the cloud.
    :vartype storage_qo_s_policies: list[~azure.mgmt.scvmm.models.StorageQoSPolicy]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "extended_location": {"required": True},
        "uuid": {"min_length": 1},
        "cloud_name": {"readonly": True},
        "cloud_capacity": {"readonly": True},
        "storage_qo_s_policies": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "vmm_server_id": {"key": "properties.vmmServerId", "type": "str"},
        "cloud_name": {"key": "properties.cloudName", "type": "str"},
        "cloud_capacity": {"key": "properties.cloudCapacity", "type": "CloudCapacity"},
        "storage_qo_s_policies": {"key": "properties.storageQoSPolicies", "type": "[StorageQoSPolicy]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        inventory_item_id: Optional[str] = None,
        uuid: Optional[str] = None,
        vmm_server_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location. Required.
        :paramtype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the resource.
        :paramtype inventory_item_id: str
        :keyword uuid: Unique ID of the cloud.
        :paramtype uuid: str
        :keyword vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
        :paramtype vmm_server_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.extended_location = extended_location
        self.inventory_item_id = inventory_item_id
        self.uuid = uuid
        self.vmm_server_id = vmm_server_id
        self.cloud_name = None
        self.cloud_capacity = None
        self.storage_qo_s_policies = None
        self.provisioning_state = None


class CloudCapacity(_serialization.Model):
    """Cloud Capacity model.

    :ivar cpu_count: CPUCount specifies the maximum number of CPUs that can be allocated in the
     cloud.
    :vartype cpu_count: int
    :ivar memory_mb: MemoryMB specifies a memory usage limit in megabytes.
    :vartype memory_mb: int
    :ivar vm_count: VMCount gives the max number of VMs that can be deployed in the cloud.
    :vartype vm_count: int
    """

    _attribute_map = {
        "cpu_count": {"key": "cpuCount", "type": "int"},
        "memory_mb": {"key": "memoryMB", "type": "int"},
        "vm_count": {"key": "vmCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        cpu_count: Optional[int] = None,
        memory_mb: Optional[int] = None,
        vm_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword cpu_count: CPUCount specifies the maximum number of CPUs that can be allocated in the
         cloud.
        :paramtype cpu_count: int
        :keyword memory_mb: MemoryMB specifies a memory usage limit in megabytes.
        :paramtype memory_mb: int
        :keyword vm_count: VMCount gives the max number of VMs that can be deployed in the cloud.
        :paramtype vm_count: int
        """
        super().__init__(**kwargs)
        self.cpu_count = cpu_count
        self.memory_mb = memory_mb
        self.vm_count = vm_count


class InventoryItemProperties(_serialization.Model):
    """Defines the resource properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CloudInventoryItem, VirtualMachineInventoryItem, VirtualMachineTemplateInventoryItem,
    VirtualNetworkInventoryItem

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "Cloud",
     "VirtualNetwork", "VirtualMachineTemplate", and "VirtualMachine".
    :vartype inventory_type: str or ~azure.mgmt.scvmm.models.InventoryType
    :ivar managed_resource_id: Gets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar uuid: Gets the UUID (which is assigned by VMM) for the inventory item.
    :vartype uuid: str
    :ivar inventory_item_name: Gets the Managed Object name in VMM for the inventory item.
    :vartype inventory_item_name: str
    :ivar provisioning_state: Gets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "inventory_type": {"required": True},
        "managed_resource_id": {"readonly": True},
        "uuid": {"readonly": True},
        "inventory_item_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "uuid": {"key": "uuid", "type": "str"},
        "inventory_item_name": {"key": "inventoryItemName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    _subtype_map = {
        "inventory_type": {
            "Cloud": "CloudInventoryItem",
            "VirtualMachine": "VirtualMachineInventoryItem",
            "VirtualMachineTemplate": "VirtualMachineTemplateInventoryItem",
            "VirtualNetwork": "VirtualNetworkInventoryItem",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.inventory_type: Optional[str] = None
        self.managed_resource_id = None
        self.uuid = None
        self.inventory_item_name = None
        self.provisioning_state = None


class CloudInventoryItem(InventoryItemProperties):
    """The Cloud inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "Cloud",
     "VirtualNetwork", "VirtualMachineTemplate", and "VirtualMachine".
    :vartype inventory_type: str or ~azure.mgmt.scvmm.models.InventoryType
    :ivar managed_resource_id: Gets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar uuid: Gets the UUID (which is assigned by VMM) for the inventory item.
    :vartype uuid: str
    :ivar inventory_item_name: Gets the Managed Object name in VMM for the inventory item.
    :vartype inventory_item_name: str
    :ivar provisioning_state: Gets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "inventory_type": {"required": True},
        "managed_resource_id": {"readonly": True},
        "uuid": {"readonly": True},
        "inventory_item_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "uuid": {"key": "uuid", "type": "str"},
        "inventory_item_name": {"key": "inventoryItemName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.inventory_type: str = "Cloud"


class CloudListResult(_serialization.Model):
    """List of Clouds.

    :ivar value: List of Clouds.
    :vartype value: list[~azure.mgmt.scvmm.models.Cloud]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Cloud]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Cloud"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of Clouds.
        :paramtype value: list[~azure.mgmt.scvmm.models.Cloud]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.scvmm.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorResponse(_serialization.Model):
    """Error response.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.scvmm.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs):
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.scvmm.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedLocation(_serialization.Model):
    """The extended location.

    :ivar type: The extended location type.
    :vartype type: str
    :ivar name: The extended location name.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, name: Optional[str] = None, **kwargs):
        """
        :keyword type: The extended location type.
        :paramtype type: str
        :keyword name: The extended location name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class HardwareProfile(_serialization.Model):
    """Defines the resource properties.

    :ivar memory_mb: MemoryMB is the size of a virtual machine's memory, in MB.
    :vartype memory_mb: int
    :ivar cpu_count: Gets or sets the number of vCPUs for the vm.
    :vartype cpu_count: int
    :ivar limit_cpu_for_migration: Gets or sets a value indicating whether to enable processor
     compatibility mode for live migration of VMs. Known values are: "false" and "true".
    :vartype limit_cpu_for_migration: str or ~azure.mgmt.scvmm.models.LimitCpuForMigration
    :ivar dynamic_memory_enabled: Gets or sets a value indicating whether to enable dynamic memory
     or not. Known values are: "false" and "true".
    :vartype dynamic_memory_enabled: str or ~azure.mgmt.scvmm.models.DynamicMemoryEnabled
    :ivar dynamic_memory_max_mb: Gets or sets the max dynamic memory for the vm.
    :vartype dynamic_memory_max_mb: int
    :ivar dynamic_memory_min_mb: Gets or sets the min dynamic memory for the vm.
    :vartype dynamic_memory_min_mb: int
    :ivar is_highly_available: Gets highly available property.
    :vartype is_highly_available: str
    """

    _attribute_map = {
        "memory_mb": {"key": "memoryMB", "type": "int"},
        "cpu_count": {"key": "cpuCount", "type": "int"},
        "limit_cpu_for_migration": {"key": "limitCpuForMigration", "type": "str"},
        "dynamic_memory_enabled": {"key": "dynamicMemoryEnabled", "type": "str"},
        "dynamic_memory_max_mb": {"key": "dynamicMemoryMaxMB", "type": "int"},
        "dynamic_memory_min_mb": {"key": "dynamicMemoryMinMB", "type": "int"},
        "is_highly_available": {"key": "isHighlyAvailable", "type": "str"},
    }

    def __init__(
        self,
        *,
        memory_mb: Optional[int] = None,
        cpu_count: Optional[int] = None,
        limit_cpu_for_migration: Optional[Union[str, "_models.LimitCpuForMigration"]] = None,
        dynamic_memory_enabled: Optional[Union[str, "_models.DynamicMemoryEnabled"]] = None,
        dynamic_memory_max_mb: Optional[int] = None,
        dynamic_memory_min_mb: Optional[int] = None,
        is_highly_available: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword memory_mb: MemoryMB is the size of a virtual machine's memory, in MB.
        :paramtype memory_mb: int
        :keyword cpu_count: Gets or sets the number of vCPUs for the vm.
        :paramtype cpu_count: int
        :keyword limit_cpu_for_migration: Gets or sets a value indicating whether to enable processor
         compatibility mode for live migration of VMs. Known values are: "false" and "true".
        :paramtype limit_cpu_for_migration: str or ~azure.mgmt.scvmm.models.LimitCpuForMigration
        :keyword dynamic_memory_enabled: Gets or sets a value indicating whether to enable dynamic
         memory or not. Known values are: "false" and "true".
        :paramtype dynamic_memory_enabled: str or ~azure.mgmt.scvmm.models.DynamicMemoryEnabled
        :keyword dynamic_memory_max_mb: Gets or sets the max dynamic memory for the vm.
        :paramtype dynamic_memory_max_mb: int
        :keyword dynamic_memory_min_mb: Gets or sets the min dynamic memory for the vm.
        :paramtype dynamic_memory_min_mb: int
        :keyword is_highly_available: Gets highly available property.
        :paramtype is_highly_available: str
        """
        super().__init__(**kwargs)
        self.memory_mb = memory_mb
        self.cpu_count = cpu_count
        self.limit_cpu_for_migration = limit_cpu_for_migration
        self.dynamic_memory_enabled = dynamic_memory_enabled
        self.dynamic_memory_max_mb = dynamic_memory_max_mb
        self.dynamic_memory_min_mb = dynamic_memory_min_mb
        self.is_highly_available = is_highly_available


class HardwareProfileUpdate(_serialization.Model):
    """Defines the resource properties.

    :ivar memory_mb: MemoryMB is the size of a virtual machine's memory, in MB.
    :vartype memory_mb: int
    :ivar cpu_count: Gets or sets the number of vCPUs for the vm.
    :vartype cpu_count: int
    :ivar limit_cpu_for_migration: Gets or sets a value indicating whether to enable processor
     compatibility mode for live migration of VMs. Known values are: "false" and "true".
    :vartype limit_cpu_for_migration: str or ~azure.mgmt.scvmm.models.LimitCpuForMigration
    :ivar dynamic_memory_enabled: Gets or sets a value indicating whether to enable dynamic memory
     or not. Known values are: "false" and "true".
    :vartype dynamic_memory_enabled: str or ~azure.mgmt.scvmm.models.DynamicMemoryEnabled
    :ivar dynamic_memory_max_mb: Gets or sets the max dynamic memory for the vm.
    :vartype dynamic_memory_max_mb: int
    :ivar dynamic_memory_min_mb: Gets or sets the min dynamic memory for the vm.
    :vartype dynamic_memory_min_mb: int
    """

    _attribute_map = {
        "memory_mb": {"key": "memoryMB", "type": "int"},
        "cpu_count": {"key": "cpuCount", "type": "int"},
        "limit_cpu_for_migration": {"key": "limitCpuForMigration", "type": "str"},
        "dynamic_memory_enabled": {"key": "dynamicMemoryEnabled", "type": "str"},
        "dynamic_memory_max_mb": {"key": "dynamicMemoryMaxMB", "type": "int"},
        "dynamic_memory_min_mb": {"key": "dynamicMemoryMinMB", "type": "int"},
    }

    def __init__(
        self,
        *,
        memory_mb: Optional[int] = None,
        cpu_count: Optional[int] = None,
        limit_cpu_for_migration: Optional[Union[str, "_models.LimitCpuForMigration"]] = None,
        dynamic_memory_enabled: Optional[Union[str, "_models.DynamicMemoryEnabled"]] = None,
        dynamic_memory_max_mb: Optional[int] = None,
        dynamic_memory_min_mb: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword memory_mb: MemoryMB is the size of a virtual machine's memory, in MB.
        :paramtype memory_mb: int
        :keyword cpu_count: Gets or sets the number of vCPUs for the vm.
        :paramtype cpu_count: int
        :keyword limit_cpu_for_migration: Gets or sets a value indicating whether to enable processor
         compatibility mode for live migration of VMs. Known values are: "false" and "true".
        :paramtype limit_cpu_for_migration: str or ~azure.mgmt.scvmm.models.LimitCpuForMigration
        :keyword dynamic_memory_enabled: Gets or sets a value indicating whether to enable dynamic
         memory or not. Known values are: "false" and "true".
        :paramtype dynamic_memory_enabled: str or ~azure.mgmt.scvmm.models.DynamicMemoryEnabled
        :keyword dynamic_memory_max_mb: Gets or sets the max dynamic memory for the vm.
        :paramtype dynamic_memory_max_mb: int
        :keyword dynamic_memory_min_mb: Gets or sets the min dynamic memory for the vm.
        :paramtype dynamic_memory_min_mb: int
        """
        super().__init__(**kwargs)
        self.memory_mb = memory_mb
        self.cpu_count = cpu_count
        self.limit_cpu_for_migration = limit_cpu_for_migration
        self.dynamic_memory_enabled = dynamic_memory_enabled
        self.dynamic_memory_max_mb = dynamic_memory_max_mb
        self.dynamic_memory_min_mb = dynamic_memory_min_mb


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class InventoryItem(ProxyResource):
    """Defines the inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.scvmm.models.SystemData
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar inventory_type: They inventory type. Required. Known values are: "Cloud",
     "VirtualNetwork", "VirtualMachineTemplate", and "VirtualMachine".
    :vartype inventory_type: str or ~azure.mgmt.scvmm.models.InventoryType
    :ivar managed_resource_id: Gets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar uuid: Gets the UUID (which is assigned by VMM) for the inventory item.
    :vartype uuid: str
    :ivar inventory_item_name: Gets the Managed Object name in VMM for the inventory item.
    :vartype inventory_item_name: str
    :ivar provisioning_state: Gets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "inventory_type": {"required": True},
        "managed_resource_id": {"readonly": True},
        "uuid": {"readonly": True},
        "inventory_item_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "inventory_type": {"key": "properties.inventoryType", "type": "str"},
        "managed_resource_id": {"key": "properties.managedResourceId", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "inventory_item_name": {"key": "properties.inventoryItemName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs):
        """
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
         the resource provider must validate and persist this value.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.kind = kind
        self.inventory_type: Optional[str] = None
        self.managed_resource_id = None
        self.uuid = None
        self.inventory_item_name = None
        self.provisioning_state = None


class InventoryItemDetails(_serialization.Model):
    """Defines the resource properties.

    :ivar inventory_item_id: Gets or sets the inventory Item ID for the resource.
    :vartype inventory_item_id: str
    :ivar inventory_item_name: Gets or sets the Managed Object name in VMM for the resource.
    :vartype inventory_item_name: str
    """

    _attribute_map = {
        "inventory_item_id": {"key": "inventoryItemId", "type": "str"},
        "inventory_item_name": {"key": "inventoryItemName", "type": "str"},
    }

    def __init__(self, *, inventory_item_id: Optional[str] = None, inventory_item_name: Optional[str] = None, **kwargs):
        """
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the resource.
        :paramtype inventory_item_id: str
        :keyword inventory_item_name: Gets or sets the Managed Object name in VMM for the resource.
        :paramtype inventory_item_name: str
        """
        super().__init__(**kwargs)
        self.inventory_item_id = inventory_item_id
        self.inventory_item_name = inventory_item_name


class InventoryItemsList(_serialization.Model):
    """List of InventoryItems.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of InventoryItems.
    :vartype next_link: str
    :ivar value: Array of InventoryItems. Required.
    :vartype value: list[~azure.mgmt.scvmm.models.InventoryItem]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[InventoryItem]"},
    }

    def __init__(self, *, value: List["_models.InventoryItem"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: Url to follow for getting next page of InventoryItems.
        :paramtype next_link: str
        :keyword value: Array of InventoryItems. Required.
        :paramtype value: list[~azure.mgmt.scvmm.models.InventoryItem]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class NetworkInterfaces(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Network Interface model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets or sets the name of the network interface.
    :vartype name: str
    :ivar display_name: Gets the display name of the network interface as shown in the vmmServer.
     This is the fallback label for a NIC when the name is not set.
    :vartype display_name: str
    :ivar ipv4_addresses: Gets or sets the nic ipv4 addresses.
    :vartype ipv4_addresses: list[str]
    :ivar ipv6_addresses: Gets or sets the nic ipv6 addresses.
    :vartype ipv6_addresses: list[str]
    :ivar mac_address: Gets or sets the nic MAC address.
    :vartype mac_address: str
    :ivar virtual_network_id: Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork
     resource to connect the nic.
    :vartype virtual_network_id: str
    :ivar network_name: Gets or sets the name of the virtual network in vmmServer that the nic is
     connected to.
    :vartype network_name: str
    :ivar ipv4_address_type: Gets or sets the ipv4 address type. Known values are: "Dynamic" and
     "Static".
    :vartype ipv4_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
    :ivar ipv6_address_type: Gets or sets the ipv6 address type. Known values are: "Dynamic" and
     "Static".
    :vartype ipv6_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
    :ivar mac_address_type: Gets or sets the mac address type. Known values are: "Dynamic" and
     "Static".
    :vartype mac_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
    :ivar nic_id: Gets or sets the nic id.
    :vartype nic_id: str
    """

    _validation = {
        "display_name": {"readonly": True},
        "ipv4_addresses": {"readonly": True},
        "ipv6_addresses": {"readonly": True},
        "network_name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "ipv4_addresses": {"key": "ipv4Addresses", "type": "[str]"},
        "ipv6_addresses": {"key": "ipv6Addresses", "type": "[str]"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "virtual_network_id": {"key": "virtualNetworkId", "type": "str"},
        "network_name": {"key": "networkName", "type": "str"},
        "ipv4_address_type": {"key": "ipv4AddressType", "type": "str"},
        "ipv6_address_type": {"key": "ipv6AddressType", "type": "str"},
        "mac_address_type": {"key": "macAddressType", "type": "str"},
        "nic_id": {"key": "nicId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        mac_address: Optional[str] = None,
        virtual_network_id: Optional[str] = None,
        ipv4_address_type: Optional[Union[str, "_models.AllocationMethod"]] = None,
        ipv6_address_type: Optional[Union[str, "_models.AllocationMethod"]] = None,
        mac_address_type: Optional[Union[str, "_models.AllocationMethod"]] = None,
        nic_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Gets or sets the name of the network interface.
        :paramtype name: str
        :keyword mac_address: Gets or sets the nic MAC address.
        :paramtype mac_address: str
        :keyword virtual_network_id: Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork
         resource to connect the nic.
        :paramtype virtual_network_id: str
        :keyword ipv4_address_type: Gets or sets the ipv4 address type. Known values are: "Dynamic" and
         "Static".
        :paramtype ipv4_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
        :keyword ipv6_address_type: Gets or sets the ipv6 address type. Known values are: "Dynamic" and
         "Static".
        :paramtype ipv6_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
        :keyword mac_address_type: Gets or sets the mac address type. Known values are: "Dynamic" and
         "Static".
        :paramtype mac_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
        :keyword nic_id: Gets or sets the nic id.
        :paramtype nic_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = None
        self.ipv4_addresses = None
        self.ipv6_addresses = None
        self.mac_address = mac_address
        self.virtual_network_id = virtual_network_id
        self.network_name = None
        self.ipv4_address_type = ipv4_address_type
        self.ipv6_address_type = ipv6_address_type
        self.mac_address_type = mac_address_type
        self.nic_id = nic_id


class NetworkInterfacesUpdate(_serialization.Model):
    """Network Interface model.

    :ivar name: Gets or sets the name of the network interface.
    :vartype name: str
    :ivar mac_address: Gets or sets the nic MAC address.
    :vartype mac_address: str
    :ivar virtual_network_id: Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork
     resource to connect the nic.
    :vartype virtual_network_id: str
    :ivar ipv4_address_type: Gets or sets the ipv4 address type. Known values are: "Dynamic" and
     "Static".
    :vartype ipv4_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
    :ivar ipv6_address_type: Gets or sets the ipv6 address type. Known values are: "Dynamic" and
     "Static".
    :vartype ipv6_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
    :ivar mac_address_type: Gets or sets the mac address type. Known values are: "Dynamic" and
     "Static".
    :vartype mac_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
    :ivar nic_id: Gets or sets the nic id.
    :vartype nic_id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "virtual_network_id": {"key": "virtualNetworkId", "type": "str"},
        "ipv4_address_type": {"key": "ipv4AddressType", "type": "str"},
        "ipv6_address_type": {"key": "ipv6AddressType", "type": "str"},
        "mac_address_type": {"key": "macAddressType", "type": "str"},
        "nic_id": {"key": "nicId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        mac_address: Optional[str] = None,
        virtual_network_id: Optional[str] = None,
        ipv4_address_type: Optional[Union[str, "_models.AllocationMethod"]] = None,
        ipv6_address_type: Optional[Union[str, "_models.AllocationMethod"]] = None,
        mac_address_type: Optional[Union[str, "_models.AllocationMethod"]] = None,
        nic_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Gets or sets the name of the network interface.
        :paramtype name: str
        :keyword mac_address: Gets or sets the nic MAC address.
        :paramtype mac_address: str
        :keyword virtual_network_id: Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork
         resource to connect the nic.
        :paramtype virtual_network_id: str
        :keyword ipv4_address_type: Gets or sets the ipv4 address type. Known values are: "Dynamic" and
         "Static".
        :paramtype ipv4_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
        :keyword ipv6_address_type: Gets or sets the ipv6 address type. Known values are: "Dynamic" and
         "Static".
        :paramtype ipv6_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
        :keyword mac_address_type: Gets or sets the mac address type. Known values are: "Dynamic" and
         "Static".
        :paramtype mac_address_type: str or ~azure.mgmt.scvmm.models.AllocationMethod
        :keyword nic_id: Gets or sets the nic id.
        :paramtype nic_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.mac_address = mac_address
        self.virtual_network_id = virtual_network_id
        self.ipv4_address_type = ipv4_address_type
        self.ipv6_address_type = ipv6_address_type
        self.mac_address_type = mac_address_type
        self.nic_id = nic_id


class NetworkProfile(_serialization.Model):
    """Defines the resource properties.

    :ivar network_interfaces: Gets or sets the list of network interfaces associated with the
     virtual machine.
    :vartype network_interfaces: list[~azure.mgmt.scvmm.models.NetworkInterfaces]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaces]"},
    }

    def __init__(self, *, network_interfaces: Optional[List["_models.NetworkInterfaces"]] = None, **kwargs):
        """
        :keyword network_interfaces: Gets or sets the list of network interfaces associated with the
         virtual machine.
        :paramtype network_interfaces: list[~azure.mgmt.scvmm.models.NetworkInterfaces]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class NetworkProfileUpdate(_serialization.Model):
    """Defines the resource properties.

    :ivar network_interfaces: Gets or sets the list of network interfaces associated with the
     virtual machine.
    :vartype network_interfaces: list[~azure.mgmt.scvmm.models.NetworkInterfacesUpdate]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfacesUpdate]"},
    }

    def __init__(self, *, network_interfaces: Optional[List["_models.NetworkInterfacesUpdate"]] = None, **kwargs):
        """
        :keyword network_interfaces: Gets or sets the list of network interfaces associated with the
         virtual machine.
        :paramtype network_interfaces: list[~azure.mgmt.scvmm.models.NetworkInterfacesUpdate]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class OsProfile(_serialization.Model):
    """Defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar admin_password: Admin password of the virtual machine.
    :vartype admin_password: str
    :ivar computer_name: Gets or sets computer name.
    :vartype computer_name: str
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.scvmm.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    """

    _validation = {
        "os_type": {"readonly": True},
        "os_name": {"readonly": True},
    }

    _attribute_map = {
        "admin_password": {"key": "adminPassword", "type": "str"},
        "computer_name": {"key": "computerName", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
    }

    def __init__(self, *, admin_password: Optional[str] = None, computer_name: Optional[str] = None, **kwargs):
        """
        :keyword admin_password: Admin password of the virtual machine.
        :paramtype admin_password: str
        :keyword computer_name: Gets or sets computer name.
        :paramtype computer_name: str
        """
        super().__init__(**kwargs)
        self.admin_password = admin_password
        self.computer_name = computer_name
        self.os_type = None
        self.os_name = None


class ResourcePatch(_serialization.Model):
    """Object containing tags updates for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ResourceProviderOperation(_serialization.Model):
    """Results of the request to list operations.

    :ivar is_data_action: Indicates whether the operation applies to data-plane.
    :vartype is_data_action: str
    :ivar name: Operation name, in format of {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.scvmm.models.ResourceProviderOperationDisplay
    """

    _attribute_map = {
        "is_data_action": {"key": "isDataAction", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "ResourceProviderOperationDisplay"},
    }

    def __init__(
        self,
        *,
        is_data_action: Optional[str] = None,
        name: Optional[str] = None,
        display: Optional["_models.ResourceProviderOperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword is_data_action: Indicates whether the operation applies to data-plane.
        :paramtype is_data_action: str
        :keyword name: Operation name, in format of {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.scvmm.models.ResourceProviderOperationDisplay
        """
        super().__init__(**kwargs)
        self.is_data_action = is_data_action
        self.name = name
        self.display = display


class ResourceProviderOperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: The resource provider.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Type of operation: read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of this operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The resource provider.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Type of operation: read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of this operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(_serialization.Model):
    """Results of the request to list operations.

    :ivar value: List of Operations.
    :vartype value: list[~azure.mgmt.scvmm.models.ResourceProviderOperation]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceProviderOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ResourceProviderOperation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of Operations.
        :paramtype value: list[~azure.mgmt.scvmm.models.ResourceProviderOperation]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class StopVirtualMachineOptions(_serialization.Model):
    """Defines the stop action properties.

    :ivar skip_shutdown: Gets or sets a value indicating whether to request non-graceful VM
     shutdown. True value for this flag indicates non-graceful shutdown whereas false indicates
     otherwise. Defaults to false.
    :vartype skip_shutdown: bool
    """

    _attribute_map = {
        "skip_shutdown": {"key": "skipShutdown", "type": "bool"},
    }

    def __init__(self, *, skip_shutdown: bool = False, **kwargs):
        """
        :keyword skip_shutdown: Gets or sets a value indicating whether to request non-graceful VM
         shutdown. True value for this flag indicates non-graceful shutdown whereas false indicates
         otherwise. Defaults to false.
        :paramtype skip_shutdown: bool
        """
        super().__init__(**kwargs)
        self.skip_shutdown = skip_shutdown


class StorageProfile(_serialization.Model):
    """Defines the resource properties.

    :ivar disks: Gets or sets the list of virtual disks associated with the virtual machine.
    :vartype disks: list[~azure.mgmt.scvmm.models.VirtualDisk]
    """

    _attribute_map = {
        "disks": {"key": "disks", "type": "[VirtualDisk]"},
    }

    def __init__(self, *, disks: Optional[List["_models.VirtualDisk"]] = None, **kwargs):
        """
        :keyword disks: Gets or sets the list of virtual disks associated with the virtual machine.
        :paramtype disks: list[~azure.mgmt.scvmm.models.VirtualDisk]
        """
        super().__init__(**kwargs)
        self.disks = disks


class StorageProfileUpdate(_serialization.Model):
    """Defines the resource properties.

    :ivar disks: Gets or sets the list of virtual disks associated with the virtual machine.
    :vartype disks: list[~azure.mgmt.scvmm.models.VirtualDiskUpdate]
    """

    _attribute_map = {
        "disks": {"key": "disks", "type": "[VirtualDiskUpdate]"},
    }

    def __init__(self, *, disks: Optional[List["_models.VirtualDiskUpdate"]] = None, **kwargs):
        """
        :keyword disks: Gets or sets the list of virtual disks associated with the virtual machine.
        :paramtype disks: list[~azure.mgmt.scvmm.models.VirtualDiskUpdate]
        """
        super().__init__(**kwargs)
        self.disks = disks


class StorageQoSPolicy(_serialization.Model):
    """The StorageQoSPolicy definition.

    :ivar name: The name of the policy.
    :vartype name: str
    :ivar id: The ID of the QoS policy.
    :vartype id: str
    :ivar iops_maximum: The maximum IO operations per second.
    :vartype iops_maximum: int
    :ivar iops_minimum: The minimum IO operations per second.
    :vartype iops_minimum: int
    :ivar bandwidth_limit: The Bandwidth Limit for internet traffic.
    :vartype bandwidth_limit: int
    :ivar policy_id: The underlying policy.
    :vartype policy_id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "iops_maximum": {"key": "iopsMaximum", "type": "int"},
        "iops_minimum": {"key": "iopsMinimum", "type": "int"},
        "bandwidth_limit": {"key": "bandwidthLimit", "type": "int"},
        "policy_id": {"key": "policyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        iops_maximum: Optional[int] = None,
        iops_minimum: Optional[int] = None,
        bandwidth_limit: Optional[int] = None,
        policy_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the policy.
        :paramtype name: str
        :keyword id: The ID of the QoS policy.
        :paramtype id: str
        :keyword iops_maximum: The maximum IO operations per second.
        :paramtype iops_maximum: int
        :keyword iops_minimum: The minimum IO operations per second.
        :paramtype iops_minimum: int
        :keyword bandwidth_limit: The Bandwidth Limit for internet traffic.
        :paramtype bandwidth_limit: int
        :keyword policy_id: The underlying policy.
        :paramtype policy_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.iops_maximum = iops_maximum
        self.iops_minimum = iops_minimum
        self.bandwidth_limit = bandwidth_limit
        self.policy_id = policy_id


class StorageQoSPolicyDetails(_serialization.Model):
    """The StorageQoSPolicyDetails definition.

    :ivar name: The name of the policy.
    :vartype name: str
    :ivar id: The ID of the QoS policy.
    :vartype id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, id: Optional[str] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword name: The name of the policy.
        :paramtype name: str
        :keyword id: The ID of the QoS policy.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.scvmm.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.scvmm.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.scvmm.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.scvmm.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class VirtualDisk(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Virtual disk model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets or sets the name of the disk.
    :vartype name: str
    :ivar display_name: Gets the display name of the virtual disk as shown in the vmmServer. This
     is the fallback label for a disk when the name is not set.
    :vartype display_name: str
    :ivar disk_id: Gets or sets the disk id.
    :vartype disk_id: str
    :ivar disk_size_gb: Gets or sets the disk total size.
    :vartype disk_size_gb: int
    :ivar max_disk_size_gb: Gets or sets the max disk size.
    :vartype max_disk_size_gb: int
    :ivar bus: Gets or sets the disk bus.
    :vartype bus: int
    :ivar lun: Gets or sets the disk lun.
    :vartype lun: int
    :ivar bus_type: Gets or sets the disk bus type.
    :vartype bus_type: str
    :ivar vhd_type: Gets or sets the disk vhd type.
    :vartype vhd_type: str
    :ivar volume_type: Gets or sets the disk volume type.
    :vartype volume_type: str
    :ivar vhd_format_type: Gets the disk vhd format type.
    :vartype vhd_format_type: str
    :ivar template_disk_id: Gets or sets the disk id in the template.
    :vartype template_disk_id: str
    :ivar storage_qo_s_policy: The QoS policy for the disk.
    :vartype storage_qo_s_policy: ~azure.mgmt.scvmm.models.StorageQoSPolicyDetails
    :ivar create_diff_disk: Gets or sets a value indicating diff disk. Known values are: "false"
     and "true".
    :vartype create_diff_disk: str or ~azure.mgmt.scvmm.models.CreateDiffDisk
    """

    _validation = {
        "display_name": {"readonly": True},
        "max_disk_size_gb": {"readonly": True},
        "volume_type": {"readonly": True},
        "vhd_format_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "max_disk_size_gb": {"key": "maxDiskSizeGB", "type": "int"},
        "bus": {"key": "bus", "type": "int"},
        "lun": {"key": "lun", "type": "int"},
        "bus_type": {"key": "busType", "type": "str"},
        "vhd_type": {"key": "vhdType", "type": "str"},
        "volume_type": {"key": "volumeType", "type": "str"},
        "vhd_format_type": {"key": "vhdFormatType", "type": "str"},
        "template_disk_id": {"key": "templateDiskId", "type": "str"},
        "storage_qo_s_policy": {"key": "storageQoSPolicy", "type": "StorageQoSPolicyDetails"},
        "create_diff_disk": {"key": "createDiffDisk", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disk_id: Optional[str] = None,
        disk_size_gb: Optional[int] = None,
        bus: Optional[int] = None,
        lun: Optional[int] = None,
        bus_type: Optional[str] = None,
        vhd_type: Optional[str] = None,
        template_disk_id: Optional[str] = None,
        storage_qo_s_policy: Optional["_models.StorageQoSPolicyDetails"] = None,
        create_diff_disk: Optional[Union[str, "_models.CreateDiffDisk"]] = None,
        **kwargs
    ):
        """
        :keyword name: Gets or sets the name of the disk.
        :paramtype name: str
        :keyword disk_id: Gets or sets the disk id.
        :paramtype disk_id: str
        :keyword disk_size_gb: Gets or sets the disk total size.
        :paramtype disk_size_gb: int
        :keyword bus: Gets or sets the disk bus.
        :paramtype bus: int
        :keyword lun: Gets or sets the disk lun.
        :paramtype lun: int
        :keyword bus_type: Gets or sets the disk bus type.
        :paramtype bus_type: str
        :keyword vhd_type: Gets or sets the disk vhd type.
        :paramtype vhd_type: str
        :keyword template_disk_id: Gets or sets the disk id in the template.
        :paramtype template_disk_id: str
        :keyword storage_qo_s_policy: The QoS policy for the disk.
        :paramtype storage_qo_s_policy: ~azure.mgmt.scvmm.models.StorageQoSPolicyDetails
        :keyword create_diff_disk: Gets or sets a value indicating diff disk. Known values are: "false"
         and "true".
        :paramtype create_diff_disk: str or ~azure.mgmt.scvmm.models.CreateDiffDisk
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = None
        self.disk_id = disk_id
        self.disk_size_gb = disk_size_gb
        self.max_disk_size_gb = None
        self.bus = bus
        self.lun = lun
        self.bus_type = bus_type
        self.vhd_type = vhd_type
        self.volume_type = None
        self.vhd_format_type = None
        self.template_disk_id = template_disk_id
        self.storage_qo_s_policy = storage_qo_s_policy
        self.create_diff_disk = create_diff_disk


class VirtualDiskUpdate(_serialization.Model):
    """Virtual disk model.

    :ivar name: Gets or sets the name of the disk.
    :vartype name: str
    :ivar disk_id: Gets or sets the disk id.
    :vartype disk_id: str
    :ivar disk_size_gb: Gets or sets the disk total size.
    :vartype disk_size_gb: int
    :ivar bus: Gets or sets the disk bus.
    :vartype bus: int
    :ivar lun: Gets or sets the disk lun.
    :vartype lun: int
    :ivar bus_type: Gets or sets the disk bus type.
    :vartype bus_type: str
    :ivar vhd_type: Gets or sets the disk vhd type.
    :vartype vhd_type: str
    :ivar storage_qo_s_policy: The QoS policy for the disk.
    :vartype storage_qo_s_policy: ~azure.mgmt.scvmm.models.StorageQoSPolicyDetails
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "bus": {"key": "bus", "type": "int"},
        "lun": {"key": "lun", "type": "int"},
        "bus_type": {"key": "busType", "type": "str"},
        "vhd_type": {"key": "vhdType", "type": "str"},
        "storage_qo_s_policy": {"key": "storageQoSPolicy", "type": "StorageQoSPolicyDetails"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disk_id: Optional[str] = None,
        disk_size_gb: Optional[int] = None,
        bus: Optional[int] = None,
        lun: Optional[int] = None,
        bus_type: Optional[str] = None,
        vhd_type: Optional[str] = None,
        storage_qo_s_policy: Optional["_models.StorageQoSPolicyDetails"] = None,
        **kwargs
    ):
        """
        :keyword name: Gets or sets the name of the disk.
        :paramtype name: str
        :keyword disk_id: Gets or sets the disk id.
        :paramtype disk_id: str
        :keyword disk_size_gb: Gets or sets the disk total size.
        :paramtype disk_size_gb: int
        :keyword bus: Gets or sets the disk bus.
        :paramtype bus: int
        :keyword lun: Gets or sets the disk lun.
        :paramtype lun: int
        :keyword bus_type: Gets or sets the disk bus type.
        :paramtype bus_type: str
        :keyword vhd_type: Gets or sets the disk vhd type.
        :paramtype vhd_type: str
        :keyword storage_qo_s_policy: The QoS policy for the disk.
        :paramtype storage_qo_s_policy: ~azure.mgmt.scvmm.models.StorageQoSPolicyDetails
        """
        super().__init__(**kwargs)
        self.name = name
        self.disk_id = disk_id
        self.disk_size_gb = disk_size_gb
        self.bus = bus
        self.lun = lun
        self.bus_type = bus_type
        self.vhd_type = vhd_type
        self.storage_qo_s_policy = storage_qo_s_policy


class VirtualMachine(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The VirtualMachines resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.scvmm.models.SystemData
    :ivar extended_location: The extended location. Required.
    :vartype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the resource.
    :vartype inventory_item_id: str
    :ivar vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
    :vartype vmm_server_id: str
    :ivar cloud_id: ARM Id of the cloud resource to use for deploying the vm.
    :vartype cloud_id: str
    :ivar template_id: ARM Id of the template resource to use for deploying the vm.
    :vartype template_id: str
    :ivar checkpoint_type: Type of checkpoint supported for the vm.
    :vartype checkpoint_type: str
    :ivar checkpoints: Checkpoints in the vm.
    :vartype checkpoints: list[~azure.mgmt.scvmm.models.Checkpoint]
    :ivar availability_sets: Availability Sets in vm.
    :vartype availability_sets: list[~azure.mgmt.scvmm.models.AvailabilitySetListItem]
    :ivar os_profile: OS properties.
    :vartype os_profile: ~azure.mgmt.scvmm.models.OsProfile
    :ivar hardware_profile: Hardware properties.
    :vartype hardware_profile: ~azure.mgmt.scvmm.models.HardwareProfile
    :ivar network_profile: Network properties.
    :vartype network_profile: ~azure.mgmt.scvmm.models.NetworkProfile
    :ivar storage_profile: Storage properties.
    :vartype storage_profile: ~azure.mgmt.scvmm.models.StorageProfile
    :ivar vm_name: VMName is the name of VM on the SCVMM server.
    :vartype vm_name: str
    :ivar uuid: Unique ID of the virtual machine.
    :vartype uuid: str
    :ivar generation: Gets or sets the generation for the vm.
    :vartype generation: int
    :ivar power_state: Gets the power state of the virtual machine.
    :vartype power_state: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "extended_location": {"required": True},
        "vm_name": {"min_length": 1},
        "power_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "vmm_server_id": {"key": "properties.vmmServerId", "type": "str"},
        "cloud_id": {"key": "properties.cloudId", "type": "str"},
        "template_id": {"key": "properties.templateId", "type": "str"},
        "checkpoint_type": {"key": "properties.checkpointType", "type": "str"},
        "checkpoints": {"key": "properties.checkpoints", "type": "[Checkpoint]"},
        "availability_sets": {"key": "properties.availabilitySets", "type": "[AvailabilitySetListItem]"},
        "os_profile": {"key": "properties.osProfile", "type": "OsProfile"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "vm_name": {"key": "properties.vmName", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "generation": {"key": "properties.generation", "type": "int"},
        "power_state": {"key": "properties.powerState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        inventory_item_id: Optional[str] = None,
        vmm_server_id: Optional[str] = None,
        cloud_id: Optional[str] = None,
        template_id: Optional[str] = None,
        checkpoint_type: Optional[str] = None,
        checkpoints: Optional[List["_models.Checkpoint"]] = None,
        availability_sets: Optional[List["_models.AvailabilitySetListItem"]] = None,
        os_profile: Optional["_models.OsProfile"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        vm_name: Optional[str] = None,
        uuid: Optional[str] = None,
        generation: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location. Required.
        :paramtype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the resource.
        :paramtype inventory_item_id: str
        :keyword vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
        :paramtype vmm_server_id: str
        :keyword cloud_id: ARM Id of the cloud resource to use for deploying the vm.
        :paramtype cloud_id: str
        :keyword template_id: ARM Id of the template resource to use for deploying the vm.
        :paramtype template_id: str
        :keyword checkpoint_type: Type of checkpoint supported for the vm.
        :paramtype checkpoint_type: str
        :keyword checkpoints: Checkpoints in the vm.
        :paramtype checkpoints: list[~azure.mgmt.scvmm.models.Checkpoint]
        :keyword availability_sets: Availability Sets in vm.
        :paramtype availability_sets: list[~azure.mgmt.scvmm.models.AvailabilitySetListItem]
        :keyword os_profile: OS properties.
        :paramtype os_profile: ~azure.mgmt.scvmm.models.OsProfile
        :keyword hardware_profile: Hardware properties.
        :paramtype hardware_profile: ~azure.mgmt.scvmm.models.HardwareProfile
        :keyword network_profile: Network properties.
        :paramtype network_profile: ~azure.mgmt.scvmm.models.NetworkProfile
        :keyword storage_profile: Storage properties.
        :paramtype storage_profile: ~azure.mgmt.scvmm.models.StorageProfile
        :keyword vm_name: VMName is the name of VM on the SCVMM server.
        :paramtype vm_name: str
        :keyword uuid: Unique ID of the virtual machine.
        :paramtype uuid: str
        :keyword generation: Gets or sets the generation for the vm.
        :paramtype generation: int
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.extended_location = extended_location
        self.inventory_item_id = inventory_item_id
        self.vmm_server_id = vmm_server_id
        self.cloud_id = cloud_id
        self.template_id = template_id
        self.checkpoint_type = checkpoint_type
        self.checkpoints = checkpoints
        self.availability_sets = availability_sets
        self.os_profile = os_profile
        self.hardware_profile = hardware_profile
        self.network_profile = network_profile
        self.storage_profile = storage_profile
        self.vm_name = vm_name
        self.uuid = uuid
        self.generation = generation
        self.power_state = None
        self.provisioning_state = None


class VirtualMachineCreateCheckpoint(_serialization.Model):
    """Defines the create checkpoint action properties.

    :ivar name: Name of the checkpoint.
    :vartype name: str
    :ivar description: Description of the checkpoint.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the checkpoint.
        :paramtype name: str
        :keyword description: Description of the checkpoint.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description


class VirtualMachineDeleteCheckpoint(_serialization.Model):
    """Defines the delete checkpoint action properties.

    :ivar id: ID of the checkpoint to be deleted.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: ID of the checkpoint to be deleted.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualMachineInventoryItem(InventoryItemProperties):
    """The Virtual machine inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "Cloud",
     "VirtualNetwork", "VirtualMachineTemplate", and "VirtualMachine".
    :vartype inventory_type: str or ~azure.mgmt.scvmm.models.InventoryType
    :ivar managed_resource_id: Gets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar uuid: Gets the UUID (which is assigned by VMM) for the inventory item.
    :vartype uuid: str
    :ivar inventory_item_name: Gets the Managed Object name in VMM for the inventory item.
    :vartype inventory_item_name: str
    :ivar provisioning_state: Gets the provisioning state.
    :vartype provisioning_state: str
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.scvmm.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    :ivar power_state: Gets the power state of the virtual machine.
    :vartype power_state: str
    :ivar ip_addresses: Gets or sets the nic ip addresses.
    :vartype ip_addresses: list[str]
    :ivar cloud: Cloud inventory resource details where the VM is present.
    :vartype cloud: ~azure.mgmt.scvmm.models.InventoryItemDetails
    """

    _validation = {
        "inventory_type": {"required": True},
        "managed_resource_id": {"readonly": True},
        "uuid": {"readonly": True},
        "inventory_item_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "os_type": {"readonly": True},
        "os_name": {"readonly": True},
        "power_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "uuid": {"key": "uuid", "type": "str"},
        "inventory_item_name": {"key": "inventoryItemName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "power_state": {"key": "powerState", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "cloud": {"key": "cloud", "type": "InventoryItemDetails"},
    }

    def __init__(
        self,
        *,
        ip_addresses: Optional[List[str]] = None,
        cloud: Optional["_models.InventoryItemDetails"] = None,
        **kwargs
    ):
        """
        :keyword ip_addresses: Gets or sets the nic ip addresses.
        :paramtype ip_addresses: list[str]
        :keyword cloud: Cloud inventory resource details where the VM is present.
        :paramtype cloud: ~azure.mgmt.scvmm.models.InventoryItemDetails
        """
        super().__init__(**kwargs)
        self.inventory_type: str = "VirtualMachine"
        self.os_type = None
        self.os_name = None
        self.power_state = None
        self.ip_addresses = ip_addresses
        self.cloud = cloud


class VirtualMachineListResult(_serialization.Model):
    """List of VirtualMachines.

    :ivar value: List of VirtualMachines.
    :vartype value: list[~azure.mgmt.scvmm.models.VirtualMachine]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualMachine"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of VirtualMachines.
        :paramtype value: list[~azure.mgmt.scvmm.models.VirtualMachine]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineRestoreCheckpoint(_serialization.Model):
    """Defines the restore checkpoint action properties.

    :ivar id: ID of the checkpoint to be restored to.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: ID of the checkpoint to be restored to.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualMachineTemplate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The VirtualMachineTemplates resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.scvmm.models.SystemData
    :ivar extended_location: The extended location. Required.
    :vartype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the resource.
    :vartype inventory_item_id: str
    :ivar uuid: Unique ID of the virtual machine template.
    :vartype uuid: str
    :ivar vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
    :vartype vmm_server_id: str
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.scvmm.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    :ivar computer_name: Gets or sets computer name.
    :vartype computer_name: str
    :ivar memory_mb: MemoryMB is the desired size of a virtual machine's memory, in MB.
    :vartype memory_mb: int
    :ivar cpu_count: Gets or sets the desired number of vCPUs for the vm.
    :vartype cpu_count: int
    :ivar limit_cpu_for_migration: Gets or sets a value indicating whether to enable processor
     compatibility mode for live migration of VMs. Known values are: "false" and "true".
    :vartype limit_cpu_for_migration: str or ~azure.mgmt.scvmm.models.LimitCpuForMigration
    :ivar dynamic_memory_enabled: Gets or sets a value indicating whether to enable dynamic memory
     or not. Known values are: "false" and "true".
    :vartype dynamic_memory_enabled: str or ~azure.mgmt.scvmm.models.DynamicMemoryEnabled
    :ivar is_customizable: Gets or sets a value indicating whether the vm template is customizable
     or not. Known values are: "false" and "true".
    :vartype is_customizable: str or ~azure.mgmt.scvmm.models.IsCustomizable
    :ivar dynamic_memory_max_mb: Gets or sets the max dynamic memory for the vm.
    :vartype dynamic_memory_max_mb: int
    :ivar dynamic_memory_min_mb: Gets or sets the min dynamic memory for the vm.
    :vartype dynamic_memory_min_mb: int
    :ivar is_highly_available: Gets highly available property.
    :vartype is_highly_available: str
    :ivar generation: Gets or sets the generation for the vm.
    :vartype generation: int
    :ivar network_interfaces: Gets or sets the network interfaces of the template.
    :vartype network_interfaces: list[~azure.mgmt.scvmm.models.NetworkInterfaces]
    :ivar disks: Gets or sets the disks of the template.
    :vartype disks: list[~azure.mgmt.scvmm.models.VirtualDisk]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "extended_location": {"required": True},
        "uuid": {"min_length": 1},
        "os_type": {"readonly": True},
        "os_name": {"readonly": True},
        "computer_name": {"readonly": True},
        "memory_mb": {"readonly": True},
        "cpu_count": {"readonly": True},
        "limit_cpu_for_migration": {"readonly": True},
        "dynamic_memory_enabled": {"readonly": True},
        "is_customizable": {"readonly": True},
        "dynamic_memory_max_mb": {"readonly": True},
        "dynamic_memory_min_mb": {"readonly": True},
        "is_highly_available": {"readonly": True},
        "generation": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "disks": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "vmm_server_id": {"key": "properties.vmmServerId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_name": {"key": "properties.osName", "type": "str"},
        "computer_name": {"key": "properties.computerName", "type": "str"},
        "memory_mb": {"key": "properties.memoryMB", "type": "int"},
        "cpu_count": {"key": "properties.cpuCount", "type": "int"},
        "limit_cpu_for_migration": {"key": "properties.limitCpuForMigration", "type": "str"},
        "dynamic_memory_enabled": {"key": "properties.dynamicMemoryEnabled", "type": "str"},
        "is_customizable": {"key": "properties.isCustomizable", "type": "str"},
        "dynamic_memory_max_mb": {"key": "properties.dynamicMemoryMaxMB", "type": "int"},
        "dynamic_memory_min_mb": {"key": "properties.dynamicMemoryMinMB", "type": "int"},
        "is_highly_available": {"key": "properties.isHighlyAvailable", "type": "str"},
        "generation": {"key": "properties.generation", "type": "int"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterfaces]"},
        "disks": {"key": "properties.disks", "type": "[VirtualDisk]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        inventory_item_id: Optional[str] = None,
        uuid: Optional[str] = None,
        vmm_server_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location. Required.
        :paramtype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the resource.
        :paramtype inventory_item_id: str
        :keyword uuid: Unique ID of the virtual machine template.
        :paramtype uuid: str
        :keyword vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
        :paramtype vmm_server_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.extended_location = extended_location
        self.inventory_item_id = inventory_item_id
        self.uuid = uuid
        self.vmm_server_id = vmm_server_id
        self.os_type = None
        self.os_name = None
        self.computer_name = None
        self.memory_mb = None
        self.cpu_count = None
        self.limit_cpu_for_migration = None
        self.dynamic_memory_enabled = None
        self.is_customizable = None
        self.dynamic_memory_max_mb = None
        self.dynamic_memory_min_mb = None
        self.is_highly_available = None
        self.generation = None
        self.network_interfaces = None
        self.disks = None
        self.provisioning_state = None


class VirtualMachineTemplateInventoryItem(InventoryItemProperties):
    """The Virtual machine template inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "Cloud",
     "VirtualNetwork", "VirtualMachineTemplate", and "VirtualMachine".
    :vartype inventory_type: str or ~azure.mgmt.scvmm.models.InventoryType
    :ivar managed_resource_id: Gets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar uuid: Gets the UUID (which is assigned by VMM) for the inventory item.
    :vartype uuid: str
    :ivar inventory_item_name: Gets the Managed Object name in VMM for the inventory item.
    :vartype inventory_item_name: str
    :ivar provisioning_state: Gets the provisioning state.
    :vartype provisioning_state: str
    :ivar cpu_count: Gets or sets the desired number of vCPUs for the vm.
    :vartype cpu_count: int
    :ivar memory_mb: MemoryMB is the desired size of a virtual machine's memory, in MB.
    :vartype memory_mb: int
    :ivar os_type: Gets or sets the type of the os. Known values are: "Windows", "Linux", and
     "Other".
    :vartype os_type: str or ~azure.mgmt.scvmm.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    """

    _validation = {
        "inventory_type": {"required": True},
        "managed_resource_id": {"readonly": True},
        "uuid": {"readonly": True},
        "inventory_item_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "cpu_count": {"readonly": True},
        "memory_mb": {"readonly": True},
        "os_type": {"readonly": True},
        "os_name": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "uuid": {"key": "uuid", "type": "str"},
        "inventory_item_name": {"key": "inventoryItemName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "cpu_count": {"key": "cpuCount", "type": "int"},
        "memory_mb": {"key": "memoryMB", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.inventory_type: str = "VirtualMachineTemplate"
        self.cpu_count = None
        self.memory_mb = None
        self.os_type = None
        self.os_name = None


class VirtualMachineTemplateListResult(_serialization.Model):
    """List of VirtualMachineTemplates.

    :ivar value: List of VirtualMachineTemplates.
    :vartype value: list[~azure.mgmt.scvmm.models.VirtualMachineTemplate]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineTemplate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualMachineTemplate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of VirtualMachineTemplates.
        :paramtype value: list[~azure.mgmt.scvmm.models.VirtualMachineTemplate]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineUpdate(_serialization.Model):
    """Defines the virtualMachineUpdate.

    :ivar properties: Defines the resource properties.
    :vartype properties: ~azure.mgmt.scvmm.models.VirtualMachineUpdateProperties
    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "VirtualMachineUpdateProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualMachineUpdateProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword properties: Defines the resource properties.
        :paramtype properties: ~azure.mgmt.scvmm.models.VirtualMachineUpdateProperties
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class VirtualMachineUpdateProperties(_serialization.Model):
    """Defines the resource properties.

    :ivar hardware_profile: Defines the resource properties.
    :vartype hardware_profile: ~azure.mgmt.scvmm.models.HardwareProfileUpdate
    :ivar storage_profile: Defines the resource properties.
    :vartype storage_profile: ~azure.mgmt.scvmm.models.StorageProfileUpdate
    :ivar network_profile: Defines the resource properties.
    :vartype network_profile: ~azure.mgmt.scvmm.models.NetworkProfileUpdate
    :ivar availability_sets: Availability Sets in vm.
    :vartype availability_sets: list[~azure.mgmt.scvmm.models.AvailabilitySetListItem]
    """

    _attribute_map = {
        "hardware_profile": {"key": "hardwareProfile", "type": "HardwareProfileUpdate"},
        "storage_profile": {"key": "storageProfile", "type": "StorageProfileUpdate"},
        "network_profile": {"key": "networkProfile", "type": "NetworkProfileUpdate"},
        "availability_sets": {"key": "availabilitySets", "type": "[AvailabilitySetListItem]"},
    }

    def __init__(
        self,
        *,
        hardware_profile: Optional["_models.HardwareProfileUpdate"] = None,
        storage_profile: Optional["_models.StorageProfileUpdate"] = None,
        network_profile: Optional["_models.NetworkProfileUpdate"] = None,
        availability_sets: Optional[List["_models.AvailabilitySetListItem"]] = None,
        **kwargs
    ):
        """
        :keyword hardware_profile: Defines the resource properties.
        :paramtype hardware_profile: ~azure.mgmt.scvmm.models.HardwareProfileUpdate
        :keyword storage_profile: Defines the resource properties.
        :paramtype storage_profile: ~azure.mgmt.scvmm.models.StorageProfileUpdate
        :keyword network_profile: Defines the resource properties.
        :paramtype network_profile: ~azure.mgmt.scvmm.models.NetworkProfileUpdate
        :keyword availability_sets: Availability Sets in vm.
        :paramtype availability_sets: list[~azure.mgmt.scvmm.models.AvailabilitySetListItem]
        """
        super().__init__(**kwargs)
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.availability_sets = availability_sets


class VirtualNetwork(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The VirtualNetworks resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.scvmm.models.SystemData
    :ivar extended_location: The extended location. Required.
    :vartype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
    :ivar inventory_item_id: Gets or sets the inventory Item ID for the resource.
    :vartype inventory_item_id: str
    :ivar uuid: Unique ID of the virtual network.
    :vartype uuid: str
    :ivar vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
    :vartype vmm_server_id: str
    :ivar network_name: Name of the virtual network in vmmServer.
    :vartype network_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "extended_location": {"required": True},
        "uuid": {"min_length": 1},
        "network_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "inventory_item_id": {"key": "properties.inventoryItemId", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "vmm_server_id": {"key": "properties.vmmServerId", "type": "str"},
        "network_name": {"key": "properties.networkName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        inventory_item_id: Optional[str] = None,
        uuid: Optional[str] = None,
        vmm_server_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location. Required.
        :paramtype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
        :keyword inventory_item_id: Gets or sets the inventory Item ID for the resource.
        :paramtype inventory_item_id: str
        :keyword uuid: Unique ID of the virtual network.
        :paramtype uuid: str
        :keyword vmm_server_id: ARM Id of the vmmServer resource in which this resource resides.
        :paramtype vmm_server_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.extended_location = extended_location
        self.inventory_item_id = inventory_item_id
        self.uuid = uuid
        self.vmm_server_id = vmm_server_id
        self.network_name = None
        self.provisioning_state = None


class VirtualNetworkInventoryItem(InventoryItemProperties):
    """The Virtual network inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar inventory_type: They inventory type. Required. Known values are: "Cloud",
     "VirtualNetwork", "VirtualMachineTemplate", and "VirtualMachine".
    :vartype inventory_type: str or ~azure.mgmt.scvmm.models.InventoryType
    :ivar managed_resource_id: Gets the tracked resource id corresponding to the inventory
     resource.
    :vartype managed_resource_id: str
    :ivar uuid: Gets the UUID (which is assigned by VMM) for the inventory item.
    :vartype uuid: str
    :ivar inventory_item_name: Gets the Managed Object name in VMM for the inventory item.
    :vartype inventory_item_name: str
    :ivar provisioning_state: Gets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "inventory_type": {"required": True},
        "managed_resource_id": {"readonly": True},
        "uuid": {"readonly": True},
        "inventory_item_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "inventory_type": {"key": "inventoryType", "type": "str"},
        "managed_resource_id": {"key": "managedResourceId", "type": "str"},
        "uuid": {"key": "uuid", "type": "str"},
        "inventory_item_name": {"key": "inventoryItemName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.inventory_type: str = "VirtualNetwork"


class VirtualNetworkListResult(_serialization.Model):
    """List of VirtualNetworks.

    :ivar value: List of VirtualNetworks.
    :vartype value: list[~azure.mgmt.scvmm.models.VirtualNetwork]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetwork"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of VirtualNetworks.
        :paramtype value: list[~azure.mgmt.scvmm.models.VirtualNetwork]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VMMServer(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The VmmServers resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Gets or sets the location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.scvmm.models.SystemData
    :ivar extended_location: The extended location. Required.
    :vartype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
    :ivar credentials: Credentials to connect to VMMServer.
    :vartype credentials: ~azure.mgmt.scvmm.models.VMMServerPropertiesCredentials
    :ivar fqdn: Fqdn is the hostname/ip of the vmmServer. Required.
    :vartype fqdn: str
    :ivar port: Port is the port on which the vmmServer is listening.
    :vartype port: int
    :ivar connection_status: Gets or sets the connection status to the vmmServer.
    :vartype connection_status: str
    :ivar error_message: Gets or sets any error message if connection to vmmServer is having any
     issue.
    :vartype error_message: str
    :ivar uuid: Unique ID of vmmServer.
    :vartype uuid: str
    :ivar version: Version is the version of the vmmSever.
    :vartype version: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "extended_location": {"required": True},
        "fqdn": {"required": True, "min_length": 1},
        "port": {"maximum": 65535, "minimum": 1},
        "connection_status": {"readonly": True},
        "error_message": {"readonly": True},
        "uuid": {"readonly": True},
        "version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "credentials": {"key": "properties.credentials", "type": "VMMServerPropertiesCredentials"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
        "uuid": {"key": "properties.uuid", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        fqdn: str,
        tags: Optional[Dict[str, str]] = None,
        credentials: Optional["_models.VMMServerPropertiesCredentials"] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword location: Gets or sets the location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location. Required.
        :paramtype extended_location: ~azure.mgmt.scvmm.models.ExtendedLocation
        :keyword credentials: Credentials to connect to VMMServer.
        :paramtype credentials: ~azure.mgmt.scvmm.models.VMMServerPropertiesCredentials
        :keyword fqdn: Fqdn is the hostname/ip of the vmmServer. Required.
        :paramtype fqdn: str
        :keyword port: Port is the port on which the vmmServer is listening.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.extended_location = extended_location
        self.credentials = credentials
        self.fqdn = fqdn
        self.port = port
        self.connection_status = None
        self.error_message = None
        self.uuid = None
        self.version = None
        self.provisioning_state = None


class VMMServerListResult(_serialization.Model):
    """List of VmmServers.

    :ivar value: List of VmmServers.
    :vartype value: list[~azure.mgmt.scvmm.models.VMMServer]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VMMServer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VMMServer"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of VmmServers.
        :paramtype value: list[~azure.mgmt.scvmm.models.VMMServer]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VMMServerPropertiesCredentials(_serialization.Model):
    """Credentials to connect to VMMServer.

    :ivar username: Username to use to connect to VMMServer.
    :vartype username: str
    :ivar password: Credentials to use to connect to VMMServer.
    :vartype password: str
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, password: Optional[str] = None, **kwargs):
        """
        :keyword username: Username to use to connect to VMMServer.
        :paramtype username: str
        :keyword password: Credentials to use to connect to VMMServer.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password
