# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EnablementStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enablement status of a feature."""

    ENABLED = "Enabled"
    """The feature is Enabled."""
    DISABLED = "Disabled"
    """The feature is Disabled."""


class FreeTrialState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The free-trial state."""

    ACTIVE = "Active"
    """The free-trial is Active."""
    EXPIRED = "Expired"
    """The free-trial is Expired."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    DELETING = "Deleting"
    """Deletion in progress"""
    ACCEPTED = "Accepted"
    """Change accepted for processing"""


class QuotaNames(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """QuotaNames."""

    SCALABLE_EXECUTION = "ScalableExecution"
    """The quota details for scalable execution feature. When enabled, Playwright client workers can
    #: connect to cloud-hosted browsers. This can increase the number of parallel workers for a test
    #: run, significantly minimizing test completion durations."""
