/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.matcher;

import fr.jayasoft.ivy.matcher.AnyMatcher;
import fr.jayasoft.ivy.matcher.Matcher;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import fr.jayasoft.ivy.util.Message;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public final class GlobPatternMatcher
implements PatternMatcher {
    private static final GlobPatternMatcher INSTANCE = new GlobPatternMatcher();

    public static PatternMatcher getInstance() {
        return INSTANCE;
    }

    private GlobPatternMatcher() {
    }

    public String getName() {
        return "glob";
    }

    public Matcher getMatcher(String exp) {
        if ("*".equals(exp)) {
            return AnyMatcher.getInstance();
        }
        return new GlobMatcher(exp);
    }

    public static class GlobMatcher
    implements Matcher {
        private Pattern _p;

        public GlobMatcher(String exp) {
            try {
                this._p = new GlobCompiler().compile(exp);
            }
            catch (MalformedPatternException e) {
                Message.error("impossible to compile glob pattern: " + exp);
            }
        }

        public boolean matches(String str) {
            return this._p != null && new Perl5Matcher().matches(str, this._p);
        }

        public boolean isExact() {
            return false;
        }
    }
}

