/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.filter.FilterHelper;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;

public class IvyResolve
extends IvyTask {
    private File _file = null;
    private String _conf = null;
    private File _cache = null;
    private String _revision = null;
    private String _pubdate = null;
    private boolean _haltOnFailure = true;
    private boolean _useCacheOnly = false;
    private String _type = null;

    public String getDate() {
        return this._pubdate;
    }

    public void setDate(String pubdate) {
        this._pubdate = pubdate;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getConf() {
        return this._conf;
    }

    public void setConf(String conf) {
        this._conf = conf;
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public boolean isHaltonfailure() {
        return this._haltOnFailure;
    }

    public void setHaltonfailure(boolean haltOnFailure) {
        this._haltOnFailure = haltOnFailure;
    }

    public void setShowprogress(boolean show) {
        Message.setShowProgress(show);
    }

    public boolean isUseCacheOnly() {
        return this._useCacheOnly;
    }

    public void setUseCacheOnly(boolean useCacheOnly) {
        this._useCacheOnly = useCacheOnly;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void execute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        try {
            if (this._file == null) {
                this._file = new File(this.getProject().getBaseDir(), this.getProperty(ivy, "ivy.dep.file"));
            }
            this._conf = this.getProperty(this._conf, ivy, "ivy.configurations");
            this._revision = this.getProperty(this._revision, ivy, "ivy.revision");
            this._type = this.getProperty(this._type, ivy, "ivy.resolve.default.type.filter");
            if (this._cache == null) {
                this._cache = ivy.getDefaultCache();
            }
            String[] confs = this.splitConfs(this._conf);
            ResolveReport report = ivy.resolve(this._file.toURL(), this._revision, confs, this._cache, this.getPubDate(this._pubdate, null), this.doValidate(ivy), this._useCacheOnly, FilterHelper.getArtifactTypeFilter(this._type));
            if (this.isHaltonfailure() && report.hasError()) {
                throw new BuildException("resolve failed - see output for details");
            }
            ModuleDescriptor md = report.getModuleDescriptor();
            this.setResolved(md);
            this.getProject().setProperty("ivy.organisation", md.getModuleRevisionId().getOrganisation());
            ivy.setVariable("ivy.organisation", md.getModuleRevisionId().getOrganisation());
            this.getProject().setProperty("ivy.module", md.getModuleRevisionId().getName());
            ivy.setVariable("ivy.module", md.getModuleRevisionId().getName());
            this.getProject().setProperty("ivy.revision", md.getResolvedModuleRevisionId().getRevision());
            ivy.setVariable("ivy.revision", md.getResolvedModuleRevisionId().getRevision());
            this.getProject().setProperty("ivy.deps.changed", String.valueOf(report.hasChanged()));
            ivy.setVariable("ivy.deps.changed", String.valueOf(report.hasChanged()));
            if (this._conf.trim().equals("*")) {
                this.getProject().setProperty("ivy.resolved.configurations", this.mergeConfs(md.getConfigurationsNames()));
                ivy.setVariable("ivy.resolved.configurations", this.mergeConfs(md.getConfigurationsNames()));
            } else {
                this.getProject().setProperty("ivy.resolved.configurations", this._conf);
                ivy.setVariable("ivy.resolved.configurations", this._conf);
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException("unable to convert given ivy file to url: " + this._file, (Throwable)e);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file", (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("impossible to resolve dependencies: " + e.getMessage(), (Throwable)e);
        }
    }
}

