/*
 *	Netlink route / adddress utilities
 *
 *	Copyright (C) 2009-2012 Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2012 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Olaf Kirch <okir@suse.de>
 *	         Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_NETLINK_H
#define __NETCONTROL_NETLINK_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <netlink/netlink.h>

typedef struct nc_netlink	nc_netlink_t;

extern nc_netlink_t *		nc_netlink_open(void);
extern void			nc_netlink_close(nc_netlink_t **);
extern int			nc_netlink_get_addrs(nc_netlink_t *, nl_recvmsg_msg_cb_t, void *);
extern int			nc_netlink_get_routes(nc_netlink_t *, nl_recvmsg_msg_cb_t, void *);

extern int			nc_netlink_parse_addr_msg(struct nl_msg *msg, nc_address_t **, int *ifindex);
extern int			nc_netlink_parse_route_msg(struct nl_msg *msg, nc_route_t **, int *ifindex);

#endif /* __NETCONTROL_NETLINK_H */
