package datafactory

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAnonymous ...
	AuthenticationTypeAnonymous AuthenticationType = "Anonymous"
	// AuthenticationTypeBasic ...
	AuthenticationTypeBasic AuthenticationType = "Basic"
	// AuthenticationTypeClientCertificate ...
	AuthenticationTypeClientCertificate AuthenticationType = "ClientCertificate"
	// AuthenticationTypeWebLinkedServiceTypeProperties ...
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = "WebLinkedServiceTypeProperties"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeAnonymous, AuthenticationTypeBasic, AuthenticationTypeClientCertificate, AuthenticationTypeWebLinkedServiceTypeProperties}
}

// AuthorizationType enumerates the values for authorization type.
type AuthorizationType string

const (
	// AuthorizationTypeKey ...
	AuthorizationTypeKey AuthorizationType = "Key"
	// AuthorizationTypeLinkedIntegrationRuntimeType ...
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = "LinkedIntegrationRuntimeType"
	// AuthorizationTypeRBAC ...
	AuthorizationTypeRBAC AuthorizationType = "RBAC"
)

// PossibleAuthorizationTypeValues returns an array of possible values for the AuthorizationType const type.
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return []AuthorizationType{AuthorizationTypeKey, AuthorizationTypeLinkedIntegrationRuntimeType, AuthorizationTypeRBAC}
}

// AvroCompressionCodec enumerates the values for avro compression codec.
type AvroCompressionCodec string

const (
	// Bzip2 ...
	Bzip2 AvroCompressionCodec = "bzip2"
	// Deflate ...
	Deflate AvroCompressionCodec = "deflate"
	// None ...
	None AvroCompressionCodec = "none"
	// Snappy ...
	Snappy AvroCompressionCodec = "snappy"
	// Xz ...
	Xz AvroCompressionCodec = "xz"
)

// PossibleAvroCompressionCodecValues returns an array of possible values for the AvroCompressionCodec const type.
func PossibleAvroCompressionCodecValues() []AvroCompressionCodec {
	return []AvroCompressionCodec{Bzip2, Deflate, None, Snappy, Xz}
}

// AzureFunctionActivityMethod enumerates the values for azure function activity method.
type AzureFunctionActivityMethod string

const (
	// DELETE ...
	DELETE AzureFunctionActivityMethod = "DELETE"
	// GET ...
	GET AzureFunctionActivityMethod = "GET"
	// HEAD ...
	HEAD AzureFunctionActivityMethod = "HEAD"
	// OPTIONS ...
	OPTIONS AzureFunctionActivityMethod = "OPTIONS"
	// POST ...
	POST AzureFunctionActivityMethod = "POST"
	// PUT ...
	PUT AzureFunctionActivityMethod = "PUT"
	// TRACE ...
	TRACE AzureFunctionActivityMethod = "TRACE"
)

// PossibleAzureFunctionActivityMethodValues returns an array of possible values for the AzureFunctionActivityMethod const type.
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return []AzureFunctionActivityMethod{DELETE, GET, HEAD, OPTIONS, POST, PUT, TRACE}
}

// AzureSearchIndexWriteBehaviorType enumerates the values for azure search index write behavior type.
type AzureSearchIndexWriteBehaviorType string

const (
	// Merge ...
	Merge AzureSearchIndexWriteBehaviorType = "Merge"
	// Upload ...
	Upload AzureSearchIndexWriteBehaviorType = "Upload"
)

// PossibleAzureSearchIndexWriteBehaviorTypeValues returns an array of possible values for the AzureSearchIndexWriteBehaviorType const type.
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return []AzureSearchIndexWriteBehaviorType{Merge, Upload}
}

// BlobEventTypes enumerates the values for blob event types.
type BlobEventTypes string

const (
	// MicrosoftStorageBlobCreated ...
	MicrosoftStorageBlobCreated BlobEventTypes = "Microsoft.Storage.BlobCreated"
	// MicrosoftStorageBlobDeleted ...
	MicrosoftStorageBlobDeleted BlobEventTypes = "Microsoft.Storage.BlobDeleted"
)

// PossibleBlobEventTypesValues returns an array of possible values for the BlobEventTypes const type.
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return []BlobEventTypes{MicrosoftStorageBlobCreated, MicrosoftStorageBlobDeleted}
}

// CassandraSourceReadConsistencyLevels enumerates the values for cassandra source read consistency levels.
type CassandraSourceReadConsistencyLevels string

const (
	// ALL ...
	ALL CassandraSourceReadConsistencyLevels = "ALL"
	// EACHQUORUM ...
	EACHQUORUM CassandraSourceReadConsistencyLevels = "EACH_QUORUM"
	// LOCALONE ...
	LOCALONE CassandraSourceReadConsistencyLevels = "LOCAL_ONE"
	// LOCALQUORUM ...
	LOCALQUORUM CassandraSourceReadConsistencyLevels = "LOCAL_QUORUM"
	// LOCALSERIAL ...
	LOCALSERIAL CassandraSourceReadConsistencyLevels = "LOCAL_SERIAL"
	// ONE ...
	ONE CassandraSourceReadConsistencyLevels = "ONE"
	// QUORUM ...
	QUORUM CassandraSourceReadConsistencyLevels = "QUORUM"
	// SERIAL ...
	SERIAL CassandraSourceReadConsistencyLevels = "SERIAL"
	// THREE ...
	THREE CassandraSourceReadConsistencyLevels = "THREE"
	// TWO ...
	TWO CassandraSourceReadConsistencyLevels = "TWO"
)

// PossibleCassandraSourceReadConsistencyLevelsValues returns an array of possible values for the CassandraSourceReadConsistencyLevels const type.
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return []CassandraSourceReadConsistencyLevels{ALL, EACHQUORUM, LOCALONE, LOCALQUORUM, LOCALSERIAL, ONE, QUORUM, SERIAL, THREE, TWO}
}

// DataFlowComputeType enumerates the values for data flow compute type.
type DataFlowComputeType string

const (
	// ComputeOptimized ...
	ComputeOptimized DataFlowComputeType = "ComputeOptimized"
	// General ...
	General DataFlowComputeType = "General"
	// MemoryOptimized ...
	MemoryOptimized DataFlowComputeType = "MemoryOptimized"
)

// PossibleDataFlowComputeTypeValues returns an array of possible values for the DataFlowComputeType const type.
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return []DataFlowComputeType{ComputeOptimized, General, MemoryOptimized}
}

// DataFlowDebugCommandType enumerates the values for data flow debug command type.
type DataFlowDebugCommandType string

const (
	// ExecuteExpressionQuery ...
	ExecuteExpressionQuery DataFlowDebugCommandType = "executeExpressionQuery"
	// ExecutePreviewQuery ...
	ExecutePreviewQuery DataFlowDebugCommandType = "executePreviewQuery"
	// ExecuteStatisticsQuery ...
	ExecuteStatisticsQuery DataFlowDebugCommandType = "executeStatisticsQuery"
)

// PossibleDataFlowDebugCommandTypeValues returns an array of possible values for the DataFlowDebugCommandType const type.
func PossibleDataFlowDebugCommandTypeValues() []DataFlowDebugCommandType {
	return []DataFlowDebugCommandType{ExecuteExpressionQuery, ExecutePreviewQuery, ExecuteStatisticsQuery}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// Db2AuthenticationType enumerates the values for db 2 authentication type.
type Db2AuthenticationType string

const (
	// Basic ...
	Basic Db2AuthenticationType = "Basic"
)

// PossibleDb2AuthenticationTypeValues returns an array of possible values for the Db2AuthenticationType const type.
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return []Db2AuthenticationType{Basic}
}

// DependencyCondition enumerates the values for dependency condition.
type DependencyCondition string

const (
	// Completed ...
	Completed DependencyCondition = "Completed"
	// Failed ...
	Failed DependencyCondition = "Failed"
	// Skipped ...
	Skipped DependencyCondition = "Skipped"
	// Succeeded ...
	Succeeded DependencyCondition = "Succeeded"
)

// PossibleDependencyConditionValues returns an array of possible values for the DependencyCondition const type.
func PossibleDependencyConditionValues() []DependencyCondition {
	return []DependencyCondition{Completed, Failed, Skipped, Succeeded}
}

// DynamicsAuthenticationType enumerates the values for dynamics authentication type.
type DynamicsAuthenticationType string

const (
	// AADServicePrincipal ...
	AADServicePrincipal DynamicsAuthenticationType = "AADServicePrincipal"
	// Ifd ...
	Ifd DynamicsAuthenticationType = "Ifd"
	// Office365 ...
	Office365 DynamicsAuthenticationType = "Office365"
)

// PossibleDynamicsAuthenticationTypeValues returns an array of possible values for the DynamicsAuthenticationType const type.
func PossibleDynamicsAuthenticationTypeValues() []DynamicsAuthenticationType {
	return []DynamicsAuthenticationType{AADServicePrincipal, Ifd, Office365}
}

// DynamicsDeploymentType enumerates the values for dynamics deployment type.
type DynamicsDeploymentType string

const (
	// Online ...
	Online DynamicsDeploymentType = "Online"
	// OnPremisesWithIfd ...
	OnPremisesWithIfd DynamicsDeploymentType = "OnPremisesWithIfd"
)

// PossibleDynamicsDeploymentTypeValues returns an array of possible values for the DynamicsDeploymentType const type.
func PossibleDynamicsDeploymentTypeValues() []DynamicsDeploymentType {
	return []DynamicsDeploymentType{Online, OnPremisesWithIfd}
}

// EventSubscriptionStatus enumerates the values for event subscription status.
type EventSubscriptionStatus string

const (
	// Deprovisioning ...
	Deprovisioning EventSubscriptionStatus = "Deprovisioning"
	// Disabled ...
	Disabled EventSubscriptionStatus = "Disabled"
	// Enabled ...
	Enabled EventSubscriptionStatus = "Enabled"
	// Provisioning ...
	Provisioning EventSubscriptionStatus = "Provisioning"
	// Unknown ...
	Unknown EventSubscriptionStatus = "Unknown"
)

// PossibleEventSubscriptionStatusValues returns an array of possible values for the EventSubscriptionStatus const type.
func PossibleEventSubscriptionStatusValues() []EventSubscriptionStatus {
	return []EventSubscriptionStatus{Deprovisioning, Disabled, Enabled, Provisioning, Unknown}
}

// FtpAuthenticationType enumerates the values for ftp authentication type.
type FtpAuthenticationType string

const (
	// FtpAuthenticationTypeAnonymous ...
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = "Anonymous"
	// FtpAuthenticationTypeBasic ...
	FtpAuthenticationTypeBasic FtpAuthenticationType = "Basic"
)

// PossibleFtpAuthenticationTypeValues returns an array of possible values for the FtpAuthenticationType const type.
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return []FtpAuthenticationType{FtpAuthenticationTypeAnonymous, FtpAuthenticationTypeBasic}
}

// GlobalParameterType enumerates the values for global parameter type.
type GlobalParameterType string

const (
	// Array ...
	Array GlobalParameterType = "Array"
	// Bool ...
	Bool GlobalParameterType = "Bool"
	// Float ...
	Float GlobalParameterType = "Float"
	// Int ...
	Int GlobalParameterType = "Int"
	// Object ...
	Object GlobalParameterType = "Object"
	// String ...
	String GlobalParameterType = "String"
)

// PossibleGlobalParameterTypeValues returns an array of possible values for the GlobalParameterType const type.
func PossibleGlobalParameterTypeValues() []GlobalParameterType {
	return []GlobalParameterType{Array, Bool, Float, Int, Object, String}
}

// GoogleAdWordsAuthenticationType enumerates the values for google ad words authentication type.
type GoogleAdWordsAuthenticationType string

const (
	// ServiceAuthentication ...
	ServiceAuthentication GoogleAdWordsAuthenticationType = "ServiceAuthentication"
	// UserAuthentication ...
	UserAuthentication GoogleAdWordsAuthenticationType = "UserAuthentication"
)

// PossibleGoogleAdWordsAuthenticationTypeValues returns an array of possible values for the GoogleAdWordsAuthenticationType const type.
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return []GoogleAdWordsAuthenticationType{ServiceAuthentication, UserAuthentication}
}

// GoogleBigQueryAuthenticationType enumerates the values for google big query authentication type.
type GoogleBigQueryAuthenticationType string

const (
	// GoogleBigQueryAuthenticationTypeServiceAuthentication ...
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = "ServiceAuthentication"
	// GoogleBigQueryAuthenticationTypeUserAuthentication ...
	GoogleBigQueryAuthenticationTypeUserAuthentication GoogleBigQueryAuthenticationType = "UserAuthentication"
)

// PossibleGoogleBigQueryAuthenticationTypeValues returns an array of possible values for the GoogleBigQueryAuthenticationType const type.
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return []GoogleBigQueryAuthenticationType{GoogleBigQueryAuthenticationTypeServiceAuthentication, GoogleBigQueryAuthenticationTypeUserAuthentication}
}

// HBaseAuthenticationType enumerates the values for h base authentication type.
type HBaseAuthenticationType string

const (
	// HBaseAuthenticationTypeAnonymous ...
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = "Anonymous"
	// HBaseAuthenticationTypeBasic ...
	HBaseAuthenticationTypeBasic HBaseAuthenticationType = "Basic"
)

// PossibleHBaseAuthenticationTypeValues returns an array of possible values for the HBaseAuthenticationType const type.
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return []HBaseAuthenticationType{HBaseAuthenticationTypeAnonymous, HBaseAuthenticationTypeBasic}
}

// HDInsightActivityDebugInfoOption enumerates the values for hd insight activity debug info option.
type HDInsightActivityDebugInfoOption string

const (
	// HDInsightActivityDebugInfoOptionAlways ...
	HDInsightActivityDebugInfoOptionAlways HDInsightActivityDebugInfoOption = "Always"
	// HDInsightActivityDebugInfoOptionFailure ...
	HDInsightActivityDebugInfoOptionFailure HDInsightActivityDebugInfoOption = "Failure"
	// HDInsightActivityDebugInfoOptionNone ...
	HDInsightActivityDebugInfoOptionNone HDInsightActivityDebugInfoOption = "None"
)

// PossibleHDInsightActivityDebugInfoOptionValues returns an array of possible values for the HDInsightActivityDebugInfoOption const type.
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return []HDInsightActivityDebugInfoOption{HDInsightActivityDebugInfoOptionAlways, HDInsightActivityDebugInfoOptionFailure, HDInsightActivityDebugInfoOptionNone}
}

// HiveAuthenticationType enumerates the values for hive authentication type.
type HiveAuthenticationType string

const (
	// Anonymous ...
	Anonymous HiveAuthenticationType = "Anonymous"
	// Username ...
	Username HiveAuthenticationType = "Username"
	// UsernameAndPassword ...
	UsernameAndPassword HiveAuthenticationType = "UsernameAndPassword"
	// WindowsAzureHDInsightService ...
	WindowsAzureHDInsightService HiveAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleHiveAuthenticationTypeValues returns an array of possible values for the HiveAuthenticationType const type.
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return []HiveAuthenticationType{Anonymous, Username, UsernameAndPassword, WindowsAzureHDInsightService}
}

// HiveServerType enumerates the values for hive server type.
type HiveServerType string

const (
	// HiveServer1 ...
	HiveServer1 HiveServerType = "HiveServer1"
	// HiveServer2 ...
	HiveServer2 HiveServerType = "HiveServer2"
	// HiveThriftServer ...
	HiveThriftServer HiveServerType = "HiveThriftServer"
)

// PossibleHiveServerTypeValues returns an array of possible values for the HiveServerType const type.
func PossibleHiveServerTypeValues() []HiveServerType {
	return []HiveServerType{HiveServer1, HiveServer2, HiveThriftServer}
}

// HiveThriftTransportProtocol enumerates the values for hive thrift transport protocol.
type HiveThriftTransportProtocol string

const (
	// Binary ...
	Binary HiveThriftTransportProtocol = "Binary"
	// HTTP ...
	HTTP HiveThriftTransportProtocol = "HTTP "
	// SASL ...
	SASL HiveThriftTransportProtocol = "SASL"
)

// PossibleHiveThriftTransportProtocolValues returns an array of possible values for the HiveThriftTransportProtocol const type.
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return []HiveThriftTransportProtocol{Binary, HTTP, SASL}
}

// HTTPAuthenticationType enumerates the values for http authentication type.
type HTTPAuthenticationType string

const (
	// HTTPAuthenticationTypeAnonymous ...
	HTTPAuthenticationTypeAnonymous HTTPAuthenticationType = "Anonymous"
	// HTTPAuthenticationTypeBasic ...
	HTTPAuthenticationTypeBasic HTTPAuthenticationType = "Basic"
	// HTTPAuthenticationTypeClientCertificate ...
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = "ClientCertificate"
	// HTTPAuthenticationTypeDigest ...
	HTTPAuthenticationTypeDigest HTTPAuthenticationType = "Digest"
	// HTTPAuthenticationTypeWindows ...
	HTTPAuthenticationTypeWindows HTTPAuthenticationType = "Windows"
)

// PossibleHTTPAuthenticationTypeValues returns an array of possible values for the HTTPAuthenticationType const type.
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return []HTTPAuthenticationType{HTTPAuthenticationTypeAnonymous, HTTPAuthenticationTypeBasic, HTTPAuthenticationTypeClientCertificate, HTTPAuthenticationTypeDigest, HTTPAuthenticationTypeWindows}
}

// ImpalaAuthenticationType enumerates the values for impala authentication type.
type ImpalaAuthenticationType string

const (
	// ImpalaAuthenticationTypeAnonymous ...
	ImpalaAuthenticationTypeAnonymous ImpalaAuthenticationType = "Anonymous"
	// ImpalaAuthenticationTypeSASLUsername ...
	ImpalaAuthenticationTypeSASLUsername ImpalaAuthenticationType = "SASLUsername"
	// ImpalaAuthenticationTypeUsernameAndPassword ...
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = "UsernameAndPassword"
)

// PossibleImpalaAuthenticationTypeValues returns an array of possible values for the ImpalaAuthenticationType const type.
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return []ImpalaAuthenticationType{ImpalaAuthenticationTypeAnonymous, ImpalaAuthenticationTypeSASLUsername, ImpalaAuthenticationTypeUsernameAndPassword}
}

// IntegrationRuntimeAuthKeyName enumerates the values for integration runtime auth key name.
type IntegrationRuntimeAuthKeyName string

const (
	// AuthKey1 ...
	AuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	// AuthKey2 ...
	AuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns an array of possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{AuthKey1, AuthKey2}
}

// IntegrationRuntimeAutoUpdate enumerates the values for integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	// Off ...
	Off IntegrationRuntimeAutoUpdate = "Off"
	// On ...
	On IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns an array of possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{Off, On}
}

// IntegrationRuntimeEdition enumerates the values for integration runtime edition.
type IntegrationRuntimeEdition string

const (
	// Enterprise ...
	Enterprise IntegrationRuntimeEdition = "Enterprise"
	// Standard ...
	Standard IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns an array of possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{Enterprise, Standard}
}

// IntegrationRuntimeEntityReferenceType enumerates the values for integration runtime entity reference type.
type IntegrationRuntimeEntityReferenceType string

const (
	// IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference ...
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = "IntegrationRuntimeReference"
	// IntegrationRuntimeEntityReferenceTypeLinkedServiceReference ...
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference IntegrationRuntimeEntityReferenceType = "LinkedServiceReference"
)

// PossibleIntegrationRuntimeEntityReferenceTypeValues returns an array of possible values for the IntegrationRuntimeEntityReferenceType const type.
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return []IntegrationRuntimeEntityReferenceType{IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference, IntegrationRuntimeEntityReferenceTypeLinkedServiceReference}
}

// IntegrationRuntimeInternalChannelEncryptionMode enumerates the values for integration runtime internal
// channel encryption mode.
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	// NotEncrypted ...
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	// NotSet ...
	NotSet IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	// SslEncrypted ...
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns an array of possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{NotEncrypted, NotSet, SslEncrypted}
}

// IntegrationRuntimeLicenseType enumerates the values for integration runtime license type.
type IntegrationRuntimeLicenseType string

const (
	// BasePrice ...
	BasePrice IntegrationRuntimeLicenseType = "BasePrice"
	// LicenseIncluded ...
	LicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns an array of possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{BasePrice, LicenseIncluded}
}

// IntegrationRuntimeSsisCatalogPricingTier enumerates the values for integration runtime ssis catalog pricing
// tier.
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	// IntegrationRuntimeSsisCatalogPricingTierBasic ...
	IntegrationRuntimeSsisCatalogPricingTierBasic IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	// IntegrationRuntimeSsisCatalogPricingTierPremium ...
	IntegrationRuntimeSsisCatalogPricingTierPremium IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	// IntegrationRuntimeSsisCatalogPricingTierPremiumRS ...
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	// IntegrationRuntimeSsisCatalogPricingTierStandard ...
	IntegrationRuntimeSsisCatalogPricingTierStandard IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns an array of possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{IntegrationRuntimeSsisCatalogPricingTierBasic, IntegrationRuntimeSsisCatalogPricingTierPremium, IntegrationRuntimeSsisCatalogPricingTierPremiumRS, IntegrationRuntimeSsisCatalogPricingTierStandard}
}

// IntegrationRuntimeState enumerates the values for integration runtime state.
type IntegrationRuntimeState string

const (
	// IntegrationRuntimeStateAccessDenied ...
	IntegrationRuntimeStateAccessDenied IntegrationRuntimeState = "AccessDenied"
	// IntegrationRuntimeStateInitial ...
	IntegrationRuntimeStateInitial IntegrationRuntimeState = "Initial"
	// IntegrationRuntimeStateLimited ...
	IntegrationRuntimeStateLimited IntegrationRuntimeState = "Limited"
	// IntegrationRuntimeStateNeedRegistration ...
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = "NeedRegistration"
	// IntegrationRuntimeStateOffline ...
	IntegrationRuntimeStateOffline IntegrationRuntimeState = "Offline"
	// IntegrationRuntimeStateOnline ...
	IntegrationRuntimeStateOnline IntegrationRuntimeState = "Online"
	// IntegrationRuntimeStateStarted ...
	IntegrationRuntimeStateStarted IntegrationRuntimeState = "Started"
	// IntegrationRuntimeStateStarting ...
	IntegrationRuntimeStateStarting IntegrationRuntimeState = "Starting"
	// IntegrationRuntimeStateStopped ...
	IntegrationRuntimeStateStopped IntegrationRuntimeState = "Stopped"
	// IntegrationRuntimeStateStopping ...
	IntegrationRuntimeStateStopping IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns an array of possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{IntegrationRuntimeStateAccessDenied, IntegrationRuntimeStateInitial, IntegrationRuntimeStateLimited, IntegrationRuntimeStateNeedRegistration, IntegrationRuntimeStateOffline, IntegrationRuntimeStateOnline, IntegrationRuntimeStateStarted, IntegrationRuntimeStateStarting, IntegrationRuntimeStateStopped, IntegrationRuntimeStateStopping}
}

// IntegrationRuntimeType enumerates the values for integration runtime type.
type IntegrationRuntimeType string

const (
	// Managed ...
	Managed IntegrationRuntimeType = "Managed"
	// SelfHosted ...
	SelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns an array of possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{Managed, SelfHosted}
}

// IntegrationRuntimeUpdateResult enumerates the values for integration runtime update result.
type IntegrationRuntimeUpdateResult string

const (
	// IntegrationRuntimeUpdateResultFail ...
	IntegrationRuntimeUpdateResultFail IntegrationRuntimeUpdateResult = "Fail"
	// IntegrationRuntimeUpdateResultNone ...
	IntegrationRuntimeUpdateResultNone IntegrationRuntimeUpdateResult = "None"
	// IntegrationRuntimeUpdateResultSucceed ...
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns an array of possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{IntegrationRuntimeUpdateResultFail, IntegrationRuntimeUpdateResultNone, IntegrationRuntimeUpdateResultSucceed}
}

// JSONWriteFilePattern enumerates the values for json write file pattern.
type JSONWriteFilePattern string

const (
	// ArrayOfObjects ...
	ArrayOfObjects JSONWriteFilePattern = "arrayOfObjects"
	// SetOfObjects ...
	SetOfObjects JSONWriteFilePattern = "setOfObjects"
)

// PossibleJSONWriteFilePatternValues returns an array of possible values for the JSONWriteFilePattern const type.
func PossibleJSONWriteFilePatternValues() []JSONWriteFilePattern {
	return []JSONWriteFilePattern{ArrayOfObjects, SetOfObjects}
}

// ManagedIntegrationRuntimeNodeStatus enumerates the values for managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	// Available ...
	Available ManagedIntegrationRuntimeNodeStatus = "Available"
	// Recycling ...
	Recycling ManagedIntegrationRuntimeNodeStatus = "Recycling"
	// Starting ...
	Starting ManagedIntegrationRuntimeNodeStatus = "Starting"
	// Unavailable ...
	Unavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns an array of possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{Available, Recycling, Starting, Unavailable}
}

// MongoDbAuthenticationType enumerates the values for mongo db authentication type.
type MongoDbAuthenticationType string

const (
	// MongoDbAuthenticationTypeAnonymous ...
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = "Anonymous"
	// MongoDbAuthenticationTypeBasic ...
	MongoDbAuthenticationTypeBasic MongoDbAuthenticationType = "Basic"
)

// PossibleMongoDbAuthenticationTypeValues returns an array of possible values for the MongoDbAuthenticationType const type.
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return []MongoDbAuthenticationType{MongoDbAuthenticationTypeAnonymous, MongoDbAuthenticationTypeBasic}
}

// NetezzaPartitionOption enumerates the values for netezza partition option.
type NetezzaPartitionOption string

const (
	// NetezzaPartitionOptionDataSlice ...
	NetezzaPartitionOptionDataSlice NetezzaPartitionOption = "DataSlice"
	// NetezzaPartitionOptionDynamicRange ...
	NetezzaPartitionOptionDynamicRange NetezzaPartitionOption = "DynamicRange"
	// NetezzaPartitionOptionNone ...
	NetezzaPartitionOptionNone NetezzaPartitionOption = "None"
)

// PossibleNetezzaPartitionOptionValues returns an array of possible values for the NetezzaPartitionOption const type.
func PossibleNetezzaPartitionOptionValues() []NetezzaPartitionOption {
	return []NetezzaPartitionOption{NetezzaPartitionOptionDataSlice, NetezzaPartitionOptionDynamicRange, NetezzaPartitionOptionNone}
}

// ODataAadServicePrincipalCredentialType enumerates the values for o data aad service principal credential
// type.
type ODataAadServicePrincipalCredentialType string

const (
	// ServicePrincipalCert ...
	ServicePrincipalCert ODataAadServicePrincipalCredentialType = "ServicePrincipalCert"
	// ServicePrincipalKey ...
	ServicePrincipalKey ODataAadServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleODataAadServicePrincipalCredentialTypeValues returns an array of possible values for the ODataAadServicePrincipalCredentialType const type.
func PossibleODataAadServicePrincipalCredentialTypeValues() []ODataAadServicePrincipalCredentialType {
	return []ODataAadServicePrincipalCredentialType{ServicePrincipalCert, ServicePrincipalKey}
}

// ODataAuthenticationType enumerates the values for o data authentication type.
type ODataAuthenticationType string

const (
	// ODataAuthenticationTypeAadServicePrincipal ...
	ODataAuthenticationTypeAadServicePrincipal ODataAuthenticationType = "AadServicePrincipal"
	// ODataAuthenticationTypeAnonymous ...
	ODataAuthenticationTypeAnonymous ODataAuthenticationType = "Anonymous"
	// ODataAuthenticationTypeBasic ...
	ODataAuthenticationTypeBasic ODataAuthenticationType = "Basic"
	// ODataAuthenticationTypeManagedServiceIdentity ...
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = "ManagedServiceIdentity"
	// ODataAuthenticationTypeWindows ...
	ODataAuthenticationTypeWindows ODataAuthenticationType = "Windows"
)

// PossibleODataAuthenticationTypeValues returns an array of possible values for the ODataAuthenticationType const type.
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return []ODataAuthenticationType{ODataAuthenticationTypeAadServicePrincipal, ODataAuthenticationTypeAnonymous, ODataAuthenticationTypeBasic, ODataAuthenticationTypeManagedServiceIdentity, ODataAuthenticationTypeWindows}
}

// OraclePartitionOption enumerates the values for oracle partition option.
type OraclePartitionOption string

const (
	// OraclePartitionOptionDynamicRange ...
	OraclePartitionOptionDynamicRange OraclePartitionOption = "DynamicRange"
	// OraclePartitionOptionNone ...
	OraclePartitionOptionNone OraclePartitionOption = "None"
	// OraclePartitionOptionPhysicalPartitionsOfTable ...
	OraclePartitionOptionPhysicalPartitionsOfTable OraclePartitionOption = "PhysicalPartitionsOfTable"
)

// PossibleOraclePartitionOptionValues returns an array of possible values for the OraclePartitionOption const type.
func PossibleOraclePartitionOptionValues() []OraclePartitionOption {
	return []OraclePartitionOption{OraclePartitionOptionDynamicRange, OraclePartitionOptionNone, OraclePartitionOptionPhysicalPartitionsOfTable}
}

// OrcCompressionCodec enumerates the values for orc compression codec.
type OrcCompressionCodec string

const (
	// OrcCompressionCodecNone ...
	OrcCompressionCodecNone OrcCompressionCodec = "none"
	// OrcCompressionCodecSnappy ...
	OrcCompressionCodecSnappy OrcCompressionCodec = "snappy"
	// OrcCompressionCodecZlib ...
	OrcCompressionCodecZlib OrcCompressionCodec = "zlib"
)

// PossibleOrcCompressionCodecValues returns an array of possible values for the OrcCompressionCodec const type.
func PossibleOrcCompressionCodecValues() []OrcCompressionCodec {
	return []OrcCompressionCodec{OrcCompressionCodecNone, OrcCompressionCodecSnappy, OrcCompressionCodecZlib}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool ...
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureString ...
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBool, ParameterTypeFloat, ParameterTypeInt, ParameterTypeObject, ParameterTypeSecureString, ParameterTypeString}
}

// PhoenixAuthenticationType enumerates the values for phoenix authentication type.
type PhoenixAuthenticationType string

const (
	// PhoenixAuthenticationTypeAnonymous ...
	PhoenixAuthenticationTypeAnonymous PhoenixAuthenticationType = "Anonymous"
	// PhoenixAuthenticationTypeUsernameAndPassword ...
	PhoenixAuthenticationTypeUsernameAndPassword PhoenixAuthenticationType = "UsernameAndPassword"
	// PhoenixAuthenticationTypeWindowsAzureHDInsightService ...
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = "WindowsAzureHDInsightService"
)

// PossiblePhoenixAuthenticationTypeValues returns an array of possible values for the PhoenixAuthenticationType const type.
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return []PhoenixAuthenticationType{PhoenixAuthenticationTypeAnonymous, PhoenixAuthenticationTypeUsernameAndPassword, PhoenixAuthenticationTypeWindowsAzureHDInsightService}
}

// PolybaseSettingsRejectType enumerates the values for polybase settings reject type.
type PolybaseSettingsRejectType string

const (
	// Percentage ...
	Percentage PolybaseSettingsRejectType = "percentage"
	// Value ...
	Value PolybaseSettingsRejectType = "value"
)

// PossiblePolybaseSettingsRejectTypeValues returns an array of possible values for the PolybaseSettingsRejectType const type.
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return []PolybaseSettingsRejectType{Percentage, Value}
}

// PrestoAuthenticationType enumerates the values for presto authentication type.
type PrestoAuthenticationType string

const (
	// PrestoAuthenticationTypeAnonymous ...
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = "Anonymous"
	// PrestoAuthenticationTypeLDAP ...
	PrestoAuthenticationTypeLDAP PrestoAuthenticationType = "LDAP"
)

// PossiblePrestoAuthenticationTypeValues returns an array of possible values for the PrestoAuthenticationType const type.
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return []PrestoAuthenticationType{PrestoAuthenticationTypeAnonymous, PrestoAuthenticationTypeLDAP}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day ...
	Day RecurrenceFrequency = "Day"
	// Hour ...
	Hour RecurrenceFrequency = "Hour"
	// Minute ...
	Minute RecurrenceFrequency = "Minute"
	// Month ...
	Month RecurrenceFrequency = "Month"
	// NotSpecified ...
	NotSpecified RecurrenceFrequency = "NotSpecified"
	// Week ...
	Week RecurrenceFrequency = "Week"
	// Year ...
	Year RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{Day, Hour, Minute, Month, NotSpecified, Week, Year}
}

// RestServiceAuthenticationType enumerates the values for rest service authentication type.
type RestServiceAuthenticationType string

const (
	// RestServiceAuthenticationTypeAadServicePrincipal ...
	RestServiceAuthenticationTypeAadServicePrincipal RestServiceAuthenticationType = "AadServicePrincipal"
	// RestServiceAuthenticationTypeAnonymous ...
	RestServiceAuthenticationTypeAnonymous RestServiceAuthenticationType = "Anonymous"
	// RestServiceAuthenticationTypeBasic ...
	RestServiceAuthenticationTypeBasic RestServiceAuthenticationType = "Basic"
	// RestServiceAuthenticationTypeManagedServiceIdentity ...
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = "ManagedServiceIdentity"
)

// PossibleRestServiceAuthenticationTypeValues returns an array of possible values for the RestServiceAuthenticationType const type.
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return []RestServiceAuthenticationType{RestServiceAuthenticationTypeAadServicePrincipal, RestServiceAuthenticationTypeAnonymous, RestServiceAuthenticationTypeBasic, RestServiceAuthenticationTypeManagedServiceIdentity}
}

// RunQueryFilterOperand enumerates the values for run query filter operand.
type RunQueryFilterOperand string

const (
	// ActivityName ...
	ActivityName RunQueryFilterOperand = "ActivityName"
	// ActivityRunEnd ...
	ActivityRunEnd RunQueryFilterOperand = "ActivityRunEnd"
	// ActivityRunStart ...
	ActivityRunStart RunQueryFilterOperand = "ActivityRunStart"
	// ActivityType ...
	ActivityType RunQueryFilterOperand = "ActivityType"
	// LatestOnly ...
	LatestOnly RunQueryFilterOperand = "LatestOnly"
	// PipelineName ...
	PipelineName RunQueryFilterOperand = "PipelineName"
	// RunEnd ...
	RunEnd RunQueryFilterOperand = "RunEnd"
	// RunGroupID ...
	RunGroupID RunQueryFilterOperand = "RunGroupId"
	// RunStart ...
	RunStart RunQueryFilterOperand = "RunStart"
	// Status ...
	Status RunQueryFilterOperand = "Status"
	// TriggerName ...
	TriggerName RunQueryFilterOperand = "TriggerName"
	// TriggerRunTimestamp ...
	TriggerRunTimestamp RunQueryFilterOperand = "TriggerRunTimestamp"
)

// PossibleRunQueryFilterOperandValues returns an array of possible values for the RunQueryFilterOperand const type.
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return []RunQueryFilterOperand{ActivityName, ActivityRunEnd, ActivityRunStart, ActivityType, LatestOnly, PipelineName, RunEnd, RunGroupID, RunStart, Status, TriggerName, TriggerRunTimestamp}
}

// RunQueryFilterOperator enumerates the values for run query filter operator.
type RunQueryFilterOperator string

const (
	// Equals ...
	Equals RunQueryFilterOperator = "Equals"
	// In ...
	In RunQueryFilterOperator = "In"
	// NotEquals ...
	NotEquals RunQueryFilterOperator = "NotEquals"
	// NotIn ...
	NotIn RunQueryFilterOperator = "NotIn"
)

// PossibleRunQueryFilterOperatorValues returns an array of possible values for the RunQueryFilterOperator const type.
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return []RunQueryFilterOperator{Equals, In, NotEquals, NotIn}
}

// RunQueryOrder enumerates the values for run query order.
type RunQueryOrder string

const (
	// ASC ...
	ASC RunQueryOrder = "ASC"
	// DESC ...
	DESC RunQueryOrder = "DESC"
)

// PossibleRunQueryOrderValues returns an array of possible values for the RunQueryOrder const type.
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return []RunQueryOrder{ASC, DESC}
}

// RunQueryOrderByField enumerates the values for run query order by field.
type RunQueryOrderByField string

const (
	// RunQueryOrderByFieldActivityName ...
	RunQueryOrderByFieldActivityName RunQueryOrderByField = "ActivityName"
	// RunQueryOrderByFieldActivityRunEnd ...
	RunQueryOrderByFieldActivityRunEnd RunQueryOrderByField = "ActivityRunEnd"
	// RunQueryOrderByFieldActivityRunStart ...
	RunQueryOrderByFieldActivityRunStart RunQueryOrderByField = "ActivityRunStart"
	// RunQueryOrderByFieldPipelineName ...
	RunQueryOrderByFieldPipelineName RunQueryOrderByField = "PipelineName"
	// RunQueryOrderByFieldRunEnd ...
	RunQueryOrderByFieldRunEnd RunQueryOrderByField = "RunEnd"
	// RunQueryOrderByFieldRunStart ...
	RunQueryOrderByFieldRunStart RunQueryOrderByField = "RunStart"
	// RunQueryOrderByFieldStatus ...
	RunQueryOrderByFieldStatus RunQueryOrderByField = "Status"
	// RunQueryOrderByFieldTriggerName ...
	RunQueryOrderByFieldTriggerName RunQueryOrderByField = "TriggerName"
	// RunQueryOrderByFieldTriggerRunTimestamp ...
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = "TriggerRunTimestamp"
)

// PossibleRunQueryOrderByFieldValues returns an array of possible values for the RunQueryOrderByField const type.
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return []RunQueryOrderByField{RunQueryOrderByFieldActivityName, RunQueryOrderByFieldActivityRunEnd, RunQueryOrderByFieldActivityRunStart, RunQueryOrderByFieldPipelineName, RunQueryOrderByFieldRunEnd, RunQueryOrderByFieldRunStart, RunQueryOrderByFieldStatus, RunQueryOrderByFieldTriggerName, RunQueryOrderByFieldTriggerRunTimestamp}
}

// SalesforceSinkWriteBehavior enumerates the values for salesforce sink write behavior.
type SalesforceSinkWriteBehavior string

const (
	// Insert ...
	Insert SalesforceSinkWriteBehavior = "Insert"
	// Upsert ...
	Upsert SalesforceSinkWriteBehavior = "Upsert"
)

// PossibleSalesforceSinkWriteBehaviorValues returns an array of possible values for the SalesforceSinkWriteBehavior const type.
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return []SalesforceSinkWriteBehavior{Insert, Upsert}
}

// SalesforceSourceReadBehavior enumerates the values for salesforce source read behavior.
type SalesforceSourceReadBehavior string

const (
	// Query ...
	Query SalesforceSourceReadBehavior = "Query"
	// QueryAll ...
	QueryAll SalesforceSourceReadBehavior = "QueryAll"
)

// PossibleSalesforceSourceReadBehaviorValues returns an array of possible values for the SalesforceSourceReadBehavior const type.
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return []SalesforceSourceReadBehavior{Query, QueryAll}
}

// SapCloudForCustomerSinkWriteBehavior enumerates the values for sap cloud for customer sink write behavior.
type SapCloudForCustomerSinkWriteBehavior string

const (
	// SapCloudForCustomerSinkWriteBehaviorInsert ...
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = "Insert"
	// SapCloudForCustomerSinkWriteBehaviorUpdate ...
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = "Update"
)

// PossibleSapCloudForCustomerSinkWriteBehaviorValues returns an array of possible values for the SapCloudForCustomerSinkWriteBehavior const type.
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return []SapCloudForCustomerSinkWriteBehavior{SapCloudForCustomerSinkWriteBehaviorInsert, SapCloudForCustomerSinkWriteBehaviorUpdate}
}

// SapHanaAuthenticationType enumerates the values for sap hana authentication type.
type SapHanaAuthenticationType string

const (
	// SapHanaAuthenticationTypeBasic ...
	SapHanaAuthenticationTypeBasic SapHanaAuthenticationType = "Basic"
	// SapHanaAuthenticationTypeWindows ...
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = "Windows"
)

// PossibleSapHanaAuthenticationTypeValues returns an array of possible values for the SapHanaAuthenticationType const type.
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return []SapHanaAuthenticationType{SapHanaAuthenticationTypeBasic, SapHanaAuthenticationTypeWindows}
}

// SapHanaPartitionOption enumerates the values for sap hana partition option.
type SapHanaPartitionOption string

const (
	// SapHanaPartitionOptionNone ...
	SapHanaPartitionOptionNone SapHanaPartitionOption = "None"
	// SapHanaPartitionOptionPhysicalPartitionsOfTable ...
	SapHanaPartitionOptionPhysicalPartitionsOfTable SapHanaPartitionOption = "PhysicalPartitionsOfTable"
	// SapHanaPartitionOptionSapHanaDynamicRange ...
	SapHanaPartitionOptionSapHanaDynamicRange SapHanaPartitionOption = "SapHanaDynamicRange"
)

// PossibleSapHanaPartitionOptionValues returns an array of possible values for the SapHanaPartitionOption const type.
func PossibleSapHanaPartitionOptionValues() []SapHanaPartitionOption {
	return []SapHanaPartitionOption{SapHanaPartitionOptionNone, SapHanaPartitionOptionPhysicalPartitionsOfTable, SapHanaPartitionOptionSapHanaDynamicRange}
}

// SapTablePartitionOption enumerates the values for sap table partition option.
type SapTablePartitionOption string

const (
	// SapTablePartitionOptionNone ...
	SapTablePartitionOptionNone SapTablePartitionOption = "None"
	// SapTablePartitionOptionPartitionOnCalendarDate ...
	SapTablePartitionOptionPartitionOnCalendarDate SapTablePartitionOption = "PartitionOnCalendarDate"
	// SapTablePartitionOptionPartitionOnCalendarMonth ...
	SapTablePartitionOptionPartitionOnCalendarMonth SapTablePartitionOption = "PartitionOnCalendarMonth"
	// SapTablePartitionOptionPartitionOnCalendarYear ...
	SapTablePartitionOptionPartitionOnCalendarYear SapTablePartitionOption = "PartitionOnCalendarYear"
	// SapTablePartitionOptionPartitionOnInt ...
	SapTablePartitionOptionPartitionOnInt SapTablePartitionOption = "PartitionOnInt"
	// SapTablePartitionOptionPartitionOnTime ...
	SapTablePartitionOptionPartitionOnTime SapTablePartitionOption = "PartitionOnTime"
)

// PossibleSapTablePartitionOptionValues returns an array of possible values for the SapTablePartitionOption const type.
func PossibleSapTablePartitionOptionValues() []SapTablePartitionOption {
	return []SapTablePartitionOption{SapTablePartitionOptionNone, SapTablePartitionOptionPartitionOnCalendarDate, SapTablePartitionOptionPartitionOnCalendarMonth, SapTablePartitionOptionPartitionOnCalendarYear, SapTablePartitionOptionPartitionOnInt, SapTablePartitionOptionPartitionOnTime}
}

// SelfHostedIntegrationRuntimeNodeStatus enumerates the values for self hosted integration runtime node
// status.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	// SelfHostedIntegrationRuntimeNodeStatusInitializeFailed ...
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	// SelfHostedIntegrationRuntimeNodeStatusInitializing ...
	SelfHostedIntegrationRuntimeNodeStatusInitializing SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	// SelfHostedIntegrationRuntimeNodeStatusLimited ...
	SelfHostedIntegrationRuntimeNodeStatusLimited SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	// SelfHostedIntegrationRuntimeNodeStatusNeedRegistration ...
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	// SelfHostedIntegrationRuntimeNodeStatusOffline ...
	SelfHostedIntegrationRuntimeNodeStatusOffline SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	// SelfHostedIntegrationRuntimeNodeStatusOnline ...
	SelfHostedIntegrationRuntimeNodeStatusOnline SelfHostedIntegrationRuntimeNodeStatus = "Online"
	// SelfHostedIntegrationRuntimeNodeStatusUpgrading ...
	SelfHostedIntegrationRuntimeNodeStatusUpgrading SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns an array of possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{SelfHostedIntegrationRuntimeNodeStatusInitializeFailed, SelfHostedIntegrationRuntimeNodeStatusInitializing, SelfHostedIntegrationRuntimeNodeStatusLimited, SelfHostedIntegrationRuntimeNodeStatusNeedRegistration, SelfHostedIntegrationRuntimeNodeStatusOffline, SelfHostedIntegrationRuntimeNodeStatusOnline, SelfHostedIntegrationRuntimeNodeStatusUpgrading}
}

// ServiceNowAuthenticationType enumerates the values for service now authentication type.
type ServiceNowAuthenticationType string

const (
	// ServiceNowAuthenticationTypeBasic ...
	ServiceNowAuthenticationTypeBasic ServiceNowAuthenticationType = "Basic"
	// ServiceNowAuthenticationTypeOAuth2 ...
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = "OAuth2"
)

// PossibleServiceNowAuthenticationTypeValues returns an array of possible values for the ServiceNowAuthenticationType const type.
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return []ServiceNowAuthenticationType{ServiceNowAuthenticationTypeBasic, ServiceNowAuthenticationTypeOAuth2}
}

// SftpAuthenticationType enumerates the values for sftp authentication type.
type SftpAuthenticationType string

const (
	// SftpAuthenticationTypeBasic ...
	SftpAuthenticationTypeBasic SftpAuthenticationType = "Basic"
	// SftpAuthenticationTypeSSHPublicKey ...
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = "SshPublicKey"
)

// PossibleSftpAuthenticationTypeValues returns an array of possible values for the SftpAuthenticationType const type.
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return []SftpAuthenticationType{SftpAuthenticationTypeBasic, SftpAuthenticationTypeSSHPublicKey}
}

// SparkAuthenticationType enumerates the values for spark authentication type.
type SparkAuthenticationType string

const (
	// SparkAuthenticationTypeAnonymous ...
	SparkAuthenticationTypeAnonymous SparkAuthenticationType = "Anonymous"
	// SparkAuthenticationTypeUsername ...
	SparkAuthenticationTypeUsername SparkAuthenticationType = "Username"
	// SparkAuthenticationTypeUsernameAndPassword ...
	SparkAuthenticationTypeUsernameAndPassword SparkAuthenticationType = "UsernameAndPassword"
	// SparkAuthenticationTypeWindowsAzureHDInsightService ...
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleSparkAuthenticationTypeValues returns an array of possible values for the SparkAuthenticationType const type.
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return []SparkAuthenticationType{SparkAuthenticationTypeAnonymous, SparkAuthenticationTypeUsername, SparkAuthenticationTypeUsernameAndPassword, SparkAuthenticationTypeWindowsAzureHDInsightService}
}

// SparkServerType enumerates the values for spark server type.
type SparkServerType string

const (
	// SharkServer ...
	SharkServer SparkServerType = "SharkServer"
	// SharkServer2 ...
	SharkServer2 SparkServerType = "SharkServer2"
	// SparkThriftServer ...
	SparkThriftServer SparkServerType = "SparkThriftServer"
)

// PossibleSparkServerTypeValues returns an array of possible values for the SparkServerType const type.
func PossibleSparkServerTypeValues() []SparkServerType {
	return []SparkServerType{SharkServer, SharkServer2, SparkThriftServer}
}

// SparkThriftTransportProtocol enumerates the values for spark thrift transport protocol.
type SparkThriftTransportProtocol string

const (
	// SparkThriftTransportProtocolBinary ...
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = "Binary"
	// SparkThriftTransportProtocolHTTP ...
	SparkThriftTransportProtocolHTTP SparkThriftTransportProtocol = "HTTP "
	// SparkThriftTransportProtocolSASL ...
	SparkThriftTransportProtocolSASL SparkThriftTransportProtocol = "SASL"
)

// PossibleSparkThriftTransportProtocolValues returns an array of possible values for the SparkThriftTransportProtocol const type.
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return []SparkThriftTransportProtocol{SparkThriftTransportProtocolBinary, SparkThriftTransportProtocolHTTP, SparkThriftTransportProtocolSASL}
}

// SQLPartitionOption enumerates the values for sql partition option.
type SQLPartitionOption string

const (
	// SQLPartitionOptionDynamicRange ...
	SQLPartitionOptionDynamicRange SQLPartitionOption = "DynamicRange"
	// SQLPartitionOptionNone ...
	SQLPartitionOptionNone SQLPartitionOption = "None"
	// SQLPartitionOptionPhysicalPartitionsOfTable ...
	SQLPartitionOptionPhysicalPartitionsOfTable SQLPartitionOption = "PhysicalPartitionsOfTable"
)

// PossibleSQLPartitionOptionValues returns an array of possible values for the SQLPartitionOption const type.
func PossibleSQLPartitionOptionValues() []SQLPartitionOption {
	return []SQLPartitionOption{SQLPartitionOptionDynamicRange, SQLPartitionOptionNone, SQLPartitionOptionPhysicalPartitionsOfTable}
}

// SsisObjectMetadataType enumerates the values for ssis object metadata type.
type SsisObjectMetadataType string

const (
	// Environment ...
	Environment SsisObjectMetadataType = "Environment"
	// Folder ...
	Folder SsisObjectMetadataType = "Folder"
	// Package ...
	Package SsisObjectMetadataType = "Package"
	// Project ...
	Project SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns an array of possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{Environment, Folder, Package, Project}
}

// SsisPackageLocationType enumerates the values for ssis package location type.
type SsisPackageLocationType string

const (
	// SsisPackageLocationTypeFile ...
	SsisPackageLocationTypeFile SsisPackageLocationType = "File"
	// SsisPackageLocationTypeInlinePackage ...
	SsisPackageLocationTypeInlinePackage SsisPackageLocationType = "InlinePackage"
	// SsisPackageLocationTypePackageStore ...
	SsisPackageLocationTypePackageStore SsisPackageLocationType = "PackageStore"
	// SsisPackageLocationTypeSSISDB ...
	SsisPackageLocationTypeSSISDB SsisPackageLocationType = "SSISDB"
)

// PossibleSsisPackageLocationTypeValues returns an array of possible values for the SsisPackageLocationType const type.
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return []SsisPackageLocationType{SsisPackageLocationTypeFile, SsisPackageLocationTypeInlinePackage, SsisPackageLocationTypePackageStore, SsisPackageLocationTypeSSISDB}
}

// StoredProcedureParameterType enumerates the values for stored procedure parameter type.
type StoredProcedureParameterType string

const (
	// StoredProcedureParameterTypeBoolean ...
	StoredProcedureParameterTypeBoolean StoredProcedureParameterType = "Boolean"
	// StoredProcedureParameterTypeDate ...
	StoredProcedureParameterTypeDate StoredProcedureParameterType = "Date"
	// StoredProcedureParameterTypeDecimal ...
	StoredProcedureParameterTypeDecimal StoredProcedureParameterType = "Decimal"
	// StoredProcedureParameterTypeGUID ...
	StoredProcedureParameterTypeGUID StoredProcedureParameterType = "Guid"
	// StoredProcedureParameterTypeInt ...
	StoredProcedureParameterTypeInt StoredProcedureParameterType = "Int"
	// StoredProcedureParameterTypeInt64 ...
	StoredProcedureParameterTypeInt64 StoredProcedureParameterType = "Int64"
	// StoredProcedureParameterTypeString ...
	StoredProcedureParameterTypeString StoredProcedureParameterType = "String"
)

// PossibleStoredProcedureParameterTypeValues returns an array of possible values for the StoredProcedureParameterType const type.
func PossibleStoredProcedureParameterTypeValues() []StoredProcedureParameterType {
	return []StoredProcedureParameterType{StoredProcedureParameterTypeBoolean, StoredProcedureParameterTypeDate, StoredProcedureParameterTypeDecimal, StoredProcedureParameterTypeGUID, StoredProcedureParameterTypeInt, StoredProcedureParameterTypeInt64, StoredProcedureParameterTypeString}
}

// SybaseAuthenticationType enumerates the values for sybase authentication type.
type SybaseAuthenticationType string

const (
	// SybaseAuthenticationTypeBasic ...
	SybaseAuthenticationTypeBasic SybaseAuthenticationType = "Basic"
	// SybaseAuthenticationTypeWindows ...
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = "Windows"
)

// PossibleSybaseAuthenticationTypeValues returns an array of possible values for the SybaseAuthenticationType const type.
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return []SybaseAuthenticationType{SybaseAuthenticationTypeBasic, SybaseAuthenticationTypeWindows}
}

// TeradataAuthenticationType enumerates the values for teradata authentication type.
type TeradataAuthenticationType string

const (
	// TeradataAuthenticationTypeBasic ...
	TeradataAuthenticationTypeBasic TeradataAuthenticationType = "Basic"
	// TeradataAuthenticationTypeWindows ...
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = "Windows"
)

// PossibleTeradataAuthenticationTypeValues returns an array of possible values for the TeradataAuthenticationType const type.
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return []TeradataAuthenticationType{TeradataAuthenticationTypeBasic, TeradataAuthenticationTypeWindows}
}

// TeradataPartitionOption enumerates the values for teradata partition option.
type TeradataPartitionOption string

const (
	// TeradataPartitionOptionDynamicRange ...
	TeradataPartitionOptionDynamicRange TeradataPartitionOption = "DynamicRange"
	// TeradataPartitionOptionHash ...
	TeradataPartitionOptionHash TeradataPartitionOption = "Hash"
	// TeradataPartitionOptionNone ...
	TeradataPartitionOptionNone TeradataPartitionOption = "None"
)

// PossibleTeradataPartitionOptionValues returns an array of possible values for the TeradataPartitionOption const type.
func PossibleTeradataPartitionOptionValues() []TeradataPartitionOption {
	return []TeradataPartitionOption{TeradataPartitionOptionDynamicRange, TeradataPartitionOptionHash, TeradataPartitionOptionNone}
}

// TriggerRunStatus enumerates the values for trigger run status.
type TriggerRunStatus string

const (
	// TriggerRunStatusFailed ...
	TriggerRunStatusFailed TriggerRunStatus = "Failed"
	// TriggerRunStatusInprogress ...
	TriggerRunStatusInprogress TriggerRunStatus = "Inprogress"
	// TriggerRunStatusSucceeded ...
	TriggerRunStatusSucceeded TriggerRunStatus = "Succeeded"
)

// PossibleTriggerRunStatusValues returns an array of possible values for the TriggerRunStatus const type.
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return []TriggerRunStatus{TriggerRunStatusFailed, TriggerRunStatusInprogress, TriggerRunStatusSucceeded}
}

// TriggerRuntimeState enumerates the values for trigger runtime state.
type TriggerRuntimeState string

const (
	// TriggerRuntimeStateDisabled ...
	TriggerRuntimeStateDisabled TriggerRuntimeState = "Disabled"
	// TriggerRuntimeStateStarted ...
	TriggerRuntimeStateStarted TriggerRuntimeState = "Started"
	// TriggerRuntimeStateStopped ...
	TriggerRuntimeStateStopped TriggerRuntimeState = "Stopped"
)

// PossibleTriggerRuntimeStateValues returns an array of possible values for the TriggerRuntimeState const type.
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return []TriggerRuntimeState{TriggerRuntimeStateDisabled, TriggerRuntimeStateStarted, TriggerRuntimeStateStopped}
}

// TumblingWindowFrequency enumerates the values for tumbling window frequency.
type TumblingWindowFrequency string

const (
	// TumblingWindowFrequencyHour ...
	TumblingWindowFrequencyHour TumblingWindowFrequency = "Hour"
	// TumblingWindowFrequencyMinute ...
	TumblingWindowFrequencyMinute TumblingWindowFrequency = "Minute"
)

// PossibleTumblingWindowFrequencyValues returns an array of possible values for the TumblingWindowFrequency const type.
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return []TumblingWindowFrequency{TumblingWindowFrequencyHour, TumblingWindowFrequencyMinute}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAzureKeyVaultSecret ...
	TypeAzureKeyVaultSecret Type = "AzureKeyVaultSecret"
	// TypeSecretBase ...
	TypeSecretBase Type = "SecretBase"
	// TypeSecureString ...
	TypeSecureString Type = "SecureString"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAzureKeyVaultSecret, TypeSecretBase, TypeSecureString}
}

// TypeBasicActivity enumerates the values for type basic activity.
type TypeBasicActivity string

const (
	// TypeActivity ...
	TypeActivity TypeBasicActivity = "Activity"
	// TypeAppendVariable ...
	TypeAppendVariable TypeBasicActivity = "AppendVariable"
	// TypeAzureDataExplorerCommand ...
	TypeAzureDataExplorerCommand TypeBasicActivity = "AzureDataExplorerCommand"
	// TypeAzureFunctionActivity ...
	TypeAzureFunctionActivity TypeBasicActivity = "AzureFunctionActivity"
	// TypeAzureMLBatchExecution ...
	TypeAzureMLBatchExecution TypeBasicActivity = "AzureMLBatchExecution"
	// TypeAzureMLExecutePipeline ...
	TypeAzureMLExecutePipeline TypeBasicActivity = "AzureMLExecutePipeline"
	// TypeAzureMLUpdateResource ...
	TypeAzureMLUpdateResource TypeBasicActivity = "AzureMLUpdateResource"
	// TypeContainer ...
	TypeContainer TypeBasicActivity = "Container"
	// TypeCopy ...
	TypeCopy TypeBasicActivity = "Copy"
	// TypeCustom ...
	TypeCustom TypeBasicActivity = "Custom"
	// TypeDatabricksNotebook ...
	TypeDatabricksNotebook TypeBasicActivity = "DatabricksNotebook"
	// TypeDatabricksSparkJar ...
	TypeDatabricksSparkJar TypeBasicActivity = "DatabricksSparkJar"
	// TypeDatabricksSparkPython ...
	TypeDatabricksSparkPython TypeBasicActivity = "DatabricksSparkPython"
	// TypeDataLakeAnalyticsUSQL ...
	TypeDataLakeAnalyticsUSQL TypeBasicActivity = "DataLakeAnalyticsU-SQL"
	// TypeDelete ...
	TypeDelete TypeBasicActivity = "Delete"
	// TypeExecuteDataFlow ...
	TypeExecuteDataFlow TypeBasicActivity = "ExecuteDataFlow"
	// TypeExecutePipeline ...
	TypeExecutePipeline TypeBasicActivity = "ExecutePipeline"
	// TypeExecuteSSISPackage ...
	TypeExecuteSSISPackage TypeBasicActivity = "ExecuteSSISPackage"
	// TypeExecution ...
	TypeExecution TypeBasicActivity = "Execution"
	// TypeFilter ...
	TypeFilter TypeBasicActivity = "Filter"
	// TypeForEach ...
	TypeForEach TypeBasicActivity = "ForEach"
	// TypeGetMetadata ...
	TypeGetMetadata TypeBasicActivity = "GetMetadata"
	// TypeHDInsightHive ...
	TypeHDInsightHive TypeBasicActivity = "HDInsightHive"
	// TypeHDInsightMapReduce ...
	TypeHDInsightMapReduce TypeBasicActivity = "HDInsightMapReduce"
	// TypeHDInsightPig ...
	TypeHDInsightPig TypeBasicActivity = "HDInsightPig"
	// TypeHDInsightSpark ...
	TypeHDInsightSpark TypeBasicActivity = "HDInsightSpark"
	// TypeHDInsightStreaming ...
	TypeHDInsightStreaming TypeBasicActivity = "HDInsightStreaming"
	// TypeIfCondition ...
	TypeIfCondition TypeBasicActivity = "IfCondition"
	// TypeLookup ...
	TypeLookup TypeBasicActivity = "Lookup"
	// TypeSetVariable ...
	TypeSetVariable TypeBasicActivity = "SetVariable"
	// TypeSQLServerStoredProcedure ...
	TypeSQLServerStoredProcedure TypeBasicActivity = "SqlServerStoredProcedure"
	// TypeSwitch ...
	TypeSwitch TypeBasicActivity = "Switch"
	// TypeUntil ...
	TypeUntil TypeBasicActivity = "Until"
	// TypeValidation ...
	TypeValidation TypeBasicActivity = "Validation"
	// TypeWait ...
	TypeWait TypeBasicActivity = "Wait"
	// TypeWebActivity ...
	TypeWebActivity TypeBasicActivity = "WebActivity"
	// TypeWebHook ...
	TypeWebHook TypeBasicActivity = "WebHook"
)

// PossibleTypeBasicActivityValues returns an array of possible values for the TypeBasicActivity const type.
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return []TypeBasicActivity{TypeActivity, TypeAppendVariable, TypeAzureDataExplorerCommand, TypeAzureFunctionActivity, TypeAzureMLBatchExecution, TypeAzureMLExecutePipeline, TypeAzureMLUpdateResource, TypeContainer, TypeCopy, TypeCustom, TypeDatabricksNotebook, TypeDatabricksSparkJar, TypeDatabricksSparkPython, TypeDataLakeAnalyticsUSQL, TypeDelete, TypeExecuteDataFlow, TypeExecutePipeline, TypeExecuteSSISPackage, TypeExecution, TypeFilter, TypeForEach, TypeGetMetadata, TypeHDInsightHive, TypeHDInsightMapReduce, TypeHDInsightPig, TypeHDInsightSpark, TypeHDInsightStreaming, TypeIfCondition, TypeLookup, TypeSetVariable, TypeSQLServerStoredProcedure, TypeSwitch, TypeUntil, TypeValidation, TypeWait, TypeWebActivity, TypeWebHook}
}

// TypeBasicCompressionReadSettings enumerates the values for type basic compression read settings.
type TypeBasicCompressionReadSettings string

const (
	// TypeCompressionReadSettings ...
	TypeCompressionReadSettings TypeBasicCompressionReadSettings = "CompressionReadSettings"
	// TypeTarGZipReadSettings ...
	TypeTarGZipReadSettings TypeBasicCompressionReadSettings = "TarGZipReadSettings"
	// TypeTarReadSettings ...
	TypeTarReadSettings TypeBasicCompressionReadSettings = "TarReadSettings"
	// TypeZipDeflateReadSettings ...
	TypeZipDeflateReadSettings TypeBasicCompressionReadSettings = "ZipDeflateReadSettings"
)

// PossibleTypeBasicCompressionReadSettingsValues returns an array of possible values for the TypeBasicCompressionReadSettings const type.
func PossibleTypeBasicCompressionReadSettingsValues() []TypeBasicCompressionReadSettings {
	return []TypeBasicCompressionReadSettings{TypeCompressionReadSettings, TypeTarGZipReadSettings, TypeTarReadSettings, TypeZipDeflateReadSettings}
}

// TypeBasicCopySink enumerates the values for type basic copy sink.
type TypeBasicCopySink string

const (
	// TypeAvroSink ...
	TypeAvroSink TypeBasicCopySink = "AvroSink"
	// TypeAzureBlobFSSink ...
	TypeAzureBlobFSSink TypeBasicCopySink = "AzureBlobFSSink"
	// TypeAzureDataExplorerSink ...
	TypeAzureDataExplorerSink TypeBasicCopySink = "AzureDataExplorerSink"
	// TypeAzureDataLakeStoreSink ...
	TypeAzureDataLakeStoreSink TypeBasicCopySink = "AzureDataLakeStoreSink"
	// TypeAzureMySQLSink ...
	TypeAzureMySQLSink TypeBasicCopySink = "AzureMySqlSink"
	// TypeAzurePostgreSQLSink ...
	TypeAzurePostgreSQLSink TypeBasicCopySink = "AzurePostgreSqlSink"
	// TypeAzureQueueSink ...
	TypeAzureQueueSink TypeBasicCopySink = "AzureQueueSink"
	// TypeAzureSearchIndexSink ...
	TypeAzureSearchIndexSink TypeBasicCopySink = "AzureSearchIndexSink"
	// TypeAzureSQLSink ...
	TypeAzureSQLSink TypeBasicCopySink = "AzureSqlSink"
	// TypeAzureTableSink ...
	TypeAzureTableSink TypeBasicCopySink = "AzureTableSink"
	// TypeBinarySink ...
	TypeBinarySink TypeBasicCopySink = "BinarySink"
	// TypeBlobSink ...
	TypeBlobSink TypeBasicCopySink = "BlobSink"
	// TypeCommonDataServiceForAppsSink ...
	TypeCommonDataServiceForAppsSink TypeBasicCopySink = "CommonDataServiceForAppsSink"
	// TypeCopySink ...
	TypeCopySink TypeBasicCopySink = "CopySink"
	// TypeCosmosDbMongoDbAPISink ...
	TypeCosmosDbMongoDbAPISink TypeBasicCopySink = "CosmosDbMongoDbApiSink"
	// TypeCosmosDbSQLAPISink ...
	TypeCosmosDbSQLAPISink TypeBasicCopySink = "CosmosDbSqlApiSink"
	// TypeDelimitedTextSink ...
	TypeDelimitedTextSink TypeBasicCopySink = "DelimitedTextSink"
	// TypeDocumentDbCollectionSink ...
	TypeDocumentDbCollectionSink TypeBasicCopySink = "DocumentDbCollectionSink"
	// TypeDynamicsCrmSink ...
	TypeDynamicsCrmSink TypeBasicCopySink = "DynamicsCrmSink"
	// TypeDynamicsSink ...
	TypeDynamicsSink TypeBasicCopySink = "DynamicsSink"
	// TypeFileSystemSink ...
	TypeFileSystemSink TypeBasicCopySink = "FileSystemSink"
	// TypeInformixSink ...
	TypeInformixSink TypeBasicCopySink = "InformixSink"
	// TypeJSONSink ...
	TypeJSONSink TypeBasicCopySink = "JsonSink"
	// TypeMicrosoftAccessSink ...
	TypeMicrosoftAccessSink TypeBasicCopySink = "MicrosoftAccessSink"
	// TypeOdbcSink ...
	TypeOdbcSink TypeBasicCopySink = "OdbcSink"
	// TypeOracleSink ...
	TypeOracleSink TypeBasicCopySink = "OracleSink"
	// TypeOrcSink ...
	TypeOrcSink TypeBasicCopySink = "OrcSink"
	// TypeParquetSink ...
	TypeParquetSink TypeBasicCopySink = "ParquetSink"
	// TypeRestSink ...
	TypeRestSink TypeBasicCopySink = "RestSink"
	// TypeSalesforceServiceCloudSink ...
	TypeSalesforceServiceCloudSink TypeBasicCopySink = "SalesforceServiceCloudSink"
	// TypeSalesforceSink ...
	TypeSalesforceSink TypeBasicCopySink = "SalesforceSink"
	// TypeSapCloudForCustomerSink ...
	TypeSapCloudForCustomerSink TypeBasicCopySink = "SapCloudForCustomerSink"
	// TypeSnowflakeSink ...
	TypeSnowflakeSink TypeBasicCopySink = "SnowflakeSink"
	// TypeSQLDWSink ...
	TypeSQLDWSink TypeBasicCopySink = "SqlDWSink"
	// TypeSQLMISink ...
	TypeSQLMISink TypeBasicCopySink = "SqlMISink"
	// TypeSQLServerSink ...
	TypeSQLServerSink TypeBasicCopySink = "SqlServerSink"
	// TypeSQLSink ...
	TypeSQLSink TypeBasicCopySink = "SqlSink"
)

// PossibleTypeBasicCopySinkValues returns an array of possible values for the TypeBasicCopySink const type.
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return []TypeBasicCopySink{TypeAvroSink, TypeAzureBlobFSSink, TypeAzureDataExplorerSink, TypeAzureDataLakeStoreSink, TypeAzureMySQLSink, TypeAzurePostgreSQLSink, TypeAzureQueueSink, TypeAzureSearchIndexSink, TypeAzureSQLSink, TypeAzureTableSink, TypeBinarySink, TypeBlobSink, TypeCommonDataServiceForAppsSink, TypeCopySink, TypeCosmosDbMongoDbAPISink, TypeCosmosDbSQLAPISink, TypeDelimitedTextSink, TypeDocumentDbCollectionSink, TypeDynamicsCrmSink, TypeDynamicsSink, TypeFileSystemSink, TypeInformixSink, TypeJSONSink, TypeMicrosoftAccessSink, TypeOdbcSink, TypeOracleSink, TypeOrcSink, TypeParquetSink, TypeRestSink, TypeSalesforceServiceCloudSink, TypeSalesforceSink, TypeSapCloudForCustomerSink, TypeSnowflakeSink, TypeSQLDWSink, TypeSQLMISink, TypeSQLServerSink, TypeSQLSink}
}

// TypeBasicCopySource enumerates the values for type basic copy source.
type TypeBasicCopySource string

const (
	// TypeAmazonMWSSource ...
	TypeAmazonMWSSource TypeBasicCopySource = "AmazonMWSSource"
	// TypeAmazonRedshiftSource ...
	TypeAmazonRedshiftSource TypeBasicCopySource = "AmazonRedshiftSource"
	// TypeAvroSource ...
	TypeAvroSource TypeBasicCopySource = "AvroSource"
	// TypeAzureBlobFSSource ...
	TypeAzureBlobFSSource TypeBasicCopySource = "AzureBlobFSSource"
	// TypeAzureDataExplorerSource ...
	TypeAzureDataExplorerSource TypeBasicCopySource = "AzureDataExplorerSource"
	// TypeAzureDataLakeStoreSource ...
	TypeAzureDataLakeStoreSource TypeBasicCopySource = "AzureDataLakeStoreSource"
	// TypeAzureMariaDBSource ...
	TypeAzureMariaDBSource TypeBasicCopySource = "AzureMariaDBSource"
	// TypeAzureMySQLSource ...
	TypeAzureMySQLSource TypeBasicCopySource = "AzureMySqlSource"
	// TypeAzurePostgreSQLSource ...
	TypeAzurePostgreSQLSource TypeBasicCopySource = "AzurePostgreSqlSource"
	// TypeAzureSQLSource ...
	TypeAzureSQLSource TypeBasicCopySource = "AzureSqlSource"
	// TypeAzureTableSource ...
	TypeAzureTableSource TypeBasicCopySource = "AzureTableSource"
	// TypeBinarySource ...
	TypeBinarySource TypeBasicCopySource = "BinarySource"
	// TypeBlobSource ...
	TypeBlobSource TypeBasicCopySource = "BlobSource"
	// TypeCassandraSource ...
	TypeCassandraSource TypeBasicCopySource = "CassandraSource"
	// TypeCommonDataServiceForAppsSource ...
	TypeCommonDataServiceForAppsSource TypeBasicCopySource = "CommonDataServiceForAppsSource"
	// TypeConcurSource ...
	TypeConcurSource TypeBasicCopySource = "ConcurSource"
	// TypeCopySource ...
	TypeCopySource TypeBasicCopySource = "CopySource"
	// TypeCosmosDbMongoDbAPISource ...
	TypeCosmosDbMongoDbAPISource TypeBasicCopySource = "CosmosDbMongoDbApiSource"
	// TypeCosmosDbSQLAPISource ...
	TypeCosmosDbSQLAPISource TypeBasicCopySource = "CosmosDbSqlApiSource"
	// TypeCouchbaseSource ...
	TypeCouchbaseSource TypeBasicCopySource = "CouchbaseSource"
	// TypeDb2Source ...
	TypeDb2Source TypeBasicCopySource = "Db2Source"
	// TypeDelimitedTextSource ...
	TypeDelimitedTextSource TypeBasicCopySource = "DelimitedTextSource"
	// TypeDocumentDbCollectionSource ...
	TypeDocumentDbCollectionSource TypeBasicCopySource = "DocumentDbCollectionSource"
	// TypeDrillSource ...
	TypeDrillSource TypeBasicCopySource = "DrillSource"
	// TypeDynamicsAXSource ...
	TypeDynamicsAXSource TypeBasicCopySource = "DynamicsAXSource"
	// TypeDynamicsCrmSource ...
	TypeDynamicsCrmSource TypeBasicCopySource = "DynamicsCrmSource"
	// TypeDynamicsSource ...
	TypeDynamicsSource TypeBasicCopySource = "DynamicsSource"
	// TypeEloquaSource ...
	TypeEloquaSource TypeBasicCopySource = "EloquaSource"
	// TypeExcelSource ...
	TypeExcelSource TypeBasicCopySource = "ExcelSource"
	// TypeFileSystemSource ...
	TypeFileSystemSource TypeBasicCopySource = "FileSystemSource"
	// TypeGoogleAdWordsSource ...
	TypeGoogleAdWordsSource TypeBasicCopySource = "GoogleAdWordsSource"
	// TypeGoogleBigQuerySource ...
	TypeGoogleBigQuerySource TypeBasicCopySource = "GoogleBigQuerySource"
	// TypeGreenplumSource ...
	TypeGreenplumSource TypeBasicCopySource = "GreenplumSource"
	// TypeHBaseSource ...
	TypeHBaseSource TypeBasicCopySource = "HBaseSource"
	// TypeHdfsSource ...
	TypeHdfsSource TypeBasicCopySource = "HdfsSource"
	// TypeHiveSource ...
	TypeHiveSource TypeBasicCopySource = "HiveSource"
	// TypeHTTPSource ...
	TypeHTTPSource TypeBasicCopySource = "HttpSource"
	// TypeHubspotSource ...
	TypeHubspotSource TypeBasicCopySource = "HubspotSource"
	// TypeImpalaSource ...
	TypeImpalaSource TypeBasicCopySource = "ImpalaSource"
	// TypeInformixSource ...
	TypeInformixSource TypeBasicCopySource = "InformixSource"
	// TypeJiraSource ...
	TypeJiraSource TypeBasicCopySource = "JiraSource"
	// TypeJSONSource ...
	TypeJSONSource TypeBasicCopySource = "JsonSource"
	// TypeMagentoSource ...
	TypeMagentoSource TypeBasicCopySource = "MagentoSource"
	// TypeMariaDBSource ...
	TypeMariaDBSource TypeBasicCopySource = "MariaDBSource"
	// TypeMarketoSource ...
	TypeMarketoSource TypeBasicCopySource = "MarketoSource"
	// TypeMicrosoftAccessSource ...
	TypeMicrosoftAccessSource TypeBasicCopySource = "MicrosoftAccessSource"
	// TypeMongoDbSource ...
	TypeMongoDbSource TypeBasicCopySource = "MongoDbSource"
	// TypeMongoDbV2Source ...
	TypeMongoDbV2Source TypeBasicCopySource = "MongoDbV2Source"
	// TypeMySQLSource ...
	TypeMySQLSource TypeBasicCopySource = "MySqlSource"
	// TypeNetezzaSource ...
	TypeNetezzaSource TypeBasicCopySource = "NetezzaSource"
	// TypeODataSource ...
	TypeODataSource TypeBasicCopySource = "ODataSource"
	// TypeOdbcSource ...
	TypeOdbcSource TypeBasicCopySource = "OdbcSource"
	// TypeOffice365Source ...
	TypeOffice365Source TypeBasicCopySource = "Office365Source"
	// TypeOracleServiceCloudSource ...
	TypeOracleServiceCloudSource TypeBasicCopySource = "OracleServiceCloudSource"
	// TypeOracleSource ...
	TypeOracleSource TypeBasicCopySource = "OracleSource"
	// TypeOrcSource ...
	TypeOrcSource TypeBasicCopySource = "OrcSource"
	// TypeParquetSource ...
	TypeParquetSource TypeBasicCopySource = "ParquetSource"
	// TypePaypalSource ...
	TypePaypalSource TypeBasicCopySource = "PaypalSource"
	// TypePhoenixSource ...
	TypePhoenixSource TypeBasicCopySource = "PhoenixSource"
	// TypePostgreSQLSource ...
	TypePostgreSQLSource TypeBasicCopySource = "PostgreSqlSource"
	// TypePrestoSource ...
	TypePrestoSource TypeBasicCopySource = "PrestoSource"
	// TypeQuickBooksSource ...
	TypeQuickBooksSource TypeBasicCopySource = "QuickBooksSource"
	// TypeRelationalSource ...
	TypeRelationalSource TypeBasicCopySource = "RelationalSource"
	// TypeResponsysSource ...
	TypeResponsysSource TypeBasicCopySource = "ResponsysSource"
	// TypeRestSource ...
	TypeRestSource TypeBasicCopySource = "RestSource"
	// TypeSalesforceMarketingCloudSource ...
	TypeSalesforceMarketingCloudSource TypeBasicCopySource = "SalesforceMarketingCloudSource"
	// TypeSalesforceServiceCloudSource ...
	TypeSalesforceServiceCloudSource TypeBasicCopySource = "SalesforceServiceCloudSource"
	// TypeSalesforceSource ...
	TypeSalesforceSource TypeBasicCopySource = "SalesforceSource"
	// TypeSapBwSource ...
	TypeSapBwSource TypeBasicCopySource = "SapBwSource"
	// TypeSapCloudForCustomerSource ...
	TypeSapCloudForCustomerSource TypeBasicCopySource = "SapCloudForCustomerSource"
	// TypeSapEccSource ...
	TypeSapEccSource TypeBasicCopySource = "SapEccSource"
	// TypeSapHanaSource ...
	TypeSapHanaSource TypeBasicCopySource = "SapHanaSource"
	// TypeSapOpenHubSource ...
	TypeSapOpenHubSource TypeBasicCopySource = "SapOpenHubSource"
	// TypeSapTableSource ...
	TypeSapTableSource TypeBasicCopySource = "SapTableSource"
	// TypeServiceNowSource ...
	TypeServiceNowSource TypeBasicCopySource = "ServiceNowSource"
	// TypeSharePointOnlineListSource ...
	TypeSharePointOnlineListSource TypeBasicCopySource = "SharePointOnlineListSource"
	// TypeShopifySource ...
	TypeShopifySource TypeBasicCopySource = "ShopifySource"
	// TypeSnowflakeSource ...
	TypeSnowflakeSource TypeBasicCopySource = "SnowflakeSource"
	// TypeSparkSource ...
	TypeSparkSource TypeBasicCopySource = "SparkSource"
	// TypeSQLDWSource ...
	TypeSQLDWSource TypeBasicCopySource = "SqlDWSource"
	// TypeSQLMISource ...
	TypeSQLMISource TypeBasicCopySource = "SqlMISource"
	// TypeSQLServerSource ...
	TypeSQLServerSource TypeBasicCopySource = "SqlServerSource"
	// TypeSQLSource ...
	TypeSQLSource TypeBasicCopySource = "SqlSource"
	// TypeSquareSource ...
	TypeSquareSource TypeBasicCopySource = "SquareSource"
	// TypeSybaseSource ...
	TypeSybaseSource TypeBasicCopySource = "SybaseSource"
	// TypeTabularSource ...
	TypeTabularSource TypeBasicCopySource = "TabularSource"
	// TypeTeradataSource ...
	TypeTeradataSource TypeBasicCopySource = "TeradataSource"
	// TypeVerticaSource ...
	TypeVerticaSource TypeBasicCopySource = "VerticaSource"
	// TypeWebSource ...
	TypeWebSource TypeBasicCopySource = "WebSource"
	// TypeXeroSource ...
	TypeXeroSource TypeBasicCopySource = "XeroSource"
	// TypeXMLSource ...
	TypeXMLSource TypeBasicCopySource = "XmlSource"
	// TypeZohoSource ...
	TypeZohoSource TypeBasicCopySource = "ZohoSource"
)

// PossibleTypeBasicCopySourceValues returns an array of possible values for the TypeBasicCopySource const type.
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return []TypeBasicCopySource{TypeAmazonMWSSource, TypeAmazonRedshiftSource, TypeAvroSource, TypeAzureBlobFSSource, TypeAzureDataExplorerSource, TypeAzureDataLakeStoreSource, TypeAzureMariaDBSource, TypeAzureMySQLSource, TypeAzurePostgreSQLSource, TypeAzureSQLSource, TypeAzureTableSource, TypeBinarySource, TypeBlobSource, TypeCassandraSource, TypeCommonDataServiceForAppsSource, TypeConcurSource, TypeCopySource, TypeCosmosDbMongoDbAPISource, TypeCosmosDbSQLAPISource, TypeCouchbaseSource, TypeDb2Source, TypeDelimitedTextSource, TypeDocumentDbCollectionSource, TypeDrillSource, TypeDynamicsAXSource, TypeDynamicsCrmSource, TypeDynamicsSource, TypeEloquaSource, TypeExcelSource, TypeFileSystemSource, TypeGoogleAdWordsSource, TypeGoogleBigQuerySource, TypeGreenplumSource, TypeHBaseSource, TypeHdfsSource, TypeHiveSource, TypeHTTPSource, TypeHubspotSource, TypeImpalaSource, TypeInformixSource, TypeJiraSource, TypeJSONSource, TypeMagentoSource, TypeMariaDBSource, TypeMarketoSource, TypeMicrosoftAccessSource, TypeMongoDbSource, TypeMongoDbV2Source, TypeMySQLSource, TypeNetezzaSource, TypeODataSource, TypeOdbcSource, TypeOffice365Source, TypeOracleServiceCloudSource, TypeOracleSource, TypeOrcSource, TypeParquetSource, TypePaypalSource, TypePhoenixSource, TypePostgreSQLSource, TypePrestoSource, TypeQuickBooksSource, TypeRelationalSource, TypeResponsysSource, TypeRestSource, TypeSalesforceMarketingCloudSource, TypeSalesforceServiceCloudSource, TypeSalesforceSource, TypeSapBwSource, TypeSapCloudForCustomerSource, TypeSapEccSource, TypeSapHanaSource, TypeSapOpenHubSource, TypeSapTableSource, TypeServiceNowSource, TypeSharePointOnlineListSource, TypeShopifySource, TypeSnowflakeSource, TypeSparkSource, TypeSQLDWSource, TypeSQLMISource, TypeSQLServerSource, TypeSQLSource, TypeSquareSource, TypeSybaseSource, TypeTabularSource, TypeTeradataSource, TypeVerticaSource, TypeWebSource, TypeXeroSource, TypeXMLSource, TypeZohoSource}
}

// TypeBasicCustomSetupBase enumerates the values for type basic custom setup base.
type TypeBasicCustomSetupBase string

const (
	// TypeAzPowerShellSetup ...
	TypeAzPowerShellSetup TypeBasicCustomSetupBase = "AzPowerShellSetup"
	// TypeCmdkeySetup ...
	TypeCmdkeySetup TypeBasicCustomSetupBase = "CmdkeySetup"
	// TypeComponentSetup ...
	TypeComponentSetup TypeBasicCustomSetupBase = "ComponentSetup"
	// TypeCustomSetupBase ...
	TypeCustomSetupBase TypeBasicCustomSetupBase = "CustomSetupBase"
	// TypeEnvironmentVariableSetup ...
	TypeEnvironmentVariableSetup TypeBasicCustomSetupBase = "EnvironmentVariableSetup"
)

// PossibleTypeBasicCustomSetupBaseValues returns an array of possible values for the TypeBasicCustomSetupBase const type.
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return []TypeBasicCustomSetupBase{TypeAzPowerShellSetup, TypeCmdkeySetup, TypeComponentSetup, TypeCustomSetupBase, TypeEnvironmentVariableSetup}
}

// TypeBasicDataFlow enumerates the values for type basic data flow.
type TypeBasicDataFlow string

const (
	// TypeDataFlow ...
	TypeDataFlow TypeBasicDataFlow = "DataFlow"
	// TypeMappingDataFlow ...
	TypeMappingDataFlow TypeBasicDataFlow = "MappingDataFlow"
)

// PossibleTypeBasicDataFlowValues returns an array of possible values for the TypeBasicDataFlow const type.
func PossibleTypeBasicDataFlowValues() []TypeBasicDataFlow {
	return []TypeBasicDataFlow{TypeDataFlow, TypeMappingDataFlow}
}

// TypeBasicDataset enumerates the values for type basic dataset.
type TypeBasicDataset string

const (
	// TypeAmazonMWSObject ...
	TypeAmazonMWSObject TypeBasicDataset = "AmazonMWSObject"
	// TypeAmazonRedshiftTable ...
	TypeAmazonRedshiftTable TypeBasicDataset = "AmazonRedshiftTable"
	// TypeAmazonS3Object ...
	TypeAmazonS3Object TypeBasicDataset = "AmazonS3Object"
	// TypeAvro ...
	TypeAvro TypeBasicDataset = "Avro"
	// TypeAzureBlob ...
	TypeAzureBlob TypeBasicDataset = "AzureBlob"
	// TypeAzureBlobFSFile ...
	TypeAzureBlobFSFile TypeBasicDataset = "AzureBlobFSFile"
	// TypeAzureDataExplorerTable ...
	TypeAzureDataExplorerTable TypeBasicDataset = "AzureDataExplorerTable"
	// TypeAzureDataLakeStoreFile ...
	TypeAzureDataLakeStoreFile TypeBasicDataset = "AzureDataLakeStoreFile"
	// TypeAzureMariaDBTable ...
	TypeAzureMariaDBTable TypeBasicDataset = "AzureMariaDBTable"
	// TypeAzureMySQLTable ...
	TypeAzureMySQLTable TypeBasicDataset = "AzureMySqlTable"
	// TypeAzurePostgreSQLTable ...
	TypeAzurePostgreSQLTable TypeBasicDataset = "AzurePostgreSqlTable"
	// TypeAzureSearchIndex ...
	TypeAzureSearchIndex TypeBasicDataset = "AzureSearchIndex"
	// TypeAzureSQLDWTable ...
	TypeAzureSQLDWTable TypeBasicDataset = "AzureSqlDWTable"
	// TypeAzureSQLMITable ...
	TypeAzureSQLMITable TypeBasicDataset = "AzureSqlMITable"
	// TypeAzureSQLTable ...
	TypeAzureSQLTable TypeBasicDataset = "AzureSqlTable"
	// TypeAzureTable ...
	TypeAzureTable TypeBasicDataset = "AzureTable"
	// TypeBinary ...
	TypeBinary TypeBasicDataset = "Binary"
	// TypeCassandraTable ...
	TypeCassandraTable TypeBasicDataset = "CassandraTable"
	// TypeCommonDataServiceForAppsEntity ...
	TypeCommonDataServiceForAppsEntity TypeBasicDataset = "CommonDataServiceForAppsEntity"
	// TypeConcurObject ...
	TypeConcurObject TypeBasicDataset = "ConcurObject"
	// TypeCosmosDbMongoDbAPICollection ...
	TypeCosmosDbMongoDbAPICollection TypeBasicDataset = "CosmosDbMongoDbApiCollection"
	// TypeCosmosDbSQLAPICollection ...
	TypeCosmosDbSQLAPICollection TypeBasicDataset = "CosmosDbSqlApiCollection"
	// TypeCouchbaseTable ...
	TypeCouchbaseTable TypeBasicDataset = "CouchbaseTable"
	// TypeCustomDataset ...
	TypeCustomDataset TypeBasicDataset = "CustomDataset"
	// TypeDataset ...
	TypeDataset TypeBasicDataset = "Dataset"
	// TypeDb2Table ...
	TypeDb2Table TypeBasicDataset = "Db2Table"
	// TypeDelimitedText ...
	TypeDelimitedText TypeBasicDataset = "DelimitedText"
	// TypeDocumentDbCollection ...
	TypeDocumentDbCollection TypeBasicDataset = "DocumentDbCollection"
	// TypeDrillTable ...
	TypeDrillTable TypeBasicDataset = "DrillTable"
	// TypeDynamicsAXResource ...
	TypeDynamicsAXResource TypeBasicDataset = "DynamicsAXResource"
	// TypeDynamicsCrmEntity ...
	TypeDynamicsCrmEntity TypeBasicDataset = "DynamicsCrmEntity"
	// TypeDynamicsEntity ...
	TypeDynamicsEntity TypeBasicDataset = "DynamicsEntity"
	// TypeEloquaObject ...
	TypeEloquaObject TypeBasicDataset = "EloquaObject"
	// TypeExcel ...
	TypeExcel TypeBasicDataset = "Excel"
	// TypeFileShare ...
	TypeFileShare TypeBasicDataset = "FileShare"
	// TypeGoogleAdWordsObject ...
	TypeGoogleAdWordsObject TypeBasicDataset = "GoogleAdWordsObject"
	// TypeGoogleBigQueryObject ...
	TypeGoogleBigQueryObject TypeBasicDataset = "GoogleBigQueryObject"
	// TypeGreenplumTable ...
	TypeGreenplumTable TypeBasicDataset = "GreenplumTable"
	// TypeHBaseObject ...
	TypeHBaseObject TypeBasicDataset = "HBaseObject"
	// TypeHiveObject ...
	TypeHiveObject TypeBasicDataset = "HiveObject"
	// TypeHTTPFile ...
	TypeHTTPFile TypeBasicDataset = "HttpFile"
	// TypeHubspotObject ...
	TypeHubspotObject TypeBasicDataset = "HubspotObject"
	// TypeImpalaObject ...
	TypeImpalaObject TypeBasicDataset = "ImpalaObject"
	// TypeInformixTable ...
	TypeInformixTable TypeBasicDataset = "InformixTable"
	// TypeJiraObject ...
	TypeJiraObject TypeBasicDataset = "JiraObject"
	// TypeJSON ...
	TypeJSON TypeBasicDataset = "Json"
	// TypeMagentoObject ...
	TypeMagentoObject TypeBasicDataset = "MagentoObject"
	// TypeMariaDBTable ...
	TypeMariaDBTable TypeBasicDataset = "MariaDBTable"
	// TypeMarketoObject ...
	TypeMarketoObject TypeBasicDataset = "MarketoObject"
	// TypeMicrosoftAccessTable ...
	TypeMicrosoftAccessTable TypeBasicDataset = "MicrosoftAccessTable"
	// TypeMongoDbCollection ...
	TypeMongoDbCollection TypeBasicDataset = "MongoDbCollection"
	// TypeMongoDbV2Collection ...
	TypeMongoDbV2Collection TypeBasicDataset = "MongoDbV2Collection"
	// TypeMySQLTable ...
	TypeMySQLTable TypeBasicDataset = "MySqlTable"
	// TypeNetezzaTable ...
	TypeNetezzaTable TypeBasicDataset = "NetezzaTable"
	// TypeODataResource ...
	TypeODataResource TypeBasicDataset = "ODataResource"
	// TypeOdbcTable ...
	TypeOdbcTable TypeBasicDataset = "OdbcTable"
	// TypeOffice365Table ...
	TypeOffice365Table TypeBasicDataset = "Office365Table"
	// TypeOracleServiceCloudObject ...
	TypeOracleServiceCloudObject TypeBasicDataset = "OracleServiceCloudObject"
	// TypeOracleTable ...
	TypeOracleTable TypeBasicDataset = "OracleTable"
	// TypeOrc ...
	TypeOrc TypeBasicDataset = "Orc"
	// TypeParquet ...
	TypeParquet TypeBasicDataset = "Parquet"
	// TypePaypalObject ...
	TypePaypalObject TypeBasicDataset = "PaypalObject"
	// TypePhoenixObject ...
	TypePhoenixObject TypeBasicDataset = "PhoenixObject"
	// TypePostgreSQLTable ...
	TypePostgreSQLTable TypeBasicDataset = "PostgreSqlTable"
	// TypePrestoObject ...
	TypePrestoObject TypeBasicDataset = "PrestoObject"
	// TypeQuickBooksObject ...
	TypeQuickBooksObject TypeBasicDataset = "QuickBooksObject"
	// TypeRelationalTable ...
	TypeRelationalTable TypeBasicDataset = "RelationalTable"
	// TypeResponsysObject ...
	TypeResponsysObject TypeBasicDataset = "ResponsysObject"
	// TypeRestResource ...
	TypeRestResource TypeBasicDataset = "RestResource"
	// TypeSalesforceMarketingCloudObject ...
	TypeSalesforceMarketingCloudObject TypeBasicDataset = "SalesforceMarketingCloudObject"
	// TypeSalesforceObject ...
	TypeSalesforceObject TypeBasicDataset = "SalesforceObject"
	// TypeSalesforceServiceCloudObject ...
	TypeSalesforceServiceCloudObject TypeBasicDataset = "SalesforceServiceCloudObject"
	// TypeSapBwCube ...
	TypeSapBwCube TypeBasicDataset = "SapBwCube"
	// TypeSapCloudForCustomerResource ...
	TypeSapCloudForCustomerResource TypeBasicDataset = "SapCloudForCustomerResource"
	// TypeSapEccResource ...
	TypeSapEccResource TypeBasicDataset = "SapEccResource"
	// TypeSapHanaTable ...
	TypeSapHanaTable TypeBasicDataset = "SapHanaTable"
	// TypeSapOpenHubTable ...
	TypeSapOpenHubTable TypeBasicDataset = "SapOpenHubTable"
	// TypeSapTableResource ...
	TypeSapTableResource TypeBasicDataset = "SapTableResource"
	// TypeServiceNowObject ...
	TypeServiceNowObject TypeBasicDataset = "ServiceNowObject"
	// TypeSharePointOnlineListResource ...
	TypeSharePointOnlineListResource TypeBasicDataset = "SharePointOnlineListResource"
	// TypeShopifyObject ...
	TypeShopifyObject TypeBasicDataset = "ShopifyObject"
	// TypeSnowflakeTable ...
	TypeSnowflakeTable TypeBasicDataset = "SnowflakeTable"
	// TypeSparkObject ...
	TypeSparkObject TypeBasicDataset = "SparkObject"
	// TypeSQLServerTable ...
	TypeSQLServerTable TypeBasicDataset = "SqlServerTable"
	// TypeSquareObject ...
	TypeSquareObject TypeBasicDataset = "SquareObject"
	// TypeSybaseTable ...
	TypeSybaseTable TypeBasicDataset = "SybaseTable"
	// TypeTeradataTable ...
	TypeTeradataTable TypeBasicDataset = "TeradataTable"
	// TypeVerticaTable ...
	TypeVerticaTable TypeBasicDataset = "VerticaTable"
	// TypeWebTable ...
	TypeWebTable TypeBasicDataset = "WebTable"
	// TypeXeroObject ...
	TypeXeroObject TypeBasicDataset = "XeroObject"
	// TypeXML ...
	TypeXML TypeBasicDataset = "Xml"
	// TypeZohoObject ...
	TypeZohoObject TypeBasicDataset = "ZohoObject"
)

// PossibleTypeBasicDatasetValues returns an array of possible values for the TypeBasicDataset const type.
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return []TypeBasicDataset{TypeAmazonMWSObject, TypeAmazonRedshiftTable, TypeAmazonS3Object, TypeAvro, TypeAzureBlob, TypeAzureBlobFSFile, TypeAzureDataExplorerTable, TypeAzureDataLakeStoreFile, TypeAzureMariaDBTable, TypeAzureMySQLTable, TypeAzurePostgreSQLTable, TypeAzureSearchIndex, TypeAzureSQLDWTable, TypeAzureSQLMITable, TypeAzureSQLTable, TypeAzureTable, TypeBinary, TypeCassandraTable, TypeCommonDataServiceForAppsEntity, TypeConcurObject, TypeCosmosDbMongoDbAPICollection, TypeCosmosDbSQLAPICollection, TypeCouchbaseTable, TypeCustomDataset, TypeDataset, TypeDb2Table, TypeDelimitedText, TypeDocumentDbCollection, TypeDrillTable, TypeDynamicsAXResource, TypeDynamicsCrmEntity, TypeDynamicsEntity, TypeEloquaObject, TypeExcel, TypeFileShare, TypeGoogleAdWordsObject, TypeGoogleBigQueryObject, TypeGreenplumTable, TypeHBaseObject, TypeHiveObject, TypeHTTPFile, TypeHubspotObject, TypeImpalaObject, TypeInformixTable, TypeJiraObject, TypeJSON, TypeMagentoObject, TypeMariaDBTable, TypeMarketoObject, TypeMicrosoftAccessTable, TypeMongoDbCollection, TypeMongoDbV2Collection, TypeMySQLTable, TypeNetezzaTable, TypeODataResource, TypeOdbcTable, TypeOffice365Table, TypeOracleServiceCloudObject, TypeOracleTable, TypeOrc, TypeParquet, TypePaypalObject, TypePhoenixObject, TypePostgreSQLTable, TypePrestoObject, TypeQuickBooksObject, TypeRelationalTable, TypeResponsysObject, TypeRestResource, TypeSalesforceMarketingCloudObject, TypeSalesforceObject, TypeSalesforceServiceCloudObject, TypeSapBwCube, TypeSapCloudForCustomerResource, TypeSapEccResource, TypeSapHanaTable, TypeSapOpenHubTable, TypeSapTableResource, TypeServiceNowObject, TypeSharePointOnlineListResource, TypeShopifyObject, TypeSnowflakeTable, TypeSparkObject, TypeSQLServerTable, TypeSquareObject, TypeSybaseTable, TypeTeradataTable, TypeVerticaTable, TypeWebTable, TypeXeroObject, TypeXML, TypeZohoObject}
}

// TypeBasicDatasetCompression enumerates the values for type basic dataset compression.
type TypeBasicDatasetCompression string

const (
	// TypeBZip2 ...
	TypeBZip2 TypeBasicDatasetCompression = "BZip2"
	// TypeDatasetCompression ...
	TypeDatasetCompression TypeBasicDatasetCompression = "DatasetCompression"
	// TypeDeflate ...
	TypeDeflate TypeBasicDatasetCompression = "Deflate"
	// TypeGZip ...
	TypeGZip TypeBasicDatasetCompression = "GZip"
	// TypeTar ...
	TypeTar TypeBasicDatasetCompression = "Tar"
	// TypeTarGZip ...
	TypeTarGZip TypeBasicDatasetCompression = "TarGZip"
	// TypeZipDeflate ...
	TypeZipDeflate TypeBasicDatasetCompression = "ZipDeflate"
)

// PossibleTypeBasicDatasetCompressionValues returns an array of possible values for the TypeBasicDatasetCompression const type.
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return []TypeBasicDatasetCompression{TypeBZip2, TypeDatasetCompression, TypeDeflate, TypeGZip, TypeTar, TypeTarGZip, TypeZipDeflate}
}

// TypeBasicDatasetLocation enumerates the values for type basic dataset location.
type TypeBasicDatasetLocation string

const (
	// TypeAmazonS3Location ...
	TypeAmazonS3Location TypeBasicDatasetLocation = "AmazonS3Location"
	// TypeAzureBlobFSLocation ...
	TypeAzureBlobFSLocation TypeBasicDatasetLocation = "AzureBlobFSLocation"
	// TypeAzureBlobStorageLocation ...
	TypeAzureBlobStorageLocation TypeBasicDatasetLocation = "AzureBlobStorageLocation"
	// TypeAzureDataLakeStoreLocation ...
	TypeAzureDataLakeStoreLocation TypeBasicDatasetLocation = "AzureDataLakeStoreLocation"
	// TypeAzureFileStorageLocation ...
	TypeAzureFileStorageLocation TypeBasicDatasetLocation = "AzureFileStorageLocation"
	// TypeDatasetLocation ...
	TypeDatasetLocation TypeBasicDatasetLocation = "DatasetLocation"
	// TypeFileServerLocation ...
	TypeFileServerLocation TypeBasicDatasetLocation = "FileServerLocation"
	// TypeFtpServerLocation ...
	TypeFtpServerLocation TypeBasicDatasetLocation = "FtpServerLocation"
	// TypeGoogleCloudStorageLocation ...
	TypeGoogleCloudStorageLocation TypeBasicDatasetLocation = "GoogleCloudStorageLocation"
	// TypeHdfsLocation ...
	TypeHdfsLocation TypeBasicDatasetLocation = "HdfsLocation"
	// TypeHTTPServerLocation ...
	TypeHTTPServerLocation TypeBasicDatasetLocation = "HttpServerLocation"
	// TypeSftpLocation ...
	TypeSftpLocation TypeBasicDatasetLocation = "SftpLocation"
)

// PossibleTypeBasicDatasetLocationValues returns an array of possible values for the TypeBasicDatasetLocation const type.
func PossibleTypeBasicDatasetLocationValues() []TypeBasicDatasetLocation {
	return []TypeBasicDatasetLocation{TypeAmazonS3Location, TypeAzureBlobFSLocation, TypeAzureBlobStorageLocation, TypeAzureDataLakeStoreLocation, TypeAzureFileStorageLocation, TypeDatasetLocation, TypeFileServerLocation, TypeFtpServerLocation, TypeGoogleCloudStorageLocation, TypeHdfsLocation, TypeHTTPServerLocation, TypeSftpLocation}
}

// TypeBasicDatasetStorageFormat enumerates the values for type basic dataset storage format.
type TypeBasicDatasetStorageFormat string

const (
	// TypeAvroFormat ...
	TypeAvroFormat TypeBasicDatasetStorageFormat = "AvroFormat"
	// TypeDatasetStorageFormat ...
	TypeDatasetStorageFormat TypeBasicDatasetStorageFormat = "DatasetStorageFormat"
	// TypeJSONFormat ...
	TypeJSONFormat TypeBasicDatasetStorageFormat = "JsonFormat"
	// TypeOrcFormat ...
	TypeOrcFormat TypeBasicDatasetStorageFormat = "OrcFormat"
	// TypeParquetFormat ...
	TypeParquetFormat TypeBasicDatasetStorageFormat = "ParquetFormat"
	// TypeTextFormat ...
	TypeTextFormat TypeBasicDatasetStorageFormat = "TextFormat"
)

// PossibleTypeBasicDatasetStorageFormatValues returns an array of possible values for the TypeBasicDatasetStorageFormat const type.
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return []TypeBasicDatasetStorageFormat{TypeAvroFormat, TypeDatasetStorageFormat, TypeJSONFormat, TypeOrcFormat, TypeParquetFormat, TypeTextFormat}
}

// TypeBasicDependencyReference enumerates the values for type basic dependency reference.
type TypeBasicDependencyReference string

const (
	// TypeDependencyReference ...
	TypeDependencyReference TypeBasicDependencyReference = "DependencyReference"
	// TypeSelfDependencyTumblingWindowTriggerReference ...
	TypeSelfDependencyTumblingWindowTriggerReference TypeBasicDependencyReference = "SelfDependencyTumblingWindowTriggerReference"
	// TypeTriggerDependencyReference ...
	TypeTriggerDependencyReference TypeBasicDependencyReference = "TriggerDependencyReference"
	// TypeTumblingWindowTriggerDependencyReference ...
	TypeTumblingWindowTriggerDependencyReference TypeBasicDependencyReference = "TumblingWindowTriggerDependencyReference"
)

// PossibleTypeBasicDependencyReferenceValues returns an array of possible values for the TypeBasicDependencyReference const type.
func PossibleTypeBasicDependencyReferenceValues() []TypeBasicDependencyReference {
	return []TypeBasicDependencyReference{TypeDependencyReference, TypeSelfDependencyTumblingWindowTriggerReference, TypeTriggerDependencyReference, TypeTumblingWindowTriggerDependencyReference}
}

// TypeBasicExportSettings enumerates the values for type basic export settings.
type TypeBasicExportSettings string

const (
	// TypeExportSettings ...
	TypeExportSettings TypeBasicExportSettings = "ExportSettings"
	// TypeSnowflakeExportCopyCommand ...
	TypeSnowflakeExportCopyCommand TypeBasicExportSettings = "SnowflakeExportCopyCommand"
)

// PossibleTypeBasicExportSettingsValues returns an array of possible values for the TypeBasicExportSettings const type.
func PossibleTypeBasicExportSettingsValues() []TypeBasicExportSettings {
	return []TypeBasicExportSettings{TypeExportSettings, TypeSnowflakeExportCopyCommand}
}

// TypeBasicFactoryRepoConfiguration enumerates the values for type basic factory repo configuration.
type TypeBasicFactoryRepoConfiguration string

const (
	// TypeFactoryGitHubConfiguration ...
	TypeFactoryGitHubConfiguration TypeBasicFactoryRepoConfiguration = "FactoryGitHubConfiguration"
	// TypeFactoryRepoConfiguration ...
	TypeFactoryRepoConfiguration TypeBasicFactoryRepoConfiguration = "FactoryRepoConfiguration"
	// TypeFactoryVSTSConfiguration ...
	TypeFactoryVSTSConfiguration TypeBasicFactoryRepoConfiguration = "FactoryVSTSConfiguration"
)

// PossibleTypeBasicFactoryRepoConfigurationValues returns an array of possible values for the TypeBasicFactoryRepoConfiguration const type.
func PossibleTypeBasicFactoryRepoConfigurationValues() []TypeBasicFactoryRepoConfiguration {
	return []TypeBasicFactoryRepoConfiguration{TypeFactoryGitHubConfiguration, TypeFactoryRepoConfiguration, TypeFactoryVSTSConfiguration}
}

// TypeBasicFormatReadSettings enumerates the values for type basic format read settings.
type TypeBasicFormatReadSettings string

const (
	// TypeBinaryReadSettings ...
	TypeBinaryReadSettings TypeBasicFormatReadSettings = "BinaryReadSettings"
	// TypeDelimitedTextReadSettings ...
	TypeDelimitedTextReadSettings TypeBasicFormatReadSettings = "DelimitedTextReadSettings"
	// TypeFormatReadSettings ...
	TypeFormatReadSettings TypeBasicFormatReadSettings = "FormatReadSettings"
	// TypeJSONReadSettings ...
	TypeJSONReadSettings TypeBasicFormatReadSettings = "JsonReadSettings"
	// TypeXMLReadSettings ...
	TypeXMLReadSettings TypeBasicFormatReadSettings = "XmlReadSettings"
)

// PossibleTypeBasicFormatReadSettingsValues returns an array of possible values for the TypeBasicFormatReadSettings const type.
func PossibleTypeBasicFormatReadSettingsValues() []TypeBasicFormatReadSettings {
	return []TypeBasicFormatReadSettings{TypeBinaryReadSettings, TypeDelimitedTextReadSettings, TypeFormatReadSettings, TypeJSONReadSettings, TypeXMLReadSettings}
}

// TypeBasicFormatWriteSettings enumerates the values for type basic format write settings.
type TypeBasicFormatWriteSettings string

const (
	// TypeAvroWriteSettings ...
	TypeAvroWriteSettings TypeBasicFormatWriteSettings = "AvroWriteSettings"
	// TypeDelimitedTextWriteSettings ...
	TypeDelimitedTextWriteSettings TypeBasicFormatWriteSettings = "DelimitedTextWriteSettings"
	// TypeFormatWriteSettings ...
	TypeFormatWriteSettings TypeBasicFormatWriteSettings = "FormatWriteSettings"
	// TypeJSONWriteSettings ...
	TypeJSONWriteSettings TypeBasicFormatWriteSettings = "JsonWriteSettings"
)

// PossibleTypeBasicFormatWriteSettingsValues returns an array of possible values for the TypeBasicFormatWriteSettings const type.
func PossibleTypeBasicFormatWriteSettingsValues() []TypeBasicFormatWriteSettings {
	return []TypeBasicFormatWriteSettings{TypeAvroWriteSettings, TypeDelimitedTextWriteSettings, TypeFormatWriteSettings, TypeJSONWriteSettings}
}

// TypeBasicImportSettings enumerates the values for type basic import settings.
type TypeBasicImportSettings string

const (
	// TypeImportSettings ...
	TypeImportSettings TypeBasicImportSettings = "ImportSettings"
	// TypeSnowflakeImportCopyCommand ...
	TypeSnowflakeImportCopyCommand TypeBasicImportSettings = "SnowflakeImportCopyCommand"
)

// PossibleTypeBasicImportSettingsValues returns an array of possible values for the TypeBasicImportSettings const type.
func PossibleTypeBasicImportSettingsValues() []TypeBasicImportSettings {
	return []TypeBasicImportSettings{TypeImportSettings, TypeSnowflakeImportCopyCommand}
}

// TypeBasicIntegrationRuntime enumerates the values for type basic integration runtime.
type TypeBasicIntegrationRuntime string

const (
	// TypeIntegrationRuntime ...
	TypeIntegrationRuntime TypeBasicIntegrationRuntime = "IntegrationRuntime"
	// TypeManaged ...
	TypeManaged TypeBasicIntegrationRuntime = "Managed"
	// TypeSelfHosted ...
	TypeSelfHosted TypeBasicIntegrationRuntime = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeValues returns an array of possible values for the TypeBasicIntegrationRuntime const type.
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return []TypeBasicIntegrationRuntime{TypeIntegrationRuntime, TypeManaged, TypeSelfHosted}
}

// TypeBasicIntegrationRuntimeStatus enumerates the values for type basic integration runtime status.
type TypeBasicIntegrationRuntimeStatus string

const (
	// TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus ...
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = "IntegrationRuntimeStatus"
	// TypeBasicIntegrationRuntimeStatusTypeManaged ...
	TypeBasicIntegrationRuntimeStatusTypeManaged TypeBasicIntegrationRuntimeStatus = "Managed"
	// TypeBasicIntegrationRuntimeStatusTypeSelfHosted ...
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted TypeBasicIntegrationRuntimeStatus = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeStatusValues returns an array of possible values for the TypeBasicIntegrationRuntimeStatus const type.
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return []TypeBasicIntegrationRuntimeStatus{TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus, TypeBasicIntegrationRuntimeStatusTypeManaged, TypeBasicIntegrationRuntimeStatusTypeSelfHosted}
}

// TypeBasicLinkedService enumerates the values for type basic linked service.
type TypeBasicLinkedService string

const (
	// TypeAmazonMWS ...
	TypeAmazonMWS TypeBasicLinkedService = "AmazonMWS"
	// TypeAmazonRedshift ...
	TypeAmazonRedshift TypeBasicLinkedService = "AmazonRedshift"
	// TypeAmazonS3 ...
	TypeAmazonS3 TypeBasicLinkedService = "AmazonS3"
	// TypeAzureBatch ...
	TypeAzureBatch TypeBasicLinkedService = "AzureBatch"
	// TypeAzureBlobFS ...
	TypeAzureBlobFS TypeBasicLinkedService = "AzureBlobFS"
	// TypeAzureBlobStorage ...
	TypeAzureBlobStorage TypeBasicLinkedService = "AzureBlobStorage"
	// TypeAzureDatabricks ...
	TypeAzureDatabricks TypeBasicLinkedService = "AzureDatabricks"
	// TypeAzureDataExplorer ...
	TypeAzureDataExplorer TypeBasicLinkedService = "AzureDataExplorer"
	// TypeAzureDataLakeAnalytics ...
	TypeAzureDataLakeAnalytics TypeBasicLinkedService = "AzureDataLakeAnalytics"
	// TypeAzureDataLakeStore ...
	TypeAzureDataLakeStore TypeBasicLinkedService = "AzureDataLakeStore"
	// TypeAzureFileStorage ...
	TypeAzureFileStorage TypeBasicLinkedService = "AzureFileStorage"
	// TypeAzureFunction ...
	TypeAzureFunction TypeBasicLinkedService = "AzureFunction"
	// TypeAzureKeyVault ...
	TypeAzureKeyVault TypeBasicLinkedService = "AzureKeyVault"
	// TypeAzureMariaDB ...
	TypeAzureMariaDB TypeBasicLinkedService = "AzureMariaDB"
	// TypeAzureML ...
	TypeAzureML TypeBasicLinkedService = "AzureML"
	// TypeAzureMLService ...
	TypeAzureMLService TypeBasicLinkedService = "AzureMLService"
	// TypeAzureMySQL ...
	TypeAzureMySQL TypeBasicLinkedService = "AzureMySql"
	// TypeAzurePostgreSQL ...
	TypeAzurePostgreSQL TypeBasicLinkedService = "AzurePostgreSql"
	// TypeAzureSearch ...
	TypeAzureSearch TypeBasicLinkedService = "AzureSearch"
	// TypeAzureSQLDatabase ...
	TypeAzureSQLDatabase TypeBasicLinkedService = "AzureSqlDatabase"
	// TypeAzureSQLDW ...
	TypeAzureSQLDW TypeBasicLinkedService = "AzureSqlDW"
	// TypeAzureSQLMI ...
	TypeAzureSQLMI TypeBasicLinkedService = "AzureSqlMI"
	// TypeAzureStorage ...
	TypeAzureStorage TypeBasicLinkedService = "AzureStorage"
	// TypeAzureTableStorage ...
	TypeAzureTableStorage TypeBasicLinkedService = "AzureTableStorage"
	// TypeCassandra ...
	TypeCassandra TypeBasicLinkedService = "Cassandra"
	// TypeCommonDataServiceForApps ...
	TypeCommonDataServiceForApps TypeBasicLinkedService = "CommonDataServiceForApps"
	// TypeConcur ...
	TypeConcur TypeBasicLinkedService = "Concur"
	// TypeCosmosDb ...
	TypeCosmosDb TypeBasicLinkedService = "CosmosDb"
	// TypeCosmosDbMongoDbAPI ...
	TypeCosmosDbMongoDbAPI TypeBasicLinkedService = "CosmosDbMongoDbApi"
	// TypeCouchbase ...
	TypeCouchbase TypeBasicLinkedService = "Couchbase"
	// TypeCustomDataSource ...
	TypeCustomDataSource TypeBasicLinkedService = "CustomDataSource"
	// TypeDb2 ...
	TypeDb2 TypeBasicLinkedService = "Db2"
	// TypeDrill ...
	TypeDrill TypeBasicLinkedService = "Drill"
	// TypeDynamics ...
	TypeDynamics TypeBasicLinkedService = "Dynamics"
	// TypeDynamicsAX ...
	TypeDynamicsAX TypeBasicLinkedService = "DynamicsAX"
	// TypeDynamicsCrm ...
	TypeDynamicsCrm TypeBasicLinkedService = "DynamicsCrm"
	// TypeEloqua ...
	TypeEloqua TypeBasicLinkedService = "Eloqua"
	// TypeFileServer ...
	TypeFileServer TypeBasicLinkedService = "FileServer"
	// TypeFtpServer ...
	TypeFtpServer TypeBasicLinkedService = "FtpServer"
	// TypeGoogleAdWords ...
	TypeGoogleAdWords TypeBasicLinkedService = "GoogleAdWords"
	// TypeGoogleBigQuery ...
	TypeGoogleBigQuery TypeBasicLinkedService = "GoogleBigQuery"
	// TypeGoogleCloudStorage ...
	TypeGoogleCloudStorage TypeBasicLinkedService = "GoogleCloudStorage"
	// TypeGreenplum ...
	TypeGreenplum TypeBasicLinkedService = "Greenplum"
	// TypeHBase ...
	TypeHBase TypeBasicLinkedService = "HBase"
	// TypeHdfs ...
	TypeHdfs TypeBasicLinkedService = "Hdfs"
	// TypeHDInsight ...
	TypeHDInsight TypeBasicLinkedService = "HDInsight"
	// TypeHDInsightOnDemand ...
	TypeHDInsightOnDemand TypeBasicLinkedService = "HDInsightOnDemand"
	// TypeHive ...
	TypeHive TypeBasicLinkedService = "Hive"
	// TypeHTTPServer ...
	TypeHTTPServer TypeBasicLinkedService = "HttpServer"
	// TypeHubspot ...
	TypeHubspot TypeBasicLinkedService = "Hubspot"
	// TypeImpala ...
	TypeImpala TypeBasicLinkedService = "Impala"
	// TypeInformix ...
	TypeInformix TypeBasicLinkedService = "Informix"
	// TypeJira ...
	TypeJira TypeBasicLinkedService = "Jira"
	// TypeLinkedService ...
	TypeLinkedService TypeBasicLinkedService = "LinkedService"
	// TypeMagento ...
	TypeMagento TypeBasicLinkedService = "Magento"
	// TypeMariaDB ...
	TypeMariaDB TypeBasicLinkedService = "MariaDB"
	// TypeMarketo ...
	TypeMarketo TypeBasicLinkedService = "Marketo"
	// TypeMicrosoftAccess ...
	TypeMicrosoftAccess TypeBasicLinkedService = "MicrosoftAccess"
	// TypeMongoDb ...
	TypeMongoDb TypeBasicLinkedService = "MongoDb"
	// TypeMongoDbV2 ...
	TypeMongoDbV2 TypeBasicLinkedService = "MongoDbV2"
	// TypeMySQL ...
	TypeMySQL TypeBasicLinkedService = "MySql"
	// TypeNetezza ...
	TypeNetezza TypeBasicLinkedService = "Netezza"
	// TypeOData ...
	TypeOData TypeBasicLinkedService = "OData"
	// TypeOdbc ...
	TypeOdbc TypeBasicLinkedService = "Odbc"
	// TypeOffice365 ...
	TypeOffice365 TypeBasicLinkedService = "Office365"
	// TypeOracle ...
	TypeOracle TypeBasicLinkedService = "Oracle"
	// TypeOracleServiceCloud ...
	TypeOracleServiceCloud TypeBasicLinkedService = "OracleServiceCloud"
	// TypePaypal ...
	TypePaypal TypeBasicLinkedService = "Paypal"
	// TypePhoenix ...
	TypePhoenix TypeBasicLinkedService = "Phoenix"
	// TypePostgreSQL ...
	TypePostgreSQL TypeBasicLinkedService = "PostgreSql"
	// TypePresto ...
	TypePresto TypeBasicLinkedService = "Presto"
	// TypeQuickBooks ...
	TypeQuickBooks TypeBasicLinkedService = "QuickBooks"
	// TypeResponsys ...
	TypeResponsys TypeBasicLinkedService = "Responsys"
	// TypeRestService ...
	TypeRestService TypeBasicLinkedService = "RestService"
	// TypeSalesforce ...
	TypeSalesforce TypeBasicLinkedService = "Salesforce"
	// TypeSalesforceMarketingCloud ...
	TypeSalesforceMarketingCloud TypeBasicLinkedService = "SalesforceMarketingCloud"
	// TypeSalesforceServiceCloud ...
	TypeSalesforceServiceCloud TypeBasicLinkedService = "SalesforceServiceCloud"
	// TypeSapBW ...
	TypeSapBW TypeBasicLinkedService = "SapBW"
	// TypeSapCloudForCustomer ...
	TypeSapCloudForCustomer TypeBasicLinkedService = "SapCloudForCustomer"
	// TypeSapEcc ...
	TypeSapEcc TypeBasicLinkedService = "SapEcc"
	// TypeSapHana ...
	TypeSapHana TypeBasicLinkedService = "SapHana"
	// TypeSapOpenHub ...
	TypeSapOpenHub TypeBasicLinkedService = "SapOpenHub"
	// TypeSapTable ...
	TypeSapTable TypeBasicLinkedService = "SapTable"
	// TypeServiceNow ...
	TypeServiceNow TypeBasicLinkedService = "ServiceNow"
	// TypeSftp ...
	TypeSftp TypeBasicLinkedService = "Sftp"
	// TypeSharePointOnlineList ...
	TypeSharePointOnlineList TypeBasicLinkedService = "SharePointOnlineList"
	// TypeShopify ...
	TypeShopify TypeBasicLinkedService = "Shopify"
	// TypeSnowflake ...
	TypeSnowflake TypeBasicLinkedService = "Snowflake"
	// TypeSpark ...
	TypeSpark TypeBasicLinkedService = "Spark"
	// TypeSQLServer ...
	TypeSQLServer TypeBasicLinkedService = "SqlServer"
	// TypeSquare ...
	TypeSquare TypeBasicLinkedService = "Square"
	// TypeSybase ...
	TypeSybase TypeBasicLinkedService = "Sybase"
	// TypeTeradata ...
	TypeTeradata TypeBasicLinkedService = "Teradata"
	// TypeVertica ...
	TypeVertica TypeBasicLinkedService = "Vertica"
	// TypeWeb ...
	TypeWeb TypeBasicLinkedService = "Web"
	// TypeXero ...
	TypeXero TypeBasicLinkedService = "Xero"
	// TypeZoho ...
	TypeZoho TypeBasicLinkedService = "Zoho"
)

// PossibleTypeBasicLinkedServiceValues returns an array of possible values for the TypeBasicLinkedService const type.
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return []TypeBasicLinkedService{TypeAmazonMWS, TypeAmazonRedshift, TypeAmazonS3, TypeAzureBatch, TypeAzureBlobFS, TypeAzureBlobStorage, TypeAzureDatabricks, TypeAzureDataExplorer, TypeAzureDataLakeAnalytics, TypeAzureDataLakeStore, TypeAzureFileStorage, TypeAzureFunction, TypeAzureKeyVault, TypeAzureMariaDB, TypeAzureML, TypeAzureMLService, TypeAzureMySQL, TypeAzurePostgreSQL, TypeAzureSearch, TypeAzureSQLDatabase, TypeAzureSQLDW, TypeAzureSQLMI, TypeAzureStorage, TypeAzureTableStorage, TypeCassandra, TypeCommonDataServiceForApps, TypeConcur, TypeCosmosDb, TypeCosmosDbMongoDbAPI, TypeCouchbase, TypeCustomDataSource, TypeDb2, TypeDrill, TypeDynamics, TypeDynamicsAX, TypeDynamicsCrm, TypeEloqua, TypeFileServer, TypeFtpServer, TypeGoogleAdWords, TypeGoogleBigQuery, TypeGoogleCloudStorage, TypeGreenplum, TypeHBase, TypeHdfs, TypeHDInsight, TypeHDInsightOnDemand, TypeHive, TypeHTTPServer, TypeHubspot, TypeImpala, TypeInformix, TypeJira, TypeLinkedService, TypeMagento, TypeMariaDB, TypeMarketo, TypeMicrosoftAccess, TypeMongoDb, TypeMongoDbV2, TypeMySQL, TypeNetezza, TypeOData, TypeOdbc, TypeOffice365, TypeOracle, TypeOracleServiceCloud, TypePaypal, TypePhoenix, TypePostgreSQL, TypePresto, TypeQuickBooks, TypeResponsys, TypeRestService, TypeSalesforce, TypeSalesforceMarketingCloud, TypeSalesforceServiceCloud, TypeSapBW, TypeSapCloudForCustomer, TypeSapEcc, TypeSapHana, TypeSapOpenHub, TypeSapTable, TypeServiceNow, TypeSftp, TypeSharePointOnlineList, TypeShopify, TypeSnowflake, TypeSpark, TypeSQLServer, TypeSquare, TypeSybase, TypeTeradata, TypeVertica, TypeWeb, TypeXero, TypeZoho}
}

// TypeBasicSsisObjectMetadata enumerates the values for type basic ssis object metadata.
type TypeBasicSsisObjectMetadata string

const (
	// TypeEnvironment ...
	TypeEnvironment TypeBasicSsisObjectMetadata = "Environment"
	// TypeFolder ...
	TypeFolder TypeBasicSsisObjectMetadata = "Folder"
	// TypePackage ...
	TypePackage TypeBasicSsisObjectMetadata = "Package"
	// TypeProject ...
	TypeProject TypeBasicSsisObjectMetadata = "Project"
	// TypeSsisObjectMetadata ...
	TypeSsisObjectMetadata TypeBasicSsisObjectMetadata = "SsisObjectMetadata"
)

// PossibleTypeBasicSsisObjectMetadataValues returns an array of possible values for the TypeBasicSsisObjectMetadata const type.
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return []TypeBasicSsisObjectMetadata{TypeEnvironment, TypeFolder, TypePackage, TypeProject, TypeSsisObjectMetadata}
}

// TypeBasicStoreReadSettings enumerates the values for type basic store read settings.
type TypeBasicStoreReadSettings string

const (
	// TypeAmazonS3ReadSettings ...
	TypeAmazonS3ReadSettings TypeBasicStoreReadSettings = "AmazonS3ReadSettings"
	// TypeAzureBlobFSReadSettings ...
	TypeAzureBlobFSReadSettings TypeBasicStoreReadSettings = "AzureBlobFSReadSettings"
	// TypeAzureBlobStorageReadSettings ...
	TypeAzureBlobStorageReadSettings TypeBasicStoreReadSettings = "AzureBlobStorageReadSettings"
	// TypeAzureDataLakeStoreReadSettings ...
	TypeAzureDataLakeStoreReadSettings TypeBasicStoreReadSettings = "AzureDataLakeStoreReadSettings"
	// TypeAzureFileStorageReadSettings ...
	TypeAzureFileStorageReadSettings TypeBasicStoreReadSettings = "AzureFileStorageReadSettings"
	// TypeFileServerReadSettings ...
	TypeFileServerReadSettings TypeBasicStoreReadSettings = "FileServerReadSettings"
	// TypeFtpReadSettings ...
	TypeFtpReadSettings TypeBasicStoreReadSettings = "FtpReadSettings"
	// TypeGoogleCloudStorageReadSettings ...
	TypeGoogleCloudStorageReadSettings TypeBasicStoreReadSettings = "GoogleCloudStorageReadSettings"
	// TypeHdfsReadSettings ...
	TypeHdfsReadSettings TypeBasicStoreReadSettings = "HdfsReadSettings"
	// TypeHTTPReadSettings ...
	TypeHTTPReadSettings TypeBasicStoreReadSettings = "HttpReadSettings"
	// TypeSftpReadSettings ...
	TypeSftpReadSettings TypeBasicStoreReadSettings = "SftpReadSettings"
	// TypeStoreReadSettings ...
	TypeStoreReadSettings TypeBasicStoreReadSettings = "StoreReadSettings"
)

// PossibleTypeBasicStoreReadSettingsValues returns an array of possible values for the TypeBasicStoreReadSettings const type.
func PossibleTypeBasicStoreReadSettingsValues() []TypeBasicStoreReadSettings {
	return []TypeBasicStoreReadSettings{TypeAmazonS3ReadSettings, TypeAzureBlobFSReadSettings, TypeAzureBlobStorageReadSettings, TypeAzureDataLakeStoreReadSettings, TypeAzureFileStorageReadSettings, TypeFileServerReadSettings, TypeFtpReadSettings, TypeGoogleCloudStorageReadSettings, TypeHdfsReadSettings, TypeHTTPReadSettings, TypeSftpReadSettings, TypeStoreReadSettings}
}

// TypeBasicStoreWriteSettings enumerates the values for type basic store write settings.
type TypeBasicStoreWriteSettings string

const (
	// TypeAzureBlobFSWriteSettings ...
	TypeAzureBlobFSWriteSettings TypeBasicStoreWriteSettings = "AzureBlobFSWriteSettings"
	// TypeAzureBlobStorageWriteSettings ...
	TypeAzureBlobStorageWriteSettings TypeBasicStoreWriteSettings = "AzureBlobStorageWriteSettings"
	// TypeAzureDataLakeStoreWriteSettings ...
	TypeAzureDataLakeStoreWriteSettings TypeBasicStoreWriteSettings = "AzureDataLakeStoreWriteSettings"
	// TypeAzureFileStorageWriteSettings ...
	TypeAzureFileStorageWriteSettings TypeBasicStoreWriteSettings = "AzureFileStorageWriteSettings"
	// TypeFileServerWriteSettings ...
	TypeFileServerWriteSettings TypeBasicStoreWriteSettings = "FileServerWriteSettings"
	// TypeSftpWriteSettings ...
	TypeSftpWriteSettings TypeBasicStoreWriteSettings = "SftpWriteSettings"
	// TypeStoreWriteSettings ...
	TypeStoreWriteSettings TypeBasicStoreWriteSettings = "StoreWriteSettings"
)

// PossibleTypeBasicStoreWriteSettingsValues returns an array of possible values for the TypeBasicStoreWriteSettings const type.
func PossibleTypeBasicStoreWriteSettingsValues() []TypeBasicStoreWriteSettings {
	return []TypeBasicStoreWriteSettings{TypeAzureBlobFSWriteSettings, TypeAzureBlobStorageWriteSettings, TypeAzureDataLakeStoreWriteSettings, TypeAzureFileStorageWriteSettings, TypeFileServerWriteSettings, TypeSftpWriteSettings, TypeStoreWriteSettings}
}

// TypeBasicTrigger enumerates the values for type basic trigger.
type TypeBasicTrigger string

const (
	// TypeBlobEventsTrigger ...
	TypeBlobEventsTrigger TypeBasicTrigger = "BlobEventsTrigger"
	// TypeBlobTrigger ...
	TypeBlobTrigger TypeBasicTrigger = "BlobTrigger"
	// TypeChainingTrigger ...
	TypeChainingTrigger TypeBasicTrigger = "ChainingTrigger"
	// TypeMultiplePipelineTrigger ...
	TypeMultiplePipelineTrigger TypeBasicTrigger = "MultiplePipelineTrigger"
	// TypeRerunTumblingWindowTrigger ...
	TypeRerunTumblingWindowTrigger TypeBasicTrigger = "RerunTumblingWindowTrigger"
	// TypeScheduleTrigger ...
	TypeScheduleTrigger TypeBasicTrigger = "ScheduleTrigger"
	// TypeTrigger ...
	TypeTrigger TypeBasicTrigger = "Trigger"
	// TypeTumblingWindowTrigger ...
	TypeTumblingWindowTrigger TypeBasicTrigger = "TumblingWindowTrigger"
)

// PossibleTypeBasicTriggerValues returns an array of possible values for the TypeBasicTrigger const type.
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return []TypeBasicTrigger{TypeBlobEventsTrigger, TypeBlobTrigger, TypeChainingTrigger, TypeMultiplePipelineTrigger, TypeRerunTumblingWindowTrigger, TypeScheduleTrigger, TypeTrigger, TypeTumblingWindowTrigger}
}

// VariableType enumerates the values for variable type.
type VariableType string

const (
	// VariableTypeArray ...
	VariableTypeArray VariableType = "Array"
	// VariableTypeBool ...
	VariableTypeBool VariableType = "Bool"
	// VariableTypeString ...
	VariableTypeString VariableType = "String"
)

// PossibleVariableTypeValues returns an array of possible values for the VariableType const type.
func PossibleVariableTypeValues() []VariableType {
	return []VariableType{VariableTypeArray, VariableTypeBool, VariableTypeString}
}

// WebActivityMethod enumerates the values for web activity method.
type WebActivityMethod string

const (
	// WebActivityMethodDELETE ...
	WebActivityMethodDELETE WebActivityMethod = "DELETE"
	// WebActivityMethodGET ...
	WebActivityMethodGET WebActivityMethod = "GET"
	// WebActivityMethodPOST ...
	WebActivityMethodPOST WebActivityMethod = "POST"
	// WebActivityMethodPUT ...
	WebActivityMethodPUT WebActivityMethod = "PUT"
)

// PossibleWebActivityMethodValues returns an array of possible values for the WebActivityMethod const type.
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return []WebActivityMethod{WebActivityMethodDELETE, WebActivityMethodGET, WebActivityMethodPOST, WebActivityMethodPUT}
}

// WebHookActivityMethod enumerates the values for web hook activity method.
type WebHookActivityMethod string

const (
	// WebHookActivityMethodPOST ...
	WebHookActivityMethodPOST WebHookActivityMethod = "POST"
)

// PossibleWebHookActivityMethodValues returns an array of possible values for the WebHookActivityMethod const type.
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return []WebHookActivityMethod{WebHookActivityMethodPOST}
}
