/*
 * Decompiled with CFR 0.152.
 */
package com.stampysoft.ant.j2me;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UpdateJARSizeTask
extends Task {
    private static final String MIDLET_JAR_SIZE = "MIDlet-Jar-Size";
    private File m_jad;
    private boolean m_relativePath = false;

    public void setJad(File jad) {
        this.m_jad = jad;
    }

    public void setRelativePath(boolean relativePath) {
        this.m_relativePath = relativePath;
    }

    public void execute() throws BuildException {
        if (this.m_jad == null) {
            throw new BuildException("You must specify a JAD file with the \"jad\" attribute", this.location);
        }
        if (!this.m_jad.isFile()) {
            throw new BuildException("The specified JAD file, " + this.m_jad + " either does not exist or is not a file", this.location);
        }
        try {
            Properties props = new Properties();
            FileInputStream fIn = new FileInputStream(this.m_jad);
            props.load(fIn);
            fIn.close();
            String jarName = props.getProperty("MIDlet-Jar-URL");
            if (jarName == null) {
                throw new BuildException("No JAR file specified in the JAD with the \"MIDlet-Jar-URL\" property", this.location);
            }
            File jarFile = null;
            if (jarName.startsWith("file://")) {
                jarName = jarName.substring("file://".length());
                jarFile = this.m_relativePath ? new File(this.m_jad.getParent(), jarName) : new File(jarName);
            } else {
                jarFile = new File(this.m_jad.getParent(), jarName);
            }
            if (!jarFile.isFile()) {
                throw new BuildException("The JAR file specified in the JAD, " + jarFile + ", either does not exist or is not a file", this.location);
            }
            String newSize = Long.toString(jarFile.length());
            if (!newSize.equals(props.getProperty(MIDLET_JAR_SIZE))) {
                this.log("Updating " + this.m_jad + " with new JAR size of " + newSize);
                props.setProperty(MIDLET_JAR_SIZE, newSize);
                FileOutputStream fOut = new FileOutputStream(this.m_jad);
                PrintWriter writer = new PrintWriter(fOut);
                Iterator keys = ((Hashtable)props).keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    writer.print(key);
                    writer.print(": ");
                    writer.println(props.getProperty(key));
                }
                writer.close();
                fOut.close();
            }
        }
        catch (IOException e) {
            throw new BuildException("Problem processing the JAD file: " + e.getMessage(), this.location);
        }
    }
}

