/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringLayout;

public class Gauge
extends Item {
    private int value;
    private int maxValue;
    private boolean interactive;
    private int blockCount;
    private static final int BLOCK_SPACE = 8;
    private static final int GAUGE_HEIGHT = 25;
    private int valueOfEachBlock;
    private int height;

    public Gauge(String label, boolean interactive, int maxValue, int initialValue) {
        super(label, 1);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.interactive = interactive;
            this.value = initialValue;
            this.setMaxValueImpl(maxValue);
        }
    }

    public void setValue(int value) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.value = value;
            this.checkValue();
            this.contentChanged(0, this.height - 30, 0);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setMaxValue(int maxValue) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setMaxValueImpl(maxValue);
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setLabel(String label) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.setLabel(label);
            int deltaHeight = ((StringLayout)this.layouts[0]).setString(label);
            this.height += deltaHeight;
            this.contentChanged(0, 0, deltaHeight);
        }
    }

    void paint(Graphics g) {
        g.setColor(Display.ERASE_COLOR);
        g.fillRect(g.getClipX(), 0, g.getClipWidth(), this.height);
        int layoutHeight = this.layouts[0].getHeight();
        if (g.getClipY() < layoutHeight) {
            this.layouts[0].paint(g, false, false);
        }
        g.translate(0, layoutHeight);
        int startBlock = 0;
        int stopBlock = this.blockCount;
        if (g.getClipX() > 0) {
            startBlock = (g.getClipX() - 6) / 8;
        }
        if (g.getClipWidth() == 5) {
            stopBlock = startBlock + 1;
        }
        if (this.hasFocus()) {
            g.setColor(0);
        } else {
            g.setColor(0x606060);
        }
        int bc = this.blockCount - 1;
        int bc2 = bc * bc;
        int i = startBlock;
        while (i < stopBlock) {
            int blockHeight = this.interactive && this.blockCount > 1 ? 5 + (i * (bc - i) << 1) / bc2 + 20 * (i * i) / bc2 : 25;
            if (this.valueOfEachBlock * (i + 1) > this.value && this.value != this.maxValue) {
                if (this.hasFocus()) {
                    g.drawRect(i * 8 + 6, 25 - blockHeight, 5, blockHeight);
                } else {
                    g.setStrokeStyle(1);
                    g.drawRect(i * 8 + 6, 25 - blockHeight, 5, blockHeight);
                    g.setStrokeStyle(0);
                }
            } else {
                g.fillRect(i * 8 + 6, 25 - blockHeight, 5, blockHeight);
            }
            ++i;
        }
        g.translate(0, -layoutHeight);
        this.setHorizontalScroll();
    }

    void focusChanged() {
        if (!this.hasFocus()) {
            this.getOwner().setHorizontalScroll(0, 100);
        }
        super.focusChanged();
    }

    int setWidth(int width) {
        this.height = 30;
        this.height += this.layouts[0].setWidth(width);
        return this.height;
    }

    int getHeight() {
        return this.height;
    }

    boolean keyPressed(int keyCode) {
        if (!this.interactive) {
            return false;
        }
        if (Display.getGameAction(keyCode) == 2 || Display.getGameAction(keyCode) == 5) {
            int blockToRepaint = -1;
            int oldValue = this.value++;
            if (Display.getGameAction(keyCode) == 2) {
                if (this.value % this.valueOfEachBlock == 0) {
                    blockToRepaint = this.value / this.valueOfEachBlock - 1;
                } else if (this.value == this.maxValue) {
                    blockToRepaint = this.blockCount - 1;
                }
                --this.value;
            } else if (this.value % this.valueOfEachBlock == 0) {
                blockToRepaint = this.value / this.valueOfEachBlock - 1;
            } else if (this.value == this.maxValue) {
                blockToRepaint = this.blockCount - 1;
            }
            this.checkValue();
            if (blockToRepaint < 0 || blockToRepaint >= this.blockCount) {
                this.setHorizontalScroll();
                return this.value != oldValue;
            }
            int blockY = 0;
            blockY = this.layouts[0].getHeight();
            this.repaint(blockToRepaint * 8 + 6, blockY, 6, 27);
            return this.value != oldValue;
        }
        return false;
    }

    private void setBlockCount() {
        this.blockCount = (Display.WIDTH - 8) / 8;
        if (this.blockCount > this.maxValue) {
            this.blockCount = this.maxValue;
        }
    }

    private void setBlockValue() {
        this.valueOfEachBlock = 1;
        if (this.maxValue <= this.blockCount) {
            return;
        }
        this.valueOfEachBlock = this.maxValue / this.blockCount;
        if (this.maxValue % this.blockCount != 0) {
            ++this.valueOfEachBlock;
        }
        this.blockCount = this.maxValue / this.valueOfEachBlock;
        if (this.maxValue % this.valueOfEachBlock != 0) {
            ++this.blockCount;
        }
    }

    private void setHorizontalScroll() {
        if (this.hasFocus() && this.interactive) {
            int scrollPosition = this.value * 100 / this.maxValue;
            if (this.value > 0 && scrollPosition == 0) {
                scrollPosition = 1;
            }
            this.getOwner().setHorizontalScroll(scrollPosition, 50);
        }
    }

    private int checkValue() {
        if (this.value < 0) {
            this.value = 0;
        } else if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
        return this.value;
    }

    private void setMaxValueImpl(int maxValue) {
        if (maxValue <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxValue = maxValue;
        this.checkValue();
        this.setBlockCount();
        this.setBlockValue();
        this.contentChanged(0, this.height - 30, 0);
    }
}

