# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AnalysisInput(msrest.serialization.Model):
    """AnalysisInput.

    All required parameters must be populated in order to send to Azure.

    :param analysis_input: Required. Contains a set of input documents to be analyzed by the
     service.
    :type analysis_input: ~azure.ai.textanalytics.v3_1.models.MultiLanguageBatchInput
    """

    _validation = {
        'analysis_input': {'required': True},
    }

    _attribute_map = {
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageBatchInput'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalysisInput, self).__init__(**kwargs)
        self.analysis_input = kwargs['analysis_input']


class JobManifest(msrest.serialization.Model):
    """JobManifest.

    All required parameters must be populated in order to send to Azure.

    :param tasks: Required. The set of tasks to execute on the input documents. Cannot specify the
     same task more than once.
    :type tasks: ~azure.ai.textanalytics.v3_1.models.JobManifestTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'JobManifestTasks'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobManifest, self).__init__(**kwargs)
        self.tasks = kwargs['tasks']


class JobDescriptor(msrest.serialization.Model):
    """JobDescriptor.

    :param display_name: Optional display name for the analysis job.
    :type display_name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobDescriptor, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class AnalyzeBatchInput(JobDescriptor, AnalysisInput, JobManifest):
    """AnalyzeBatchInput.

    All required parameters must be populated in order to send to Azure.

    :param tasks: Required. The set of tasks to execute on the input documents. Cannot specify the
     same task more than once.
    :type tasks: ~azure.ai.textanalytics.v3_1.models.JobManifestTasks
    :param analysis_input: Required. Contains a set of input documents to be analyzed by the
     service.
    :type analysis_input: ~azure.ai.textanalytics.v3_1.models.MultiLanguageBatchInput
    :param display_name: Optional display name for the analysis job.
    :type display_name: str
    """

    _validation = {
        'tasks': {'required': True},
        'analysis_input': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'JobManifestTasks'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageBatchInput'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyzeBatchInput, self).__init__(**kwargs)
        self.tasks = kwargs['tasks']
        self.analysis_input = kwargs['analysis_input']
        self.tasks = kwargs['tasks']
        self.display_name = kwargs.get('display_name', None)
        self.analysis_input = kwargs['analysis_input']
        self.display_name = kwargs.get('display_name', None)


class AnalyzeJobDisplayName(msrest.serialization.Model):
    """AnalyzeJobDisplayName.

    :param display_name:
    :type display_name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyzeJobDisplayName, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class AnalyzeJobErrorsAndStatistics(msrest.serialization.Model):
    """AnalyzeJobErrorsAndStatistics.

    :param errors:
    :type errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    """

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyzeJobErrorsAndStatistics, self).__init__(**kwargs)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)


class JobMetadata(msrest.serialization.Model):
    """JobMetadata.

    All required parameters must be populated in order to send to Azure.

    :param created_date_time: Required.
    :type created_date_time: ~datetime.datetime
    :param expiration_date_time:
    :type expiration_date_time: ~datetime.datetime
    :param job_id: Required.
    :type job_id: str
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobMetadata, self).__init__(**kwargs)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class AnalyzeJobMetadata(JobMetadata, AnalyzeJobDisplayName):
    """AnalyzeJobMetadata.

    All required parameters must be populated in order to send to Azure.

    :param display_name:
    :type display_name: str
    :param created_date_time: Required.
    :type created_date_time: ~datetime.datetime
    :param expiration_date_time:
    :type expiration_date_time: ~datetime.datetime
    :param job_id: Required.
    :type job_id: str
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyzeJobMetadata, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class Pagination(msrest.serialization.Model):
    """Pagination.

    :param next_link:
    :type next_link: str
    """

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Pagination, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)


class TasksState(msrest.serialization.Model):
    """TasksState.

    All required parameters must be populated in order to send to Azure.

    :param tasks: Required.
    :type tasks: ~azure.ai.textanalytics.v3_1.models.TasksStateTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TasksState, self).__init__(**kwargs)
        self.tasks = kwargs['tasks']


class AnalyzeJobState(AnalyzeJobMetadata, TasksState, AnalyzeJobErrorsAndStatistics, Pagination):
    """AnalyzeJobState.

    All required parameters must be populated in order to send to Azure.

    :param next_link:
    :type next_link: str
    :param errors:
    :type errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param tasks: Required.
    :type tasks: ~azure.ai.textanalytics.v3_1.models.TasksStateTasks
    :param display_name:
    :type display_name: str
    :param created_date_time: Required.
    :type created_date_time: ~datetime.datetime
    :param expiration_date_time:
    :type expiration_date_time: ~datetime.datetime
    :param job_id: Required.
    :type job_id: str
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'tasks': {'required': True},
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyzeJobState, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.tasks = kwargs['tasks']
        self.next_link = kwargs.get('next_link', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']
        self.next_link = kwargs.get('next_link', None)
        self.tasks = kwargs['tasks']
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.tasks = kwargs['tasks']
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class DetectedLanguage(msrest.serialization.Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Long name of a detected language (e.g. English, French).
    :type name: str
    :param iso6391_name: Required. A two letter representation of the detected language according
     to the ISO 639-1 standard (e.g. en, fr).
    :type iso6391_name: str
    :param confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
     indicate 100% certainty that the identified language is true.
    :type confidence_score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'iso6391_name': {'key': 'iso6391Name', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectedLanguage, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.iso6391_name = kwargs['iso6391_name']
        self.confidence_score = kwargs['confidence_score']


class DocumentEntities(msrest.serialization.Model):
    """DocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Recognized entities in the document.
    :type entities: list[~azure.ai.textanalytics.v3_1.models.Entity]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.entities = kwargs['entities']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentError(msrest.serialization.Model):
    """DocumentError.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Document Id.
    :type id: str
    :param error: Required. Document Error.
    :type error: ~azure.ai.textanalytics.v3_1.models.TextAnalyticsError
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentError, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.error = kwargs['error']


class DocumentHealthcareEntities(msrest.serialization.Model):
    """DocumentHealthcareEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Healthcare entities.
    :type entities: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntity]
    :param relations: Required. Healthcare entity relations.
    :type relations: list[~azure.ai.textanalytics.v3_1.models.HealthcareRelation]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[HealthcareEntity]'},
        'relations': {'key': 'relations', 'type': '[HealthcareRelation]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentHealthcareEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.entities = kwargs['entities']
        self.relations = kwargs['relations']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentKeyPhrases(msrest.serialization.Model):
    """DocumentKeyPhrases.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param key_phrases: Required. A list of representative words or phrases. The number of key
     phrases returned is proportional to the number of words in the input document.
    :type key_phrases: list[str]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'key_phrases': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key_phrases': {'key': 'keyPhrases', 'type': '[str]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentKeyPhrases, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.key_phrases = kwargs['key_phrases']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentLanguage(msrest.serialization.Model):
    """DocumentLanguage.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param detected_language: Required. Detected Language.
    :type detected_language: ~azure.ai.textanalytics.v3_1.models.DetectedLanguage
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'detected_language': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'detected_language': {'key': 'detectedLanguage', 'type': 'DetectedLanguage'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentLanguage, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.detected_language = kwargs['detected_language']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentLinkedEntities(msrest.serialization.Model):
    """DocumentLinkedEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Recognized well known entities in the document.
    :type entities: list[~azure.ai.textanalytics.v3_1.models.LinkedEntity]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[LinkedEntity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentLinkedEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.entities = kwargs['entities']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentSentiment(msrest.serialization.Model):
    """DocumentSentiment.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
     Mixed). Possible values include: "positive", "neutral", "negative", "mixed".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1.models.DocumentSentimentValue
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    :param confidence_scores: Required. Document level sentiment confidence scores between 0 and 1
     for each sentiment class.
    :type confidence_scores: ~azure.ai.textanalytics.v3_1.models.SentimentConfidenceScorePerLabel
    :param sentences: Required. Sentence level sentiment analysis.
    :type sentences: list[~azure.ai.textanalytics.v3_1.models.SentenceSentiment]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    """

    _validation = {
        'id': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'sentences': {'key': 'sentences', 'type': '[SentenceSentiment]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentSentiment, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.sentiment = kwargs['sentiment']
        self.statistics = kwargs.get('statistics', None)
        self.confidence_scores = kwargs['confidence_scores']
        self.sentences = kwargs['sentences']
        self.warnings = kwargs['warnings']


class DocumentStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :param characters_count: Required. Number of text elements recognized in the document.
    :type characters_count: int
    :param transactions_count: Required. Number of transactions for the document.
    :type transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'characters_count': {'key': 'charactersCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentStatistics, self).__init__(**kwargs)
        self.characters_count = kwargs['characters_count']
        self.transactions_count = kwargs['transactions_count']


class EntitiesResult(msrest.serialization.Model):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.DocumentEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntitiesResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class EntitiesTask(msrest.serialization.Model):
    """EntitiesTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1.models.EntitiesTaskParameters
    :param task_name:
    :type task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'EntitiesTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntitiesTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class EntitiesTaskParameters(msrest.serialization.Model):
    """EntitiesTaskParameters.

    :param model_version:
    :type model_version: str
    :param logging_opt_out:
    :type logging_opt_out: bool
    :param string_index_type:  Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntitiesTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.string_index_type = kwargs.get('string_index_type', None)


class EntitiesTaskResult(msrest.serialization.Model):
    """EntitiesTaskResult.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.EntitiesResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntitiesResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntitiesTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class Entity(msrest.serialization.Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param category: Required. Entity type.
    :type category: str
    :param subcategory: (Optional) Entity sub type.
    :type subcategory: str
    :param offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :type offset: int
    :param length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :type length: int
    :param confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :type confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Entity, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.category = kwargs['category']
        self.subcategory = kwargs.get('subcategory', None)
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.confidence_score = kwargs['confidence_score']


class EntityLinkingResult(msrest.serialization.Model):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.DocumentLinkedEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLinkedEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityLinkingResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class EntityLinkingTask(msrest.serialization.Model):
    """EntityLinkingTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1.models.EntityLinkingTaskParameters
    :param task_name:
    :type task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'EntityLinkingTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityLinkingTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class EntityLinkingTaskParameters(msrest.serialization.Model):
    """EntityLinkingTaskParameters.

    :param model_version:
    :type model_version: str
    :param logging_opt_out:
    :type logging_opt_out: bool
    :param string_index_type:  Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityLinkingTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.string_index_type = kwargs.get('string_index_type', None)


class EntityLinkingTaskResult(msrest.serialization.Model):
    """EntityLinkingTaskResult.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.EntityLinkingResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntityLinkingResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityLinkingTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. Document Error.
    :type error: ~azure.ai.textanalytics.v3_1.models.TextAnalyticsError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs['error']


class HealthcareAssertion(msrest.serialization.Model):
    """HealthcareAssertion.

    :param conditionality: Describes any conditionality on the entity. Possible values include:
     "hypothetical", "conditional".
    :type conditionality: str or ~azure.ai.textanalytics.v3_1.models.Conditionality
    :param certainty: Describes the entities certainty and polarity. Possible values include:
     "positive", "positivePossible", "neutralPossible", "negativePossible", "negative".
    :type certainty: str or ~azure.ai.textanalytics.v3_1.models.Certainty
    :param association: Describes if the entity is the subject of the text or if it describes
     someone else. Possible values include: "subject", "other".
    :type association: str or ~azure.ai.textanalytics.v3_1.models.Association
    """

    _attribute_map = {
        'conditionality': {'key': 'conditionality', 'type': 'str'},
        'certainty': {'key': 'certainty', 'type': 'str'},
        'association': {'key': 'association', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareAssertion, self).__init__(**kwargs)
        self.conditionality = kwargs.get('conditionality', None)
        self.certainty = kwargs.get('certainty', None)
        self.association = kwargs.get('association', None)


class HealthcareLinkingProperties(msrest.serialization.Model):
    """HealthcareLinkingProperties.

    :param assertion:
    :type assertion: ~azure.ai.textanalytics.v3_1.models.HealthcareAssertion
    :param name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :type name: str
    :param links: Entity references in known data sources.
    :type links: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntityLink]
    """

    _attribute_map = {
        'assertion': {'key': 'assertion', 'type': 'HealthcareAssertion'},
        'name': {'key': 'name', 'type': 'str'},
        'links': {'key': 'links', 'type': '[HealthcareEntityLink]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareLinkingProperties, self).__init__(**kwargs)
        self.assertion = kwargs.get('assertion', None)
        self.name = kwargs.get('name', None)
        self.links = kwargs.get('links', None)


class HealthcareEntityProperties(msrest.serialization.Model):
    """HealthcareEntityProperties.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param category: Required. Healthcare Entity Category. Possible values include:
     "BODY_STRUCTURE", "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY",
     "MEASUREMENT_VALUE", "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN",
     "VARIANT", "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
     "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
     "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
    :type category: str or ~azure.ai.textanalytics.v3_1.models.HealthcareEntityCategory
    :param subcategory: (Optional) Entity sub type.
    :type subcategory: str
    :param offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :type offset: int
    :param length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :type length: int
    :param confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :type confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareEntityProperties, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.category = kwargs['category']
        self.subcategory = kwargs.get('subcategory', None)
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.confidence_score = kwargs['confidence_score']


class HealthcareEntity(HealthcareEntityProperties, HealthcareLinkingProperties):
    """HealthcareEntity.

    All required parameters must be populated in order to send to Azure.

    :param assertion:
    :type assertion: ~azure.ai.textanalytics.v3_1.models.HealthcareAssertion
    :param name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :type name: str
    :param links: Entity references in known data sources.
    :type links: list[~azure.ai.textanalytics.v3_1.models.HealthcareEntityLink]
    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param category: Required. Healthcare Entity Category. Possible values include:
     "BODY_STRUCTURE", "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY",
     "MEASUREMENT_VALUE", "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN",
     "VARIANT", "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
     "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
     "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
    :type category: str or ~azure.ai.textanalytics.v3_1.models.HealthcareEntityCategory
    :param subcategory: (Optional) Entity sub type.
    :type subcategory: str
    :param offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :type offset: int
    :param length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :type length: int
    :param confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :type confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'assertion': {'key': 'assertion', 'type': 'HealthcareAssertion'},
        'name': {'key': 'name', 'type': 'str'},
        'links': {'key': 'links', 'type': '[HealthcareEntityLink]'},
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareEntity, self).__init__(**kwargs)
        self.assertion = kwargs.get('assertion', None)
        self.name = kwargs.get('name', None)
        self.links = kwargs.get('links', None)
        self.text = kwargs['text']
        self.category = kwargs['category']
        self.subcategory = kwargs.get('subcategory', None)
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.confidence_score = kwargs['confidence_score']


class HealthcareEntityLink(msrest.serialization.Model):
    """HealthcareEntityLink.

    All required parameters must be populated in order to send to Azure.

    :param data_source: Required. Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
    :type data_source: str
    :param id: Required. Entity id in the given source catalog.
    :type id: str
    """

    _validation = {
        'data_source': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareEntityLink, self).__init__(**kwargs)
        self.data_source = kwargs['data_source']
        self.id = kwargs['id']


class HealthcareTaskResult(msrest.serialization.Model):
    """HealthcareTaskResult.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.HealthcareResult
    :param errors:
    :type errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'HealthcareResult'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.errors = kwargs.get('errors', None)


class HealthcareJobState(JobMetadata, Pagination, HealthcareTaskResult):
    """HealthcareJobState.

    All required parameters must be populated in order to send to Azure.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.HealthcareResult
    :param errors:
    :type errors: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    :param next_link:
    :type next_link: str
    :param created_date_time: Required.
    :type created_date_time: ~datetime.datetime
    :param expiration_date_time:
    :type expiration_date_time: ~datetime.datetime
    :param job_id: Required.
    :type job_id: str
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'HealthcareResult'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareJobState, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.errors = kwargs.get('errors', None)
        self.next_link = kwargs.get('next_link', None)
        self.results = kwargs.get('results', None)
        self.errors = kwargs.get('errors', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']
        self.next_link = kwargs.get('next_link', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class HealthcareRelation(msrest.serialization.Model):
    """Every relation is an entity graph of a certain relationType, where all entities are connected and have specific roles within the relation context.

    All required parameters must be populated in order to send to Azure.

    :param relation_type: Required. Type of relation. Examples include: ``DosageOfMedication`` or
     'FrequencyOfMedication', etc. Possible values include: "Abbreviation",
     "DirectionOfBodyStructure", "DirectionOfCondition", "DirectionOfExamination",
     "DirectionOfTreatment", "DosageOfMedication", "FormOfMedication", "FrequencyOfMedication",
     "FrequencyOfTreatment", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
     "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment",
     "UnitOfCondition", "UnitOfExamination", "ValueOfCondition", "ValueOfExamination".
    :type relation_type: str or ~azure.ai.textanalytics.v3_1.models.RelationType
    :param entities: Required. The entities in the relation.
    :type entities: list[~azure.ai.textanalytics.v3_1.models.HealthcareRelationEntity]
    """

    _validation = {
        'relation_type': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[HealthcareRelationEntity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareRelation, self).__init__(**kwargs)
        self.relation_type = kwargs['relation_type']
        self.entities = kwargs['entities']


class HealthcareRelationEntity(msrest.serialization.Model):
    """HealthcareRelationEntity.

    All required parameters must be populated in order to send to Azure.

    :param ref: Required. Reference link object, using a JSON pointer RFC 6901 (URI Fragment
     Identifier Representation), pointing to the entity .
    :type ref: str
    :param role: Required. Role of entity in the relationship. For example: 'CD20-positive diffuse
     large B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
     (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis).
    :type role: str
    """

    _validation = {
        'ref': {'required': True},
        'role': {'required': True},
    }

    _attribute_map = {
        'ref': {'key': 'ref', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareRelationEntity, self).__init__(**kwargs)
        self.ref = kwargs['ref']
        self.role = kwargs['role']


class HealthcareResult(msrest.serialization.Model):
    """HealthcareResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.DocumentHealthcareEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentHealthcareEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthcareResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class InnerError(msrest.serialization.Model):
    """InnerError.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include: "InvalidParameterValue",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputRecords", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode",
     "InvalidCountryHint".
    :type code: str or ~azure.ai.textanalytics.v3_1.models.InnerErrorCodeValue
    :param message: Required. Error message.
    :type message: str
    :param details: Error details.
    :type details: dict[str, str]
    :param target: Error target.
    :type target: str
    :param innererror: Inner error contains more specific information.
    :type innererror: ~azure.ai.textanalytics.v3_1.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.details = kwargs.get('details', None)
        self.target = kwargs.get('target', None)
        self.innererror = kwargs.get('innererror', None)


class JobManifestTasks(msrest.serialization.Model):
    """The set of tasks to execute on the input documents. Cannot specify the same task more than once.

    :param entity_recognition_tasks:
    :type entity_recognition_tasks: list[~azure.ai.textanalytics.v3_1.models.EntitiesTask]
    :param entity_recognition_pii_tasks:
    :type entity_recognition_pii_tasks: list[~azure.ai.textanalytics.v3_1.models.PiiTask]
    :param key_phrase_extraction_tasks:
    :type key_phrase_extraction_tasks: list[~azure.ai.textanalytics.v3_1.models.KeyPhrasesTask]
    :param entity_linking_tasks:
    :type entity_linking_tasks: list[~azure.ai.textanalytics.v3_1.models.EntityLinkingTask]
    :param sentiment_analysis_tasks:
    :type sentiment_analysis_tasks: list[~azure.ai.textanalytics.v3_1.models.SentimentAnalysisTask]
    """

    _attribute_map = {
        'entity_recognition_tasks': {'key': 'entityRecognitionTasks', 'type': '[EntitiesTask]'},
        'entity_recognition_pii_tasks': {'key': 'entityRecognitionPiiTasks', 'type': '[PiiTask]'},
        'key_phrase_extraction_tasks': {'key': 'keyPhraseExtractionTasks', 'type': '[KeyPhrasesTask]'},
        'entity_linking_tasks': {'key': 'entityLinkingTasks', 'type': '[EntityLinkingTask]'},
        'sentiment_analysis_tasks': {'key': 'sentimentAnalysisTasks', 'type': '[SentimentAnalysisTask]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobManifestTasks, self).__init__(**kwargs)
        self.entity_recognition_tasks = kwargs.get('entity_recognition_tasks', None)
        self.entity_recognition_pii_tasks = kwargs.get('entity_recognition_pii_tasks', None)
        self.key_phrase_extraction_tasks = kwargs.get('key_phrase_extraction_tasks', None)
        self.entity_linking_tasks = kwargs.get('entity_linking_tasks', None)
        self.sentiment_analysis_tasks = kwargs.get('sentiment_analysis_tasks', None)


class KeyPhraseResult(msrest.serialization.Model):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.DocumentKeyPhrases]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentKeyPhrases]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyPhraseResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class KeyPhrasesTask(msrest.serialization.Model):
    """KeyPhrasesTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1.models.KeyPhrasesTaskParameters
    :param task_name:
    :type task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'KeyPhrasesTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyPhrasesTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class KeyPhrasesTaskParameters(msrest.serialization.Model):
    """KeyPhrasesTaskParameters.

    :param model_version:
    :type model_version: str
    :param logging_opt_out:
    :type logging_opt_out: bool
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyPhrasesTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)


class KeyPhraseTaskResult(msrest.serialization.Model):
    """KeyPhraseTaskResult.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.KeyPhraseResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyPhraseTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class LanguageBatchInput(msrest.serialization.Model):
    """LanguageBatchInput.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.LanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[LanguageInput]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LanguageBatchInput, self).__init__(**kwargs)
        self.documents = kwargs['documents']


class LanguageInput(msrest.serialization.Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param text: Required.
    :type text: str
    :param country_hint:
    :type country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'country_hint': {'key': 'countryHint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LanguageInput, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.text = kwargs['text']
        self.country_hint = kwargs.get('country_hint', None)


class LanguageResult(msrest.serialization.Model):
    """LanguageResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.DocumentLanguage]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLanguage]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LanguageResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class LinkedEntity(msrest.serialization.Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Entity Linking formal name.
    :type name: str
    :param matches: Required. List of instances this entity appears in the text.
    :type matches: list[~azure.ai.textanalytics.v3_1.models.Match]
    :param language: Required. Language used in the data source.
    :type language: str
    :param id: Unique identifier of the recognized entity from the data source.
    :type id: str
    :param url: Required. URL for the entity's page from the data source.
    :type url: str
    :param data_source: Required. Data source used to extract entity linking, such as Wiki/Bing
     etc.
    :type data_source: str
    :param bing_id: Bing Entity Search API unique identifier of the recognized entity.
    :type bing_id: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'matches': {'key': 'matches', 'type': '[Match]'},
        'language': {'key': 'language', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedEntity, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.matches = kwargs['matches']
        self.language = kwargs['language']
        self.id = kwargs.get('id', None)
        self.url = kwargs['url']
        self.data_source = kwargs['data_source']
        self.bing_id = kwargs.get('bing_id', None)


class Match(msrest.serialization.Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :param confidence_score: Required. If a well known item is recognized, a decimal number
     denoting the confidence level between 0 and 1 will be returned.
    :type confidence_score: float
    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param offset: Required. Start position for the entity match text.
    :type offset: int
    :param length: Required. Length for the entity match text.
    :type length: int
    """

    _validation = {
        'confidence_score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Match, self).__init__(**kwargs)
        self.confidence_score = kwargs['confidence_score']
        self.text = kwargs['text']
        self.offset = kwargs['offset']
        self.length = kwargs['length']


class MultiLanguageBatchInput(msrest.serialization.Model):
    """Contains a set of input documents to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. The set of documents to process as part of this batch.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[MultiLanguageInput]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MultiLanguageBatchInput, self).__init__(**kwargs)
        self.documents = kwargs['documents']


class MultiLanguageInput(msrest.serialization.Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A unique, non-empty document identifier.
    :type id: str
    :param text: Required. The input text to process.
    :type text: str
    :param language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :type language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MultiLanguageInput, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.text = kwargs['text']
        self.language = kwargs.get('language', None)


class PiiDocumentEntities(msrest.serialization.Model):
    """PiiDocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param redacted_text: Required. Returns redacted text.
    :type redacted_text: str
    :param entities: Required. Recognized entities in the document.
    :type entities: list[~azure.ai.textanalytics.v3_1.models.Entity]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'redacted_text': {'key': 'redactedText', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PiiDocumentEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.redacted_text = kwargs['redacted_text']
        self.entities = kwargs['entities']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class PiiResult(msrest.serialization.Model):
    """PiiResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.PiiDocumentEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[PiiDocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PiiResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class PiiTask(msrest.serialization.Model):
    """PiiTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1.models.PiiTaskParameters
    :param task_name:
    :type task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'PiiTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PiiTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class PiiTaskParameters(msrest.serialization.Model):
    """PiiTaskParameters.

    :param domain:  Possible values include: "phi", "none". Default value: "none".
    :type domain: str or ~azure.ai.textanalytics.v3_1.models.PiiTaskParametersDomain
    :param model_version:
    :type model_version: str
    :param logging_opt_out:
    :type logging_opt_out: bool
    :param pii_categories: (Optional) describes the PII categories to return.
    :type pii_categories: list[str or ~azure.ai.textanalytics.v3_1.models.PiiCategory]
    :param string_index_type:  Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _validation = {
        'pii_categories': {'unique': True},
    }

    _attribute_map = {
        'domain': {'key': 'domain', 'type': 'str'},
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'pii_categories': {'key': 'piiCategories', 'type': '[str]'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PiiTaskParameters, self).__init__(**kwargs)
        self.domain = kwargs.get('domain', "none")
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', True)
        self.pii_categories = kwargs.get('pii_categories', None)
        self.string_index_type = kwargs.get('string_index_type', None)


class PiiTaskResult(msrest.serialization.Model):
    """PiiTaskResult.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.PiiResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'PiiResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PiiTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class RequestStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :param documents_count: Required. Number of documents submitted in the request.
    :type documents_count: int
    :param valid_documents_count: Required. Number of valid documents. This excludes empty,
     over-size limit or non-supported languages documents.
    :type valid_documents_count: int
    :param erroneous_documents_count: Required. Number of invalid documents. This includes empty,
     over-size limit or non-supported languages documents.
    :type erroneous_documents_count: int
    :param transactions_count: Required. Number of transactions for the request.
    :type transactions_count: long
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'documents_count': {'key': 'documentsCount', 'type': 'int'},
        'valid_documents_count': {'key': 'validDocumentsCount', 'type': 'int'},
        'erroneous_documents_count': {'key': 'erroneousDocumentsCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestStatistics, self).__init__(**kwargs)
        self.documents_count = kwargs['documents_count']
        self.valid_documents_count = kwargs['valid_documents_count']
        self.erroneous_documents_count = kwargs['erroneous_documents_count']
        self.transactions_count = kwargs['transactions_count']


class SentenceAssessment(msrest.serialization.Model):
    """SentenceAssessment.

    All required parameters must be populated in order to send to Azure.

    :param sentiment: Required. Assessment sentiment in the sentence. Possible values include:
     "positive", "mixed", "negative".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1.models.TokenSentimentValue
    :param confidence_scores: Required. Assessment sentiment confidence scores in the sentence.
    :type confidence_scores: ~azure.ai.textanalytics.v3_1.models.TargetConfidenceScoreLabel
    :param offset: Required. The assessment offset from the start of the sentence.
    :type offset: int
    :param length: Required. The length of the assessment.
    :type length: int
    :param text: Required. The assessment text detected.
    :type text: str
    :param is_negated: Required. The indicator representing if the assessment is negated.
    :type is_negated: bool
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'is_negated': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'TargetConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'is_negated': {'key': 'isNegated', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentenceAssessment, self).__init__(**kwargs)
        self.sentiment = kwargs['sentiment']
        self.confidence_scores = kwargs['confidence_scores']
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.text = kwargs['text']
        self.is_negated = kwargs['is_negated']


class SentenceSentiment(msrest.serialization.Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. The sentence text.
    :type text: str
    :param sentiment: Required. The predicted Sentiment for the sentence. Possible values include:
     "positive", "neutral", "negative".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1.models.SentenceSentimentValue
    :param confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
     sentence for all classes.
    :type confidence_scores: ~azure.ai.textanalytics.v3_1.models.SentimentConfidenceScorePerLabel
    :param offset: Required. The sentence offset from the start of the document.
    :type offset: int
    :param length: Required. The length of the sentence.
    :type length: int
    :param targets: The array of sentence targets for the sentence.
    :type targets: list[~azure.ai.textanalytics.v3_1.models.SentenceTarget]
    :param assessments: The array of assessments for the sentence.
    :type assessments: list[~azure.ai.textanalytics.v3_1.models.SentenceAssessment]
    """

    _validation = {
        'text': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'targets': {'key': 'targets', 'type': '[SentenceTarget]'},
        'assessments': {'key': 'assessments', 'type': '[SentenceAssessment]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentenceSentiment, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.sentiment = kwargs['sentiment']
        self.confidence_scores = kwargs['confidence_scores']
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.targets = kwargs.get('targets', None)
        self.assessments = kwargs.get('assessments', None)


class SentenceTarget(msrest.serialization.Model):
    """SentenceTarget.

    All required parameters must be populated in order to send to Azure.

    :param sentiment: Required. Targeted sentiment in the sentence. Possible values include:
     "positive", "mixed", "negative".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1.models.TokenSentimentValue
    :param confidence_scores: Required. Target sentiment confidence scores for the target in the
     sentence.
    :type confidence_scores: ~azure.ai.textanalytics.v3_1.models.TargetConfidenceScoreLabel
    :param offset: Required. The target offset from the start of the sentence.
    :type offset: int
    :param length: Required. The length of the target.
    :type length: int
    :param text: Required. The target text detected.
    :type text: str
    :param relations: Required. The array of either assessment or target objects which is related
     to the target.
    :type relations: list[~azure.ai.textanalytics.v3_1.models.TargetRelation]
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'TargetConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'relations': {'key': 'relations', 'type': '[TargetRelation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentenceTarget, self).__init__(**kwargs)
        self.sentiment = kwargs['sentiment']
        self.confidence_scores = kwargs['confidence_scores']
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.text = kwargs['text']
        self.relations = kwargs['relations']


class SentimentAnalysisTask(msrest.serialization.Model):
    """SentimentAnalysisTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1.models.SentimentAnalysisTaskParameters
    :param task_name:
    :type task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'SentimentAnalysisTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentimentAnalysisTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class SentimentAnalysisTaskParameters(msrest.serialization.Model):
    """SentimentAnalysisTaskParameters.

    :param model_version:
    :type model_version: str
    :param logging_opt_out:
    :type logging_opt_out: bool
    :param opinion_mining:
    :type opinion_mining: bool
    :param string_index_type:  Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'opinion_mining': {'key': 'opinionMining', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentimentAnalysisTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.opinion_mining = kwargs.get('opinion_mining', False)
        self.string_index_type = kwargs.get('string_index_type', None)


class SentimentConfidenceScorePerLabel(msrest.serialization.Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :param positive: Required.
    :type positive: float
    :param neutral: Required.
    :type neutral: float
    :param negative: Required.
    :type negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'neutral': {'key': 'neutral', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentimentConfidenceScorePerLabel, self).__init__(**kwargs)
        self.positive = kwargs['positive']
        self.neutral = kwargs['neutral']
        self.negative = kwargs['negative']


class SentimentResponse(msrest.serialization.Model):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Sentiment analysis per document.
    :type documents: list[~azure.ai.textanalytics.v3_1.models.DocumentSentiment]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentSentiment]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentimentResponse, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class SentimentTaskResult(msrest.serialization.Model):
    """SentimentTaskResult.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.SentimentResponse
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'SentimentResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SentimentTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class TargetConfidenceScoreLabel(msrest.serialization.Model):
    """Represents the confidence scores across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :param positive: Required.
    :type positive: float
    :param negative: Required.
    :type negative: float
    """

    _validation = {
        'positive': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TargetConfidenceScoreLabel, self).__init__(**kwargs)
        self.positive = kwargs['positive']
        self.negative = kwargs['negative']


class TargetRelation(msrest.serialization.Model):
    """TargetRelation.

    All required parameters must be populated in order to send to Azure.

    :param relation_type: Required. The type related to the target. Possible values include:
     "assessment", "target".
    :type relation_type: str or ~azure.ai.textanalytics.v3_1.models.TargetRelationType
    :param ref: Required. The JSON pointer indicating the linked object.
    :type ref: str
    """

    _validation = {
        'relation_type': {'required': True},
        'ref': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'ref': {'key': 'ref', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TargetRelation, self).__init__(**kwargs)
        self.relation_type = kwargs['relation_type']
        self.ref = kwargs['ref']


class TasksStateTasks(msrest.serialization.Model):
    """TasksStateTasks.

    All required parameters must be populated in order to send to Azure.

    :param completed: Required.
    :type completed: int
    :param failed: Required.
    :type failed: int
    :param in_progress: Required.
    :type in_progress: int
    :param total: Required.
    :type total: int
    :param entity_recognition_tasks:
    :type entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityRecognitionTasksItem]
    :param entity_recognition_pii_tasks:
    :type entity_recognition_pii_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityRecognitionPiiTasksItem]
    :param key_phrase_extraction_tasks:
    :type key_phrase_extraction_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksKeyPhraseExtractionTasksItem]
    :param entity_linking_tasks:
    :type entity_linking_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksEntityLinkingTasksItem]
    :param sentiment_analysis_tasks:
    :type sentiment_analysis_tasks:
     list[~azure.ai.textanalytics.v3_1.models.TasksStateTasksSentimentAnalysisTasksItem]
    """

    _validation = {
        'completed': {'required': True},
        'failed': {'required': True},
        'in_progress': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        'completed': {'key': 'completed', 'type': 'int'},
        'failed': {'key': 'failed', 'type': 'int'},
        'in_progress': {'key': 'inProgress', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
        'entity_recognition_tasks': {'key': 'entityRecognitionTasks', 'type': '[TasksStateTasksEntityRecognitionTasksItem]'},
        'entity_recognition_pii_tasks': {'key': 'entityRecognitionPiiTasks', 'type': '[TasksStateTasksEntityRecognitionPiiTasksItem]'},
        'key_phrase_extraction_tasks': {'key': 'keyPhraseExtractionTasks', 'type': '[TasksStateTasksKeyPhraseExtractionTasksItem]'},
        'entity_linking_tasks': {'key': 'entityLinkingTasks', 'type': '[TasksStateTasksEntityLinkingTasksItem]'},
        'sentiment_analysis_tasks': {'key': 'sentimentAnalysisTasks', 'type': '[TasksStateTasksSentimentAnalysisTasksItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TasksStateTasks, self).__init__(**kwargs)
        self.completed = kwargs['completed']
        self.failed = kwargs['failed']
        self.in_progress = kwargs['in_progress']
        self.total = kwargs['total']
        self.entity_recognition_tasks = kwargs.get('entity_recognition_tasks', None)
        self.entity_recognition_pii_tasks = kwargs.get('entity_recognition_pii_tasks', None)
        self.key_phrase_extraction_tasks = kwargs.get('key_phrase_extraction_tasks', None)
        self.entity_linking_tasks = kwargs.get('entity_linking_tasks', None)
        self.sentiment_analysis_tasks = kwargs.get('sentiment_analysis_tasks', None)


class TaskState(msrest.serialization.Model):
    """TaskState.

    All required parameters must be populated in order to send to Azure.

    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param task_name: Required.
    :type task_name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskState, self).__init__(**kwargs)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksEntityLinkingTasksItem(TaskState, EntityLinkingTaskResult):
    """TasksStateTasksEntityLinkingTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.EntityLinkingResult
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param task_name: Required.
    :type task_name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntityLinkingResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TasksStateTasksEntityLinkingTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksEntityRecognitionPiiTasksItem(TaskState, PiiTaskResult):
    """TasksStateTasksEntityRecognitionPiiTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.PiiResult
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param task_name: Required.
    :type task_name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'PiiResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TasksStateTasksEntityRecognitionPiiTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksEntityRecognitionTasksItem(TaskState, EntitiesTaskResult):
    """TasksStateTasksEntityRecognitionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.EntitiesResult
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param task_name: Required.
    :type task_name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntitiesResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TasksStateTasksEntityRecognitionTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksKeyPhraseExtractionTasksItem(TaskState, KeyPhraseTaskResult):
    """TasksStateTasksKeyPhraseExtractionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.KeyPhraseResult
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param task_name: Required.
    :type task_name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TasksStateTasksKeyPhraseExtractionTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksSentimentAnalysisTasksItem(TaskState, SentimentTaskResult):
    """TasksStateTasksSentimentAnalysisTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results:
    :type results: ~azure.ai.textanalytics.v3_1.models.SentimentResponse
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param task_name: Required.
    :type task_name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :type status: str or ~azure.ai.textanalytics.v3_1.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'SentimentResponse'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TasksStateTasksSentimentAnalysisTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TextAnalyticsError(msrest.serialization.Model):
    """TextAnalyticsError.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include: "InvalidRequest",
     "InvalidArgument", "InternalServerError", "ServiceUnavailable", "NotFound".
    :type code: str or ~azure.ai.textanalytics.v3_1.models.ErrorCodeValue
    :param message: Required. Error message.
    :type message: str
    :param target: Error target.
    :type target: str
    :param innererror: Inner error contains more specific information.
    :type innererror: ~azure.ai.textanalytics.v3_1.models.InnerError
    :param details: Details about specific errors that led to this reported error.
    :type details: list[~azure.ai.textanalytics.v3_1.models.TextAnalyticsError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'details': {'key': 'details', 'type': '[TextAnalyticsError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TextAnalyticsError, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)
        self.innererror = kwargs.get('innererror', None)
        self.details = kwargs.get('details', None)


class TextAnalyticsWarning(msrest.serialization.Model):
    """TextAnalyticsWarning.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include: "LongWordsInDocument",
     "DocumentTruncated".
    :type code: str or ~azure.ai.textanalytics.v3_1.models.WarningCodeValue
    :param message: Required. Warning message.
    :type message: str
    :param target_ref: A JSON pointer reference indicating the target object.
    :type target_ref: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target_ref': {'key': 'targetRef', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TextAnalyticsWarning, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target_ref = kwargs.get('target_ref', None)
