# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AlignMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An optional field, indicates how we align different variables into the same time-range which is
    required by the model.{Inner, Outer}
    """

    INNER = "Inner"
    OUTER = "Outer"

class AnomalyDetectorErrorCodes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The error code.
    """

    INVALID_CUSTOM_INTERVAL = "InvalidCustomInterval"
    BAD_ARGUMENT = "BadArgument"
    INVALID_GRANULARITY = "InvalidGranularity"
    INVALID_PERIOD = "InvalidPeriod"
    INVALID_MODEL_ARGUMENT = "InvalidModelArgument"
    INVALID_SERIES = "InvalidSeries"
    INVALID_JSON_FORMAT = "InvalidJsonFormat"
    REQUIRED_GRANULARITY = "RequiredGranularity"
    REQUIRED_SERIES = "RequiredSeries"

class DetectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Multivariate anomaly detection status
    """

    CREATED = "CREATED"
    RUNNING = "RUNNING"
    READY = "READY"
    FAILED = "FAILED"

class FillNAMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An optional field, indicates how missed values will be filled with. Can not be set to NotFill,
    when alignMode is Outer.{Previous, Subsequent, Linear, Zero, Fix, NotFill}
    """

    PREVIOUS = "Previous"
    SUBSEQUENT = "Subsequent"
    LINEAR = "Linear"
    ZERO = "Zero"
    PAD = "Pad"
    NOT_FILL = "NotFill"

class ModelStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Model training status.
    """

    CREATED = "CREATED"
    RUNNING = "RUNNING"
    READY = "READY"
    FAILED = "FAILED"

class TimeGranularity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Optional argument, can be one of yearly, monthly, weekly, daily, hourly, minutely, secondly,
    microsecond or none. If granularity is not present, it will be none by default. If granularity
    is none, the timestamp property in time series point can be absent.
    """

    YEARLY = "yearly"
    MONTHLY = "monthly"
    WEEKLY = "weekly"
    DAILY = "daily"
    HOURLY = "hourly"
    PER_MINUTE = "minutely"
    PER_SECOND = "secondly"
    MICROSECOND = "microsecond"
    NONE = "none"
