# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Address(Model):
    """The shipping address of the customer.

    All required parameters must be populated in order to send to Azure.

    :param address_line1: Required. The address line1.
    :type address_line1: str
    :param address_line2: The address line2.
    :type address_line2: str
    :param address_line3: The address line3.
    :type address_line3: str
    :param postal_code: Required. The postal code.
    :type postal_code: str
    :param city: Required. The city name.
    :type city: str
    :param state: Required. The state name.
    :type state: str
    :param country: Required. The country name.
    :type country: str
    """

    _validation = {
        'address_line1': {'required': True},
        'postal_code': {'required': True},
        'city': {'required': True},
        'state': {'required': True},
        'country': {'required': True},
    }

    _attribute_map = {
        'address_line1': {'key': 'addressLine1', 'type': 'str'},
        'address_line2': {'key': 'addressLine2', 'type': 'str'},
        'address_line3': {'key': 'addressLine3', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Address, self).__init__(**kwargs)
        self.address_line1 = kwargs.get('address_line1', None)
        self.address_line2 = kwargs.get('address_line2', None)
        self.address_line3 = kwargs.get('address_line3', None)
        self.postal_code = kwargs.get('postal_code', None)
        self.city = kwargs.get('city', None)
        self.state = kwargs.get('state', None)
        self.country = kwargs.get('country', None)


class ARMBaseModel(Model):
    """Represents the base class for all object models.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ARMBaseModel, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Alert(ARMBaseModel):
    """Alert on the data box edge/gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar title: Alert title.
    :vartype title: str
    :ivar alert_type: Alert type.
    :vartype alert_type: str
    :ivar appeared_at_date_time: UTC time when the alert appeared.
    :vartype appeared_at_date_time: datetime
    :ivar recommendation: Alert recommendation.
    :vartype recommendation: str
    :ivar severity: Severity of the alert. Possible values include:
     'Informational', 'Warning', 'Critical'
    :vartype severity: str or ~azure.mgmt.databoxedge.models.AlertSeverity
    :ivar error_details: Error details of the alert.
    :vartype error_details: ~azure.mgmt.databoxedge.models.AlertErrorDetails
    :ivar detailed_information: Alert details.
    :vartype detailed_information: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'readonly': True},
        'alert_type': {'readonly': True},
        'appeared_at_date_time': {'readonly': True},
        'recommendation': {'readonly': True},
        'severity': {'readonly': True},
        'error_details': {'readonly': True},
        'detailed_information': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'alert_type': {'key': 'properties.alertType', 'type': 'str'},
        'appeared_at_date_time': {'key': 'properties.appearedAtDateTime', 'type': 'iso-8601'},
        'recommendation': {'key': 'properties.recommendation', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'error_details': {'key': 'properties.errorDetails', 'type': 'AlertErrorDetails'},
        'detailed_information': {'key': 'properties.detailedInformation', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Alert, self).__init__(**kwargs)
        self.title = None
        self.alert_type = None
        self.appeared_at_date_time = None
        self.recommendation = None
        self.severity = None
        self.error_details = None
        self.detailed_information = None


class AlertErrorDetails(Model):
    """Error details for the alert.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_code: Error code.
    :vartype error_code: str
    :ivar error_message: Error Message.
    :vartype error_message: str
    :ivar occurrences: Number of occurrences.
    :vartype occurrences: int
    """

    _validation = {
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'occurrences': {'readonly': True},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'occurrences': {'key': 'occurrences', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AlertErrorDetails, self).__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.occurrences = None


class AsymmetricEncryptedSecret(Model):
    """Represent the secrets intended for encryption with asymmetric key pair.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The value of the secret.
    :type value: str
    :param encryption_cert_thumbprint: Thumbprint certificate used to encrypt
     \\"Value\\". If the value is unencrypted, it will be null.
    :type encryption_cert_thumbprint: str
    :param encryption_algorithm: Required. The algorithm used to encrypt
     "Value". Possible values include: 'None', 'AES256', 'RSAES_PKCS1_v_1_5'
    :type encryption_algorithm: str or
     ~azure.mgmt.databoxedge.models.EncryptionAlgorithm
    """

    _validation = {
        'value': {'required': True},
        'encryption_algorithm': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'encryption_cert_thumbprint': {'key': 'encryptionCertThumbprint', 'type': 'str'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AsymmetricEncryptedSecret, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.encryption_cert_thumbprint = kwargs.get('encryption_cert_thumbprint', None)
        self.encryption_algorithm = kwargs.get('encryption_algorithm', None)


class Authentication(Model):
    """Authentication mechanism for IoT devices.

    :param symmetric_key: Symmetric key for authentication.
    :type symmetric_key: ~azure.mgmt.databoxedge.models.SymmetricKey
    """

    _attribute_map = {
        'symmetric_key': {'key': 'symmetricKey', 'type': 'SymmetricKey'},
    }

    def __init__(self, **kwargs):
        super(Authentication, self).__init__(**kwargs)
        self.symmetric_key = kwargs.get('symmetric_key', None)


class AzureContainerInfo(Model):
    """Azure container mapping of the endpoint.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_credential_id: Required. ID of the storage account
     credential used to access storage.
    :type storage_account_credential_id: str
    :param container_name: Required. Container name (Based on the data format
     specified, this represents the name of Azure Files/Page blob/Block blob).
    :type container_name: str
    :param data_format: Required. Storage format used for the file represented
     by the share. Possible values include: 'BlockBlob', 'PageBlob',
     'AzureFile'
    :type data_format: str or
     ~azure.mgmt.databoxedge.models.AzureContainerDataFormat
    """

    _validation = {
        'storage_account_credential_id': {'required': True},
        'container_name': {'required': True},
        'data_format': {'required': True},
    }

    _attribute_map = {
        'storage_account_credential_id': {'key': 'storageAccountCredentialId', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'data_format': {'key': 'dataFormat', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureContainerInfo, self).__init__(**kwargs)
        self.storage_account_credential_id = kwargs.get('storage_account_credential_id', None)
        self.container_name = kwargs.get('container_name', None)
        self.data_format = kwargs.get('data_format', None)


class BandwidthSchedule(ARMBaseModel):
    """The bandwidth schedule details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param start: Required. The start time of the schedule in UTC.
    :type start: str
    :param stop: Required. The stop time of the schedule in UTC.
    :type stop: str
    :param rate_in_mbps: Required. The bandwidth rate in Mbps.
    :type rate_in_mbps: int
    :param days: Required. The days of the week when this schedule is
     applicable.
    :type days: list[str or ~azure.mgmt.databoxedge.models.DayOfWeek]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start': {'required': True},
        'stop': {'required': True},
        'rate_in_mbps': {'required': True},
        'days': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start': {'key': 'properties.start', 'type': 'str'},
        'stop': {'key': 'properties.stop', 'type': 'str'},
        'rate_in_mbps': {'key': 'properties.rateInMbps', 'type': 'int'},
        'days': {'key': 'properties.days', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(BandwidthSchedule, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.stop = kwargs.get('stop', None)
        self.rate_in_mbps = kwargs.get('rate_in_mbps', None)
        self.days = kwargs.get('days', None)


class ClientAccessRight(Model):
    """The mapping between a particular client IP and the type of access client
    has on the NFS share.

    All required parameters must be populated in order to send to Azure.

    :param client: Required. IP of the client.
    :type client: str
    :param access_permission: Required. Type of access to be allowed for the
     client. Possible values include: 'NoAccess', 'ReadOnly', 'ReadWrite'
    :type access_permission: str or
     ~azure.mgmt.databoxedge.models.ClientPermissionType
    """

    _validation = {
        'client': {'required': True},
        'access_permission': {'required': True},
    }

    _attribute_map = {
        'client': {'key': 'client', 'type': 'str'},
        'access_permission': {'key': 'accessPermission', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClientAccessRight, self).__init__(**kwargs)
        self.client = kwargs.get('client', None)
        self.access_permission = kwargs.get('access_permission', None)


class CloudError(Model):
    """An error response from the service.

    :param error: The error details.
    :type error: ~azure.mgmt.databoxedge.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.databoxedge.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, **kwargs):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class ContactDetails(Model):
    """Contains all the contact details of the customer.

    All required parameters must be populated in order to send to Azure.

    :param contact_person: Required. The contact person name.
    :type contact_person: str
    :param company_name: Required. The name of the company.
    :type company_name: str
    :param phone: Required. The phone number.
    :type phone: str
    :param email_list: Required. The email list.
    :type email_list: list[str]
    """

    _validation = {
        'contact_person': {'required': True},
        'company_name': {'required': True},
        'phone': {'required': True},
        'email_list': {'required': True},
    }

    _attribute_map = {
        'contact_person': {'key': 'contactPerson', 'type': 'str'},
        'company_name': {'key': 'companyName', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
        'email_list': {'key': 'emailList', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ContactDetails, self).__init__(**kwargs)
        self.contact_person = kwargs.get('contact_person', None)
        self.company_name = kwargs.get('company_name', None)
        self.phone = kwargs.get('phone', None)
        self.email_list = kwargs.get('email_list', None)


class DataBoxEdgeDevice(ARMBaseModel):
    """The Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param location: Required. The location of the device. This is a supported
     and registered Azure geographical region (for example, West US, East US,
     or Southeast Asia). The geographical region of a device cannot be changed
     once it is created, but if an identical geographical region is specified
     on update, the request will succeed.
    :type location: str
    :param tags: The list of tags that describe the device. These tags can be
     used to view and group this device (across resource groups).
    :type tags: dict[str, str]
    :param sku: The SKU type.
    :type sku: ~azure.mgmt.databoxedge.models.Sku
    :param etag: The etag for the devices.
    :type etag: str
    :param data_box_edge_device_status: The status of the Data Box
     Edge/Gateway device. Possible values include: 'ReadyToSetup', 'Online',
     'Offline', 'NeedsAttention', 'Disconnected', 'PartiallyDisconnected'
    :type data_box_edge_device_status: str or
     ~azure.mgmt.databoxedge.models.DataBoxEdgeDeviceStatus
    :ivar serial_number: The Serial Number of Data Box Edge/Gateway device.
    :vartype serial_number: str
    :param description: The Description of the Data Box Edge/Gateway device.
    :type description: str
    :param model_description: The description of the Data Box Edge/Gateway
     device model.
    :type model_description: str
    :ivar device_type: The type of the Data Box Edge/Gateway device. Possible
     values include: 'DataBoxEdgeDevice'
    :vartype device_type: str or ~azure.mgmt.databoxedge.models.DeviceType
    :param friendly_name: The Data Box Edge/Gateway device name.
    :type friendly_name: str
    :ivar culture: The Data Box Edge/Gateway device culture.
    :vartype culture: str
    :ivar device_model: The Data Box Edge/Gateway device model.
    :vartype device_model: str
    :ivar device_software_version: The Data Box Edge/Gateway device software
     version.
    :vartype device_software_version: str
    :ivar device_local_capacity: The Data Box Edge/Gateway device local
     capacity in MB.
    :vartype device_local_capacity: long
    :ivar time_zone: The Data Box Edge/Gateway device timezone.
    :vartype time_zone: str
    :ivar device_hcs_version: The device software version number of the device
     (eg: 1.2.18105.6).
    :vartype device_hcs_version: str
    :ivar configured_role_types: Type of compute roles configured.
    :vartype configured_role_types: list[str or
     ~azure.mgmt.databoxedge.models.RoleTypes]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'serial_number': {'readonly': True},
        'device_type': {'readonly': True},
        'culture': {'readonly': True},
        'device_model': {'readonly': True},
        'device_software_version': {'readonly': True},
        'device_local_capacity': {'readonly': True},
        'time_zone': {'readonly': True},
        'device_hcs_version': {'readonly': True},
        'configured_role_types': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'data_box_edge_device_status': {'key': 'properties.dataBoxEdgeDeviceStatus', 'type': 'str'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'model_description': {'key': 'properties.modelDescription', 'type': 'str'},
        'device_type': {'key': 'properties.deviceType', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'culture': {'key': 'properties.culture', 'type': 'str'},
        'device_model': {'key': 'properties.deviceModel', 'type': 'str'},
        'device_software_version': {'key': 'properties.deviceSoftwareVersion', 'type': 'str'},
        'device_local_capacity': {'key': 'properties.deviceLocalCapacity', 'type': 'long'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'device_hcs_version': {'key': 'properties.deviceHcsVersion', 'type': 'str'},
        'configured_role_types': {'key': 'properties.configuredRoleTypes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DataBoxEdgeDevice, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)
        self.etag = kwargs.get('etag', None)
        self.data_box_edge_device_status = kwargs.get('data_box_edge_device_status', None)
        self.serial_number = None
        self.description = kwargs.get('description', None)
        self.model_description = kwargs.get('model_description', None)
        self.device_type = None
        self.friendly_name = kwargs.get('friendly_name', None)
        self.culture = None
        self.device_model = None
        self.device_software_version = None
        self.device_local_capacity = None
        self.time_zone = None
        self.device_hcs_version = None
        self.configured_role_types = None


class DataBoxEdgeDeviceExtendedInfo(ARMBaseModel):
    """The extended Info of the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param encryption_key_thumbprint: The digital signature of encrypted
     certificate.
    :type encryption_key_thumbprint: str
    :param encryption_key: The public part of the encryption certificate.
     Client uses this to encrypt any secret.
    :type encryption_key: str
    :ivar resource_key: The Resource ID of the Resource.
    :vartype resource_key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'encryption_key_thumbprint': {'key': 'properties.encryptionKeyThumbprint', 'type': 'str'},
        'encryption_key': {'key': 'properties.encryptionKey', 'type': 'str'},
        'resource_key': {'key': 'properties.resourceKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataBoxEdgeDeviceExtendedInfo, self).__init__(**kwargs)
        self.encryption_key_thumbprint = kwargs.get('encryption_key_thumbprint', None)
        self.encryption_key = kwargs.get('encryption_key', None)
        self.resource_key = None


class DataBoxEdgeDevicePatch(Model):
    """The Data Box Edge/Gateway device patch.

    :param tags: The tags attached to the Data Box Edge/Gateway resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(DataBoxEdgeDevicePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class Trigger(ARMBaseModel):
    """Trigger details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FileEventTrigger, PeriodicTimerEventTrigger

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'FileEvent': 'FileEventTrigger', 'PeriodicTimerEvent': 'PeriodicTimerEventTrigger'}
    }

    def __init__(self, **kwargs):
        super(Trigger, self).__init__(**kwargs)
        self.kind = None
        self.kind = 'Trigger'


class FileEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param source_info: Required. File event source details.
    :type source_info: ~azure.mgmt.databoxedge.models.FileSourceInfo
    :param sink_info: Required. Role sink info.
    :type sink_info: ~azure.mgmt.databoxedge.models.RoleSinkInfo
    :param custom_context_tag: A custom context tag typically used to
     correlate the trigger against its usage. For example, if a periodic timer
     trigger is intended for certain specific IoT modules in the device, the
     tag can be the name or the image URL of the module.
    :type custom_context_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'source_info': {'required': True},
        'sink_info': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'source_info': {'key': 'properties.sourceInfo', 'type': 'FileSourceInfo'},
        'sink_info': {'key': 'properties.sinkInfo', 'type': 'RoleSinkInfo'},
        'custom_context_tag': {'key': 'properties.customContextTag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileEventTrigger, self).__init__(**kwargs)
        self.source_info = kwargs.get('source_info', None)
        self.sink_info = kwargs.get('sink_info', None)
        self.custom_context_tag = kwargs.get('custom_context_tag', None)
        self.kind = 'FileEvent'


class FileSourceInfo(Model):
    """File source details.

    All required parameters must be populated in order to send to Azure.

    :param share_id: Required. File share ID.
    :type share_id: str
    """

    _validation = {
        'share_id': {'required': True},
    }

    _attribute_map = {
        'share_id': {'key': 'shareId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileSourceInfo, self).__init__(**kwargs)
        self.share_id = kwargs.get('share_id', None)


class IoTDeviceInfo(Model):
    """Metadata of IoT device/IoT Edge device to be configured.

    All required parameters must be populated in order to send to Azure.

    :param device_id: Required. ID of the IoT device/edge device.
    :type device_id: str
    :param io_thost_hub: Required. Host name for the IoT hub associated to the
     device.
    :type io_thost_hub: str
    :param authentication: IoT device authentication info.
    :type authentication: ~azure.mgmt.databoxedge.models.Authentication
    """

    _validation = {
        'device_id': {'required': True},
        'io_thost_hub': {'required': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'io_thost_hub': {'key': 'ioTHostHub', 'type': 'str'},
        'authentication': {'key': 'authentication', 'type': 'Authentication'},
    }

    def __init__(self, **kwargs):
        super(IoTDeviceInfo, self).__init__(**kwargs)
        self.device_id = kwargs.get('device_id', None)
        self.io_thost_hub = kwargs.get('io_thost_hub', None)
        self.authentication = kwargs.get('authentication', None)


class Role(ARMBaseModel):
    """Compute role.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: IoTRole

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'IOT': 'IoTRole'}
    }

    def __init__(self, **kwargs):
        super(Role, self).__init__(**kwargs)
        self.kind = None
        self.kind = 'Role'


class IoTRole(Role):
    """Compute role.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param host_platform: Required. Host OS supported by the IoT role.
     Possible values include: 'Windows', 'Linux'
    :type host_platform: str or ~azure.mgmt.databoxedge.models.PlatformType
    :param io_tdevice_details: Required. IoT device metadata to which data box
     edge device needs to be connected.
    :type io_tdevice_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
    :param io_tedge_device_details: Required. IoT edge device to which the IoT
     role needs to be configured.
    :type io_tedge_device_details:
     ~azure.mgmt.databoxedge.models.IoTDeviceInfo
    :param share_mappings: Mount points of shares in role(s).
    :type share_mappings: list[~azure.mgmt.databoxedge.models.MountPointMap]
    :param role_status: Required. Role status. Possible values include:
     'Enabled', 'Disabled'
    :type role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'host_platform': {'required': True},
        'io_tdevice_details': {'required': True},
        'io_tedge_device_details': {'required': True},
        'role_status': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'host_platform': {'key': 'properties.hostPlatform', 'type': 'str'},
        'io_tdevice_details': {'key': 'properties.ioTDeviceDetails', 'type': 'IoTDeviceInfo'},
        'io_tedge_device_details': {'key': 'properties.ioTEdgeDeviceDetails', 'type': 'IoTDeviceInfo'},
        'share_mappings': {'key': 'properties.shareMappings', 'type': '[MountPointMap]'},
        'role_status': {'key': 'properties.roleStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IoTRole, self).__init__(**kwargs)
        self.host_platform = kwargs.get('host_platform', None)
        self.io_tdevice_details = kwargs.get('io_tdevice_details', None)
        self.io_tedge_device_details = kwargs.get('io_tedge_device_details', None)
        self.share_mappings = kwargs.get('share_mappings', None)
        self.role_status = kwargs.get('role_status', None)
        self.kind = 'IOT'


class Ipv4Config(Model):
    """Details related to the IPv4 address configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar ip_address: The IPv4 address of the network adapter.
    :vartype ip_address: str
    :ivar subnet: The IPv4 subnet of the network adapter.
    :vartype subnet: str
    :ivar gateway: The IPv4 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        'ip_address': {'readonly': True},
        'subnet': {'readonly': True},
        'gateway': {'readonly': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
        'gateway': {'key': 'gateway', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Ipv4Config, self).__init__(**kwargs)
        self.ip_address = None
        self.subnet = None
        self.gateway = None


class Ipv6Config(Model):
    """Details related to the IPv6 address configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar ip_address: The IPv6 address of the network adapter.
    :vartype ip_address: str
    :ivar prefix_length: The IPv6 prefix of the network adapter.
    :vartype prefix_length: int
    :ivar gateway: The IPv6 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        'ip_address': {'readonly': True},
        'prefix_length': {'readonly': True},
        'gateway': {'readonly': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'prefix_length': {'key': 'prefixLength', 'type': 'int'},
        'gateway': {'key': 'gateway', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Ipv6Config, self).__init__(**kwargs)
        self.ip_address = None
        self.prefix_length = None
        self.gateway = None


class Job(Model):
    """A device job.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The name of the object.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar status: The current status of the job. Possible values include:
     'Invalid', 'Running', 'Succeeded', 'Failed', 'Canceled', 'Paused',
     'Scheduled'
    :vartype status: str or ~azure.mgmt.databoxedge.models.JobStatus
    :ivar start_time: The UTC date and time at which the job started.
    :vartype start_time: datetime
    :ivar end_time: The UTC date and time at which the job completed.
    :vartype end_time: datetime
    :ivar percent_complete: The percentage of the job that is complete.
    :vartype percent_complete: int
    :ivar error: The error details.
    :vartype error: ~azure.mgmt.databoxedge.models.JobErrorDetails
    :ivar job_type: The type of the job. Possible values include: 'Invalid',
     'ScanForUpdates', 'DownloadUpdates', 'InstallUpdates', 'RefreshShare'
    :vartype job_type: str or ~azure.mgmt.databoxedge.models.JobType
    :ivar current_stage: Current stage of the update operation. Possible
     values include: 'Unknown', 'Initial', 'ScanStarted', 'ScanComplete',
     'ScanFailed', 'DownloadStarted', 'DownloadComplete', 'DownloadFailed',
     'InstallStarted', 'InstallComplete', 'InstallFailed', 'RebootInitiated',
     'Success', 'Failure', 'RescanStarted', 'RescanComplete', 'RescanFailed'
    :vartype current_stage: str or
     ~azure.mgmt.databoxedge.models.UpdateOperationStage
    :ivar download_progress: The download progress.
    :vartype download_progress:
     ~azure.mgmt.databoxedge.models.UpdateDownloadProgress
    :ivar install_progress: The install progress.
    :vartype install_progress:
     ~azure.mgmt.databoxedge.models.UpdateInstallProgress
    :ivar total_refresh_errors: Total number of errors encountered during the
     refresh process.
    :vartype total_refresh_errors: int
    :ivar error_manifest_file: Local share/remote container relative path to
     the error manifest file of the refresh.
    :vartype error_manifest_file: str
    :ivar share_id: ARM ID of the share that was refreshed.
    :vartype share_id: str
    :param folder: If only subfolders need to be refreshed, then the subfolder
     path inside the share. (The path is empty if there are no subfolders.)
    :type folder: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'error': {'readonly': True},
        'job_type': {'readonly': True},
        'current_stage': {'readonly': True},
        'download_progress': {'readonly': True},
        'install_progress': {'readonly': True},
        'total_refresh_errors': {'readonly': True},
        'error_manifest_file': {'readonly': True},
        'share_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'error': {'key': 'error', 'type': 'JobErrorDetails'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'current_stage': {'key': 'properties.currentStage', 'type': 'str'},
        'download_progress': {'key': 'properties.downloadProgress', 'type': 'UpdateDownloadProgress'},
        'install_progress': {'key': 'properties.installProgress', 'type': 'UpdateInstallProgress'},
        'total_refresh_errors': {'key': 'properties.totalRefreshErrors', 'type': 'int'},
        'error_manifest_file': {'key': 'properties.errorManifestFile', 'type': 'str'},
        'share_id': {'key': 'properties.shareId', 'type': 'str'},
        'folder': {'key': 'properties.folder', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Job, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.percent_complete = None
        self.error = None
        self.job_type = None
        self.current_stage = None
        self.download_progress = None
        self.install_progress = None
        self.total_refresh_errors = None
        self.error_manifest_file = None
        self.share_id = None
        self.folder = kwargs.get('folder', None)


class JobErrorDetails(Model):
    """The job error information containing the list of job errors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_details: The error details.
    :vartype error_details: list[~azure.mgmt.databoxedge.models.JobErrorItem]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        'error_details': {'readonly': True},
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorItem]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobErrorDetails, self).__init__(**kwargs)
        self.error_details = None
        self.code = None
        self.message = None


class JobErrorItem(Model):
    """The job error items.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar recommendations: The recommended actions.
    :vartype recommendations: list[str]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        'recommendations': {'readonly': True},
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobErrorItem, self).__init__(**kwargs)
        self.recommendations = None
        self.code = None
        self.message = None


class MetricDimensionV1(Model):
    """Metric Dimension v1.

    :param name: Name of the metrics dimension.
    :type name: str
    :param display_name: Display name of the metrics dimension.
    :type display_name: str
    :param to_be_exported_for_shoebox: To be exported to shoe box.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(MetricDimensionV1, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class MetricSpecificationV1(Model):
    """Metric specification version 1.

    :param name: Name of the metric.
    :type name: str
    :param display_name: Display name of the metric.
    :type display_name: str
    :param display_description: Description of the metric to be displayed.
    :type display_description: str
    :param unit: Metric units. Possible values include: 'NotSpecified',
     'Percent', 'Count', 'Seconds', 'Milliseconds', 'Bytes', 'BytesPerSecond',
     'CountPerSecond'
    :type unit: str or ~azure.mgmt.databoxedge.models.MetricUnit
    :param aggregation_type: Metric aggregation type. Possible values include:
     'NotSpecified', 'None', 'Average', 'Minimum', 'Maximum', 'Total', 'Count'
    :type aggregation_type: str or
     ~azure.mgmt.databoxedge.models.MetricAggregationType
    :param dimensions: Metric dimensions, other than default dimension which
     is resource.
    :type dimensions: list[~azure.mgmt.databoxedge.models.MetricDimensionV1]
    :param fill_gap_with_zero: Set true to fill the gaps with zero.
    :type fill_gap_with_zero: bool
    :param category: Metric category. Possible values include: 'Capacity',
     'Transaction'
    :type category: str or ~azure.mgmt.databoxedge.models.MetricCategory
    :param resource_id_dimension_name_override: Resource name override.
    :type resource_id_dimension_name_override: str
    :param supported_time_grain_types: Support granularity of metrics.
    :type supported_time_grain_types: list[str or
     ~azure.mgmt.databoxedge.models.TimeGrain]
    :param supported_aggregation_types: Support metric aggregation type.
    :type supported_aggregation_types: list[str or
     ~azure.mgmt.databoxedge.models.MetricAggregationType]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimensionV1]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(MetricSpecificationV1, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.category = kwargs.get('category', None)
        self.resource_id_dimension_name_override = kwargs.get('resource_id_dimension_name_override', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)


class MountPointMap(Model):
    """The share mount point.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param share_id: Required. ID of the share mounted to the role VM.
    :type share_id: str
    :ivar role_id: ID of the role to which share is mounted.
    :vartype role_id: str
    :ivar mount_point: Mount point for the share.
    :vartype mount_point: str
    :ivar role_type: Role type. Possible values include: 'IOT', 'ASA',
     'Functions', 'Cognitive'
    :vartype role_type: str or ~azure.mgmt.databoxedge.models.RoleTypes
    """

    _validation = {
        'share_id': {'required': True},
        'role_id': {'readonly': True},
        'mount_point': {'readonly': True},
        'role_type': {'readonly': True},
    }

    _attribute_map = {
        'share_id': {'key': 'shareId', 'type': 'str'},
        'role_id': {'key': 'roleId', 'type': 'str'},
        'mount_point': {'key': 'mountPoint', 'type': 'str'},
        'role_type': {'key': 'roleType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MountPointMap, self).__init__(**kwargs)
        self.share_id = kwargs.get('share_id', None)
        self.role_id = None
        self.mount_point = None
        self.role_type = None


class NetworkAdapter(Model):
    """Represents the networkAdapter on a device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar adapter_id: Instance ID of network adapter.
    :vartype adapter_id: str
    :ivar adapter_position: Hardware position of network adapter.
    :vartype adapter_position:
     ~azure.mgmt.databoxedge.models.NetworkAdapterPosition
    :ivar index: Logical index of the adapter.
    :vartype index: int
    :ivar node_id: Node ID of the network adapter.
    :vartype node_id: str
    :ivar network_adapter_name: Network adapter name.
    :vartype network_adapter_name: str
    :ivar label: Hardware label for the adapter.
    :vartype label: str
    :ivar mac_address: MAC address.
    :vartype mac_address: str
    :ivar link_speed: Link speed.
    :vartype link_speed: long
    :ivar status: Value indicating whether this adapter is valid. Possible
     values include: 'Inactive', 'Active'
    :vartype status: str or
     ~azure.mgmt.databoxedge.models.NetworkAdapterStatus
    :param rdma_status: Value indicating whether this adapter is RDMA capable.
     Possible values include: 'Incapable', 'Capable'
    :type rdma_status: str or
     ~azure.mgmt.databoxedge.models.NetworkAdapterRDMAStatus
    :param dhcp_status: Value indicating whether this adapter has DHCP
     enabled. Possible values include: 'Disabled', 'Enabled'
    :type dhcp_status: str or
     ~azure.mgmt.databoxedge.models.NetworkAdapterDHCPStatus
    :ivar ipv4_configuration: The IPv4 configuration of the network adapter.
    :vartype ipv4_configuration: ~azure.mgmt.databoxedge.models.Ipv4Config
    :ivar ipv6_configuration: The IPv6 configuration of the network adapter.
    :vartype ipv6_configuration: ~azure.mgmt.databoxedge.models.Ipv6Config
    :ivar ipv6_link_local_address: The IPv6 local address.
    :vartype ipv6_link_local_address: str
    :ivar dns_servers: The list of DNS Servers of the device.
    :vartype dns_servers: list[str]
    """

    _validation = {
        'adapter_id': {'readonly': True},
        'adapter_position': {'readonly': True},
        'index': {'readonly': True},
        'node_id': {'readonly': True},
        'network_adapter_name': {'readonly': True},
        'label': {'readonly': True},
        'mac_address': {'readonly': True},
        'link_speed': {'readonly': True},
        'status': {'readonly': True},
        'ipv4_configuration': {'readonly': True},
        'ipv6_configuration': {'readonly': True},
        'ipv6_link_local_address': {'readonly': True},
        'dns_servers': {'readonly': True},
    }

    _attribute_map = {
        'adapter_id': {'key': 'adapterId', 'type': 'str'},
        'adapter_position': {'key': 'adapterPosition', 'type': 'NetworkAdapterPosition'},
        'index': {'key': 'index', 'type': 'int'},
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'network_adapter_name': {'key': 'networkAdapterName', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
        'link_speed': {'key': 'linkSpeed', 'type': 'long'},
        'status': {'key': 'status', 'type': 'str'},
        'rdma_status': {'key': 'rdmaStatus', 'type': 'str'},
        'dhcp_status': {'key': 'dhcpStatus', 'type': 'str'},
        'ipv4_configuration': {'key': 'ipv4Configuration', 'type': 'Ipv4Config'},
        'ipv6_configuration': {'key': 'ipv6Configuration', 'type': 'Ipv6Config'},
        'ipv6_link_local_address': {'key': 'ipv6LinkLocalAddress', 'type': 'str'},
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(NetworkAdapter, self).__init__(**kwargs)
        self.adapter_id = None
        self.adapter_position = None
        self.index = None
        self.node_id = None
        self.network_adapter_name = None
        self.label = None
        self.mac_address = None
        self.link_speed = None
        self.status = None
        self.rdma_status = kwargs.get('rdma_status', None)
        self.dhcp_status = kwargs.get('dhcp_status', None)
        self.ipv4_configuration = None
        self.ipv6_configuration = None
        self.ipv6_link_local_address = None
        self.dns_servers = None


class NetworkAdapterPosition(Model):
    """The network adapter position.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar network_group: The network group. Possible values include: 'None',
     'NonRDMA', 'RDMA'
    :vartype network_group: str or ~azure.mgmt.databoxedge.models.NetworkGroup
    :ivar port: The port.
    :vartype port: int
    """

    _validation = {
        'network_group': {'readonly': True},
        'port': {'readonly': True},
    }

    _attribute_map = {
        'network_group': {'key': 'networkGroup', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(NetworkAdapterPosition, self).__init__(**kwargs)
        self.network_group = None
        self.port = None


class NetworkSettings(ARMBaseModel):
    """The network settings of a device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar network_adapters: The network adapter list on the device.
    :vartype network_adapters:
     list[~azure.mgmt.databoxedge.models.NetworkAdapter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'network_adapters': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'network_adapters': {'key': 'properties.networkAdapters', 'type': '[NetworkAdapter]'},
    }

    def __init__(self, **kwargs):
        super(NetworkSettings, self).__init__(**kwargs)
        self.network_adapters = None


class Operation(Model):
    """Operations.

    :param name: Name of the operation.
    :type name: str
    :param display: Properties displayed for the operation.
    :type display: ~azure.mgmt.databoxedge.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param service_specification: Service specification.
    :type service_specification:
     ~azure.mgmt.databoxedge.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplay(Model):
    """Operation display properties.

    :param provider: Provider name.
    :type provider: str
    :param resource: The type of resource in which the operation is performed.
    :type resource: str
    :param operation: Operation to be performed on the resource.
    :type operation: str
    :param description: Description of the operation to be performed.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class Order(ARMBaseModel):
    """The order details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param contact_information: Required. The contact details.
    :type contact_information: ~azure.mgmt.databoxedge.models.ContactDetails
    :param shipping_address: Required. The shipping address.
    :type shipping_address: ~azure.mgmt.databoxedge.models.Address
    :param current_status: Current status of the order.
    :type current_status: ~azure.mgmt.databoxedge.models.OrderStatus
    :ivar order_history: List of status changes in the order.
    :vartype order_history: list[~azure.mgmt.databoxedge.models.OrderStatus]
    :ivar serial_number: Serial number of the device.
    :vartype serial_number: str
    :ivar delivery_tracking_info: Tracking information for the package
     delivered to the customer whether it has an original or a replacement
     device.
    :vartype delivery_tracking_info:
     list[~azure.mgmt.databoxedge.models.TrackingInfo]
    :ivar return_tracking_info: Tracking information for the package returned
     from the customer whether it has an original or a replacement device.
    :vartype return_tracking_info:
     list[~azure.mgmt.databoxedge.models.TrackingInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'contact_information': {'required': True},
        'shipping_address': {'required': True},
        'order_history': {'readonly': True},
        'serial_number': {'readonly': True},
        'delivery_tracking_info': {'readonly': True},
        'return_tracking_info': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'contact_information': {'key': 'properties.contactInformation', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'properties.shippingAddress', 'type': 'Address'},
        'current_status': {'key': 'properties.currentStatus', 'type': 'OrderStatus'},
        'order_history': {'key': 'properties.orderHistory', 'type': '[OrderStatus]'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'delivery_tracking_info': {'key': 'properties.deliveryTrackingInfo', 'type': '[TrackingInfo]'},
        'return_tracking_info': {'key': 'properties.returnTrackingInfo', 'type': '[TrackingInfo]'},
    }

    def __init__(self, **kwargs):
        super(Order, self).__init__(**kwargs)
        self.contact_information = kwargs.get('contact_information', None)
        self.shipping_address = kwargs.get('shipping_address', None)
        self.current_status = kwargs.get('current_status', None)
        self.order_history = None
        self.serial_number = None
        self.delivery_tracking_info = None
        self.return_tracking_info = None


class OrderStatus(Model):
    """Represents a single status change.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Status of the order as per the allowed status
     types. Possible values include: 'Untracked', 'AwaitingFulfilment',
     'AwaitingPreparation', 'AwaitingShipment', 'Shipped', 'Arriving',
     'Delivered', 'ReplacementRequested', 'LostDevice', 'Declined',
     'ReturnInitiated', 'AwaitingReturnShipment', 'ShippedBack',
     'CollectedAtMicrosoft'
    :type status: str or ~azure.mgmt.databoxedge.models.OrderState
    :ivar update_date_time: Time of status update.
    :vartype update_date_time: datetime
    :param comments: Comments related to this status change.
    :type comments: str
    """

    _validation = {
        'status': {'required': True},
        'update_date_time': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'update_date_time': {'key': 'updateDateTime', 'type': 'iso-8601'},
        'comments': {'key': 'comments', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OrderStatus, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.update_date_time = None
        self.comments = kwargs.get('comments', None)


class PeriodicTimerEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param source_info: Required. Periodic timer details.
    :type source_info: ~azure.mgmt.databoxedge.models.PeriodicTimerSourceInfo
    :param sink_info: Required. Role Sink information.
    :type sink_info: ~azure.mgmt.databoxedge.models.RoleSinkInfo
    :param custom_context_tag: A custom context tag typically used to
     correlate the trigger against its usage. For example, if a periodic timer
     trigger is intended for certain specific IoT modules in the device, the
     tag can be the name or the image URL of the module.
    :type custom_context_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'source_info': {'required': True},
        'sink_info': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'source_info': {'key': 'properties.sourceInfo', 'type': 'PeriodicTimerSourceInfo'},
        'sink_info': {'key': 'properties.sinkInfo', 'type': 'RoleSinkInfo'},
        'custom_context_tag': {'key': 'properties.customContextTag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PeriodicTimerEventTrigger, self).__init__(**kwargs)
        self.source_info = kwargs.get('source_info', None)
        self.sink_info = kwargs.get('sink_info', None)
        self.custom_context_tag = kwargs.get('custom_context_tag', None)
        self.kind = 'PeriodicTimerEvent'


class PeriodicTimerSourceInfo(Model):
    """Periodic timer event source.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The time of the day that results in a valid
     trigger. Schedule is computed with reference to the time specified up to
     seconds. If timezone is not specified the time will considered to be in
     device timezone. The value will always be returned as UTC time.
    :type start_time: datetime
    :param schedule: Required. Periodic frequency at which timer event needs
     to be raised. Supports daily, hourly, minutes, and seconds.
    :type schedule: str
    :param topic: Topic where periodic events are published to IoT device.
    :type topic: str
    """

    _validation = {
        'start_time': {'required': True},
        'schedule': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'schedule': {'key': 'schedule', 'type': 'str'},
        'topic': {'key': 'topic', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PeriodicTimerSourceInfo, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.schedule = kwargs.get('schedule', None)
        self.topic = kwargs.get('topic', None)


class RefreshDetails(Model):
    """Fields for tracking refresh job on the share.

    :param in_progress_refresh_job_id: If a refresh share job is currently in
     progress on this share, this field indicates the ARM resource ID of that
     job. The field is empty if no job is in progress.
    :type in_progress_refresh_job_id: str
    :param last_completed_refresh_job_time_in_utc: Indicates the completed
     time for the last refresh job on this particular share, if any.This could
     be a failed job or a successful job.
    :type last_completed_refresh_job_time_in_utc: datetime
    :param error_manifest_file: Indicates the relative path of the error xml
     for the last refresh job on this particular share, if any. This could be a
     failed job or a successful job.
    :type error_manifest_file: str
    :param last_job: Indicates the id of the last refresh job on this
     particular share,if any. This could be a failed job or a successful job.
    :type last_job: str
    """

    _attribute_map = {
        'in_progress_refresh_job_id': {'key': 'inProgressRefreshJobId', 'type': 'str'},
        'last_completed_refresh_job_time_in_utc': {'key': 'lastCompletedRefreshJobTimeInUTC', 'type': 'iso-8601'},
        'error_manifest_file': {'key': 'errorManifestFile', 'type': 'str'},
        'last_job': {'key': 'lastJob', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RefreshDetails, self).__init__(**kwargs)
        self.in_progress_refresh_job_id = kwargs.get('in_progress_refresh_job_id', None)
        self.last_completed_refresh_job_time_in_utc = kwargs.get('last_completed_refresh_job_time_in_utc', None)
        self.error_manifest_file = kwargs.get('error_manifest_file', None)
        self.last_job = kwargs.get('last_job', None)


class RoleSinkInfo(Model):
    """Compute role against which events will be raised.

    All required parameters must be populated in order to send to Azure.

    :param role_id: Required. Compute role ID.
    :type role_id: str
    """

    _validation = {
        'role_id': {'required': True},
    }

    _attribute_map = {
        'role_id': {'key': 'roleId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RoleSinkInfo, self).__init__(**kwargs)
        self.role_id = kwargs.get('role_id', None)


class SecuritySettings(ARMBaseModel):
    """The security settings of a device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param device_admin_password: Required. Device administrator password as
     an encrypted string (encrypted using RSA PKCS #1) is used to sign into the
     local web UI of the device. The Actual password should have at least 8
     characters that are a combination of  uppercase, lowercase, numeric, and
     special characters.
    :type device_admin_password:
     ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'device_admin_password': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'device_admin_password': {'key': 'properties.deviceAdminPassword', 'type': 'AsymmetricEncryptedSecret'},
    }

    def __init__(self, **kwargs):
        super(SecuritySettings, self).__init__(**kwargs)
        self.device_admin_password = kwargs.get('device_admin_password', None)


class ServiceSpecification(Model):
    """Service specification.

    :param metric_specifications: Metric specification as defined by shoebox.
    :type metric_specifications:
     list[~azure.mgmt.databoxedge.models.MetricSpecificationV1]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecificationV1]'},
    }

    def __init__(self, **kwargs):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class Share(ARMBaseModel):
    """Represents a share on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param description: Description for the share.
    :type description: str
    :param share_status: Required. Current status of the share. Possible
     values include: 'Online', 'Offline'
    :type share_status: str or ~azure.mgmt.databoxedge.models.ShareStatus
    :param monitoring_status: Required. Current monitoring status of the
     share. Possible values include: 'Enabled', 'Disabled'
    :type monitoring_status: str or
     ~azure.mgmt.databoxedge.models.MonitoringStatus
    :param azure_container_info: Azure container mapping for the share.
    :type azure_container_info:
     ~azure.mgmt.databoxedge.models.AzureContainerInfo
    :param access_protocol: Required. Access protocol to be used by the share.
     Possible values include: 'SMB', 'NFS'
    :type access_protocol: str or
     ~azure.mgmt.databoxedge.models.ShareAccessProtocol
    :param user_access_rights: Mapping of users and corresponding access
     rights on the share (required for SMB protocol).
    :type user_access_rights:
     list[~azure.mgmt.databoxedge.models.UserAccessRight]
    :param client_access_rights: List of IP addresses and corresponding access
     rights on the share(required for NFS protocol).
    :type client_access_rights:
     list[~azure.mgmt.databoxedge.models.ClientAccessRight]
    :param refresh_details: Details of the refresh job on this share.
    :type refresh_details: ~azure.mgmt.databoxedge.models.RefreshDetails
    :ivar share_mappings: Share mount point to the role.
    :vartype share_mappings:
     list[~azure.mgmt.databoxedge.models.MountPointMap]
    :param data_policy: Data policy of the share. Possible values include:
     'Cloud', 'Local'
    :type data_policy: str or ~azure.mgmt.databoxedge.models.DataPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'share_status': {'required': True},
        'monitoring_status': {'required': True},
        'access_protocol': {'required': True},
        'share_mappings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'share_status': {'key': 'properties.shareStatus', 'type': 'str'},
        'monitoring_status': {'key': 'properties.monitoringStatus', 'type': 'str'},
        'azure_container_info': {'key': 'properties.azureContainerInfo', 'type': 'AzureContainerInfo'},
        'access_protocol': {'key': 'properties.accessProtocol', 'type': 'str'},
        'user_access_rights': {'key': 'properties.userAccessRights', 'type': '[UserAccessRight]'},
        'client_access_rights': {'key': 'properties.clientAccessRights', 'type': '[ClientAccessRight]'},
        'refresh_details': {'key': 'properties.refreshDetails', 'type': 'RefreshDetails'},
        'share_mappings': {'key': 'properties.shareMappings', 'type': '[MountPointMap]'},
        'data_policy': {'key': 'properties.dataPolicy', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Share, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.share_status = kwargs.get('share_status', None)
        self.monitoring_status = kwargs.get('monitoring_status', None)
        self.azure_container_info = kwargs.get('azure_container_info', None)
        self.access_protocol = kwargs.get('access_protocol', None)
        self.user_access_rights = kwargs.get('user_access_rights', None)
        self.client_access_rights = kwargs.get('client_access_rights', None)
        self.refresh_details = kwargs.get('refresh_details', None)
        self.share_mappings = None
        self.data_policy = kwargs.get('data_policy', None)


class ShareAccessRight(Model):
    """Specifies the mapping between this particular user and the type of access
    he has on shares on this device.

    All required parameters must be populated in order to send to Azure.

    :param share_id: Required. The share ID.
    :type share_id: str
    :param access_type: Required. Type of access to be allowed on the share
     for this user. Possible values include: 'Change', 'Read', 'Custom'
    :type access_type: str or ~azure.mgmt.databoxedge.models.ShareAccessType
    """

    _validation = {
        'share_id': {'required': True},
        'access_type': {'required': True},
    }

    _attribute_map = {
        'share_id': {'key': 'shareId', 'type': 'str'},
        'access_type': {'key': 'accessType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ShareAccessRight, self).__init__(**kwargs)
        self.share_id = kwargs.get('share_id', None)
        self.access_type = kwargs.get('access_type', None)


class Sku(Model):
    """The SKU type.

    :param name: SKU name. Possible values include: 'Gateway', 'Edge'
    :type name: str or ~azure.mgmt.databoxedge.models.SkuName
    :param tier: The SKU tier. This is based on the SKU name. Possible values
     include: 'Standard'
    :type tier: str or ~azure.mgmt.databoxedge.models.SkuTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)


class StorageAccountCredential(ARMBaseModel):
    """The storage account credential.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param alias: Required. Alias for the storage account.
    :type alias: str
    :param user_name: Username for the storage account.
    :type user_name: str
    :param account_key: Encrypted storage key.
    :type account_key:
     ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    :param connection_string: Connection string for the storage account. Use
     this string if username and account key are not specified.
    :type connection_string: str
    :param ssl_status: Required. Signifies whether SSL needs to be enabled or
     not. Possible values include: 'Enabled', 'Disabled'
    :type ssl_status: str or ~azure.mgmt.databoxedge.models.SSLStatus
    :param blob_domain_name: Blob end point for private clouds.
    :type blob_domain_name: str
    :param account_type: Required. Type of storage accessed on the storage
     account. Possible values include: 'GeneralPurposeStorage', 'BlobStorage'
    :type account_type: str or ~azure.mgmt.databoxedge.models.AccountType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'alias': {'required': True},
        'ssl_status': {'required': True},
        'account_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'alias': {'key': 'properties.alias', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'account_key': {'key': 'properties.accountKey', 'type': 'AsymmetricEncryptedSecret'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'ssl_status': {'key': 'properties.sslStatus', 'type': 'str'},
        'blob_domain_name': {'key': 'properties.blobDomainName', 'type': 'str'},
        'account_type': {'key': 'properties.accountType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StorageAccountCredential, self).__init__(**kwargs)
        self.alias = kwargs.get('alias', None)
        self.user_name = kwargs.get('user_name', None)
        self.account_key = kwargs.get('account_key', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.ssl_status = kwargs.get('ssl_status', None)
        self.blob_domain_name = kwargs.get('blob_domain_name', None)
        self.account_type = kwargs.get('account_type', None)


class SymmetricKey(Model):
    """Symmetric key for authentication.

    :param connection_string: Connection string based on the symmetric key.
    :type connection_string:
     ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    """

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'AsymmetricEncryptedSecret'},
    }

    def __init__(self, **kwargs):
        super(SymmetricKey, self).__init__(**kwargs)
        self.connection_string = kwargs.get('connection_string', None)


class TrackingInfo(Model):
    """Tracking courier information.

    :param serial_number: Serial number of the device being tracked.
    :type serial_number: str
    :param carrier_name: Name of the carrier used in the delivery.
    :type carrier_name: str
    :param tracking_id: Tracking ID of the shipment.
    :type tracking_id: str
    :param tracking_url: Tracking URL of the shipment.
    :type tracking_url: str
    """

    _attribute_map = {
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrackingInfo, self).__init__(**kwargs)
        self.serial_number = kwargs.get('serial_number', None)
        self.carrier_name = kwargs.get('carrier_name', None)
        self.tracking_id = kwargs.get('tracking_id', None)
        self.tracking_url = kwargs.get('tracking_url', None)


class UpdateDownloadProgress(Model):
    """Details about the download progress of update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar download_phase: The download phase. Possible values include:
     'Unknown', 'Initializing', 'Downloading', 'Verifying'
    :vartype download_phase: str or
     ~azure.mgmt.databoxedge.models.DownloadPhase
    :ivar percent_complete: Percentage of completion.
    :vartype percent_complete: int
    :ivar total_bytes_to_download: Total bytes to download.
    :vartype total_bytes_to_download: float
    :ivar total_bytes_downloaded: Total bytes downloaded.
    :vartype total_bytes_downloaded: float
    :ivar number_of_updates_to_download: Number of updates to download.
    :vartype number_of_updates_to_download: int
    :ivar number_of_updates_downloaded: Number of updates downloaded.
    :vartype number_of_updates_downloaded: int
    """

    _validation = {
        'download_phase': {'readonly': True},
        'percent_complete': {'readonly': True},
        'total_bytes_to_download': {'readonly': True},
        'total_bytes_downloaded': {'readonly': True},
        'number_of_updates_to_download': {'readonly': True},
        'number_of_updates_downloaded': {'readonly': True},
    }

    _attribute_map = {
        'download_phase': {'key': 'downloadPhase', 'type': 'str'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'total_bytes_to_download': {'key': 'totalBytesToDownload', 'type': 'float'},
        'total_bytes_downloaded': {'key': 'totalBytesDownloaded', 'type': 'float'},
        'number_of_updates_to_download': {'key': 'numberOfUpdatesToDownload', 'type': 'int'},
        'number_of_updates_downloaded': {'key': 'numberOfUpdatesDownloaded', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(UpdateDownloadProgress, self).__init__(**kwargs)
        self.download_phase = None
        self.percent_complete = None
        self.total_bytes_to_download = None
        self.total_bytes_downloaded = None
        self.number_of_updates_to_download = None
        self.number_of_updates_downloaded = None


class UpdateInstallProgress(Model):
    """Progress details during installation of updates.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar percent_complete: Percentage completed.
    :vartype percent_complete: int
    :ivar number_of_updates_to_install: Number of updates to install.
    :vartype number_of_updates_to_install: int
    :ivar number_of_updates_installed: Number of updates installed.
    :vartype number_of_updates_installed: int
    """

    _validation = {
        'percent_complete': {'readonly': True},
        'number_of_updates_to_install': {'readonly': True},
        'number_of_updates_installed': {'readonly': True},
    }

    _attribute_map = {
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'number_of_updates_to_install': {'key': 'numberOfUpdatesToInstall', 'type': 'int'},
        'number_of_updates_installed': {'key': 'numberOfUpdatesInstalled', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(UpdateInstallProgress, self).__init__(**kwargs)
        self.percent_complete = None
        self.number_of_updates_to_install = None
        self.number_of_updates_installed = None


class UpdateSummary(ARMBaseModel):
    """Details about ongoing updates and availability of updates on the device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param device_version_number: The current version of the device in format:
     1.2.17312.13.",
    :type device_version_number: str
    :param friendly_device_version_name: The current version of the device in
     text format.
    :type friendly_device_version_name: str
    :param device_last_scanned_date_time: The last time when a scan was done
     on the device.
    :type device_last_scanned_date_time: datetime
    :param last_completed_scan_job_date_time: The time when the last scan job
     was completed (success/cancelled/failed) on the appliance.
    :type last_completed_scan_job_date_time: datetime
    :ivar last_completed_download_job_date_time: The time when the last
     Download job was completed (success/cancelled/failed) on the appliance.
    :vartype last_completed_download_job_date_time: datetime
    :ivar last_completed_install_job_date_time: The time when the last Install
     job was completed (success/cancelled/failed) on the appliance.
    :vartype last_completed_install_job_date_time: datetime
    :ivar total_number_of_updates_available: The number of updates available
     for the current device version as per the last device scan.
    :vartype total_number_of_updates_available: int
    :ivar total_number_of_updates_pending_download: The total number of items
     pending download.
    :vartype total_number_of_updates_pending_download: int
    :ivar total_number_of_updates_pending_install: The total number of items
     pending install.
    :vartype total_number_of_updates_pending_install: int
    :ivar reboot_behavior: Indicates if updates are available and at least one
     of the updates needs a reboot. Possible values include: 'NeverReboots',
     'RequiresReboot', 'RequestReboot'
    :vartype reboot_behavior: str or
     ~azure.mgmt.databoxedge.models.InstallRebootBehavior
    :ivar ongoing_update_operation: The current update operation. Possible
     values include: 'None', 'Scan', 'Download', 'Install'
    :vartype ongoing_update_operation: str or
     ~azure.mgmt.databoxedge.models.UpdateOperation
    :ivar in_progress_download_job_id: The job ID of the download job in
     progress.
    :vartype in_progress_download_job_id: str
    :ivar in_progress_install_job_id: The job ID of the install job in
     progress.
    :vartype in_progress_install_job_id: str
    :ivar in_progress_download_job_started_date_time: The time when the
     currently running download (if any) started.
    :vartype in_progress_download_job_started_date_time: datetime
    :ivar in_progress_install_job_started_date_time: The time when the
     currently running install (if any) started.
    :vartype in_progress_install_job_started_date_time: datetime
    :ivar update_titles: The list of updates available for install.
    :vartype update_titles: list[str]
    :ivar total_update_size_in_bytes: The total size of updates available for
     download in bytes.
    :vartype total_update_size_in_bytes: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_completed_download_job_date_time': {'readonly': True},
        'last_completed_install_job_date_time': {'readonly': True},
        'total_number_of_updates_available': {'readonly': True},
        'total_number_of_updates_pending_download': {'readonly': True},
        'total_number_of_updates_pending_install': {'readonly': True},
        'reboot_behavior': {'readonly': True},
        'ongoing_update_operation': {'readonly': True},
        'in_progress_download_job_id': {'readonly': True},
        'in_progress_install_job_id': {'readonly': True},
        'in_progress_download_job_started_date_time': {'readonly': True},
        'in_progress_install_job_started_date_time': {'readonly': True},
        'update_titles': {'readonly': True},
        'total_update_size_in_bytes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'device_version_number': {'key': 'properties.deviceVersionNumber', 'type': 'str'},
        'friendly_device_version_name': {'key': 'properties.friendlyDeviceVersionName', 'type': 'str'},
        'device_last_scanned_date_time': {'key': 'properties.deviceLastScannedDateTime', 'type': 'iso-8601'},
        'last_completed_scan_job_date_time': {'key': 'properties.lastCompletedScanJobDateTime', 'type': 'iso-8601'},
        'last_completed_download_job_date_time': {'key': 'properties.lastCompletedDownloadJobDateTime', 'type': 'iso-8601'},
        'last_completed_install_job_date_time': {'key': 'properties.lastCompletedInstallJobDateTime', 'type': 'iso-8601'},
        'total_number_of_updates_available': {'key': 'properties.totalNumberOfUpdatesAvailable', 'type': 'int'},
        'total_number_of_updates_pending_download': {'key': 'properties.totalNumberOfUpdatesPendingDownload', 'type': 'int'},
        'total_number_of_updates_pending_install': {'key': 'properties.totalNumberOfUpdatesPendingInstall', 'type': 'int'},
        'reboot_behavior': {'key': 'properties.rebootBehavior', 'type': 'str'},
        'ongoing_update_operation': {'key': 'properties.ongoingUpdateOperation', 'type': 'str'},
        'in_progress_download_job_id': {'key': 'properties.inProgressDownloadJobId', 'type': 'str'},
        'in_progress_install_job_id': {'key': 'properties.inProgressInstallJobId', 'type': 'str'},
        'in_progress_download_job_started_date_time': {'key': 'properties.inProgressDownloadJobStartedDateTime', 'type': 'iso-8601'},
        'in_progress_install_job_started_date_time': {'key': 'properties.inProgressInstallJobStartedDateTime', 'type': 'iso-8601'},
        'update_titles': {'key': 'properties.updateTitles', 'type': '[str]'},
        'total_update_size_in_bytes': {'key': 'properties.totalUpdateSizeInBytes', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(UpdateSummary, self).__init__(**kwargs)
        self.device_version_number = kwargs.get('device_version_number', None)
        self.friendly_device_version_name = kwargs.get('friendly_device_version_name', None)
        self.device_last_scanned_date_time = kwargs.get('device_last_scanned_date_time', None)
        self.last_completed_scan_job_date_time = kwargs.get('last_completed_scan_job_date_time', None)
        self.last_completed_download_job_date_time = None
        self.last_completed_install_job_date_time = None
        self.total_number_of_updates_available = None
        self.total_number_of_updates_pending_download = None
        self.total_number_of_updates_pending_install = None
        self.reboot_behavior = None
        self.ongoing_update_operation = None
        self.in_progress_download_job_id = None
        self.in_progress_install_job_id = None
        self.in_progress_download_job_started_date_time = None
        self.in_progress_install_job_started_date_time = None
        self.update_titles = None
        self.total_update_size_in_bytes = None


class UploadCertificateRequest(Model):
    """The upload certificate request.

    All required parameters must be populated in order to send to Azure.

    :param authentication_type: The authentication type. Possible values
     include: 'Invalid', 'AzureActiveDirectory'
    :type authentication_type: str or
     ~azure.mgmt.databoxedge.models.AuthenticationType
    :param certificate: Required. The base64 encoded certificate raw data.
    :type certificate: str
    """

    _validation = {
        'certificate': {'required': True},
    }

    _attribute_map = {
        'authentication_type': {'key': 'properties.authenticationType', 'type': 'str'},
        'certificate': {'key': 'properties.certificate', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UploadCertificateRequest, self).__init__(**kwargs)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.certificate = kwargs.get('certificate', None)


class UploadCertificateResponse(Model):
    """The upload registration certificate response.

    All required parameters must be populated in order to send to Azure.

    :param auth_type: Specifies authentication type. Possible values include:
     'Invalid', 'AzureActiveDirectory'
    :type auth_type: str or ~azure.mgmt.databoxedge.models.AuthenticationType
    :param resource_id: Required. The resource ID of the Data Box Edge/Gateway
     device.
    :type resource_id: str
    :param aad_authority: Required. Azure Active Directory tenant authority.
    :type aad_authority: str
    :param aad_tenant_id: Required. Azure Active Directory tenant ID.
    :type aad_tenant_id: str
    :param service_principal_client_id: Required. Azure Active Directory
     service principal client ID.
    :type service_principal_client_id: str
    :param service_principal_object_id: Required. Azure Active Directory
     service principal object ID.
    :type service_principal_object_id: str
    :param azure_management_endpoint_audience: Required. The azure management
     endpoint audience.
    :type azure_management_endpoint_audience: str
    """

    _validation = {
        'resource_id': {'required': True},
        'aad_authority': {'required': True},
        'aad_tenant_id': {'required': True},
        'service_principal_client_id': {'required': True},
        'service_principal_object_id': {'required': True},
        'azure_management_endpoint_audience': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'aad_authority': {'key': 'aadAuthority', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'service_principal_object_id': {'key': 'servicePrincipalObjectId', 'type': 'str'},
        'azure_management_endpoint_audience': {'key': 'azureManagementEndpointAudience', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UploadCertificateResponse, self).__init__(**kwargs)
        self.auth_type = kwargs.get('auth_type', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.aad_authority = kwargs.get('aad_authority', None)
        self.aad_tenant_id = kwargs.get('aad_tenant_id', None)
        self.service_principal_client_id = kwargs.get('service_principal_client_id', None)
        self.service_principal_object_id = kwargs.get('service_principal_object_id', None)
        self.azure_management_endpoint_audience = kwargs.get('azure_management_endpoint_audience', None)


class User(ARMBaseModel):
    """Represents a user who has access to one or more shares on the Data Box
    Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param encrypted_password: The password details.
    :type encrypted_password:
     ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    :param share_access_rights: List of shares that the user has rights on.
     This field should not be specified during user creation.
    :type share_access_rights:
     list[~azure.mgmt.databoxedge.models.ShareAccessRight]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'encrypted_password': {'key': 'properties.encryptedPassword', 'type': 'AsymmetricEncryptedSecret'},
        'share_access_rights': {'key': 'properties.shareAccessRights', 'type': '[ShareAccessRight]'},
    }

    def __init__(self, **kwargs):
        super(User, self).__init__(**kwargs)
        self.encrypted_password = kwargs.get('encrypted_password', None)
        self.share_access_rights = kwargs.get('share_access_rights', None)


class UserAccessRight(Model):
    """The mapping between a particular user and the access type on the SMB share.

    All required parameters must be populated in order to send to Azure.

    :param user_id: Required. User ID (already existing in the device).
    :type user_id: str
    :param access_type: Required. Type of access to be allowed for the user.
     Possible values include: 'Change', 'Read', 'Custom'
    :type access_type: str or ~azure.mgmt.databoxedge.models.ShareAccessType
    """

    _validation = {
        'user_id': {'required': True},
        'access_type': {'required': True},
    }

    _attribute_map = {
        'user_id': {'key': 'userId', 'type': 'str'},
        'access_type': {'key': 'accessType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserAccessRight, self).__init__(**kwargs)
        self.user_id = kwargs.get('user_id', None)
        self.access_type = kwargs.get('access_type', None)
