/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

class Utils {
    static final byte LOG_CRIT = 5;
    static final byte LOG_ERR = 4;
    static final byte LOG_WARN = 3;
    static final byte LOG_NOTICE = 2;
    static final byte LOG_INFO = 1;
    static final byte LOG_DEBUG = 0;
    private static byte logLevel = (byte)3;
    private static char[] hc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    Utils() {
    }

    static String hexEncode(byte[] b, int off, int len) {
        if (b == null || len <= 0) {
            return "";
        }
        if (off < 0 || b.length < off + len) {
            return "<bad args>";
        }
        char[] r = new char[len << 1];
        int i = 0;
        int j = 0;
        while (i < len) {
            int v = b[off + i] & 0xFF;
            r[j++] = hc[v >>> 4];
            r[j++] = hc[v & 0xF];
            ++i;
        }
        return new String(r);
    }

    static String hexEncode(byte[] b) {
        if (b == null) {
            return "";
        }
        return Utils.hexEncode(b, 0, b.length);
    }

    static byte[] longToBytes(long n) {
        byte[] b = new byte[8];
        int i = 0;
        while (i < 64) {
            b[i >> 3] = (byte)(n >> 56 - i & 0xFFL);
            i += 8;
        }
        return b;
    }

    static boolean byteMatch(byte[] a, int aOff, byte[] b, int bOff, int len) {
        if (a.length < aOff + len || b.length < bOff + len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i + aOff] != b[i + bOff]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static void log(byte lev, String msg) {
        if (lev < logLevel) {
            return;
        }
        try {
            System.out.print(msg);
        }
        catch (Exception e) {
            System.out.println("log() caught <" + e + ">");
        }
    }

    static void logln(byte lev, String msg) {
        if (lev < logLevel) {
            return;
        }
        try {
            System.out.println(msg);
        }
        catch (Exception e) {
            System.out.println("logln() caught <" + e + ">");
        }
    }
}

