/*
 * Decompiled with CFR 0.152.
 */
package midlet;

import java.io.IOException;
import java.io.Reader;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import org.gjt.xpp.XmlPullParserException;
import shared.count.ProgressObserver;
import shared.count.ReaderFactory;
import shared.count.XppCount;

public class XppCountMidlet
extends MIDlet
implements CommandListener,
ProgressObserver,
ReaderFactory,
Runnable {
    private static final boolean DEBUG = false;
    Command exitCommand = new Command("Exit", 7, 2);
    Command parseCommand = new Command("Parse", 1, 1);
    Command speedCommand = new Command("Test", 1, 1);
    Command okCommand = new Command("OK", 4, 1);
    Display display;
    Form welcomeForm;
    TextField inputXml;
    TextBox parsingOutput;
    boolean stopped = true;
    boolean finishRun;
    char[] xmlContent;
    XppCount driver;
    Thread runner;

    private void debug(String msg) {
    }

    public void startApp() throws MIDletStateChangeException {
        this.welcomeForm = new Form("XPP2 DEMO");
        this.inputXml = new TextField("Enter XML", "<hello>World! 10</hello>", 1000, 0);
        this.welcomeForm.append((Item)this.inputXml);
        this.welcomeForm.addCommand(this.parseCommand);
        this.welcomeForm.addCommand(this.exitCommand);
        this.welcomeForm.setCommandListener((CommandListener)this);
        this.parsingOutput = new TextBox("Output", "", 1000, 0);
        this.parsingOutput.setCommandListener((CommandListener)this);
        this.parsingOutput.addCommand(this.okCommand);
        this.parsingOutput.setCommandListener((CommandListener)this);
        this.display = Display.getDisplay((MIDlet)this);
        this.display.setCurrent((Displayable)this.welcomeForm);
        this.driver = new XppCount();
        this.runner = new Thread(this);
        this.finishRun = false;
        this.runner.start();
    }

    public void pauseApp() {
        this.stopped = true;
    }

    public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.stopped = true;
        this.finishRun = true;
        if (unconditional) {
            this.notifyDestroyed();
        }
    }

    public void commandAction(Command c, Displayable s) {
        try {
            this.debug("command=" + c);
            if (c == this.exitCommand) {
                this.debug("EXIT pressed");
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (c == this.parseCommand) {
                this.debug("PARSE pressed");
                this.parsingOutput.setString("Parsing...\n");
                this.display.setCurrent((Displayable)this.parsingOutput);
                this.xmlContent = new char[this.inputXml.size()];
                this.inputXml.getChars(this.xmlContent);
                this.debug("parsing requested");
                this.stopped = false;
                Thread.currentThread();
                Thread.yield();
            } else if (c == this.okCommand) {
                this.debug("OK pressed");
                this.debug("parsing stopped");
                this.stopped = true;
                this.display.setCurrent((Displayable)this.welcomeForm);
                Thread.currentThread();
                Thread.yield();
            } else {
                this.debug("Unknown command " + c);
            }
        }
        catch (Exception ex) {
            this.debug(ex.toString());
            ex.printStackTrace();
        }
    }

    public void print(String msg) {
        int last = this.parsingOutput.size();
        this.parsingOutput.insert(msg, last);
    }

    public void println(String msg) {
        this.print(msg + "\n");
    }

    public void trace(String msg) {
    }

    public void verbose(String msg) {
    }

    public boolean stopRequested() {
        return this.stopped;
    }

    public Reader newReader() throws IOException {
        MyCharArrayReader r = new MyCharArrayReader(this.xmlContent);
        return r;
    }

    public void runTest() {
        try {
            if (!this.stopped) {
                this.debug("paring started...");
                System.err.println("runtTest paring start");
                this.driver.runTest("INTERNAL", this, this);
                this.stopped = true;
                this.debug("parsing finished");
            }
        }
        catch (XmlPullParserException ex) {
            this.stopped = true;
            this.println("\nParsing error: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (IOException ex) {
            this.stopped = true;
            this.println("\nIO error: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            this.stopped = true;
            this.println("\nGeneric error: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void run() {
        boolean count = false;
        while (!this.finishRun) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.runTest();
        }
    }

    public class MyCharArrayReader
    extends Reader {
        char[] buf;
        int pos;

        public MyCharArrayReader(char[] buf) {
            this.buf = buf;
            this.pos = 0;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            XppCountMidlet.this.debug("buf=" + this.buf + " cbuf=" + cbuf + " off=" + off + " len=" + len);
            int toRead = len;
            if (this.pos + toRead > this.buf.length) {
                toRead = this.buf.length - this.pos;
            }
            if (toRead == 0) {
                return -1;
            }
            System.arraycopy(this.buf, this.pos, cbuf, off, toRead);
            this.pos += toRead;
            return toRead;
        }

        public void close() throws IOException {
            if (this.pos >= this.buf.length) {
                throw new IOException("attempt to close already closed reader");
            }
            this.pos = this.buf.length;
        }
    }
}

