.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_set_default_password.mdoc -- set default password for zip
.\" Copyright (C) 2011-2021 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_SET_DEFAULT_PASSWORD" "3" "September 15, 2020" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_set_default_password\fR
\- set default password for encrypted files in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_set_default_password\fR(\fIzip_t\ *archive\fR, \fIconst\ char\ *password\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_set_default_password\fR()
function sets the default password used when accessing encrypted files.
If
\fIpassword\fR
is
\fRNULL\fR
or the empty string, the default password is unset.
.PP
If you prefer a different password for single files, use
zip_fopen_encrypted(3)
instead of
zip_fopen(3).
Usually, however, the same password is used for every file in an
zip archive.
.PP
The password is not verified when calling this function.
See the
\fICAVEATS\fR
section in
zip_fopen_encrypted(3)
for more details about password handling.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_set_default_password\fR()
fails if:
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_fopen(3),
zip_fopen_encrypted(3)
.SH "HISTORY"
\fBzip_set_default_password\fR()
was added in libzip 0.10.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
