// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/agentcommunication/v1/agent_communication.proto

package agentcommunicationpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	anypb "google.golang.org/protobuf/types/known/anypb"
	status "google.golang.org/genproto/googleapis/rpc/status"
	codes "google.golang.org/grpc/codes"
	grpc "google.golang.org/grpc"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Reasons returned in ErrorInfo with any messages containing google.rpc.Status.
type ErrorReason int32

const (
	// Default value. This value is unused.
	ErrorReason_ERROR_REASON_UNSPECIFIED ErrorReason = 0
	// The message was missing a message ID.
	ErrorReason_MISSING_MESSAGE_ID ErrorReason = 1
	// The message type was missing or invalid.
	ErrorReason_INVALID_MESSAGE_TYPE ErrorReason = 2
	// The was not acked.
	ErrorReason_MESSAGE_NOT_ACKED ErrorReason = 3
	// The MessageResponse is invalid.
	ErrorReason_INVALID_MESSAGE_RESPONSE ErrorReason = 4
	// The register request was invalid.
	ErrorReason_INVALID_REGISTER_REQUEST ErrorReason = 5
	// Stream headers are missing or invalid.
	ErrorReason_INVALID_STREAM_HEADERS ErrorReason = 6
	// Service enablement check failed.
	ErrorReason_SERVICE_CHECK_FAILURE ErrorReason = 7
	// Rate of new connections is too high.
	ErrorReason_AGENT_CONNECTION_RATE_QUOTA_EXCEEDED ErrorReason = 8
	// Rate of messages too high. This will only happen if message rate far
	// exceeds quota, well behaved agents are expected to respond to
	// AGENT_MESSAGE_RATE_QUOTA_EXCEEDED in StreamAgentMessagesResponse.
	ErrorReason_AGENT_MESSAGE_RATE_QUOTA_EXCEEDED ErrorReason = 9
	// Message bandwidth of new connections is too high.
	ErrorReason_AGENT_BANDWIDTH_RATE_QUOTA_EXCEEDED ErrorReason = 10
	// The SendAgentMessageRequest is invalid.
	ErrorReason_INVALID_SEND_AGENT_MESSAGE_REQUEST ErrorReason = 11
)

// Enum value maps for ErrorReason.
var (
	ErrorReason_name = map[int32]string{
		0:  "ERROR_REASON_UNSPECIFIED",
		1:  "MISSING_MESSAGE_ID",
		2:  "INVALID_MESSAGE_TYPE",
		3:  "MESSAGE_NOT_ACKED",
		4:  "INVALID_MESSAGE_RESPONSE",
		5:  "INVALID_REGISTER_REQUEST",
		6:  "INVALID_STREAM_HEADERS",
		7:  "SERVICE_CHECK_FAILURE",
		8:  "AGENT_CONNECTION_RATE_QUOTA_EXCEEDED",
		9:  "AGENT_MESSAGE_RATE_QUOTA_EXCEEDED",
		10: "AGENT_BANDWIDTH_RATE_QUOTA_EXCEEDED",
		11: "INVALID_SEND_AGENT_MESSAGE_REQUEST",
	}
	ErrorReason_value = map[string]int32{
		"ERROR_REASON_UNSPECIFIED":             0,
		"MISSING_MESSAGE_ID":                   1,
		"INVALID_MESSAGE_TYPE":                 2,
		"MESSAGE_NOT_ACKED":                    3,
		"INVALID_MESSAGE_RESPONSE":             4,
		"INVALID_REGISTER_REQUEST":             5,
		"INVALID_STREAM_HEADERS":               6,
		"SERVICE_CHECK_FAILURE":                7,
		"AGENT_CONNECTION_RATE_QUOTA_EXCEEDED": 8,
		"AGENT_MESSAGE_RATE_QUOTA_EXCEEDED":    9,
		"AGENT_BANDWIDTH_RATE_QUOTA_EXCEEDED":  10,
		"INVALID_SEND_AGENT_MESSAGE_REQUEST":   11,
	}
)

func (x ErrorReason) Enum() *ErrorReason {
	p := new(ErrorReason)
	*p = x
	return p
}

func (x ErrorReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_enumTypes[0].Descriptor()
}

func (ErrorReason) Type() protoreflect.EnumType {
	return &file_google_cloud_agentcommunication_v1_agent_communication_proto_enumTypes[0]
}

func (x ErrorReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorReason.Descriptor instead.
func (ErrorReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{0}
}

// Reasons returned in ErrorInfo when the status field of MessageResponse is
// not OK.
type StreamAgentMessagesResponse_ErrorReason int32

const (
	// Default value. This value is unused.
	StreamAgentMessagesResponse_ERROR_REASON_UNSPECIFIED StreamAgentMessagesResponse_ErrorReason = 0
	// Message rate is too high.
	StreamAgentMessagesResponse_AGENT_MESSAGE_RATE_QUOTA_EXCEEDED StreamAgentMessagesResponse_ErrorReason = 1
	// Message Bandwidth rate is too high.
	StreamAgentMessagesResponse_AGENT_BANDWIDTH_RATE_QUOTA_EXCEEDED StreamAgentMessagesResponse_ErrorReason = 2
)

// Enum value maps for StreamAgentMessagesResponse_ErrorReason.
var (
	StreamAgentMessagesResponse_ErrorReason_name = map[int32]string{
		0: "ERROR_REASON_UNSPECIFIED",
		1: "AGENT_MESSAGE_RATE_QUOTA_EXCEEDED",
		2: "AGENT_BANDWIDTH_RATE_QUOTA_EXCEEDED",
	}
	StreamAgentMessagesResponse_ErrorReason_value = map[string]int32{
		"ERROR_REASON_UNSPECIFIED":            0,
		"AGENT_MESSAGE_RATE_QUOTA_EXCEEDED":   1,
		"AGENT_BANDWIDTH_RATE_QUOTA_EXCEEDED": 2,
	}
)

func (x StreamAgentMessagesResponse_ErrorReason) Enum() *StreamAgentMessagesResponse_ErrorReason {
	p := new(StreamAgentMessagesResponse_ErrorReason)
	*p = x
	return p
}

func (x StreamAgentMessagesResponse_ErrorReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamAgentMessagesResponse_ErrorReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_enumTypes[1].Descriptor()
}

func (StreamAgentMessagesResponse_ErrorReason) Type() protoreflect.EnumType {
	return &file_google_cloud_agentcommunication_v1_agent_communication_proto_enumTypes[1]
}

func (x StreamAgentMessagesResponse_ErrorReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamAgentMessagesResponse_ErrorReason.Descriptor instead.
func (StreamAgentMessagesResponse_ErrorReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{6, 0}
}

// Sends an AgentMessage.
type SendAgentMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the channel for the connection.
	// The channel ID must:
	//   - Be 1-63 characters in length.
	//   - Match the regular expression ^[a-z]([-a-z0-9]*[a-z0-9])?$. This means
	//     that the first character must be a lowercase letter, and all the following
	//     characters must be hyphens, lowercase letters, or digits, except the last
	//     character, which cannot be a hyphen.
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// Required. ID of the resource for the connection.
	// This must only contain UTF-8 encoded characters and be 1-255 characters in
	// length.
	ResourceId string `protobuf:"bytes,2,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Required. The message to be sent.
	MessageBody *MessageBody `protobuf:"bytes,3,opt,name=message_body,json=messageBody,proto3" json:"message_body,omitempty"`
}

func (x *SendAgentMessageRequest) Reset() {
	*x = SendAgentMessageRequest{}
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SendAgentMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendAgentMessageRequest) ProtoMessage() {}

func (x *SendAgentMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendAgentMessageRequest.ProtoReflect.Descriptor instead.
func (*SendAgentMessageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{0}
}

func (x *SendAgentMessageRequest) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *SendAgentMessageRequest) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *SendAgentMessageRequest) GetMessageBody() *MessageBody {
	if x != nil {
		return x.MessageBody
	}
	return nil
}

// Response to a sent message.
type SendAgentMessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message response, if any.
	MessageBody *MessageBody `protobuf:"bytes,1,opt,name=message_body,json=messageBody,proto3" json:"message_body,omitempty"`
}

func (x *SendAgentMessageResponse) Reset() {
	*x = SendAgentMessageResponse{}
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SendAgentMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendAgentMessageResponse) ProtoMessage() {}

func (x *SendAgentMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendAgentMessageResponse.ProtoReflect.Descriptor instead.
func (*SendAgentMessageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{1}
}

func (x *SendAgentMessageResponse) GetMessageBody() *MessageBody {
	if x != nil {
		return x.MessageBody
	}
	return nil
}

// Registers this connection.
type RegisterConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Protocol version to use.
	ProtocolVersion int32 `protobuf:"varint,1,opt,name=protocol_version,json=protocolVersion,proto3" json:"protocol_version,omitempty"`
	// Required. ID of the channel for the connection.
	// The channel ID must:
	//   - Be 1-63 characters in length.
	//   - Match the regular expression ^[a-z]([-a-z0-9]*[a-z0-9])?$. This means
	//     that the first character must be a lowercase letter, and all the following
	//     characters must be hyphens, lowercase letters, or digits, except the last
	//     character, which cannot be a hyphen.
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// Required. ID of the resource for the connection.
	// This must only contain UTF-8 encoded characters and be 1-255 characters in
	// length.
	ResourceId string `protobuf:"bytes,3,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
}

func (x *RegisterConnection) Reset() {
	*x = RegisterConnection{}
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterConnection) ProtoMessage() {}

func (x *RegisterConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterConnection.ProtoReflect.Descriptor instead.
func (*RegisterConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{2}
}

func (x *RegisterConnection) GetProtocolVersion() int32 {
	if x != nil {
		return x.ProtocolVersion
	}
	return 0
}

func (x *RegisterConnection) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *RegisterConnection) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

// Response to a sent message.
type MessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Status for this message response, for non OK status
	// ErrorInfo.reason will be one of StreamAgentMessagesResponse.ErrorReason.
	// Expected agent responses:
	// OK - message was successfully received.
	// Expected service responses:
	// OK - message was successfully received.
	// RESOURCE_EXHAUSTED - this connection is rate limited, message delivery
	// should be slowed.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *MessageResponse) Reset() {
	*x = MessageResponse{}
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageResponse) ProtoMessage() {}

func (x *MessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageResponse.ProtoReflect.Descriptor instead.
func (*MessageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{3}
}

func (x *MessageResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// The message to be delivered.
type MessageBody struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Labels to use for this message for easy lookup and client side
	// filtering. Labels must meet the following constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each message is limited to a maximum of 12 labels and less than 1024
	// bytes.
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The actual message.
	Body *anypb.Any `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *MessageBody) Reset() {
	*x = MessageBody{}
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageBody) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageBody) ProtoMessage() {}

func (x *MessageBody) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageBody.ProtoReflect.Descriptor instead.
func (*MessageBody) Descriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{4}
}

func (x *MessageBody) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *MessageBody) GetBody() *anypb.Any {
	if x != nil {
		return x.Body
	}
	return nil
}

// A streaming request message to send messages to the server on a particular
// channel.
type StreamAgentMessagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the message sent to the service, this ID is used to
	// uniquely identify this message so service can ack.
	MessageId string `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// The type of message.
	//
	// Types that are assignable to Type:
	//
	//	*StreamAgentMessagesRequest_RegisterConnection
	//	*StreamAgentMessagesRequest_MessageResponse
	//	*StreamAgentMessagesRequest_MessageBody
	Type isStreamAgentMessagesRequest_Type `protobuf_oneof:"type"`
}

func (x *StreamAgentMessagesRequest) Reset() {
	*x = StreamAgentMessagesRequest{}
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamAgentMessagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamAgentMessagesRequest) ProtoMessage() {}

func (x *StreamAgentMessagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamAgentMessagesRequest.ProtoReflect.Descriptor instead.
func (*StreamAgentMessagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{5}
}

func (x *StreamAgentMessagesRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (m *StreamAgentMessagesRequest) GetType() isStreamAgentMessagesRequest_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *StreamAgentMessagesRequest) GetRegisterConnection() *RegisterConnection {
	if x, ok := x.GetType().(*StreamAgentMessagesRequest_RegisterConnection); ok {
		return x.RegisterConnection
	}
	return nil
}

func (x *StreamAgentMessagesRequest) GetMessageResponse() *MessageResponse {
	if x, ok := x.GetType().(*StreamAgentMessagesRequest_MessageResponse); ok {
		return x.MessageResponse
	}
	return nil
}

func (x *StreamAgentMessagesRequest) GetMessageBody() *MessageBody {
	if x, ok := x.GetType().(*StreamAgentMessagesRequest_MessageBody); ok {
		return x.MessageBody
	}
	return nil
}

type isStreamAgentMessagesRequest_Type interface {
	isStreamAgentMessagesRequest_Type()
}

type StreamAgentMessagesRequest_RegisterConnection struct {
	// Initial stream message. Must be sent before any other messages on this
	// stream.
	RegisterConnection *RegisterConnection `protobuf:"bytes,2,opt,name=register_connection,json=registerConnection,proto3,oneof"`
}

type StreamAgentMessagesRequest_MessageResponse struct {
	// Response to a message sent from the service.
	// Should be sent as soon as the agent receives a message.
	MessageResponse *MessageResponse `protobuf:"bytes,3,opt,name=message_response,json=messageResponse,proto3,oneof"`
}

type StreamAgentMessagesRequest_MessageBody struct {
	// A message meant for a client.
	MessageBody *MessageBody `protobuf:"bytes,4,opt,name=message_body,json=messageBody,proto3,oneof"`
}

func (*StreamAgentMessagesRequest_RegisterConnection) isStreamAgentMessagesRequest_Type() {}

func (*StreamAgentMessagesRequest_MessageResponse) isStreamAgentMessagesRequest_Type() {}

func (*StreamAgentMessagesRequest_MessageBody) isStreamAgentMessagesRequest_Type() {}

// The streaming rpc message that will send messages to the agent.
type StreamAgentMessagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the message sent to the agent, this ID is used to uniquely
	// identify this message so agent can ack.
	MessageId string `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// The type of message.
	//
	// Types that are assignable to Type:
	//
	//	*StreamAgentMessagesResponse_MessageResponse
	//	*StreamAgentMessagesResponse_MessageBody
	Type isStreamAgentMessagesResponse_Type `protobuf_oneof:"type"`
}

func (x *StreamAgentMessagesResponse) Reset() {
	*x = StreamAgentMessagesResponse{}
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamAgentMessagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamAgentMessagesResponse) ProtoMessage() {}

func (x *StreamAgentMessagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamAgentMessagesResponse.ProtoReflect.Descriptor instead.
func (*StreamAgentMessagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP(), []int{6}
}

func (x *StreamAgentMessagesResponse) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (m *StreamAgentMessagesResponse) GetType() isStreamAgentMessagesResponse_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *StreamAgentMessagesResponse) GetMessageResponse() *MessageResponse {
	if x, ok := x.GetType().(*StreamAgentMessagesResponse_MessageResponse); ok {
		return x.MessageResponse
	}
	return nil
}

func (x *StreamAgentMessagesResponse) GetMessageBody() *MessageBody {
	if x, ok := x.GetType().(*StreamAgentMessagesResponse_MessageBody); ok {
		return x.MessageBody
	}
	return nil
}

type isStreamAgentMessagesResponse_Type interface {
	isStreamAgentMessagesResponse_Type()
}

type StreamAgentMessagesResponse_MessageResponse struct {
	// Response to a message sent to the service.
	// Will be sent as soon as the service receives a message.
	MessageResponse *MessageResponse `protobuf:"bytes,2,opt,name=message_response,json=messageResponse,proto3,oneof"`
}

type StreamAgentMessagesResponse_MessageBody struct {
	// A message sent from a client.
	MessageBody *MessageBody `protobuf:"bytes,3,opt,name=message_body,json=messageBody,proto3,oneof"`
}

func (*StreamAgentMessagesResponse_MessageResponse) isStreamAgentMessagesResponse_Type() {}

func (*StreamAgentMessagesResponse_MessageBody) isStreamAgentMessagesResponse_Type() {}

var File_google_cloud_agentcommunication_v1_agent_communication_proto protoreflect.FileDescriptor

var file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x75,
	0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xbc, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x6e, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64,
	0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x22,
	0x6e, 0x0a, 0x18, 0x53, 0x65, 0x6e, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0c, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f,
	0x64, 0x79, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x22,
	0x8e, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64,
	0x22, 0x42, 0x0a, 0x0f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0xd1, 0x01, 0x0a, 0x0b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x42, 0x6f, 0x64, 0x79, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x42, 0x6f, 0x64, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2d,
	0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xeb, 0x02, 0x0a, 0x1a, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x69, 0x0a, 0x13, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d,
	0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x12, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x10, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x48,
	0x00, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x42, 0x06,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xf9, 0x02, 0x0a, 0x1b, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x10, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x48, 0x00,
	0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x22, 0x7b, 0x0a,
	0x0b, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x18,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x47,
	0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x52, 0x41, 0x54, 0x45,
	0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x27, 0x0a, 0x23, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x42, 0x41, 0x4e, 0x44, 0x57,
	0x49, 0x44, 0x54, 0x48, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f,
	0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x2a, 0x89, 0x03, 0x0a, 0x0b, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x53,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x45, 0x53, 0x53,
	0x41, 0x47, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x4e, 0x4f,
	0x54, 0x5f, 0x41, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x52, 0x45, 0x53,
	0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x51, 0x55,
	0x45, 0x53, 0x54, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x53, 0x10,
	0x06, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x48, 0x45,
	0x43, 0x4b, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x10, 0x07, 0x12, 0x28, 0x0a, 0x24,
	0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x08, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f,
	0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x4f,
	0x54, 0x41, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x09, 0x12, 0x27, 0x0a,
	0x23, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x42, 0x41, 0x4e, 0x44, 0x57, 0x49, 0x44, 0x54, 0x48,
	0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x26, 0x0a, 0x22, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x5f, 0x53, 0x45, 0x4e, 0x44, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x45, 0x53,
	0x53, 0x41, 0x47, 0x45, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x0b, 0x32, 0xeb,
	0x02, 0x0a, 0x12, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9c, 0x01, 0x0a, 0x13, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x12, 0x8f, 0x01, 0x0a, 0x10, 0x53, 0x65, 0x6e, 0x64, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f,
	0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x6e, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75,
	0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x6e, 0x64,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x1a, 0x24, 0xca, 0x41, 0x21, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x8d, 0x02, 0x0a,
	0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x56, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d,
	0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x6d, 0x75,
	0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x75,
	0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescOnce sync.Once
	file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescData = file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDesc
)

func file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescGZIP() []byte {
	file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescOnce.Do(func() {
		file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescData)
	})
	return file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDescData
}

var file_google_cloud_agentcommunication_v1_agent_communication_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_agentcommunication_v1_agent_communication_proto_goTypes = []any{
	(ErrorReason)(0), // 0: google.cloud.agentcommunication.v1.ErrorReason
	(StreamAgentMessagesResponse_ErrorReason)(0), // 1: google.cloud.agentcommunication.v1.StreamAgentMessagesResponse.ErrorReason
	(*SendAgentMessageRequest)(nil),              // 2: google.cloud.agentcommunication.v1.SendAgentMessageRequest
	(*SendAgentMessageResponse)(nil),             // 3: google.cloud.agentcommunication.v1.SendAgentMessageResponse
	(*RegisterConnection)(nil),                   // 4: google.cloud.agentcommunication.v1.RegisterConnection
	(*MessageResponse)(nil),                      // 5: google.cloud.agentcommunication.v1.MessageResponse
	(*MessageBody)(nil),                          // 6: google.cloud.agentcommunication.v1.MessageBody
	(*StreamAgentMessagesRequest)(nil),           // 7: google.cloud.agentcommunication.v1.StreamAgentMessagesRequest
	(*StreamAgentMessagesResponse)(nil),          // 8: google.cloud.agentcommunication.v1.StreamAgentMessagesResponse
	nil,                                          // 9: google.cloud.agentcommunication.v1.MessageBody.LabelsEntry
	(*status.Status)(nil),                        // 10: google.rpc.Status
	(*anypb.Any)(nil),                            // 11: google.protobuf.Any
}
var file_google_cloud_agentcommunication_v1_agent_communication_proto_depIdxs = []int32{
	6,  // 0: google.cloud.agentcommunication.v1.SendAgentMessageRequest.message_body:type_name -> google.cloud.agentcommunication.v1.MessageBody
	6,  // 1: google.cloud.agentcommunication.v1.SendAgentMessageResponse.message_body:type_name -> google.cloud.agentcommunication.v1.MessageBody
	10, // 2: google.cloud.agentcommunication.v1.MessageResponse.status:type_name -> google.rpc.Status
	9,  // 3: google.cloud.agentcommunication.v1.MessageBody.labels:type_name -> google.cloud.agentcommunication.v1.MessageBody.LabelsEntry
	11, // 4: google.cloud.agentcommunication.v1.MessageBody.body:type_name -> google.protobuf.Any
	4,  // 5: google.cloud.agentcommunication.v1.StreamAgentMessagesRequest.register_connection:type_name -> google.cloud.agentcommunication.v1.RegisterConnection
	5,  // 6: google.cloud.agentcommunication.v1.StreamAgentMessagesRequest.message_response:type_name -> google.cloud.agentcommunication.v1.MessageResponse
	6,  // 7: google.cloud.agentcommunication.v1.StreamAgentMessagesRequest.message_body:type_name -> google.cloud.agentcommunication.v1.MessageBody
	5,  // 8: google.cloud.agentcommunication.v1.StreamAgentMessagesResponse.message_response:type_name -> google.cloud.agentcommunication.v1.MessageResponse
	6,  // 9: google.cloud.agentcommunication.v1.StreamAgentMessagesResponse.message_body:type_name -> google.cloud.agentcommunication.v1.MessageBody
	7,  // 10: google.cloud.agentcommunication.v1.AgentCommunication.StreamAgentMessages:input_type -> google.cloud.agentcommunication.v1.StreamAgentMessagesRequest
	2,  // 11: google.cloud.agentcommunication.v1.AgentCommunication.SendAgentMessage:input_type -> google.cloud.agentcommunication.v1.SendAgentMessageRequest
	8,  // 12: google.cloud.agentcommunication.v1.AgentCommunication.StreamAgentMessages:output_type -> google.cloud.agentcommunication.v1.StreamAgentMessagesResponse
	3,  // 13: google.cloud.agentcommunication.v1.AgentCommunication.SendAgentMessage:output_type -> google.cloud.agentcommunication.v1.SendAgentMessageResponse
	12, // [12:14] is the sub-list for method output_type
	10, // [10:12] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_agentcommunication_v1_agent_communication_proto_init() }
func file_google_cloud_agentcommunication_v1_agent_communication_proto_init() {
	if File_google_cloud_agentcommunication_v1_agent_communication_proto != nil {
		return
	}
	file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[5].OneofWrappers = []any{
		(*StreamAgentMessagesRequest_RegisterConnection)(nil),
		(*StreamAgentMessagesRequest_MessageResponse)(nil),
		(*StreamAgentMessagesRequest_MessageBody)(nil),
	}
	file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes[6].OneofWrappers = []any{
		(*StreamAgentMessagesResponse_MessageResponse)(nil),
		(*StreamAgentMessagesResponse_MessageBody)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_agentcommunication_v1_agent_communication_proto_goTypes,
		DependencyIndexes: file_google_cloud_agentcommunication_v1_agent_communication_proto_depIdxs,
		EnumInfos:         file_google_cloud_agentcommunication_v1_agent_communication_proto_enumTypes,
		MessageInfos:      file_google_cloud_agentcommunication_v1_agent_communication_proto_msgTypes,
	}.Build()
	File_google_cloud_agentcommunication_v1_agent_communication_proto = out.File
	file_google_cloud_agentcommunication_v1_agent_communication_proto_rawDesc = nil
	file_google_cloud_agentcommunication_v1_agent_communication_proto_goTypes = nil
	file_google_cloud_agentcommunication_v1_agent_communication_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AgentCommunicationClient is the client API for AgentCommunication service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentCommunicationClient interface {
	// Bi-di streaming between the server and resource on a communication channel.
	StreamAgentMessages(ctx context.Context, opts ...grpc.CallOption) (AgentCommunication_StreamAgentMessagesClient, error)
	// Send a message to a client. This is equivalent to sending a message via
	// StreamAgentMessages with a single message and waiting for the response.
	// Channel ID and Resource ID are required to be sent in the header.
	SendAgentMessage(ctx context.Context, in *SendAgentMessageRequest, opts ...grpc.CallOption) (*SendAgentMessageResponse, error)
}

type agentCommunicationClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentCommunicationClient(cc grpc.ClientConnInterface) AgentCommunicationClient {
	return &agentCommunicationClient{cc}
}

func (c *agentCommunicationClient) StreamAgentMessages(ctx context.Context, opts ...grpc.CallOption) (AgentCommunication_StreamAgentMessagesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AgentCommunication_serviceDesc.Streams[0], "/google.cloud.agentcommunication.v1.AgentCommunication/StreamAgentMessages", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentCommunicationStreamAgentMessagesClient{stream}
	return x, nil
}

type AgentCommunication_StreamAgentMessagesClient interface {
	Send(*StreamAgentMessagesRequest) error
	Recv() (*StreamAgentMessagesResponse, error)
	grpc.ClientStream
}

type agentCommunicationStreamAgentMessagesClient struct {
	grpc.ClientStream
}

func (x *agentCommunicationStreamAgentMessagesClient) Send(m *StreamAgentMessagesRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *agentCommunicationStreamAgentMessagesClient) Recv() (*StreamAgentMessagesResponse, error) {
	m := new(StreamAgentMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentCommunicationClient) SendAgentMessage(ctx context.Context, in *SendAgentMessageRequest, opts ...grpc.CallOption) (*SendAgentMessageResponse, error) {
	out := new(SendAgentMessageResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.agentcommunication.v1.AgentCommunication/SendAgentMessage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentCommunicationServer is the server API for AgentCommunication service.
type AgentCommunicationServer interface {
	// Bi-di streaming between the server and resource on a communication channel.
	StreamAgentMessages(AgentCommunication_StreamAgentMessagesServer) error
	// Send a message to a client. This is equivalent to sending a message via
	// StreamAgentMessages with a single message and waiting for the response.
	// Channel ID and Resource ID are required to be sent in the header.
	SendAgentMessage(context.Context, *SendAgentMessageRequest) (*SendAgentMessageResponse, error)
}

// UnimplementedAgentCommunicationServer can be embedded to have forward compatible implementations.
type UnimplementedAgentCommunicationServer struct {
}

func (*UnimplementedAgentCommunicationServer) StreamAgentMessages(AgentCommunication_StreamAgentMessagesServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamAgentMessages not implemented")
}
func (*UnimplementedAgentCommunicationServer) SendAgentMessage(context.Context, *SendAgentMessageRequest) (*SendAgentMessageResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SendAgentMessage not implemented")
}

func RegisterAgentCommunicationServer(s *grpc.Server, srv AgentCommunicationServer) {
	s.RegisterService(&_AgentCommunication_serviceDesc, srv)
}

func _AgentCommunication_StreamAgentMessages_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(AgentCommunicationServer).StreamAgentMessages(&agentCommunicationStreamAgentMessagesServer{stream})
}

type AgentCommunication_StreamAgentMessagesServer interface {
	Send(*StreamAgentMessagesResponse) error
	Recv() (*StreamAgentMessagesRequest, error)
	grpc.ServerStream
}

type agentCommunicationStreamAgentMessagesServer struct {
	grpc.ServerStream
}

func (x *agentCommunicationStreamAgentMessagesServer) Send(m *StreamAgentMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *agentCommunicationStreamAgentMessagesServer) Recv() (*StreamAgentMessagesRequest, error) {
	m := new(StreamAgentMessagesRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _AgentCommunication_SendAgentMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendAgentMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentCommunicationServer).SendAgentMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.agentcommunication.v1.AgentCommunication/SendAgentMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentCommunicationServer).SendAgentMessage(ctx, req.(*SendAgentMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AgentCommunication_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.agentcommunication.v1.AgentCommunication",
	HandlerType: (*AgentCommunicationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SendAgentMessage",
			Handler:    _AgentCommunication_SendAgentMessage_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamAgentMessages",
			Handler:       _AgentCommunication_StreamAgentMessages_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/agentcommunication/v1/agent_communication.proto",
}
