// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/feature_monitor_job.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Choices of the trigger type.
type FeatureMonitorJob_FeatureMonitorJobTrigger int32

const (
	// Trigger type unspecified.
	FeatureMonitorJob_FEATURE_MONITOR_JOB_TRIGGER_UNSPECIFIED FeatureMonitorJob_FeatureMonitorJobTrigger = 0
	// Triggered by periodic schedule.
	FeatureMonitorJob_FEATURE_MONITOR_JOB_TRIGGER_PERIODIC FeatureMonitorJob_FeatureMonitorJobTrigger = 1
	// Triggered on demand by CreateFeatureMonitorJob request.
	FeatureMonitorJob_FEATURE_MONITOR_JOB_TRIGGER_ON_DEMAND FeatureMonitorJob_FeatureMonitorJobTrigger = 2
)

// Enum value maps for FeatureMonitorJob_FeatureMonitorJobTrigger.
var (
	FeatureMonitorJob_FeatureMonitorJobTrigger_name = map[int32]string{
		0: "FEATURE_MONITOR_JOB_TRIGGER_UNSPECIFIED",
		1: "FEATURE_MONITOR_JOB_TRIGGER_PERIODIC",
		2: "FEATURE_MONITOR_JOB_TRIGGER_ON_DEMAND",
	}
	FeatureMonitorJob_FeatureMonitorJobTrigger_value = map[string]int32{
		"FEATURE_MONITOR_JOB_TRIGGER_UNSPECIFIED": 0,
		"FEATURE_MONITOR_JOB_TRIGGER_PERIODIC":    1,
		"FEATURE_MONITOR_JOB_TRIGGER_ON_DEMAND":   2,
	}
)

func (x FeatureMonitorJob_FeatureMonitorJobTrigger) Enum() *FeatureMonitorJob_FeatureMonitorJobTrigger {
	p := new(FeatureMonitorJob_FeatureMonitorJobTrigger)
	*p = x
	return p
}

func (x FeatureMonitorJob_FeatureMonitorJobTrigger) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FeatureMonitorJob_FeatureMonitorJobTrigger) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_enumTypes[0].Descriptor()
}

func (FeatureMonitorJob_FeatureMonitorJobTrigger) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_enumTypes[0]
}

func (x FeatureMonitorJob_FeatureMonitorJobTrigger) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FeatureMonitorJob_FeatureMonitorJobTrigger.Descriptor instead.
func (FeatureMonitorJob_FeatureMonitorJobTrigger) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescGZIP(), []int{0, 0}
}

// Vertex AI Feature Monitor Job.
type FeatureMonitorJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the FeatureMonitorJob. Format:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}/featureMonitors/{feature_monitor}/featureMonitorJobs/{feature_monitor_job}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when this FeatureMonitorJob was created. Creation of
	// a FeatureMonitorJob means that the job is pending / waiting for sufficient
	// resources but may not have started running yet.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Final status of the FeatureMonitorJob.
	FinalStatus *status.Status `protobuf:"bytes,3,opt,name=final_status,json=finalStatus,proto3" json:"final_status,omitempty"`
	// Output only. Summary from the FeatureMonitorJob.
	JobSummary *FeatureMonitorJob_JobSummary `protobuf:"bytes,4,opt,name=job_summary,json=jobSummary,proto3" json:"job_summary,omitempty"`
	// Optional. The labels with user-defined metadata to organize your
	// FeatureMonitorJob.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	// No more than 64 user labels can be associated with one
	// FeatureMonitor(System labels are excluded)." System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the FeatureMonitor.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. FeatureMonitorJob ID comparing to which the drift is
	// calculated.
	DriftBaseFeatureMonitorJobId int64 `protobuf:"varint,7,opt,name=drift_base_feature_monitor_job_id,json=driftBaseFeatureMonitorJobId,proto3" json:"drift_base_feature_monitor_job_id,omitempty"`
	// Output only. Data snapshot time comparing to which the drift is calculated.
	DriftBaseSnapshotTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=drift_base_snapshot_time,json=driftBaseSnapshotTime,proto3" json:"drift_base_snapshot_time,omitempty"`
	// Output only. Feature selection config used when creating FeatureMonitorJob.
	FeatureSelectionConfig *FeatureSelectionConfig `protobuf:"bytes,9,opt,name=feature_selection_config,json=featureSelectionConfig,proto3" json:"feature_selection_config,omitempty"`
	// Output only. Trigger type of the Feature Monitor Job.
	TriggerType FeatureMonitorJob_FeatureMonitorJobTrigger `protobuf:"varint,10,opt,name=trigger_type,json=triggerType,proto3,enum=google.cloud.aiplatform.v1beta1.FeatureMonitorJob_FeatureMonitorJobTrigger" json:"trigger_type,omitempty"`
}

func (x *FeatureMonitorJob) Reset() {
	*x = FeatureMonitorJob{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureMonitorJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureMonitorJob) ProtoMessage() {}

func (x *FeatureMonitorJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureMonitorJob.ProtoReflect.Descriptor instead.
func (*FeatureMonitorJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescGZIP(), []int{0}
}

func (x *FeatureMonitorJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FeatureMonitorJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *FeatureMonitorJob) GetFinalStatus() *status.Status {
	if x != nil {
		return x.FinalStatus
	}
	return nil
}

func (x *FeatureMonitorJob) GetJobSummary() *FeatureMonitorJob_JobSummary {
	if x != nil {
		return x.JobSummary
	}
	return nil
}

func (x *FeatureMonitorJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *FeatureMonitorJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *FeatureMonitorJob) GetDriftBaseFeatureMonitorJobId() int64 {
	if x != nil {
		return x.DriftBaseFeatureMonitorJobId
	}
	return 0
}

func (x *FeatureMonitorJob) GetDriftBaseSnapshotTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DriftBaseSnapshotTime
	}
	return nil
}

func (x *FeatureMonitorJob) GetFeatureSelectionConfig() *FeatureSelectionConfig {
	if x != nil {
		return x.FeatureSelectionConfig
	}
	return nil
}

func (x *FeatureMonitorJob) GetTriggerType() FeatureMonitorJob_FeatureMonitorJobTrigger {
	if x != nil {
		return x.TriggerType
	}
	return FeatureMonitorJob_FEATURE_MONITOR_JOB_TRIGGER_UNSPECIFIED
}

// Summary from the FeatureMonitorJob.
type FeatureMonitorJob_JobSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. BigQuery slot milliseconds consumed.
	TotalSlotMs int64 `protobuf:"varint,1,opt,name=total_slot_ms,json=totalSlotMs,proto3" json:"total_slot_ms,omitempty"`
	// Output only. Features and their stats and anomalies
	FeatureStatsAndAnomalies []*FeatureStatsAndAnomaly `protobuf:"bytes,2,rep,name=feature_stats_and_anomalies,json=featureStatsAndAnomalies,proto3" json:"feature_stats_and_anomalies,omitempty"`
}

func (x *FeatureMonitorJob_JobSummary) Reset() {
	*x = FeatureMonitorJob_JobSummary{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureMonitorJob_JobSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureMonitorJob_JobSummary) ProtoMessage() {}

func (x *FeatureMonitorJob_JobSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureMonitorJob_JobSummary.ProtoReflect.Descriptor instead.
func (*FeatureMonitorJob_JobSummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FeatureMonitorJob_JobSummary) GetTotalSlotMs() int64 {
	if x != nil {
		return x.TotalSlotMs
	}
	return 0
}

func (x *FeatureMonitorJob_JobSummary) GetFeatureStatsAndAnomalies() []*FeatureStatsAndAnomaly {
	if x != nil {
		return x.FeatureStatsAndAnomalies
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x0b, 0x0a, 0x11, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0c, 0x66, 0x69,
	0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x66, 0x69, 0x6e, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x63, 0x0a, 0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x2e,
	0x4a, 0x6f, 0x62, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x6a, 0x6f, 0x62, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x5b, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4c, 0x0a, 0x21, 0x64, 0x72, 0x69, 0x66, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x5f, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x1c, 0x64, 0x72, 0x69, 0x66, 0x74, 0x42, 0x61, 0x73, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x58, 0x0a,
	0x18, 0x64, 0x72, 0x69, 0x66, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x15, 0x64, 0x72, 0x69, 0x66, 0x74, 0x42, 0x61, 0x73, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x76, 0x0a, 0x18, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x73, 0x0a, 0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x1a, 0xb2, 0x01, 0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x12, 0x27, 0x0a, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x6c, 0x6f, 0x74, 0x4d, 0x73, 0x12, 0x7b, 0x0a, 0x1b,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x61, 0x6e,
	0x64, 0x5f, 0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x41, 0x6e, 0x64, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x18, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41, 0x6e, 0x64,
	0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x69, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x9c, 0x01, 0x0a, 0x18, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x12, 0x2b, 0x0a, 0x27, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x4d, 0x4f, 0x4e,
	0x49, 0x54, 0x4f, 0x52, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x28,
	0x0a, 0x24, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f,
	0x52, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x50, 0x45,
	0x52, 0x49, 0x4f, 0x44, 0x49, 0x43, 0x10, 0x01, 0x12, 0x29, 0x0a, 0x25, 0x46, 0x45, 0x41, 0x54,
	0x55, 0x52, 0x45, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x4a, 0x4f, 0x42, 0x5f,
	0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e,
	0x44, 0x10, 0x02, 0x3a, 0xeb, 0x01, 0xea, 0x41, 0xe7, 0x01, 0x0a, 0x2b, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x90, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x2f,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x2f,
	0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x2a, 0x12, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x32, 0x11,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f,
	0x62, 0x42, 0xed, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x16, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_goTypes = []any{
	(FeatureMonitorJob_FeatureMonitorJobTrigger)(0), // 0: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.FeatureMonitorJobTrigger
	(*FeatureMonitorJob)(nil),                       // 1: google.cloud.aiplatform.v1beta1.FeatureMonitorJob
	(*FeatureMonitorJob_JobSummary)(nil),            // 2: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.JobSummary
	nil,                                             // 3: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.LabelsEntry
	(*timestamppb.Timestamp)(nil),                   // 4: google.protobuf.Timestamp
	(*status.Status)(nil),                           // 5: google.rpc.Status
	(*FeatureSelectionConfig)(nil),                  // 6: google.cloud.aiplatform.v1beta1.FeatureSelectionConfig
	(*FeatureStatsAndAnomaly)(nil),                  // 7: google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly
}
var file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_depIdxs = []int32{
	4, // 0: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.create_time:type_name -> google.protobuf.Timestamp
	5, // 1: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.final_status:type_name -> google.rpc.Status
	2, // 2: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.job_summary:type_name -> google.cloud.aiplatform.v1beta1.FeatureMonitorJob.JobSummary
	3, // 3: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.labels:type_name -> google.cloud.aiplatform.v1beta1.FeatureMonitorJob.LabelsEntry
	4, // 4: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.drift_base_snapshot_time:type_name -> google.protobuf.Timestamp
	6, // 5: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.feature_selection_config:type_name -> google.cloud.aiplatform.v1beta1.FeatureSelectionConfig
	0, // 6: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.trigger_type:type_name -> google.cloud.aiplatform.v1beta1.FeatureMonitorJob.FeatureMonitorJobTrigger
	7, // 7: google.cloud.aiplatform.v1beta1.FeatureMonitorJob.JobSummary.feature_stats_and_anomalies:type_name -> google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_feature_monitor_job_proto_depIdxs = nil
}
