/*
 * Copyright (C) 2021 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "opencl/test/unit_test/memory_manager/memory_manager_tests_xehp_and_later.h"
#include "test.h"

using namespace NEO;

HWTEST_EXCLUDE_PRODUCT(MemoryManagerTests, givenEnabledLocalMemoryWhenAllocateInternalAllocationInDevicePoolThen32BitAllocationIsCreated, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(MemoryManagerTests, givenEnabledLocalMemoryWhenAllocateKernelIsaInDevicePoolThenLocalMemoryPoolIsUsed, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(MemoryManagerTests, givenEnabledLocalMemoryWhenAllocateInternalHeapInDevicePoolThenLocalMemoryPoolIsUsed, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(MemoryManagerTests, givenEnabledLocalMemoryWhenLinearStreamIsAllocatedInDevicePoolThenLocalMemoryPoolIsUsed, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(GetAllocationDataTestHw, givenLinearStreamTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsNotRequested, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(GetAllocationDataTestHw, givenLinearStreamWhenGetAllocationDataIsCalledThenSystemMemoryIsNotRequested, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(GetAllocationDataTestHw, givenKernelIsaTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsNotRequested, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(GetAllocationDataTestHw, givenInternalHeapTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsNotRequested, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(GetAllocationDataTestHw, givenRingBufferAllocationWhenGetAllocationDataIsCalledThenItHasProperFieldsSet, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(GetAllocationDataTestHw, givenSemaphoreBufferAllocationWhenGetAllocationDataIsCalledThenItHasProperFieldsSet, IGFX_XE_HP_SDV);
HWTEST_EXCLUDE_PRODUCT(GetAllocationDataTestHw, givenPrintfAllocationWhenGetAllocationDataIsCalledThenDontUseSystemMemoryAndRequireCpuAccess, IGFX_XE_HP_SDV);

using MemoryManagerTestsXeHP = ::testing::Test;
XEHPTEST_F(MemoryManagerTestsXeHP, givenEnabledLocalMemoryWhenLinearStreamIsAllocatedInSystemPoolThenLocalMemoryPoolIsUsed) {
    givenEnabledLocalMemoryWhenLinearStreamIsAllocatedInSystemPoolThenLocalMemoryPoolIsUsed();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenLinearStreamTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested) {
    givenLinearStreamTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenLinearStreamWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested) {
    givenLinearStreamWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenEnabledLocalMemoryWhenAllocateInternalHeapInSystemPoolThenLocalMemoryPoolIsNotUsed) {
    givenEnabledLocalMemoryWhenAllocateInternalHeapInSystemPoolThenLocalMemoryPoolIsNotUsed();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenKernelIsaTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested) {
    givenKernelIsaTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenRingBufferAllocationWhenGetAllocationDataIsCalledThenItHasProperFieldsSet) {
    givenRingBufferAllocationWhenGetAllocationDataIsCalledThenItHasProperFieldsSet();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenSemaphoreBufferAllocationWhenGetAllocationDataIsCalledThenItHasProperFieldsSet) {
    givenSemaphoreBufferAllocationWhenGetAllocationDataIsCalledThenItHasProperFieldsSet();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenConstantSurfaceTypeWhenGetAllocationDataIsCalledThenLocalMemoryIsRequestedWithoutCpuAccess) {
    givenConstantSurfaceTypeWhenGetAllocationDataIsCalledThenLocalMemoryIsRequestedWithoutCpuAccess();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenPrintfAllocationWhenGetAllocationDataIsCalledThenUseSystemMemoryAndRequireCpuAccess) {
    givenPrintfAllocationWhenGetAllocationDataIsCalledThenUseSystemMemoryAndRequireCpuAccess();
}

XEHPTEST_F(MemoryManagerTestsXeHP, givenGpuTimestampTagBufferTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested) {
    givenGpuTimestampTagBufferTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested();
}
