; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -print-schedule -mcpu=x86-64 -mattr=+lwp | FileCheck %s --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown -print-schedule -mcpu=bdver1 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER1
; RUN: llc < %s -mtriple=x86_64-unknown -print-schedule -mcpu=bdver2 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER2
; RUN: llc < %s -mtriple=x86_64-unknown -print-schedule -mcpu=bdver3 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER3
; RUN: llc < %s -mtriple=x86_64-unknown -print-schedule -mcpu=bdver4 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER4

define void @test_llwpcb(i8 *%a0) nounwind {
; GENERIC-LABEL: test_llwpcb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    llwpcb %rdi # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_llwpcb:
; BDVER:       # %bb.0:
; BDVER-NEXT:    llwpcb %rdi
; BDVER-NEXT:    retq
  tail call void @llvm.x86.llwpcb(i8 *%a0)
  ret void
}

define i8* @test_slwpcb(i8 *%a0) nounwind {
; GENERIC-LABEL: test_slwpcb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    slwpcb %rax # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_slwpcb:
; BDVER:       # %bb.0:
; BDVER-NEXT:    slwpcb %rax
; BDVER-NEXT:    retq
  %1 = tail call i8* @llvm.x86.slwpcb()
  ret i8 *%1
}

define i8 @test_lwpins32_rri(i32 %a0, i32 %a1) nounwind {
; GENERIC-LABEL: test_lwpins32_rri:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    addl %esi, %esi # sched: [1:0.33]
; GENERIC-NEXT:    lwpins $-1985229329, %esi, %edi # imm = 0x89ABCDEF
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpins32_rri:
; BDVER:       # %bb.0:
; BDVER-NEXT:    addl %esi, %esi
; BDVER-NEXT:    lwpins $-1985229329, %esi, %edi # imm = 0x89ABCDEF
; BDVER-NEXT:    setb %al
; BDVER-NEXT:    retq
  %1 = add i32 %a1, %a1
  %2 = tail call i8 @llvm.x86.lwpins32(i32 %a0, i32 %1, i32 2309737967)
  ret i8 %2
}

define i8 @test_lwpins32_rmi(i32 %a0, i32 *%p1) nounwind {
; GENERIC-LABEL: test_lwpins32_rmi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    lwpins $1985229328, (%rsi), %edi # imm = 0x76543210
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpins32_rmi:
; BDVER:       # %bb.0:
; BDVER-NEXT:    lwpins $1985229328, (%rsi), %edi # imm = 0x76543210
; BDVER-NEXT:    setb %al
; BDVER-NEXT:    retq
  %a1 = load i32, i32 *%p1
  %1 = tail call i8 @llvm.x86.lwpins32(i32 %a0, i32 %a1, i32 1985229328)
  ret i8 %1
}

define i8 @test_lwpins64_rri(i64 %a0, i32 %a1) nounwind {
; GENERIC-LABEL: test_lwpins64_rri:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    lwpins $-1985229329, %esi, %rdi # imm = 0x89ABCDEF
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpins64_rri:
; BDVER:       # %bb.0:
; BDVER-NEXT:    lwpins $-1985229329, %esi, %rdi # imm = 0x89ABCDEF
; BDVER-NEXT:    setb %al
; BDVER-NEXT:    retq
  %1 = tail call i8 @llvm.x86.lwpins64(i64 %a0, i32 %a1, i32 2309737967)
  ret i8 %1
}

define i8 @test_lwpins64_rmi(i64 %a0, i32 *%p1) nounwind {
; GENERIC-LABEL: test_lwpins64_rmi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    lwpins $1985229328, (%rsi), %rdi # imm = 0x76543210
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    setb %al # sched: [1:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpins64_rmi:
; BDVER:       # %bb.0:
; BDVER-NEXT:    lwpins $1985229328, (%rsi), %rdi # imm = 0x76543210
; BDVER-NEXT:    setb %al
; BDVER-NEXT:    retq
  %a1 = load i32, i32 *%p1
  %1 = tail call i8 @llvm.x86.lwpins64(i64 %a0, i32 %a1, i32 1985229328)
  ret i8 %1
}

define void @test_lwpval32_rri(i32 %a0, i32 %a1) nounwind {
; GENERIC-LABEL: test_lwpval32_rri:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    addl %esi, %esi # sched: [1:0.33]
; GENERIC-NEXT:    lwpval $-19088744, %esi, %edi # imm = 0xFEDCBA98
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpval32_rri:
; BDVER:       # %bb.0:
; BDVER-NEXT:    addl %esi, %esi
; BDVER-NEXT:    lwpval $-19088744, %esi, %edi # imm = 0xFEDCBA98
; BDVER-NEXT:    retq
  %1 = add i32 %a1, %a1
  tail call void @llvm.x86.lwpval32(i32 %a0, i32 %1, i32 4275878552)
  ret void
}

define void @test_lwpval32_rmi(i32 %a0, i32 *%p1) nounwind {
; GENERIC-LABEL: test_lwpval32_rmi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    lwpval $305419896, (%rsi), %edi # imm = 0x12345678
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpval32_rmi:
; BDVER:       # %bb.0:
; BDVER-NEXT:    lwpval $305419896, (%rsi), %edi # imm = 0x12345678
; BDVER-NEXT:    retq
  %a1 = load i32, i32 *%p1
  tail call void @llvm.x86.lwpval32(i32 %a0, i32 %a1, i32 305419896)
  ret void
}

define void @test_lwpval64_rri(i64 %a0, i32 %a1) nounwind {
; GENERIC-LABEL: test_lwpval64_rri:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    lwpval $-19088744, %esi, %rdi # imm = 0xFEDCBA98
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpval64_rri:
; BDVER:       # %bb.0:
; BDVER-NEXT:    lwpval $-19088744, %esi, %rdi # imm = 0xFEDCBA98
; BDVER-NEXT:    retq
  tail call void @llvm.x86.lwpval64(i64 %a0, i32 %a1, i32 4275878552)
  ret void
}

define void @test_lwpval64_rmi(i64 %a0, i32 *%p1) nounwind {
; GENERIC-LABEL: test_lwpval64_rmi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    lwpval $305419896, (%rsi), %rdi # imm = 0x12345678
; GENERIC-NEXT:    # sched: [100:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_lwpval64_rmi:
; BDVER:       # %bb.0:
; BDVER-NEXT:    lwpval $305419896, (%rsi), %rdi # imm = 0x12345678
; BDVER-NEXT:    retq
  %a1 = load i32, i32 *%p1
  tail call void @llvm.x86.lwpval64(i64 %a0, i32 %a1, i32 305419896)
  ret void
}

declare void @llvm.x86.llwpcb(i8*) nounwind
declare i8* @llvm.x86.slwpcb() nounwind
declare i8 @llvm.x86.lwpins32(i32, i32, i32) nounwind
declare i8 @llvm.x86.lwpins64(i64, i32, i32) nounwind
declare void @llvm.x86.lwpval32(i32, i32, i32) nounwind
declare void @llvm.x86.lwpval64(i64, i32, i32) nounwind
