; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  < %s -mtriple=mips-mti-linux-gnu -relocation-model=static \
; RUN:   -mips-tail-calls=1 -mcpu=mips32r2 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=MIPS32R2
; RUN: llc  < %s -mtriple=mips-img-linux-gnu -relocation-model=static \
; RUN:   -mips-tail-calls=1 -mcpu=mips32r6 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=MIPS32R6
; RUN: llc  < %s -mtriple=mips64-mti-linux-gnu -relocation-model=static \
; RUN:   -mips-tail-calls=1 -mcpu=mips64r2 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=MIPS64R2
; RUN: llc  < %s -mtriple=mips64-img-linux-gnu -relocation-model=static \
; RUN:   -mips-tail-calls=1 -mcpu=mips64r6 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=MIPS64R6

; RUN: llc  < %s -mtriple=mips-mti-linux-gnu -relocation-model=pic \
; RUN:   -mips-tail-calls=1 -mcpu=mips32r2 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=PIC-MIPS32R2
; RUN: llc  < %s -mtriple=mips-img-linux-gnu -relocation-model=pic \
; RUN:   -mips-tail-calls=1 -mcpu=mips32r6 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=PIC-MIPS32R6
; RUN: llc  < %s -mtriple=mips64-mti-linux-gnu -relocation-model=pic \
; RUN:   -mips-tail-calls=1 -mcpu=mips64r2 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=PIC-MIPS64R2
; RUN: llc  < %s -mtriple=mips64-img-linux-gnu -relocation-model=pic \
; RUN:   -mips-tail-calls=1 -mcpu=mips64r6 -mattr=+use-indirect-jump-hazard \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=PIC-MIPS64R6

define void @fooNonTail(void (i32)* nocapture %f1) nounwind {
; MIPS32R2-LABEL: fooNonTail:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    addiu $sp, $sp, -24
; MIPS32R2-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R2-NEXT:    move $25, $4
; MIPS32R2-NEXT:    jalr.hb $25
; MIPS32R2-NEXT:    addiu $4, $zero, 13
; MIPS32R2-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $sp, $sp, 24
;
; MIPS32R6-LABEL: fooNonTail:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    addiu $sp, $sp, -24
; MIPS32R6-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R6-NEXT:    move $25, $4
; MIPS32R6-NEXT:    jalr.hb $25
; MIPS32R6-NEXT:    addiu $4, $zero, 13
; MIPS32R6-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $sp, $sp, 24
;
; MIPS64R2-LABEL: fooNonTail:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    daddiu $sp, $sp, -16
; MIPS64R2-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64R2-NEXT:    move $25, $4
; MIPS64R2-NEXT:    jalr.hb $25
; MIPS64R2-NEXT:    daddiu $4, $zero, 13
; MIPS64R2-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    daddiu $sp, $sp, 16
;
; MIPS64R6-LABEL: fooNonTail:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64R6-NEXT:    move $25, $4
; MIPS64R6-NEXT:    jalr.hb $25
; MIPS64R6-NEXT:    daddiu $4, $zero, 13
; MIPS64R6-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
;
; PIC-MIPS32R2-LABEL: fooNonTail:
; PIC-MIPS32R2:       # %bb.0: # %entry
; PIC-MIPS32R2-NEXT:    addiu $sp, $sp, -24
; PIC-MIPS32R2-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; PIC-MIPS32R2-NEXT:    move $25, $4
; PIC-MIPS32R2-NEXT:    jalr.hb $25
; PIC-MIPS32R2-NEXT:    addiu $4, $zero, 13
; PIC-MIPS32R2-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; PIC-MIPS32R2-NEXT:    jr $ra
; PIC-MIPS32R2-NEXT:    addiu $sp, $sp, 24
;
; PIC-MIPS32R6-LABEL: fooNonTail:
; PIC-MIPS32R6:       # %bb.0: # %entry
; PIC-MIPS32R6-NEXT:    addiu $sp, $sp, -24
; PIC-MIPS32R6-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; PIC-MIPS32R6-NEXT:    move $25, $4
; PIC-MIPS32R6-NEXT:    jalr.hb $25
; PIC-MIPS32R6-NEXT:    addiu $4, $zero, 13
; PIC-MIPS32R6-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; PIC-MIPS32R6-NEXT:    jr $ra
; PIC-MIPS32R6-NEXT:    addiu $sp, $sp, 24
;
; PIC-MIPS64R2-LABEL: fooNonTail:
; PIC-MIPS64R2:       # %bb.0: # %entry
; PIC-MIPS64R2-NEXT:    daddiu $sp, $sp, -16
; PIC-MIPS64R2-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; PIC-MIPS64R2-NEXT:    move $25, $4
; PIC-MIPS64R2-NEXT:    jalr.hb $25
; PIC-MIPS64R2-NEXT:    daddiu $4, $zero, 13
; PIC-MIPS64R2-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; PIC-MIPS64R2-NEXT:    jr $ra
; PIC-MIPS64R2-NEXT:    daddiu $sp, $sp, 16
;
; PIC-MIPS64R6-LABEL: fooNonTail:
; PIC-MIPS64R6:       # %bb.0: # %entry
; PIC-MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; PIC-MIPS64R6-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; PIC-MIPS64R6-NEXT:    move $25, $4
; PIC-MIPS64R6-NEXT:    jalr.hb $25
; PIC-MIPS64R6-NEXT:    daddiu $4, $zero, 13
; PIC-MIPS64R6-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; PIC-MIPS64R6-NEXT:    jr $ra
; PIC-MIPS64R6-NEXT:    daddiu $sp, $sp, 16
entry:
  call void %f1(i32 13) nounwind
  ret void
}

define i32 @fooTail(i32 (i32)* nocapture %f1) nounwind {
; MIPS32R2-LABEL: fooTail:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    move $25, $4
; MIPS32R2-NEXT:    jr.hb $25
; MIPS32R2-NEXT:    addiu $4, $zero, 14
;
; MIPS32R6-LABEL: fooTail:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    move $25, $4
; MIPS32R6-NEXT:    jr.hb $25
; MIPS32R6-NEXT:    addiu $4, $zero, 14
;
; MIPS64R2-LABEL: fooTail:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    move $25, $4
; MIPS64R2-NEXT:    jr.hb $25
; MIPS64R2-NEXT:    daddiu $4, $zero, 14
;
; MIPS64R6-LABEL: fooTail:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    move $25, $4
; MIPS64R6-NEXT:    jr.hb $25
; MIPS64R6-NEXT:    daddiu $4, $zero, 14
;
; PIC-MIPS32R2-LABEL: fooTail:
; PIC-MIPS32R2:       # %bb.0: # %entry
; PIC-MIPS32R2-NEXT:    move $25, $4
; PIC-MIPS32R2-NEXT:    jr.hb $25
; PIC-MIPS32R2-NEXT:    addiu $4, $zero, 14
;
; PIC-MIPS32R6-LABEL: fooTail:
; PIC-MIPS32R6:       # %bb.0: # %entry
; PIC-MIPS32R6-NEXT:    move $25, $4
; PIC-MIPS32R6-NEXT:    jr.hb $25
; PIC-MIPS32R6-NEXT:    addiu $4, $zero, 14
;
; PIC-MIPS64R2-LABEL: fooTail:
; PIC-MIPS64R2:       # %bb.0: # %entry
; PIC-MIPS64R2-NEXT:    move $25, $4
; PIC-MIPS64R2-NEXT:    jr.hb $25
; PIC-MIPS64R2-NEXT:    daddiu $4, $zero, 14
;
; PIC-MIPS64R6-LABEL: fooTail:
; PIC-MIPS64R6:       # %bb.0: # %entry
; PIC-MIPS64R6-NEXT:    move $25, $4
; PIC-MIPS64R6-NEXT:    jr.hb $25
; PIC-MIPS64R6-NEXT:    daddiu $4, $zero, 14
entry:
   %0 = tail call i32 %f1(i32 14) nounwind
   ret i32 %0
}
