## Guide: Adding a new example

Firstly - thanks for your interest in adding a new example!

The examples folder is now backed by a Test Framework which requires certain files exist within a Directory. For the tests to run, the following files must exist:

* `main.tf` - which contains the code for the example
* `README.md` - which contains an summary of what will be provisioned
* `variables.tf` - which contains all of the variables used in this example

Other files and directories may exist in this directory, such as any sub-modules; however there must be no `provider` or `terraform` blocks specified in the example - since these will be generated by the test framework (and this will conflict).

---

### Variable Population

Terraform prompts users to insert values for variables which do not have a default value - as such the Test Framework populates certain variable values which are documented below.

The following Variables are required in (almost) all examples:

* `location` - The Location in which the Resources should be provisioned.

* `prefix` - A prefix which should be used for all resources in this example. This value will be generated as a short string.

In addition the following variables can optionally be used (and will be pre-populated) at this time:

* `alt_location` - The Alternate Location which should be used for provisioning resources.

* `kubernetes_client_id` - The Client ID of the Service Principal which can be reused by Kubernetes.

* `kubernetes_client_secret` - The Client Secret of the Service Principal which can be reused by Kubernetes.

If you require further variables which cannot have a default value, we can investigate adding these as required - please open a GitHub issue and we can discuss this further :)
