/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.Entity;
import com.sun.xml.stream.PropertyManager;
import com.sun.xml.stream.XMLEntityManager;
import com.sun.xml.stream.XMLErrorReporter;
import com.sun.xml.stream.xerces.util.URI;
import com.sun.xml.stream.xerces.util.XMLResourceIdentifierImpl;
import com.sun.xml.stream.xerces.xni.parser.XMLComponentManager;
import com.sun.xml.stream.xerces.xni.parser.XMLConfigurationException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class XMLEntityStorage {
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String WARN_ON_DUPLICATE_ENTITYDEF = "http://apache.org/xml/features/warn-on-duplicate-entitydef";
    protected boolean fWarnDuplicateEntityDef;
    protected Hashtable fEntities = new Hashtable();
    protected Entity.ScannedEntity fCurrentEntity;
    private XMLEntityManager fEntityManager;
    protected XMLErrorReporter fErrorReporter;
    protected PropertyManager fPropertyManager;
    private static String gUserDir;
    private static String gEscapedUserDir;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    static {
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = 0;
        while (n <= 31) {
            XMLEntityStorage.gNeedEscaping[n] = true;
            XMLEntityStorage.gAfterEscaping1[n] = gHexChs[n >> 4];
            XMLEntityStorage.gAfterEscaping2[n] = gHexChs[n & 0xF];
            ++n;
        }
        XMLEntityStorage.gNeedEscaping[127] = true;
        XMLEntityStorage.gAfterEscaping1[127] = 55;
        XMLEntityStorage.gAfterEscaping2[127] = 70;
        char[] cArray = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            XMLEntityStorage.gNeedEscaping[c] = true;
            XMLEntityStorage.gAfterEscaping1[c] = gHexChs[c >> 4];
            XMLEntityStorage.gAfterEscaping2[c] = gHexChs[c & 0xF];
            ++n3;
        }
    }

    public void reset() {
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    public XMLEntityStorage(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
    }

    public void reset(PropertyManager propertyManager) {
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty(ERROR_REPORTER);
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    public XMLEntityStorage(XMLEntityManager xMLEntityManager) {
        this.fEntityManager = xMLEntityManager;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fWarnDuplicateEntityDef = xMLComponentManager.getFeature(WARN_ON_DUPLICATE_ENTITYDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateEntityDef = false;
        }
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    private static synchronized String getUserDir() {
        int n;
        String string = "";
        try {
            string = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.equals(gUserDir)) {
            return gEscapedUserDir;
        }
        gUserDir = string;
        char c = File.separatorChar;
        string = string.replace(c, '/');
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 * 3);
        if (n2 >= 2 && string.charAt(1) == ':' && (n = Character.toUpperCase(string.charAt(0))) >= 65 && n <= 90) {
            stringBuffer.append('/');
        }
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            if (n >= 128) break;
            if (gNeedEscaping[n]) {
                stringBuffer.append('%');
                stringBuffer.append(gAfterEscaping1[n]);
                stringBuffer.append(gAfterEscaping2[n]);
            } else {
                stringBuffer.append((char)n);
            }
            ++n3;
        }
        if (n3 < n2) {
            byte[] byArray = null;
            try {
                byArray = string.substring(n3).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
            n2 = byArray.length;
            n3 = 0;
            while (n3 < n2) {
                byte by = byArray[n3];
                if (by < 0) {
                    n = by + 256;
                    stringBuffer.append('%');
                    stringBuffer.append(gHexChs[n >> 4]);
                    stringBuffer.append(gHexChs[n & 0xF]);
                } else if (gNeedEscaping[by]) {
                    stringBuffer.append('%');
                    stringBuffer.append(gAfterEscaping1[by]);
                    stringBuffer.append(gAfterEscaping2[by]);
                } else {
                    stringBuffer.append((char)by);
                }
                ++n3;
            }
        }
        if (!string.endsWith("/")) {
            stringBuffer.append('/');
        }
        gEscapedUserDir = stringBuffer.toString();
        return gEscapedUserDir;
    }

    public boolean isDeclaredEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        return entity != null;
    }

    public boolean isEntityDeclInExternalSubset(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isEntityDeclInExternalSubset();
    }

    public boolean isExternalEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public boolean isUnparsedEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    public static String expandSystemId(String string) {
        return XMLEntityStorage.expandSystemId(string, null);
    }

    protected static String fixURI(String string) {
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2) {
            char c = string.charAt(1);
            if (c == ':') {
                char c2 = Character.toUpperCase(string.charAt(0));
                if (c2 >= 'A' && c2 <= 'Z') {
                    string = "/" + string;
                }
            } else if (c == '/' && string.charAt(0) == '/') {
                string = "file:" + string;
            }
        }
        return string;
    }

    public void addInternalEntity(String string, String string2) {
        if (!this.fEntities.containsKey(string)) {
            this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
            Entity.InternalEntity internalEntity = new Entity.InternalEntity(string, string2, false);
            this.fEntities.put(string, internalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public static String expandSystemId(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            object = new URI(string);
            if (object != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        object = XMLEntityStorage.fixURI(string);
        URI uRI = null;
        URI uRI2 = null;
        try {
            if (string2 == null || string2.length() == 0 || string2.equals(string)) {
                String string3 = XMLEntityStorage.getUserDir();
                uRI = new URI("file", "", string3, null, null);
            } else {
                try {
                    uRI = new URI(XMLEntityStorage.fixURI(string2));
                }
                catch (URI.MalformedURIException malformedURIException) {
                    if (string2.indexOf(58) != -1) {
                        uRI = new URI("file", "", XMLEntityStorage.fixURI(string2), null, null);
                    }
                    String string4 = XMLEntityStorage.getUserDir();
                    string4 = string4 + XMLEntityStorage.fixURI(string2);
                    uRI = new URI("file", "", string4, null, null);
                }
            }
            uRI2 = new URI(uRI, (String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRI2 == null) {
            return string;
        }
        return uRI2.toString();
    }

    public void addExternalEntity(String string, String string2, String string3, String string4) {
        if (!this.fEntities.containsKey(string)) {
            if (string4 == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null) {
                string4 = this.fCurrentEntity.entityLocation.getExpandedSystemId();
            }
            this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
            Entity.ExternalEntity externalEntity = new Entity.ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, XMLEntityStorage.expandSystemId(string3, string4)), null, true);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public void addUnparsedEntity(String string, String string2, String string3, String string4, String string5) {
        this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
        if (!this.fEntities.containsKey(string)) {
            Entity.ExternalEntity externalEntity = new Entity.ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, null), string5, false);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }
}

