/**********************************************************************
 * $nodeinfo_test example -- C source code using TF/ACC PLI routines
 *
 * C source to illustrate reading 4-state logic values and strengths
 * into C integers.  The signals in Verilog to be read can be a vector 
 * of any bit size (including scalar).
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage:
 * ------
 *
 *   Syntax:   $nodeinfo_test(<vector>);
 *
 *   Example:
 *    wire (strong0,weak1) w1 = test_reg;
 *    reg  test_reg;
 *    initial $nodeinfo_test(w1);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_nodeinfoTest_checktf(),
 *              PLIbook_nodeinfoTest_calltf();
 *  /* table entries -/
 *   {usertask,                         /* type of PLI routine -/
 *     0,                               /* user_data value -/
 *     PLIbook_nodeinfoTest_checktf,    /* checktf routine -/
 *     0,                               /* sizetf routine -/
 *     PLIbook_nodeinfoTest_calltf,     /* calltf routine -/
 *     0,                               /* misctf routine -/
 *     "$nodeinfo_test",                /* system task/function name -/
 *     1                                /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_nodeinfoTest_checktf()
{
  if (tf_nump() != 1)
    tf_error("Usage error: $nodeinfo_test(<signal>);");
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_nodeinfoTest_calltf() 
{
  s_tfnodeinfo   node_info;
  int            i;
  
  /* Get the nodeinfo structure for tfarg 1 */
  io_printf("Reading Node Information\n");
  if (!tf_nodeinfo(1, &node_info)) {
    tf_error("Error getting tf_nodeinfo for tfarg 1");
    return(0);
  }
  io_printf(" node_symbol is %s\n",
            node_info.node_symbol? node_info.node_symbol: "No Symbol");
  switch (node_info.node_type) {
    case TF_NULL_NODE:
      io_printf(" node_type = TF_NULL_NODE\n"); break;
    case TF_REG_NODE:
      io_printf(" node_type = TF_REG_NODE\n"); break;
    case TF_INTEGER_NODE:
      io_printf(" node_type = TF_INTEGER_NODE\n"); break;
    case TF_TIME_NODE:
      io_printf(" node_type = TF_TIME_NODE\n"); break;
    case TF_REAL_NODE:
      io_printf(" node_type = TF_REAL_NODE\n"); break;
    case TF_NETSCALAR_NODE:
      io_printf(" node_type = TF_NETSCALAR_NODE\n"); break;
    case TF_NETVECTOR_NODE:
      io_printf(" node_type = TF_NETVECTOR_NODE\n"); break;
    case TF_MEMORY_NODE:
      io_printf(" node_type = TF_MEMORY_NODE\n"); break;
    default:
      io_printf(" node_type = unknown (%d)\n\n", node_info.node_type);
  }
  io_printf(" node_ngroups = %d\n",     node_info.node_ngroups);
  io_printf(" node_vec_size = %d\n",    node_info.node_vec_size);
  io_printf(" node_sign = %d\n",        node_info.node_sign);
  io_printf(" node_ms_index = %d\n",    node_info.node_ms_index);
  io_printf(" node_ls_index = %d\n",    node_info.node_ls_index);
  io_printf(" node_mem_size = %d\n",    node_info.node_mem_size);
  io_printf(" node_lhs_element = %d\n", node_info.node_lhs_element);
  io_printf(" node_rhs_element = %d\n", node_info.node_rhs_element);
  
  switch (node_info.node_type) {
    case TF_REG_NODE:
      io_printf(" reg value (in hex):\n");
      for (i=0; i<node_info.node_ngroups; i++) {
        io_printf("   avalbits[%d] = %x\n",
                  i, node_info.node_value.vecval_p[i].avalbits);
        io_printf("   bvalbits[%d] = %x\n",
                  i, node_info.node_value.vecval_p[i].bvalbits);
      }
      break;
    case TF_INTEGER_NODE:
      io_printf(" integer value (in hex):\n");
      io_printf("   avalbits[0] = %x\n",
                node_info.node_value.vecval_p[0].avalbits);
      io_printf("   bvalbits[0] = %x\n",
                node_info.node_value.vecval_p[0].bvalbits);
      break;
    case TF_TIME_NODE:
      io_printf(" time value (in hex):\n");
      io_printf("   {avalbits[1],avalbits[0]} = %x%x\n",
                node_info.node_value.vecval_p[1].avalbits,
                node_info.node_value.vecval_p[0].avalbits);
      io_printf("   {bvalbits[1],bvalbits[0]} = %x%x\n",
                node_info.node_value.vecval_p[1].bvalbits,
                node_info.node_value.vecval_p[0].bvalbits);
      break;
    case TF_REAL_NODE:
      io_printf(" real value = %f\n",
                *node_info.node_value.real_val_p);
      break;
    case TF_NETSCALAR_NODE:
      io_printf(" scalar net value with strength (in hex):\n");
      io_printf("   strength0 = %x\n",
                node_info.node_value.strengthval_p->strength0);
      io_printf("   strength1 = %x\n",
                node_info.node_value.strengthval_p->strength1);
      break;
    case TF_NETVECTOR_NODE:
      for (i=0; i<node_info.node_ngroups; i++) {
        io_printf("   avalbits[%d] = %x\n",
                  i, node_info.node_value.vecval_p[i].avalbits);
        io_printf("   bvalbits[%d] = %x\n",
                  i, node_info.node_value.vecval_p[i].bvalbits);
      }
      break;
    case TF_MEMORY_NODE:
      io_printf(" memory arrays are not supported in this example\n");
      break;
  }
  io_printf("\n");
  return(0);
}
/*********************************************************************/
