# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AccessRights(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The permissions assigned to the shared access policy.
    """

    REGISTRY_READ = "RegistryRead"
    REGISTRY_WRITE = "RegistryWrite"
    SERVICE_CONNECT = "ServiceConnect"
    DEVICE_CONNECT = "DeviceConnect"
    REGISTRY_READ_REGISTRY_WRITE = "RegistryRead, RegistryWrite"
    REGISTRY_READ_SERVICE_CONNECT = "RegistryRead, ServiceConnect"
    REGISTRY_READ_DEVICE_CONNECT = "RegistryRead, DeviceConnect"
    REGISTRY_WRITE_SERVICE_CONNECT = "RegistryWrite, ServiceConnect"
    REGISTRY_WRITE_DEVICE_CONNECT = "RegistryWrite, DeviceConnect"
    SERVICE_CONNECT_DEVICE_CONNECT = "ServiceConnect, DeviceConnect"
    REGISTRY_READ_REGISTRY_WRITE_SERVICE_CONNECT = "RegistryRead, RegistryWrite, ServiceConnect"
    REGISTRY_READ_REGISTRY_WRITE_DEVICE_CONNECT = "RegistryRead, RegistryWrite, DeviceConnect"
    REGISTRY_READ_SERVICE_CONNECT_DEVICE_CONNECT = "RegistryRead, ServiceConnect, DeviceConnect"
    REGISTRY_WRITE_SERVICE_CONNECT_DEVICE_CONNECT = "RegistryWrite, ServiceConnect, DeviceConnect"
    REGISTRY_READ_REGISTRY_WRITE_SERVICE_CONNECT_DEVICE_CONNECT = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect"

class Capabilities(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The capabilities and features enabled for the IoT hub.
    """

    NONE = "None"
    DEVICE_MANAGEMENT = "DeviceManagement"

class EndpointHealthStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The health status code of the endpoint
    """

    UNKNOWN = "unknown"
    HEALTHY = "healthy"
    UNHEALTHY = "unhealthy"
    DEAD = "dead"

class IotHubNameUnavailabilityReason(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The reason for unavailability.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class IotHubScaleType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the scaling enabled.
    """

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
    NONE = "None"

class IotHubSku(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the SKU.
    """

    F1 = "F1"
    S1 = "S1"
    S2 = "S2"
    S3 = "S3"
    B1 = "B1"
    B2 = "B2"
    B3 = "B3"

class IotHubSkuTier(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The billing tier for the IoT hub.
    """

    FREE = "Free"
    STANDARD = "Standard"
    BASIC = "Basic"

class IpFilterActionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The desired action for requests captured by this rule.
    """

    ACCEPT = "Accept"
    REJECT = "Reject"

class JobStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the job.
    """

    UNKNOWN = "unknown"
    ENQUEUED = "enqueued"
    RUNNING = "running"
    COMPLETED = "completed"
    FAILED = "failed"
    CANCELLED = "cancelled"

class JobType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the job.
    """

    UNKNOWN = "unknown"
    EXPORT = "export"
    IMPORT_ENUM = "import"
    BACKUP = "backup"
    READ_DEVICE_PROPERTIES = "readDeviceProperties"
    WRITE_DEVICE_PROPERTIES = "writeDeviceProperties"
    UPDATE_DEVICE_CONFIGURATION = "updateDeviceConfiguration"
    REBOOT_DEVICE = "rebootDevice"
    FACTORY_RESET_DEVICE = "factoryResetDevice"
    FIRMWARE_UPDATE = "firmwareUpdate"

class OperationMonitoringLevel(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The operations monitoring level.
    """

    NONE = "None"
    ERROR = "Error"
    INFORMATION = "Information"
    ERROR_INFORMATION = "Error, Information"

class RouteErrorSeverity(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Severity of the route error
    """

    ERROR = "error"
    WARNING = "warning"

class RoutingSource(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The source that the routing rule is to be applied to, such as DeviceMessages.
    """

    INVALID = "Invalid"
    DEVICE_MESSAGES = "DeviceMessages"
    TWIN_CHANGE_EVENTS = "TwinChangeEvents"
    DEVICE_LIFECYCLE_EVENTS = "DeviceLifecycleEvents"
    DEVICE_JOB_LIFECYCLE_EVENTS = "DeviceJobLifecycleEvents"

class TestResultStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Result of testing route
    """

    UNDEFINED = "undefined"
    FALSE = "false"
    TRUE = "true"
