/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.xpm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class XPMEncoder
extends JimiEncoderBase {
    protected static final String MAGIC = "/* XPM */\n";
    protected static final String HEADER_STRING = "static char* image[]={\n";
    protected static char[] paletteStringCharacters;
    protected PrintStream output;
    protected AdaptiveRasterImage jimiImage;
    protected int state;
    protected int paletteSize;
    protected String[] paletteStrings;
    protected int entrySize;

    public XPMEncoder() {
        if (paletteStringCharacters == null) {
            this.generatePaletteStringCharacters();
        }
    }

    protected void createPaletteStrings(IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        this.entrySize = 0;
        int n2 = n;
        do {
            ++this.entrySize;
        } while ((n2 /= paletteStringCharacters.length) != 0);
        this.paletteStrings = new String[n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3;
            String string = "";
            int n5 = 0;
            while (n5 < this.entrySize) {
                string = String.valueOf(String.valueOf(paletteStringCharacters[n4 % paletteStringCharacters.length])) + string;
                n4 /= paletteStringCharacters.length;
                ++n5;
            }
            this.paletteStrings[n3] = string;
            ++n3;
        }
    }

    protected void doImageEncode() throws JimiException, IOException {
        if (!(this.jimiImage.getColorModel() instanceof IndexColorModel)) {
            throw new JimiException("XPM only encodes palette-based images.");
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.jimiImage.getColorModel();
        this.createPaletteStrings(indexColorModel);
        this.writeHeader();
        this.writePalette(indexColorModel);
        this.writeImageData();
        this.writeTrailer();
    }

    public boolean driveEncoder() throws JimiException {
        try {
            this.jimiImage = this.getJimiImage();
            this.doImageEncode();
        }
        catch (Exception exception) {
            this.state = 1;
            exception.printStackTrace();
            throw new JimiException(exception.toString());
        }
        this.state = 2;
        return false;
    }

    protected void generatePaletteStringCharacters() {
        int n = 62;
        paletteStringCharacters = new char[n];
        int n2 = 0;
        int n3 = 48;
        while (n3 <= 57) {
            XPMEncoder.paletteStringCharacters[n2++] = n3;
            n3 = (char)(n3 + 1);
        }
        n3 = 97;
        while (n3 <= 122) {
            XPMEncoder.paletteStringCharacters[n2++] = n3;
            n3 = (char)(n3 + 1);
        }
        n3 = 65;
        while (n3 <= 90) {
            XPMEncoder.paletteStringCharacters[n2++] = n3;
            n3 = (char)(n3 + 1);
        }
    }

    public int getState() {
        return this.state;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.output = new PrintStream(outputStream);
    }

    protected String toPaddedHexString(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return string;
    }

    protected void writeHeader() throws IOException {
        this.output.print(MAGIC);
        this.output.print(HEADER_STRING);
        int n = this.jimiImage.getWidth();
        int n2 = this.jimiImage.getHeight();
        this.output.println("\"" + n + " " + n2 + " " + this.paletteStrings.length + " " + this.entrySize + "\",");
    }

    protected void writeImageData() throws IOException, JimiException {
        int[] nArray = new int[this.jimiImage.getWidth()];
        int n = this.jimiImage.getHeight();
        int n2 = 0;
        while (n2 < n) {
            this.jimiImage.getChannel(n2, nArray, 0);
            this.output.print("\"");
            int n3 = 0;
            while (n3 < nArray.length) {
                this.output.print(this.paletteStrings[nArray[n3]]);
                ++n3;
            }
            if (n2 < n - 1) {
                this.output.println("\",");
            }
            ++n2;
        }
    }

    protected void writePalette(IndexColorModel indexColorModel) throws IOException {
        int n = 0;
        while (n < this.paletteStrings.length) {
            this.output.println("\"" + this.paletteStrings[n] + " c #" + this.toPaddedHexString(indexColorModel.getRGB(n) & 0xFFFFFF) + "\",");
            ++n;
        }
    }

    protected void writeTrailer() throws IOException {
        this.output.println("\"};");
    }
}

