/*
 *	syntax object
 *
 *	Copyright (C) 2010 Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Olaf Kirch <okir@suse.de>
 *	         Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif
#include <stdlib.h>
#include <string.h>

#include <sutils.h>
#include <logging.h>
#include <syntax.h>


extern nc_syntax_t *		nc__syntax_xml_netcf(const char *pathname);

nc_syntax_t *
nc_syntax_new(const char *schema, const char *base_path)
{
	if(!schema) {
		nc_error("Unable to determine default schema");
		return NULL;
	}

	if(!strcasecmp(schema, "netcf"))
		return nc__syntax_xml_netcf(base_path);

	nc_error("schema \"%s\" not supported", schema);
	return NULL;
}

void
nc_syntax_set_root_directory(nc_syntax_t *syntax, const char *root_dir)
{
	if(syntax)
		nc_string_dup(&syntax->root_dir, root_dir);
}

void
nc_syntax_free(nc_syntax_t *syntax)
{
	if(syntax) {
		free(syntax->base_path);
		free(syntax->root_dir);
		free(syntax);
	}
}

int
nc_syntax_supported_inteface(nc_syntax_t *syntax, nc_handle_t *handle,
				const nc_interface_t *ifp)
{
	if (!syntax || !syntax->supported_inteface) {
		nc_error("syntax does not support this function");
		return -1;
	}
	return syntax->supported_inteface(syntax, handle, ifp);
}

xml_node_t *
nc_syntax_xml_from_interface(nc_syntax_t *syntax, nc_handle_t *handle,
				nc_interface_t *ifp)
{
	if (!syntax || !syntax->xml_from_interface) {
		nc_error("syntax not capable of creating xml for interface");
		return NULL;
	}
	return syntax->xml_from_interface(syntax, handle, ifp, NULL);
}

nc_interface_t *
nc_syntax_xml_to_interface(nc_syntax_t *syntax, nc_handle_t *handle,
				const xml_node_t *ifnode)
{
	if (!syntax || !syntax->xml_from_interface) {
		nc_error("syntax not capable of creating interface from xml");
		return NULL;
	}
	return syntax->xml_to_interface(syntax, handle, ifnode);
}

