/*
 *	Routines for bonding interface handling
 *
 *	Copyright (C) 2009, 2010  Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Olaf Kirch <okir@suse.de>
 *	         Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_BONDING_H
#define __NETCONTROL_BONDING_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sutils.h>
#include <ntypes.h>
#include <handle.h>

enum {
	NC_BOND_MONITOR_ARP,
	NC_BOND_MONITOR_MII,
};

enum {
	NC_BOND_MODE_BALANCE_RR = 0,
	NC_BOND_MODE_ACTIVE_BACKUP = 1,
	NC_BOND_MODE_BALANCE_XOR = 2,
	NC_BOND_MODE_BROADCAST = 3,
	NC_BOND_MODE_802_3AD = 4,
	NC_BOND_MODE_BALANCE_TLB = 5,
	NC_BOND_MODE_BALANCE_ALB = 6,
};
enum {
	NC_BOND_VALIDATE_NONE = 0,
	NC_BOND_VALIDATE_ACTIVE = 1,
	NC_BOND_VALIDATE_BACKUP = 2,
	NC_BOND_VALIDATE_ALL = 3,
};
enum {
	NC_BOND_CARRIER_DETECT_IOCTL = 0,
	NC_BOND_CARRIER_DETECT_NETIF = 1,
};
#if 0
enum {
	NC_BOND_FAILOVER_MAC_NONE = 0,
	NC_BOND_FAILOVER_MAC_ACTIVE = 1,
	NC_BOND_FAILOVER_MAC_FOLLOW = 2,
};
enum {
	NC_BOND_AD_SELECT_STABLE = 0,
	NC_BOND_AD_SELECT_BANDWIDTH = 1,
	NC_BOND_AD_SELECT_COUNT = 2,
};
enum {
	NC_BOND_PRIMARY_RESELECT_ALWAYS = 0,
	NC_BOND_PRIMARY_RESELECT_BETTER = 1,
	NC_BOND_PRIMARY_RESELECT_FAILURE = 2,
};
#endif
enum {
	NC_BOND_LACP_RATE_SLOW = 0,
	NC_BOND_LACP_RATE_FAST = 1,
};
enum {
	NC_BOND_XMIT_HASH_POLICY_LAYER2  = 0,
	NC_BOND_XMIT_HASH_POLICY_LAYER23 = 1,
	NC_BOND_XMIT_HASH_POLICY_LAYER34 = 2,
};

struct nc_bonding {
	/* This is where we store the module options taken from
	 * the sysconfig files.
	 */
	char *			module_opts;

	unsigned int		mode;

	int			monitoring;
	struct nc_bonding_arpmon {
		unsigned int	interval;	/* ms */
		unsigned int	validate;
		nc_string_array_t targets;
	}			arpmon;
	struct nc_bonding_miimon {
		unsigned int	frequency;
		unsigned int	updelay;
		unsigned int	downdelay;
		unsigned int	carrier_detect;
	}			miimon;

#if 0
	unsigned int		num_grat_arp;
	unsigned int		num_unsol_na;
	unsigned int		resend_igmp;

#endif
	unsigned int		lacp_rate;		/* 802.3ad */
	unsigned int		xmit_hash_policy;	/* 802.3ad, balance-xor */

	char *			primary_slave;
#if 0
	unsigned int		primary_reselect;
#endif

	unsigned int		slave_type;
	nc_string_array_t	slave_names;
	nc_var_array_t		extra_options;
};

extern int		nc_bonding_bind(nc_interface_t *, nc_handle_t *, nc_var_array_t *);

nc_bonding_t *		nc_bonding_new(void);
extern void		nc_bonding_free(nc_bonding_t *);
extern nc_bonding_t *	nc_bonding_clone(const nc_bonding_t *);
extern int		nc_bonding_add_slave(nc_bonding_t *, const char *);
extern void		nc_bonding_parse_module_options(nc_bonding_t *,
						nc_handle_t *, const char *);
extern void		nc_bonding_build_module_options(nc_bonding_t *);
extern int		nc_bonding_parse_sysfs_attrs(const char *, nc_bonding_t *);
extern int		nc_bonding_write_sysfs_attrs(const char *ifname,
						const nc_bonding_t *cfg_bond,
						const nc_bonding_t *cur_bond,
						int state);
extern int		nc_sysfs_bonding_get_attr(const char *master, const char *attr, char **result);
extern int		nc_sysfs_bonding_get_slaves(const char *master, nc_string_array_t *list);
extern int		nc_sysfs_bonding_get_arp_targets(const char *master, nc_string_array_t *list);
extern int		nc_sysfs_get_bonding_parent(const char *name, char **parent);

#endif /* __NETCONTROL_BONDING_H */
